/*
 * ZTE tsc driver
 *
 * Copyright (C) 2013 ZTE Ltd.
 * 	by tsp
 *
 */

#include <linux/module.h>
#include <linux/kernel.h>
#include <linux/init.h>
#include <linux/semaphore.h>
#include <linux/spinlock.h>
#include <linux/interrupt.h>
#include <linux/types.h>
#include <linux/sched.h>
#include <linux/io.h>
#include <linux/timer.h>
#include <linux/kthread.h>	/*For kthread_run()*/
#include <linux/delay.h>
#include <mach/iomap.h>
#include "zx-tsc.h"
#include <linux/soc/zte/tsc/tsc.h>
#include <linux/cpps_init2.h>
#include <linux/cp_types.h>
#include "NvParam_drv.h"
#include "pub_debug_info.h"
#include <linux/miscdevice.h>	/* For handling misc devices */
#include <linux/fs.h>		/* For file operations */
#include <linux/uaccess.h>
#include <linux/syscalls.h>/*For sys_open operation*/


#ifdef RFC_DCXO_EN //jingti
#define IRAM_TEMPCOMP_DAC (IRAM_BASE_ADDR_SLAVE_AFC+0x8)  //high16bit: the ADC value of temp	
#else
#define IRAM_TEMPCOMP_DAC (IRAM_BASE_ADDR_PUB_RF+0x40)//the ADC value of temp
#endif
#define IRAM_TEMPCOMP_RFDDAC (IRAM_BASE_ADDR_SLAVE_AFC+0x8)  //high16bit: the ADC value of temp	
#define IRAM_TEMPCOMP_RFDTEMP (IRAM_BASE_ADDR_SLAVE_AFC+0xc)  //temp of adcrfd

#define RFDDAC_LOW	1
#define RFDDAC_LOWE	1591
#define RFDDAC_HIGHE 6096
#define RFDDAC_HIGH	8191

volatile u32 g_adc1_flag = 0;//?adc1??2apa2?????g_adc1_flag=1
volatile u32 g_adc2_flag = 0;//?adc2??2apa2?????g_adc2_flag=1
volatile u32 g_adc3_flag = 0; // 1:adcrf work

struct timer_list timer_tsc;

u32 g_test_addr0=0;
u32 g_test_addr1=0;
u32 g_test_addr2=IRAM_TEMPCOMP_DAC;
u32 g_test_addr3=IRAM_TEMPCOMP_RFDTEMP;

s32 g_tsc_print_log_debug=0;

/*
1cnt is 20s
1h=3600s: 180cnt
*/
unsigned int tsc_record_time_cnt=0; 	
unsigned int tsc_record_time= 3600; 
module_param(tsc_record_time, uint, 0644);
unsigned int tsc_record_flag= 0; 
module_param(tsc_record_flag, uint, 0644);

int g_ts_data_info[PROBE_NUM][PROBE_INFO] = {0};

static struct mutex tsc_mutexId;
struct semaphore s_tsc_adc_semaphore;

T_SYS_NV_TSC_CONFIG TsNvData = {0};
int  tsc_tempValue[PROBE_MAX]={0};

struct kobject *zx_tsc_kobj;

extern int ts_temp_value_table[TS_ADC_TEMP_NUMBER][TS_ADC_TEMP_VOLTAGE_NUMBER];
extern volatile u32 ts_adc_flag;
extern T_TscP_Strategy g_ps_Strategy[STRATEGY_PS_NUM];
extern T_TscP_Strategy g_phy_Strategy[STRATEGY_PHY_NUM];

int  ts_temp_value_tableRfd[TS_ADC_TEMP_NUMBER][TS_ADC_TEMP_VOLTAGE_NUMBER]={
{
 -45,-44,-43,-42,-41,		
 -40,-39,-38,-37,-36, -35,-34,-33,-32,-31,		
 -30,-29,-28,-27,-26, -25,-24,-23,-22,-21,		
 -20,-19,-18,-17,-16, -15,-14,-13,-12,-11,		
 -10,-9,-8,-7,-6, -5,-4,-3,-2,-1,	
 0,1,2,3,4,5,6,7,8,9,
 10,11,12,13,14,15,16,17,18,19,
 20,21,22,23,24,25,26,27,28,29,	
 30,31,32,33,34,35,36,37,38,39,
 40,41,42,43,44,45,46,47,48,49,
 50,51,52,53,54,55,56,57,58,59,
 60,61,62,63,64,65,66,67,68,69,
 70,71,72,73,74,75,76,77,78,79,
 80,81,82,83,84,85,86,87,88,89,
 90,91,92,93,94,95,96,97,98,99,
 100,101,102,103,104,105,106,107,108,109,
 110,111,112,113,114,115,116,117,118,119,
 120,121,122,123,124,125},

{
7598,7592,7586,7579,7572,
7564,7556,7547,7537,7527,7516,7505,7493,7480,7466,
7451,7436,7420,7402,7384,7365,7344,7323,7300,7277,
7252,7225,7198,7169,7139,7107,7074,7040,7004,6967,
6928,6888,6846,6803,6758,6712,6664,6615,6564,6512,
6458,6403,6347,6290,6231,6171,6110,6048,5984,5920,
5855,5790,5723,5656,5588,5520,5452,5383,5314,5245,
5176,5107,5038,4969,4901,4833,4765,4698,4632,4566,
4501,4438,4376,4313,4251,4188,4131,4073,4016,3958,
3901,3849,3797,3745,3693,3641,3595,3549,3502,3456,
3410,3370,3330,3289,3249,3209,3174,3139,3104,3069,
3034,3004,2974,2943,2913,2883,2857,2832,2806,2781,
2755,2733,2711,2690,2668,2646,2627,2609,2590,2572,
2553,2537,2521,2506,2490,2474,2461,2447,2434,2420,
2407,2396,2385,2373,2362,2351,2341,2332,2322,2313,
2303,2295,2287,2278,2270,2262,2255,2248,2241,2234,
2227,2221,2215,2210,2204,2198,2193,2188,2183,2178,
2173,2169,2164,2160,2155,2151 }
};

#define zte_tsc_attr(_name) \
static struct kobj_attribute _name##_attr = 	\
{                           \
	.attr	= 				\
	{                       \
		.name = __stringify(_name),	\
		.mode = 0644,			\
	},					\
	.show	= _name##_show,			\
	.store	= _name##_store,		\
}

/*the power on info */
typedef enum
{
	POWER_ON_NORMAL = 0,
	POWER_ON_FOTA,
	POWER_ON_CHARGING,
	POWER_ON_RTC,
	POWER_ON_RESET,
	POWER_ON_HDT_TEST,
	POWER_ON_EXCEPTRESET,
	POWER_ON_LOCALUPDATE,
	POWER_ON_BOOST_IN,
	POWER_ON_AMT,
	POWER_ON_PRODUCTION,
	POWER_ON_INVALID,
}T_ZDrvSys_PowerOn_Type;

//extern int nand_NvRead(int dwStart, int dwLen, char* to);
extern uint get_adc1_voltage(void);
extern uint get_adc2_voltage(void);
#ifndef USE_CPPS_KO
extern UINT32 zOss_NvItemRead(UINT32 NvItemID, UINT8 * NvItemData, UINT32 NvItemLen);
#endif
//static int tsc_adcRf_read(void);

void tsc_get_tempPercent(unsigned int *percent)
{
	*percent = zx_read_reg(TSCTRL_TEMP_PERCENT);
}


 static ssize_t tsc_percent_show(struct kobject *kobj, struct kobj_attribute *attr,
			   char *buf)
 {

	 unsigned int tsc_per = 0;
	 char *s = buf;

	tsc_get_tempPercent(&tsc_per);
	sprintf(s, "%d\n", tsc_per);

	return sizeof(unsigned int);
 }
 
 static ssize_t tsc_percent_store(struct kobject *kobj, struct kobj_attribute *attr,
				const char *buf, size_t n)
 {
	 int error = 0;
 	
	 return error ;
 }
 zte_tsc_attr(tsc_percent);


 signed int tsc_set_detect_en(unsigned char val)
{
	zx_write_reg(TSCTRL_DETECT_EN,val);
	return 0;
}
signed int tsc_get_detect_en(void)
{
	return zx_read_reg(TSCTRL_DETECT_EN);
}
  static ssize_t tsc_ptscCtrlEn_show(struct kobject *kobj, struct kobj_attribute *attr,
				char *buf)
  {
 
	  signed int tsc_CtrlEn = 0;
	  char *s = buf;
 
	  tsc_CtrlEn = tsc_get_detect_en();

	 sprintf(s, "%d\n", tsc_CtrlEn);
 
	 return sizeof(unsigned int);
  }

  static ssize_t tsc_ptscCtrlEn_store(struct kobject *kobj, struct kobj_attribute *attr,
				 const char *buf, size_t n)
  {

	  int error = 0;
	  signed int tsc_CtrlEn=0;  
	  if(strict_strtol(buf, 0, &tsc_CtrlEn))//char to num ʮ
	  {
	 	 error = -EINVAL;
	  }
	  tsc_set_detect_en(tsc_CtrlEn);
	  
	  return error ? error : n;
  }
  
  zte_tsc_attr(tsc_ptscCtrlEn);

 static  int *tsc_get_probe_temperature(void)
 {
	 unsigned int i;
 
	 for(i=0;i<PROBE_MAX; i++)
		 tsc_tempValue[i]= zx_read_reg(TSCTRL_TEMPADC1 + 0x4 * i);
 
	//tsc_tempValue[PROBE_ADCRF]= tsc_adcRf_read();  //test
	return tsc_tempValue;
 }

 static ssize_t tsc_value_show(struct kobject *kobj, struct kobj_attribute *attr,
			   char *buf)
 {
	 char *s = buf;
	 int *tsc_val = 0;
	 unsigned int i;
	 
	 tsc_val = tsc_get_probe_temperature();

	memcpy((unsigned char *)buf, (unsigned char *)tsc_val, PROBE_MAX*sizeof(int));
	for(i=0; i<PROBE_MAX;i++){
		sprintf(s, "%d\n ", tsc_val[i]);
		s+=4;
	}
	return PROBE_MAX*sizeof(int);
 }
 
 static ssize_t tsc_value_store(struct kobject *kobj, struct kobj_attribute *attr,
				const char *buf, size_t n)
 {
	 int error = 0;
 
	 return error;
 }
 
 zte_tsc_attr(tsc_value);

  static ssize_t tsc_strategy_status_show(struct kobject *kobj, struct kobj_attribute *attr,
			   char *buf)
 {
	 char *s = buf;
	 unsigned int i;
	 int ret, size = 0;
	 
	for(i=0; i<STRATEGY_PS_NUM;i++){
		ret = sprintf(s, "%s", g_ps_Strategy[i].name);
		size += ret;
		s += ret;
		ret = sprintf(s, "%d\n", g_ps_Strategy[i].flag);
		size += ret;
		s += ret;
	}
	for(i=0; i<STRATEGY_PHY_NUM;i++){
		ret = sprintf(s, "%s", g_phy_Strategy[i].name);
		size += ret;
		s += ret;
		ret = sprintf(s, "%d\n", g_phy_Strategy[i].flag);
		size += ret;
		s += ret;
	}	
	return size;
}
 
 static ssize_t tsc_strategy_status_store(struct kobject *kobj, struct kobj_attribute *attr,
				const char *buf, size_t n)
 {
	 int error = 0;
	 return error;
 }
 
 zte_tsc_attr(tsc_strategy_status);
 
 

  static ssize_t tsc_print_log_show(struct kobject *kobj, struct kobj_attribute *attr,
				char *buf)
  {
 
	 char *s = buf;

	 sprintf(s, "%d\n", g_tsc_print_log_debug);
 
	 return sizeof(unsigned int);
  }
  

  static ssize_t tsc_print_log_store(struct kobject *kobj, struct kobj_attribute *attr,
				 const char *buf, size_t n)
  {

	  int error = 0;
	  if(strict_strtol(buf, 0, &g_tsc_print_log_debug))//char to num ʮ
	  {
	  	error = -EINVAL;
	  }

	  return error ? error : n;
  }
  
 zte_tsc_attr(tsc_print_log);


 static struct attribute * g[] = 
 {
	 &tsc_value_attr.attr,
	 &tsc_percent_attr.attr,
	 &tsc_ptscCtrlEn_attr.attr,
	 &tsc_print_log_attr.attr,
	 &tsc_strategy_status_attr.attr,
	 
	 NULL,
 };
 
 static struct attribute_group zx_tsc_attr_group = 
 {
	 .attrs = g,
 };

 /********************************************************************************
 * Function:
 * Description: 
 * Parameters: 
 * Returns: 
 * Others:
 ********************************************************************************/

 static int zx_tsc_open(struct inode *inode, struct file *file)
{
	return 0; 
}

static int zx_tsc_close(struct inode *inode, struct file *file)
{
	return 0;
}
static long zx_tsc_ioctl(struct file *file, unsigned int cmd, unsigned long arg)
{
	int ret=0;
	u8 thresh[THRESHOLD_NUM+1]={0};
	
	switch(cmd)
	{
		case ZX_TSC_SET_THRESHOLD:
			ret= copy_from_user(thresh, (u8*)arg, sizeof(thresh));
			if(ret)
				printk("zx_tsc_ioctl copy_from_user ret=%d\n", ret);
			
			if(thresh[0] >= PROBE_MAX){
				printk("set error probe num\n");
				return -1;
			}
			memcpy((unsigned char *)(&TsNvData.Threshods[thresh[0]]), thresh+1, THRESHOLD_NUM*sizeof(u8));
			memcpy((void*)TSCTRL_IRAM_NV, &TsNvData, sizeof(TsNvData));	
			break;
			
		case ZX_TSC_GET_THRESHOLD:
			ret= copy_from_user(thresh, (u8*)arg, sizeof(thresh));
			if(ret)
				printk("zx_tsc_ioctl copy_from_user ret1=%d\n", ret);
			
			if(thresh[0] >= PROBE_MAX){
				printk("get error probe num\n");
				return -1;
			}
						
			ret= copy_to_user((u8*)arg+1, (unsigned char *)(&TsNvData.Threshods[thresh[0]]), THRESHOLD_NUM*sizeof(u8));
			if(ret)
				printk("zx_tsc_ioctl copy_to_user ret=%d\n", ret);			
			break;
			
		case ZX_TSC_SET_DECTET_EN:
			ret= copy_from_user(&TsNvData.DetectEn, (u8*)arg, sizeof(u8));
			if(ret)
				printk("zx_tsc_ioctl copy_from_user ret=%d\n", ret);
			
			memcpy((void*)TSCTRL_IRAM_NV, &TsNvData, sizeof(TsNvData));
			tsc_set_detect_en(TsNvData.DetectEn);
			break;
			
		case ZX_TSC_GET_DECTET_EN:			
			ret= copy_to_user((u8*)arg, (unsigned char *)&TsNvData.DetectEn, sizeof(u8));
			if(ret)
				printk("zx_tsc_ioctl copy_to_user ret=%d\n", ret);			
			break;
			
		default:
			break;		
	}

	return ret;
}

 static const struct file_operations zx_tsc_fops = {
	.owner		= THIS_MODULE,
	.unlocked_ioctl	= zx_tsc_ioctl,
	.open		= zx_tsc_open,
	.release	= zx_tsc_close,
};

static struct miscdevice zx_tsc_miscdev = {
	.minor		= MISC_DYNAMIC_MINOR,
	.name		= "zx_tsc",
	.fops		= &zx_tsc_fops,
};


/********************************************************************************
 * Function:
 * Description: tsc_lock
 * Parameters: void
 * Returns: void
 * Others:
 ********************************************************************************/
static void tsc_lock(void)
{
	mutex_lock(&tsc_mutexId);
}
/********************************************************************************
 * Function:
 * Description: tsc_unlock
 * Parameters: void
 * Returns: void
 * Others:
 ********************************************************************************/

static void tsc_unlock(void)
{
	mutex_unlock(&tsc_mutexId);
}
/*******************************************************************************
 * Function: tsc_nearest
 * Description:2???????1???
 * Parameters:
 *   Input: 
 *			

 *   Output: N/A
 * Returns: N/A

 * Others:	//not use
********************************************************************************/
u32 tsc_nearest(int b[],u32 searchKey,u32 low,u32 high)
{
	u32 middle = (u32)(low+high)/2;
	u32 index;
	while(high -low >1)
	{
		if(searchKey ==b[middle] ) return middle;
		if(searchKey > b[middle] ) high = middle;
		if(searchKey < b[middle] ) low = middle;
		middle = (u32)(low+high)/2;
	}
	index = searchKey - b[high]> b[low]-searchKey ?low:high;
	return index;
}
/*******************************************************************************
 * Function: tsc_get_probe_adcvalue
 * Description: ??Y??1????????
 * Parameters:
 *   Input: adcValue:??1?
 *			*temp:??|???????

 *   Output: N/A
 * Returns: N/A

 * Others:	//not use
********************************************************************************/
static void tsc_get_probe_adcvalue(u32 adcValue, int *temp, int is_adcRfd) 
{
	u32 index = 0;
	if(is_adcRfd){	
		index= tsc_nearest(ts_temp_value_tableRfd[TS_TEMP_VOLTAGE_TABLE_NUMBER],adcValue,TS_TEMP_NUMBER_SMALLEST,TS_TEMP_NUMBER_BIGGEST-1);
		*temp= ts_temp_value_tableRfd[TS_TEMP_VALUE_TABLE_NUMBER][index];
	}
	else
	{
		index= tsc_nearest(ts_temp_value_table[TS_TEMP_VOLTAGE_TABLE_NUMBER],adcValue,TS_TEMP_NUMBER_SMALLEST,TS_TEMP_NUMBER_BIGGEST-1);
		*temp= ts_temp_value_table[TS_TEMP_VALUE_TABLE_NUMBER][index];
	}
		
}

static u32 tsc_dac_read(u32 addr)
{
	u32	dac;
	
	dac = zx_read_reg(addr);

#ifdef RFC_DCXO_EN
	dac = (dac&0xffff0000)>>16; //high16bit: the ADC value of temp	
#endif

	return dac;
}
#if 0
static int tsc_adcRf_read(void)
{
	u32	adcRfValue;
	int tempRf;
	
	adcRfValue = tsc_dac_read(IRAM_TEMPCOMP_DAC); 
	tsc_get_probe_adcvalue(adcRfValue,&tempRf);

	return tempRf;
}
#endif
static void tsc_temp_detect(void * arg)
{
	u32 adc1Value = 0;
	int temp1 = 0;
	u32 adc2Value = 0;
	int temp2 = 0;
	u32 adcRfValue = 0;	
	int tempRf = 0;
	u32 adcRfdValue = 0;	
	int tempRfd = 0;


	while(1) {
		if(g_adc1_flag==1){
			adc1Value = get_adc1_voltage();
			tsc_get_probe_adcvalue(adc1Value,&temp1, 0);
		}
		if(g_adc2_flag==1){
			adc2Value = get_adc2_voltage();
			tsc_get_probe_adcvalue(adc2Value,&temp2, 0);
		}
		if(g_adc3_flag==1){
			adcRfValue = tsc_dac_read(IRAM_TEMPCOMP_DAC); 
			tsc_get_probe_adcvalue(adcRfValue,&tempRf, 0);
			if((adcRfValue<RFDDAC_LOW)||(adcRfValue>RFDDAC_HIGH))
			{
				printk("!!!!!!!(adcRfValue < %d)||(adcRfValue > %d)\n", RFDDAC_LOW, RFDDAC_HIGH);
				tempRf=25;
			}
			if((adcRfValue>=RFDDAC_LOW)&&(adcRfValue<=RFDDAC_LOWE))
			{
				printk("curcuit breakage(%d<=adcRfValue<= %d)\n", RFDDAC_LOW, RFDDAC_LOWE);
				tempRf= -100 ;
			}
			if((adcRfValue>=RFDDAC_HIGHE)&&(adcRfValue<=RFDDAC_HIGH))
			{
				printk("curcuit short(%d<=adcRfValue<= %d)\n", RFDDAC_HIGHE, RFDDAC_HIGH);
				tempRfd= -75 ;
			}			
		}
		if(TsNvData.AdcRFd_En==0xB2){	
			adcRfdValue =(zx_read_reg(IRAM_TEMPCOMP_RFDDAC)&0xffff0000)>>16; 
			tsc_get_probe_adcvalue(adcRfdValue,&tempRfd, 1);
			if((adcRfdValue<RFDDAC_LOW)||(adcRfdValue>RFDDAC_HIGH))
			{
				printk("!!!!!!!(adcRfdValue < %d)||(adcRfdValue > %d)\n", RFDDAC_LOW, RFDDAC_HIGH);
				tempRfd=25;
			}
			if((adcRfdValue>=RFDDAC_LOW)&&(adcRfdValue<=RFDDAC_LOWE))
			{
				printk("curcuit breakage(%d<=adcRfdValue<= %d)\n", RFDDAC_LOW, RFDDAC_LOWE);
				tempRfd= -100 ;
			}
			if((adcRfdValue>=RFDDAC_HIGHE)&&(adcRfdValue<=RFDDAC_HIGH))
			{
				printk("curcuit short(%d<=adcRfdValue<= %d)\n", RFDDAC_HIGHE, RFDDAC_HIGH);
				tempRfd= -75 ;
			}			
		}

		tsc_lock();

		/*set tempvalue to g_ts_data_info*/	
		g_ts_data_info[PROBE_ADC1][TS_MEMBER_PROBE] = PROBE_ADC1;
		g_ts_data_info[PROBE_ADC1][TS_MEMBER_TEMP] = temp1;
		g_ts_data_info[PROBE_ADC2][TS_MEMBER_PROBE] = PROBE_ADC2;
		g_ts_data_info[PROBE_ADC2][TS_MEMBER_TEMP] = temp2;
		g_ts_data_info[PROBE_ADCRF][TS_MEMBER_PROBE] = PROBE_ADCRF;
		g_ts_data_info[PROBE_ADCRF][TS_MEMBER_TEMP] =tempRf;	
		/*zx_read_reg(IRAM_BASE_ADDR_SLAVE_AFC+0xc)>>10 is the temprature of rf*/
		//g_ts_data_info[PROBE_ADCRF][TS_MEMBER_TEMP] = zx_read_reg(IRAM_TEMPCOMP_RFDTEMP)>>10;	

		if(TsNvData.AdcRFd_En==0xB2){		
			g_ts_data_info[PROBE_ADCRFd][TS_MEMBER_PROBE] = PROBE_ADCRFd;
			g_ts_data_info[PROBE_ADCRFd][TS_MEMBER_TEMP] = tempRfd;
		}	
		
		/*set tempvalue to iram to ap*/	
		tsc_write_reg(TSCTRL_TEMPADC1,temp1);
		tsc_write_reg(TSCTRL_TEMPADC2,temp2);
		tsc_write_reg(TSCTRL_TEMPADCRF, g_ts_data_info[PROBE_ADCRF][TS_MEMBER_TEMP]);
		tsc_write_reg(TSCTRL_TEMPADCRFd, g_ts_data_info[PROBE_ADCRFd][TS_MEMBER_TEMP]);

		tsc_unlock();		

		if(g_tsc_print_log_debug)
		{
			if(TsNvData.AdcRFd_En==0xB2){		
				tsc_print_log(" adc1Value=%d,adc2Value=%d,adcRfValue=%d,adcRfdValue=%d,temp1 = %d.temp2 = %d.temprf = %d.temprfd = %d\n",
				adc1Value,adc2Value,adcRfValue,adcRfdValue,temp1,temp2, g_ts_data_info[PROBE_ADCRF][TS_MEMBER_TEMP], g_ts_data_info[PROBE_ADCRFd][TS_MEMBER_TEMP] );
			}else{
				tsc_print_log("adc1Value=%d,adc2Value=%d,adcRfValue=%d,temp1 = %d.temp2 = %d.temprf = %d.\n",
				adc1Value,adc2Value,adcRfValue,temp1,temp2, g_ts_data_info[PROBE_ADCRF][TS_MEMBER_TEMP] );
			}
			tsc_print_log("DetectEn:0x%x; AdcRFd_En:0x%x; Modemrate_En:0x%x; TansmitPower_En:0x%x; Dfs_En:0x%x; User_En:0x%x;",
				TsNvData.DetectEn, TsNvData.AdcRFd_En, TsNvData.Modemrate_En, TsNvData.TansmitPower_En, TsNvData.Dfs_En, TsNvData.User_En );
		}

		if((((tsc_record_time_cnt*TS_POLLING_TIME_S)%tsc_record_time)==0) && tsc_record_flag)
		{
			if(g_adc1_flag==1){
				sc_debug_info_record(MODULE_ID_AP_TSC, "temp1:%d\n", zx_read_reg(TSCTRL_TEMPADC1) );
				printk( "temp1:%d\n", zx_read_reg(TSCTRL_TEMPADC1));
			}
			if(g_adc2_flag==1){
				sc_debug_info_record(MODULE_ID_AP_TSC, "temp2:%d\n", zx_read_reg(TSCTRL_TEMPADC2) );
				printk( "temp2:%d\n", zx_read_reg(TSCTRL_TEMPADC2));
			}
			if(g_adc3_flag==1){
				sc_debug_info_record(MODULE_ID_AP_TSC, "tempRf:%d\n", zx_read_reg(TSCTRL_TEMPADCRF) );
				printk( "tempRf:%d\n", zx_read_reg(TSCTRL_TEMPADCRF));
			}
			if(TsNvData.AdcRFd_En==0xB2){			
				sc_debug_info_record(MODULE_ID_AP_TSC, "tempRfd:%d\n", zx_read_reg(TSCTRL_TEMPADCRFd) );
				printk( "tempRfd:%d\n", zx_read_reg(TSCTRL_TEMPADCRFd));
			}	
		}
		tsc_record_time_cnt++;
		
		 if(TsNvData.DetectEn == 0xB2)
			up(&s_tsc_adc_semaphore);
		 
		msleep(TS_POLLING_TIME_S*1000);

	}
	
}

static void tsc_temp_detect_thread_ctread(unsigned long een)
{

	int err;

	err = (int)kthread_run(tsc_temp_detect, NULL, "tsc_temp_detect");
	if (IS_ERR((const void *)err)) {
		printk(KERN_ERR"[zx tsctrl]: Fail to create and run tsc_temp_detect!\n");
        //return PTR_ERR((const void *)err);
    }
}


/*init tsctrl Iram*/
static void tsc_createtimer(void)
{
	init_timer(&timer_tsc); 
	timer_tsc.function = tsc_temp_detect_thread_ctread; 
	
	timer_tsc.expires = jiffies + msecs_to_jiffies(TS_TEMP_DETECT_BEGIN_TIME); 
	add_timer(&timer_tsc); 

}
/*******************************************************************************
* Function: tsc_refInit
* Description: 
* Parameters:
*	 Input: N/A
*
*	 Output: N/A
* Returns: N/A

* Others:	//not use
********************************************************************************/
s32 tsc_refInit(void)
{
	if(ts_adc_flag ==1)
	{
		g_adc1_flag=1; //?adc1??2apa2?????g_adc1_flag=1
		g_adc2_flag=0; //?adc2??2apa2?????g_adc2_flag=1	
		g_adc3_flag=0; 
	}
	else if(ts_adc_flag ==2)
	{
		g_adc1_flag=0; //?adc1??2apa2?????g_adc1_flag=1
		g_adc2_flag=1; //?adc2??2apa2?????g_adc2_flag=1
		g_adc3_flag=0; 
	}
	else
	{
		g_adc1_flag=0;
		g_adc2_flag=0; 
		g_adc3_flag=1; 
	}

	tsc_print_log("g_adc1_flag:%d, g_adc2_flag:%d, g_adc3_flag:%d.\n",g_adc1_flag, g_adc2_flag, g_adc3_flag);
	
	return 0;
}


/*init tsctrl Iram*/
static void tsc_init_iram(void)
{
	/*?3???D??t??|????䨬?*/
    memset((void *)(IRAM_BASE_ADDR_TPC), 0x0, IRAM__LEN_TPC);    /*???*/	
}


 /* /sys/zx_tsc/tsc_value */  
 /* /sys/zx_tsc/tsc_percent */ 
 /* /sys/zx_tsc/tsc_ptscCtrlEn */  
 static int  zx_tsc_init(void)
 {
	 int ret;
 	unsigned int  power_typ=0;
	
	 printk(KERN_INFO "[TSC] create sysfs interface\n");
 
	 zx_tsc_kobj = kobject_create_and_add("zx_tsc", NULL);
	 if (!zx_tsc_kobj){
		 return -ENOMEM; 
	 }
 
	 ret = sysfs_create_group(zx_tsc_kobj, &zx_tsc_attr_group);
	 if (ret){
		 printk(KERN_WARNING "[TSC] sysfs_create_group ret %d\n", ret);  
		 return ret;
	 }

	/*init iram for tsc*/
	tsc_init_iram();
	
	g_test_addr0=DRV_PUB_NV_ADDR; 
    g_test_addr1=DRV_SYS_NV_ITEM_ADDR(tsc_config);
	//ret = nand_NvRead(DRV_SYS_NV_ITEM_ADDR(tsc_config),DRV_SYS_NV_ITEM_SIZE(tsc_config),(u8*)&TsNvData);
	ret = CPPS_FUNC(cpps_callbacks, zOss_NvItemRead)(DRV_SYS_NV_ITEM_ADDR(tsc_config), (u8*)&TsNvData, DRV_SYS_NV_ITEM_SIZE(tsc_config));
	
	if(ret != 0){
		printk(KERN_ERR"[zx tsc]: zOss_NvItemRead failed [err=%d]!\n", ret);
	    return -1;
	}
	
	zDrvTsc_SetTscEn(0xB2);//need
	tsc_refInit();

	mutex_init(&tsc_mutexId);
	sema_init(&s_tsc_adc_semaphore, 0);	
	
	tsc_createtimer();

	printk("adc1 throshold:[throd0,throd1]=[%d,%d],[throd2,throd3]=[%d,%d],[throd4,throd5]=[%d,%d],[throd6,throd7]=[%d,%d],[throd8,throd9]=[%d,%d].\n", \
		TsNvData.Threshods[PROBE_ADC1].THROSHOLD_0,TsNvData.Threshods[PROBE_ADC1].THROSHOLD_1,TsNvData.Threshods[PROBE_ADC1].THROSHOLD_2,\
		TsNvData.Threshods[PROBE_ADC1].THROSHOLD_3,TsNvData.Threshods[PROBE_ADC1].THROSHOLD_4,TsNvData.Threshods[PROBE_ADC1].THROSHOLD_5,\
		TsNvData.Threshods[PROBE_ADC1].THROSHOLD_6,TsNvData.Threshods[PROBE_ADC1].THROSHOLD_7,\
		TsNvData.Threshods[PROBE_ADC1].THROSHOLD_8,TsNvData.Threshods[PROBE_ADC1].THROSHOLD_9);
	printk("adc2 throshold:[throd0,throd1]=[%d,%d],[throd2,throd3]=[%d,%d],[throd4,throd5]=[%d,%d],[throd6,throd7]=[%d,%d],[throd8,throd9]=[%d,%d].\n", \
		TsNvData.Threshods[PROBE_ADC2].THROSHOLD_0,TsNvData.Threshods[PROBE_ADC2].THROSHOLD_1,TsNvData.Threshods[PROBE_ADC2].THROSHOLD_2,\
		TsNvData.Threshods[PROBE_ADC2].THROSHOLD_3,TsNvData.Threshods[PROBE_ADC2].THROSHOLD_4,TsNvData.Threshods[PROBE_ADC2].THROSHOLD_5,\
		TsNvData.Threshods[PROBE_ADC2].THROSHOLD_6,TsNvData.Threshods[PROBE_ADC2].THROSHOLD_7,\
		TsNvData.Threshods[PROBE_ADC2].THROSHOLD_8,TsNvData.Threshods[PROBE_ADC2].THROSHOLD_9);
	printk("adcrf throshold:[throd0,throd1]=[%d,%d],[throd2,throd3]=[%d,%d],[throd4,throd5]=[%d,%d],[throd6,throd7]=[%d,%d],[throd8,throd9]=[%d,%d].\n", \
		TsNvData.Threshods[PROBE_ADCRF].THROSHOLD_0,TsNvData.Threshods[PROBE_ADCRF].THROSHOLD_1,TsNvData.Threshods[PROBE_ADCRF].THROSHOLD_2,\
		TsNvData.Threshods[PROBE_ADCRF].THROSHOLD_3,TsNvData.Threshods[PROBE_ADCRF].THROSHOLD_4,TsNvData.Threshods[PROBE_ADCRF].THROSHOLD_5,\
		TsNvData.Threshods[PROBE_ADCRF].THROSHOLD_6,TsNvData.Threshods[PROBE_ADCRF].THROSHOLD_7,\
		TsNvData.Threshods[PROBE_ADCRF].THROSHOLD_8,TsNvData.Threshods[PROBE_ADCRF].THROSHOLD_9);

	memcpy((void*)TSCTRL_IRAM_NV, &TsNvData, sizeof(TsNvData));
	
    if(TsNvData.DetectEn != 0xB2){
		zDrvTsc_SetTscEn(0);//need		
		printk("TsNvData.DetectEn != 0xB2.\n");
        return 0;  /*if dont enable tsc,just return success.*/
    }	

	
	//????1??2a?2????????2?????3
  //  if(TsNvData.DetectEn == 0xB2){
		tsctrl_init(); 
		power_typ = *(unsigned int *)POWERON_TYPE_BASE;
		if(POWER_ON_AMT ==power_typ) {
			zDrvTsc_SetTscEn(0);
			printk("POWER_ON_AMT set tscen= 0.\n");
		}
 //   }

 	ret = misc_register(&zx_tsc_miscdev);
	if (ret != 0) {
		printk(KERN_ERR"tsc cannot register miscdev on(err=%d)\n", ret);
		return ret;
	}

	printk("zx_tsc_init  end.\n");
 
	 return 0;
 }

 static int __init zx_softtsc_init(void)
 {
	cpps_init2_register(zx_tsc_init);
	return 0;
 }
 
 
late_initcall_sync(zx_softtsc_init);



void tsc_set_temp_data_info(Ts_TsCtrl_Probe ProbeNum)
{
    tsc_lock();
    if(ProbeNum == PROBE_ADC1)
    {
        g_ts_data_info[PROBE_ADC1][TS_MEMBER_PROBE] = PROBE_MAX;
        g_ts_data_info[PROBE_ADC1][TS_MEMBER_TEMP] = 0xFF;
    }
    else if(ProbeNum == PROBE_ADC2)
    {
        g_ts_data_info[PROBE_ADC2][TS_MEMBER_PROBE] = PROBE_MAX;
        g_ts_data_info[PROBE_ADC2][TS_MEMBER_TEMP] = 0xFF;
    }
    else if(ProbeNum == PROBE_ADCRF)
    {
        g_ts_data_info[PROBE_ADCRF][TS_MEMBER_PROBE] = PROBE_MAX;
        g_ts_data_info[PROBE_ADCRF][TS_MEMBER_TEMP] = 0xFF;
    }	
    else
    {
    	if(g_tsc_print_log_debug)
        	tsc_print_log("clear array empty.\n");
    }
    tsc_unlock();
}

/*get buffer first address*/
void tsc_get_temp_data_info(int TsDataInfo[][PROBE_INFO])
{
    int i,j;
    tsc_lock();
    for(i=0;i<PROBE_NUM;i++)
    {
        for(j=0;j<PROBE_INFO;j++)
        {
            TsDataInfo[i][j] = g_ts_data_info[i][j];
        }
    }
    tsc_unlock();
}

s32 zDrvTsc_SetTscEn(u8 val)
{
	tsc_set_detect_en(val);
	return 0;

}
EXPORT_SYMBOL(zDrvTsc_SetTscEn);

s32 zDrvTsc_GetTscEn(void)
{
	return tsc_get_detect_en();
}
EXPORT_SYMBOL(zDrvTsc_GetTscEn);

