/*
 * 
 *
 * Copyright (c) 2013, ZTE Corporation.
 * write by SWQ
 *
 */

#ifndef __ZX_TSC_H
#define __ZX_TSC_H

/****************************************************************************
* 	                                        Include files
****************************************************************************/
#include <linux/ioctl.h>


/****************************************************************************
*                                           Types
****************************************************************************/
 typedef enum _T_TsCtrl_Probe
{
	PROBE_ADC1 = 0,
	PROBE_ADC2,
	PROBE_ADCRF,	//get rf temp
	PROBE_ADCRFd,   //get dbb temp
	PROBE_RESEV3,
	PROBE_RESEV4,
	
	PROBE_MAX,
} Ts_TsCtrl_Probe;

 typedef enum
 {
	 TS_TEMP_VALUE_TABLE_NUMBER = 0,
	 TS_TEMP_VOLTAGE_TABLE_NUMBER = 1,
	 TS_TEMP_TABLE_NUMBER_MAX
 }TS_TEMP_TABLE_NUMBER;

 typedef enum _T_Ts_Member
 {
     TS_MEMBER_PROBE = 0,
     TS_MEMBER_TEMP,

     TS_MEMBER_MAX,
 } Ts_Member;

typedef enum _T_TsCtrl_Strategy_Id
{
	PS_STRATEGY_RATE = 0,
	PS_STRATEGY_ANYRESIDENT,
	WIFI_STRATEGY,
	CHARGER_STRATEGY,
	AP_RATE,
	MAX_TSCTRL_STRATEGY_ID
} T_TsCtrl_Strategy_ModuleId;

/**************************************************
	0--STRTEGY_STOP:  ֹͣ
	1--STRTEGY_START: ʼ
	2--STRTEGY_HOLD:  HOLD֮ǰ
**************************************************/
 typedef enum _T_TsCtrl_Strategy
 {
	STRTEGY_STOP = 0,
	STRTEGY_START=1,
	STRTEGY_HOLD=2,

	STRTEGY_MAX,
 } Ts_TsCtrlStrategy; 

typedef struct _T_TscPhy_Strategy
{
	char name[32];
	volatile u32 flag;
}T_TscP_Strategy;


/****************************************************************************
* 	                                           macro define
****************************************************************************/
#define ZX_TSC_DEV    "/dev/zx_tsc"

#define ZX_TSC_IOC_MAGIC     'W'
/*ioctl cmd usd by device*/
#define ZX_TSC_SET_THRESHOLD         	_IOW(ZX_TSC_IOC_MAGIC, 1, char *)
#define ZX_TSC_GET_THRESHOLD          _IOW(ZX_TSC_IOC_MAGIC, 2, char *)

#define ZX_TSC_SET_DECTET_EN         	_IOW(ZX_TSC_IOC_MAGIC, 3, char *)
#define ZX_TSC_GET_DECTET_EN          _IOW(ZX_TSC_IOC_MAGIC, 4, char *)






#define tsc_read_reg 							zx_read_reg
#define tsc_write_reg							zx_write_reg
/**/

#define  STRATEGY_PS_ANYRESIDENT  			0
#define  STRATEGY_PS_RATE  					1
#define  STRATEGY_PS_DFS  					2
#define  STRATEGY_PS_NUM  					3

#define  THRESHOLD_NUM  			11
#define  STRATEGY_PHY_NUM  					8

#define  BITS_FOR_PHYIRAM				    1
/*TSCTRL_PHY iram ÿһbitʾPHYһǷִ*/
#define  BIT_LIMIT_LTE_DOWNRATE1  			0
#define  BIT_LIMIT_LTE_DOWNRATE2  			1
#define  BIT_LIMIT_W_DOWNRATE1  			2
#define  BIT_LIMIT_W_DOWNRATE2  			3
#define  BIT_LIMIT_LTE_UPTRANSIMITPOWER1  	4
#define  BIT_LIMIT_LTE_UPTRANSIMITPOWER2  	5
#define  BIT_LIMIT_W_UPTRANSIMITPOWER1  	6
#define  BIT_LIMIT_W_UPTRANSIMITPOWER2  	7
/**/
//#define  STRATEGY_PS_NUM  	2
#define  BITS_FOR_PSIRAM				    4
/*TSCTRL_PS iram ÿbitʾPSһǷִ*/
#define  BIT_PS_RATE  						0
#define  BIT_PS_ANYRESIDENT  				4
#define  BIT_PS_FREQ  						8

/**/
//#define  STRATEGY_PERIP_NUM  	2
#define  BITS_FOR_PEPIPIRAM				    4
/*TSCTRL_PERIP iram ÿbitʾTSCTRL_PERIPһǷִ*/
#define  BIT_WIFI  							0
#define  BIT_CHHRGER	 					4
#define  BIT_APRATE	 						8


/**/
//#define  STRATEGY_AP_NUM  	2
#define  BITS_FOR_APPIRAM				    4
/*TSCTRL_AP iram ÿbitʾAPһǷִ*/
#define  BIT_SHUTDOWN	 				    0		

/*TSCTRL_PHY iramInfo:ÿһbitʾPHYһǷִ
bit0:limit_ltedownrate1	  1:lte10:ֹͣlte1
bit1:limit_ltedownrate2	  1:lte20:ֹͣlte2
bit2:limit_wdownrate1	  1:w10:ֹͣw1
bit3:limit_wdownrate2	1:w20:ֹͣw2
bit4:limit_lteuptransmitrate1	1:lteз书10:ֹͣlteз书1
bit5:limit_lteuptransmitrate2	1:lteз书20:ֹͣlteз书2
bit6:limit_wuptransmitrate1		1:wз书10:ֹͣwз书1
bit7:limit_wuptransmitrate2		1:wз书20:ֹͣwз书2
*/

#define  TSCTRL_PHY							(IRAM_TSC_BASE+0x00)/* 1KIRAM_BASE_ADDR_TPC++0x400--¿ݴ  */

/*TSCTRL_PHY+0x04--TSCTRL_PHY+0x44
ÿ4 bitʾÿ̽ǷҪִв1:ִ0:ִ;2 HOLD*/
#define  TSCTRL_PS							(IRAM_TSC_BASE+0x04)
#define  TSCTRL_AP							(IRAM_TSC_BASE+0x08)
#define  TSCTRL_PERIP						(IRAM_TSC_BASE+0x0C)

/*ÿ4 bitʾÿ̽ǷҪִв1:ִ0:ִ;2 HOLD*/
#define  TSCTRL_LIMIT_LTE_DOWNRATE1			(IRAM_TSC_BASE+0x10)  /*A*/
#define  TSCTRL_LIMIT_LTE_DOWNRATE2			(IRAM_TSC_BASE+0x14)  /*B*/
#define  TSCTRL_LIMIT_W_DOWNRATE1			(IRAM_TSC_BASE+0x18)  /*A*/
#define  TSCTRL_LIMIT_W_DOWNRATE2			(IRAM_TSC_BASE+0x1c)  /*B*/
#define  TSCTRL_LIMIT_LTE_UPTRANSIMITPOWER1	(IRAM_TSC_BASE+0x20)  /*C*/
#define  TSCTRL_LIMIT_LTE_UPTRANSIMITPOWER2	(IRAM_TSC_BASE+0x24)  /*D*/
#define  TSCTRL_LIMIT_W_UPTRANSIMITPOWER1	(IRAM_TSC_BASE+0x28)  /*C*/
#define  TSCTRL_LIMIT_W_UPTRANSIMITPOWER2	(IRAM_TSC_BASE+0x2c)  /*D*/
#define  TSCTRL_PS_RATE						(IRAM_TSC_BASE+0x30)  /*E*/
#define  TSCTRL_PS_ANYRESIDENT				(IRAM_TSC_BASE+0x34)  /*F*/
#define  TSCTRL_SHUTDOWN					(IRAM_TSC_BASE+0x38)  /*G*/
#define  TSCTRL_WIFI						(IRAM_TSC_BASE+0x3c)  /*F*/
#define  TSCTRL_CHARGER						(IRAM_TSC_BASE+0x40)  /*F*/
#define  TSCTRL_APRATE						(IRAM_TSC_BASE+0x44)  /*F*/
#define  TSCTRL_DFS							(IRAM_TSC_BASE+0x48)  /*DFS*/

/*ÿ̽ԲԵĿϢڴ洢IRAMʼbitλ*/
#define  BITS_FOR_PROBES 				 4
#define  BIT_PROBE_ADC1  				(PROBE_ADC1*BITS_FOR_PROBES)
#define  BIT_PROBE_ADC2  				(PROBE_ADC2*BITS_FOR_PROBES)
#define  BIT_PROBE_ADCRF  				(PROBE_ADCRF*BITS_FOR_PROBES)
#define  BIT_PROBE_ADCRFd   				(PROBE_ADCRFd*BITS_FOR_PROBES)
#define  BIT_PROBE_RESEV3  				(PROBE_RESEV3*BITS_FOR_PROBES)
#define  BIT_PROBE_RESEV4  				(PROBE_RESEV4*BITS_FOR_PROBES)

/*Ԥֿռ洢ҪR7ݵA9Ϣ,TSCTRL_PHY+0x100--TSCTRL_PHY+0x400*/
#define  TSCTRL_TEMPADC1					(IRAM_TSC_BASE+0x100)  /*temp adc1*/
#define  TSCTRL_TEMPADC2					(IRAM_TSC_BASE+0x104)  /*temp adc2*/
#define  TSCTRL_TEMPADCRF					(IRAM_TSC_BASE+0x108)  /*temp adcrf*/
#define  TSCTRL_TEMPADCRFd					(IRAM_TSC_BASE+0x10c)  /*temp rev2*/
#define  TSCTRL_TEMPREV3					(IRAM_TSC_BASE+0x110)  /*temp rev3*/
#define  TSCTRL_TEMPREV4					(IRAM_TSC_BASE+0x114)  /*temp rev4*/
#define  TSCTRL_DETECT_EN					(IRAM_TSC_BASE+0x118)  /*TsNvData.DetectEn*/
#define  TSCTRL_TEMP_PERCENT				(IRAM_TSC_BASE+0x11c)  /*APrate ,g_tempPercent*/


#define TSCTRL_IRAM_NV		(IRAM_TSC_BASE+0x200)  /*TSC NV: size-0x140*/


#define PS_CORE_SEL_REG      (ZX_MATRIX_CRM_BASE+0x20)/*ps core clk sel*/

/**/
#define  PROBE_NUM  	PROBE_MAX
#define  PROBE_INFO 	2   //fixed value, probe num and temp
//#define  TS_ADC_TEMP_NUMBER   2
//#define  TS_ADC_TEMP_VOLTAGE_NUMBER  110
#define  TS_TEMP_NUMBER_SMALLEST   0

//l.yang  Fix the issue of inaccurate temperature start
#define  TS_TEMP_NUMBER_BIGGEST  166
//l.yang  Fix the issue of inaccurate temperature start


#define TEMP_PERCENT_INTERVAL  (10) //¶Ȱٷֱȼ

// timing parameters
#define TS_TEMP_DETECT_BEGIN_TIME (60 * 1000)  //60s , the begin time to  detect temp
#define TS_STRATEGY_SET_BEGIN_TIME (61 * 1000)  //60s , the begin time to  start temp strategy
#define TS_POLLING_TIME_S	(20)
#define TS_POLLING_TIME (TS_POLLING_TIME_S * 1000)  //20s
#define TS_PROBE_OFFSET   2   /*bit2ʼ*/
#define NV_TEMP_VALUE_NUMBERS  7


#define TSC_DEBUG_DEF		1

#if TSC_DEBUG_DEF
#define tsc_print_log(fmt, args...)      	\
{	\
	printk(KERN_INFO "[tsc] " fmt, ##args);	\
}
#else
#define tsc_print_log(fmt, args...) {}
#endif

 /****************************************************************************
*                                           fuction extern 
****************************************************************************/
void tsctrl_init(void);
void tsc_get_temp_data_info(int TsDataInfo[][PROBE_INFO]);
typedef void (* T_TsCtrl_CallbackFunction)( u8 en ); /*en:   1,ԣ0,ֹͣ; 2: hold */
s32   zDrvTsCtrl_RegCallback(T_TsCtrl_Strategy_ModuleId  module,T_TsCtrl_CallbackFunction callback);
s32   zDrvTsc_SetTscEn(u8 val);  //val:0xB2,¿ش򿪣 ֵ¿عر
s32   zDrvTsc_GetTscEn(void);
u32 zDrvTsCtrl_DfsEn(void);

#endif /* __ZX_TSC_H */

