/*
 *  zx-pm-custom.c - power management custom interface.
 *
 *  Written by zxp.
 *
 */

#include <linux/module.h>
#include <linux/kernel.h>
#include <linux/init.h>
#include <linux/spinlock.h>
#include <linux/interrupt.h>
#include <linux/types.h>
#include <linux/suspend.h>
#include <linux/tick.h>

#include <mach/irqs.h>
#include "zx-pm.h"

/*===================================================================
 *==  7520v2 ap interrupt arrangement ===============================
 *===================================================================
 *===================================	 evb     dc	   mifi   =======
 *== timer1              -- wake		   y      y     y
 *== m02ap_icp                             y      y     y
 *== ps2ap_icp                             y      y     y
 *== ext0                -- pmu            y      n     y 
 *== ext1                -- pg(charger)    y      n     y
 *== ext2                -- wps_key   	   n      n     y 	
 *== ext3                -- rst_key	       y      n     y	
 *== ext4                -- pwr_key        y      n     n
 *== ext7                -- wps_key        y      n     n 
 *== ext6                -- wifi_wake      y      n     y
 *== alarm                                 y      n     n
 *== rtc                                   y      n     n
 *===================================================================
 */
/* evb */
#if  defined(CONFIG_ARCH_ZX297520V3_MIFI) || defined(CONFIG_ARCH_ZX297520V3_EVB) || defined(CONFIG_ARCH_ZX297520V3_MDL) ||\
	 defined(CONFIG_ARCH_ZX297520V3_PHONE) || defined(CONFIG_ARCH_ZX297520V3_WATCH) || defined(CONFIG_ARCH_ZX297520V3_CPE) ||\
	 defined(CONFIG_ARCH_ZX297520V3_POC)|| defined(CONFIG_ARCH_ZX297520V3_FWP)|| defined(CONFIG_ARCH_ZX297520V3_CAP) ||\
	 defined(CONFIG_ARCH_ZX297520V3_UFI)|| defined(CONFIG_ARCH_ZX297520V3_CPE_SWITCH)


static unsigned int wake_source_for_sleep[] = 
{
#ifndef CONFIG_ARCH_ZX297520V3_CAP
    WAKE_SRC_ICP_M02PS | WAKE_SRC_ICP_AP2PS | WAKE_SRC_PS_TIMER1 |  \
	WAKE_SRC_ICP_PHY2PS |WAKE_SRC_SPCU_PW,
#else
	WAKE_SRC_ICP_M02AP | WAKE_SRC_ICP_PS2AP | WAKE_SRC_AP_TIMER1 |	\
	WAKE_SRC_ICP_PHY2AP ,
#endif
    /*WAKE_SRC_RTC_ALARM | WAKE_SRC_RTC_TIMER | 					\
    WAKE_SRC_EXTERNAL0 | WAKE_SRC_EXTERNAL1 | WAKE_SRC_EXTERNAL2 |	\
    WAKE_SRC_EXTERNAL3 | WAKE_SRC_EXTERNAL4 | WAKE_SRC_EXTERNAL5 |  \
    WAKE_SRC_EXTERNAL6 | WAKE_SRC_EXTERNAL13 | WAKE_SRC_EXTERNAL14 |\
    WAKE_SRC_EXTERNAL7 ,*/
    /*|\
    WAKE_SRC_USB_POWERDWN_UP | WAKE_SRC_USB_POWERDWN_DOWN,*/
};

#elif  defined(CONFIG_ARCH_ZX297520V2EVB)
static unsigned int wake_source_for_sleep[] = 
{
    WAKE_SRC_ICP_M02AP | WAKE_SRC_ICP_PS2AP | WAKE_SRC_AP_TIMER1,/*|  \
    WAKE_SRC_RTC_ALARM | WAKE_SRC_RTC_TIMER | 					
    WAKE_SRC_EXTERNAL0 | WAKE_SRC_EXTERNAL1 | WAKE_SRC_EXTERNAL2 |	\
    WAKE_SRC_EXTERNAL3 | WAKE_SRC_EXTERNAL4 | WAKE_SRC_EXTERNAL5 |  \
    WAKE_SRC_EXTERNAL6 | WAKE_SRC_EXTERNAL13 | WAKE_SRC_EXTERNAL14 |\
    WAKE_SRC_EXTERNAL7 ,\*/
    /*|\
    WAKE_SRC_USB_POWERDWN_UP | WAKE_SRC_USB_POWERDWN_DOWN,*/
};
#else	

/* dc */
static unsigned int wake_source_for_sleep[] = 
{
    WAKE_SRC_ICP_M02AP | WAKE_SRC_ICP_PS2AP | WAKE_SRC_AP_TIMER1 |	\
    WAKE_SRC_EXTERNAL0,
};

#endif 

unsigned int pm_get_wakesource(void)
{
	return wake_source_for_sleep[0];
}

/*===================================================================
 *==  7520v2 ap uart debug interface  ===============================
 *===================================================================
 */
//#define	DEBUG_UART0
#define	DEBUG_UART1
void __iomem *debug_uart_base(void)
{
#if defined(DEBUG_UART0)
	return ZX29_UART0_VA;
#elif defined(DEBUG_UART1)
	return ZX29_UART1_VA;
#endif
}

