/*
 * ZTE power management main driver
 *
 * Copyright (C) 2013 ZTE Ltd.
 * 	by zxp
 *
 */
#include <linux/module.h>
#include <linux/kernel.h>
#include <linux/init.h>
#include <linux/spinlock.h>
#include <linux/interrupt.h>
#include <linux/types.h>
#include <linux/sched.h>
#include <linux/io.h>
#include <linux/suspend.h>
#include <linux/time.h>
#include <linux/timer.h>
#include <linux/delay.h>
#include <linux/cpu.h>
#include "zx-pm.h"
#include <linux/timer.h>
#include <linux/kthread.h>	/*For kthread_run()*/
#include <mach/spinlock.h>
#include "pub_debug_info.h"

#ifdef CONFIG_ZX_PM_DEBUG

static struct delayed_work 	pm_debug_work;
struct kobject *pm_debug_kobj;
static struct timer_list pm_debug_timer;

#define PM_DEBUG_DELAY 		msecs_to_jiffies(10000)		//10s

#endif

/*********************************************************************
 * some common pm functions
 ********************************************************************/
#ifdef CONFIG_ZX_RAM_CONSOLE 
#define	 PM_LOG_SRAM_SIZE	(4*1024)
static char pm_sram_printk_buf[PM_LOG_SRAM_SIZE];	// loop buffer
static u32  pm_sram_point = 0;
static u32  pm_sram_inited = 0;
//static char pm_sram_temp_buf[512] = {0};
/*
1cnt is 1s
*/
unsigned int psm_record_time_cnt=0; 	
unsigned int psm_record_time= 30; 
module_param(psm_record_time, uint, 0644);

static void pm_sram_cpy(char *s, unsigned len)
{
	if(pm_sram_point + len >= PM_LOG_SRAM_SIZE)
		pm_sram_point = 0;

	memcpy(pm_sram_printk_buf+pm_sram_point, s, len);
	pm_sram_point += len;
}

/* ------------------for idle print msg-------------------------*/

#define	 PM_IDLE_SRAM_ITEM_SIZE		(200)
#define	 PM_IDLE_SRAM_ITEM_CNT		(8)
#define	 PM_IDLE_TOTAL_SRAM_SIZE	(PM_IDLE_SRAM_ITEM_SIZE*PM_IDLE_SRAM_ITEM_CNT)

typedef struct
{
	char 	buf[PM_IDLE_SRAM_ITEM_SIZE];
}pm_idle_sram;

static pm_idle_sram pm_idle_sram_buf[PM_IDLE_SRAM_ITEM_CNT];
static unsigned int pm_idle_sram_state = 0;
static unsigned int pm_idle_sram_cur_item = 0;

static u32 last_uart_jiffies =0; 
struct timer_list timer_uart_print;


#ifdef CONFIG_CPU_IDLE
extern int zx_idle_get_debug_flag(void);
extern int zx_idle_get_idle_flag(void); //ap idle flag
#endif

#ifndef CONFIG_CPU_IDLE
typedef int (*pm_callback_fn)(void);
int zx_pm_register_callback(pm_callback_fn enter_cb, pm_callback_fn exit_cb)
{
	return 0;
}
EXPORT_SYMBOL(zx_pm_register_callback);
#endif

/*  for idle print msg */

void pm_idle_sram_start(void)
{
	pm_idle_sram_cur_item = 0;
	pm_idle_sram_state = 1;
}

void pm_idle_sram_end(void)
{
	pm_idle_sram_state = 0;
}


bool pm_idle_sram_is_permit(void)
{
#ifdef CONFIG_CPU_IDLE
	if(pm_idle_sram_state && (pm_get_mask_info()&PM_SLEEP_FLAG_PRINT))//if(pm_idle_sram_state && (zx_idle_get_debug_flag()&1))
		return true;
	else
		return false;
#endif	
}

static void pm_idle_sram_cpy(char *s, unsigned len)
{
	if(!pm_idle_sram_is_permit())
		return;

	if((pm_idle_sram_cur_item >= PM_IDLE_SRAM_ITEM_CNT) || (len >= PM_IDLE_SRAM_ITEM_SIZE))
	{
		BUG();
		//return ;
	}
	
	memcpy(pm_idle_sram_buf[pm_idle_sram_cur_item].buf, s, len);
	pm_idle_sram_buf[pm_idle_sram_cur_item].buf[len] = 0;
	pm_idle_sram_cur_item ++;
}

 /**
 * pm_uart_print
 * 
 */

 static void pm_update_uart_jiffies(void)
 {
	last_uart_jiffies=jiffies;
 }

static void pm_sleep_flag_print(void)
{
	u32 cur_jiffies = jiffies;
	u32 work_jiffies = cur_jiffies - last_uart_jiffies;
	
	if( (work_jiffies > 200) ) {

		last_uart_jiffies = cur_jiffies;	
		printk(" jiffies:%u; ", cur_jiffies);
		#ifndef CONFIG_SYSTEM_RECOVERY
		#ifndef CONFIG_ARCH_ZX297520V3_CAP
			#ifdef USE_CPPS_KO
			if(cpps_callbacks.psm_GetModemSleepFlagStatus)
				CPPS_FUNC(cpps_callbacks,psm_GetModemSleepFlagStatus)();
			#else
			psm_GetModemSleepFlagStatus();
			#endif
		#endif
		#endif	
	}	
}

static void pm_sleepflag_print_func(unsigned long een)
{

	if(pm_get_mask_info()&PM_SLEEP_FLAG_PRINT) {

		soft_spin_lock_psm(UART_SFLOCK);

		pm_sleep_flag_print();
		mod_timer(&timer_uart_print ,jiffies + msecs_to_jiffies(1 * 1000));
		soft_spin_unlock_psm(UART_SFLOCK);
	}
	
}

static void pm_uart_createtimer(void)
{

	init_timer(&timer_uart_print); 
	timer_uart_print.function = pm_sleepflag_print_func; 
	timer_uart_print.expires = jiffies + msecs_to_jiffies(59 * 1000); 
	add_timer(&timer_uart_print); 

}

 void pm_uart_mod_timer(void)
 {
 	if(pm_get_mask_info()&PM_SLEEP_FLAG_PRINT) {
	 	pm_update_uart_jiffies();
		mod_timer(&timer_uart_print ,jiffies + msecs_to_jiffies(1 * 1000));
 	}
 }

  void pm_uart_del_timer(void)
 {
 	if(pm_get_mask_info()&PM_SLEEP_FLAG_PRINT) {
		del_timer(&timer_uart_print);
 	}
 }
/* ------------------for idle print msg-------------------------*/

#endif
extern void pm_debug_wakelocks(void);
void pm_psm_flag_print(u32 *sleepflag)
{
	unsigned int temp_count;

	#ifdef CONFIG_CPU_IDLE
	#ifndef CONFIG_ARCH_ZX297520V3_CAP
	printk("L1e e1 w t: 0x%x  0x%x  0x%x  0x%x; drv:0x%x;  app:0x%x; plat:0x%x; gsm:0x%x; idle_flag:0x%x; dma_used: 0x%x \n ",  
		sleepflag[0], sleepflag[7],   sleepflag[1], sleepflag[2], sleepflag[3], sleepflag[4] , sleepflag[5], sleepflag[6], zx_idle_get_idle_flag(),pm_dma_used());

	if((psm_record_time_cnt%psm_record_time)==0)
	{
		if((sleepflag[0]!=0x7f) ||(sleepflag[7]!=0x7f)||(sleepflag[1]!=0x3f)||(sleepflag[2]!=0x3f)){
			sc_debug_info_record(MODULE_ID_AP_PSM, "L1e0 e1 w t:%x %x %x %x\n", sleepflag[0], sleepflag[7], sleepflag[1], sleepflag[2] );
			printk("L1e0 e1 w t: %x %x %x %x\n", sleepflag[0], sleepflag[7], sleepflag[1], sleepflag[2] );
		}
		if(sleepflag[3]){
			sc_debug_info_record(MODULE_ID_AP_PSM, "drv %x\n", sleepflag[3] );
			printk("drv: %x\n", sleepflag[3] );
		}
		if(sleepflag[4]){
			sc_debug_info_record(MODULE_ID_AP_PSM, "app %x\n", sleepflag[4] );
			printk("app: %x\n", sleepflag[4] );
		}
		if(!sleepflag[5]){
			sc_debug_info_record(MODULE_ID_AP_PSM, "plat %x\n", sleepflag[5] );
			printk("plat: %x\n", sleepflag[5] );
		}
		if(!sleepflag[6]){
			sc_debug_info_record(MODULE_ID_AP_PSM, "gsm %x\n", sleepflag[6] );
			printk("gsm: %x\n", sleepflag[6] );
		}
		if(zx_idle_get_idle_flag() ){
			sc_debug_info_record(MODULE_ID_AP_PSM, "idle_flag %x\n", zx_idle_get_idle_flag() );
			printk("idle_flag: %x\n", zx_idle_get_idle_flag());
		}
		if(pm_dma_used()){
			sc_debug_info_record(MODULE_ID_AP_PSM, "dma_used %x\n", pm_dma_used());
			printk("dma_used: %x\n", pm_dma_used() );
		}

		if(!(pm_get_wakeup_count(&temp_count, false) && pm_save_wakeup_count(temp_count)))
		{
			pm_debug_wakelocks();
		}
	}
	psm_record_time_cnt++;		
		
	#endif
	#endif
}
EXPORT_SYMBOL(pm_psm_flag_print);

void pm_cppsmsleeptime_print(u32 gsm_sleetime, u32 ps_sleetime)
{
	#ifdef CONFIG_CPU_IDLE
	#ifndef CONFIG_ARCH_ZX297520V3_CAP
	printk("\n gsmsleep: %u;  pssleep:%u \n ", gsm_sleetime, ps_sleetime);	
	#endif
	#endif
}
EXPORT_SYMBOL(pm_cppsmsleeptime_print);

u32 print_cnt=0;

void pm_idle_sram_print(void)
{
#ifdef CONFIG_ZX_RAM_CONSOLE
	int i;

	if((print_cnt++) % 1 == 0) {
		for(i=0; i<pm_idle_sram_cur_item; i++)
		{
			printk("%s", pm_idle_sram_buf[i].buf);
		}

		pm_idle_sram_cur_item = 0;
	}	
#endif	
}

/**
 * usage: like printk(...)
 */
void pm_printk(const char *fmt, ...)
{
#ifdef CONFIG_ZX_RAM_CONSOLE
	va_list args;
	unsigned long long t;
	unsigned long nanosec_rem;	
	int tlen, len;
	char pm_sram_temp_buf[512] = {0};
	
	if(!pm_sram_inited)
		return;
	
	va_start(args, fmt);
	preempt_disable();

	/* add time stamp */
	t = cpu_clock(read_cpuid());
	nanosec_rem = do_div(t, 1000000000);
	tlen = sprintf(pm_sram_temp_buf, ">%5lu.%06lu< ",
		       (unsigned long) t, nanosec_rem / 1000);
	
	len = vsprintf(pm_sram_temp_buf+tlen, fmt, args);
	len += tlen;

	pm_sram_cpy(pm_sram_temp_buf, len);
	pm_idle_sram_cpy(pm_sram_temp_buf, len);

	preempt_enable();
	va_end(args);
#endif
}

void pm_sram_init(void)
{
#ifdef CONFIG_ZX_RAM_CONSOLE
    pr_info("[SLP] Power/SRAM_INIT \n");

	pm_sram_printk_buf[0] = 0;
	pm_sram_point = 0;

	pm_sram_inited = 1;
#endif
}

/*********************************************************************
 * some pm debug functions
 *
 * we use sysfs interface
 ********************************************************************/
#ifdef CONFIG_ZX_PM_DEBUG

static void pm_debug_timer_expired(unsigned long data)
{
	mod_timer(&pm_debug_timer, jiffies + msecs_to_jiffies(6*1000));
	
	pr_info("[SLP] pm timer !!!");	
}


/*=============================================================================
 *========  /sys/zte_pm/state =================================================
 *=============================================================================
 */
 
/**
 *  put the string to the buf, and return the string length 	
 */
static ssize_t state_show(struct kobject *kobj, struct kobj_attribute *attr,
			  char *buf)
{
	char *s = buf;

	s += sprintf(s, "%s\n", "[SLP] no debug info now!");	

	return (s - buf);
}

/**
 *  the buf store the input string , n is the string length 
 *  return the status
 */
static ssize_t state_store(struct kobject *kobj, struct kobj_attribute *attr,
			   const char *buf, size_t n)
{
	int error = 0;

//	zDrvRpMsg_CreateChannel(M0_ID, channel_1, 0x20);

	return error;
}

zte_pm_attr(state);

/*=============================================================================
 *========  /sys/zte_pm/cpufreq =================================================
 *=============================================================================
 */
 
/**
 *  put the string to the buf, and return the string length 	
 */
 extern void debug_cpu_freq_info(void);
/* usage: "cat cpufreq" */
static ssize_t cpufreq_show(struct kobject *kobj, struct kobj_attribute *attr,
			  char *buf)
{
	char *s = buf;

//	s += sprintf(s, "%s\n", "[SLP] cpufreq debug !");	
#ifdef CONFIG_CPU_FREQ
	debug_cpu_freq_info();
#endif

	return (s - buf);
}

/**
 *  the buf store the input string , n is the string length 
 *  return the status
 */
static ssize_t cpufreq_store(struct kobject *kobj, struct kobj_attribute *attr,
			   const char *buf, size_t n)
{
	int error = 0;
		
	return error ;
}

zte_pm_attr(cpufreq);


static ssize_t cap_state_show(struct kobject *kobj, struct kobj_attribute *attr,
			  char *buf)
{
	char *s = buf;
	int sta=0;
	sta= pcu_CoreIsActive(CPU_AP);
	s += sprintf(s, "%d\n",  sta);	

	return (s - buf);
}

/**
 *  the buf store the input string , n is the string length 
 *  return the status
 */
static ssize_t cap_state_store(struct kobject *kobj, struct kobj_attribute *attr,
			   const char *buf, size_t n)
{
	int error = 0;
		
	return error ;
}

zte_pm_attr(cap_state);

/*=============================================================================
 *========  /sys/zte_pm/debug_work  ===========================================
 *=============================================================================
 */
#if 0 
static unsigned test_item = 0;
static void pm_test_switch_clock(void)
{
	printk("[SLP] pm_test_switch_clock: %d \n\r", test_item);

	switch(test_item)
	{
	case 0:	/* ufi 400M */
		cpufreq_test(1, 0);

		break;
	case 1: /* ufi 800M */
		cpufreq_test(0, 1);
		break;
	case 2: /* 624 624M */
		cpufreq_test(1, 2);		
		break;
	case 3: /* 624 156M */
		cpufreq_test(2, 3);				
		break;
	case 4: /* main 26M */	
		cpufreq_test(3, 4);		
		test_item = 0;
		return;
		break;
	}
	
	test_item ++;
}
#endif

static void pm_debug_func(struct work_struct *work)
{
	printk("[SLP] runs in %s. \n\r", __func__);

	pm_suspend(PM_SUSPEND_MEM);
//	pm_test_switch_clock();

	schedule_delayed_work(&pm_debug_work, PM_DEBUG_DELAY);
}

static ssize_t pm_debug_show(struct kobject *kobj, struct kobj_attribute *attr,
			  char *buf)
{
	char *s = buf;

	s += sprintf(s, "%s\n", "[SLP] pm debug !");	

	return (s - buf);
}

/* usage: "echo 1 > pm_debug" */
static ssize_t pm_debug_store(struct kobject *kobj, struct kobj_attribute *attr,
			   const char *buf, size_t n)
{
	int error = 0;
	long temp;	

	if(strict_strtol(buf, 0, &temp))
		error = -EINVAL;

	if(temp == 1)
		schedule_delayed_work(&pm_debug_work, PM_DEBUG_DELAY);
	else
		cancel_delayed_work(&pm_debug_work);
		
	return error ? error : n;
}

zte_pm_attr(pm_debug);

/*=============================================================================
 *========  /sys/zte_pm/wakelock  =============================================
 *=============================================================================
 */
extern void test_wakelock(void);
//extern void pm_debug_wakelocks(void);
static ssize_t wakelock_show(struct kobject *kobj, struct kobj_attribute *attr,
			  char *buf)
{
	char *s = buf;

	pm_debug_wakelocks();	

	return (s - buf);
}

static ssize_t wakelock_store(struct kobject *kobj, struct kobj_attribute *attr,
			   const char *buf, size_t n)
{
	int error = 0;
	
#ifdef CONFIG_ZX_PM_SUSPEND
	test_wakelock();
#endif
		
	return error ;
}

zte_pm_attr(wakelock);

#ifdef CONFIG_ZX_AUTOSLEEP
/*=============================================================================
 *========  /sys/zte_pm/app_done  =============================================
 *=============================================================================
 */
extern void app_start_done(void);
static ssize_t app_done_show(struct kobject *kobj, struct kobj_attribute *attr,
			  char *buf)
{
	char *s = buf;

	return (s - buf);
}

static ssize_t app_done_store(struct kobject *kobj, struct kobj_attribute *attr,
			   const char *buf, size_t n)
{
	int error = 0;
	
	app_start_done();
		
	return error;
}

zte_pm_attr(app_done);
#endif

static struct attribute * g[] = 
{
	&state_attr.attr,
	&pm_debug_attr.attr,
	&wakelock_attr.attr,
#ifdef CONFIG_ZX_AUTOSLEEP
	&app_done_attr.attr,	
#endif	
	&cpufreq_attr.attr,
	&cap_state_attr.attr,
	
	NULL,
};


static struct attribute_group zte_pm_attr_group = 
{
	.attrs = g,
};


/**
 *  1create sysfs "/sys/zte_pm" 
 *  2add attr 
 */
static int __init pm_debug_init(void)
{
	int ret;
	
    printk(KERN_INFO "[SLP] create sysfs interface\n");
	pm_debug_kobj = kobject_create_and_add("zte_pm", NULL);
	if (!pm_debug_kobj)
		return -ENOMEM;	
    ret = sysfs_create_group(pm_debug_kobj, &zte_pm_attr_group);
    if (ret)
    {
        printk(KERN_WARNING "[SLP] sysfs_create_group ret %d\n", ret);	
		return ret;
    }

	/* init delayed work */
	INIT_DELAYED_WORK_DEFERRABLE(&pm_debug_work, pm_debug_func);
	/* we will start this in sysfs */
//	schedule_delayed_work(&pm_debug_work, PM_DEBUG_DELAY);

	setup_timer(&pm_debug_timer, pm_debug_timer_expired, 0);
//	mod_timer(&pm_debug_timer, jiffies + msecs_to_jiffies(6*1000));

#ifdef CONFIG_CPU_IDLE
	/* cpuidle debug init */
	idle_debug_init();
#endif

	pm_debug_mask_info_init();

	return 0;
}

#endif


static int zx_pm_pre_idle_notifier(struct notifier_block *nb,
					     unsigned long val,
					     void *data)
{
	switch (val) {
	case IDLE_START:
		#ifndef CONFIG_SYSTEM_RECOVERY
		#ifndef CONFIG_ARCH_ZX297520V3_CAP
			#ifdef USE_CPPS_KO
			if(cpps_callbacks.psm_ModemDevSleep)
				CPPS_FUNC(cpps_callbacks,psm_ModemDevSleep)();
			#else
			psm_ModemDevSleep();
			#endif
		#endif
		#endif
		break;
	case IDLE_END:
		break;
	}

	return 0;
}

static struct notifier_block zx_pm_pre__idle_nb = {
	.notifier_call = zx_pm_pre_idle_notifier,
};



		
/*********************************************************************
 * FUNCTION DEFINATIONS
 ********************************************************************/
#if 0//defined(CONFIG_ARCH_ZX297520V2EVB)
static int __init zx_pm_init(void)
{
    return 0;
}
#else
static int __init zx_pm_init(void)
{
    pr_info("[SLP] Power/PM_INIT \n");

#ifdef	CONFIG_PM_SLEEP
    /* 1Suspend driver */
    zx_suspend_init();
#endif

#if 0 //added when debug	 
	/* 2power domain initial */
	zx_pwr_init();
#endif

	/* 3context memory initial */
	zx_pm_context_init();

    /* 4SCU/l2 lowerpower setting */
	pm_init_l2_and_scu(); /*20V5 A53 dont't need set l2,becasue l2 is ARM internal */


    /* 5acs */
	//pm_init_acs();
	
	/* 6init the ram log for pm */
	pm_sram_init();

#ifdef CONFIG_ZX_PM_DEBUG
	pm_debug_init();
#endif

#ifdef CONFIG_CPU_IDLE
    /* 7idle driver initial */
	zx_cpuidle_init();
#ifdef CONFIG_ZX_RAM_CONSOLE 
#ifndef CONFIG_ARCH_ZX297520V3_CAP
	pm_uart_createtimer();
#endif
#endif
#endif

	idle_notifier_register(&zx_pm_pre__idle_nb);

    return 0;
}
#endif

late_initcall(zx_pm_init);

