/*******************************************************************************
 * Copyright (C) 2013, ZTE Corporation.
 *
 * File Name: icp.c
 * File Mark:
 * Description:
 * Others:
 * Version:       V0.1
 * Author:        ShiDeYou
 * Date:          2013-3-13
 * History 1:
 *     Date:
 *     Version:
 *     Author:
 *     Modification:
 * History 2:
 ******************************************************************************/
#include <linux/init.h>
#include <linux/module.h>
#include <crypto/internal/skcipher.h>
#include <linux/cpumask.h>
#include <linux/err.h>
#include <linux/init.h>
#include <linux/kernel.h>
#include <linux/delay.h>
	 
#include <linux/mm.h>
#include <linux/types.h>
#include <linux/major.h>
#include <linux/uaccess.h>
#include <linux/device.h>
	 
#include <linux/cdev.h>
#include <linux/workqueue.h>
	 
#include <linux/fs.h>
#include <mach/debug.h>
#include <linux/platform_device.h>
	 
#include <asm/irq.h>
#include <asm/setup.h>
#include <asm/io.h>
#include <asm/system.h>
	 
#include <asm/mach/arch.h>
#include <asm/mach/irq.h>
#include <asm/mach/map.h>
	 
#include <linux/soc/zte/rpm/rpmsg.h>
#include <linux/soc/zte/rpm/rpmsg_zx29.h>
#include <linux/sched.h>
#include <linux/poll.h>	 
 //unsigned int channel_size[2][2] = {{0x100,0x100},{0x100,0x100}};
#define CHANNEL_NUM 		CHANNEL_AP2PS_MAXID//CHANNEL_MAXID		//37 from voLte 

typedef struct _zx29_rpmsg_channel 
{
	T_ZDrvRpMsg_ActorID actorID;
	T_ZDrvRpMsg_ChID 	chID;
	void *				buf;
	unsigned int 		len;
}zx29_rpmsg_channel;
 
typedef struct _zx29_rpmsg_ser 
{
	struct kref 	kref;   /* Reference management */
	struct cdev 	cdev;
	struct module 	*owner;
	const char  	*driver_name;
	const char  	*name;
	int name_base;  
	int major;	  
	int minor_start;    
	int num; 		   
	int flags;	   
	int	index;
	int count;
	zx29_rpmsg_channel rpmsg_channel[CHANNEL_NUM];

	const struct file_operations *ops;
}zx29_rpmsg_ser; 
 
static int zx29_rpmsg_open(struct inode *inode, struct file *filp)
{
	dev_t device = inode->i_rdev;
	T_ZDrvRpMsg_ChID chID;
	zx29_rpmsg_ser *rpmsg_drv;

	rpmsg_drv = container_of (inode->i_cdev, zx29_rpmsg_ser, cdev);

	rpmsg_drv->count++;
	chID = (T_ZDrvRpMsg_ChID)(MINOR(device) - rpmsg_drv->minor_start);

	filp->private_data = &(rpmsg_drv->rpmsg_channel[chID]);

	return 0;
}	
 
static long zx29_rpmsg_ioctl(struct file *filp, unsigned int cmd, unsigned long arg)
{
	int ret;
	T_ZDrvRpMsg_Msg rpmsg;

	zx29_rpmsg_channel *rpmsg_channel = filp->private_data;
	rpmsg.actorID = rpmsg_channel->actorID;
	rpmsg.chID = rpmsg_channel->chID;
 
	switch(cmd)
	{
		case RPMSG_CREATE_CHANNEL:
#ifndef CONFIG_ARCH_ZX297520V3_CAP
			ret = zDrvRpMsg_CreateChannel_Cap(rpmsg.actorID, rpmsg.chID, arg);
#else
			ret = zDrvRpMsg_CreateChannel(rpmsg.actorID, rpmsg.chID, arg);
#endif
			if(ret != RPMSG_SUCCESS)
			{
	 			rpmsg_log("CreateChannel(actID=%d)(chId=%d) failed(%d). \n", rpmsg_channel->actorID, rpmsg_channel->chID, ret);			
				return -ENXIO;
			}
			break;  
		case RPMSG_GET_DATASIZE:
			ret = zDrvRpMsg_RecvCh_GetDataSize(rpmsg.actorID, rpmsg.chID);
			*(unsigned int *)arg = ret;
			break;
		case RPMSG_SET_INT:
			zDrvIcp_SetInt(rpmsg.actorID, rpmsg.chID);
			break;
		case RPMSG_SET_INT_FLAG:
			icp_rpmsg_setchIntflag(rpmsg.actorID, rpmsg.chID, 1);
			break;
		case RPMSG_CLEAR_INT_FLAG:
			icp_rpmsg_setchIntflag(rpmsg.actorID, rpmsg.chID, 0);
			break;
		case RPMSG_SET_POLL_FLAG:
			icp_rpmsg_setchpollflag(rpmsg.actorID, rpmsg.chID, 1);
			break;
		case RPMSG_CLEAR_POLL_FLAG:
			icp_rpmsg_setchpollflag(rpmsg.actorID, rpmsg.chID, 0);
			break;
			 
		default:
			return -EPERM;
		}
	
	return 0;
}
 
static ssize_t zx29_rpmsg_write(struct file *filp, const char __user *ubuf,
						   size_t len, loff_t *ppos) 
{
	int ret;
	unsigned int flag;
	T_ZDrvRpMsg_Msg rpmsg;
	 
	zx29_rpmsg_channel *rpmsg_channel = filp->private_data;  
	rpmsg.actorID = rpmsg_channel->actorID;
	rpmsg.chID = rpmsg_channel->chID;
	rpmsg.len = len;
	rpmsg.flag = 0;
	 
	rpmsg.buf = kmalloc(len, GFP_KERNEL);
	if(rpmsg.buf == NULL)
	{
		rpmsg_log("zx29_rpmsg_write1 kmalloc failed\n");
		return 0;
	}
	
	ret = copy_from_user(rpmsg.buf, ubuf, len);
 
	if (ret<0)
	{
	 	rpmsg_log("zx29_rpmsg_write1(actID=%d)(chId=%d) len=%d failed(%d). \n", rpmsg_channel->actorID, rpmsg_channel->chID, len, ret);
		kfree(rpmsg.buf);
		return -EFAULT;
	}
	flag = icp_rpmsg_getchflag(rpmsg.actorID, rpmsg.chID);
	if(flag&CHANNEL_INT_FLAG)
		rpmsg.flag |= RPMSG_WRITE_INT;

#ifndef CONFIG_ARCH_ZX297520V3_CAP		 
	ret = zDrvRpMsg_Write_Cap(&rpmsg);
#else
	ret = zDrvRpMsg_Write(&rpmsg);
#endif
	kfree(rpmsg.buf);
	  
	if(ret<0)
	{
	 	rpmsg_log("zx29_rpmsg_write2(actID=%d)(chId=%d) len=%d failed(%d). \n", rpmsg_channel->actorID, rpmsg_channel->chID, len, ret);	
		return 0;
	}
 
	return len;	 
}

static ssize_t zx29_rpmsg_read(struct file *filp, char __user *ubuf,
						 size_t len, loff_t *offp)
{
	unsigned int size;
	int ret;
	unsigned int flag;
	T_ZDrvRpMsg_Msg rpmsg;

	zx29_rpmsg_channel *rpmsg_channel = filp->private_data;
	rpmsg.actorID = rpmsg_channel->actorID;
	rpmsg.chID = rpmsg_channel->chID;
	rpmsg.len = len;
	rpmsg.flag = 0;

	rpmsg.buf = kmalloc(len, GFP_KERNEL);
	if(rpmsg.buf == NULL)
	{
		rpmsg_log("zx29_rpmsg_read1 kmalloc failed\n");
		return 0;
	}
	  	
	flag = icp_rpmsg_getchflag(rpmsg.actorID, rpmsg.chID);
	if(flag&CHANENL_POLL_FLAG)
		rpmsg.flag |= RPMSG_READ_POLL;

#ifndef CONFIG_ARCH_ZX297520V3_CAP	 
	ret = zDrvRpMsg_Read_Cap(&rpmsg);
#else
	ret = zDrvRpMsg_Read(&rpmsg);
#endif
	if(ret<0)
	{
		rpmsg_log("zx29_rpmsg_read1(actID=%d)(chId=%d) len=%d failed(%d). \n", rpmsg_channel->actorID, rpmsg_channel->chID, len, ret);
		kfree(rpmsg.buf);
		return 0;
	}
	else
		size = ret;
		  
	ret = copy_to_user(ubuf, rpmsg.buf, size);
	kfree(rpmsg.buf);
	if (ret<0) 
	{
		rpmsg_log("zx29_rpmsg_read2(actID=%d)(chId=%d) len=%d failed(%d). \n", rpmsg_channel->actorID, rpmsg_channel->chID, len, ret);	 
		return -EFAULT;
	}

	return size;
}

extern bool halRpMsg_IsRecvChEmpty(T_ZDrvRpMsg_ActorID actorID, T_ZDrvRpMsg_ChID chID);
extern wait_queue_head_t *icp_rpmsg_get_waitq(T_ZDrvRpMsg_ActorID actorID, T_ZDrvRpMsg_ChID chID);
static unsigned int zx29_rpmsg_poll(struct file *file,
				    struct poll_table_struct *wait)
{
	
	zx29_rpmsg_channel *rpmsg_channel = file->private_data;
	   
	poll_wait(file, icp_rpmsg_get_waitq(rpmsg_channel->actorID, rpmsg_channel->chID), wait);

	if (halRpMsg_IsRecvChEmpty(rpmsg_channel->actorID, rpmsg_channel->chID) != TRUE)
		return POLLIN | POLLRDNORM;

	return 0;
}
 
int zx29_rpmsg_release(struct inode *inode, struct file *filp)
{	 
	filp->private_data = NULL;

	return 0;
}
 
static const struct file_operations	rpmsg_zx29_ops = {
	.owner 		= THIS_MODULE,
	.open 		= zx29_rpmsg_open,
	.release 	= zx29_rpmsg_release,
	.write 		= zx29_rpmsg_write,
	.read 		= zx29_rpmsg_read,
	.unlocked_ioctl = zx29_rpmsg_ioctl,
	.poll=zx29_rpmsg_poll,
};
   
struct class *rpmsg_classes;

zx29_rpmsg_ser rpmsg_zx29 = {
	.owner   		= THIS_MODULE,
	.driver_name 	= "armps_rpmsg",
	.name	   		= "rpmsg",	//ps_rpmsgch
	.major   		= 0,
	.minor_start 	= 30,
	.num 			= CHANNEL_NUM,
};

struct device *zx29_rpmsg_register_device(struct class *rpmsg_class, zx29_rpmsg_ser *driver, unsigned index,
				struct device *device)
{
	char name[64];
	dev_t dev = MKDEV(driver->major, driver->minor_start) + index;

	if (index >= driver->num) {
		return ERR_PTR(-EINVAL);
	}
 
	sprintf(name, "%s%d", driver->name, index);

	return device_create(rpmsg_class, device, dev, NULL, name);
}

static int zx29_rpmsg_probe(struct device *rpdev)
{
	int error;
	int i;
	dev_t dev;
	zx29_rpmsg_ser *rpmsg_ser ;
	
	rpmsg_ser = &rpmsg_zx29;
	
	rpmsg_ser->ops = &rpmsg_zx29_ops;
	rpmsg_ser->count = 0;
//	rpmsg_ser->rpmsg_channel.actorID = rpdev->id;

	error = alloc_chrdev_region(&dev, rpmsg_ser->minor_start,
					rpmsg_ser->num, rpmsg_ser->name);
	if (!error) {
		rpmsg_ser->major = MAJOR(dev);
		rpmsg_ser->minor_start = MINOR(dev);
	}

	cdev_init(&rpmsg_ser->cdev, &rpmsg_zx29_ops);
	rpmsg_ser->cdev.owner = rpmsg_ser->owner;

	error = cdev_add(&rpmsg_ser->cdev, dev, rpmsg_ser->num);
	if (error) {
		unregister_chrdev_region(dev, rpmsg_ser->num);
		return error;
	}
		
	for (i = 0; i < rpmsg_ser->num; i++) {
		rpmsg_ser->rpmsg_channel[i].actorID = rpdev->id;
		rpmsg_ser->rpmsg_channel[i].chID = channel_0 + i;
		zx29_rpmsg_register_device(rpmsg_classes, rpmsg_ser, i, NULL);
	}

	return 0;
}

static struct device_attribute rpmsg_zx29_dev_attrs[] = {
	__ATTR_NULL,
};

struct bus_type icp_rpmsg_bus = {
	.name = "rpmsg_zx29",
	.dev_attrs	= rpmsg_zx29_dev_attrs,
};

static struct device_driver rpmsg_zx29_drv={
	.name = "icp_rpmsg1",
	.owner = THIS_MODULE,
	.bus= &icp_rpmsg_bus,
	.probe = zx29_rpmsg_probe,
};

void zx29_rpmsg_unregister_device(struct class *rpmsg_class, zx29_rpmsg_ser *driver, unsigned index)
{
	dev_t dev = MKDEV(driver->major, driver->minor_start) + index;

	device_destroy(rpmsg_class, dev);
}

int icp_rpmsg_device_register(Icp_rpmsg_drv *icp_rpmsg)
{
	int ret;
	
	ret =  bus_register(&icp_rpmsg_bus);
	if (ret)
		return ret;
	
	icp_rpmsg->dev.bus = &icp_rpmsg_bus;
	dev_set_name(&icp_rpmsg->dev, "icp_rpmsg%d", icp_rpmsg->actorID);
	ret = device_register(&icp_rpmsg->dev);

	return ret;
}
 
static int __init zx29_rpmsg_init(void)
{
	int ret = 0;
	rpmsg_classes = class_create(THIS_MODULE, rpmsg_zx29.name);

	if (IS_ERR(rpmsg_classes))
		return PTR_ERR(rpmsg_classes);

	ret = driver_register(&rpmsg_zx29_drv);
	if(ret < 0)
		printk("rpmsg_zx29 init failed!");

	rpmsg_sram_init();

	return ret;
}

static void __exit zx29_rpmsg_exit(void)
{
	int i;
	zx29_rpmsg_ser *rpmsg_ser;
	rpmsg_ser = &rpmsg_zx29;
	
	for (i = 0; i < rpmsg_ser->num; i++) {
		zx29_rpmsg_unregister_device(rpmsg_classes, rpmsg_ser, i);
	}
	
	class_destroy(rpmsg_classes);
}

module_init(zx29_rpmsg_init);
module_exit(zx29_rpmsg_exit);

MODULE_AUTHOR("zte");
MODULE_DESCRIPTION("zte rpmsg driver");
MODULE_LICENSE("GPL");
MODULE_ALIAS("platform: rpmsg");
 
