/* * Copyright (c) 2011 Qualcomm Atheros, Inc. * */

#include <linux/in.h>
#include <linux/ip.h>
#include <linux/udp.h>
#include <linux/tcp.h>
#include <linux/icmp.h>
#include <net/ip.h>
#include <linux/if_arp.h>

#include <linux/inetdevice.h>
#include <linux/netfilter.h>
#include <linux/netfilter_ipv4.h>
#include <linux/netfilter_arp.h>
#include <linux/netfilter_ipv4/ip_tables.h>
#include <linux/netfilter/xt_multiport.h>
#include <linux/netfilter/xt_iprange.h>
#include <linux/netfilter/nf_conntrack_tcp.h>
#include <net/checksum.h>
#include <net/dsfield.h>
#include <net/route.h>
#include <net/netfilter/nf_nat.h>
#include <net/netfilter/nf_nat_core.h>
#include <net/netfilter/nf_nat_rule.h>
#include <net/netfilter/nf_conntrack_helper.h>
#include <linux/module.h>

#include <linux/proc_fs.h>

MODULE_LICENSE("GPL");

/* ******************************* ˵ ******************************* */
//ping¼ʱӹ
int net_debug_ping = 0;

//tcp/udp¼ʱӹܣҪserverܰװӦ
int net_debug_perf = 0;

//Ӧ֧һݼ¼32
typedef enum {
    //pcʹ÷Χ0~31
    LABEL_NULL = 0,
    
	CLINET_RECV,
	CLINET_SEND,
	SERVER_RECV,
	SERVER_SEND,
	
	//AP32ʼͬĺ˲òͬݶζ,32~63
	AP_USB_IN = 32,
	AP_USB_OUT,
	AP_PS_IN,
	AP_PS_OUT,
    AP_WIFI_WAN_IN,
	AP_WIFI_WAN_OUT,
    AP_WIFI_LAN_IN,
	AP_WIFI_LAN_OUT,
	AP_ETH_WAN_IN,
	AP_ETH_WAN_OUT,
	AP_ETH_LAN_IN,
	AP_ETH_LAN_OUT,
	AP_PS_EXT1_IN,
	AP_PS_EXT1_OUT,
	AP_PS_EXT2_IN,
	AP_PS_EXT2_OUT,
	AP_PS_EXT3_IN,
	AP_PS_EXT3_OUT,
	AP_PS_EXT4_IN,
	AP_PS_EXT4_OUT,

    //CP64ʼ.64~95
	CP_ETH1_IN = 64,   
	CP_ETH1_OUT,
	CP_ETH2_IN,
	CP_ETH2_OUT,
	CP_ETH3_IN,
	CP_ETH3_OUT,
	CP_ETH4_IN,
	CP_ETH4_OUT,
	CP_PS1_IN,
	CP_PS1_OUT,
	CP_PS2_IN,
	CP_PS2_OUT,
	CP_PS3_IN,
	CP_PS3_OUT,
	CP_PS4_IN,
	CP_PS4_OUT,
	CP_CTRM1_IN,
	CP_CTRM1_OUT,
	CP_CTRM2_IN,
	CP_CTRM2_OUT,
	CP_CTRM3_IN,
	CP_CTRM3_OUT,
	CP_CTRM4_IN,
	CP_CTRM4_OUT,
	LABEL_MAX,
} zping_label;

typedef enum {
    PACKET_IN  = 0,
    PACKET_OUT,
} zping_pos;

#pragma pack(push)
#pragma pack(1)


typedef struct // 4 bytes align
{
	u_int16_t id; // useless in this case, use id in the icmp header instead
	u_int16_t item_count;
	u_int16_t item_index;
	u_int16_t item_index_padding;
	u_int16_t flags;
	u_int16_t flags_padding;
} zping_hdr_t;

typedef struct // 4 bytes align
{
	u_int16_t label;
    u_int16_t label_padding;
    
	u_int32_t secs;
    u_int32_t secs_padding;
    
	u_int32_t usecs;
	u_int32_t usecs_padding;

    u_int16_t last_seq;
    u_int16_t last_seq_padding;
} zping_item_t;

typedef struct // 4 bytes align
{
	u_int16_t label;
    u_int16_t label_padding;

    u_int16_t last_seq;
    u_int16_t last_seq_padding;
} zping_pktlost_item_t;


typedef struct // 4 bytes align
{
	u_int16_t id;
	u_int16_t item_count;
	u_int16_t item_index;
	u_int16_t item_index_padding;
	u_int16_t flags;
	u_int16_t flags_padding;

	// char *items;
} zperf_hdr_t;

typedef struct // 4 bytes align
{
	u_int32_t label;
	u_int32_t secs;
	u_int32_t usecs;

	u_int32_t label_padding;
	u_int32_t secs_padding;
	u_int32_t usecs_padding;
} zperf_item_t;

#pragma pack(pop)

#define ZPING_EXCLUDE 0x01

u_int16_t last_seqs[LABEL_MAX] = {0};

#define ZXICP_EXCLUDE 0x01

//óʼnetdog -sԶ̬
net_dbg_dev_info_t net_dbg_dev_info = {"usblan0", "wan1", "wlan0-vxd", "wlan0-va0", 
                   "sw0.200", "sw0.100", "usblan0", "usblan1", "usblan2", "usblan3"};

/* ********************************  ********************************/


/* ******************************** ʵ ********************************/
static int get_dev_label_by_name(char* node_str, int pos)
{
    if (!node_str)
    {
        printk("net_debug get dev NULL \n");
        return -1;
    }
    
    //ֶ֧usb
	if (!strncmp(node_str, net_dbg_dev_info.usb, strlen(node_str)))
    {
        if (PACKET_IN == pos)
		    return AP_USB_IN;
        else if (PACKET_OUT == pos)
		    return AP_USB_OUT;
    }

    //ֶ֧
	if (!strncmp(node_str, net_dbg_dev_info.ps, strlen(node_str)))
	{
        if (PACKET_IN == pos)
		    return AP_PS_IN;
        else if (PACKET_OUT == pos)
		    return AP_PS_OUT;
    }
    
	if (!strncmp(node_str, net_dbg_dev_info.wifi_wan, strlen(node_str)))
    {
        if (PACKET_IN == pos)
		    return AP_WIFI_WAN_IN;
        else if (PACKET_OUT == pos)
		    return AP_WIFI_WAN_OUT;
    }
    
	if (!strncmp(node_str, net_dbg_dev_info.wifi_lan, strlen(node_str)))
    {
        if (PACKET_IN == pos)
		    return AP_WIFI_LAN_IN;
        else if (PACKET_OUT == pos)
		    return AP_WIFI_LAN_OUT;
    }

	if (!strncmp(node_str, net_dbg_dev_info.eth_wan, strlen(node_str)))
	{
        if (PACKET_IN == pos)
		    return AP_ETH_WAN_IN;
        else if (PACKET_OUT == pos)
		    return AP_ETH_WAN_OUT;
    }

	if (!strncmp(node_str, net_dbg_dev_info.eth_lan, strlen(node_str)))
	{
        if (PACKET_IN == pos)
		    return AP_ETH_LAN_IN;
        else if (PACKET_OUT == pos)
		    return AP_ETH_LAN_OUT;
    }

	if (!strncmp(node_str, net_dbg_dev_info.ps_ext1, strlen(node_str)))
	{
        if (PACKET_IN == pos)
		    return AP_PS_EXT1_IN;
        else if (PACKET_OUT == pos)
		    return AP_PS_EXT1_OUT;
    }

	if (!strncmp(node_str, net_dbg_dev_info.ps_ext2, strlen(node_str)))
	{
        if (PACKET_IN == pos)
		    return AP_PS_EXT2_IN;
        else if (PACKET_OUT == pos)
		    return AP_PS_EXT2_OUT;
    }

	if (!strncmp(node_str, net_dbg_dev_info.ps_ext3, strlen(node_str)))
	{
        if (PACKET_IN == pos)
		    return AP_PS_EXT3_IN;
        else if (PACKET_OUT == pos)
		    return AP_PS_EXT3_OUT;
    }

	if (!strncmp(node_str, net_dbg_dev_info.ps_ext4, strlen(node_str)))
	{
        if (PACKET_IN == pos)
		    return AP_PS_EXT4_IN;
        else if (PACKET_OUT == pos)
		    return AP_PS_EXT4_OUT;
    }

	return -1;
}

/*ȡIPv4 skb ipͷָ룬Ҫͷ*/
static char *get_skb_iphdr(struct sk_buff *skb)
{
    unsigned int old_len = skb->len;
    unsigned char * old_data = skb->data;
    __be16 old_pro = skb->protocol;
    
    __be16 next_pro = skb->protocol;
    struct ethhdr *eth;
    char *iphdr = NULL;

    if (skb->mac_header != NULL)
        eth = (struct ethhdr *)skb->mac_header;
    else
        eth = (struct ethhdr *)skb->data;

    skb->data = (struct iphdr *)((char *)eth + ETH_HLEN);
    
again:
    if (next_pro == htons(ETH_P_IP) || next_pro == htons(ETH_P_IPV6))
    {
        iphdr = skb->data;
        goto out;
    }
    //vlan
    else if (next_pro == cpu_to_be16(ETH_P_8021Q))
    {
        skb_pull(skb, VLAN_HLEN);
        next_pro = *((__be16 *)(skb->data - 2));
        goto again;
    }
    //pppoe 
    else if (next_pro == htons(ETH_P_PPP_SES))
    {
        if (*(skb->data + 6) == 0x00 && (*(skb->data + 7) == 0x21 || *(skb->data + 7) == 0x57))
        {
            next_pro = htons(ETH_P_IP);
            __skb_pull(skb, PPPOE_HEADER_LEN);
            goto again;
        }
    }

out:
    skb->protocol = old_pro;
    skb->data = old_data;
    skb->len = old_len;
    return iphdr;
}

/* ***************** pingʱ¼**************** */
int get_current_item_index_zping(char *buffer)
{
	zping_hdr_t *zping_hdr = (zping_hdr_t*)buffer;
	return zping_hdr->item_index;
}

u_int16_t get_last_seq(u_int32_t label)
{
    return last_seqs[label];
}

int set_last_seq(u_int32_t label, u_int16_t seq)
{
    last_seqs[label] = seq;
    return 1;
}

//ӼĴȡʱԱapcpʱ׼ͬ
extern u64 read_persistent_us(void);
void get_uniform_time(unsigned long * sec ,unsigned long * usec )
{
	unsigned long long time_usec = read_persistent_us();
	*usec = (unsigned long)time_usec;
	*sec = (unsigned long)((unsigned long)time_usec/1000000);
}

int set_zping_item(char *buffer, int index, u_int16_t seq, u_int32_t label)
{
    struct timeval tv;
	zping_hdr_t *zping_hdr = (zping_hdr_t*)buffer;
	
	zping_pktlost_item_t *zping_pkylost_item;
	zping_item_t *zping_item;
	
    if(zping_hdr->id == 0){
		//ģʽ
        zping_pkylost_item = (zping_pktlost_item_t *)(buffer + sizeof(zping_hdr_t) 
            + sizeof(zping_pktlost_item_t) * (index - 1));
        zping_pkylost_item->label = label;
	    zping_pkylost_item->label_padding = zping_pkylost_item->label_padding - zping_pkylost_item->label;
        zping_pkylost_item->last_seq = get_last_seq(label);
        zping_pkylost_item->last_seq_padding -= zping_pkylost_item->last_seq;
    }else{
    	//ʱģʽ
        zping_item = (zping_item_t *)(buffer + sizeof(zping_hdr_t) 
            + sizeof(zping_item_t) * (index - 1));
        zping_item->label = label;
	    zping_item->label_padding = zping_item->label_padding - zping_item->label;

	    get_uniform_time(&zping_item->secs,&zping_item->usecs);
	    //zping_item->secs = tv.tv_sec;
	    //zping_item->usecs = tv.tv_usec;

        zping_item->secs_padding = zping_item->secs_padding - zping_item->secs;
	    zping_item->usecs_padding = zping_item->usecs_padding - zping_item->usecs;
    
        zping_item->last_seq = get_last_seq(label);
        zping_item->last_seq_padding -= zping_item->last_seq;
    }
	
	zping_hdr->item_index++;
    zping_hdr->item_index_padding--;
	
    set_last_seq(label, seq);

	return 1;
}

char *zping_validate(struct sk_buff *skb, u_int16_t *seq)
{
    struct ethhdr *eth;
    struct iphdr *iph;
    struct icmphdr *icmph;
    zping_hdr_t *zping_hdr;
    int item_size = 0;

    if (skb == NULL)
        return NULL;

    if (skb->mac_header != NULL)
        eth = (struct ethhdr *)skb->mac_header;
    else
        eth = (struct ethhdr *)skb->data;

#if 0
    if (ntohs(eth->h_proto) != ETH_P_IP)
    {
        return NULL;
    }
    
    iph = (struct iphdr *)((char *)eth + ETH_HLEN);
#else
    iph = (struct iphdr *)get_skb_iphdr(skb);
    if (!iph)
        return NULL;
#endif

    if (iph->frag_off & htons(IP_OFFSET))
		return NULL;

    if (iph->protocol != IPPROTO_ICMP)
    {
        return NULL;
    }

    icmph = (struct icmphdr *)((char *)iph + iph->ihl * 4);
    
    if (icmph->type != ICMP_ECHO && icmph->type != ICMP_ECHOREPLY)
        return NULL;

    //debugĹ̶0x7777ĶĻҪӦһ
    /*
    if (ntohs(icmph->un.echo.id) != 0x7777)
    {
        return NULL;
    }*/

    zping_hdr = (zping_hdr_t*)((char *)icmph + 8);
    item_size = zping_hdr->id == 0? sizeof(zping_pktlost_item_t):sizeof(zping_item_t);
    
    // Ҫпռ洢4item
    if (ntohs(iph->tot_len) - iph->ihl * 4 - 8 < item_size * 4 + sizeof(zping_hdr_t))
    {
        return NULL;
    }

    if (ntohs(zping_hdr->flags) & ZPING_EXCLUDE)
    {
        return NULL;
    }

    if (ntohs(iph->tot_len) - iph->ihl * 4 - 8 < 
        item_size * zping_hdr->item_count + sizeof(zping_hdr_t))
    {
        return NULL;
    }

    *seq = ntohs(icmph->un.echo.sequence);
    return (char *)icmph + 8;
}

/**********************************************/
//input:
//		packet_addr: ׵ַݽṹַ
//		node_str:      ڱʶ·ڵַ豸
/**********************************************/
void net_dbg_ping_dev_recv(char * packet_addr,char* node_str)
{
    int item_index;
    char *data;
    u_int16_t seq;
    int label = -1;

    if (!net_debug_ping)
        return;
    //dataָicmpݶͷzping_hdr
    if ((data = zping_validate(packet_addr, &seq)) == NULL)
        return;
	//ȡڵid
    if ((label = get_dev_label_by_name(node_str, PACKET_IN)) == -1)
        return;
	//ȡ¼ǰڵϢindex
    item_index = get_current_item_index_zping(data);
	//ýڵϢ
    set_zping_item(data, item_index + 1, seq, label);
}

void net_dbg_ping_dev_send(char * packet_addr,char* node_str)
{
    int item_index;
    char *data;
    u_int16_t seq;
    int label = -1;

    if (!net_debug_ping)
        return;

    if ((data = zping_validate(packet_addr, &seq)) == NULL)
        return;

    if ((label = get_dev_label_by_name(node_str, PACKET_OUT)) == -1)
        return;

    item_index = get_current_item_index_zping(data);
    set_zping_item(data, item_index + 1, seq, label);
}

/* ***************** perfʱ¼**************** */
int get_current_item_index(char *buffer)
{
	zperf_hdr_t *zperf_hdr = (zperf_hdr_t*)buffer;
	return zperf_hdr->item_index;
}

int set_zperf_item(char *buffer, int index, u_int32_t label)
{
    struct timeval tv;
	zperf_hdr_t *zperf_hdr = (zperf_hdr_t*)buffer;
	
	zperf_item_t *zperf_item = (zperf_item_t *)(buffer + sizeof(zperf_hdr_t) + sizeof(zperf_item_t) * (index - 1));
	zperf_item->label = label;
	zperf_item->label_padding = zperf_item->label_padding - zperf_item->label;

	zperf_hdr->item_index++;
    zperf_hdr->item_index_padding--;

	do_gettimeofday(&tv);
	zperf_item->secs = tv.tv_sec;
	zperf_item->usecs = tv.tv_usec;

    zperf_item->secs_padding = zperf_item->secs_padding - zperf_item->secs;
	zperf_item->usecs_padding = zperf_item->usecs_padding - zperf_item->usecs;

	return 1;
}

char *zperf_validate(struct sk_buff *skb)
{
    struct ethhdr *eth;
    struct iphdr *iph;
    struct tcphdr *tcph;
    zperf_hdr_t *zperf_hdr;

    if (skb == NULL)
        return NULL;

    if (skb->mac_header != NULL)
        eth = (struct ethhdr *)skb->mac_header;
    else
        eth = (struct ethhdr *)skb->data;

#if 0
    if (ntohs(eth->h_proto) != ETH_P_IP)
    {
        return NULL;
    }
    
    iph = (struct iphdr *)((char *)eth + ETH_HLEN);
#else
    iph = (struct iphdr *)get_skb_iphdr(skb);
    if (!iph)
        return NULL;
#endif

    if (iph->frag_off & htons(IP_OFFSET))
		return NULL;

    if (iph->protocol != IPPROTO_TCP)
    {
        return NULL;
    }
    
    tcph = (struct tcphdr *)((char *)iph + iph->ihl * 4);
    if(ntohs(tcph->source) == 23457 || ntohs(tcph->dest) == 23456)
    {
        
    }
    else
        return NULL;

    if(ntohs(iph->tot_len) - iph->ihl * 4 - tcph->doff * 4 < sizeof(zperf_item_t) * 6 + sizeof(zperf_hdr_t))
    {
        return NULL;
    }

    zperf_hdr = (zperf_hdr_t*)((char *)tcph + tcph->doff * 4);

    if (ntohs(zperf_hdr->flags) & ZXICP_EXCLUDE)
    {
        return NULL;
    }

    if (ntohs(iph->tot_len) - iph->ihl * 4 - tcph->doff * 4 < 
        sizeof(zperf_item_t) * zperf_hdr->item_count+ sizeof(zperf_hdr_t))
    {
        return NULL;
    }

    return (char *)tcph + tcph->doff * 4;
}

void net_dbg_perf_dev_recv(char * packet_addr,char* node_str)
{
    int item_index;
    char *data;
    int label = -1;

    if (!net_debug_perf)
        return;
    
    if ((data = zperf_validate(packet_addr)) == NULL)
        return;

    if ((label = get_dev_label_by_name(node_str, PACKET_IN)) == -1)
        return;

    item_index = get_current_item_index(data);
    set_zperf_item(data, item_index + 1, label);
}

void net_dbg_perf_dev_send(char * packet_addr,char* node_str)
{
    int item_index;
    char *data;
    int label = -1;

    if (!net_debug_perf)
        return;

    if ((data = zperf_validate(packet_addr)) == NULL)
        return;
    
    if ((label = get_dev_label_by_name(node_str, PACKET_OUT)) == -1)
        return;

    item_index = get_current_item_index(data);
    set_zperf_item(data, item_index + 1, label);
}

void net_dbg_perf_clear_last_item(struct sk_buff *skb)
{
    char *data;
	zperf_hdr_t *zperf_hdr;
	zperf_item_t *zperf_item;
    int label = -1;

    if (!net_debug_perf)
        return;

    if ((data = zperf_validate(skb)) == NULL)
        return;

    if ((label = get_dev_label_by_name(skb, PACKET_IN)) == -1)
        return;

    zperf_hdr = (zperf_hdr_t*)data;

    zperf_item = (zperf_item_t *)(data + sizeof(zperf_hdr_t) + sizeof(zperf_item_t) * (zperf_hdr->item_index - 1));
	zperf_item->label = 0x0;
	zperf_item->label_padding = 0xFFFFFFFF;
	zperf_item->secs = 0x0;
	zperf_item->secs_padding = 0xFFFFFFFF;
	zperf_item->usecs = 0x0;
	zperf_item->usecs_padding = 0xFFFFFFFF;

	zperf_hdr->item_index--;
    zperf_hdr->item_index_padding++;
}

