#include <linux/module.h>
#include <linux/kernel.h>
#include <linux/fs.h>
#include <linux/init.h>
#include <linux/delay.h>
#include <linux/irq.h>
#include <linux/netdevice.h>
#include <linux/etherdevice.h>
#include <linux/if_bridge.h>
#include <asm/uaccess.h>
#include <asm/irq.h>
#include <asm/io.h>
#include <linux/device.h>
#include <linux/string.h>
#include <linux/skbuff.h>
#include <linux/jhash.h>
#include <linux/ip.h>
#include <linux/ipv6.h>
#include <linux/udp.h>
#include <linux/tcp.h>
#include <linux/icmp.h>
#include <net/ip.h>
#include "../../bridge/br_private.h"
#include <net/arp.h>
#include <net/SI/netioc_proc.h>
#include <net/SI/netioctl.h>
#include <net/SI/errno_track.h>
#include <net/ipv6.h>
#include <linux/if_arp.h>

#ifdef NETLINK_UC 
#include "../../../../drivers/net/fast6/fast6.h"
#include "../../../../drivers/net/fastnat/fastnat.h"
#else
#include <net/SI/fastnat.h>
#include <net/SI/fast6.h>
#endif

struct skb_debug_t {
	int total_num;
	int used_num;
	struct sk_buff *buf[];
};

struct skb_debug_t *g_skb_debug = NULL;

static spinlock_t skb_debug_spinlock;
#ifdef CONFIG_SPEED_OPT
extern size_t skb_sys_pool_size(const void *ptr);
#endif
unsigned long check_pkt = 0;
EXPORT_SYMBOL(check_pkt);
int set_print_pkt = 0;  /*ӡ*/

/*¼ĳϢ*/
struct check_pkt_info skb_insert_info = {0};
EXPORT_SYMBOL(skb_insert_info);
struct check_pkt_info skb_unlink_info = {0};
EXPORT_SYMBOL(skb_unlink_info);

/*skbתARP/IPV4ͷ,Э飬ıskb*/
static unsigned char* skip_mac_header(struct sk_buff *skb, unsigned short *protocol)
{
    __be16 next_pro;
    unsigned char *curr_ptr = NULL;

    if(skb_mac_header_was_set(skb))
    {
        curr_ptr = skb_mac_header(skb);
        curr_ptr += ETH_HLEN;
        next_pro = *(__be16 *)(curr_ptr - 2);
    }
    else
    {
        curr_ptr = skb->data + ETH_HLEN;
        next_pro = *(__be16 *)(curr_ptr - 2);
    }

again:
    if (htons(ETH_P_IP) == next_pro || htons(ETH_P_ARP) == next_pro)
    {
        *protocol = ntohs(next_pro);
        return curr_ptr;
    }
    //vlan
    else if (next_pro == cpu_to_be16(ETH_P_8021Q))
    {
        curr_ptr += VLAN_HLEN;
        next_pro = *((__be16 *)(curr_ptr - 2));
        goto again;
    }
    //pppoe 
    else if (next_pro == htons(ETH_P_PPP_SES))
    {
        if (*(curr_ptr + 6) == 0x00 && (*(curr_ptr + 7) == 0x21 || *(curr_ptr + 7) == 0x57))
        {
            next_pro = htons(ETH_P_IP);
            curr_ptr += PPPOE_HEADER_LEN;
            goto again;
        }
    }    
    return NULL;
}


/*DHCPѡֶΣȡӦmessage type,ûнoverload*/
unsigned char *dhcp_option_get(unsigned char *data, int data_len, int code)
{
	unsigned char *opt_ptr;
	int len;
	int overload = 0;

	opt_ptr = data;
	while (1) {
		if (data_len <= 0)
			return NULL;

		if (opt_ptr[0] == DHCP_PADDING) 
        {
			data_len--;
			opt_ptr++;
			continue;
		}
		if (opt_ptr[0] == DHCP_END)
			return NULL;
        
		len = 2 + opt_ptr[1];
		data_len -= len;
		if (data_len < 0)
			return NULL;

		if (opt_ptr[0] == code)
			return opt_ptr + 2;

		opt_ptr += len;
	}

	return NULL;
}


void print_check_pkt_info(struct check_pkt_info *pkt_info, int num)
{
    int i = 0;
    
    num = num > MAX_PKT_NUM ? MAX_PKT_NUM : num;
    printk("\n%10s %10s %10s\n", "Protocol", "MsgType", "Time");
    for(i = 0; i < num; i++)
    {
        printk("%10s %10d %10lu\n", 
            proto_str[pkt_info->info[i].proto_type], 
            pkt_info->info[i].msg_type, 
            pkt_info->info[i].time);
    }
}
EXPORT_SYMBOL(print_check_pkt_info);

/*ݰǷָ͵İ¼ʱ*/
/*pkt_infoؽЭ*/
int check_packet_type(struct sk_buff *skb, struct pkt_info *pkt_info)
{
    struct iphdr *ip_hdr = NULL;
    struct icmphdr *icmphdr = NULL;
    struct udphdr *udp_hdr = NULL;
    struct arphdr *arp_hdr = NULL;
    unsigned char *data_ptr = NULL;
    unsigned char *opt_ptr = NULL;
    unsigned short data_len = 0;
    unsigned short protocol = 0;

    if(0 == check_pkt)
        return 0;

    memset(pkt_info, 0, sizeof(struct pkt_info));

    /*MACͷARP/IPV4*/
    data_ptr = skip_mac_header(skb, &protocol);
    if(NULL == data_ptr)
        return 0;

    if(ETH_P_ARP == protocol)
    {
        if(test_bit(PKT_TYPE_ARP_BIT, &check_pkt))
        {
            arp_hdr = (struct arphdr *)data_ptr;
            pkt_info->proto_type = PROTO_TYPE_ARP;
            pkt_info->msg_type   = ntohs(arp_hdr->ar_op);
            pkt_info->time       = jiffies;
            return 1;
        }
    }
    else if(ETH_P_IP == protocol)
    {   
        ip_hdr = (struct iphdr *)data_ptr;

        /*ڷƬֻʶƬ*/
        if(ntohs(ip_hdr->frag_off) & IP_OFFSET)
        {
            return 0;
        }

        data_len = ntohs(ip_hdr->tot_len);

        switch(ip_hdr->protocol)
        {
            case IPPROTO_UDP:
                udp_hdr = (struct udphdr *)((unsigned char *)ip_hdr + ip_hdr->ihl * 4);
                if(test_bit(PKT_TYPE_DHCP_BIT, &check_pkt))
                {
                    if((DHCP_CLIENT_PORT == ntohs(udp_hdr->source) && DHCP_SERVER_PORT == ntohs(udp_hdr->dest)) || 
                        (DHCP_CLIENT_PORT == ntohs(udp_hdr->dest) && DHCP_SERVER_PORT == ntohs(udp_hdr->source)))
                    {
                        /*UDPͷ*/
                        data_ptr = (unsigned char *)udp_hdr + 8;
                        /*DHCP̶ͷ*/
                        data_ptr += 236;
                        /*magic cookies*/
                        data_ptr += 4;
                        data_len = data_len - ip_hdr->ihl * 4 - 8 - 236 - 4;

                        /*ȡDHCPmessage type*/
                        opt_ptr = dhcp_option_get(data_ptr, data_len, DHCP_MSG_TYPE);
                        if(opt_ptr)
                            pkt_info->msg_type = opt_ptr[0];

                        pkt_info->proto_type = PROTO_TYPE_DHCP;
                        pkt_info->time = jiffies;

                        return 1;
                    }
                }
                break;
                
            case IPPROTO_TCP:
                break;
            case IPPROTO_ICMP:
                icmphdr = (struct icmphdr *)((unsigned char *)ip_hdr + ip_hdr->ihl * 4);
                if(test_bit(PKT_TYPE_PING_BIT, &check_pkt))
                {
                    if(ICMP_ECHOREPLY == icmphdr->type || ICMP_ECHO == icmphdr->type)
                    {
                        pkt_info->proto_type = PROTO_TYPE_PING;
                        pkt_info->msg_type   = icmphdr->type;
                        pkt_info->time       = jiffies;
                        return 1;
                    }
                }
                break;
            default:
                break;
        }
    }

    return 0;
}
EXPORT_SYMBOL(check_packet_type);


#ifdef CONFIG_NETCTL

void net_print_packet(unsigned char *data, unsigned int len, int flag)
{
    int i = 0;

    if(set_print_pkt && net_ratelimit())
    {
        if(0 == flag)
            printk("\nrecv packet:\n");
        else if(1 == flag)
            printk("\nsend packet:\n");
        else
            printk("\nprint packet:\n");

        for(i = 0; i < len; i++)
        {
            if(i % 16 == 0)
                printk("\n");
            printk("%2x ", data[i]);
        }
    }
}


void track_netlink(struct sk_buff *skb,u32 group)
{
	struct nlmsghdr *nlh;	

	nlh = (struct nlmsghdr*)(skb->data);	
	net_run_track(PRT_RTNL_SEND,"rtnetlink_send,msg_type =%d;group = %d",nlh->nlmsg_type,group);
}


/*MACַnet_deviceַбȽ
  ֵĳ
  1.ݻػ
  2.ͨѶCPEͬMACַ
 */
void check_macaddr_only(unsigned char *ha, unsigned char ha_len)
{
	struct net_device *dev;
	unsigned char addr_len = 0;
	unsigned char addr[ETH_ALEN] = {0};
	
	if(0 == addr_check)
	{
		return;
	}
	
	read_lock(&dev_base_lock);

	for_each_netdev(&init_net, dev)
	{
		if(dev->addr_len != ha_len)
		{
			//޸ԭĬsit0addr_len=4dev_addrĬΪȫ0豸macַ[0:3]ҲȫΪ0ʱͻ
			continue;
		}
		//addr_len = dev->addr_len > ha_len ? ha_len : dev->addr_len;
		addr_len = ha_len;
		if((addr_len > 0) && !memcmp(dev->dev_addr, ha, addr_len))
		{
			addr_len = addr_len > ETH_ALEN ? ETH_ALEN : addr_len;
			memcpy(addr, ha, addr_len);
			
			panic("check_macaddr_only: mac address of pc is same as the device, dev name: %s, mac %x:%x:%x:%x:%x:%x\n", 
				dev->name, addr[0], addr[1], addr[2], addr[3], addr[4], addr[5]);		
			read_unlock(&dev_base_lock);
			return;
		}
	}

	read_unlock(&dev_base_lock);

	return;
}


void skbinfo_add(unsigned char *addr,unsigned int skbinfo_type)
{
	struct sk_buff *skb;
	skbinfo_dbg[skbinfo_type] ++;
/*
	if(skb_max_panic && skbinfo_type == SKB_TYPE_ALL)
	{
		//˴δspinlockһʹøùܣҪ
		if(skbinfo_dbg[SKB_TYPE_ALL] > skb_max_panic)
			panic("too much skb is alloced,pleasw check data_leak ");
	}
*/
	if(skbinfo_type == SKB_TYPE_DATA)
	{
		skb = (struct sk_buff *)addr;
        if(skb->isExtern == 0)
#ifndef CONFIG_SPEED_OPT        
	    	skbinfo_dbg[SKB_DATA_BYTES] += ksize(skb->head);
#else
	    	skbinfo_dbg[SKB_DATA_BYTES] += skb_sys_pool_size(skb->head);
#endif
        else
            skbinfo_dbg[SKB_DATA_BYTES] += skb->data - skb->head + skb->len;
	}
	if(skbinfo_type==(skb_info_track&0X7F)) 
	{ 
		printk("net resource monitor!!!");   
		dump_stack(); 
		if(skb_info_track&0X80)
			panic("net team dbg panic !!!");
	} 
	
}


void skbinfo_del(unsigned char *addr,unsigned int skbinfo_type)
{
	struct sk_buff *skb;
	skbinfo_dbg[skbinfo_type] --;
	
	if(skbinfo_type == SKB_TYPE_DATA)
	{
		skb = (struct sk_buff *)addr;
        if(skb->isExtern == 0)
#ifndef CONFIG_SPEED_OPT          
            skbinfo_dbg[SKB_DATA_BYTES] -= ksize(skb->head);
#else
            skbinfo_dbg[SKB_DATA_BYTES] -= skb_sys_pool_size(skb->head);
#endif
        else
            skbinfo_dbg[SKB_DATA_BYTES] -= skb->data - skb->head + skb->len;
	}

}

void netruninfo_add(unsigned char *addr,unsigned int info_type)
{
	netruninfo_dbg[info_type] ++;	
	if(info_type==(net_info_track&0X7F)) 
	{ 
		printk("net resource monitor!!!");   
		dump_stack(); 
		if(net_info_track&0X80)
			panic("net team dbg panic !!!");
	} 
}

void netruninfo_del(unsigned char *addr,unsigned int info_type)
{
	netruninfo_dbg[info_type] --;
}
static int filter(void *start1, void *start2, unsigned int len)
{
    int i = 100, ret = -1;
    int *p = start1, *q = start2;

    do {
        if (!memcmp(p, q, len)) {
            ret = 0;
            break;
        }
        ++p;
    }while(i--);

    return ret;
}

//úжskb->network_headerЧԣػȡЧipͷ
unsigned char * check_skb_for_dump(struct sk_buff *skb, int *mark)
{
    unsigned char * mac_head, *net_head, *tsp_head;
    //dri->net 0; net->dri 1;
    mac_head = skb_mac_head(skb);
    net_head = skb_network_head(skb);
    tsp_head = skb_transport_head(skb);
    *mark = 0;
    if (!skb->dev){
   //     printk("skb->dev = NULL err in %s.\n", __func__);
        return NULL;
    }
    if (skb->data == NULL){
        printk("skb->data = NULL err in %s.\n", __func__);
        return NULL;
    }
    if (skb->data == mac_head){
        if(net_head && net_head < (mac_head + skb->dev->hard_header_len )){
            *mark = -2;
            return mac_head + skb->dev->hard_header_len;
        }
        *mark = 2;
         return mac_head + skb->dev->hard_header_len;  
    }
    else if(skb->data == net_head){
        if(mac_head && net_head < (mac_head + skb->dev->hard_header_len )){
            *mark = -23;
            return mac_head + skb->dev->hard_header_len;
        }
        if(tsp_head && net_head < (tsp_head - 20)){
            *mark = -3;
            return net_head;
        }
        *mark = 3;
        return net_head;
    }
    else if(skb->data == tsp_head ){
        if((!net_head) || (net_head && net_head < (tsp_head - 20))){
            *mark = -4;
            return NULL;
        }
        *mark = 4;
        return net_head;
    }
    else{
     //   printk("unexpected err in %s\n", __func__);
        return NULL;
    }
        
}

extern struct nf_conntrack_tuple tuple_info;
extern int getconn_type;

//skb_release_dataʱݵַƥ䣬ջ켣
void dump_net_stack(struct sk_buff *skb, unsigned int offset)
{
    if(getconn_type != 8 && getconn_type != 10)
        return;
    int mark = 0;
    struct iphdr *iphv4;
    struct ipv6hdr *iphv6;
    unsigned char *tsp_start = NULL;
    unsigned char *iph = check_skb_for_dump(skb, &mark);
    
    if(getconn_type == 10 && iph){
        if (skb->now_location & FASTNAT_SUCC){
            printk("skb->len = %d now_location = %d\n", skb->len, skb->now_location);
            struct tcphdr *th = (struct tcphdr *)(iph + 20);
            printk("th->seq=%lu, th->sport=%ld, th->dport=%ld\n", htonl(th->seq), htons(th->source), htons(th->dest));
            goto out;
        }
        return;
    }
    if(iph){
        if((iph[0] & 0xf0) == 0x40){
            iphv4 = (struct iphdr*)iph;
            if(tuple_info.dst.protonum && tuple_info.dst.protonum != iphv4->protocol){
                return;
            }
            if(tuple_info.dst.u3.ip && memcmp(&tuple_info.dst.u3.ip, &iphv4->daddr, 4) != 0){
                return;
            }
            if(tuple_info.src.u3.ip && memcmp(&tuple_info.src.u3.ip, &iphv4->saddr, 4) != 0){
                return;
            }
            tsp_start = (unsigned char*)iphv4 + (iphv4->ihl << 2);
        }
        else if((iph[0] & 0xf0) == 0x60){
            iphv6 = (struct ipv6hdr*)iph;
            if(tuple_info.dst.protonum && tuple_info.dst.protonum != iphv6->nexthdr){
                return;
            }
            if(tuple_info.dst.u3.ip && memcmp(&tuple_info.dst.u3.in6, &iphv6->daddr, 16) != 0){
                return;
            }
            if(tuple_info.src.u3.ip && memcmp(&tuple_info.src.u3.in6, &iphv6->saddr, 16) != 0){
                return;
            }
            tsp_start = (unsigned char*)iphv6 + 40;
        }
    }
    //ͷʱֻдͷûͷֻȽЧport
    if(mark == -4){
        tsp_start = skb->data; 
    }
    if(tsp_start == NULL)
        return;
    
    if(tuple_info.src.u.all && memcmp(&tuple_info.src.u.all, tsp_start, 2) != 0){
        return;
    }
    if(tuple_info.dst.u.all && memcmp(&tuple_info.dst.u.all, tsp_start + 2, 2) != 0) {
        return;
    }
    
    printk("free skb match mark = %d:\n", mark);
    if(tuple_info.dst.protonum && mark != -4)
        printk("protonum = %d ",tuple_info.dst.protonum);
    if(tuple_info.src.u3.ip && mark != -4){
        if(iph && (iph[0] & 0xf0) == 0x40){
            printk("sip: %08x ", ntohl(tuple_info.src.u3.ip));
        }else if(iph && (iph[0] & 0xf0) == 0x60){
            printk("sip: %x:%x:%x:%x:%x:%x:%x:%x ", ntohs(tuple_info.src.u3.in6.s6_addr16[0]), ntohs(tuple_info.src.u3.in6.s6_addr16[1]), ntohs(tuple_info.src.u3.in6.s6_addr16[2]), ntohs(tuple_info.src.u3.in6.s6_addr16[3]), 
                    ntohs(tuple_info.src.u3.in6.s6_addr16[4]), ntohs(tuple_info.src.u3.in6.s6_addr16[5]), ntohs(tuple_info.src.u3.in6.s6_addr16[6]), ntohs(tuple_info.src.u3.in6.s6_addr16[7]));
        }
    }
    if(tuple_info.src.u.all){
        printk("sport : %d ", ntohs(tuple_info.src.u.all));
    }
    if(tuple_info.dst.u3.ip && mark != -4){
        if(iph && (iph[0] & 0xf0) == 0x40){
            printk("dip: %08x ", ntohl(tuple_info.dst.u3.ip));
        }else if(iph && (iph[0] & 0xf0) == 0x60){
            printk("dip: %x:%x:%x:%x:%x:%x:%x:%x ", ntohs(tuple_info.dst.u3.in6.s6_addr16[0]), ntohs(tuple_info.dst.u3.in6.s6_addr16[1]), ntohs(tuple_info.dst.u3.in6.s6_addr16[2]), ntohs(tuple_info.dst.u3.in6.s6_addr16[3]), 
                    ntohs(tuple_info.dst.u3.in6.s6_addr16[4]), ntohs(tuple_info.dst.u3.in6.s6_addr16[5]), ntohs(tuple_info.dst.u3.in6.s6_addr16[6]), ntohs(tuple_info.dst.u3.in6.s6_addr16[7]));
        }
    }
    if(tuple_info.dst.u.all) {
        printk("dport : %d ", ntohs(tuple_info.dst.u.all));
    }
    printk("\n");
   // if (skb_dump_len) 
      //  if(!filter((skb->head + offset), skb_dump_str, skb_dump_len))
out:
    dump_stack();
}



/***********************************************************************************************************/
/*ΪĽӿڣǿܶԴļע*/
/***********************************************************************************************************/

extern int set_tcpdump;
extern char br_name[];

//Ҫskb->mac_headerѾֵ
unsigned int get_network_head_len(struct sk_buff *skb)
{
#ifdef NET_SKBUFF_DATA_USES_OFFSET
    unsigned char *buf = (unsigned char *)skb->head + skb->mac_header + ETH_HLEN;
#else
    unsigned char *buf = (unsigned char *)skb->mac_header + ETH_HLEN;
#endif

    if ((((unsigned)buf[0]) & 0xF0) == 0x40)
        return 20; //ipv4 ipͷ20
        
    if ((((unsigned)buf[0]) & 0xF0) == 0x60)
        return 40; //ipv6 ipͷ40
        
    return 20; //Ĭipv4
}

//Ȫӣο__netif_receive_skbץȡշĶƱģfastnatڱģtcpdumpʽʹüɣӰܣҪproc
void tcpdumpin_sq(struct sk_buff *skb)
{
    unsigned char        *data_priv;
    struct packet_type *ptype;
    __be16 type;
    unsigned int len_priv;
    int dev_flag = 0;

    if (!(set_tcpdump & 1))
        return;
    
    if (list_empty(&ptype_all))
    {
        return;
    }

    //浱ǰĵ֡ͷϢץָ
    data_priv = skb->data;
    len_priv = skb->len;
    
    //ȺdataָMACͷݵǰ̬
    if (skb->mac_header == 0 || skb->mac_header == ~0U)
    {
        skb_reset_mac_header(skb);
        skb->network_header = skb->mac_header + ETH_HLEN;
        skb->transport_header = skb->network_header + get_network_head_len(skb);
    }
    else if (skb->network_header == 0 || skb->network_header == ~0U)
    {
        skb->network_header = skb->mac_header + ETH_HLEN;
        skb->transport_header = skb->network_header + get_network_head_len(skb);
        skb_reset_data_bymachd(skb);
        skb_push(skb, ETH_HLEN);
    }
    else if (skb->transport_header == 0 || skb->transport_header == ~0U)
    {
        skb->network_header = skb->mac_header + ETH_HLEN;
        skb->transport_header = skb->network_header + get_network_head_len(skb);
        skb_reset_data_bymachd(skb);
        skb_push(skb, ETH_HLEN);
    }
    
    //devΪʱΪ˱֤е㶼ץdevΪptype->dev
    if (skb->dev == NULL)
    {
        dev_flag = 1;
    }

    rcu_read_lock();
    list_for_each_entry_rcu(ptype, &ptype_all, list) {
        //skbMAC֡ҪκƫƵ
        if ((!ptype->dev || !skb->dev || ptype->dev == skb->dev))  // && (ptype->func == packet_rcv)
        {
            //packet_rcvڲҪskb->dev벻ΪգԴ˴Сɣжץ
            if(skb->dev == NULL && ptype->dev)
                skb->dev = ptype->dev;
            else if(skb->dev == NULL)
                skb->dev = __dev_get_by_name(&init_net, br_name);

            atomic_inc(&skb->users);
            track_add(skb, 0, USER_INFO, 0);
            ptype->func(skb, skb->dev, ptype, skb->dev);
            if(dev_flag == 1)
                skb->dev = NULL;
        }
    }
    rcu_read_unlock();

    //ָskbʼ״̬
    skb->data = data_priv;
    skb->len = len_priv;
    if(dev_flag == 1)
        skb->dev = NULL;
}

//Ȫӣοdev_queue_xmit_nitץȡͷĶƱģfastnatȳڱģtcpdumpʽʹüɣӰܣҪproc
void tcpdumpout_sq(struct sk_buff *skb)
{
    struct packet_type *ptype;
    struct sk_buff *skb2 = NULL;
    int dev_flag = 0;
    sk_buff_data_t        transport_header;
    sk_buff_data_t        network_header;
    sk_buff_data_t        mac_header;
    unsigned char        *data_priv;
    unsigned int len_priv;
    
    if (!(set_tcpdump & 2))
        return;
    
    if (list_empty(&ptype_all))
    {
        return;
    }

    //浱ǰĵ֡ͷϢץָ
    data_priv = skb->data;
    len_priv = skb->len;
    transport_header = skb->transport_header;
    network_header = skb->network_header;
    mac_header = skb->mac_header;

    if (skb->mac_header == 0 || skb->mac_header == ~0U)
    {
        skb_reset_mac_header(skb);
        skb->network_header = skb->mac_header + ETH_HLEN;
        skb->transport_header = skb->network_header + get_network_head_len(skb);
    }
    else if (skb->network_header == 0 || skb->network_header == ~0U)
    {
        skb->network_header = skb->mac_header + ETH_HLEN;
        skb->transport_header = skb->network_header + get_network_head_len(skb);
        skb_reset_data_bymachd(skb);
        skb_push(skb, ETH_HLEN);
    }
    else if (skb->transport_header == 0 || skb->transport_header == ~0U)
    {
        skb->transport_header = skb->network_header + get_network_head_len(skb);
        skb_reset_data_bymachd(skb);
        skb_push(skb, ETH_HLEN);
    }

    //TCPδüֵdev˴ǿиֵΪbr0ҪץڱʱҪdevУڱץ
    if(skb->dev == NULL)
    {
        dev_flag = 1;
    }
    
    rcu_read_lock();
    list_for_each_entry_rcu(ptype, &ptype_all, list) {
        //TCPIP棬ʱdataδָMACͷǽƫƣָMACͷץȡģPPPoE౨ģ޷ץȫ
        if ((ptype->dev == skb->dev || !ptype->dev || !skb->dev) && (ptype->af_packet_priv != NULL) &&
          (struct sock *)ptype->af_packet_priv != skb->sk) // && (ptype->func == packet_rcv)
        {
            //packet_rcvڲҪskb->dev벻ΪգԴ˴Сɣжץ
            if(skb->dev == NULL && ptype->dev)
                skb->dev = ptype->dev;
            else if(skb->dev == NULL)
                skb->dev = __dev_get_by_name(&init_net, br_name);
            
            skb2 = skb_clone(skb, GFP_ATOMIC);
            if (!skb2)
                break;
            ptype->func(skb2, skb->dev, ptype, skb->dev);
            
            if (dev_flag == 1)
                skb->dev = NULL;
        }
    }
    rcu_read_unlock();

    //ָskbʼ״̬
    if(dev_flag == 1)
        skb->dev = NULL;
    skb->transport_header = transport_header;
    skb->network_header = network_header;
    skb->mac_header = mac_header;
    skb->data = data_priv;
    skb->len = len_priv;
}




/*devƥھӱarp_tblеھӽڵ*/
void get_neigh_bydev(struct neigh_table *tbl, struct net_device *dev, struct dev_neigh_info *neigh_info)
{
    int i;
    int len;
    unsigned int neigh_num = 0;
    struct neigh_hash_table *nht;

    if(tbl->family != AF_INET && tbl->family != AF_INET6)
        return;

    rcu_read_lock_bh();
    nht = rcu_dereference_bh(tbl->nht);

    for(i = 0; i < (1 << nht->hash_shift); i++)
    {
        struct neighbour *neigh;

        for(neigh = rcu_dereference_bh(nht->hash_buckets[i]); neigh != NULL; neigh = rcu_dereference_bh(neigh->next))
        {
            if(neigh->dev == dev)
            {
                len = tbl->key_len > MAX_IPADDR_LEN ? MAX_IPADDR_LEN : tbl->key_len;

                memcpy(neigh_info->neigh_nod[neigh_num].ip_addr, neigh->primary_key, len);
                neigh_info->neigh_nod[neigh_num].ip_len = len;
                memcpy(neigh_info->neigh_nod[neigh_num].mac_addr, neigh->ha, MAX_MACADDR_LEN);
                neigh_num++;
                if(neigh_num >= 20)
                    goto end;
            }
        }
    }

end:
    neigh_info->num = neigh_num;

    rcu_read_unlock_bh();

    return;
}

/*ԶھӵMACַҵarp_tblеھIPַϢ*/
void get_neigh_bymac(struct neigh_table *tbl,mac_addr *addr, struct neigh_info *info)
{
    int i;
    int len;
    struct neigh_hash_table *nht;

    if(tbl->family != AF_INET && tbl->family != AF_INET6)
        return;

    nht = rcu_dereference_bh(tbl->nht);

    for(i = 0; i < (1 << nht->hash_shift); i++)
    {
        struct neighbour *neigh;

        for(neigh = rcu_dereference_bh(nht->hash_buckets[i]); neigh != NULL; neigh = rcu_dereference_bh(neigh->next))
        {
            if(!compare_ether_addr(neigh->ha,addr->addr)) 
            {
                len = tbl->key_len > MAX_IPADDR_LEN ? MAX_IPADDR_LEN : tbl->key_len;

                memcpy(info->ip_addr, neigh->primary_key, len);
                info->ip_len = len;
                memcpy(info->mac_addr, neigh->ha, MAX_MACADDR_LEN);
                return;
            }
        }
	}
}

//ȡĳ2ŵ豸ھбϢȸݳdevҵеԶھMACַٸMACַҵarp_tblеھIPַϢ
void getneigh_ofdev(struct net_device *dst_dev,struct dev_neigh_info  *neigh_info)
{
	int i;
	int neigh_num = 0;
	struct net_device *br_dev;
	struct net_bridge *br;
	
	br_dev = dev_get_by_name(&init_net, br_name);
	br = netdev_priv(br_dev);
	
	spin_lock_bh(&br->hash_lock);
	for (i = 0; i < BR_HASH_SIZE; i++) {
		struct hlist_node *h;
		hlist_for_each(h, &br->hash[i]) {
			struct net_bridge_fdb_entry *f;

			f = hlist_entry(h, struct net_bridge_fdb_entry, hlist);
			if (f->dst && f->dst->dev == dst_dev && !f->is_local) {
			   get_neigh_bymac(&arp_tbl, &f->addr,neigh_info->neigh_nod+neigh_num);
	                neigh_num++;

			}
		}
	}
	spin_unlock_bh(&br->hash_lock);
	neigh_info->num = neigh_num;
}

void update_brport_info(struct devlist_info *dev_info){
    int i = 0, j = 0, k = 0;
    struct net_device *br_dev;
    struct net_device *temp_dev;
    struct dev_neigh_info *temp_neigh;
    int temp_count ;
    for(i = 0; i < dev_info->num; i++){
        if(dev_info->info[i].dev_layer == BR_DEV){
            br_dev = dev_get_by_name(&init_net, dev_info->info[i].name);
            for(j = 0; j < dev_info->info[i].dev_neigh.num; j++){
                temp_dev = getbrport_bydst(br_dev, dev_info->info[i].dev_neigh.neigh_nod[j].mac_addr);
                if(!temp_dev || temp_dev->ifindex == br_dev->ifindex){
                    printk("temp_dev error!!!\n");
                    continue;
                }        
                for(k = 0 ; k < dev_info->num; k++){
                    if(strcmp(dev_info->info[k].name, temp_dev->name) == 0){
						temp_neigh = &(dev_info->info[k].dev_neigh);
						if(temp_neigh->num >= 20){
							printk("dev=%s , neigh info is full!\n", temp_dev->name);
						    break;
						}
                        temp_count = temp_neigh->num;			
                        memcpy(temp_neigh->neigh_nod[temp_count].ip_addr, dev_info->info[i].dev_neigh.neigh_nod[j].ip_addr,  dev_info->info[i].dev_neigh.neigh_nod[j].ip_len);
                        temp_neigh->neigh_nod[temp_count].ip_len = dev_info->info[i].dev_neigh.neigh_nod[j].ip_len;
                        memcpy(temp_neigh->neigh_nod[temp_count].mac_addr, dev_info->info[i].dev_neigh.neigh_nod[j].mac_addr, MAX_MACADDR_LEN);
                        temp_count ++;
                        temp_neigh->num = temp_count;
                        break;
                    }
                }
            }
			if(br_dev)
				dev_put(br_dev);
        }
    }
}

/*ȡinit_net豸ϢIPMACdevھб*/
int get_devlist_info(unsigned long arg)
{
    struct devlist_info *dev_info;
    struct net_device *dev;
    struct net_device *temp_dev;
    struct dev_neigh_info *temp_neigh;
    unsigned int temp_count = 0;
    unsigned int dev_num = 0;
	
    dev_info=(struct devlist_info*)kzalloc(sizeof(struct devlist_info), GFP_KERNEL);
    if(!dev_info)
        return -EFAULT;

    read_lock(&dev_base_lock);

    for_each_netdev(&init_net, dev)
    {
        if(dev->flags & IFF_UP && strcmp(dev->name, "lo") != 0)
        {
        	//¼ڵϢ
            strcpy(dev_info->info[dev_num].name, dev->name);
            if(dev->ip_ptr && dev->ip_ptr->ifa_list)
                dev_info->info[dev_num].ipv4_addr = dev->ip_ptr->ifa_list->ifa_address; 
            if(dev->header_ops && dev->dev_addr){
                memcpy(dev_info->info[dev_num].mac_addr, dev->dev_addr, dev->addr_len);
                if(is_zero_ether_addr(dev->dev_addr))
                    dev_info->info[dev_num].mac_errtype = ZERO_ADDRERR;
                else if(is_broadcast_ether_addr(dev->dev_addr))
                    dev_info->info[dev_num].mac_errtype = BROADCAST_ADDRERR;
                else if(is_multicast_ether_addr(dev->dev_addr))
                    dev_info->info[dev_num].mac_errtype = MULTICAST_ADDRERR;              
            }

		//Ϊ±ڹԶھбϢ
		//ŵ豸ȸݳdevҵеԶھMACַٸMACַҵarp_tblеھIPַϢ
            if(dev->priv_flags & IFF_BRIDGE_PORT){
		    	dev_info->info[dev_num].dev_layer = L2_DEV;
                dev_info->info[dev_num].dev_neigh.num = 0;
		//	getneigh_ofdev(dev,&(dev_info->info[dev_num].dev_neigh));
            }
		//br0أȡھб
            else if(dev->priv_flags & IFF_EBRIDGE){
                dev_info->info[dev_num].dev_layer = BR_DEV;
                get_neigh_bydev(&arp_tbl, dev,&(dev_info->info[dev_num].dev_neigh));
            }
		//ͨ3豸ȡھбϢ
            else{
                //ųarpӿ
                if(!(dev->flags & IFF_NOARP))
                    get_neigh_bydev(&arp_tbl, dev,&(dev_info->info[dev_num].dev_neigh));
                dev_info->info[dev_num].dev_layer = L3_DEV;         
            }
		    dev_num++;
            if(dev_num >= MAX_DEV_NUM)
            {
                break;
            }
        }
    }
    dev_info->num = dev_num;
    update_brport_info(dev_info);
    read_unlock(&dev_base_lock);
    
    if (copy_to_user((char *)arg, dev_info, sizeof(struct devlist_info)))
    {
        kfree(dev_info);
        return -EFAULT;
    }
    kfree(dev_info);

    return 0;
}

void skb_debug_off(void)
{
	if(g_skb_debug)
	{
		unsigned long flags;
		spin_lock_irqsave(&skb_debug_spinlock, flags);
		kfree(g_skb_debug);
		g_skb_debug = NULL;
		spin_unlock_irqrestore(&skb_debug_spinlock, flags);
	}
}

extern wait_queue_head_t skb_wait_queue;
extern atomic_t  skb_used;
extern atomic_t  skb_tops;
extern atomic_t  skb_fromps;
//ڸskbṹ룬ⲿdata
void skb_alloc_track(struct sk_buff *skb)
{
#ifndef CONFIG_SPEED_OPT
	netslab_inc(SKB_SLAB);
	track_add(skb, 0, SKB_INFO, skb->truesize);
	skbinfo_add(skb,SKB_TYPE_ALL);
#endif
	atomic_inc(&skb_used);
	if(unlikely(g_skb_debug))
	{
		unsigned long flags;
		int i = 0;
		
		spin_lock_irqsave(&skb_debug_spinlock, flags);
		if(g_skb_debug == NULL)
		{
			spin_unlock_irqrestore(&skb_debug_spinlock, flags);
			return;
		}
		if(unlikely(g_skb_debug->total_num < skb_num_limit+10))
		{
			struct skb_debug_t *skb_debug_tmp = (struct skb_debug_t *)kzalloc(sizeof(struct skb_debug_t) + (skb_num_limit+10)*4, GFP_ATOMIC);
			if(skb_debug_tmp)
			{
				memcpy(skb_debug_tmp, g_skb_debug, (sizeof(struct skb_debug_t) + g_skb_debug->total_num*4));
				skb_debug_tmp->total_num = (skb_num_limit+10);
				kfree(g_skb_debug);
				g_skb_debug = skb_debug_tmp;
			}
		}
		for(i = 0; i < g_skb_debug->total_num; i++)
		{
			if(g_skb_debug->buf[i] == NULL)
			{
				g_skb_debug->buf[i] = skb;
				g_skb_debug->used_num++;
				spin_unlock_irqrestore(&skb_debug_spinlock, flags);
				return;
			}
		}
		spin_unlock_irqrestore(&skb_debug_spinlock, flags);
		BUG();
	}
}
//ڸskbṹͷţⲿdata
extern wait_queue_head_t skb_wait_queue;
void skb_free_track(struct sk_buff *skb)
{
#ifndef CONFIG_SPEED_OPT
	track_del(skb, 0, SKB_INFO);
	skbinfo_del(skb,SKB_TYPE_ALL);
	netslab_dec(SKB_SLAB);	
#endif
	//2017.6.3  add by linxu  set a limit for skb
	atomic_dec(&skb_used);
	if(waitqueue_active(&skb_wait_queue) && ( atomic_read(&skb_used) < skb_num_limit))
	{
		wake_up(&skb_wait_queue);		
	}
	if(unlikely(g_skb_debug))
	{
		unsigned long flags;
		int i = 0;
		
		spin_lock_irqsave(&skb_debug_spinlock, flags);
		if(g_skb_debug == NULL)
		{
			spin_unlock_irqrestore(&skb_debug_spinlock, flags);
			return;
		}
		for(i = 0; i < g_skb_debug->total_num; i++)
		{
			if(g_skb_debug->buf[i] == skb)
			{
				g_skb_debug->buf[i] = NULL;
				g_skb_debug->used_num--;
				spin_unlock_irqrestore(&skb_debug_spinlock, flags);
				return;
			}
		}
		spin_unlock_irqrestore(&skb_debug_spinlock, flags);
		BUG();
	}
}
//ڸslabƵskb->dataṹ,ⲿPSBUF
void skbdata_alloc_track(struct sk_buff *skb)
{
#ifndef CONFIG_SPEED_OPT
	skbinfo_add((unsigned char *)skb,SKB_TYPE_DATA);
	track_add(skb->head, 0, DATA_INFO, skb->len);
#endif
}
//ڸslabƵskb->dataṹͷ,ⲿPSBUF
void skbdata_free_track(struct sk_buff *skb)
{
#ifndef CONFIG_SPEED_OPT
	track_del(skb->head, 0, DATA_INFO);
	skbinfo_del(skb,SKB_TYPE_DATA);
#endif
}

//ڸⲿdata
void fromext_alloc_track(struct sk_buff *skb)
{
#ifndef CONFIG_SPEED_OPT
	track_add(skb, 0, DATA_INFO,  skb->len);
	skbinfo_add((unsigned char *)skb,SKB_TYPE_FROMCP);
#endif
	atomic_inc(&skb_fromps);
}
//ڸⲿdataͷ
void fromext_free_track(struct sk_buff *skb)
{
#ifndef CONFIG_SPEED_OPT
	track_del(skb->head, 0, DATA_INFO);
	skbinfo_del(skb,SKB_TYPE_FROMCP);
#endif	
	atomic_dec(&skb_fromps);
}
//ڸٷ͸ⲿ
void toext_alloc_track(struct sk_buff *skb)
{
#ifndef CONFIG_SPEED_OPT
	skbinfo_add((unsigned char *)skb,SKB_TYPE_TOCP);
#endif
	atomic_inc(&skb_tops);
}
//ڸٷ͸ⲿͷ
void toext_free_track(struct sk_buff *skb)
{
#ifndef CONFIG_SPEED_OPT
	skbinfo_del(skb,SKB_TYPE_TOCP);
#endif
	atomic_dec(&skb_tops);
}
#else



int set_print = 0;       //ԶĴӡ
EXPORT_SYMBOL(set_print);

int set_tcpdump = 0;  //ץ

//ŵǰskbصͳϢһЩ쳣Ϣ
unsigned long skbinfo_dbg[SKB_INFO_MAX]= {0}; 

//ԴͳֵǸؼṹ룬ԹڲѧϰͶλ
unsigned long netruninfo_dbg[NET_INFO_MAX]= {0}; 

//skb޵ȫ֣Ŀǰδʹ
unsigned long skb_max_panic = 0; //skbޣᵼpanic
unsigned long skb_num_limit = 6000;  //skbޣNULL

//ضskbͷŵʱջ
char skb_dump_str[NIOCTL_MAX_MSGLEN] = {0};
unsigned int skb_dump_len = 0;

/*ԱTCPͳ*/
unsigned long tcp_stats_dbg[TCP_STATS_MAX] = {0};


//ΪݰĽģϢͳƳݰģ
int  skb_num4 = 0;                  //յV4ݰ
int  skb_num6 = 0;                  //յV6ݰ
int  skb_big_num;                   //lenȳ1000ݰV4V6
int  skb_small_num;                 //lenС100ݰV4V6
int  skb_bytes4 = 0;                //յV4ݰֽ
int  skb_bytes6 = 0;                //յV6ݰֽ
int  skb_unknown = 0;               //յδ֪ЭݰARPȷV4V6ı
int  skb_tcpnum = 0;                //յtcpݰV4V6fastbrı
int  skb_udpnum = 0;                //յudpݰV4V6fastbrı
int  broadcast_num4 = 0;            //յV4㲥
int  broadcast_num6 = 0;            //յV6㲥
int  multicast_num4 = 0;            //յV4鲥
int  multicast_num6 = 0;            //յV6鲥
int  fastnat_num = 0;               //fastnatɹı
int  fast6_num = 0;                 //fast6ɹı
int  fastbr_num = 0;                //fastbrɹı
int  fast_local4_rcv_num = 0;       //fast_local4ɹձ
int  fast_local6_rcv_num = 0;       //fast_local6ɹձ
int  fast_local4_output_num = 0;    //fast_local4ɹͱ
int  fast_local6_output_num = 0;    //fast_local6ɹͱ
int  fast_tcpdump_num = 0;          //fastץ
int  skb_expand4 = 0;               //ͷռ䲻V4ݰ
int  skb_expand6 = 0;               //ͷռ䲻V6ݰ

int double_mac = 0; //mac鿪
//slabڴʹͳƣδͨslabַأkmalloc
struct slab_info slab_count = {0};

/*TCPͳ*/
#define TCP_PKT_STATS_INC(_mod)    tcp_stats_dbg[_mod]++

void dump_net_stack(struct sk_buff *skb, unsigned int offset)
{
   
}


void check_macaddr_only(unsigned char *ha, unsigned char ha_len)
{
	
}

//ڸskbṹ룬ⲿdata
void skb_alloc_track(struct sk_buff *skb)
{
	
}
//ڸskbṹͷţⲿdata
void skb_free_track(struct sk_buff *skb)
{
	
}
//ڸslabƵskb->dataṹ,ⲿPSBUF
void skbdata_alloc_track(struct sk_buff *skb)
{
	
}
//ڸslabƵskb->dataṹͷ,ⲿPSBUF
void skbdata_free_track(struct sk_buff *skb)
{
	
}

//ڸⲿdata
void fromext_alloc_track(struct sk_buff *skb)
{
	

}
//ڸⲿdataͷ
void fromext_free_track(struct sk_buff *skb)
{
	
}
//ڸٷ͸ⲿ
void toext_alloc_track(struct sk_buff *skb)
{
	
}
//ڸٷ͸ⲿͷ
void toext_free_track(struct sk_buff *skb)
{
	
}

void net_print_packet(unsigned char *data, unsigned int len, int flag)
{
   
}


void tcpdumpin_sq(struct sk_buff *skb)
{
    
}

void track_netlink(struct sk_buff *skb,u32 group)
{

}

void netslab_inc(int i)
{

}

void netslab_dec(int i)
{

}

void netruninfo_add(unsigned char *addr,unsigned int info_type)
{
}

void netruninfo_del(unsigned char *addr,unsigned int info_type)
{
}

void skbinfo_add(unsigned char *addr,unsigned int skbinfo_type)
{
}

void skbinfo_del(unsigned char *addr,unsigned int skbinfo_type)
{
}

int net_debug_packet = 0;
struct timeval net_debug_packet_tv = {0, 0};
struct list_head net_debug_packet_list_head; 
int net_debug_packet_sec = 0;

//¼Ӧ÷
void record_app_atcive_net()
{

}

int get_tcp_stat_info(unsigned long arg)
{
    return 0;
}
#endif

#ifdef _USE_TestHarness 
int *vir_addr_ddrnet = 0;

void psnet_freepsbuf(void *head)
{
}

const struct net_device_ops psnet_netdev_ops;

#endif

void netother_init(void)
{
	spin_lock_init(&skb_debug_spinlock);
	g_skb_debug = (struct skb_debug_t *)kzalloc(sizeof(struct skb_debug_t) + (skb_num_limit+10)*4, GFP_ATOMIC);
	if(g_skb_debug)
	{
		g_skb_debug->total_num = (skb_num_limit+10);
	}
}

