/* * Copyright (c) 2011 Qualcomm Atheros, Inc. * */

#include <linux/in.h>
#include <linux/ip.h>
#include <linux/udp.h>
#include <linux/tcp.h>
#include <linux/icmp.h>
#include <net/ip.h>
#include <linux/if_arp.h>

#include <linux/inetdevice.h>
#include <linux/netfilter.h>
#include <linux/netfilter_ipv6.h>
#include <linux/netfilter_arp.h>
#include <linux/netfilter/xt_multiport.h>
#include <linux/netfilter/xt_iprange.h>
#include <linux/netfilter/nf_conntrack_tcp.h>
#include <net/checksum.h>
#include <net/dsfield.h>
#include <net/route.h>
#include <net/netfilter/nf_nat.h>
#include <net/netfilter/nf_nat_core.h>
#include <net/netfilter/nf_nat_rule.h>
#include <net/netfilter/nf_conntrack_acct.h>
#include <net/netfilter/nf_conntrack_helper.h>
#include <linux/module.h>

#include <linux/proc_fs.h>
#include <net/SI/fast6.h>
#include <net/SI/fast_common.h>

MODULE_LICENSE("GPL");

/* ***************** ipv6 תر ********************************/
spinlock_t fast6_spinlock; //Ĳ
fast_list_t working_list6 = {0};
struct hlist_nulls_head *working_hash6;
extern int speedMode;
extern struct sk_buff_head fast_txq;
extern struct tasklet_struct fast_tx_bh;
/* ********************************  ********************************/
extern int zvnet_get_index_by_netdev(struct net_device *net);
extern struct net_device *fast_br_parent(const struct net_device *dev);

/* ******************************** ʵ ********************************/
// ipv6ͷչѡжǷl4head
static int ip6nol4head(int type)
{
    int i, count;
    int optarray[] = {IPPROTO_ESP}; //ʱֻ֪ESPоЭչ

    count = sizeof(optarray)/sizeof(optarray[0]);
    for (i = 0; i < count; i++)
    {
        if (type == optarray[i])
            return (1);
    }
    return (0);
}

/*жǷIPV6չͷ*/
static int ip6option(int type)
{
    int i, optarray[8] = {IPPROTO_HOPOPTS, IPPROTO_IPV6, IPPROTO_ROUTING, IPPROTO_FRAGMENT,
            IPPROTO_ESP, IPPROTO_AH, IPPROTO_DSTOPTS, IPPROTO_NONE};
    
    for (i = 0; i < 8; i++)
    {
        if (type == optarray[i])
            return(optarray[i]);
    }
    return (0);
}

//skb->dataҪָipͷ
/*IPV6ͷչͷָL4ͷ,L4Э*/
unsigned char *getipv6uppkg(unsigned char *ippkg, unsigned char *protocol, int *uppkglen)
{
    unsigned char *ippkgpos = ippkg + 40;
    struct ip6_hdr *hdr = (struct ip6_hdr *)ippkg;
    struct ip6_opthdr *opthdr;
    int ip6hdrlen;
    int proto = 0;

    proto = ip6option(hdr->ip6_nxt);
    if (proto)
    {
#if 1
        return NULL;
#else	//Э鲻fast cov_2	
        if (ip6nol4head(proto))
            return NULL;
        
        opthdr =(struct ip6_opthdr *)ippkgpos;
        while ((proto = ip6option(opthdr->nxt)) != 0)
        {
            if (ip6nol4head(proto))
                return NULL;
            ippkgpos += (opthdr->len + 1) << 3;
            opthdr = (struct ip6_opthdr *)ippkgpos;
        }
        if (protocol)
            *protocol = opthdr->nxt;
        ippkgpos += (opthdr->len + 1) << 3;
#endif		
    }
    else
        if (protocol)
            *protocol = hdr->ip6_nxt;
        
    ip6hdrlen = ippkgpos - ippkg;
    
    if (uppkglen)
        *uppkglen = ntohs(hdr->ip6_plen) + 40 - ip6hdrlen;
    
    return (ippkgpos);
}

/*ȡIPV6ԪϢĿǰTCP/UDP/ICMP*/
int fast6_get_tuple(struct sk_buff *skb, struct nf_conntrack_tuple *tuple)
{
    if (!skb || !tuple)
    {
        return -1;
    }
    __u8 next_hdr;
    unsigned char *l4head;
    struct ipv6hdr *iph = (struct ipv6hdr *)skb->data;
    struct udphdr *udph = NULL;
    struct tcphdr *tcph = NULL;
    struct icmp6hdr *icmph = NULL;


    /* only IPv6 packets */    
    if (htons(ETH_P_IPV6) != skb->protocol)
    {
        return -1;
    }
    
    if (skb->len >= sizeof(struct ipv6hdr))
    {
        l4head = getipv6uppkg(skb->data, &next_hdr, NULL);
        if (l4head == NULL)
            return -1;
    }
    else
        return -1;
    
    memset(tuple, 0, sizeof(struct nf_conntrack_tuple));

    /* only tcp/udp */
    if (NEXTHDR_UDP == next_hdr)
    {
        udph = (struct udphdr *)l4head;
        tuple->src.u.udp.port = udph->source;
        tuple->dst.u.udp.port = udph->dest;
        skb_udpnum++;
    }
    else if (NEXTHDR_TCP == next_hdr)
    {
        tcph = (struct tcphdr *)l4head;
        tuple->src.u.tcp.port = tcph->source;
        tuple->dst.u.tcp.port = tcph->dest;
        skb_tcpnum++;
    }
    else if (NEXTHDR_ICMP == next_hdr)
    {
        icmph = (struct icmp6hdr *)l4head; /* point to ICMPv4 header */
        tuple->src.u.icmp.id = icmph->icmp6_identifier;
        tuple->dst.u.icmp.type = icmph->icmp6_type;
        tuple->dst.u.icmp.code = icmph->icmp6_code;
    }
    else
    {
        return -1;
    }

    tuple->src.l3num = AF_INET6;
    tuple->src.u3.in6 = iph->saddr;
    tuple->dst.u3.in6 = iph->daddr;
    tuple->dst.protonum = next_hdr;
    tuple->dst.dir = IP_CT_DIR_ORIGINAL;

    return 0;
#if 0
    struct ipv6hdr *iph6 = NULL;
    struct udphdr *udph = NULL;
    struct tcphdr *tcph = NULL;
    unsigned char proto = 0;
    unsigned char *l4h = NULL;

    if(!skb || !tuple)
    {
        return -1;
    }

    /* only IP packets */    
    if(htons(ETH_P_IP) != skb->protocol)
    {
        return -1;
    }

    iph6 = (struct ipv6hdr *)skb->data;

    /* not deal with fragment packets now */  

    if(ntohs(iph6->frag_off) & (IP_MF | IP_OFFSET))
    {
        return -1;
    }


    if(iph6->hop_limit <= 1)
    {
        return -1;
    }

    memset(tuple, 0, sizeof(struct nf_conntrack_tuple));

    /* only tcp/udp */
    l4h = getipv6uppkg(iph6, &proto, NULL);
    
    if(IPPROTO_UDP == proto)
    {
        udph = (struct udphdr *)l4h;
        tuple->src.u.udp.port = udph->source;
        tuple->dst.u.udp.port = udph->dest;
    }
    else if(IPPROTO_TCP == proto)
    {
        tcph = (struct tcphdr *)l4h;
        tuple->src.u.tcp.port = tcph->source;
        tuple->dst.u.tcp.port = tcph->dest;
    }
    else
    {
        return -1;
    }

    tuple->src.l3num = AF_INET;
    tuple->src.u3.in6 = iph6->saddr;
    tuple->dst.u3.in6 = iph6->daddr;
    tuple->dst.protonum = proto;
    tuple->dst.dir = IP_CT_DIR_ORIGINAL;

    return 0;
#endif
}

//˴Ҫֺdev_xmit_completeһ
//inline޷ȡļУֻfastnatfast6һ
static inline bool start_xmit_complete(int rc)
{
    /*
     * Positive cases with an skb consumed by a driver:
     * - successful transmission (rc == NETDEV_TX_OK)
     * - error while transmitting (rc < 0)
     * - error while queueing to a different device (rc & NET_XMIT_MASK)
     */
    if (likely(rc < NET_XMIT_MASK))
        return true;

    return false;
}

//ipv6ݰĿٴhashRCUƽбܵspinб
int fast6_recv(struct sk_buff *skb)
{
    struct nf_conntrack_tuple tuple;
    fast_entry_data_t *fast6_entry_data = NULL;
    fast_entry_t *fast6_entry = NULL;
    struct tcphdr *tcph = NULL;
    struct net_device *dev = NULL;
    __u8 next_hdr = 0;
    unsigned char *l4head;
    struct ipv6hdr *ip6;
	struct nf_conn_counter *acct = NULL;
	struct sk_buff *skb2 = NULL;
	int l4_offset = 0;
    
    //print_sun(SUN_DBG, "enter fast_6_recv \n");

    if (fastnat_level == FAST_CLOSE)
    {
        return 0;
    }
    
    if (fast6_get_tuple(skb, &tuple) < 0)
    {
        //print_sun(SUN_DBG, "fast_6_recv get tuple err \n");
        return 0;
    }
    
    ip6 = ipv6_hdr(skb);
    if (ip6->nexthdr != IPPROTO_TCP && ip6->nexthdr != IPPROTO_UDP)
        return 0;
    
    rcu_read_lock();
    //spin_lock_bh(&fast6_spinlock);
    fast6_entry_data = fast_find_entry_data(working_hash6, &tuple);
    if (fast6_entry_data == NULL)
    {
        rcu_read_unlock();
        //spin_unlock_bh(&fast6_spinlock);
        //print_sun(SUN_DBG, "fast_6_recv fast_6_find null \n");
        return 0;
    }

    fast6_entry = fast_data_to_entry(fast6_entry_data);
    if (!fast6_entry)
    {
        rcu_read_unlock();
        //spin_unlock_bh(&fast6_spinlock);
        //print_sun(SUN_DBG, "fast_6_recv fast6_entry is null \n");
        return 0;
    }

    /* ֻе˫ӶɹFASTNAT߱׼ */
    if (fast6_entry->flags != FAST_ALL_DIR)
    {
        rcu_read_unlock();
        //spin_unlock_bh(&fast6_spinlock);
        //print_sun(SUN_DBG, "fast_6_recv flags is not FAST_ALL_DIR \n");
        return 0;
    }

#if _USE_VEHICLE_DC
	if(fastbr_level != 1){
		if(fast6_entry_data->tuplehash.tuple.dst.dir == IP_CT_DIR_ORIGINAL){
			if(fast6_entry->data[IP_CT_DIR_REPLY].indev == NULL){
				printk("fast6_entry indev1 null %s\n", fast6_entry_data->outdev->name);
				rcu_read_unlock();
				return 0;
			}
			if(fast6_entry->data[IP_CT_DIR_REPLY].indev != fast6_entry_data->outdev){
				spin_lock_bh(&fast6_spinlock);
				dev_put(fast6_entry_data->outdev);
				dev_hold(fast6_entry->data[IP_CT_DIR_REPLY].indev);
				fast6_entry_data->outdev = fast6_entry->data[IP_CT_DIR_REPLY].indev;
				fast6_entry_data->hh_flag = 0;
				fast6_entry_data->vlan_tci = 0;
				spin_unlock_bh(&fast6_spinlock);
				rcu_read_unlock();
				return 0;
			}
		}else{
			if(fast6_entry->data[IP_CT_DIR_ORIGINAL].indev == NULL){
				printk("fast6_entry indev0 null %s\n", fast6_entry_data->outdev->name);
				rcu_read_unlock();
				return 0;
			}
			if(fast6_entry->data[IP_CT_DIR_ORIGINAL].indev != fast6_entry_data->outdev){
				spin_lock_bh(&fast6_spinlock);
				dev_put(fast6_entry_data->outdev);
				dev_hold(fast6_entry->data[IP_CT_DIR_ORIGINAL].indev);
				fast6_entry_data->outdev = fast6_entry->data[IP_CT_DIR_ORIGINAL].indev;
				fast6_entry_data->hh_flag = 0;
				fast6_entry_data->vlan_tci = 0;
				spin_unlock_bh(&fast6_spinlock);
				rcu_read_unlock();
				return 0;
			}
		}
	}else{
		if(fast6_entry_data->indev != NULL && fast6_entry_data->indev != skb->indev){
			/*tupleͬindevͬ·תİǰֻҪν*/
			rcu_read_unlock();
			return 0;
		}
	}
	if(skb->isvlan && fast6_entry_data->hh_flag == 0){
		rcu_read_unlock();
		return 0;
	}
#endif
    dev = fast6_entry_data->outdev;
    /*жϱĳǷ񳬹DEVMTU*/
    if (!dev || (skb->len > dev->mtu))
    {
        skbinfo_add(NULL, SKB_OVER_MTU);
        rcu_read_unlock();
        //spin_unlock_bh(&fast6_spinlock);
        //print_sun(SUN_DBG, "fast_6_recv outdev err \n");
        return 0;
    }
    
    //شİֱͷŲ
    if (strcmp(skb->dev->name, dev->name) == 0)
    {
        skbinfo_add(NULL, SKB_LOOP);
        rcu_read_unlock();
        //spin_unlock_bh(&fast6_spinlock);    /*add by jiangjing*/
        kfree_skb(skb);
        printk("loopback skb %s, free skb\n", dev->name);
        return 1;
    }

    /*IPV6ͷȡL4ͷָ*/
    l4head = getipv6uppkg(skb->data, &next_hdr, NULL);
    if (l4head == NULL)
    {
        rcu_read_unlock();
        //spin_unlock_bh(&fast6_spinlock);
        //print_sun(SUN_DBG, "fast_6_recv l4head is null \n");
        return 0;
    }
	l4_offset = l4head - skb->data;
    //tcpdumpin_sq(skb);
#if _USE_VEHICLE_DC
	if(skb->indev && zvnet_get_index_by_netdev(skb->indev) >= 0 && (zvnet_get_index_by_netdev(dev) >= 0 || 
		((dev->priv_flags & IFF_EBRIDGE) && (fast_br_parent(skb->indev) != dev)))){
		rcu_read_unlock();
		return 0;
	}
	if(fastbr_level != 1){
		if (IPPROTO_TCP == tuple.dst.protonum){
			tcph = (struct tcphdr *)l4head;
			if(tcph->rst || tcph->fin){
				update_tcp_timeout(fast6_entry, fast6_entry_data, tcph);
				rcu_read_unlock();
				return 0;
			}
		}
		if(fast6_entry->cap_nfct == NULL){
			int zvnet_id = zvnet_get_index_by_netdev(skb->indev);
			if(zvnet_id < 0 && skb->nfct_bak == NULL){
				/*zvnetݣߵfast¼ctfast*/
				skb->nfct_bak = &fast6_entry->ct->ct_general;
				nf_conntrack_get(skb->nfct_bak);
				fast6_entry->ct->fast_entry = fast6_entry;
			}
			if(skb->capNfct && skb->zvnet_id){
				if(skb->nfct_bak != NULL && skb->nfct_bak != fast6_entry->ct){
					rcu_read_unlock();
					if(printk_ratelimit())
						printk("IPV6NAT ctin %x!=ctout %x nofast\n", skb->nfct_bak, fast6_entry->ct);
					return 0;
				}
				spin_lock_bh(&fast6_spinlock);
				if(zvnet_id >= 0 && fast6_entry_data->zvnet_id == 0){
					fast6_entry_data->zvnet_id = zvnet_id+1;
					if(fast6_entry_data->tuplehash.tuple.dst.dir == IP_CT_DIR_ORIGINAL){
						fast6_entry->data[IP_CT_DIR_REPLY].zvnet_id = skb->zvnet_id;
					}else{
						fast6_entry->data[IP_CT_DIR_ORIGINAL].zvnet_id = skb->zvnet_id;
					}
				}
				fast6_entry->fwd_entry = fast6_entry;
				fast6_entry->cap_nfct = skb->capNfct;
				atomic_set(&fast6_entry->data[0].pkt, 0);
				atomic_set(&fast6_entry->data[0].len, 0);
				atomic_set(&fast6_entry->data[1].pkt, 0);
				atomic_set(&fast6_entry->data[1].len, 0);
				spin_unlock_bh(&fast6_spinlock);
				skb->capNfct = NULL;
			}else{
				if(zvnet_id < 0 && zvnet_get_index_by_netdev(dev) < 0){
					rcu_read_unlock();
					return 0;
				}
				if(fast6_entry_data->indev != skb->indev){
					rcu_read_unlock();
					return 0;
				}
			}
		}else{
			if (fast6_entry_data->hh_flag != 2){
				rcu_read_unlock();
				return 0;
			}
			atomic_inc(&fast6_entry_data->pkt);
			atomic_add(skb->len, &fast6_entry_data->len);
			if(atomic_read(&fast6_entry_data->len) > 1000000 && 
				fast6_entry->data[0].zvnet_id && fast6_entry->data[1].zvnet_id){
				cap_conntrack_update_end(fast6_entry->cap_nfct,
					atomic_read(&fast6_entry->data[0].pkt),atomic_read(&fast6_entry->data[0].len),
					atomic_read(&fast6_entry->data[1].pkt),atomic_read(&fast6_entry->data[1].len),
					fast6_entry->data[1].zvnet_id,fast6_entry->data[0].zvnet_id);
					spin_lock_bh(&fast6_spinlock);
					atomic_set(&fast6_entry->data[0].pkt, 0);
					atomic_set(&fast6_entry->data[0].len, 0);
					atomic_set(&fast6_entry->data[1].pkt, 0);
					atomic_set(&fast6_entry->data[1].len, 0);
					spin_unlock_bh(&fast6_spinlock);
			}
		}
	}
#endif

    if (!(skb2 = fast_expand_headroom_v6(skb, dev))){
		rcu_read_unlock();
        return 1;
    }
	
	if(skb2 != skb){
		l4head = skb2->data + l4_offset;
		skb = skb2;
		skb_expand6++;
	}
	
    fast_tcpdump(skb);
    
    //ץУݻclonefastɹҪıdataݣҪcopyһ
    if (skb_cloned(skb))
    {
        //print_sun(SUN_DBG, "fast6_recv clone \n");
        if (pskb_expand_head(skb, 0, 0, GFP_ATOMIC))
        {
            rcu_read_unlock();
            //spin_unlock_bh(&fast6_spinlock);
            //print_sun(SUN_DBG, "fast6_recv clone copy failed !!!\n");
            printk("pskb_expand_head skb failed, free skb\n");
            kfree_skb(skb);
            return 1;
        }
    }

    //fast6ɹIPͷ׵ַ,Թcacheˢʱʹ
    skb_reset_network_header(skb);
    skb->isFastnat = 1;
    skb->priority = fast6_entry_data->priority;
    skb->mark = fast6_entry_data->mark;

    //ctӵͳ --- ͳƶǶIPMAC
    if (fast6_entry_data->tuplehash.tuple.dst.dir == IP_CT_DIR_ORIGINAL){
        fast6_entry->ct->packet_info[IP_CT_DIR_ORIGINAL].packets++;
        fast6_entry->ct->packet_info[IP_CT_DIR_ORIGINAL].bytes += skb->len;
    } else if (fast6_entry_data->tuplehash.tuple.dst.dir == IP_CT_DIR_REPLY){
        fast6_entry->ct->packet_info[IP_CT_DIR_REPLY].packets++;
        fast6_entry->ct->packet_info[IP_CT_DIR_REPLY].bytes += skb->len;
    } else {
        printk("fast6 packet error\n");
    }

    //ںԴĻӵͳ
    acct = nf_conn_acct_find(fast6_entry->ct);
    if (acct) {
        enum ip_conntrack_info ctinfo;
        if (fast6_entry_data->tuplehash.tuple.dst.dir == IP_CT_DIR_ORIGINAL)
            ctinfo = IP_CT_ESTABLISHED;
        else 
            ctinfo = IP_CT_ESTABLISHED_REPLY;

        atomic64_inc(&acct[CTINFO2DIR(ctinfo)].packets);
        atomic64_add(skb->len, &acct[CTINFO2DIR(ctinfo)].bytes);
    }

    /* ƹܣΪ˽UDPʱ޷֪indevͳⶨ */
    if ((fast6_entry_data->indev == NULL) && skb->dev)
    {
        fast6_entry_data->indev = skb->dev;
    }

    // ͳ豸Ľհ  --- οlinuxԭͳƵĶIP
    if (fast6_entry_data->indev && (fastnat_level == FAST_NET_DEVICE))
    {
        fast6_entry_data->indev->stats.rx_packets++;
        fast6_entry_data->indev->stats.rx_bytes += skb->len;
    }  
	//豸skb->indevʵdevfast¼
	if(skb->indev && fast6_entry_data->indev != skb->indev && (fastnat_level == FAST_NET_DEVICE)){
        skb->indev->stats.rx_packets++;
        skb->indev->stats.rx_bytes += skb->len;
	}

    skb->dev = dev;
#if _USE_VEHICLE_DC
	skb->vlan_tci = fast6_entry_data->vlan_tci;
#endif
    //ֻеMACͷԤֵʱ׼ֵΪIPͷ
    skb_push(skb, ETH_HLEN);

    if (fast6_entry_data->hh_flag)
    {
        memcpy(skb->data, fast6_entry_data->hh_data, ETH_HLEN);
    }

    /*ӳʱ*/
    if (IPPROTO_TCP == tuple.dst.protonum)
    {
        mod_timer(&fast6_entry->timeout, jiffies + tcp_timeouts[fast6_entry->ct->proto.tcp.state]);
        tcph = (struct tcphdr *)l4head;
        update_tcp_timeout(fast6_entry, fast6_entry_data, tcph);
    }
    else if (IPPROTO_UDP == tuple.dst.protonum)
    {
        /*udp*/
        if (fast_test_bit(IPS_SEEN_REPLY_BIT, fast6_entry->ct->status))
        {
            mod_timer(&fast6_entry->timeout, jiffies + fast_udp_timeout_stream);
        }
        else
        {
            mod_timer(&fast6_entry->timeout, jiffies + fast_udp_timeout);
        }
    }

    if (skb->dev->flags & IFF_UP)
    {
        //pppֻҪIP
        if (skb->dev->type == ARPHRD_PPP)//(strncmp(skb->dev->name, ppp_name, strlen(ppp_name)) == 0)
        {
           skb_pull(skb, ETH_HLEN);
        }
        
        skb->now_location |= FAST6_SUCC;
        if (fastnat_level == FAST_NET_DEVICE)
        {
            //print_sun(SUN_DBG, "fastnat-2 dev_queue_xmit, send to:%s !!!!!!!! \n", skb->dev->name);
             if(speedMode == 0)
            {
            	dev_queue_xmit(skb);
            }
			else if(skb->dev->netdev_ops && skb->dev->netdev_ops->ndo_start_xmit
				&& skb->dev->netdev_ops->ndo_select_queue == NULL
				&& (skb->dev->type != ARPHRD_PPP) && skb->vlan_tci == 0)//wifi豸ڶҪskb_set_queue_mappingҷppp0
			{
				//skb->dev->netdev_ops->ndo_start_xmit(skb, skb->dev);
				int rc = -ENOMEM;
				rc = skb->dev->netdev_ops->ndo_start_xmit(skb, skb->dev);
				if (!dev_xmit_complete(rc)) {
					skb->dev->stats_dbg.tx_dropped++;
					skb->dev->stats.tx_dropped++;
					skbinfo_add(NULL,SKB_ERRFREE);
					kfree_skb(skb);
				}
			}
			else if(skb->dev->type == ARPHRD_PPP)
			{
				skb_queue_tail(&fast_txq, skb);
				tasklet_schedule(&fast_tx_bh);
			}
			else
			{
				dev_queue_xmit(skb);
			}
        }
        //صӦãֻ߱׼fastnaṭ޷вִ
        else if (fastnat_level == FAST_NET_CORE)
        {
            dev_queue_xmit(skb);
        }
        /*add by jiangjing*/
        fast6_entry_data->packet_num++;

        //dev_queue_xmit(skb);
        //dev_put(dev);
    }
    else
    {
        //print_sun(SUN_DBG, "fast6_recv ERR &&&&&& %s DOWN, kfree_skb!!!!!!!! \n", skb->dev->name);
        kfree_skb(skb);
    }

    rcu_read_unlock();
    //spin_unlock_bh(&fast6_spinlock);
    
    //fast6_entry_data->packet_num++;
    //print_sun(SUN_DBG, "fast_6_recv okokok \n");
    return 1;
}

static struct nf_hook_ops fast6_hook = {
    .hook = napt6_handle,
    .owner = THIS_MODULE,
    .pf = PF_INET6,
    .hooknum = NF_INET_POST_ROUTING,
    .priority = NF_IP6_PRI_LAST,
};

//POST_ROUTINGڵ㣬fastӵĸֵhash
unsigned int napt6_handle(unsigned int hooknum,
            struct sk_buff *skb,
            const struct net_device *in,
            const struct net_device *out, int (*okfn) (struct sk_buff *))
{
    struct nf_conn *ct;
    enum ip_conntrack_info ctinfo;
    u_int8_t protocol;
    fast_entry_t *fast6_entry;
    fast_entry_data_t *fast6_entry_data;
    enum ip_conntrack_dir dir, rdir;
    struct dst_entry *dst = skb_dst(skb);
#ifdef CONFIG_ATHRS_HW_NAT
    u_int32_t mask =0;
#endif

    if (fastnat_level == FAST_CLOSE || fastnat_level == FAST_CLOSE_KEEP_LINK)
    {
        return NF_ACCEPT;
    }

    if (fast_test_bit(FAST_TYPE_VERSION_BIT, fast_switch))
    {
        return NF_ACCEPT;
    }
    
    if (!out)
    {
        return NF_ACCEPT;
    }
    
    if (ipv6_hdr(skb)->nexthdr != IPPROTO_TCP && ipv6_hdr(skb)->nexthdr != IPPROTO_UDP)
        return NF_ACCEPT;

    //鲥
    if (ipv6_addr_is_multicast(&ipv6_hdr(skb)->daddr))
    {
        return NF_ACCEPT;
    }

    //˴ҪעǷƵfast֣Ƿɸ
    if (working_list6.count > nf_conntrack_max)
    {
        return NF_ACCEPT;
    }

    /*жǷһ*/
    if (!dst)
    { 
        return NF_ACCEPT;
    }
    
    if (dst->_neighbour && memcmp(dst->_neighbour->ha, zeromac, ETH_ALEN) == 0)
    {
        //pppipv6תʱûгԣδ
        //if (strncmp(out->name, ppp_name, strlen(ppp_name)) != 0)
        //{
        return NF_ACCEPT;
        //}
    }

    if (!(ct = nf_ct_get(skb, &ctinfo)))
    {
        return NF_ACCEPT;
    }
    protocol = nf_ct_protonum(ct);

#if 0 
    //only fast 6
    if (1 == ct->isbih)
        return NF_ACCEPT;
#endif

#if 0 
    /* only nat */
    if(!fast_test_bit(IPS_SRC_NAT_BIT, ct->status) && 
        !fast_test_bit(IPS_DST_NAT_BIT, ct->status))
    {
        return NF_ACCEPT;
    }
#endif

    /* only forward */
    if (!skb->skb_iif)
    {
        return NF_ACCEPT;
    }

    /*skip www because fastnat can't process url filter*/
#if 0
    if(ct->tuplehash[IP_CT_DIR_ORIGINAL].tuple.dst.u.all == WWW_PORT)
    {
        XDBG_PRINT(XDBG_FASTNAT_ADD_ENTRY, XDBGLV_DEBUG, "skip www\n");
        return NF_ACCEPT;
    }
#endif

    //˲ҪfastnatЭ
    if (check_skip_ports(ct->tuplehash[IP_CT_DIR_ORIGINAL].tuple.dst.u.all))
    {
        return NF_ACCEPT;
    }

    dir = CTINFO2DIR(ctinfo);
    
    rdir = (IP_CT_DIR_ORIGINAL == dir) ? IP_CT_DIR_REPLY: IP_CT_DIR_ORIGINAL;
    
    if (IPPROTO_TCP == protocol)
    {
        /* only established */
        if(!fast_test_bit(IPS_ASSURED_BIT, ct->status))
        {
            return NF_ACCEPT;
        }
    }
    else if (IPPROTO_UDP != protocol)
    {
        return NF_ACCEPT;
    }

    spin_lock_bh(&fast6_spinlock);
    if (!(fast6_entry = fast_get_entry(&working_list6, ct, dir, 6)))
    {
        spin_unlock_bh(&fast6_spinlock);
        return NF_ACCEPT;
    }
    fast6_entry->fast_spinlock = &fast6_spinlock;

    //״νȡctɾctʱ״νظܲ
    if (!(fast6_entry->flags & FAST_ALL_DIR))
    {
        nf_conntrack_get(&ct->ct_general);
        del_timer(&ct->timeout);
    }

    fast6_entry_data = &fast6_entry->data[dir];
    fast6_entry_data->tuplehash.tuple = ct->tuplehash[dir].tuple;

    //memcpy(fast6_entry_data->dmac, dst->_neighbour->ha, ETH_ALEN);
    //fast6_entry_data->tos = ip_hdr(skb)->tos;
    fast6_entry_data->priority = skb->priority;
    fast6_entry_data->mark = skb->mark;
	if(fast6_entry_data->outdev == NULL){
    fast6_entry_data->outdev = out;

#if 0
    if (tos_ignore_flag) {
        fast6_entry_data->priority = 0;
        fast6_entry_data->flow_lbl[0] = 0;
    } else {
        fast6_entry_data->priority = (ip_hdr(skb)->tos & 0xf0) >> 4;
        fast6_entry_data->flow_lbl[0] = (ip_hdr(skb)->tos & 0x0f) << 4;
    }
    
    fast6_entry_data->flow_lbl[1] = 0;
    fast6_entry_data->flow_lbl[2] = 0;
#endif 
    if (!record_MAC_header(working_hash6, ct, fast6_entry, fast6_entry_data, dst->_neighbour, out, htons(ETH_P_IPV6)))
    {
        spin_unlock_bh(&fast6_spinlock);
        return NF_ACCEPT;
    }
	}
    //˴֤λͻ
    fast6_entry->flags = fast6_entry->flags | (1 << dir);
    
    fast_add_entry(working_hash6, fast6_entry_data);
#if _USE_VEHICLE_DC
	if(fastbr_level != 1){
		if(fast6_entry->data[dir].indev == NULL)
			fast6_entry->data[dir].indev = skb->indev;
	}else {
		if (fast6_entry->flags == FAST_ALL_DIR){
			fast6_entry->data[0].indev = fast6_entry->data[1].outdev;
			fast6_entry->data[1].indev = fast6_entry->data[0].outdev;
		}
	}
#else
    if (fast6_entry->flags == FAST_ALL_DIR)
    {
        fast6_entry->data[0].indev = fast6_entry->data[1].outdev;
        fast6_entry->data[1].indev = fast6_entry->data[0].outdev;
    }
#endif
    spin_unlock_bh(&fast6_spinlock);

    ct->fast_ct.isFast = FAST_CT_WND6;
#if _USE_VEHICLE_DC
	if(skb->nfct_bak == NULL){
		skb->nfct_bak = &ct->ct_general;
		nf_conntrack_get(skb->nfct_bak);
		ct->fast_entry = fast6_entry;
	}
#endif
	//ɾentryбŻԿʱȴӴɾȡظͷ
	fast_entry_del_cleanup();
    
    return NF_ACCEPT;
}

/*֪ͨ¼*/
int fast6_event(traverse_command_t *cmd)
{
    spin_lock_bh(&fast6_spinlock);
    traverse_process(&working_list6, cmd);
    spin_unlock_bh(&fast6_spinlock);
	return 0;
}

//fastnat_levelرգipv6תϢ
void fast6_cleanup_links(void)
{
    spin_lock_bh(&fast6_spinlock);
    fast_cleanup_links(&working_list6);
    spin_unlock_bh(&fast6_spinlock);
}

int tsp_fast6_init(void)
{
    int ret;
    
    //print_sun(SUN_DBG,"start init fast6\n");

    working_hash6 = nf_ct_alloc_hashtable(&nf_conntrack_htable_size, /*&fast6hash_vmalloc,*/ 1);
    if (!working_hash6) 
    {
        //print_sun(SUN_DBG, "Unable to create working_hash6\n");
        return -EINVAL;
    }

    spin_lock_init(&fast6_spinlock);

    ret = nf_register_hook(&fast6_hook);
    if (ret != 0)
    {
        //print_sun(SUN_DBG,"init fast6 failed\n");
        goto err;
    }
    
    //print_sun(SUN_DBG,"init fast6 done\n");
    return 0;
    
err:
    nf_ct_free_hashtable(working_hash6, /*fast6_hash_vmalloc, */nf_conntrack_htable_size);
    return -EINVAL;
}

int tsp_fast6_cleanup(void)
{
    nf_unregister_hook(&fast6_hook);
    nf_ct_free_hashtable(working_hash6, /*fast6_hash_vmalloc,*/ nf_conntrack_htable_size);
    
    //print_sun(SUN_DBG,"fast6 cleanup done\n");
    return 0;
}

