# /*****************************************************************************
#* Ȩ (C)2014, ͨѶɷ޹˾
#* 
#* ļ:     gcc_arm_linux.mk
#* ļʶ:     gcc_arm_linux.mk
#* ժҪ:     linux gccļ
#* ʹ÷:     include gcc_arm_linux.mk
#* 
#* ޸        汾      ޸ı        ޸          ޸
#* -----------------------------------------------------------------------------
#* 2014/09/09      V1.0        Create                    
#* 
# ******************************************************************************/

#===============================================================================
# compiler tools path, CROSS_COMPILE_ROOT is set in root Makefile
#===============================================================================
GCC_ROOT    = $(CROSS_COMPILE_ROOT)
GCC_BIN     = $(GCC_ROOT)/bin
GCC_LIB     = $(GCC_ROOT)/lib

#===============================================================================
# compiler tools setup
#===============================================================================
CC          = $(GCC_BIN)/$(CROSS_COMPILE_PREFIX)gcc
CXX         = $(GCC_BIN)/$(CROSS_COMPILE_PREFIX)gcc
ASM         = $(GCC_BIN)/$(CROSS_COMPILE_PREFIX)as
AR          = $(GCC_BIN)/$(CROSS_COMPILE_PREFIX)ar
AR2         = $(GCC_BIN)/$(CROSS_COMPILE_PREFIX)gcc-ar
LD          = $(GCC_BIN)/$(CROSS_COMPILE_PREFIX)ld
ELF2BIN     = $(GCC_BIN)/$(CROSS_COMPILE_PREFIX)objcopy
ELF2SYM	    = $(GCC_BIN)/$(CROSS_COMPILE_PREFIX)nm

#===============================================================================
# C include path setup
#===============================================================================
INCLUDE     =   -I$(LINUX_ROOT)/arch/arm/include                            \
                -I$(LINUX_ROOT)/arch/arm/include/uapi                       \
                -I$(LINUX_ROOT)/arch/arm/include/generated                  \
                -I$(LINUX_ROOT)/include                                     \
                -I$(LINUX_ROOT)/include/uapi                                \
                -I$(LINUX_ROOT)/kernel                                      \
                -include $(LINUX_ROOT)/include/linux/kconfig.h              \
                -I$(LINUX_ROOT)/arch/arm/mach-$(PRJ_NAME)/include

#===============================================================================
# C++ STL(standard template library) include path setup
#===============================================================================
STDINCLUDE  += 

#===============================================================================
# gcc flags setup
#===============================================================================
export CCFLAGS  = -nostdinc -isystem $(CROSS_COMPILE_INCLUDE)
export CCFLAGS  += -mlittle-endian -Wall -Wundef -Wstrict-prototypes -Wno-trigraphs -fno-strict-aliasing -fno-common
export CCFLAGS  += -Wno-format-security -fno-delete-null-pointer-checks
#export CCFLAGS  += -marm -fno-dwarf2-cfi-asm -mabi=aapcs-linux -mno-thumb-interwork -funwind-tables
export CCFLAGS  += -fno-dwarf2-cfi-asm -mabi=aapcs-linux
ifeq ($(CONFIG_MIN_8M_VERSION), n)
CCFLAGS  += -funwind-tables
endif
export CCFLAGS  += -msoft-float -Uarm -Wframe-larger-than=1024 -fno-stack-protector
export CCFLAGS  += -Wno-unused-but-set-variable -fomit-frame-pointer -g -fno-inline-functions-called-once 
export CCFLAGS  += -Wdeclaration-after-statement -Wno-pointer-sign -fno-strict-overflow -fconserve-stack
export CCFLAGS  += -Wno-redundant-decls -Wno-write-strings
export CCFLAGS  += -march=$(CPU_ARCH) -mno-unaligned-access
#export CCFLAGS  += -finstrument-functions

export CCFLAGS  += -fno-short-enums -fsigned-char -fstrict-volatile-bitfields
export CCFLAGS  += -fno-schedule-insns -fno-schedule-insns2
export CCFLAGS  += -Wfatal-errors -Wno-declaration-after-statement -Wno-unused-value
export CCFLAGS  += -Wno-unused-variable -Wno-unused-function -Wno-missing-braces
export CCFLAGS  += -Wno-unknown-pragmas -Wno-format-extra-args
export CCFLAGS  += -D__KERNEL__ -D__LINUX_ARM_ARCH__=7

ifeq ($(THUMB), yes)
export CCFLAGS  += -mthumb -mthumb-interwork -Wa,-mimplicit-it=thumb
ifeq ($(USE_CPPS_KO), yes)
export CCFLAGS  += -mlong-calls
endif
else
export CCFLAGS  += -marm
endif

ifeq ($(CONFIG_MIN_8M_VERSION), y)
export CCFLAGS  += -ffunction-sections
endif

export CCFLAGS  += -Wl,--gc-sections
export CCFLAGS  += -g -Os -MD -c
export CXXFLAGS =  $(CCFLAGS)

#===============================================================================
# assembler flags setup
#===============================================================================
ASFLAGS     = -march=$(CPU_ARCH)

#===============================================================================
# archieve flags setup
#===============================================================================
ARFLAGS     = -rcs
ARFLAGS2     = rcSTPD


#===============================================================================
# library include path setup
#===============================================================================
LDFLAG      = -Wl,--no-check-sections -nostartfiles -L$(GCC_LIB) -T$(PRJ_PATH)/ws/dosmake/makefw/os/tos/tos.ld

#===============================================================================
# ld setup
#===============================================================================
LDOUT       = 
LDMAP       = 

#===============================================================================
# elf to binary flags setup
#===============================================================================
ELF2BINOUT  = -O binary

#===============================================================================
# elf to symbol flags setup
#===============================================================================
ELF2SYMOUT	= -nCS --size-sort

#===============================================================================
# user defintion
#===============================================================================
export PLAT_GCC_OPTIMIZE    = -O2
export COM_GCC_OPTIMIZE     = -O2
export DRV_GCC_OPTIMIZE     = -O2
export PS_GCC_OPTIMIZE      = -O2
export TOOLS_GCC_OPTIMIZE   = -O2

