# ------------------------------------------------------------------------ #
# Compiler makefile for Microsoft Visual C++ 6.0                           #
# ------------------------------------------------------------------------ #
.PHONY :

# ------------------------------------------------------------------------ #
# Compiler tools
# ------------------------------------------------------------------------ #
CC            = cl.exe
CPP           = cl.exe
THUMBCC       = cl.exe
THUMBCPP      = cl.exe
ASM           =
LINK          = link.exe
CONV          =
AR            = lib.exe



# ---------------------------------------------------------------------------
# Apply Rational Realtime when CODECOVERAGE=YES                              
# ---------------------------------------------------------------------------
# todo: for backward compatibility, should be removed later
ifeq '$(DEBUGINFO)' ''
	ifeq '$(BUILDMODE)' 'DEBUG'
			DEBUGINFO=YES
	endif
endif

ifeq '${CODECOVERAGE}' 'YES'
ifeq '${TESTENVIRONMENT}' 'URRCM'
ifneq '$(findstring ${BUILD_LIB},urrc urrcbp urrcdc urrcm)' ''
CC            = attolcc -proc=ret -call -block=logical -cond=modified -count --atl_multi_treads=1 -- cl.exe
endif # ifneq '$(findstring ${BUILD_LIB},urrc urrcbp urrcdc urrcm)' ''
endif # ifeq '${TESTENVIRONMENT}' 'URRCM'

ifeq '${TESTENVIRONMENT}' 'UPDCP'
ifneq '$(findstring ${BUILD_LIB},urabmupdcp sif)' ''
CC            = attolcc -proc=ret -call -block=logical -cond=modified -count --atl_multi_treads=1 -- cl.exe
endif # ifneq '$(findstring ${BUILD_LIB},urabmupdcp sif)' ''
endif # ifeq '${TESTENVIRONMENT}' 'UPDCP'

ifeq '${TESTENVIRONMENT}' 'URLC'
ifneq '$(findstring ${BUILD_LIB},urlcc urlcdl urlcul)' ''
CC            = attolcc -proc=ret -call -block=logical -cond=modified -count --atl_multi_treads=1 -- cl.exe
endif # ifneq '$(findstring ${BUILD_LIB},urlcc urlcdl urlcul)' ''
endif # ifeq '${TESTENVIRONMENT}' 'URLC'

ifeq '${TESTENVIRONMENT}' 'UMAC'
ifneq '$(findstring ${BUILD_LIB},umac security ugdci)' ''
CC            = attolcc -proc=ret -call -block=logical -cond=modified -count --atl_multi_treads=1 -- cl.exe
endif # ifneq '$(findstring ${BUILD_LIB},umac security ugdci)' ''
endif # ifeq '${TESTENVIRONMENT}' 'UMAC'

ifeq '${TESTENVIRONMENT}' 'USIM'
ifneq '$(findstring ${BUILD_LIB},usim)' ''
CC            = attolcc -proc=ret -call -block=logical -cond=modified -count --atl_multi_treads=1 -- cl.exe
endif # ifneq '$(findstring ${BUILD_LIB},usim)' ''
endif # ifeq '${TESTENVIRONMENT}' 'USIM'

endif # ifeq '${CODECOVERAGE}' 'YES'

# ------------------------------------------------------------------------ #
# Extensions for standard files
# ------------------------------------------------------------------------ #
OBJFILEEXT    = obj
DEPFILEEXT    = dep
OUTPUTFILEEXT = exe
SRCFILEEXT    = src
MAPFILEEXT    = map
LIBFILEEXT    = lib
ERRFILEEXT    = err
SBRFILEEXT    = sbr
PDBFILEEXT    = pdb

CC_DEFPREFIX = -D
CC_INCPREFIX = -I

export COMPILER_VERSION := $(shell $(CC) 2>&1 | $(SED) -n "s/.*Version  *\([0-9]*\).*/\1/p")

msvc_version : 
	-@$(ECHO) "COMPILER VERSION: $(COMPILER_VERSION)"


# ======================================================================== #
# Common compiler switches for C and C++ compiler
# ======================================================================== #
CC_CPP_OPTIONS      = /nologo                   # no logo and info messages

ifeq '$(WARNINGS)' 'YES'
    CC_CPP_OPTIONS     += /W3                   # Warning level 3 - recommended for production purposes
else
ifeq '$(WARNINGS)' 'NO'
    CC_CPP_OPTIONS     += /W0                   # Warning level 0 - disable all warnings
else
    CC_CPP_OPTIONS     += /W3                   # Warning level 3 - default
endif
endif

CC_CPP_OPTIONS     += /c                        # compile without linking
CC_CPP_OPTIONS     += /Od                       # no optimization, speed compilation, debugging
CC_CPP_OPTIONS     += ${CC_DEFPREFIX}_MBCS      # default define:
CC_CPP_OPTIONS     += ${CC_DEFPREFIX}_MSC       # default define:
CC_CPP_OPTIONS     += ${CC_DEFPREFIX}_CONSOLE   # default define:
CC_CPP_OPTIONS     += ${CC_DEFPREFIX}_LIB       # default define:
CC_CPP_OPTIONS     += ${CC_DEFPREFIX}_Windows       # default define:
CC_CPP_OPTIONS     += ${CC_DEFPREFIX}MSVCWIN       # default define:
CC_CPP_OPTIONS     += ${CC_DEFPREFIX}_WIN32       # default define:

ifeq '$(DEBUGINFO)' 'YES'                   # --- debug info
    CC_CPP_OPTIONS += ${CC_DEFPREFIX}_DEBUG
    CC_CPP_OPTIONS += /MTd                  # multithread debug
    ifeq '$(COMPILER_VERSION)' '14'
        CC_CPP_OPTIONS += /RTC1             # catch release build errors
    else
        CC_CPP_OPTIONS += /GZ               # catch release build errors
    endif
    CC_CPP_OPTIONS += /Zi                   # create additional debug library
    CC_CPP_OPTIONS += /Fd${LIBDIR}/$(basename ${BUILD_LIB}).${PDBFILEEXT} # location of PDB library
else                                        # --- release mode
    CC_CPP_OPTIONS += /MT                   # multithread
    CC_CPP_OPTIONS += /Gi-                  # dissable incremental compilation
endif

ifneq '$(TESTENVIRONMENT)' ''
    CC_CPP_OPTIONS += /D__thumb             # compile test build like target build
    CC_CPP_OPTIONS += /DUNITEST             # define UniTest build
    CC_CPP_OPTIONS += /DSID_DEFINED	    # 
    CC_CPP_OPTIONS += /DWIN32_LEAN_AND_MEAN # don't include unwanted Microsoft specific header files
    CC_CPP_OPTIONS += /DNOGDI               # ditto
    CC_CPP_OPTIONS += /DNOCRYPT             # ditto
endif

# --- add compiler and library specific compile switches
CC_CPP_OPTIONS += ${MSVC_OPTIONS} $(MSVC_CC_CPP_OPTIONS_$(BUILD_LIB))

# --- assembler files - not used yet
ifneq '$(ASMCODEGEN)' ''
endif

# --- the *_CMD variable contains options that may not go into via-file
CC_CPP_OPTIONS_CMD += /Fo${OBJDIR}/${BUILD_LIB}/$(@F) # specifiy obj name
CC_CPP_OPTIONS_CMD += $(subst \,/,$<)                 # source file
ifneq '$(TESTENVIRONMENT)' ''
    CC_CPP_OPTIONS_CMD += /FR${SBRDIR}/${BUILD_LIB}/$(basename ${@F}).${SBRFILEEXT} # create browse info file
endif
ifeq '${ERRORLOG}' 'YES'
    CC_CPP_OPTIONS_CMD += 2>&1 > ${ERRDIR}/${BUILD_LIB}/$(basename ${@F}).${ERRFILEEXT}
endif


# ======================================================================== #
# C and C++ specific compiler switches
# ======================================================================== #
CC_INCL  = $(strip $(addprefix ${CC_INCPREFIX},  \
                                               ${CC_INCLUDE} \
                                               ${${BUILD_LIB}_INC} \
            )       )
CC_DEF   = $(strip $(addprefix ${CC_DEFPREFIX},$(SYSTEM_DEFS) \
                                               ${L1_DEFS} \
                                               ${CC_DEFS}  \
                                               ${CCC_DEFS_PLATFORM} ) )
CPP_INCL = $(strip $(addprefix ${CC_INCPREFIX}, \
                                               ${CPP_INCLUDE} \
                                               ${${BUILD_LIB}_INC}\
            )       )
CPP_DEF  = $(strip $(addprefix ${CC_DEFPREFIX},${SYSTEM_DEFS} \
                                               ${L1_DEFS} \
                                               ${CPP_DEFS} \
                                               ${CPP_DEFS_PLATFORM} ) )

CC_OPTIONS  = ${CC_INCL} ${CC_DEF} ${MSVC_CC_OPTIONS} $(MSVC_CC_OPTIONS_$(BUILD_LIB))
CPP_OPTIONS = ${CPP_INCL} ${CPP_DEF} ${MSVC_CPP_OPTIONS} $(MSVC_CPP_OPTIONS_$(BUILD_LIB))
CPP_OPTIONS+= -we4150 # turn warning C4150 into error since it's to serious

# precompiled header are only supported for cpp
ifeq '$(findstring hpp,${PCH_FILE})' 'hpp'
    PCH_FILENAME      = ${OBJDIR}/$(BUILD_LIB)/$(basename $(PCH_BUILD_FILE)).pch
    # add pch-options to source-options
    PCH_USE_OPTIONS    += /Yu${PCH_FILE} /Fp${PCH_FILENAME}
    # build specific pch-options
    PCH_CREATE_OPTIONS += /Yc${PCH_FILE} /Fp${PCH_FILENAME}
endif


# ======================================================================== #
# combining, via files
# ======================================================================== #
CC_COMPLETE_TMP  = ${CC_CPP_OPTIONS} ${CC_OPTIONS}
CPP_COMPLETE_TMP = ${CC_CPP_OPTIONS}              ${CPP_OPTIONS} ${PCH_USE_OPTIONS}
PCH_COMPLETE_TMP = ${CC_CPP_OPTIONS}              ${CPP_OPTIONS} ${PCH_CREATE_OPTIONS}

ifeq '${VIAFILE}' 'YES'
    VIA_CC_COMPLETE  = ${CC_COMPLETE_TMP}
    VIA_CPP_COMPLETE = ${CPP_COMPLETE_TMP}
    VIA_PCH_COMPLETE = ${PCH_COMPLETE_TMP}
    CC_COMPLETE  = @${OBJDIR}/${BUILD_LIB}/cc.via
    CPP_COMPLETE = @${OBJDIR}/${BUILD_LIB}/cpp.via
    PCH_COMPLETE = @${OBJDIR}/${BUILD_LIB}/pch.via
else
    CC_COMPLETE  = ${CC_COMPLETE_TMP}
    CPP_COMPLETE = ${CPP_COMPLETE_TMP}
    PCH_COMPLETE = ${PCH_COMPLETE_TMP}
endif # VIAFILE


# ======================================================================== #
# command lines
# ======================================================================== #
ASM_CMDLINE = # we're not using an assembler on win32
ifeq '$(ERRORLOG)' 'YES'
    CMDLINE_ERROR_POSTPROC=|| ( $(CAT) ${ERRDIR}/${BUILD_LIB}/$(basename ${@F}).${ERRFILEEXT} && exit 3)
endif 

ASM_CMDLINE = # we're not using an assembler on win32
CC_CMDLINE  = $(strip ${CC}  ${CC_COMPLETE}  ${CC_CPP_OPTIONS_CMD} ) $(CMDLINE_ERROR_POSTPROC)
CPP_CMDLINE = $(strip ${CPP} ${CPP_COMPLETE} ${CC_CPP_OPTIONS_CMD} ) $(CMDLINE_ERROR_POSTPROC)
PCH_CMDLINE = $(strip ${CPP} ${PCH_COMPLETE} ${CC_CPP_OPTIONS_CMD} ) $(CMDLINE_ERROR_POSTPROC)



# no specific THUMB-stuff!
THUMBCC_CMDLINE  = ${CC_CMDLINE}
THUMBCPP_CMDLINE = ${CPP_CMDLINE}


# ------------------------------------------------------------------------ #
# Howto make dependencies per file
# ------------------------------------------------------------------------ #
# jwo: dep/file deactivated as we build dep-file on a per-lib base
ifeq '0' '1'
CC_MAKEDEP_CMDLINE       = ${MKDEP} \
                               $(addprefix /I ,$(subst /,\,${${BUILD_LIB}_INC})) \
                               /T "" \
                               /X \
                               /o $(subst /,\,${DEPDIR}/${BUILD_LIB}/${BUILD_LIB}.${DEPFILEEXT}) \
                               $(subst /,\,$^)
THUMBCC_MAKEDEP_CMDLINE  = ${CC_MAKEDEP_CMDLINE}
CPP_MAKEDEP_CMDLINE      = ${CC_MAKEDEP_CMDLINE}
THUMBCPP_MAKEDEP_CMDLINE = ${CC_MAKEDEP_CMDLINE}
endif

# ------------------------------------------------------------------------ #
# How to run the SDL code generation
# ------------------------------------------------------------------------ #
runsdlcmd:
	$(SDL_MAKE_CMD)


# ------------------------------------------------------------------------ #
# Target rule for 'all'
# ------------------------------------------------------------------------ #
ifeq '${SDLCODEGEN}' 'YES'
  all: runsdlcmd runsdlscr config createdirs ${MAKEDIR}/${PROJECTNAME}.${OUTPUTFILEEXT}
else # SDLCODEGEN
  ifeq '${SDLSCR}' 'YES'
    all: runsdlscr config createdirs ${MAKEDIR}/${PROJECTNAME}.${OUTPUTFILEEXT}
  else # SDLSCR
    all: config createdirs ${MAKEDIR}/${PROJECTNAME}.${OUTPUTFILEEXT}
  endif # SDL source code reduction
endif # SDLCODEGEN


# ------------------------------------------------------------------------ #
# creating the .lib
# ------------------------------------------------------------------------ #
L_OPTIONS = /nologo
LINKER_CMDLINE=${AR}
FILTEROUTFILE = $(notdir $(LIB_DEPFILE)) # jwo probably using $^ instead of ^F would be smarter
ifeq '${VIAFILE}' 'YES'
    LINKER_CMDLINE += @${OBJDIR}/${BUILD_LIB}/lib.via
    VIA_LIB_COMPLETE = \
               ${L_OPTIONS} \
               /MACHINE:IX86 \
               /out:${LIBDIR}/${BUILD_LIB}.${LIBFILEEXT} \
               $(addprefix ${OBJDIR}/${BUILD_LIB}/,$(filter-out ${FILTEROUTFILE},$(^F))) \
               ${OBJSTOLINK}
else
    LINKER_CMDLINE += \
               ${L_OPTIONS} \
               /MACHINE:IX86 \
               /out:${LIBDIR}/${BUILD_LIB}.${LIBFILEEXT} \
               $(addprefix ${OBJDIR}/${BUILD_LIB}/,$(filter-out ${FILTEROUTFILE},$(^F))) \
               ${OBJSTOLINK}
endif


# ------------------------------------------------------------------------ #
# Linker
# ------------------------------------------------------------------------ #
L_FLAGS   = /subsystem:console
L_FLAGS  += /machine:I386
L_FLAGS  += /pdbtype:sept
L_FLAGS  += /verbose:lib
L_FLAGS  += /nodefaultlib:libc.lib
L_FLAGS  += /nodefaultlib:libcd.lib
L_FLAGS  += /nodefaultlib:libcmt.lib
L_FLAGS  += /nodefaultlib:libcmtd.lib

L_STANDARDLIBS  = # init
ifeq '$(DEBUGINFO)' 'YES'
   L_STANDARDLIBS += libcmtd.lib
else
   L_STANDARDLIBS += libcmt.lib
endif
L_STANDARDLIBS += kernel32.lib
L_STANDARDLIBS += user32.lib
L_STANDARDLIBS += ws2_32.lib
L_STANDARDLIBS += netapi32.lib
L_STANDARDLIBS += comctl32.lib
L_STANDARDLIBS += gdi32.lib
L_STANDARDLIBS += comdlg32.lib
L_STANDARDLIBS += advapi32.lib
L_STANDARDLIBS += winmm.lib
L_STANDARDLIBS += imagehlp.lib
L_STANDARDLIBS += shell32.lib

# todo: check & fix this, why do apoxi need DEBUG always?
ifeq '$(findstring APOXI,${APPLICATIONS})' 'APOXI'
  L_FLAGS += /DEBUG
else # APOXI
  ifeq '$(DEBUGINFO)' 'YES'
    L_FLAGS += /DEBUG
  else
    ifeq '$(findstring ${BUILD_LIB},${DEBUGLIBS})' '${BUILD_LIB}'
      L_FLAGS += /DEBUG
    endif # DEBUGMODE
  endif # DEBUGMODE
endif # APOXI


# ------------------------------------------------------------------------ #
# Target rule for 'link'ing executable
# ------------------------------------------------------------------------ #
ARC_CMDLINE  = ${LINK} ${L_FLAGS}
ARC_CMDLINE += /out:${MAKEDIR}/${PROJECTNAME}.${OUTPUTFILEEXT}
ifeq '$(DEBUGINFO)' 'YES'
  ARC_CMDLINE += /pdb:${MAKEDIR}/${PROJECTNAME}.pdb
endif
ARC_CMDLINE += /libpath:${LIBDIR}
ARC_CMDLINE += /libpath:${GLOBALPATH}/stack-interface/sdl/msvc50
ARC_CMDLINE += ${L_STANDARDLIBS}
ARC_CMDLINE += ${LIBSTOBUILD} ${LIBSTOLINK}

link: ${MAKEDIR}/sys_version.c
	$(ECHO) Creating executable $(MAKEDIR)/$(PROJECTNAME).${OUTPUTFILEEXT} ...
	${ARC_CMDLINE}
ifneq '${CMDPEREXE}' ''
	${CMDPEREXE}
endif # CMDPEREXE


# ------------------------------------------------------------------------ #
# Rule to build the executable
# ------------------------------------------------------------------------ #
${MAKEDIR}/${PROJECTNAME}.${OUTPUTFILEEXT} : ${LIBSTOBUILD}
	$(MAKE) link



# ------------------------------------------------------------------------
# create a dependency file per lib
# msvc doesn't provide dep-generation so mkdep.exe (comneon-made, not to be
# mixed up with gnu's mkdep) is used
# there is one dependency file per library <lib>.dep
# ------------------------------------------------------------------------
#
ifneq '$(DEPENDENCIES)' 'NO'
  LIB_DEPFILE=${DEPDIR}/${BUILD_LIB}/${BUILD_LIB}.$(DEPFILEEXT)
endif

# adapt pathes to cygwin
ifeq '${BUILDPCOS}' 'WIN32'
PATH_DELIM=\\
else
PATH_DELIM=/
endif

# adapt path of executable
MKDEP := $(subst \,${PATH_DELIM},${MKDEP})

# this is tricky, but mkdep expects INCLUDE_DEP to contain a ";" separated list of directories
# add a ":" before and after each token, then we replace ": :" with ";" and remove single ":" (start & end)
NULL:=
SPACE:= $(NULL) # this is a space
# we don't modify INCLUDE as this is used by compilers; muc uses "include" (lowercase)
export INCLUDE_DEP=$(strip $(INCLUDE))$(strip $(include))
INCLUDE_DEP +=$(strip $(subst :,,$(subst : :,;,$(addprefix :,$(addsuffix :,${${BUILD_LIB}_INC})))))
INCLUDE_DEP:=$(subst ;$(SPACE),;,$(INCLUDE_DEP))

${DEPDIR}/${BUILD_LIB}/${BUILD_LIB}.$(DEPFILEEXT) : \
                                        ${${BUILD_LIB}_THUMB_FILES} \
                                        ${${BUILD_LIB}_FILES}
	-@$(ECHO) --- generating dependency file $@ ---
    # this command get's too long most of the time so we create a viafile anyway
	$(shell echo $(wordlist 1,1,$($^)) > ${DEPDIR}/${BUILD_LIB}/${BUILD_LIB}.via )
	$(foreach str, $^, $(shell echo ${str} >> ${DEPDIR}/${BUILD_LIB}/${BUILD_LIB}.via) )
	${MKDEP}  \
                               /T "$(OBJ_DIR)" \
                               /X \
                               /E INCLUDE_DEP \
                               /o $(subst /,${PATH_DELIM},${DEPDIR}/${BUILD_LIB}/${BUILD_LIB}.${DEPFILEEXT}) \
                               @$(subst /,${PATH_DELIM},${DEPDIR}/${BUILD_LIB}/${BUILD_LIB}.via)
# /T <dir> obj file directory <dir>
# /X enable unix style ("/") support
# /o write output to file <file>
# /v verbose output
# /S<c> file separator (\ by default)
# /i<c> inc path seperator (; by default)
# /x o generate dependencies with .o files (.obj is default)
#                               $(addprefix /I ,$(subst /,\,${${BUILD_LIB}_INC}))

