# /*****************************************************************************
#* Ȩ (C)2015, ͨѶɷ޹˾
#* 
#* ļ:     mdl_rules.mk
#* ļʶ:     mdl_rules.mk
#* ժҪ:     ģļ
#* ʹ÷:     include mdl_rules.mk
#* 
#* ޸        汾      ޸ı        ޸          ޸
#* -----------------------------------------------------------------------------
#* 2015/05/20      V1.0                              
#* 
# ******************************************************************************/

#===============================================================================
# ļϹ
#===============================================================================
_ALL_OBJECTS = $(addprefix $(_MDL_OBJ_PATH)/, \
               $(subst .c,.o, $(notdir $(_C_SOURCE))))

_ALL_OBJECTS += $(addprefix $(_MDL_OBJ_PATH)/, \
	       $(subst .cpp,.o, $(notdir $(_CPP_SOURCE))))

_ALL_OBJECTS += $(addprefix $(_MDL_OBJ_PATH)/, \
               $(subst .s,.o, $(notdir $(_s_SOURCE))))

_ALL_OBJECTS += $(addprefix $(_MDL_OBJ_PATH)/, \
               $(subst .S,.o, $(notdir $(_S_SOURCE))))

ifeq ($(USE_ENABLE_LTO),yes)
ifneq ($(DISABLE_LTO_ONCE),yes)
	CCFLAGS +=  -flto -fno-toplevel-reorder -fno-fat-lto-objects 
endif
endif

#===============================================================================
# ļɹ
#===============================================================================
$(_MDL_OBJ_PATH)/%.o:$(_MDL_SRC_PATH)/%.cpp
	@$(ECHO) Compile $< 
	@-$(MKDIR) $(_MDL_OBJ_PATH)
	$(VERB)$(CXX) $(CXXFLAGS) $(CPU_PUB_DEFINE) $(DEFINE) $(STDINCLUDE) $(INCLUDE) -c $< -o $@
	@$(ECHO) Done!

$(_MDL_OBJ_PATH)/%.o:$(_MDL_SRC_PATH)/%.c
	@$(ECHO) Compile $< 
	@-$(MKDIR) $(_MDL_OBJ_PATH)
ifeq ($(CONFIG_MIN_8M_VERSION), y)
	$(VERB)$(CC) $(CCFLAGS) $(CPU_PUB_DEFINE) $(DEFINE) -Wno-builtin-macro-redefined -U __FILE__ -D '__FILE__=""'  $(STDINCLUDE) $(INCLUDE) -c $< -o $@
else
	$(VERB)$(CC) $(CCFLAGS) $(CPU_PUB_DEFINE) $(DEFINE) -Wno-builtin-macro-redefined -U __FILE__ -D '__FILE__="$(shell basename $<)"'  $(STDINCLUDE) $(INCLUDE) -c $< -o $@
endif
	@$(ECHO) Done!

$(_MDL_OBJ_PATH)/%.o:$(_MDL_SRC_PATH)/%.S
	@$(ECHO) Compile $< 
	@-$(MKDIR) $(_MDL_OBJ_PATH)
	@$(CC) $(CCFLAGS) $(ASFLAGS) $(CPU_PUB_DEFINE) $(DEFINE) -o $@ $(INCLUDE) $<
	@$(ECHO) Done!
	
$(_MDL_OBJ_PATH)/%.o:$(_MDL_SRC_PATH)/%.s
	@$(ECHO) Compile $< 
	@-$(MKDIR) $(_MDL_OBJ_PATH)
	@$(ASM) $(ASFLAGS)  -o $@ $(INCLUDE) $<
	@$(ECHO) Done!

#===============================================================================
#
#===============================================================================
_ALL_LINT =

ifeq ($(LINTCHK), yes)
_ALL_LINT = $(addprefix $(_MDL_OBJ_PATH)/lnt/, \
            $(subst .c,.lnt, $(notdir $(_C_SOURCE))))
               		
$(_MDL_OBJ_PATH)/lnt/%.lnt:$(_MDL_SRC_PATH)/%.c
	@$(ECHO) Lint $< 
	@-$(MKDIR) $(_MDL_OBJ_PATH)/lnt
	@$(PCLINT) -u -b +fdi $(INCLUDE) $(STDINCLUDE) $(CPU_PUB_DEFINE) $(DEFINE) $(LINTOPTION) $<>>$(OBJ_PATH)/$(PRJ_NAME).lnt
	@$(ECHO) Done!
endif

#===============================================================================
#ģ
#===============================================================================
default: mdl
clean:   mdlclean

mdl:$(_ALL_OBJECTS) $(_ALL_LINT)
	@$(ECHO) Compile module $(_MDL_NAME) done!
	@$(ECHO) ""

mdlclean:
	@-$(RM) $(_MDL_OBJ_PATH)/lnt/*
	@-$(RMDIR) $(_MDL_OBJ_PATH)/lnt
	@-$(RM) $(_MDL_OBJ_PATH)/*
	@-$(RM) $(OBJ_PATH)/$(PRJ_NAME).lnt
	@-$(RMDIR) $(_MDL_OBJ_PATH)
	@$(ECHO) "--- clean obj file $(_MDL_OBJ_PATH)/* done."
	@$(ECHO) ""
