#include	"wsIntrn.h"
#include "../interface5.0/zte_web_interface.h"
//#include "../interface5.0/zte_rest_comm_interface.h"



static websUrlHandlerType	*websUrlHandler;			
static int					websUrlHandlerMax;			
static int					urlHandlerOpenCount = 0;	

static int 		websUrlHandlerSort(const void *p1, const void *p2);
static char_t	*websCondenseMultipleChars(char_t *strToCondense, char_t cCondense);

static int 		websPublishHandler(webs_t wp, char_t *urlPrefix, char_t *webDir, 
				int sid, char_t *url, char_t *path, char_t *query);


				
static int websUrlHandlerSort(const void *p1, const void *p2)
{
	websUrlHandlerType	*s1, *s2;
	int 				rc;

	a_assert(p1);
	a_assert(p2);

	s1 = (websUrlHandlerType*) p1;
	s2 = (websUrlHandlerType*) p2;

	if ((s1->flags & WEBS_HANDLER_FIRST) || (s2->flags & WEBS_HANDLER_LAST)) {
		return -1;
	}

	if ((s2->flags & WEBS_HANDLER_FIRST) || (s1->flags & WEBS_HANDLER_LAST)) {
		return 1;
	}

	if ((rc = gstrcmp(s1->urlPrefix, s2->urlPrefix)) == 0) {
		if (s1->len < s2->len) {
			return 1;
		} else if (s1->len > s2->len) {
			return -1;
		}
	}
	return -rc; 
}

int websUrlHandlerOpen()
{
	if (++urlHandlerOpenCount == 1) {
#ifdef WEB_ASP	
		websAspOpen();
#endif
		websUrlHandler = NULL;
		websUrlHandlerMax = 0;
	}
	return 0;
}

int websUrlHandlerDefine(char_t *urlPrefix, char_t *webDir, int arg,
		int (*handler)(webs_t wp, char_t *urlPrefix, char_t *webdir, int arg, 
		char_t *url, char_t *path, char_t *query), int flags)
{
	websUrlHandlerType	*sp;
	int					len;

	a_assert(urlPrefix);
	a_assert(handler);

	len = (websUrlHandlerMax + 1) * sizeof(websUrlHandlerType);
	if ((websUrlHandler = brealloc(B_L, websUrlHandler, len)) == NULL) {
		return -1;
	}
	sp = &websUrlHandler[websUrlHandlerMax++];
	memset(sp, 0, sizeof(websUrlHandlerType));

	sp->urlPrefix = bstrdup(B_L, urlPrefix);
	if(sp->urlPrefix)
	sp->len = gstrlen(sp->urlPrefix);
	if (webDir) {
		sp->webDir = bstrdup(B_L, webDir);
	} else {
		sp->webDir = bstrdup(B_L, T(""));
	}
	sp->handler = handler;
	sp->arg = arg;
	sp->flags = flags;

	qsort(websUrlHandler, websUrlHandlerMax, sizeof(websUrlHandlerType), 
		websUrlHandlerSort);
	return 0;
}

void websUrlHandlerClose()
{
	websUrlHandlerType *sp;

	if (--urlHandlerOpenCount <= 0) {
#ifdef WEB_ASP	
		websAspClose();
#endif
		for (sp = websUrlHandler; sp < &websUrlHandler[websUrlHandlerMax];
			sp++) {
			bfree(B_L, sp->urlPrefix);
			if (sp->webDir) {
				bfree(B_L, sp->webDir);
			}
		}
		bfree(B_L, websUrlHandler);
		websUrlHandlerMax = 0;
	}
}

int websPublish(char_t *urlPrefix, char_t *path)
{
	return websUrlHandlerDefine(urlPrefix, path, 0, websPublishHandler, 0);
}


int websUrlHandlerDelete(int (*handler)(webs_t wp, char_t *urlPrefix, 
	char_t *webDir, int arg, char_t *url, char_t *path, char_t *query))
{
	websUrlHandlerType	*sp;
	int					index;

	for (index = 0; index < websUrlHandlerMax; index++) {
		sp = &websUrlHandler[index];
		if (sp->handler == handler) {
			sp->handler = NULL;
			return 0;
		}
	}
	return -1;
}

char_t *websGetPublishDir(char_t *path, char_t **urlPrefix)
{
	websUrlHandlerType	*sp;
	int					index;

	for (index = 0; index < websUrlHandlerMax; index++) {
		sp = &websUrlHandler[index];
		if (sp->urlPrefix[0] == '\0') {
			continue;
		}
		if (sp->handler && gstrncmp(sp->urlPrefix, path, sp->len) == 0) {
			if (urlPrefix) {
				*urlPrefix = sp->urlPrefix;
			}
			return sp->webDir;
		}
	}
	return NULL;
}


static int websPublishHandler(webs_t wp, char_t *urlPrefix, char_t *webDir, 
	int sid, char_t *url, char_t *path, char_t *query)
{
	int		len;

	a_assert(websValid(wp));
	a_assert(path);

	len = gstrlen(urlPrefix) + 1;
	websSetRequestPath(wp, webDir, &path[len]);
	return 0;
}

#ifdef OBSOLETE_CODE
static int websTidyUrl(webs_t wp)
{
	char_t	*parts[64]; 				
	char_t	*token, *url, *tidyurl;
	int 	i, len, npart;

	a_assert(websValid(wp));


	url = bstrdup(B_L, wp->url);
	websDecodeUrl(url, url, gstrlen(url));

	len = npart = 0;
	parts[0] = NULL;
	token = gstrtok(url, T("/"));

	while (token != NULL) {
		if (gstrcmp(token, T("..")) == 0) {
			if (npart > 0) {
				npart--;
			}

		} else if (gstrcmp(token, T(".")) != 0) {
			parts[npart] = token;
			len += gstrlen(token) + 1;
			npart++;
		}
		token = gstrtok(NULL, T("/"));
	}

	if (npart || (gstrcmp(url, T("/")) == 0) || (url[0] == '\0')) {
		tidyurl = balloc(B_L, (len + 2) * sizeof(char_t));
		*tidyurl = '\0';

		for (i = 0; i < npart; i++) {
			gstrcat(tidyurl, T("/"));
			gstrcat(tidyurl, parts[i]);
		}

		bfree(B_L, url);

		bfree(B_L, wp->url);
		wp->url = tidyurl;
		return 0;
	} else {
		bfree(B_L, url);
		return -1;
	}
}
#endif

int websUrlHandlerRequest(webs_t wp)
{
    websUrlHandlerType	*sp;
    int i, first;
    int m=0;
    int n=0;
    int m_count=0;
    int n_count=0;
    
    char  zte_user_login_flag[10] = {0};
    char  zte_web_global_flag[10] = {0};  // 1 means needn't LOGIN, 0 means need LOGIN
    char_t *ip_address = NULL; 
    char  dataCard[32] = {0};
    char  userIpaddr[40] = {0};
    a_assert(websValid(wp));
	if(websValid(wp)== 0){
		softap_assert("websUrlHandlerRequest 1");
	}
    
    socketDeleteHandler(wp->sid);
    wp->state = WEBS_PROCESSING;
    websStats.handlerHits++;
    
    websSetRequestPath(wp, websGetDefaultDir(), NULL);
    
    
    ip_address = websGetRequestIpaddr(wp);
#if 0 // kw 3	
    if (NULL == ip_address)
    {
        slog(MISC_PRINT,SLOG_ERR,"ip_address is null.");
        websDone(wp, 200);
        return 0;
    }
#endif
	
    sc_cfg_get(NV_DATA_CARD,dataCard,sizeof(dataCard));
    sc_cfg_get(NV_USER_IP_ADDR,userIpaddr,sizeof(userIpaddr));
    if (0 == strcmp(dataCard,"1"))
    {
        strcpy(zte_user_login_flag,"ok");
    }
    else if(0 == strcmp(userIpaddr,ip_address))
    {
        sc_cfg_get("loginfo",zte_user_login_flag,sizeof(zte_user_login_flag));
    }
    else
    {
        strcpy(zte_user_login_flag,""); 
    }
    if(strstr(wp->url, "messages"))
    {
        if(strcmp("ok", zte_user_login_flag) != 0) 
        {
            slog(MISC_PRINT,SLOG_DEBUG,"websUrlHandlerRequest -> GET is not allowed: %s", wp->url);
            
            //zte_webs_feedback_top(wp, zte_web_get_login_page(wp)); /*Ӧն*/
            //websDone(wp, 200);
			websRedirect(wp, zte_web_get_login_page(wp));
            return 0;
        }
        //   allow pass        
    }
    
    if (strstr(wp->url, "default_parameter") ||strstr(wp->url, "version_parameter") ||strstr(wp->url, "custom_parameter") ||strstr(wp->url, "zteconfig/config"))
    {
        slog(MISC_PRINT,SLOG_DEBUG,"websUrlHandlerRequest -> GET is not allowed: %s", wp->url);
        websError(wp, 404, T("Bad state"));
        return 0;
    }
    
    //zte_nv_read("loginfo", zte_user_login_flag, sizeof(zte_user_login_flag));
    
    if (strcmp("ok", zte_user_login_flag) != 0)   // not login
    {
        //   allow pass 
        
    }
    
#ifdef FEATURE_ZTE_WEB_TCARD
    //added by guo shoupeng 10124224 for http share 20111001 start
    zte_httpShare_urlHandler(wp,wp->url);
    //added by guo shoupeng 10124224 for http share 20111001 start
#endif //def FEATURE_ZTE_WEB_TCARD
    
    /*
    *	Eliminate security hole
    */
    websCondenseMultipleChars(wp->path, '/');
    websCondenseMultipleChars(wp->url, '/');
    
    first = 1;
    for (i = 0; i < websUrlHandlerMax; i++) 
    {
        sp = &websUrlHandler[i];
        if (sp->handler && gstrncmp(sp->urlPrefix, wp->path, sp->len) == 0) 
        {
            if (first) 
            {
                websSetEnv(wp);
                first = 0;
            }
			
			if(websValid(wp)== 0){
				softap_assert("websUrlHandlerRequest 2");
			}

            if ((*sp->handler)(wp, sp->urlPrefix, sp->webDir, sp->arg, 
                               wp->url, wp->path, wp->query)) 
            {
                return 1;
            }
            if (!websValid(wp)) 
            {
                trace(0, T("webs: handler %s called websDone, but didn't return 1\n"), sp->urlPrefix);
                return 1;
            }
        }
    }

    if (i >= websUrlHandlerMax) 
    {
        websError(wp, 200, T("No handler for this URL"));
    }
    return 0;
}

static char_t *websCondenseMultipleChars(char_t *strToCondense, char_t cCondense)
{
	if (strToCondense != NULL) {
		char_t *pStr, *pScan;

		pStr = pScan = strToCondense;

		while (*pScan && *pStr) {

			while ((*pScan == cCondense) && (*(pScan + 1) == cCondense)) {
				pScan++;
			}

			if (pStr != pScan) {
				*pStr = *pScan;
			}
			
			pScan++;
			pStr++;
		}

		if (pStr != pScan) {
			*pStr = 0;
		}
	}

	return strToCondense;
}

