/**
 * 
 * @file      cp_log.c
 * @brief     
 *            This file is part of ZCAT.
 *            zcatӦòlog_agentcplog豸
 *            
 * @details   
 * @author    Tools Team.
 * @email     
 * @copyright Copyright (C) 2013 Sanechips Technology Co., Ltd.
 * @warning   
 * @date      2019/02/02
 * @version   1.2
 * @pre       
 * @post      
 *            
 * @par       
 * Change History :
 * ---------------------------------------------------------------------------
 * date        version  author         description
 * ---------------------------------------------------------------------------
 * 2017/07/17  1.0      hou.bing       Create file
 * 2019/01/24  1.1      jiang.fenglin  1.usblogд
 *                                     2.߳
 * 2019/02/02  1.2      jiang.fenglin  ޸עͷʽΪdoxygen
 * ---------------------------------------------------------------------------
 * 
 * 
 */

#include <string.h>
#include <time.h>
#include <pthread.h>
#include <sys/prctl.h>
#include "log_agent.h"

#define MAX_PACKET_LEN       (0x10000)
#define MAX_CP_PACKET_LEN    (MAX_PACKET_LEN * 2)

const char* cplog_dev = "/dev/cplog";     // 豸·
static unsigned char g_cp_read_buffer[MAX_CP_PACKET_LEN] = {0}; // ݻ
pthread_t read_cplog_thread = 0;
int cplog_fd = -1;

extern void send_log_out(unsigned char* buf, int len);

/**
 * @brief ȡcplog̺߳\n
 *        cplog豸еlogݣתȥ.
 * @param[in] args ̺߳
 * @return void
 * @note
 * @see 
 */
void *read_cplog(void* args)
{
    const struct timespec notimer_interval = {0, 20000000};//20ms
    int read_Len = -1;
    int nosleep_ret = -1;

    prctl(PR_SET_NAME, "read_cplog");
    
    while(1)
    {   
        read_Len = read(cplog_fd, g_cp_read_buffer, MAX_CP_PACKET_LEN);
        
        if(read_Len > 0)
        {           
            //printf("zcat: read_cplog read_Len %d\n", read_Len);
            send_log_out(g_cp_read_buffer, read_Len);   
            memset(g_cp_read_buffer, 0, MAX_CP_PACKET_LEN);
        }
        else if(read_Len == 0)
        {
            nosleep_ret = nanosleep(&notimer_interval, NULL);
            if(nosleep_ret < 0)
            {
                sleep(1);
            }
        }
        else
        {
            sleep(1);
        }
        
    }
}

