/**
 * 
 * @file      log_agent_main.c
 * @brief     
 *            This file is part of ZCAT.
 *            log_agentļNVݲͬģʽ
 *            NV:
 *            zcat_mode
 *                APUSB - Ӧòusbڴlog
 *                APTF  - Ӧò洢logTF
 *                APNET - Ӧòsocketlog
 *                APFS  - Ӧò洢logļϵͳ/var/zcatĿ¼
 *                CPUSB - ں˲usbڴlog
 *                CPTF  - ں˲洢logTF
 *                CPNET - ں˲socketlog
 *                CPFS  - ں˲洢logļϵͳ/var/zcatĿ¼
 *            zcat_usblog
 *                ָlogtty·: ttyGS2
 *            
 * @details   
 * @author    Tools Team.
 * @email     
 * @copyright Copyright (C) 2013 Sanechips Technology Co., Ltd.
 * @warning   
 * @date      2019/02/22
 * @version   1.6
 * @pre       
 * @post      
 *            
 * @par       
 * Change History :
 * ---------------------------------------------------------------------------
 * date        version  author         description
 * ---------------------------------------------------------------------------
 * 2017/07/17  1.0      hou.bing       Create file
 * 2019/01/24  1.1      jiang.fenglin  1.usblogд
 *                                     2.߳
 * 2019/01/25  1.2      jiang.fenglin  APUSBģʽtty·ù
 * 2019/02/02  1.3      jiang.fenglin  ޸עͷʽΪdoxygen,淶
 * 2019/02/02  1.4      jiang.fenglin  empty log_agent_usb.c
 * 2019/02/22  1.5      jiang.fenglin  ̬LOG˿,log˿ڶֻ̬usbΪģʽģʽֲ
 * 2019/03/04  1.6      jiang.fenglin  뾯
 * 2019/07/08  1.7      jiang.fenglin  APFS/CPFSģʽ
 * ---------------------------------------------------------------------------
 * 
 * 
 */

#include <stdarg.h>
#include <string.h>
#include <pthread.h>
#include <sys/msg.h>
#include <sys/ioctl.h>
#include "log_agent.h"
#include "cfg_api.h"

E_ZCAT_MODE g_log_dir = ZCAT_MODE_CP_USB;
E_ZCAT_STATE g_log_state = ZCAT_STATE_INIT;

extern pthread_t read_kernellog_thread;
extern pthread_t read_applog_thread;
extern pthread_t read_cplog_thread;
extern pthread_t read_usb_thread;
extern pthread_t monitor_hotplug_thread;
extern pthread_t read_wifi_thread;
extern pthread_t rule_heartbeat_thread;

extern const char* cplog_dev;
extern const char* applog_dev;
extern const char* kernellog_dev;

extern int cplog_fd;
extern int applog_fd;
extern int kernellog_fd;

extern int init_log_agent_tools();
extern int init_usblog_mode();
extern int init_sdcard_mode();
extern int init_net_mode();

extern void *read_applog(void* args);
extern void *read_kernellog(void* args);
extern void *read_cplog(void* args);
extern int  log_argv_proc(int argc, char *argv[]);

extern char g_zcat_usblog[8]; // 洢usblogtty豸

/**
 * @brief zcat modeʼlogģʽ
 * @param[in] void
 * @return 1 on success, errno otherwise
 * @note
 * @see 
 */
int init_log_type(int argc, char *argv[])
{
    char zcat_mode[16] = { 0 };

    // 1.ȡnvֵ
    sc_cfg_get("zcat_mode", zcat_mode, sizeof(zcat_mode) - 1);
    if (strcmp(zcat_mode, "APTF") == 0)
    {
        g_log_dir = ZCAT_MODE_AP_TF;
    }
    else if (strcmp(zcat_mode, "CPTF") == 0)
    {
        g_log_dir = ZCAT_MODE_CP_TF;
    }
    else if (strcmp(zcat_mode, "APFS") == 0)
    {
        if (log_argv_proc(argc, argv) < 0)
            return -1;

        g_log_dir = ZCAT_MODE_AP_FS;
    }
    else if (strcmp(zcat_mode, "CPFS") == 0)
    {
        g_log_dir = ZCAT_MODE_CP_FS;
    }
    else if (strcmp(zcat_mode, "APNET") == 0)
    {
        g_log_dir = ZCAT_MODE_AP_NET;
    }
    else if (strcmp(zcat_mode, "CPNET") == 0)
    {
        g_log_dir = ZCAT_MODE_CP_NET;
    }
    else if (strcmp(zcat_mode, "APUSB") == 0)
    {
        g_log_dir = ZCAT_MODE_AP_USB;
    }    
#ifdef USE_CAP_SUPPORT
    else if (strcmp(zcat_mode, "CAPFS") == 0)
    {
        g_log_dir = ZCAT_MODE_CAP_FS;
    }
#endif
    else
    {
        g_log_dir = ZCAT_MODE_CP_USB;
    }
    return 0;
}

/**
 * @brief cplogʱĳʼ
 * @param[in] void
 * @return 1 on success, errno otherwise
 * @note
 * @see 
 */
int init_cp_mode()
{
    return 1;
}

/**
 * @brief cap洢logʱĳʼ
 * @param[in] void
 * @return 1 on success, errno otherwise
 * @note
 * @see 
 */
#ifdef USE_CAP_SUPPORT
int init_cap_mode(void)
{
    if(ioctl(cplog_fd, ZCAT_IPC_ALLOC_CAP_SMLOGBUF, g_log_dir)!= 0)
    {
        printf("[zcat]ioctl:ZCAT_IPC_SET_PERIPHERAL_MODE fail!\n");
        return -1;
    }
    return 0;
}
#endif

/** 
 * @brief zte_log_agentںNVݲͬģʽ
 *
 * @return ˵
 *        -<em>-1</em> fail
 *        -<em>0</em> succeed
 */
int main(int argc, char *argv[])
{
    char zcat_usblog[8] = { 0 };
    int ret = 0;

    /* 1.ȡnvֵ*/
    ret = init_log_type(argc, argv);

    if (ret < 0)
        return -1;

    printf("[zcat] zcat_mode = 0x%x\n", g_log_dir);

    if (ZCAT_MODE_AP_USB == g_log_dir || ZCAT_MODE_CP_USB == g_log_dir)
    {
        sc_cfg_get("zcat_usblog", zcat_usblog, sizeof(zcat_usblog) - 1);
        if (strlen(zcat_usblog) > 3)
        {
            memcpy(g_zcat_usblog, zcat_usblog, sizeof(zcat_usblog));
        }
        printf("[zcat] zcat_usblog = %s\n", g_zcat_usblog);
    }

    // 2.ʼȫֱ
    init_log_agent_tools();
    
    // 3.ģʽlogԴ豸Ĺ߳
    //   V3EҪȡapplogkernellog豸
    cplog_fd = open(cplog_dev, O_RDWR);
    if (cplog_fd < 0) {
        goto __exit;
    }
   
    if((g_log_dir == ZCAT_MODE_AP_USB) || (g_log_dir == ZCAT_MODE_AP_TF)
        || (g_log_dir == ZCAT_MODE_AP_NET) || (g_log_dir == ZCAT_MODE_AP_FS))
    {
        // 3.1 Դ豸
        #if 0
        applog_fd = open(applog_dev, O_RDWR);
        if (applog_fd < 0) {
            goto __exit;
        }
        kernellog_fd = open(kernellog_dev, O_RDWR);
        if (kernellog_fd < 0) {
            goto __exit;
        }
        #endif

        // 3.2 Դ豸Ķд߳
        #if 0
        ret = pthread_create(&read_applog_thread, NULL, read_applog, NULL);
        if(ret != 0 ) {
            goto __exit;
        }
        ret = pthread_create(&read_kernellog_thread, NULL, read_kernellog, NULL);
        if(ret != 0) {
            goto __exit;
        }
        #endif
        ret = pthread_create(&read_cplog_thread, NULL, read_cplog, NULL);
        if(ret != 0) {
            goto __exit;
        }
    }

    printf("[zcat] init logdev success.\n");

    // 4.ʼ
    switch(g_log_dir)
    {
        case ZCAT_MODE_AP_USB:
        {
            if(init_usblog_mode() < 0) {
                goto __exit;
            }
            break;
        }
        case ZCAT_MODE_AP_TF:
        case ZCAT_MODE_AP_FS:
        {
            init_sdcard_mode();
            break;
        }
        case ZCAT_MODE_AP_NET:
        {
            if(init_net_mode() < 0) {
                goto __exit;
            }
            break;
        }
        case ZCAT_MODE_CP_USB:
        case ZCAT_MODE_CP_TF:
        case ZCAT_MODE_CP_NET:
        case ZCAT_MODE_CP_FS:
        {
            init_cp_mode();
            break;
        }
#ifdef USE_CAP_SUPPORT
        case ZCAT_MODE_CAP_FS:
        {
            init_cap_mode();
            break;
        }
#endif
        default: {
            goto __exit;
        }
    }

    g_log_state = ZCAT_STATE_RUNNING;

    // 5.ʼɣcpͬ
    printf("[zcat] init peripheral success.\n");
    
    if(ioctl(cplog_fd, ZCAT_IPC_SET_PERIPHERAL_MODE, g_log_dir)!= 0)
    {
        printf("[zcat]ioctl:ZCAT_IPC_SET_PERIPHERAL_MODE fail!\n");
    }
    if(ioctl(cplog_fd, ZCAT_IPC_SET_TTY, g_zcat_usblog)!= 0)
    {
        printf("[zcat]ioctl:ZCAT_IPC_SET_TTY fail!\n");
    }
    if(ioctl(cplog_fd, ZCAT_IPC_SYN, 0)!=0)
    {
        printf("[zcat]ioctl:ZCAT_IPC_SYN fail!\n");
    }

    while(1)
    {
        ret = ioctl(cplog_fd, ZCAT_IPC_ACK, 0);
        if(ret == 0)
        {
            ioctl(cplog_fd, ZCAT_IPC_ESTABLISHED, 0);
            break;
        }
        sleep(1);
    }

__exit:
    // 6. ˳
    if(read_kernellog_thread > 0) pthread_join(read_kernellog_thread, NULL);
    if(read_applog_thread > 0) pthread_join(read_applog_thread, NULL);
    if(read_cplog_thread > 0) pthread_join(read_cplog_thread, NULL);
    if(monitor_hotplug_thread > 0) pthread_join(monitor_hotplug_thread, NULL);
    if(read_usb_thread > 0) pthread_join(read_usb_thread, NULL);
    if(read_wifi_thread > 0) pthread_join(read_wifi_thread, NULL);
    if(rule_heartbeat_thread > 0) pthread_join(rule_heartbeat_thread, NULL);
    
    if(applog_fd >= 0) close(applog_fd);
    if(kernellog_fd >= 0) close(kernellog_fd);
    if(cplog_fd >= 0) close(cplog_fd);
    
    printf("[zcat] log_agent exit.\n");

    return 0;
}
