/**
 * 
 * @file      log_agent_network.c
 * @brief     
 *            This file is part of ZCAT.
 *            zcatӦòlog_agentͨsocket
 *            һ߳̽pc෢Ĺ
 *            豸̣߳logͨsocketpc
 *            
 * @details   
 * @author    Tools Team.
 * @email     
 * @copyright Copyright (C) 2013 Sanechips Technology Co., Ltd.
 * @warning   
 * @date      2019/02/02
 * @version   1.2
 * @pre       
 * @post      
 *            
 * @par       
 * Change History :
 * ---------------------------------------------------------------------------
 * date        version  author         description
 * ---------------------------------------------------------------------------
 * 2017/07/17  1.0      hou.bing       Create file
 * 2019/01/24  1.1      jiang.fenglin  1.usblogд
 *                                     2.߳
 * 2019/02/02  1.2      jiang.fenglin  ޸עͷʽΪdoxygen
 * ---------------------------------------------------------------------------
 * 
 * 
 */

#include <signal.h>
#include <pthread.h>
#include <string.h>
#include <sys/prctl.h>
#include "log_agent.h"

static int g_client_sockfd = -1;
pthread_t  read_wifi_thread = 0;

extern unsigned char g_UsbLogBuf[2048 + 1];
extern int send_log_to_cp(unsigned char *buf, int len);
extern int deal_with_encoded_data(unsigned char *buffer, int buf_len);

static void sig_test_func(int sig)
{

}


/**
 * @brief ݸsocketͻ.
 * @param[in] buf ͵ָ
 * @param[in] len ͵ݳ
 * @return ʵʷ͵ݳ
 * @note
 * @see 
 */
int send_message_to_client(unsigned char* buf, int len)
{
    int write_len = 0;
    
    if(buf && len && (g_client_sockfd >= 0))
    {
        write_len = write(g_client_sockfd, buf, len);
        if(write_len != len)
        {
            printf("[zcat] write to client error!\n");
            return write_len;
        }
    }
    return write_len;
}

/**
 * @brief socket server̺߳\n
 *        pcsocket clientĽ룬pc.
 * @param[in] args ̺߳
 * @return void
 * @note
 * @see 
 */
static void* read_wifi(void* args)
{
    int serverfd = -1, clientfd = -1;
    socklen_t cliaddr_len = 0;
    struct sockaddr_in server_addr, client_addr;
    unsigned char *pbuf = g_UsbLogBuf;
    int read_len = 0;
    int opt = 1;

    struct sigaction action;
    action.sa_handler = sig_test_func;
    sigemptyset(&action.sa_mask);
    action.sa_flags = 0;
    sigaction(SIGPIPE, &action, NULL);

    prctl(PR_SET_NAME, "read_wifi");
  
    serverfd = socket(AF_INET, SOCK_STREAM, 0);
    if (serverfd == -1) {
        printf("[zcat] socket create fail!\n");
        goto __exit;
    }
    
    if(setsockopt(serverfd, SOL_SOCKET, SO_REUSEADDR, &opt, sizeof(opt))!= 0)
    {
        printf("[zcat] setsockopt fail!\n");
    }
    bzero(&server_addr, sizeof(server_addr));

    memset(&server_addr, 0, sizeof(server_addr));
    server_addr.sin_family = AF_INET;
    server_addr.sin_port = htons(10005);
    server_addr.sin_addr.s_addr = htonl(INADDR_ANY);
  
    if (bind(serverfd, (struct sockaddr *) &server_addr, sizeof(server_addr)) == -1) {
        printf("[zcat] socket bind fail!\n");
        goto __exit;
    }
  
    if ((listen(serverfd, 20)) == -1) {
        printf("[zcat] socket listen fail!\n");
        goto __exit;
    }
  

    for (;;)
    {
        if(clientfd >= 0)
        {
            close(clientfd);
        }
        
        clientfd = accept(serverfd, (struct sockaddr *) &client_addr, &cliaddr_len);
        printf("[zcat] socket accept %s.\n", inet_ntoa(client_addr.sin_addr));
        g_client_sockfd = clientfd;
        
        while(1)
        {
            read_len = read(g_client_sockfd, pbuf, 2048);
            if(read_len > 0)
            {
                send_log_to_cp(pbuf, read_len);
                deal_with_encoded_data(pbuf, read_len);
            }
            else
            {
                close(g_client_sockfd);
                g_client_sockfd = -1;
                printf("[zcat] socket client closed.\n");
                break;
            }
        }
    }
    
__exit:
    if(serverfd >= 0) close(serverfd);

    return NULL;
}

/**
 * @brief ʼģʽ\n
 *        ȡpcϢ߳.
 * @param[in] void
 * @return 0 on success, errno otherwise
 * @note
 * @see 
 */
int init_net_mode()
{
    int ret = -1;
    
    ret = pthread_create(&read_wifi_thread, NULL, read_wifi, NULL);
    if(ret < 0)
    {
        printf("[zcat] init_network_device error!\n");
        return ret;
    }
    return ret;
}

