/**
 * 
 * @file      log_agent_sdcard.c
 * @brief     
 *            This file is part of ZCAT.
 *            zcatӦòlog_agentͨsd
 *            
 * @details   
 * @author    Tools Team.
 * @email     
 * @copyright Copyright (C) 2013 Sanechips Technology Co., Ltd.
 * @warning   
 * @date      2019/02/02
 * @version   1.2
 * @pre       
 * @post      
 *            
 * @par       
 * Change History :
 * ---------------------------------------------------------------------------
 * date        version  author         description
 * ---------------------------------------------------------------------------
 * 2017/07/17  1.0      hou.bing       Create file
 * 2019/01/24  1.1      jiang.fenglin  1.usblogд
 *                                     2.߳
 * 2019/02/02  1.2      jiang.fenglin  ޸עͷʽΪdoxygen
 * 2019/07/08  1.3      jiang.fenglin  APFS/CPFSģʽ
 * ---------------------------------------------------------------------------
 * 
 * 
 */

#include <string.h>
#include <pthread.h>
#include <sys/prctl.h>
#include <sys/statfs.h>
#include "log_agent.h"
#include "cfg_api.h"

/**
 * 궨
 */
#define USB_DEV_SDCARD_PATH      "/dev/mmcblk0p1"
#define USB_DEV_SDCARD_PATH_BACK "/dev/mmcblk0"

#define ZCAT_SDCARD_MOUNT_PATH   "/tmp/udisk"
#define ZCAT_SDCARD_RULE_PATH    "/tmp/udisk/log.rule"
#define ZCAT_SDCARD_LOG_PATH     "/tmp/udisk/zcat_log"

/*APFS ģʽ:浽EMMC·͹·û*/
#define ZCAT_FS_CFG_LOG_PATH     "/zcat"
#define MAX_STRING_LENGTH        (256)
#define MAX_NVCFG_LOG_SIZE       (1000)
#define MAX_NUMSIZE_STRING_LEN   (16)
#define SINGLE_LOG_SIZE_TFCARD   (500*1024*1024)
#define SINGLE_LOG_SIZE_APFS     (100*1024*1024)
#define ZCAT_RULE_DIR_MAXLEN     (0x100)
#define ZCAT_MAX_LOG_NUM         (10)
#define ZCAT_MAX_CFG_TOTAL_SIZE  (0x100000)
#define ZCAT_ONE_MB_SIZE         (1024*1024)
#define ZCAT_MIN_VALUE(x, y)     ((x) < (y) ? (x) : (y))

/**
 * ȫֱ
 */
char *logfs_emmc_path;
char *logfs_rule_path;

static T_LOG_SDCARD_PARA g_log_sdcard_para = { {0} };
pthread_t rule_heartbeat_thread = 0;

extern int deal_with_encoded_data(unsigned char *buffer,int buf_len);

typedef struct
{
    char head1[16];
    int heartbeat_pos;
    int heartbeat_len;
    int rule_pos;
    int rule_len;
    int ap_rule_pos;
    int ap_rule_len;
    int log_file_size;
    int log_file_cnt;
}rule_struct;

char g_heartbeat_buff[35] = {
    0x01,0xaa,0xaa,0xaa,0x01,0x55,0x73,0x01,
    0x14,0x00,0x00,0x00,0x06,0x01,0xbb,0xbb,
    0x04,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x03,0x00,0x00,0x00,
    0xe6,0x7a,0x7e
};

/* 豸 */
extern BOOL bSDSet;
extern int cplog_fd;


/**
 * @brief жĿ¼Ƿڣ򴴽һµĿ¼
 * @param[in] dir_path Ŀ¼·
 * @return 0 on success, -1 error.
 * @note
 * @see 
 */
int test_dir_exist(char* dir_path)
{
    DIR *p_dir = NULL;
    
    if ((p_dir = opendir(dir_path)) == NULL)
    {
        printf("[zcat] opendir failed, mkdir %s\n", dir_path);
        if (mkdir(dir_path, 0777) != 0)
        {
            printf("[zcat] mkdir %s error, error info: %s\n", dir_path, strerror(errno));
            return -1;
        }
    }
    else
    {
        closedir(p_dir);
        p_dir = NULL;
    }
    return 0;
}

/**
 * @brief NVеַתΪֵ
 * @param[in]   nvItem_str ַ
 * @return[out] error:-1.
 * @note  
 * @see 
 */
int strtol_check(const char *nvItem_str)
{
    int nvItem_val = 0;

    errno = 0;
    nvItem_val = (int)strtol(nvItem_str, NULL, 0);

    if(errno == ERANGE)
    {
        printf("[zcat] strtol error, return\n");
        return -1;
    }
    return nvItem_val;
}

/**
 * @brief ʼsdlogò
 * @return void
 * @note
 * zte_log_agent -t total_size -n max_lognum Ƽʹ
 * else ֧: 
   zte_log_agent : Ĭֵ(APFS_SINGLE_LOG_SIZELogAPFS_MAX_LOG_NUM)
 * @see 
 */
static void init_cfg_param(int zcat_mode)
{
    int     nvint_size = 0;
    int     nvint_num = 0;
    int     max_logNum = 0; 
    UINT64  total_size = 0;
    char nvstr_num[MAX_NUMSIZE_STRING_LEN] = {0};
    char nvstr_size[MAX_NUMSIZE_STRING_LEN] = {0};

    if(g_log_sdcard_para.max_file_num == 0) 
    {
        sc_cfg_get("zlog_num", nvstr_num, MAX_NUMSIZE_STRING_LEN - 1);
        nvint_num = strtol_check(nvstr_num);

        if (nvint_num > 0)
        {
            g_log_sdcard_para.max_file_num = ZCAT_MIN_VALUE(nvint_num, ZCAT_MAX_LOG_NUM);
        }
    }

    if(g_log_sdcard_para.max_total_size == 0) 
    {
        sc_cfg_get("zlog_size", nvstr_size, MAX_NUMSIZE_STRING_LEN - 1);    
        nvint_size = strtol_check(nvstr_size);
        
        if((nvint_size > 0) && (nvint_size < MAX_NVCFG_LOG_SIZE))
        {
            g_log_sdcard_para.max_total_size = (UINT64)(nvint_size) * ZCAT_ONE_MB_SIZE;    
        }
    }
    
    max_logNum = g_log_sdcard_para.max_file_num;
    total_size = g_log_sdcard_para.max_total_size;
    printf("[zcat] max_logNum %d\n", max_logNum);
    printf("[zcat] max_total_size %lld\n", g_log_sdcard_para.max_total_size);
    
    if (total_size && max_logNum)
    {
        g_log_sdcard_para.max_file_size = total_size / max_logNum;
    }
    else
    {
        if (zcat_mode == ZCAT_MODE_AP_TF) 
        {
            g_log_sdcard_para.max_file_size = SINGLE_LOG_SIZE_TFCARD;
        }
        else
        {
            g_log_sdcard_para.max_file_size = SINGLE_LOG_SIZE_APFS;
        }
        g_log_sdcard_para.max_file_num = ZCAT_MAX_LOG_NUM;
    }

    g_log_sdcard_para.log_overwrite = 1;
    g_log_sdcard_para.compress_log_files = 1;
    g_log_sdcard_para.file_counts = 0;
    g_log_sdcard_para.output_fd = -1;
    g_log_sdcard_para.free_space_limit = ZCAT_ONE_MB_SIZE;
}

/**
 * @brief ʼsdnormalģʽ
 * @return void
 * @note
 * @see 
 */
static int init_sdcard_flash_mode()
{
    memset(g_log_sdcard_para.log_dir, 0, sizeof(g_log_sdcard_para.log_dir));
    strcpy(g_log_sdcard_para.log_dir, ZCAT_SDCARD_LOG_PATH);

    if(test_dir_exist(g_log_sdcard_para.log_dir) < 0)//־ļ
    {
        printf("[zcat] test %s dir exist failed. \n", g_log_sdcard_para.log_dir);
        return -1;
    }
    return 0;
}

/**
 * @brief ʼsduģʽ
 * @return void
 * @note
 * @see 
 */
static int init_sdcard_u_mode()
{
    memset(g_log_sdcard_para.log_dir, 0, sizeof(g_log_sdcard_para.log_dir));
    strcpy(g_log_sdcard_para.log_dir, ZCAT_SDCARD_LOG_PATH);
    if(test_dir_exist(ZCAT_SDCARD_LOG_PATH) < 0)//ж־Ŀ¼Ƿ
    {
        printf("[zcat] test_dir_exist failed:%s. \n", ZCAT_SDCARD_LOG_PATH);
        return -1;
    }
    /*if(test_dir_exist(MODEM_LOG_PATH) < 0)//жcp־Ŀ¼Ƿ
    {
        printf("test_dir_exist failed:%s. \n", MODEM_LOG_PATH);
        return -1;
    }*/
    return 0;
}

int zCat_MountSd()
{
    char cmd[100] = { 0 };

    if(test_dir_exist(ZCAT_SDCARD_MOUNT_PATH) < 0) // صʱļ
    {
        printf("[zcat] create %s fail.\n", ZCAT_SDCARD_MOUNT_PATH);
        return -1;
    }

    printf("[zcat] init sd output dir successs.\n");

    memset(cmd, 0, sizeof(cmd));
    sprintf(cmd, "mount -t vfat %s %s", USB_DEV_SDCARD_PATH, ZCAT_SDCARD_MOUNT_PATH); 
    if(0 != zxic_system(cmd))
    {
        printf("[zcat] cmd %s fail!\n", cmd);

        memset(cmd, 0, sizeof(cmd));
        sprintf(cmd, "mount -t vfat %s %s", USB_DEV_SDCARD_PATH_BACK, ZCAT_SDCARD_MOUNT_PATH); 
        if(0 != system(cmd))
        {
            printf("[zcat] cmd %s fail, mount error!\n", cmd);
            return -1;
        }
    }
    return 0;
}

/**
 * @brief ɾĿ¼ڴļ\n
 *        ļжϴʱ䣬ɾȴǸļ
 * @param[in] dir_path Ŀ¼·
 * @return void
 * @note
 * @see 
 */
static void delete_oldest_file(char* dir_path)
{
    DIR *p_dir = NULL;
    struct dirent *p_entry = NULL;
    char oldest_file[64] = "99999999999999";    //ڵֵ
    char file_name[MAX_STRING_LENGTH] = {0};
    p_dir = opendir(dir_path);

    if(p_dir)
    {
        while ((p_entry = readdir(p_dir)) != NULL)
        {
            if (strncmp(p_entry->d_name, ".", 1) == 0)
                continue;

            if (strcmp(p_entry->d_name, oldest_file) < 0)
            {
                strncpy(oldest_file, p_entry->d_name, 64 - 1);
            }
        }

        snprintf(file_name, MAX_STRING_LENGTH, "%s/%s", dir_path, oldest_file);
        if(remove(file_name) != 0)
        {
            printf("[zcat] remove %s fail!errno=%d(%s)\n",file_name,errno,strerror(errno));
        }
        closedir(p_dir);
    }
}


/**
 * @brief dir_pathĿ¼´logļļ,\n
 *        ԵǰʱΪļlogļlogļLOG_FILE_MAX_NO
 *        ǰļѴޣɾȴļ,ԵǰʱΪļļ
 * @param[in] log_sdcard_para ־T
 * @return 򿪵logļ
 * @note
 * @see 
 */
static int open_log_file(T_LOG_SDCARD_PARA* log_sdcard_para)
{
    int fd = -1;
    char file_name[MAX_STRING_LENGTH] = {0};
    struct tm *cur_time;
    time_t now;

    now = time(NULL);
    cur_time = localtime(&now);

    if(cur_time != NULL)
        snprintf(file_name, MAX_STRING_LENGTH, "%s/%d_%02d%02d_%02d%02d%02d%s", log_sdcard_para->log_dir, cur_time->tm_year + 1900,
             cur_time->tm_mon + 1, cur_time->tm_mday, cur_time->tm_hour, cur_time->tm_min,
             cur_time->tm_sec, ".log");

    if (log_sdcard_para->log_overwrite)
    {
        log_sdcard_para->file_counts++;

        struct statfs diskInfo;
        statfs(g_log_sdcard_para.log_dir, &diskInfo);

        if ((diskInfo.f_bfree * diskInfo.f_bsize < log_sdcard_para->free_space_limit)
        || (log_sdcard_para->file_counts > log_sdcard_para->max_file_num))
        {
            delete_oldest_file(log_sdcard_para->log_dir);
            log_sdcard_para->file_counts--;
        }
    }

    fd = open(file_name, O_WRONLY | O_CREAT, S_IRUSR | S_IWUSR | S_IWGRP | S_IRGRP | S_IWOTH | S_IROTH);

    if (fd >= 0)
    {
        fchmod(fd, S_IRUSR | S_IWUSR | S_IRGRP |S_IWGRP | S_IROTH |S_IWOTH);
    }
    strncpy(log_sdcard_para->log_name, file_name, MAX_STRING_LENGTH-1);

    return fd;
}

/**
 * @brief APFSģʽµĲʼlog͹Ĵ洢·
 * @param[in] argc 
 * @param[in] argv
 * @return 0 on success, errno otherwise
 * @note
 * @see 
 */
int log_argv_proc(int argc, char *argv[])
{
    int opt;
    int fnum_flag  = 0;
    int tsize_flag = 0;
    unsigned int tsize_val = 0;
    extern char *optarg;

    while ((opt=getopt(argc,argv,"d:r:n:t:")) != EOF)
    {
        switch (opt) 
        {
            case 'd':
                logfs_emmc_path = optarg;
                if (logfs_emmc_path)
                    printf("[zcat] APFS [%s] : log save path %s\n", __func__, logfs_emmc_path);
                break;
            case 'r':
                logfs_rule_path = optarg;
                if (logfs_rule_path)
                    printf("[zcat] APFS [%s]: path_logrule %s\n", __func__, logfs_rule_path);
                break;
            case 'n':
                fnum_flag = 1;
                if(optarg)
                    g_log_sdcard_para.max_file_num = atoi(optarg);
                break;
            case 't':
                tsize_flag = 1;
                if(optarg)
                {
                    tsize_val = atoi(optarg);
                    if ((0 < tsize_val) 
                        && (tsize_val <= ZCAT_MAX_CFG_TOTAL_SIZE))
                    {
                        g_log_sdcard_para.max_total_size = tsize_val * ZCAT_ONE_MB_SIZE;
                    }
                    else
                    {
                        printf("-t param error: total log size should be smaller than %d !", ZCAT_MAX_CFG_TOTAL_SIZE);
                        return -1;
                    }
                }
                break;
            default:
                break;
        }
    }
    if (fnum_flag^tsize_flag)
    {
        printf("param error: \"log_agent -t 100 -n 10\"  or \"log_agent\" !");
        return -1;
    }
    else
    {
        return 0;
    }
}

/**
 * @brief ʼlogĿ¼
 * @param[in] n/a
 * @return 0 on success, errno otherwise
 * @note
 * @see 
 */
int init_fs_log_dir()
{
    char *log_path  = NULL;
    char *rule_file = NULL;
    int  logdir_size  = 0;     
    int  ruledir_size  = 0; 
    
    log_path     = g_log_sdcard_para.log_dir;
    rule_file    = g_log_sdcard_para.rule_path;
    logdir_size  = sizeof(g_log_sdcard_para.log_dir);
    ruledir_size = sizeof(g_log_sdcard_para.rule_path);

    init_cfg_param(ZCAT_MODE_AP_FS);
    
    memset(log_path,  0, logdir_size);
    memset(rule_file, 0, ruledir_size);
    
    if (logfs_emmc_path)
    {
        //ж·Ƿ
        if (access(logfs_emmc_path, R_OK|W_OK) < 0)
        {
            sc_cfg_get("zlog_path", log_path, logdir_size);
            printf("[zcat] APFS log: path error, errno=%d, so now read from nv!\n", errno);            
        }    
        else
        {
            snprintf(log_path, MAX_STRING_LENGTH - 1 , "%s%s", logfs_emmc_path, ZCAT_FS_CFG_LOG_PATH);
        }
    }
    else
    {        
        sc_cfg_get("zlog_path", log_path, logdir_size);
    }
    
    if (logfs_rule_path)
        strncpy(rule_file, logfs_rule_path, ruledir_size - 1);
    else
        sc_cfg_get("rule_file", rule_file, ruledir_size - 1);
        
    printf("[zcat] log_path: %s, rule_file %s\n", log_path, rule_file);
    
    if(test_dir_exist(log_path) < 0)//־ļ
    {
        printf("[zcat] test %s dir exist failed. \n", g_log_sdcard_para.log_dir);
        return -1;
    }

    g_log_sdcard_para.output_fd = open_log_file(&g_log_sdcard_para);//־ļ
    if (g_log_sdcard_para.output_fd == -1)
    {
        printf("[zcat] failed to open log file!\n");
        return -1;
    }
    return 0;
}

/**
 * @brief ʼsdlogĿ¼
 * @param[in] mode normalģʽ/uģʽ
 * @return 0 on success, errno otherwise
 * @note
 * @see 
 */
int init_sdcard_log_dir(E_FLASH_MODE mode)
{
    init_cfg_param(ZCAT_MODE_AP_TF);

    if(mode == FLASH_MODE_U)
    {
        if(init_sdcard_u_mode() < 0)
        {
            printf("[zcat] init_sdcard_u_mode failed!\n");
            return -1;
        }
    }
    else
    {
        if(init_sdcard_flash_mode() < 0)
        {
            printf("[zcat] init_sdcard_flash_mode failed!\n");
            return -1;
        }
    }

    memset(g_log_sdcard_para.rule_path, 0, sizeof(g_log_sdcard_para.rule_path));
    strcpy(g_log_sdcard_para.rule_path, ZCAT_SDCARD_RULE_PATH);

    g_log_sdcard_para.output_fd = open_log_file(&g_log_sdcard_para);//־ļ
    if (g_log_sdcard_para.output_fd == -1)
    {
        printf("[zcat] failed to open log file!\n");
        return -1;
    }
    return 0;
}

/**
 * @brief дlogSD.\n
 * @param[in] fd һдsdеzlfļ
 * @param[in] buf дָ
 * @param[in] len дָ
 * @param[in] log_sdcard_para sd
 * @return ʵдĳ
 * @note
 * @see 
 */
static int output_log_to_sdcard(int fd, unsigned char *buf, int len, T_LOG_SDCARD_PARA* log_sdcard_para)
{
    int output_fd = fd;
    int write_len = 0;

    //static int file_size = 0;
    log_sdcard_para->file_size += len;

    // ļСﵽļߴ磬½һļ
    if (log_sdcard_para->file_size > log_sdcard_para->max_file_size)
    {
        close(fd);

        if (log_sdcard_para->compress_log_files)
        {
            //compress_log_files(g_log_dir);
        }

        output_fd = open_log_file(log_sdcard_para);
        if (output_fd == -1)
        {
            return -1;
        }
        log_sdcard_para->output_fd = output_fd;
        log_sdcard_para->file_size = len;
    }

    write_len = write(output_fd, buf, len);
    if(write_len != len) // Tдɾ֮ǰlogļ
    {
        delete_oldest_file(log_sdcard_para->log_dir);
        log_sdcard_para->file_counts--;
        write_len = write(output_fd, buf, len);
        if(write_len != len)
        {
            return -1;
        }
    }

    return write_len;
}

/**
 * @brief bufferд뵽T
 * @param[in] buffer дָ
 * @param[in] buffer_len дݳ
 * @return ʵдĳ
 * @note
 * @see 
 */
int send_message_to_sdcard(unsigned char* buf, int len)
{
    return output_log_to_sdcard(g_log_sdcard_para.output_fd, buf, len, &g_log_sdcard_para);
}

/**
 * @brief ͹ļcp.\n
 * @param[in] fd ļ
 * @param[in] offset ļƫ
 * @param[in] length ݳ
 * @return 0 on success, -1 otherwise
 * @note
 * @see 
 */
static int send_rules_to_cp(int fd, int offset, int length)
{
    char buf[1024] = {0};
    int left_len = 0;
    int next_buf_len = 0;
    int read_len = 0;

    if(lseek(fd, offset, SEEK_SET) == -1)
    {
        printf("[zcat] rules file lseek to pos %d failed (%s)\n", offset, strerror(errno));
        return -1; 
    }

    left_len = length;
    next_buf_len = sizeof(buf) < left_len ? sizeof(buf) : left_len;
    while((read_len = read(fd, buf, next_buf_len)) > 0)
    {
        int write_len = write(cplog_fd, buf, read_len);
        if (write_len != read_len)
        {
            printf("[zcat] send_rule error, write_len = %d, len = %d.\n", write_len, read_len);
            return -1;
        }
        left_len -= read_len;
        next_buf_len = sizeof(buf) < left_len ? sizeof(buf) : left_len;
    }
    return 0;
}


/**
 * @brief ͹ļap, app devkernel dev.\n
 * @param[in] fd ļ
 * @param[in] offset ļƫ
 * @param[in] length ݳ
 * @return 0 on success, -1 otherwise
 * @note
 * @see 
 */
static int send_rules_to_ap(int fd, int offset, int length)
{
    unsigned char buf[1024] = {0};
    int left_len = 0;
    int next_buf_len = 0;
    int read_len = 0;

    if(lseek(fd, offset, SEEK_SET) == -1)
    {
        printf("[zcat] rules file lseek to pos %d failed (%s)\n", offset, strerror(errno));
        return -1; 
    }

    left_len = length;
    next_buf_len = sizeof(buf) < left_len ? sizeof(buf) : left_len;
    while((read_len = read(fd, buf, next_buf_len)) > 0)
    {
        deal_with_encoded_data(buf, read_len);
        next_buf_len = sizeof(buf) < left_len ? sizeof(buf) : left_len;
    }
    return 0;
}

/**
 * @brief ļϷԣȡժҪϢ.\n
 * @param[in] fd ļ
 * @param[out] rule_info ļҪϢ
 * @return ļĴС
 * @note
 * @see 
 */
static int get_rule(int fd, rule_struct *rule_info)
{
    int len = 0;
    
    len = read(fd, rule_info, sizeof(rule_struct));
    if(len <= 0)
    {
        printf("[zcat] rule file len = %d\n", len);
        return len;
    }
    printf("[zcat] rule_info\n\theartbeat_pos : %d\n\theartbeat_len : %d\n\trule_pos      : %d\n\trule_len      : %d\n",
        rule_info->heartbeat_pos,
        rule_info->heartbeat_len,
        rule_info->rule_pos,
        rule_info->rule_len
        );

    if(rule_info->heartbeat_len > sizeof(g_heartbeat_buff))
    {
        printf("[zcat] check_rule, heartbeat voerload %d error.\n", sizeof(g_heartbeat_buff));
        return -1;
    }

    // ȡļеݣ滻Ĭ
    if(lseek(fd, rule_info->heartbeat_pos, SEEK_SET) == -1)
    {
        printf("[zcat] check_rule, lseek to heartbeat_pos error.\n");
        return -1;
    }
    if(read(fd, g_heartbeat_buff, rule_info->heartbeat_len) <= 0)
    {
        printf("[zcat] check_rule, read heartbeat data error.\n");
        return -1;
    }
    
    return len;
}

/**
 * @brief ̣߳\n
 *        ȡsdеĹļ͸pcԵķ.
 * @param[in] arg sdļ
 * @return void
 * @note
 * @see 
 */
static void rule_heartbeat_entry(void *arg)
{
    BOOL bSendRule = FALSE;
    int rule_file_fd = 0;
    int rule_len = 0;
    rule_struct rule_info = { {0} };
    char* heartbeat_buf = g_heartbeat_buff;
    int heartbeat_len = sizeof(g_heartbeat_buff);

    prctl(PR_SET_NAME, "heartbeat");
    
    while(TRUE)
    {
        int write_len = write(cplog_fd, heartbeat_buf, heartbeat_len);
        if (write_len != heartbeat_len)
        {
            printf("[zcat] send heartbeat failed! %d, %d, %d\n", cplog_fd, heartbeat_len, write_len);
        }
        
        sleep(2);
        if(bSDSet == TRUE && bSendRule == FALSE)
        {
             rule_file_fd = open(g_log_sdcard_para.rule_path, O_RDONLY, S_IRUSR);
             if (rule_file_fd < 0)
             {
                printf("[zcat] failed to open rule file %s.\n", g_log_sdcard_para.rule_path);
                continue;
             }

             // ļϷ
             rule_len = get_rule(rule_file_fd, &rule_info);
             if(rule_len <= 0)
             {
                close(rule_file_fd);
                return;
             }
             printf("[zcat] check rule success,len is %d\n", rule_len);

             // cp
             send_rules_to_cp(rule_file_fd, rule_info.rule_pos, rule_info.rule_len);
             printf("[zcat] send rules to cp %d bytes,position %d\n",
                rule_info.rule_len,
                rule_info.rule_pos);
             // ap
             send_rules_to_cp(rule_file_fd, rule_info.ap_rule_pos, rule_info.ap_rule_len);
             printf("[zcat] send rules to cp %d bytes,position %d\n", 
                rule_info.ap_rule_len,
                rule_info.ap_rule_pos);
             
             close(rule_file_fd);
             bSendRule = TRUE;
        }
    }
}

#if 0
/**
 * @brief ȡsdcardģʽ
 * @param[in] void
 * @return sdcardģʽ
 * @note
 * @see 
 */
static E_FLASH_MODE get_flash_mode()
{
    E_FLASH_MODE flash_mode = FLASH_MODE_NOMAL;

    return flash_mode;
}
#endif

/**
 * @brief ʼsdcardģʽ߳.
 * @param[in] void
 * @return 0 on success, errno otherwise
 * @note
 * @see 
 */
int init_sdcard_mode()
{
    //E_FLASH_MODE flash_mode = FLASH_MODE_NOMAL;

    //flash_mode = get_flash_mode();
    pthread_create(&rule_heartbeat_thread, NULL, (void*)rule_heartbeat_entry, NULL);

    return 0;
}
