/**
 * 
 * @file      log_agent_usblog.c
 * @brief     
 *            This file is part of ZCAT.
 *            zcatӦòlog_agentͨusb
 *            
 * @details   
 * @author    Tools Team.
 * @email     
 * @copyright Copyright (C) 2013 Sanechips Technology Co., Ltd.
 * @warning   
 * @date      2019/02/22
 * @version   1.4
 * @pre       
 * @post      
 *            
 * @par       
 * Change History :
 * ---------------------------------------------------------------------------
 * date        version  author         description
 * ---------------------------------------------------------------------------
 * 2017/07/17  1.0      hou.bing       Create file
 * 2019/01/24  1.1      jiang.fenglin  1.usblogд
 *                                     2.߳
 * 2019/01/25  1.2      jiang.fenglin  APUSBģʽtty·ù
 * 2019/02/02  1.3      jiang.fenglin  ޸עͷʽΪdoxygen
 * 2019/02/22  1.4      jiang.fenglin  ̬LOG˿,log˿ڶֻ̬usbΪģʽģʽֲ
 * ---------------------------------------------------------------------------
 * 
 * 
 */

#include <unistd.h>
#include <pthread.h>
#include <stdio.h>
#include <string.h>
#include <sys/prctl.h>
#include "cfg_api.h"
#include "log_agent.h"
#include "port_com.h"


#define ZCAT_FACTORY_PATH "/sys/devices/virtual/android_usb/android0/f_acm/instances"
#define ZCAT_DEFAULT_TTY  "ttyGS2"
char g_zcat_usblog[8] = { 't', 't', 'y', 'G', 'S', '2' };

int usblog_fd = -1;
pthread_t read_usb_thread = 0;
unsigned char g_UsbLogBuf[2048 + 1] = { 0 };
const struct timespec notimer_interval = {0, 300000}; // 20ms
pthread_rwlock_t usblog_rwlock = PTHREAD_RWLOCK_INITIALIZER;

extern int send_log_to_cp(unsigned char *buf, int len);
extern int deal_with_encoded_data(unsigned char *buffer, int buf_len);
extern int init_monitor_hotplug();
extern int hb_flag;

/**
 * @brief ݵusblog
 * @param[in] buf ͵ݻָ
 * @param[in] len ͵ݳ
 * @return void
 * @note
 * @see 
 */
int send_message_to_usblog(unsigned char* buf, int len)
{
    int write_len = 0;  
    int i = 0;
    int ret = -1;

    if ( buf && len )
    {
        for(i = 0; i < 100; i++)
        {
            pthread_rwlock_rdlock(&usblog_rwlock);
            if ( usblog_fd >= 0 )
            {
                write_len = write(usblog_fd, buf, len);
            }
            pthread_rwlock_unlock(&usblog_rwlock);

            //printf("send_message_to_usblog %8d,%8d\n", len, write_len);

            if ( write_len == len )
            {
                ret = 0;
                break;
            }
            else if( write_len )
            {
                len -= write_len;
            }
            else
            {
                nanosleep(&notimer_interval, NULL);
            }
        }
    }
    
    return ret;
}

/**
 * @brief ͹ļ̺߳\n
 *        pc͵ueݣת
 * @param[in] args ̺߳
 * @return void
 * @note
 * @see 
 */
static void *read_usblog(void *args)
{
    unsigned char *pbuf = NULL;
    int read_len = 0;
    
    pbuf = g_UsbLogBuf;
	/*
    if(pbuf == NULL)
    {
        printf("[zcat] read_usblog fail.\n");
        return NULL;
    }*/

    prctl(PR_SET_NAME, "read_usblog");
    
    while(1)
    {
        pthread_rwlock_rdlock(&usblog_rwlock);
        if( usblog_fd >= 0)
        {
            read_len = read(usblog_fd, pbuf, 2*1024);
        }
        pthread_rwlock_unlock(&usblog_rwlock);

        if(read_len > 0)
        {
            //printf("[zcat] read_usblog %d bytes\n",read_len);
            send_log_to_cp(pbuf, read_len); // cp͹
            deal_with_encoded_data(pbuf, read_len); // ap͹
        }

        if( usblog_fd < 0 || read_len <= 0 )
        {
            //printf("[zcat] read_usblog sleep 2\n");
            sleep(2);
        }
    }

    return NULL;
}


/**
 * @brief ȡļС
 * @param[in] fp ļָ
 * @return ļСλֽ
 * @note
 * @see 
 */
int filelength(FILE *fp)
{
    int num;
    fseek(fp, 0, SEEK_END);
    num = ftell(fp);
    fseek(fp, 0, SEEK_SET);
    return num;
}

/**
 * @brief ȡļ
 * @param[in] path ļ·
 * @param[out] buf ָ
 * @param[in] len ĿռС
 * @return ļʵʴСλֽ
 * @note
 * @see 
 */
static int readfile(char *path, char* buf, unsigned len)
{
    FILE *fp;
    int length;
    if((fp = fopen(path, "r")) == NULL)
    {
        printf("[zcat] open file %s error.\n", path);
        return -1;
    }
    length = filelength(fp);
    length = length > len ? len : length;
    //ch=(char *)malloc(length+1);
    fread(buf, (unsigned int)length, 1, fp);
    fclose(fp);
    *(buf + length) = '\0';
    return length;
}

/**
 * @brief жǷΪģʽ
 * @param[in] void
 * @return 1 - ģʽ0 - ģʽ
 * @note
 * @see 
 */
static int is_factory_mode()
{
    char buf[2] = { 0 };
    int itemp;
    
    readfile(ZCAT_FACTORY_PATH, buf, 1);

    itemp = atoi(buf);
    printf("[zcat] ZCAT_FACTORY_PATH : %d\n", itemp);

    if(itemp == 2)
        return 1;
    else
        return 0;
}

#if 0
/**
 * @brief дļ
 * @param[in] path ļ·
 * @param[in] buf ָ
 * @param[in] len ĿռС
 * @return ʵдĳȣλֽ
 * @note
 * @see 
 */
static int writefile(char*path, char*buf, unsigned len)
{
    FILE *fp;
    int rtv;
    
    if((fp = fopen(path, "w")) == NULL)
    {
        printf("[zcat] open file %s error.\n", path);
        return -1;
    }
    rtv = fwrite(buf, len, 1, fp);
    fclose(fp);
    return rtv;
}
#endif

/**
 * @brief ȡusblogtty·
 * @param[in] void
 * @return void
 * @note
 * @see 
 */
void get_usblog_tty_path()
{
    int isFactory = is_factory_mode();
    
    memset(g_zcat_usblog, 0, sizeof(g_zcat_usblog));
    
    if(isFactory)
    {
        sprintf(g_zcat_usblog, ZCAT_DEFAULT_TTY);
        g_zcat_usblog[5] = '1'; // ģʽlogڹ̶ΪttyGS1ָ
    }
    else
    {
        // tty·ʹõ·ʹĬϵ
        sc_cfg_get("zcat_usblog", g_zcat_usblog, sizeof(g_zcat_usblog) - 1);
        if (strlen(g_zcat_usblog) < 3)
        {
            sprintf(g_zcat_usblog, ZCAT_DEFAULT_TTY);
        }
    }
}

/**
 * @brief رusb豸
 * @param[in] void
 * @return 0 on success, errno otherwise
 * @note
 * @see 
 */
int close_usblog()
{
    int ret = -1;

    pthread_rwlock_wrlock(&usblog_rwlock); // дرն˿ڹвд
    if(usblog_fd >= 0)
    {
        ret = close(usblog_fd);
        if (ret < 0)
        {
            printf("[zcat] close usblog_dev faild, ret = %d, error = %s\n", ret, strerror(errno));
			pthread_rwlock_unlock(&usblog_rwlock);
            return ret;  
        }
        else
        {
            usblog_fd = -1;
        }
    }
    pthread_rwlock_unlock(&usblog_rwlock);
    
    return 0;
}

/**
 * @brief usb豸
 * @param[in] void
 * @return 豸
 * @note
 * @see 
 */
int open_usblog()
{
    int fd = -1;
    char usblog_dev[16] = { 0 };

    if ( usblog_fd >= 0 ) {
        close_usblog();
    }

    sprintf(usblog_dev, "/dev/%s", g_zcat_usblog);
    
    fd = open(usblog_dev, O_RDWR);
    if ( fd < 0 )
    {
        printf("[zcat] open %s error!\n", usblog_dev);
        return -1;
    }
    printf("[zcat] open %s\n", usblog_dev);
    
    usblog_fd = fd;
    
    PortSet(fd);

    return fd;
}

/**
 * @brief ʼusbģʽ\n
 *        ȡusbtty·.
 *        ttyȡpc෢ļ
 *        usbȲμ߳
 * @param[in] void
 * @return 0 on success, errno otherwise
 * @note
 * @see 
 */
int init_usblog_mode()
{
    int ret = 0;

    ret = pthread_rwlock_init(&usblog_rwlock, NULL);
    if(ret)
    {
        printf("[zcat] usblog_rwlock init error.\n"); 
        return -1;
    }
    else
    {
        ret = init_monitor_hotplug();
        if(ret < 0)
        {
            printf("[zcat] init_monitor_hotplug error.\n"); 
            goto __exit;
        }

        ret = pthread_create(&read_usb_thread, NULL, read_usblog, NULL);
        if(ret != 0)
        {   
            printf("[zcat] create read_usb_thread error.\n");
            goto __exit;
        }
        return ret;
    __exit:
        pthread_rwlock_destroy(&usblog_rwlock);
        return ret;
    }
}


