/*********************************************************************
 Copyright 2016 by  ZIXC Corporation.
*
* FileName::    zx234290.c
* File Mark:
* Description:
* Others:
* Version:
* Author:
* Date:

* History 1:
*     Date:
*     Version:
*     Author:
*     Modification:
* History 2:
**********************************************************************/

#include <common.h>
#include <errno.h>
#include <command.h>
#include <malloc.h>
#include <asm/io.h>
#include <boot_mode.h>
#include <i2c.h>
#include <drvs_gpio.h>
#include <power.h>
#include <zx234290.h>
#include <zx234502.h>
#include <watchdog.h>

int zx234290_write_flag(UINT8 val);

#define PIN_PSHOLD_NUM     GPIO24
#define GPIO_PSHOLD_FUNC_SEL    GPIO24_GPIO24

static boot_reason_t s_boot_reason = UNKNOWN_BOOT_REASON;
unsigned int g_pmu_type = PMU_TYPE_MAX;

/*******************************************************************************
 * Function:    zx234290_i2c_read_reg
 * Description:
 * Parameters:
 *   Input:
 *
 *   Output:
 *
 * Returns:
 *
 *
 * Others:
 ********************************************************************************/
int zx234290_i2c_read_reg(ushort reg, uchar *val)
{
    return i2c_read(0, ZX234290_I2C_SLAVE_ADDR, reg, 8, val, 1);
}

/*******************************************************************************
 * Function:    zx234290_i2c_write_reg
 * Description:
 * Parameters:
 *   Input:
 *
 *   Output:
 *
 * Returns:
 *
 *
 * Others:
 ********************************************************************************/
int zx234290_i2c_write_reg(ushort reg, uchar *val)
{
	return i2c_write(0, ZX234290_I2C_SLAVE_ADDR, reg, 8, val, 1);
}

int zx234290_reset_flag(void)
{
#if 0
    int ret = 0;
    int val = 0;

    /*
    int val = 0xff;
    ret = zx234290_i2c_write_reg(0x0f,&val);
    */
    ret = zx234290_i2c_read_reg(BUCK_MODE_CONTROL0, &val);
    val &= (~0x30);
    ret += zx234290_i2c_write_reg(BUCK_MODE_CONTROL0, &val);

    return ret;
#else
    return zx234290_write_flag(ZX234290_USER_RST_UNDEFINE);
#endif
}

int zx234290_write_flag(UINT8 val)
{
#if 0
    int ret = 0;
    int tmp = 0;

    if(val > 3)
    {
        return -1;
    }
    ret = zx234290_i2c_read_reg(BUCK_MODE_CONTROL0, &tmp);
    tmp  &= (~0x30);
    tmp |= (val<<4);
    ret += zx234290_i2c_write_reg(BUCK_MODE_CONTROL0, &tmp);

    return ret;
#else
    int ret = 0;
    uchar tmp = 0;

    /*
    ret = zx234290_i2c_read_reg(ZX234290_REG_ADDR_USER_RESERVED, &tmp);
    tmp &= ~(0x03<<2);
    tmp |= (val<<2);
    */
    tmp = val;
    ret |= zx234290_i2c_write_reg(ZX234290_REG_USER, &tmp);

    return ret;
#endif
}


void zx234290_set_rtc_alarm_off(void)
{
    int ret = 0;
    uchar tmp = 0;

   //set alarm active bit 1 disable
    ret = zx234290_i2c_read_reg(ZX234290_REG_ADDR_ALARM_MINUTE, &tmp);
    tmp |= (1<<ZX234290_RTC_AlARM_ACTIVATED_LSH);
    ret |= zx234290_i2c_write_reg(ZX234290_REG_ADDR_ALARM_MINUTE, &tmp);

    ret |= zx234290_i2c_read_reg(ZX234290_REG_ADDR_ALARM_HOUR, &tmp);
    tmp |= (1<<ZX234290_RTC_AlARM_ACTIVATED_LSH);
    ret |= zx234290_i2c_write_reg(ZX234290_REG_ADDR_ALARM_HOUR, &tmp);

	ret |= zx234290_i2c_read_reg(ZX234290_REG_ADDR_ALARM_DAY, &tmp);
    tmp |= (1<<ZX234290_RTC_AlARM_ACTIVATED_LSH);
    ret |= zx234290_i2c_write_reg(ZX234290_REG_ADDR_ALARM_DAY, &tmp);

	ret = zx234290_i2c_read_reg(ZX234290_REG_ADDR_ALARM_WEEK, &tmp);
    tmp |= (1<<ZX234290_RTC_AlARM_ACTIVATED_LSH);
    ret |= zx234290_i2c_write_reg(ZX234290_REG_ADDR_ALARM_WEEK, &tmp);

	
	ret |= zx234290_i2c_read_reg(ZX234290_REG_ADDR_ALARM_SECOND, &tmp);
    tmp |= (1<<ZX234290_RTC_AlARM_ACTIVATED_LSH);
    ret |= zx234290_i2c_write_reg(ZX234290_REG_ADDR_ALARM_SECOND, &tmp);
	
    /*disable AIE bit && AF*/
    ret |= zx234290_i2c_read_reg(ZX234290_REG_RTC_CONTROL2, &tmp);
    tmp &= ~(RTC_CONTROL2_AIE|RTC_CONTROL2_AF);
    ret |= zx234290_i2c_write_reg(ZX234290_REG_RTC_CONTROL2, &tmp);

	if(ret)		
		printf( "[%s] fail ret=%d...\n", __FUNCTION__, ret);
		
}
/*******************************************************************************
 * Function:    zx234290_get_boot_reason
 * Description:
 * Parameters:
 *   Input:
 *
 *   Output:
 *
 * Returns:
 *
 *
 * Others:
 ********************************************************************************/
int zx234290_get_boot_reason(boot_reason_t *boot_reason)
{
    if (boot_reason == NULL)
    {
        return -1;
    }

	if(s_boot_reason == UNKNOWN_BOOT_REASON)
	{
		return -EIO;
	}
	*boot_reason = s_boot_reason;

	return 0;
}

/*******************************************************************************
 * Function:	zx234290_get_boot_reason
 * Description:
 * Parameters:
 *	 Input:
 *
 *	 Output:
 *
 * Returns:
 *
 *
 * Others:
 ********************************************************************************/
static int zx234290_get_boot_reason_prev(void)
{
    int ret = 0;
    uchar reg_user = ZX234290_USER_RST_UNDEFINE;
    uchar reg_start = 0;
    uchar reg_write = 0;

	/* START_UP_STATUS */
    ret = zx234290_i2c_read_reg(START_UP_STATUS, &reg_start);
    if( ret != 0 )
    {
		return -EIO;
    }
	printf( "	[%s][START_UP_STATUS = 0x%X] ...\n", __FUNCTION__, reg_start);
    (*(volatile unsigned long *)(START_UP_STATUS_BASE))=reg_start;

	/* ZX234290_REG_USER */
    ret = zx234290_i2c_read_reg(ZX234290_REG_USER, &reg_user);
    if(reg_user != ZX234290_USER_RST_UNDEFINE)
    {
        reg_write = ZX234290_USER_RST_UNDEFINE; /* write back the reset value */

        ret |= zx234290_i2c_write_reg(ZX234290_REG_USER, &reg_write);
    }
    if ( ret != 0 )
    {
       return -EIO;
    }
    printf( "	[%s][USER_RESERVED   = 0x%X] ...\n", __FUNCTION__, reg_user);
    (*(volatile unsigned long *)(USER_RESERVED_BASE)) =reg_user;

   /* 1.  */
	if( reg_start & PWR_ON_START_UP )
    /* ϵͳ,ZX234290_REG_USERΪֵΪ */
    {
		s_boot_reason = RB_POWER_KEY;
            return 0;
        }
	else if( reg_start & PS_HOLD_START_UP )
	{
		s_boot_reason = RB_USB_INSERT;

        /* ZX234290_REG_USERΪϵ縴λֵǷֵ */
		return 0;
    }
	else if( reg_start & RTC_ALARM_START_UP )
   /* 2.  */
    {
		uchar rtc_ctrl2 = 0xF0;

		ret = zx234290_i2c_read_reg(ZX234290_REG_RTC_CONTROL2, &rtc_ctrl2);
    	printf( "	[%s][RTC_CONTROL2   = 0x%X]\n", __FUNCTION__, rtc_ctrl2);

		if (rtc_ctrl2 & RTC_CONTROL2_AF) {
			s_boot_reason = RB_RTC;
			zx234290_set_rtc_alarm_off();
		} else if (rtc_ctrl2 & RTC_CONTROL2_TF) {
			s_boot_reason = RB_RESET_NOMAL;
		}

		return ret;
    }
	else if( reg_start & LLP_RESTART_UP )
    {
		s_boot_reason = RB_POWER_KEY_LONG;
		return 0;
    }
	/* reg_startΪ0reg_start֮δ磬ϵͳ */

   /* 2.  */

    /* ϵͳ,ZX234290_REG_USERΪֵΪ */
    switch (reg_user)
    {
		case ZX234290_USER_RST_TO_NORMAL:
        {
			s_boot_reason = RB_RESET_NOMAL;
			return 0;
        }

		case ZX234290_USER_RST_TO_CHARGER:
        {
			s_boot_reason = RB_RESET_USB_OFF;
			return 0;
    }

		case ZX234290_USER_RST_TO_ALARM:
    {
			s_boot_reason = RB_RESET_ALARM;
			return 0;
    }

        /* ZX234290_REG_USERΪϵ縴λֵǷֵ */
        default:
		{
			if ((reg_user & 0xF0) == ZX234290_WDT_RST_FLAG) {
				s_boot_reason = reg_user;
				return 0;
			}
        break;
    	}
	}

	s_boot_reason = RB_USB_INSERT;

    return 0;
}

/*******************************************************************************
 * Function:    zx234290_ps_hold_pull_on
 * Description:
 * Parameters:
 *   Input:
 *
 *   Output:
 *
 * Returns:
 *
 *
 * Others:
 ********************************************************************************/
int zx234290_ps_hold_pull_on(void)
{
    zDrvGpio_PullUpDown(PIN_PSHOLD_NUM, 0);
    //gpio_set_reuse(PS_HOLD_PIN, 0);
    zDrvGpio_SetFunc(PIN_PSHOLD_NUM,GPIO_PSHOLD_FUNC_SEL);
    zDrvGpio_SetDirection(PIN_PSHOLD_NUM,GPIO_IN);    //set output;v3 gpio24(pshold) direction is reverse
    zDrvGpio_SetOutputValue(PIN_PSHOLD_NUM,GPIO_HIGH);
    return 0;
}

/*******************************************************************************
 * Function:    zx234290_ps_hold_pull_off
 * Description:
 * Parameters:
 *   Input:
 *
 *   Output:
 *
 * Returns:
 *
 *
 * Others:
 ********************************************************************************/
int zx234290_ps_hold_pull_off(void)
{
    zDrvGpio_PullUpDown(PIN_PSHOLD_NUM, 0);
    //gpio_set_reuse(PS_HOLD_PIN, 0);
     //gpio_direction_output(PS_HOLD_PIN, GPIO_LOW);
    zDrvGpio_SetFunc(PIN_PSHOLD_NUM,GPIO_PSHOLD_FUNC_SEL);
    zDrvGpio_SetDirection(PIN_PSHOLD_NUM,GPIO_IN);    //set output;v3 gpio24(pshold) direction is reverse
	zDrvGpio_SetOutputValue(PIN_PSHOLD_NUM,GPIO_LOW);
    return 0;
}

/*******************************************************************************
 * Function:    zx234290_power_off
 * Description:
 * Parameters:
 *   Input:
 *
 *   Output:
 *
 * Returns:
 *
 *
 * Others:
 ********************************************************************************/
int zx234290_power_off(void)
{
    return zx234290_ps_hold_pull_off();
}

/*******************************************************************************
 * Function:
 * Description:
 * Parameters:
 *   Input:
 *
 *   Output:
 *
 * Returns:
 *
 *
 * Others:
 ********************************************************************************/
int pmu_init(void)
{
    int ret = 0;
	uchar reg_val = 0;
	uchar reg_val1 = 0;
    struct pmu_opt pmu = {NULL};

    /* GPIO init */
    //gpio_set_reuse(PS_HOLD_PIN, 0x0);
    //gpio_direction_output(PS_HOLD_PIN,GPIO_LOW);

   // gpio_set_reuse(POWER_KEY_PIN,0x0);
   // gpio_direction_input(POWER_KEY_PIN);

   // gpio_noaction(POWER_KEY_PIN);

    /* register pmu opt */
    pmu.read_reg = zx234290_i2c_read_reg;
    pmu.write_reg = zx234290_i2c_write_reg;
    pmu.get_boot_reason = zx234290_get_boot_reason;
    pmu.ps_hold_pull_on = pmu_pull_on_ps_hold;
    pmu.ps_hold_pull_off = pmu_pull_off_ps_hold;
    pmu.power_off = zx234290_power_off;
    ret = register_pmu_opt(&pmu);
    if( ret != 0 )
    {
        return -EIO;
    }

	ret = zx234290_get_boot_reason_prev();
	ret +=zx234290_i2c_read_reg(ZX234297_REG_ADDR_SINK_CONTROL,&reg_val);
	ret +=zx234290_i2c_read_reg(ZX234290_REG_ADDR_TYPE,&reg_val1);
	if(reg_val==0x7f){//means 296G C
		reg_val = 0xff;//define to 296
		ret+=zx234290_i2c_write_reg(ZX234297_REG_ADDR_SINK_CONTROL,&reg_val);
	}
	
	if (ret != SUCCESS)
	{
		printf( "[%s]set 0x29 error ret=0x%x!\n", __FUNCTION__,ret);
		return ret;
	}
	
	if(0xff == reg_val)//296&296G
	{
		if(0==reg_val1)
			g_pmu_type = PMU_TYPE_296G;
		else
			g_pmu_type = PMU_TYPE_296;			
	}
	else//297
	{
		if(0==reg_val1)
			g_pmu_type = PMU_TYPE_296H;
		else
			g_pmu_type = PMU_TYPE_297;			
	}
    return ret;
}

/* ================================================================================
 *  pmu_init:
 */
int pmu_pull_off_ps_hold(void)
{
	return zx234290_ps_hold_pull_off();
}

/* ================================================================================
 *  pmu_init:
 */
int pmu_pull_on_ps_hold(void)
{
	return zx234290_ps_hold_pull_on();
}

/* ================================================================================
 *  system_power_off:
 */
void system_power_off(void)
{
    zx234290_power_off();
}

int zx234290_get_adc2_voltage(void)
{
    int nTempAdc = 0, ret = -1;
    int adcReadInt = -1;
    int msb=0, lsb=0;
	int num;
	uchar status_a=0;
    uchar adcEnable = 0x28;
	uchar sys_ctrl;

    ret = zx234290_i2c_read_reg(ZX234290_REG_SYS_CTRL, &sys_ctrl);
	if (ret != SUCCESS)
	{
		return -EIO;
	}
	sys_ctrl = (sys_ctrl & (1 << 7)) | adcEnable;

    /*enable adc*/
#if 0
    ret = zx234290_i2c_write_reg(ZX234290_REG_SYS_CTRL,&sys_ctrl);
    if (ret != SUCCESS)
    {
        return -EIO;
    }
#else
	for(num=1; num <= 50; num++)
	{
		ret = zx234290_i2c_write_reg(ZX234290_REG_SYS_CTRL, &sys_ctrl);
		if (ret != SUCCESS)
		{
			return -EIO;
		}
		udelay((100000/3000)*5); /* delay 5ms */
		ret = zx234290_i2c_read_reg(ZX234290_REG_ADDR_STSA, &status_a);
	    if (ret != SUCCESS)
	    {
	        return -EIO;
	    }

		if(status_a & 0x04)
		{
			printf( "adc2 get adc,break num =%d ...\n", num);
			break;
		}
	}
#endif
	udelay((100000/3000)*20); /* delay 20ms */

    /*read adc*/
    ret = zx234290_i2c_read_reg(ZX234290_REG_ADC_ADC2MSB, &msb);
    if (ret != SUCCESS)
    {
        return -EIO;
    }
    ret = zx234290_i2c_read_reg(ZX234290_REG_ADC_ADC2LSB, &lsb);
    if (ret != SUCCESS)
    {
        return -EIO;
    }

    /*clear int*/
    ret = zx234290_i2c_read_reg(ZX234290_REG_INTA, &adcReadInt);
    if (ret != SUCCESS)
    {
        return -EIO;
    }
    ret =zx234290_i2c_read_reg(ZX234290_REG_INTB, &adcReadInt);
    if (ret != SUCCESS)
    {
        return -EIO;
    }

    nTempAdc = ((msb<<4)|(lsb>>4));

    nTempAdc = (int)((double)(5000-0)*(nTempAdc)/4096);

    return nTempAdc;
}

int zx234290_get_adc1_voltage(void)   /*read adc1*/
{
    int nTempAdc = 0,adcEnable = 0,ret = -1;
    int adcReadInt = -1;
    int msb=0, lsb=0;
	int num;
	uchar status_a=0;
    adcEnable = 0x30;   /*read adc1*/
	uchar sys_ctrl;

    ret = zx234290_i2c_read_reg(ZX234290_REG_SYS_CTRL, &sys_ctrl);
	if (ret != SUCCESS)
	{
		return -EIO;
	}
	sys_ctrl = (sys_ctrl & (1 << 7)) | adcEnable;

    /*enable adc*/
#if 0
    ret = zx234290_i2c_write_reg(ZX234290_REG_SYS_CTRL,&sys_ctrl);
    if (ret != SUCCESS)
    {
        return -EIO;
    }
#else
	for(num=1; num <= 50; num++)
	{
		ret = zx234290_i2c_write_reg(ZX234290_REG_SYS_CTRL, &sys_ctrl);
		if (ret != SUCCESS)
		{
			return -EIO;
		}
		udelay((100000/3000)*5); /* delay 5ms */
		ret = zx234290_i2c_read_reg(ZX234290_REG_ADDR_STSA, &status_a);
	    if (ret != SUCCESS)
	    {
	        return -EIO;
	    }
		if(status_a & 0x04)
		{
			printf( "adc1 get adc,break num =%d ...\n", num);
			break;
		}
	}
#endif

    udelay((100000/3000)*20); /* delay 20ms */

    /*read adc*/
    ret = zx234290_i2c_read_reg(ZX234290_REG_ADC_ADC1MSB, &msb);
    if (ret != SUCCESS)
    {
        return -EIO;
    }
    ret = zx234290_i2c_read_reg(ZX234290_REG_ADC_ADC1LSB, &lsb);
    if (ret != SUCCESS)
    {
        return -EIO;
    }

    /*clear int*/
    ret = zx234290_i2c_read_reg(ZX234290_REG_INTA, &adcReadInt);
    if (ret != SUCCESS)
    {
        return -EIO;
    }
    ret =zx234290_i2c_read_reg(ZX234290_REG_INTB, &adcReadInt);
    if (ret != SUCCESS)
    {
        return -EIO;
    }

    nTempAdc = ((msb<<4)|(lsb>>4));

    nTempAdc = (int)((double)(5000-0)*(nTempAdc)/4096);

    return nTempAdc;
}

int zx234290_get_vbat_voltage(void)
{
    int nTempAdc = 0,adcEnable = 0,ret = -1;
    int adcReadInt = -1;
    int msb=0, lsb=0;
	int num;
	uchar status_a=0;
    //adcEnable = 0x30;
    adcEnable = 0x20;
	uchar sys_ctrl;

    ret = zx234290_i2c_read_reg(ZX234290_REG_SYS_CTRL, &sys_ctrl);
	if (ret != SUCCESS)
	{
		return -EIO;
	}
	sys_ctrl = (sys_ctrl & (1 << 7)) | adcEnable;

#if 0
    ret = zx234290_i2c_write_reg(ZX234290_REG_SYS_CTRL,&sys_ctrl);
    if (ret != SUCCESS)
    {
        return -EIO;
    }
#else
	for(num=1; num <= 50; num++)
	{
		ret = zx234290_i2c_write_reg(ZX234290_REG_SYS_CTRL, &sys_ctrl);
		if (ret != SUCCESS)
		{
			return -EIO;
		}
		udelay((100000/3000)*5); /* delay 5ms */
		ret = zx234290_i2c_read_reg(ZX234290_REG_ADDR_STSA, &status_a);
	    if (ret != SUCCESS)
	    {
	        return -EIO;
	    }
		if(status_a & 0x04)
		{
			printf( "vbat get adc,break num =%d ...\n", num);
			break;
		}
	}
#endif
    //ret = zx234290_i2c_read_reg(ZX234290_REG_ADC_ADC1MSB, &msb);
    ret = zx234290_i2c_read_reg(ZX234290_REG_ADC_VBATMSB, &msb);
    if (ret != SUCCESS)
    {
        return -EIO;
    }
    //ret = zx234290_i2c_read_reg(ZX234290_REG_ADC_ADC1LSB, &lsb);
    ret = zx234290_i2c_read_reg(ZX234290_REG_ADC_VBATLSB, &lsb);
    if (ret != SUCCESS)
    {
        return -EIO;
    }
    ret = zx234290_i2c_read_reg(ZX234290_REG_INTA, &adcReadInt);
    if (ret != SUCCESS)
    {
        return -EIO;
    }
    ret =zx234290_i2c_read_reg(ZX234290_REG_INTB, &adcReadInt);
    if (ret != SUCCESS)
    {
        return -EIO;
    }
    nTempAdc = ((msb<<4)|(lsb>>4));
    nTempAdc = (int)((double)(5000-0)*(nTempAdc)/4096);
    return nTempAdc;
}

int zx234290_set_llp_enable(void)
{
    int ret = -1;
    ushort reg=ZX234290_REG_ADDR_PWRON;
    uchar val=0x05;

    ret = zx234290_i2c_write_reg(reg, &val);
    if (ret != SUCCESS)
    {
        return -EIO;
    }
    return ret;
}

/*get the poweron key state 0x1<<5: poweron press 0:poweron up*/
int zx234290_get_poweron_state(void)
{
    int val = 0,ret = -1;
	uchar reg = 0;

    ret = zx234290_i2c_read_reg(STATUS_A,&reg);
    if (ret != SUCCESS)
    {
        return -EIO;
    }
    val = reg&STATUS_PWR_ON;
    return val;
}

/* get the rtc_alarm status: bit0 in reg 0x05 */
int zx234290_get_rtc_state(void)
{
    int val = 0,ret = -1;
	uchar reg = 0;

    ret = zx234290_i2c_read_reg(STATUS_B, &reg);
    if (ret != SUCCESS)
    {
        return -EIO;
    }
    val = reg & STATUS_RTC_ALARM;
    return val;
}

/* Set or clear SoftOn bit in ZX234290_REG_SYS_CTRL */
int zx234290_set_softon(int on)
{
	uchar reg = 0;
    int ret;

    ret = zx234290_i2c_read_reg(ZX234290_REG_SYS_CTRL, &reg);
    if (ret != SUCCESS)
    {
        return -EIO;
    }

    if ((reg >> 7) != on) {
        reg ^= (0x01<<7);
        ret = zx234290_i2c_write_reg(ZX234290_REG_SYS_CTRL, &reg);
        if (ret != SUCCESS)
        {
            return -EIO;
        }
    }
    return 0;
}

/*set ldo8 SD VOL*/
int zx234290_set_ldo8_voltage(T_ZDrvZx234290_VldoD vol)
{
	int ret = 0;
	unsigned char  reg_addr=0, reg_val=0;

	if(vol > VLDOD_MAX)
	{
		return -EINVAL;
	}
	reg_addr = ZX234290_REG_ADDR_LDO78_VOL;
	ret = zx234290_i2c_read_reg(reg_addr,&reg_val);
	if (ret != SUCCESS)
	{
		return -EIO;
	}
	reg_val &= ~(0xf<<ZX234290_LDO8_VSEL_LSH);
	reg_val |= (vol<<ZX234290_LDO8_VSEL_LSH);
   
	ret = zx234290_i2c_write_reg(reg_addr, &reg_val);
	if (ret != SUCCESS)
	{
	   return -EIO;
	}
   
	return 0;
}

int zx234290_set_ldo8_sleep_voltage(T_ZDrvZx234290_VldoD vol)
{
	int ret = 0;
	unsigned char  reg_addr=0, reg_val=0;

	if(vol > VLDOD_MAX)
	{
		return -EINVAL;
	}
	reg_addr = ZX234290_REG_ADDR_LDO78_VOL;
	ret = zx234290_i2c_read_reg(reg_addr,&reg_val);
	if (ret != SUCCESS)
	{
		return -EIO;
	}
	reg_val &= ~(0xf<<ZX234290_LDO8_SLP_VSEL_LSH);
	reg_val |= (vol<<ZX234290_LDO8_SLP_VSEL_LSH);
   
	ret = zx234290_i2c_write_reg(reg_addr, &reg_val);
	if (ret != SUCCESS)
	{
	   return -EIO;
	}
   
	return 0;
}


/* clear SoftOn bit in ZX234290_REG_SYS_CTRL bit7 */
int zx234290_ldo8_enable(int enable)
{
    int ret = -1;
	uchar reg = 0;

    ret = zx234290_i2c_read_reg(ZX234290_REG_LDO_EN1, &reg);
    if (ret != SUCCESS)
    {
        return -EIO;
    }
    reg &= ~(0x01<<7);
	reg |= (enable<<7);
    ret = zx234290_i2c_write_reg(ZX234290_REG_LDO_EN1, &reg);
    if (ret != SUCCESS)
    {
        return -EIO;
    }
    return 0;
}
int zx234290_set_sink(T_ZX234290_SINK sink_num, int is_on, T_ZX234297_SINK_CURRENT sink_current)
{
    int ret = 0;
	unsigned char lsh_on, lsh_current;
	uchar reg = 0;
	
	ret = zx234290_i2c_read_reg(ZX234297_REG_ADDR_SINK_CONTROL, &reg);
	if (ret != SUCCESS)
	{
		return -EIO;
	}	
	if(0xff==reg){
		printf("pmu zx234296 no sink\n");
		return SUCCESS;
	}
	if (sink_num == SINK_1) {
		lsh_on = ZX234297_SINK1_ON_LSH;
		lsh_current = ZX234297_SINK1_CURRENT_LSH;
	} else if (sink_num == SINK_2) {
		lsh_on = ZX234297_SINK2_ON_LSH;
		lsh_current = ZX234297_SINK2_CURRENT_LSH;
	} else
		return -EINVAL;

	if (is_on) {
		if (sink_current >= SINK_CURRENT_MAX)
			sink_current = SINK_CURRENT_120MA;
			
		ret = zx234290_i2c_read_reg(ZX234297_REG_ADDR_SINK_CONTROL, &reg);
	    if (ret != SUCCESS)
	    {
	        return -EIO;
	    }
	    reg &= ~(0xf<<lsh_current);
		reg |= (sink_current<<lsh_current);
	    ret = zx234290_i2c_write_reg(ZX234297_REG_ADDR_SINK_CONTROL, &reg);
	    if (ret != SUCCESS)
	    {
	        return -EIO;
	    }
	}

	is_on = !!is_on;
	ret = zx234290_i2c_read_reg(ZX234290_REG_ADDR_LDO_EN2, &reg);
	if (ret != SUCCESS)
	{
		return -EIO;
	}
    reg &= ~(0x1<<lsh_on);
	reg |= (is_on<<lsh_on);
    ret = zx234290_i2c_write_reg(ZX234290_REG_ADDR_LDO_EN2, &reg);
    if (ret != SUCCESS)
    {
        return -EIO;
    }
	
    return 0;
}

#if 0
int zx234290_SetVldo8(Zx234290_VldoD vol)
{
	int reg = 0,val = 0,ret = -1;
	ret = zx234290_i2c_read_reg(ZX234290_REG_LD78_VOL, &reg);
	if (ret != SUCCESS)
	{
		return -EIO;
	}
	BOOT_PRINTF(UBOOT_ERR, "********First  REG0x15=0x%x!!!\n",reg);
	reg &= 0xf;/*00001111*/
	reg |= (vol<<4);
	ret = zx234290_i2c_write_reg(ZX234290_REG_LD78_VOL, &reg);
	if (ret != SUCCESS)
	{
		return -EIO;
	}
	ret = zx234290_i2c_read_reg(ZX234290_REG_LD78_VOL, &reg);
	if (ret != SUCCESS)
	{
		return -EIO;
	}
	BOOT_PRINTF(UBOOT_ERR, "********Last  REG0x15=0x%x!!!\n",reg);
	return 0;
}

#endif


