/*******************************************************************************
 * Copyright (C) 2016, ZIXC Corporation.
 *
 * File Name:cmd_testusb.c
 * File Mark:
 * Description:
 * Others:
 * Version:       1.0
 * Author:        zangxiaofeng
 * Date:          2013-4-22
 * History 1:
 *     Date:
 *     Version:
 *     Author:
 *     Modification:
 * History 2:
  ********************************************************************************/


/****************************************************************************
* 	                                     Include files
****************************************************************************/
#include <common.h>
#include <command.h>
#include <net.h>
#include <jffs2/load_kernel.h>
#include "downloader_nand.h"
#include "downloader_config.h"
#include "errno.h"
/****************************************************************************
*							Global Function Prototypes
****************************************************************************/
extern int downloader_serial_write(const char * buffer,unsigned int len);
extern int downloader_serial_read_actuallen(char * buffer,unsigned int len);

/*******************************************************************************
 * Function:do_reboot
 * Description:
 * Parameters:
 *	 Input:
 *
 *	 Output:
 *
 * Returns:
 *
 *
 * Others:
 ********************************************************************************/
int do_testusb(cmd_tbl_t *cmdtp, int flag, int argc, char * const argv[])
{
    unsigned int size = 0;
    char ack[64] = {0};
    
    if(argc < 2)
    {
        return cmd_usage(cmdtp);
    }
    size = (unsigned int)simple_strtoul (argv[1], NULL, 16);

    sprintf(ack,"DATA %x",size);
    downloader_serial_write(ack, strlen(ack)+1);
    downloader_serial_read_actuallen((char *)DOWNLOADER_BUFFER_BASE, size); 
    sprintf(ack,"OKAY");
    downloader_serial_write(ack, strlen(ack)+1);
    return 0;
}

U_BOOT_CMD(
	testusb, CONFIG_SYS_MAXARGS, 0, do_testusb,
	"testusb: testusb [size]",
	""
);

