/*******************************************************************************
 * Copyright (C) 2014, ZTE Corporation.
 *
 * File Name:    hal_gpioinfo.c
 * File Mark:
 * Description:  gpio information table
 * Others:
 * Version:       1.0
 * Author:        zhangdongdong
 * Date:          2015-07-31
 * History 1:
 *     Date:
 *     Version:
 *     Author:
 *     Modification:
 ********************************************************************************/

/****************************************************************************
*                                              Include files
****************************************************************************/
#include "hal_gpio_v2.h"
#include <drvs_gpio.h>




/****************************************************************************
*                                              Local Macros
****************************************************************************/
/*PIN MUX*/
#define ZX297520V2_PIN_MUX        0x01303000
#define GPIO_PINMUX_REG_BASE ZX297520V2_PIN_MUX

/*PAD*/
#define ZX297520V2_A1_PAD_CTRL0   0x0013C000
#define PAD_CTRL_REG_BASE   ZX297520V2_A1_PAD_CTRL0




#define PD_FUNC_SEL_BASE        (GPIO_PINMUX_REG_BASE)
#define AON_FUNC_SEL_BASE		(PAD_CTRL_REG_BASE)
#define TOP_FUNC_SEL_BASE		(PAD_CTRL_REG_BASE)
#define IO_CFG_BASE				(PAD_CTRL_REG_BASE+0x800)

/****************************************************************************
*                                              Local Types
****************************************************************************/


/****************************************************************************
*                                              Local Constants
****************************************************************************/

/****************************************************************************
*                                              Local Variables
****************************************************************************/

/****************************************************************************
*                                             Global Constants
****************************************************************************/

/****************************************************************************
*                                             Global Variables
****************************************************************************/

/****************************************************************************
*                                             Global Function Prototypes
****************************************************************************/
T_Gpio gGpioInfoTable[] =
{
	[NAND_WE] = {
        .name       = "nand_we",
		.gpio       = GPIO0,
		.flag       = 0,
        .pdFuncSel  = {INVLID_ADDR, INVLID_VALUE, INVLID_VALUE},
        .aonFuncSel = {INVLID_ADDR, INVLID_VALUE, INVLID_VALUE},
        .topFuncSel = {TOP_FUNC_SEL_BASE+0x10, 0, 1},
        .ioCfg      = {IO_CFG_BASE, 0, 2},
    },

	[NAND_CSN] = {
        .name       = "nand_csn",
		.gpio       = GPIO1,
		.flag       = 0,
        .pdFuncSel  = {INVLID_ADDR, INVLID_VALUE, INVLID_VALUE},
        .aonFuncSel = {INVLID_ADDR, INVLID_VALUE, INVLID_VALUE},
        .topFuncSel = {TOP_FUNC_SEL_BASE+0x10, 1, 1},
        .ioCfg      = {IO_CFG_BASE, 2, 2},
    },

	[NAND_READY] = {
        .name       = "nand_ready",
		.gpio       = GPIO2,
		.flag       = 0,
        .pdFuncSel  = {INVLID_ADDR, INVLID_VALUE, INVLID_VALUE},
        .aonFuncSel = {INVLID_ADDR, INVLID_VALUE, INVLID_VALUE},
        .topFuncSel = {TOP_FUNC_SEL_BASE+0x10, 2, 1},
        .ioCfg      = {IO_CFG_BASE, 4, 2},
    },

	[NAND_CLE_] = {
        .name       = "nand_cle",
		.gpio       = GPIO3,
		.flag       = 0,
        .pdFuncSel  = {PD_FUNC_SEL_BASE, 0, 2},
        .aonFuncSel = {INVLID_ADDR, INVLID_VALUE, INVLID_VALUE},
        .topFuncSel = {TOP_FUNC_SEL_BASE+0x10, 3, 1},
        .ioCfg      = {IO_CFG_BASE, 6, 2},
    },

	[NAND_ALE_] = {
        .name       = "nand_ale",
		.gpio       = GPIO4,
		.flag       = 0,
        .pdFuncSel  = {INVLID_ADDR, INVLID_VALUE, INVLID_VALUE},
        .aonFuncSel = {INVLID_ADDR, INVLID_VALUE, INVLID_VALUE},
        .topFuncSel = {TOP_FUNC_SEL_BASE+0x10, 4, 1},
        .ioCfg      = {IO_CFG_BASE, 8, 2},
    },

	[NAND_RE] = {
        .name       = "nand_re",
		.gpio       = GPIO5,
		.flag       = 0,
        .pdFuncSel  = {PD_FUNC_SEL_BASE, 2, 2},
        .aonFuncSel = {INVLID_ADDR, INVLID_VALUE, INVLID_VALUE},
        .topFuncSel = {TOP_FUNC_SEL_BASE+0x10, 5, 1},
        .ioCfg      = {IO_CFG_BASE, 10, 2},
    },

	[NAND_WP] = {
        .name       = "nand_wp",
		.gpio       = GPIO6,
		.flag       = 0,
        .pdFuncSel  = {INVLID_ADDR, INVLID_VALUE, INVLID_VALUE},
        .aonFuncSel = {INVLID_ADDR, INVLID_VALUE, INVLID_VALUE},
        .topFuncSel = {TOP_FUNC_SEL_BASE+0x10, 6, 1},
        .ioCfg      = {IO_CFG_BASE, 12, 2},
    },

	[NAND_DATA0] = {
        .name       = "nand_data0",
		.gpio       = GPIO7,
		.flag       = 0,
        .pdFuncSel  = {PD_FUNC_SEL_BASE+0x8, 0, 2},
        .aonFuncSel = {INVLID_ADDR, INVLID_VALUE, INVLID_VALUE},
        .topFuncSel = {TOP_FUNC_SEL_BASE+0x10, 7, 1},
        .ioCfg      = {IO_CFG_BASE, 14, 2},
    },

	[NAND_DATA1] = {
        .name       = "nand_data1",
		.gpio       = GPIO8,
		.flag       = 0,
        .pdFuncSel  = {PD_FUNC_SEL_BASE+0x8, 2, 2},
        .aonFuncSel = {INVLID_ADDR, INVLID_VALUE, INVLID_VALUE},
        .topFuncSel = {TOP_FUNC_SEL_BASE+0x10, 8, 1},
        .ioCfg      = {IO_CFG_BASE, 16, 2},
    },

	[NAND_DATA2] = {
        .name       = "nand_data2",
		.gpio       = GPIO9,
		.flag       = 0,
        .pdFuncSel  = {PD_FUNC_SEL_BASE+0x0, 4, 2},
        .aonFuncSel = {INVLID_ADDR, INVLID_VALUE, INVLID_VALUE},
        .topFuncSel = {TOP_FUNC_SEL_BASE+0x10, 9, 1},
        .ioCfg      = {IO_CFG_BASE, 18, 2},
    },

	[NAND_DATA3] = {
        .name       = "nand_data3",
		.gpio       = GPIO10,
		.flag       = 0,
        .pdFuncSel  = {PD_FUNC_SEL_BASE+0x0, 6, 2},
        .aonFuncSel = {INVLID_ADDR, INVLID_VALUE, INVLID_VALUE},
        .topFuncSel = {TOP_FUNC_SEL_BASE+0x10, 10, 1},
        .ioCfg      = {IO_CFG_BASE, 20, 2},
    },

	[NAND_DATA4] = {
        .name       = "nand_data4",
		.gpio       = GPIO11,
		.flag       = 0,
        .pdFuncSel  = {PD_FUNC_SEL_BASE+0x0, 8, 2},
        .aonFuncSel = {INVLID_ADDR, INVLID_VALUE, INVLID_VALUE},
        .topFuncSel = {TOP_FUNC_SEL_BASE+0x10, 11, 1},
        .ioCfg      = {IO_CFG_BASE, 22, 2},
    },

	[NAND_DATA5] = {
        .name       = "nand_data5",
		.gpio       = GPIO12,
		.flag       = 0,
        .pdFuncSel  = {PD_FUNC_SEL_BASE+0x0, 10, 2},
        .aonFuncSel = {INVLID_ADDR, INVLID_VALUE, INVLID_VALUE},
        .topFuncSel = {TOP_FUNC_SEL_BASE+0x10, 12, 1},
        .ioCfg      = {IO_CFG_BASE, 24, 2},
    },

	[NAND_DATA6] = {
        .name       = "nand_data6",
		.gpio       = GPIO13,
		.flag       = 0,
        .pdFuncSel  = {PD_FUNC_SEL_BASE+0x8, 4, 2},
        .aonFuncSel = {INVLID_ADDR, INVLID_VALUE, INVLID_VALUE},
        .topFuncSel = {TOP_FUNC_SEL_BASE+0x10, 13, 1},
        .ioCfg      = {IO_CFG_BASE, 26, 2},
    },

	[NAND_DATA7] = {
        .name       = "nand_data7",
		.gpio       = GPIO14,
		.flag       = 0,
        .pdFuncSel  = {PD_FUNC_SEL_BASE+0x8, 6, 2},
        .aonFuncSel = {INVLID_ADDR, INVLID_VALUE, INVLID_VALUE},
        .topFuncSel = {TOP_FUNC_SEL_BASE+0x10, 14, 1},
        .ioCfg      = {IO_CFG_BASE, 28, 2},
    },

	[CLK_OUT0] = {
        .name       = "clk_out0",
		.gpio       = GPIO23,
		.flag       = 0,
        .pdFuncSel  = {INVLID_ADDR, INVLID_VALUE, INVLID_VALUE},
        .aonFuncSel = {AON_FUNC_SEL_BASE, 0, 2},
        .topFuncSel = {INVLID_ADDR, INVLID_VALUE, INVLID_VALUE},
        .ioCfg      = {IO_CFG_BASE+0x4, 4, 2},
    },

	[CLK_OUT1] = {
        .name       = "clk_out1",
		.gpio       = GPIO24,
		.flag       = 0,
        .pdFuncSel  = {INVLID_ADDR, INVLID_VALUE, INVLID_VALUE},
        .aonFuncSel = {AON_FUNC_SEL_BASE, 2, 2},
        .topFuncSel = {INVLID_ADDR, INVLID_VALUE, INVLID_VALUE},
        .ioCfg      = {IO_CFG_BASE+0x4, 6, 2},
    },

	[CLK_OUT2] = {
        .name       = "clk_out2",
		.gpio       = GPIO25,
		.flag       = 0,
        .pdFuncSel  = {INVLID_ADDR, INVLID_VALUE, INVLID_VALUE},
        .aonFuncSel = {AON_FUNC_SEL_BASE, 4, 2},
        .topFuncSel = {INVLID_ADDR, INVLID_VALUE, INVLID_VALUE},
        .ioCfg      = {IO_CFG_BASE+0x4, 8, 2},
    },

	[CLK_32K_OUT] = {
        .name       = "clk_32k_out",
		.gpio       = GPIO26,
		.flag       = 0,
        .pdFuncSel  = {INVLID_ADDR, INVLID_VALUE, INVLID_VALUE},
        .aonFuncSel = {AON_FUNC_SEL_BASE, 6, 2},
        .topFuncSel = {INVLID_ADDR, INVLID_VALUE, INVLID_VALUE},
        .ioCfg      = {IO_CFG_BASE+0x4, 10, 2},
    },

	[CLK_REQ0] = {
        .name       = "clk_req0",
		.gpio       = GPIO27,
		.flag       = 0,
        .pdFuncSel  = {INVLID_ADDR, INVLID_VALUE, INVLID_VALUE},
        .aonFuncSel = {AON_FUNC_SEL_BASE, 8, 2},
        .topFuncSel = {INVLID_ADDR, INVLID_VALUE, INVLID_VALUE},
        .ioCfg      = {IO_CFG_BASE+0x4, 12, 2},
    },

	[PWR_CTRL1] = {
        .name       = "pwr_ctrl1",
		.gpio       = GPIO29,
		.flag       = 0,
        .pdFuncSel  = {INVLID_ADDR, INVLID_VALUE, INVLID_VALUE},
        .aonFuncSel = {AON_FUNC_SEL_BASE, 10, 2},
        .topFuncSel = {INVLID_ADDR, INVLID_VALUE, INVLID_VALUE},
        .ioCfg      = {IO_CFG_BASE+0x8, 0, 2},
    },

	[SSP0_CS] = {
        .name       = "ssp0_cs",
		.gpio       = GPIO30,
		.flag       = 0,
        .pdFuncSel  = {INVLID_ADDR, INVLID_VALUE, INVLID_VALUE},
        .aonFuncSel = {INVLID_ADDR, INVLID_VALUE, INVLID_VALUE},
        .topFuncSel = {TOP_FUNC_SEL_BASE+0x10, 15, 1},
        .ioCfg      = {IO_CFG_BASE+0x8, 2, 2},
    },

	[SSP0_CLK] = {
        .name       = "ssp0_clk",
		.gpio       = GPIO31,
		.flag       = 0,
        .pdFuncSel  = {INVLID_ADDR, INVLID_VALUE, INVLID_VALUE},
        .aonFuncSel = {INVLID_ADDR, INVLID_VALUE, INVLID_VALUE},
        .topFuncSel = {TOP_FUNC_SEL_BASE+0x10, 16, 1},
        .ioCfg      = {IO_CFG_BASE+0x8, 4, 2},
    },

	[SSP0_RXD] = {
        .name       = "ssp0_rxd",
		.gpio       = GPIO32,
		.flag       = 0,
        .pdFuncSel  = {INVLID_ADDR, INVLID_VALUE, INVLID_VALUE},
        .aonFuncSel = {INVLID_ADDR, INVLID_VALUE, INVLID_VALUE},
        .topFuncSel = {TOP_FUNC_SEL_BASE+0x10, 17, 1},
        .ioCfg      = {IO_CFG_BASE+0x8, 6, 2},
    },

	[SSP0_TXD] = {
        .name       = "ssp0_txd",
		.gpio       = GPIO33,
		.flag       = 0,
        .pdFuncSel  = {INVLID_ADDR, INVLID_VALUE, INVLID_VALUE},
        .aonFuncSel = {INVLID_ADDR, INVLID_VALUE, INVLID_VALUE},
        .topFuncSel = {TOP_FUNC_SEL_BASE+0x10, 18, 1},
        .ioCfg      = {IO_CFG_BASE+0x8, 8, 2},
    },

	[UART0_RXD] = {
        .name       = "uart0_rxd",
		.gpio       = GPIO34,
		.flag       = 0,
        .pdFuncSel  = {PD_FUNC_SEL_BASE+0x4, 0, 2},
        .aonFuncSel = {AON_FUNC_SEL_BASE, 12, 2},
        .topFuncSel = {TOP_FUNC_SEL_BASE+0x10, 19, 1},
        .ioCfg      = {IO_CFG_BASE+0x8, 14, 2},
    },

	[UART0_TXD] = {
        .name       = "uart0_txd",
		.gpio       = GPIO35,
		.flag       = 0,
        .pdFuncSel  = {PD_FUNC_SEL_BASE+0x4, 2, 2},
        .aonFuncSel = {AON_FUNC_SEL_BASE, 14, 2},
        .topFuncSel = {TOP_FUNC_SEL_BASE+0x10, 20, 1},
        .ioCfg      = {IO_CFG_BASE+0x8, 16, 2},
    },

	[UART0_CTS] = {
        .name       = "uart0_cts",
		.gpio       = GPIO36,
		.flag       = 0,
        .pdFuncSel  = {PD_FUNC_SEL_BASE+0x4, 4, 2},
        .aonFuncSel = {AON_FUNC_SEL_BASE, 16, 2},
        .topFuncSel = {TOP_FUNC_SEL_BASE+0x10, 21, 1},
        .ioCfg      = {IO_CFG_BASE+0x8, 18, 2},
    },

	[UART0_RTS] = {
        .name       = "uart0_rts",
		.gpio       = GPIO37,
		.flag       = 0,
        .pdFuncSel  = {PD_FUNC_SEL_BASE+0x4, 6, 2},
        .aonFuncSel = {AON_FUNC_SEL_BASE, 18, 2},
        .topFuncSel = {TOP_FUNC_SEL_BASE+0x14, 0, 1},
        .ioCfg      = {IO_CFG_BASE+0x8, 20, 2},
    },

	[I2S0_WS] = {
        .name       = "i2s0_ws",
		.gpio       = GPIO38,
		.flag       = 0,
        .pdFuncSel  = {PD_FUNC_SEL_BASE+0x4, 8, 2},
        .aonFuncSel = {INVLID_ADDR, INVLID_VALUE, INVLID_VALUE},
        .topFuncSel = {TOP_FUNC_SEL_BASE+0x14, 1, 1},
        .ioCfg      = {IO_CFG_BASE+0x8, 22, 2},
    },

	[I2S0_CLK] = {
        .name       = "i2s0_clk",
		.gpio       = GPIO39,
		.flag       = 0,
        .pdFuncSel  = {PD_FUNC_SEL_BASE+0x4, 10, 2},
        .aonFuncSel = {INVLID_ADDR, INVLID_VALUE, INVLID_VALUE},
        .topFuncSel = {TOP_FUNC_SEL_BASE+0x14, 2, 1},
        .ioCfg      = {IO_CFG_BASE+0x8, 24, 2},
    },

	[I2S0_DIN] = {
        .name       = "i2s0_din",
		.gpio       = GPIO40,
		.flag       = 0,
        .pdFuncSel  = {PD_FUNC_SEL_BASE+0x4, 12, 2},
        .aonFuncSel = {INVLID_ADDR, INVLID_VALUE, INVLID_VALUE},
        .topFuncSel = {TOP_FUNC_SEL_BASE+0x14, 3, 1},
        .ioCfg      = {IO_CFG_BASE+0x8, 26, 2},
    },
	
	[I2S0_DOUT] = {
        .name       = "i2s0_dout",
		.gpio       = GPIO41,
		.flag       = 0,
        .pdFuncSel  = {PD_FUNC_SEL_BASE+0x4, 14, 2},
        .aonFuncSel = {INVLID_ADDR, INVLID_VALUE, INVLID_VALUE},
        .topFuncSel = {TOP_FUNC_SEL_BASE+0x14, 4, 1},
        .ioCfg      = {IO_CFG_BASE+0x8, 28, 2},
    },

	[I2S1_WS] = {
        .name       = "i2s1_ws",
		.gpio       = GPIO42,
		.flag       = 0,
        .pdFuncSel  = {PD_FUNC_SEL_BASE+0x4, 16, 2},
        .aonFuncSel = {INVLID_ADDR, INVLID_VALUE, INVLID_VALUE},
        .topFuncSel = {TOP_FUNC_SEL_BASE+0x14, 5, 1},
        .ioCfg      = {IO_CFG_BASE+0x8, 30, 2},
    },

	[I2S1_CLK] = {
        .name       = "i2s1_clk",
		.gpio       = GPIO43,
		.flag       = 0,
        .pdFuncSel  = {PD_FUNC_SEL_BASE+0x4, 18, 2},
        .aonFuncSel = {INVLID_ADDR, INVLID_VALUE, INVLID_VALUE},
        .topFuncSel = {TOP_FUNC_SEL_BASE+0x14, 6, 1},
        .ioCfg      = {IO_CFG_BASE+0xc, 0, 2},
    },

	[I2S1_DIN] = {
        .name       = "i2s1_din",
		.gpio       = GPIO44,
		.flag       = 0,
        .pdFuncSel  = {PD_FUNC_SEL_BASE+0x4, 20, 2},
        .aonFuncSel = {INVLID_ADDR, INVLID_VALUE, INVLID_VALUE},
        .topFuncSel = {TOP_FUNC_SEL_BASE+0x14, 7, 1},
        .ioCfg      = {IO_CFG_BASE+0xc, 2, 2},
    },
	
	[I2S1_DOUT] = {
        .name       = "i2s1_dout",
		.gpio       = GPIO45,
		.flag       = 0,
        .pdFuncSel  = {PD_FUNC_SEL_BASE+0x4, 22, 2},
        .aonFuncSel = {INVLID_ADDR, INVLID_VALUE, INVLID_VALUE},
        .topFuncSel = {TOP_FUNC_SEL_BASE+0x14, 8, 1},
        .ioCfg      = {IO_CFG_BASE+0xc, 4, 2},
    },

	[SCL0] = {
        .name       = "scl0",
		.gpio       = GPIO46,
		.flag       = 0,
        .pdFuncSel  = {INVLID_ADDR, INVLID_VALUE, INVLID_VALUE},
        .aonFuncSel = {AON_FUNC_SEL_BASE+0x4, 0, 2},
        .topFuncSel = {INVLID_ADDR, INVLID_VALUE, INVLID_VALUE},
        .ioCfg      = {IO_CFG_BASE+0xc, 6, 2},
    },
		
	[SDA0] = {
        .name       = "sda0",
		.gpio       = GPIO47,
		.flag       = 0,
        .pdFuncSel  = {INVLID_ADDR, INVLID_VALUE, INVLID_VALUE},
        .aonFuncSel = {AON_FUNC_SEL_BASE+0x4, 2, 2},
        .topFuncSel = {INVLID_ADDR, INVLID_VALUE, INVLID_VALUE},
        .ioCfg      = {IO_CFG_BASE+0xc, 8, 2},
    },

	[SCL1] = {
        .name       = "scl1",
		.gpio       = GPIO48,
		.flag       = 0,
        .pdFuncSel  = {INVLID_ADDR, INVLID_VALUE, INVLID_VALUE},
        .aonFuncSel = {INVLID_ADDR, INVLID_VALUE, INVLID_VALUE},
        .topFuncSel = {TOP_FUNC_SEL_BASE+0x14, 9, 1},
        .ioCfg      = {IO_CFG_BASE+0xc, 10, 2},
    },
		
	[SDA1] = {
        .name       = "sda1",
		.gpio       = GPIO49,
		.flag       = 0,
        .pdFuncSel  = {INVLID_ADDR, INVLID_VALUE, INVLID_VALUE},
        .aonFuncSel = {INVLID_ADDR, INVLID_VALUE, INVLID_VALUE},
        .topFuncSel = {TOP_FUNC_SEL_BASE+0x14, 10, 1},
        .ioCfg      = {IO_CFG_BASE+0xc, 12, 2},
    },

	[EXT_INT0] = {
        .name       = "ext_int0",
		.gpio       = GPIO50,
		.flag       = 0,
        .pdFuncSel  = {INVLID_ADDR, INVLID_VALUE, INVLID_VALUE},
        .aonFuncSel = {AON_FUNC_SEL_BASE+0x4, 4, 2},
        .topFuncSel = {TOP_FUNC_SEL_BASE+0x14, 11, 1},
        .ioCfg      = {IO_CFG_BASE+0xc, 14, 2},
    },

	[EXT_INT1] = {
        .name       = "ext_int1",
		.gpio       = GPIO51,
		.flag       = 0,
        .pdFuncSel  = {INVLID_ADDR, INVLID_VALUE, INVLID_VALUE},
        .aonFuncSel = {AON_FUNC_SEL_BASE+0x4, 6, 2},
        .topFuncSel = {TOP_FUNC_SEL_BASE+0x14, 12, 1},
        .ioCfg      = {IO_CFG_BASE+0xc, 16, 2},
    },

	[EXT_INT2] = {
        .name       = "ext_int2",
		.gpio       = GPIO52,
		.flag       = 0,
        .pdFuncSel  = {INVLID_ADDR, INVLID_VALUE, INVLID_VALUE},
        .aonFuncSel = {AON_FUNC_SEL_BASE+0x4, 8, 2},
        .topFuncSel = {TOP_FUNC_SEL_BASE+0x14, 13, 1},
        .ioCfg      = {IO_CFG_BASE+0xc, 18, 2},
    },

	[EXT_INT3] = {
        .name       = "ext_int3",
		.gpio       = GPIO53,
		.flag       = 0,
        .pdFuncSel  = {INVLID_ADDR, INVLID_VALUE, INVLID_VALUE},
        .aonFuncSel = {AON_FUNC_SEL_BASE+0x4, 10, 2},
        .topFuncSel = {TOP_FUNC_SEL_BASE+0x14, 14, 1},
        .ioCfg      = {IO_CFG_BASE+0xc, 20, 2},
    },

	[EXT_INT4] = {
        .name       = "ext_int4",
		.gpio       = GPIO54,
		.flag       = 0,
        .pdFuncSel  = {INVLID_ADDR, INVLID_VALUE, INVLID_VALUE},
        .aonFuncSel = {AON_FUNC_SEL_BASE+0x4, 12, 2},
        .topFuncSel = {TOP_FUNC_SEL_BASE+0x14, 15, 1},
        .ioCfg      = {IO_CFG_BASE+0xc, 22, 2},
    },

	[EXT_INT5] = {
        .name       = "ext_int5",
		.gpio       = GPIO55,
		.flag       = 0,
        .pdFuncSel  = {INVLID_ADDR, INVLID_VALUE, INVLID_VALUE},
        .aonFuncSel = {AON_FUNC_SEL_BASE+0x4, 14, 2},
        .topFuncSel = {TOP_FUNC_SEL_BASE+0x14, 16, 1},
        .ioCfg      = {IO_CFG_BASE+0xc, 24, 2},
    },

	[EXT_INT6] = {
        .name       = "ext_int6",
		.gpio       = GPIO56,
		.flag       = 0,
        .pdFuncSel  = {INVLID_ADDR, INVLID_VALUE, INVLID_VALUE},
        .aonFuncSel = {AON_FUNC_SEL_BASE+0x4, 16, 2},
        .topFuncSel = {TOP_FUNC_SEL_BASE+0x14, 17, 1},
        .ioCfg      = {IO_CFG_BASE+0xc, 26, 2},
    },

	[EXT_INT7] = {
        .name       = "ext_int7",
		.gpio       = GPIO57,
		.flag       = 0,
        .pdFuncSel  = {INVLID_ADDR, INVLID_VALUE, INVLID_VALUE},
        .aonFuncSel = {AON_FUNC_SEL_BASE+0x4, 18, 2},
        .topFuncSel = {TOP_FUNC_SEL_BASE+0x14, 18, 1},
        .ioCfg      = {IO_CFG_BASE+0xc, 28, 2},
    },

	[SD1_CLK] = {
        .name       = "sd1_clk",
		.gpio       = GPIO58,
		.flag       = 0,
        .pdFuncSel  = {INVLID_ADDR, INVLID_VALUE, INVLID_VALUE},
        .aonFuncSel = {INVLID_ADDR, INVLID_VALUE, INVLID_VALUE},
        .topFuncSel = {TOP_FUNC_SEL_BASE+0x14, 19, 1},
        .ioCfg      = {IO_CFG_BASE+0x10, 0, 8},
    },

	[SD1_CMD] = {
        .name       = "sd1_cmd",
		.gpio       = GPIO59,
		.flag       = 0,
        .pdFuncSel  = {PD_FUNC_SEL_BASE+0x8, 8, 2},
        .aonFuncSel = {AON_FUNC_SEL_BASE+0x4, 20, 2},
        .topFuncSel = {TOP_FUNC_SEL_BASE+0x14, 20, 1},
        .ioCfg      = {IO_CFG_BASE+0x10, 8, 8},
    },

	[SD1_DATA0] = {
        .name       = "sd1_data0",
		.gpio       = GPIO60,
		.flag       = 0,
        .pdFuncSel  = {PD_FUNC_SEL_BASE+0x8, 10, 2},
        .aonFuncSel = {AON_FUNC_SEL_BASE+0x4, 22, 2},
        .topFuncSel = {TOP_FUNC_SEL_BASE+0x14, 21, 1},
        .ioCfg      = {IO_CFG_BASE+0x10, 16, 8},
    },

	[SD1_DATA1] = {
        .name       = "sd1_data1",
		.gpio       = GPIO61,
		.flag       = 0,
        .pdFuncSel  = {PD_FUNC_SEL_BASE+0x8, 12, 2},
        .aonFuncSel = {AON_FUNC_SEL_BASE+0x4, 24, 2},
        .topFuncSel = {TOP_FUNC_SEL_BASE+0x14, 22, 1},
        .ioCfg      = {IO_CFG_BASE+0x10, 24, 8},
    },

	[SD1_DATA2] = {
        .name       = "sd1_data2",
		.gpio       = GPIO62,
		.flag       = 0,
        .pdFuncSel  = {PD_FUNC_SEL_BASE+0x8, 14, 2},
        .aonFuncSel = {AON_FUNC_SEL_BASE+0x4, 26, 2},
        .topFuncSel = {TOP_FUNC_SEL_BASE+0x14, 23, 1},
        .ioCfg      = {IO_CFG_BASE+0x14, 0, 8},
    },

	[SD1_DATA3] = {
        .name       = "sd1_data3",
		.gpio       = GPIO63,
		.flag       = 0,
        .pdFuncSel  = {PD_FUNC_SEL_BASE+0x8, 16, 2},
        .aonFuncSel = {AON_FUNC_SEL_BASE+0x4, 28, 2},
        .topFuncSel = {TOP_FUNC_SEL_BASE+0x14, 24, 1},
        .ioCfg      = {IO_CFG_BASE+0x14, 8, 8},
    },

	[JTAG_TCK] = {
        .name       = "jtag_tck",
		.gpio       = GPIO64,
		.flag       = 0,
        .pdFuncSel  = {PD_FUNC_SEL_BASE+0xc, 0, 2},
        .aonFuncSel = {AON_FUNC_SEL_BASE+0x8, 0, 2},
        .topFuncSel = {TOP_FUNC_SEL_BASE+0x14, 25, 1},
        .ioCfg      = {IO_CFG_BASE+0x1c, 0, 2},
    },

	[JTAG_TDI] = {
        .name       = "jtag_tdi",
		.gpio       = GPIO66,
		.flag       = 0,
        .pdFuncSel  = {PD_FUNC_SEL_BASE+0xc, 2, 2},
        .aonFuncSel = {AON_FUNC_SEL_BASE+0x8, 2, 2},
        .topFuncSel = {TOP_FUNC_SEL_BASE+0x14, 26, 1},
        .ioCfg      = {IO_CFG_BASE+0x1c, 2, 2},
    },

	[JTAG_TDO] = {
        .name       = "jtag_tdo",
		.gpio       = GPIO67,
		.flag       = 0,
        .pdFuncSel  = {PD_FUNC_SEL_BASE+0xc, 4, 2},
        .aonFuncSel = {AON_FUNC_SEL_BASE+0x8, 4, 2},
        .topFuncSel = {TOP_FUNC_SEL_BASE+0x14, 27, 1},
        .ioCfg      = {IO_CFG_BASE+0x1c, 4, 2},
    },

	[JTAG_TMS] = {
        .name       = "jtag_tms",
		.gpio       = GPIO68,
		.flag       = 0,
        .pdFuncSel  = {PD_FUNC_SEL_BASE+0xc, 6, 2},
        .aonFuncSel = {AON_FUNC_SEL_BASE+0x8, 6, 2},
        .topFuncSel = {TOP_FUNC_SEL_BASE+0x14, 28, 1},
        .ioCfg      = {IO_CFG_BASE+0x1c, 6, 2},
    },

	[JTAG_TRST] = {
        .name       = "jtag_trst",
		.gpio       = GPIO69,
		.flag       = 0,
        .pdFuncSel  = {PD_FUNC_SEL_BASE+0xc, 8, 2},
        .aonFuncSel = {AON_FUNC_SEL_BASE+0x8, 8, 2},
        .topFuncSel = {TOP_FUNC_SEL_BASE+0x14, 29, 1},
        .ioCfg      = {IO_CFG_BASE+0x1c, 8, 2},
    },

	[KBC_0] = {
        .name       = "kbc_0",
		.gpio       = GPIO70,
		.flag       = 0,
        .pdFuncSel  = {PD_FUNC_SEL_BASE+0x10, 0, 2},
        .aonFuncSel = {AON_FUNC_SEL_BASE+0xc, 0, 2},
        .topFuncSel = {TOP_FUNC_SEL_BASE+0x14, 30, 1},
        .ioCfg      = {IO_CFG_BASE+0x1c, 10, 2},
    },

	[KBC_1] = {
        .name       = "kbc_1",
		.gpio       = GPIO71,
		.flag       = 0,
        .pdFuncSel  = {INVLID_ADDR, INVLID_VALUE, INVLID_VALUE},
        .aonFuncSel = {AON_FUNC_SEL_BASE+0xc, 2, 2},
        .topFuncSel = {TOP_FUNC_SEL_BASE+0x14, 31, 1},
        .ioCfg      = {IO_CFG_BASE+0x1c, 12, 2},
    },

	[KBC_2] = {
        .name       = "kbc_2",
		.gpio       = GPIO72,
		.flag       = 0,
        .pdFuncSel  = {PD_FUNC_SEL_BASE+0x10, 2, 2},
        .aonFuncSel = {AON_FUNC_SEL_BASE+0xc, 4, 2},
        .topFuncSel = {TOP_FUNC_SEL_BASE+0x18, 0, 1},
        .ioCfg      = {IO_CFG_BASE+0x1c, 14, 2},
    },

	[KBC_3] = {
        .name       = "kbc_3",
		.gpio       = GPIO73,
		.flag       = 0,
        .pdFuncSel  = {PD_FUNC_SEL_BASE+0x10, 4, 2},
        .aonFuncSel = {AON_FUNC_SEL_BASE+0xc, 6, 2},
        .topFuncSel = {TOP_FUNC_SEL_BASE+0x18, 1, 1},
        .ioCfg      = {IO_CFG_BASE+0x1c, 16, 2},
    },

	[KBR_0] = {
        .name       = "kbr_0",
		.gpio       = GPIO74,
		.flag       = 0,
        .pdFuncSel  = {PD_FUNC_SEL_BASE+0x10, 6, 2},
        .aonFuncSel = {AON_FUNC_SEL_BASE+0xc, 8, 2},
        .topFuncSel = {TOP_FUNC_SEL_BASE+0x18, 2, 1},
        .ioCfg      = {IO_CFG_BASE+0x1c, 18, 2},
    },

	[KBR_1] = {
        .name       = "kbr_1",
		.gpio       = GPIO75,
		.flag       = 0,
        .pdFuncSel  = {PD_FUNC_SEL_BASE+0x10, 8, 2},
        .aonFuncSel = {AON_FUNC_SEL_BASE+0xc, 10, 2},
        .topFuncSel = {TOP_FUNC_SEL_BASE+0x18, 3, 1},
        .ioCfg      = {IO_CFG_BASE+0x1c, 20, 2},
    },

	[KBR_2] = {
        .name       = "kbr_2",
		.gpio       = GPIO76,
		.flag       = 0,
        .pdFuncSel  = {PD_FUNC_SEL_BASE+0x10, 10, 2},
        .aonFuncSel = {AON_FUNC_SEL_BASE+0xc, 12, 2},
        .topFuncSel = {TOP_FUNC_SEL_BASE+0x18, 4, 1},
        .ioCfg      = {IO_CFG_BASE+0x1c, 22, 2},
    },

	[KBR_3] = {
        .name       = "kbr_3",
		.gpio       = GPIO77,
		.flag       = 0,
        .pdFuncSel  = {INVLID_ADDR, INVLID_VALUE, INVLID_VALUE},
        .aonFuncSel = {AON_FUNC_SEL_BASE+0xc, 14, 2},
        .topFuncSel = {TOP_FUNC_SEL_BASE+0x18, 5, 1},
        .ioCfg      = {IO_CFG_BASE+0x1c, 24, 2},
    },

	[LTE_TDD_TXRX_DATA0] = {
        .name       = "lte_tdd_txrx_data0",
		.gpio       = GPIO78,
		.flag       = 0,
        .pdFuncSel  = {INVLID_ADDR, INVLID_VALUE, INVLID_VALUE},
        .aonFuncSel = {INVLID_ADDR, INVLID_VALUE, INVLID_VALUE},
        .topFuncSel = {TOP_FUNC_SEL_BASE+0x18, 6, 1},
        .ioCfg      = {IO_CFG_BASE+0x20, 0, 8},
    },

	[LTE_TDD_TXRX_DATA1] = {
        .name       = "lte_tdd_txrx_data1",
		.gpio       = GPIO79,
		.flag       = 0,
        .pdFuncSel  = {INVLID_ADDR, INVLID_VALUE, INVLID_VALUE},
        .aonFuncSel = {INVLID_ADDR, INVLID_VALUE, INVLID_VALUE},
        .topFuncSel = {TOP_FUNC_SEL_BASE+0x18, 7, 1},
        .ioCfg      = {IO_CFG_BASE+0x20, 0, 8},
    },

	[LTE_TDD_TXRX_DATA2] = {
        .name       = "lte_tdd_txrx_data2",
		.gpio       = GPIO80,
		.flag       = 0,
        .pdFuncSel  = {INVLID_ADDR, INVLID_VALUE, INVLID_VALUE},
        .aonFuncSel = {INVLID_ADDR, INVLID_VALUE, INVLID_VALUE},
        .topFuncSel = {TOP_FUNC_SEL_BASE+0x18, 8, 1},
        .ioCfg      = {IO_CFG_BASE+0x20, 0, 8},
    },

	[LTE_TDD_TXRX_DATA3] = {
        .name       = "lte_tdd_txrx_data3",
		.gpio       = GPIO81,
		.flag       = 0,
        .pdFuncSel  = {INVLID_ADDR, INVLID_VALUE, INVLID_VALUE},
        .aonFuncSel = {INVLID_ADDR, INVLID_VALUE, INVLID_VALUE},
        .topFuncSel = {TOP_FUNC_SEL_BASE+0x18, 9, 1},
        .ioCfg      = {IO_CFG_BASE+0x20, 0, 8},
    },

	[LTE_TDD_TXRX_DATA4] = {
        .name       = "lte_tdd_txrx_data4",
		.gpio       = GPIO82,
		.flag       = 0,
        .pdFuncSel  = {INVLID_ADDR, INVLID_VALUE, INVLID_VALUE},
        .aonFuncSel = {INVLID_ADDR, INVLID_VALUE, INVLID_VALUE},
        .topFuncSel = {TOP_FUNC_SEL_BASE+0x18, 10, 1},
        .ioCfg      = {IO_CFG_BASE+0x20, 0, 8},
    },

	[LTE_TDD_TXRX_DATA5] = {
        .name       = "lte_tdd_txrx_data5",
		.gpio       = GPIO83,
		.flag       = 0,
        .pdFuncSel  = {INVLID_ADDR, INVLID_VALUE, INVLID_VALUE},
        .aonFuncSel = {INVLID_ADDR, INVLID_VALUE, INVLID_VALUE},
        .topFuncSel = {TOP_FUNC_SEL_BASE+0x18, 11, 1},
        .ioCfg      = {IO_CFG_BASE+0x20, 0, 8},
    },

	[LTE_TDD_TXRX_DATA6] = {
        .name       = "lte_tdd_txrx_data6",
		.gpio       = GPIO84,
		.flag       = 0,
        .pdFuncSel  = {INVLID_ADDR, INVLID_VALUE, INVLID_VALUE},
        .aonFuncSel = {INVLID_ADDR, INVLID_VALUE, INVLID_VALUE},
        .topFuncSel = {TOP_FUNC_SEL_BASE+0x18, 12, 1},
        .ioCfg      = {IO_CFG_BASE+0x20, 0, 8},
    },

	[LTE_TDD_TXRX_DATA7] = {
        .name       = "lte_tdd_txrx_data7",
		.gpio       = GPIO85,
		.flag       = 0,
        .pdFuncSel  = {INVLID_ADDR, INVLID_VALUE, INVLID_VALUE},
        .aonFuncSel = {INVLID_ADDR, INVLID_VALUE, INVLID_VALUE},
        .topFuncSel = {TOP_FUNC_SEL_BASE+0x18, 13, 1},
        .ioCfg      = {IO_CFG_BASE+0x20, 0, 8},
    },

	[LTE_TDD_TXRX_DATA8] = {
        .name       = "lte_tdd_txrx_data8",
		.gpio       = GPIO86,
		.flag       = 0,
        .pdFuncSel  = {INVLID_ADDR, INVLID_VALUE, INVLID_VALUE},
        .aonFuncSel = {INVLID_ADDR, INVLID_VALUE, INVLID_VALUE},
        .topFuncSel = {TOP_FUNC_SEL_BASE+0x18, 14, 1},
        .ioCfg      = {IO_CFG_BASE+0x20, 0, 8},
    },

	[LTE_TDD_TXRX_DATA9] = {
        .name       = "lte_tdd_txrx_data9",
		.gpio       = GPIO87,
		.flag       = 0,
        .pdFuncSel  = {INVLID_ADDR, INVLID_VALUE, INVLID_VALUE},
        .aonFuncSel = {INVLID_ADDR, INVLID_VALUE, INVLID_VALUE},
        .topFuncSel = {TOP_FUNC_SEL_BASE+0x18, 15, 1},
        .ioCfg      = {IO_CFG_BASE+0x20, 0, 8},
    },

	[LTE_TDD_TXRX_DATA10] = {
        .name       = "lte_tdd_txrx_data10",
		.gpio       = GPIO88,
		.flag       = 0,
        .pdFuncSel  = {INVLID_ADDR, INVLID_VALUE, INVLID_VALUE},
        .aonFuncSel = {INVLID_ADDR, INVLID_VALUE, INVLID_VALUE},
        .topFuncSel = {TOP_FUNC_SEL_BASE+0x18, 16, 1},
        .ioCfg      = {IO_CFG_BASE+0x20, 0, 8},
    },

	[LTE_TDD_TXRX_DATA11] = {
        .name       = "lte_tdd_txrx_data11",
		.gpio       = GPIO89,
		.flag       = 0,
        .pdFuncSel  = {INVLID_ADDR, INVLID_VALUE, INVLID_VALUE},
        .aonFuncSel = {INVLID_ADDR, INVLID_VALUE, INVLID_VALUE},
        .topFuncSel = {TOP_FUNC_SEL_BASE+0x18, 17, 1},
        .ioCfg      = {IO_CFG_BASE+0x20, 0, 8},
    },

	[LTE_TDD_RX_DATA0] = {
        .name       = "lte_tdd_rx_data0",
		.gpio       = GPIO90,
		.flag       = 0,
        .pdFuncSel  = {INVLID_ADDR, INVLID_VALUE, INVLID_VALUE},
        .aonFuncSel = {INVLID_ADDR, INVLID_VALUE, INVLID_VALUE},
        .topFuncSel = {TOP_FUNC_SEL_BASE+0x18, 18, 1},
        .ioCfg      = {IO_CFG_BASE+0x20, 0, 8},
    },

	[LTE_TDD_RX_DATA1] = {
        .name       = "lte_tdd_rx_data1",
		.gpio       = GPIO91,
		.flag       = 0,
        .pdFuncSel  = {INVLID_ADDR, INVLID_VALUE, INVLID_VALUE},
        .aonFuncSel = {INVLID_ADDR, INVLID_VALUE, INVLID_VALUE},
        .topFuncSel = {TOP_FUNC_SEL_BASE+0x18, 19, 1},
        .ioCfg      = {IO_CFG_BASE+0x20, 0, 8},
    },

	[LTE_TDD_RX_DATA2] = {
        .name       = "lte_tdd_rx_data2",
		.gpio       = GPIO92,
		.flag       = 0,
        .pdFuncSel  = {INVLID_ADDR, INVLID_VALUE, INVLID_VALUE},
        .aonFuncSel = {INVLID_ADDR, INVLID_VALUE, INVLID_VALUE},
        .topFuncSel = {TOP_FUNC_SEL_BASE+0x18, 20, 1},
        .ioCfg      = {IO_CFG_BASE+0x20, 0, 8},
    },

	[LTE_TDD_RX_DATA3] = {
        .name       = "lte_tdd_rx_data3",
		.gpio       = GPIO93,
		.flag       = 0,
        .pdFuncSel  = {INVLID_ADDR, INVLID_VALUE, INVLID_VALUE},
        .aonFuncSel = {INVLID_ADDR, INVLID_VALUE, INVLID_VALUE},
        .topFuncSel = {TOP_FUNC_SEL_BASE+0x18, 21, 1},
        .ioCfg      = {IO_CFG_BASE+0x20, 0, 8},
    },

	[LTE_TDD_RX_DATA4] = {
        .name       = "lte_tdd_rx_data4",
		.gpio       = GPIO94,
		.flag       = 0,
        .pdFuncSel  = {INVLID_ADDR, INVLID_VALUE, INVLID_VALUE},
        .aonFuncSel = {INVLID_ADDR, INVLID_VALUE, INVLID_VALUE},
        .topFuncSel = {TOP_FUNC_SEL_BASE+0x18, 22, 1},
        .ioCfg      = {IO_CFG_BASE+0x20, 0, 8},
    },

	[LTE_TDD_RX_DATA5] = {
        .name       = "lte_tdd_rx_data5",
		.gpio       = GPIO95,
		.flag       = 0,
        .pdFuncSel  = {INVLID_ADDR, INVLID_VALUE, INVLID_VALUE},
        .aonFuncSel = {INVLID_ADDR, INVLID_VALUE, INVLID_VALUE},
        .topFuncSel = {TOP_FUNC_SEL_BASE+0x18, 23, 1},
        .ioCfg      = {IO_CFG_BASE+0x20, 0, 8},
    },

	[LTE_TDD_RX_DATA6] = {
        .name       = "lte_tdd_rx_data6",
		.gpio       = GPIO96,
		.flag       = 0,
        .pdFuncSel  = {INVLID_ADDR, INVLID_VALUE, INVLID_VALUE},
        .aonFuncSel = {INVLID_ADDR, INVLID_VALUE, INVLID_VALUE},
        .topFuncSel = {TOP_FUNC_SEL_BASE+0x18, 24, 1},
        .ioCfg      = {IO_CFG_BASE+0x20, 0, 8},
    },

	[LTE_TDD_RX_DATA7] = {
        .name       = "lte_tdd_rx_data7",
		.gpio       = GPIO97,
		.flag       = 0,
        .pdFuncSel  = {INVLID_ADDR, INVLID_VALUE, INVLID_VALUE},
        .aonFuncSel = {INVLID_ADDR, INVLID_VALUE, INVLID_VALUE},
        .topFuncSel = {TOP_FUNC_SEL_BASE+0x18, 25, 1},
        .ioCfg      = {IO_CFG_BASE+0x20, 0, 8},
    },

	[LTE_TDD_RX_DATA8] = {
        .name       = "lte_tdd_rx_data8",
		.gpio       = GPIO98,
		.flag       = 0,
        .pdFuncSel  = {INVLID_ADDR, INVLID_VALUE, INVLID_VALUE},
        .aonFuncSel = {INVLID_ADDR, INVLID_VALUE, INVLID_VALUE},
        .topFuncSel = {TOP_FUNC_SEL_BASE+0x18, 26, 1},
        .ioCfg      = {IO_CFG_BASE+0x20, 0, 8},
    },

	[LTE_TDD_RX_DATA9] = {
        .name       = "lte_tdd_rx_data9",
		.gpio       = GPIO99,
		.flag       = 0,
        .pdFuncSel  = {INVLID_ADDR, INVLID_VALUE, INVLID_VALUE},
        .aonFuncSel = {INVLID_ADDR, INVLID_VALUE, INVLID_VALUE},
        .topFuncSel = {TOP_FUNC_SEL_BASE+0x18, 27, 1},
        .ioCfg      = {IO_CFG_BASE+0x20, 0, 8},
    },

	[LTE_TDD_RX_DATA10] = {
        .name       = "lte_tdd_rx_data10",
		.gpio       = GPIO100,
		.flag       = 0,
        .pdFuncSel  = {INVLID_ADDR, INVLID_VALUE, INVLID_VALUE},
        .aonFuncSel = {INVLID_ADDR, INVLID_VALUE, INVLID_VALUE},
        .topFuncSel = {TOP_FUNC_SEL_BASE+0x18, 28, 1},
        .ioCfg      = {IO_CFG_BASE+0x20, 0, 8},
    },

	[LTE_TDD_RX_DATA11] = {
        .name       = "lte_tdd_rx_data11",
		.gpio       = GPIO101,
		.flag       = 0,
        .pdFuncSel  = {INVLID_ADDR, INVLID_VALUE, INVLID_VALUE},
        .aonFuncSel = {INVLID_ADDR, INVLID_VALUE, INVLID_VALUE},
        .topFuncSel = {TOP_FUNC_SEL_BASE+0x18, 29, 1},
        .ioCfg      = {IO_CFG_BASE+0x20, 0, 8},
    },

	[FCLK] = {
        .name       = "fclk",
		.gpio       = GPIO102,
		.flag       = 0,
        .pdFuncSel  = {INVLID_ADDR, INVLID_VALUE, INVLID_VALUE},
        .aonFuncSel = {INVLID_ADDR, INVLID_VALUE, INVLID_VALUE},
        .topFuncSel = {TOP_FUNC_SEL_BASE+0x18, 30, 1},
        .ioCfg      = {IO_CFG_BASE+0x28, 8, 8},
    },

	[FRAME_TX] = {
        .name       = "frame_tx",
		.gpio       = GPIO103,
		.flag       = 0,
        .pdFuncSel  = {INVLID_ADDR, INVLID_VALUE, INVLID_VALUE},
        .aonFuncSel = {INVLID_ADDR, INVLID_VALUE, INVLID_VALUE},
        .topFuncSel = {TOP_FUNC_SEL_BASE+0x18, 31, 1},
        .ioCfg      = {IO_CFG_BASE+0x24, 0, 2},
    },

	[FRAME_RX] = {
        .name       = "frame_rx",
		.gpio       = GPIO104,
		.flag       = 0,
        .pdFuncSel  = {INVLID_ADDR, INVLID_VALUE, INVLID_VALUE},
        .aonFuncSel = {INVLID_ADDR, INVLID_VALUE, INVLID_VALUE},
        .topFuncSel = {TOP_FUNC_SEL_BASE+0x1c, 0, 1},
        .ioCfg      = {IO_CFG_BASE+0x24, 2, 2},
    },

	[MCLK] = {
        .name       = "mclk",
		.gpio       = GPIO105,
		.flag       = 0,
        .pdFuncSel  = {INVLID_ADDR, INVLID_VALUE, INVLID_VALUE},
        .aonFuncSel = {INVLID_ADDR, INVLID_VALUE, INVLID_VALUE},
        .topFuncSel = {TOP_FUNC_SEL_BASE+0x1c, 1, 1},
        .ioCfg      = {IO_CFG_BASE+0x24, 4, 2},
    },

	[LTE_REF_CLK] = {
        .name       = "lte_ref_clk",
		.gpio       = GPIO106,
		.flag       = 0,
        .pdFuncSel  = {INVLID_ADDR, INVLID_VALUE, INVLID_VALUE},
        .aonFuncSel = {INVLID_ADDR, INVLID_VALUE, INVLID_VALUE},
        .topFuncSel = {TOP_FUNC_SEL_BASE+0x1c, 2, 1},
        .ioCfg      = {IO_CFG_BASE+0x24, 6, 2},
    },

	[LTE_TXRX_EN] = {
        .name       = "lte_txrx_en",
		.gpio       = GPIO107,
		.flag       = 0,
        .pdFuncSel  = {PD_FUNC_SEL_BASE+0x14, 0, 10},
        .aonFuncSel = {INVLID_ADDR, INVLID_VALUE, INVLID_VALUE},
        .topFuncSel = {TOP_FUNC_SEL_BASE+0x1c, 3, 1},
        .ioCfg      = {IO_CFG_BASE+0x24, 8, 2},
    },

	[LTE_TXRX_SWITCH] = {
        .name       = "lte_txrx_switch",
		.gpio       = GPIO108,
		.flag       = 0,
        .pdFuncSel  = {PD_FUNC_SEL_BASE+0x14, 10, 10},
        .aonFuncSel = {INVLID_ADDR, INVLID_VALUE, INVLID_VALUE},
        .topFuncSel = {TOP_FUNC_SEL_BASE+0x1c, 4, 1},
        .ioCfg      = {IO_CFG_BASE+0x24, 10, 2},
    },

	[RESETB_OUT] = {
        .name       = "resetb_out",
		.gpio       = GPIO109,
		.flag       = 0,
        .pdFuncSel  = {INVLID_ADDR, INVLID_VALUE, INVLID_VALUE},
        .aonFuncSel = {INVLID_ADDR, INVLID_VALUE, INVLID_VALUE},
        .topFuncSel = {TOP_FUNC_SEL_BASE+0x1c, 5, 1},
        .ioCfg      = {IO_CFG_BASE+0x24, 12, 2},
    },

	[PDN_GSM] = {
        .name       = "pdn_gsm",
		.gpio       = GPIO110,
		.flag       = 0,
        .pdFuncSel  = {INVLID_ADDR, INVLID_VALUE, INVLID_VALUE},
        .aonFuncSel = {AON_FUNC_SEL_BASE+0xc, 16, 2},
        .topFuncSel = {TOP_FUNC_SEL_BASE+0x1c, 6, 1},
        .ioCfg      = {IO_CFG_BASE+0x24, 14, 2},
    },

	[WAKE_UP] = {
        .name       = "wake_up",
		.gpio       = GPIO111,
		.flag       = 0,
        .pdFuncSel  = {INVLID_ADDR, INVLID_VALUE, INVLID_VALUE},
        .aonFuncSel = {AON_FUNC_SEL_BASE+0xc, 18, 2},
        .topFuncSel = {INVLID_ADDR, INVLID_VALUE, INVLID_VALUE},
        .ioCfg      = {IO_CFG_BASE+0x24, 20, 2},
    },

	[RF_SPI0_STR0] = {
        .name       = "rf_spi0_str0",
		.gpio       = GPIO112,
		.flag       = 0,
        .pdFuncSel  = {INVLID_ADDR, INVLID_VALUE, INVLID_VALUE},
        .aonFuncSel = {INVLID_ADDR, INVLID_VALUE, INVLID_VALUE},
        .topFuncSel = {TOP_FUNC_SEL_BASE+0x1c, 7, 1},
        .ioCfg      = {IO_CFG_BASE+0x28, 0, 8},
    },

	[RF_SPI0_STR1] = {
        .name       = "rf_spi0_str1",
		.gpio       = GPIO113,
		.flag       = 0,
        .pdFuncSel  = {INVLID_ADDR, INVLID_VALUE, INVLID_VALUE},
        .aonFuncSel = {INVLID_ADDR, INVLID_VALUE, INVLID_VALUE},
        .topFuncSel = {TOP_FUNC_SEL_BASE+0x1c, 8, 1},
        .ioCfg      = {IO_CFG_BASE+0x28, 0, 8},
    },

	[RF_SPI0_CLK] = {
        .name       = "rf_spi0_clk",
		.gpio       = GPIO114,
		.flag       = 0,
        .pdFuncSel  = {INVLID_ADDR, INVLID_VALUE, INVLID_VALUE},
        .aonFuncSel = {INVLID_ADDR, INVLID_VALUE, INVLID_VALUE},
        .topFuncSel = {TOP_FUNC_SEL_BASE+0x1c, 9, 1},
        .ioCfg      = {IO_CFG_BASE+0x28, 0, 8},
    },

	[RF_SPI0_DIN] = {
        .name       = "rf_spi0_din",
		.gpio       = GPIO115,
		.flag       = 0,
        .pdFuncSel  = {INVLID_ADDR, INVLID_VALUE, INVLID_VALUE},
        .aonFuncSel = {INVLID_ADDR, INVLID_VALUE, INVLID_VALUE},
        .topFuncSel = {TOP_FUNC_SEL_BASE+0x1c, 10, 1},
        .ioCfg      = {IO_CFG_BASE+0x28, 0, 8},
    },

	[RF_SPI0_DATA] = {
        .name       = "rf_spi0_data",
		.gpio       = GPIO116,
		.flag       = 0,
        .pdFuncSel  = {INVLID_ADDR, INVLID_VALUE, INVLID_VALUE},
        .aonFuncSel = {INVLID_ADDR, INVLID_VALUE, INVLID_VALUE},
        .topFuncSel = {TOP_FUNC_SEL_BASE+0x1c, 11, 1},
        .ioCfg      = {IO_CFG_BASE+0x28, 0, 8},
    },

	[RF_SPI1_STR] = {
        .name       = "rf_spi1_str",
		.gpio       = GPIO117,
		.flag       = 0,
        .pdFuncSel  = {INVLID_ADDR, INVLID_VALUE, INVLID_VALUE},
        .aonFuncSel = {INVLID_ADDR, INVLID_VALUE, INVLID_VALUE},
        .topFuncSel = {TOP_FUNC_SEL_BASE+0x1c, 12, 1},
        .ioCfg      = {IO_CFG_BASE+0x2c, 0, 2},
    },

	[RF_SPI1_CLK] = {
        .name       = "rf_spi1_clk",
		.gpio       = GPIO118,
		.flag       = 0,
        .pdFuncSel  = {INVLID_ADDR, INVLID_VALUE, INVLID_VALUE},
        .aonFuncSel = {INVLID_ADDR, INVLID_VALUE, INVLID_VALUE},
        .topFuncSel = {TOP_FUNC_SEL_BASE+0x1c, 13, 1},
        .ioCfg      = {IO_CFG_BASE+0x2c, 2, 2},
    },

	[RF_SPI1_DIN] = {
        .name       = "rf_spi1_din",
		.gpio       = GPIO119,
		.flag       = 0,
        .pdFuncSel  = {INVLID_ADDR, INVLID_VALUE, INVLID_VALUE},
        .aonFuncSel = {INVLID_ADDR, INVLID_VALUE, INVLID_VALUE},
        .topFuncSel = {TOP_FUNC_SEL_BASE+0x1c, 14, 1},
        .ioCfg      = {IO_CFG_BASE+0x2c, 4, 2},
    },

	[RF_SPI1_DATA] = {
        .name       = "rf_spi1_data",
		.gpio       = GPIO120,
		.flag       = 0,
        .pdFuncSel  = {INVLID_ADDR, INVLID_VALUE, INVLID_VALUE},
        .aonFuncSel = {INVLID_ADDR, INVLID_VALUE, INVLID_VALUE},
        .topFuncSel = {TOP_FUNC_SEL_BASE+0x1c, 15, 1},
        .ioCfg      = {IO_CFG_BASE+0x2c, 6, 2},
    },

	[RF_CONTROL0] = {
        .name       = "rf_control0",
		.gpio       = GPIO121,
		.flag       = 0,
        .pdFuncSel  = {PD_FUNC_SEL_BASE+0x18, 0, 10},
        .aonFuncSel = {INVLID_ADDR, INVLID_VALUE, INVLID_VALUE},
        .topFuncSel = {TOP_FUNC_SEL_BASE+0x1c, 16, 1},
        .ioCfg      = {IO_CFG_BASE+0x2c, 8, 2},
    },

	[RF_CONTROL1] = {
        .name       = "rf_control1",
		.gpio       = GPIO122,
		.flag       = 0,
        .pdFuncSel  = {PD_FUNC_SEL_BASE+0x18, 10, 10},
        .aonFuncSel = {INVLID_ADDR, INVLID_VALUE, INVLID_VALUE},
        .topFuncSel = {TOP_FUNC_SEL_BASE+0x1c, 17, 1},
        .ioCfg      = {IO_CFG_BASE+0x2c, 10, 2},
    },

	[RF_CONTROL2] = {
        .name       = "rf_control2",
		.gpio       = GPIO123,
		.flag       = 0,
        .pdFuncSel  = {PD_FUNC_SEL_BASE+0x18, 20, 10},
        .aonFuncSel = {INVLID_ADDR, INVLID_VALUE, INVLID_VALUE},
        .topFuncSel = {TOP_FUNC_SEL_BASE+0x1c, 18, 1},
        .ioCfg      = {IO_CFG_BASE+0x2c, 12, 2},
    },

	[RF_CONTROL3] = {
        .name       = "rf_control3",
		.gpio       = GPIO124,
		.flag       = 0,
        .pdFuncSel  = {PD_FUNC_SEL_BASE+0x1c, 0, 10},
        .aonFuncSel = {INVLID_ADDR, INVLID_VALUE, INVLID_VALUE},
        .topFuncSel = {TOP_FUNC_SEL_BASE+0x1c, 19, 1},
        .ioCfg      = {IO_CFG_BASE+0x2c, 14, 2},
    },

	[RF_CONTROL4] = {
        .name       = "rf_control4",
		.gpio       = GPIO125,
		.flag       = 0,
        .pdFuncSel  = {PD_FUNC_SEL_BASE+0x1c, 10, 10},
        .aonFuncSel = {INVLID_ADDR, INVLID_VALUE, INVLID_VALUE},
        .topFuncSel = {TOP_FUNC_SEL_BASE+0x1c, 20, 1},
        .ioCfg      = {IO_CFG_BASE+0x2c, 16, 2},
    },

	[RF_CONTROL5] = {
        .name       = "rf_control5",
		.gpio       = GPIO126,
		.flag       = 0,
        .pdFuncSel  = {PD_FUNC_SEL_BASE+0x1c, 20, 10},
        .aonFuncSel = {INVLID_ADDR, INVLID_VALUE, INVLID_VALUE},
        .topFuncSel = {TOP_FUNC_SEL_BASE+0x1c, 21, 1},
        .ioCfg      = {IO_CFG_BASE+0x2c, 18, 2},
    },

	[RF_CONTROL6] = {
        .name       = "rf_control6",
		.gpio       = GPIO127,
		.flag       = 0,
        .pdFuncSel  = {PD_FUNC_SEL_BASE+0x20, 0, 10},
        .aonFuncSel = {INVLID_ADDR, INVLID_VALUE, INVLID_VALUE},
        .topFuncSel = {TOP_FUNC_SEL_BASE+0x1c, 22, 1},
        .ioCfg      = {IO_CFG_BASE+0x2c, 20, 2},
    },

	[RF_CONTROL7] = {
        .name       = "rf_control7",
		.gpio       = GPIO128,
		.flag       = 0,
        .pdFuncSel  = {PD_FUNC_SEL_BASE+0x20, 10, 10},
        .aonFuncSel = {INVLID_ADDR, INVLID_VALUE, INVLID_VALUE},
        .topFuncSel = {TOP_FUNC_SEL_BASE+0x1c, 23, 1},
        .ioCfg      = {IO_CFG_BASE+0x2c, 22, 2},
    },

	[RF_CONTROL8] = {
        .name       = "rf_control8",
		.gpio       = GPIO129,
		.flag       = 0,
        .pdFuncSel  = {PD_FUNC_SEL_BASE+0x20, 20, 10},
        .aonFuncSel = {INVLID_ADDR, INVLID_VALUE, INVLID_VALUE},
        .topFuncSel = {TOP_FUNC_SEL_BASE+0x1c, 24, 1},
        .ioCfg      = {IO_CFG_BASE+0x2c, 24, 2},
    },

	[RF_CONTROL9] = {
        .name       = "rf_control9",
		.gpio       = GPIO130,
		.flag       = 0,
        .pdFuncSel  = {PD_FUNC_SEL_BASE+0x24, 0, 10},
        .aonFuncSel = {INVLID_ADDR, INVLID_VALUE, INVLID_VALUE},
        .topFuncSel = {TOP_FUNC_SEL_BASE+0x1c, 25, 1},
        .ioCfg      = {IO_CFG_BASE+0x2c, 26, 2},
    },

	[RF_CONTROL10] = {
        .name       = "rf_control10",
		.gpio       = GPIO131,
		.flag       = 0,
        .pdFuncSel  = {PD_FUNC_SEL_BASE+0x24, 10, 10},
        .aonFuncSel = {INVLID_ADDR, INVLID_VALUE, INVLID_VALUE},
        .topFuncSel = {TOP_FUNC_SEL_BASE+0x1c, 26, 1},
        .ioCfg      = {IO_CFG_BASE+0x2c, 28, 2},
    },

	[RF_CONTROL11] = {
        .name       = "rf_control11",
		.gpio       = GPIO132,
		.flag       = 0,
        .pdFuncSel  = {PD_FUNC_SEL_BASE+0x24, 20, 10},
        .aonFuncSel = {INVLID_ADDR, INVLID_VALUE, INVLID_VALUE},
        .topFuncSel = {TOP_FUNC_SEL_BASE+0x1c, 27, 1},
        .ioCfg      = {IO_CFG_BASE+0x2c, 30, 2},
    },

	[RF_CONTROL12] = {
        .name       = "rf_control12",
		.gpio       = GPIO133,
		.flag       = 0,
        .pdFuncSel  = {PD_FUNC_SEL_BASE+0x28, 0, 10},
        .aonFuncSel = {INVLID_ADDR, INVLID_VALUE, INVLID_VALUE},
        .topFuncSel = {TOP_FUNC_SEL_BASE+0x1c, 28, 1},
        .ioCfg      = {IO_CFG_BASE+0x30, 0, 2},
    },

	[RF_CONTROL13] = {
        .name       = "rf_control13",
		.gpio       = GPIO134,
		.flag       = 0,
        .pdFuncSel  = {PD_FUNC_SEL_BASE+0x28, 10, 10},
        .aonFuncSel = {INVLID_ADDR, INVLID_VALUE, INVLID_VALUE},
        .topFuncSel = {TOP_FUNC_SEL_BASE+0x1c, 29, 1},
        .ioCfg      = {IO_CFG_BASE+0x30, 2, 2},
    },

	[RF_CONTROL14] = {
        .name       = "rf_control14",
		.gpio       = GPIO135,
		.flag       = 0,
        .pdFuncSel  = {PD_FUNC_SEL_BASE+0x28, 20, 10},
        .aonFuncSel = {INVLID_ADDR, INVLID_VALUE, INVLID_VALUE},
        .topFuncSel = {TOP_FUNC_SEL_BASE+0x1c, 30, 1},
        .ioCfg      = {IO_CFG_BASE+0x30, 4, 2},
    },

	[RF_CONTROL15] = {
        .name       = "rf_control15",
		.gpio       = GPIO136,
		.flag       = 0,
        .pdFuncSel  = {PD_FUNC_SEL_BASE+0x2c, 0, 10},
        .aonFuncSel = {INVLID_ADDR, INVLID_VALUE, INVLID_VALUE},
        .topFuncSel = {TOP_FUNC_SEL_BASE+0x1c, 31, 1},
        .ioCfg      = {IO_CFG_BASE+0x30, 6, 2},
    },

	[RF_CONTROL16] = {
        .name       = "rf_control16",
		.gpio       = GPIO137,
		.flag       = 0,
        .pdFuncSel  = {PD_FUNC_SEL_BASE+0x2c, 10, 10},
        .aonFuncSel = {INVLID_ADDR, INVLID_VALUE, INVLID_VALUE},
        .topFuncSel = {TOP_FUNC_SEL_BASE+0x20, 0, 1},
        .ioCfg      = {IO_CFG_BASE+0x30, 8, 2},
    },

	[RF_CONTROL17] = {
        .name       = "rf_control17",
		.gpio       = GPIO138,
		.flag       = 0,
        .pdFuncSel  = {PD_FUNC_SEL_BASE+0x2c, 20, 10},
        .aonFuncSel = {INVLID_ADDR, INVLID_VALUE, INVLID_VALUE},
        .topFuncSel = {TOP_FUNC_SEL_BASE+0x20, 1, 1},
        .ioCfg      = {IO_CFG_BASE+0x30, 10, 2},
    },

	[RF_CONTROL18] = {
        .name       = "rf_control18",
		.gpio       = GPIO139,
		.flag       = 0,
        .pdFuncSel  = {PD_FUNC_SEL_BASE+0x30, 0, 10},
        .aonFuncSel = {INVLID_ADDR, INVLID_VALUE, INVLID_VALUE},
        .topFuncSel = {TOP_FUNC_SEL_BASE+0x20, 2, 1},
        .ioCfg      = {IO_CFG_BASE+0x30, 12, 2},
    },

	[RF_CONTROL19] = {
        .name       = "rf_control19",
		.gpio       = GPIO140,
		.flag       = 0,
        .pdFuncSel  = {PD_FUNC_SEL_BASE+0x30, 10, 10},
        .aonFuncSel = {INVLID_ADDR, INVLID_VALUE, INVLID_VALUE},
        .topFuncSel = {TOP_FUNC_SEL_BASE+0x20, 3, 1},
        .ioCfg      = {IO_CFG_BASE+0x30, 14, 2},
    },

	[RF_CONTROL20] = {
        .name       = "rf_control20",
		.gpio       = GPIO141,
		.flag       = 0,
        .pdFuncSel  = {PD_FUNC_SEL_BASE+0x30, 20, 10},
        .aonFuncSel = {INVLID_ADDR, INVLID_VALUE, INVLID_VALUE},
        .topFuncSel = {TOP_FUNC_SEL_BASE+0x20, 4, 1},
        .ioCfg      = {IO_CFG_BASE+0x30, 16, 2},
    },

	[RF_CONTROL21] = {
        .name       = "rf_control21",
		.gpio       = GPIO142,
		.flag       = 0,
        .pdFuncSel  = {PD_FUNC_SEL_BASE+0x34, 0, 10},
        .aonFuncSel = {INVLID_ADDR, INVLID_VALUE, INVLID_VALUE},
        .topFuncSel = {TOP_FUNC_SEL_BASE+0x20, 5, 1},
        .ioCfg      = {IO_CFG_BASE+0x30, 18, 2},
    },

	[RF_CONTROL22] = {
        .name       = "rf_control22",
		.gpio       = GPIO143,
		.flag       = 0,
        .pdFuncSel  = {PD_FUNC_SEL_BASE+0x34, 10, 10},
        .aonFuncSel = {INVLID_ADDR, INVLID_VALUE, INVLID_VALUE},
        .topFuncSel = {TOP_FUNC_SEL_BASE+0x20, 6, 1},
        .ioCfg      = {IO_CFG_BASE+0x30, 20, 2},
    },

	[RF_CONTROL23] = {
        .name       = "rf_control23",
		.gpio       = GPIO144,
		.flag       = 0,
        .pdFuncSel  = {PD_FUNC_SEL_BASE+0x34, 20, 10},
        .aonFuncSel = {INVLID_ADDR, INVLID_VALUE, INVLID_VALUE},
        .topFuncSel = {TOP_FUNC_SEL_BASE+0x20, 7, 1},
        .ioCfg      = {IO_CFG_BASE+0x30, 22, 2},
    },

	[RMII_CLK_I] = {
        .name       = "rmii_clk_i",
		.gpio       = GPIO155,
		.flag       = 0,
        .pdFuncSel  = {INVLID_ADDR, INVLID_VALUE, INVLID_VALUE},
        .aonFuncSel = {INVLID_ADDR, INVLID_VALUE, INVLID_VALUE},
        .topFuncSel = {TOP_FUNC_SEL_BASE+0x20, 8, 1},
        .ioCfg      = {IO_CFG_BASE+0x40, 8, 8},
    },

	[RMII_CLK_O] = {
        .name       = "rmii_clk_o",
		.gpio       = GPIO154,
		.flag       = 0,
        .pdFuncSel  = {INVLID_ADDR, INVLID_VALUE, INVLID_VALUE},
        .aonFuncSel = {INVLID_ADDR, INVLID_VALUE, INVLID_VALUE},
        .topFuncSel = {TOP_FUNC_SEL_BASE+0x20, 9, 1},
        .ioCfg      = {IO_CFG_BASE+0x40, 8, 8},
    },

	[RMII_TXEN] = {
        .name       = "rmii_txen",
		.gpio       = GPIO145,
		.flag       = 0,
        .pdFuncSel  = {INVLID_ADDR, INVLID_VALUE, INVLID_VALUE},
        .aonFuncSel = {INVLID_ADDR, INVLID_VALUE, INVLID_VALUE},
        .topFuncSel = {TOP_FUNC_SEL_BASE+0x20, 10, 1},
        .ioCfg      = {IO_CFG_BASE+0x40, 8, 8},
    },

	[RMII_RXEN] = {
        .name       = "rmii_rxen",
		.gpio       = GPIO146,
		.flag       = 0,
        .pdFuncSel  = {INVLID_ADDR, INVLID_VALUE, INVLID_VALUE},
        .aonFuncSel = {INVLID_ADDR, INVLID_VALUE, INVLID_VALUE},
        .topFuncSel = {TOP_FUNC_SEL_BASE+0x20, 11, 1},
        .ioCfg      = {IO_CFG_BASE+0x40, 8, 8},
    },

	[RMII_RXD0] = {
        .name       = "rmii_rxd0",
		.gpio       = GPIO147,
		.flag       = 0,
        .pdFuncSel  = {INVLID_ADDR, INVLID_VALUE, INVLID_VALUE},
        .aonFuncSel = {INVLID_ADDR, INVLID_VALUE, INVLID_VALUE},
        .topFuncSel = {TOP_FUNC_SEL_BASE+0x20, 12, 1},
        .ioCfg      = {IO_CFG_BASE+0x40, 8, 8},
    },

	[RMII_RXD1] = {
        .name       = "rmii_rxd1",
		.gpio       = GPIO148,
		.flag       = 0,
        .pdFuncSel  = {INVLID_ADDR, INVLID_VALUE, INVLID_VALUE},
        .aonFuncSel = {INVLID_ADDR, INVLID_VALUE, INVLID_VALUE},
        .topFuncSel = {TOP_FUNC_SEL_BASE+0x20, 13, 1},
        .ioCfg      = {IO_CFG_BASE+0x40, 8, 8},
    },

	[RMII_TXD0] = {
        .name       = "rmii_txd0",
		.gpio       = GPIO149,
		.flag       = 0,
        .pdFuncSel  = {INVLID_ADDR, INVLID_VALUE, INVLID_VALUE},
        .aonFuncSel = {INVLID_ADDR, INVLID_VALUE, INVLID_VALUE},
        .topFuncSel = {TOP_FUNC_SEL_BASE+0x20, 14, 1},
        .ioCfg      = {IO_CFG_BASE+0x40, 8, 8},
    },

	[RMII_TXD1] = {
        .name       = "rmii_txd1",
		.gpio       = GPIO150,
		.flag       = 0,
        .pdFuncSel  = {INVLID_ADDR, INVLID_VALUE, INVLID_VALUE},
        .aonFuncSel = {INVLID_ADDR, INVLID_VALUE, INVLID_VALUE},
        .topFuncSel = {TOP_FUNC_SEL_BASE+0x20, 15, 1},
        .ioCfg      = {IO_CFG_BASE+0x40, 8, 8},
    },

	[MDC_SCLK] = {
        .name       = "mdc_sclk",
		.gpio       = GPIO151,
		.flag       = 0,
        .pdFuncSel  = {INVLID_ADDR, INVLID_VALUE, INVLID_VALUE},
        .aonFuncSel = {INVLID_ADDR, INVLID_VALUE, INVLID_VALUE},
        .topFuncSel = {TOP_FUNC_SEL_BASE+0x20, 16, 1},
        .ioCfg      = {IO_CFG_BASE+0x40, 8, 8},
    },

	[MDC_SDIO] = {
        .name       = "mdc_sdio",
		.gpio       = GPIO152,
		.flag       = 0,
        .pdFuncSel  = {INVLID_ADDR, INVLID_VALUE, INVLID_VALUE},
        .aonFuncSel = {INVLID_ADDR, INVLID_VALUE, INVLID_VALUE},
        .topFuncSel = {TOP_FUNC_SEL_BASE+0x20, 17, 1},
        .ioCfg      = {IO_CFG_BASE+0x40, 8, 8},
    },

	[PHY_RST] = {
        .name       = "phy_rst",
		.gpio       = GPIO153,
		.flag       = 0,
        .pdFuncSel  = {INVLID_ADDR, INVLID_VALUE, INVLID_VALUE},
        .aonFuncSel = {INVLID_ADDR, INVLID_VALUE, INVLID_VALUE},
        .topFuncSel = {TOP_FUNC_SEL_BASE+0x20, 18, 1},
        .ioCfg      = {IO_CFG_BASE+0x40, 8, 8},
    },
};

UINT32 gGpioNumMax = sizeof(gGpioInfoTable) / sizeof(T_Gpio);
		
