#!/bin/sh

cd ../../..
SRC_PATH=`pwd`
KEYS_PATH=$SRC_PATH/../tools/SignImage

cd $SRC_PATH/common/src/loader

make mrproper
rm -f ./z-load*

is_ok=0

if 
	make "$chip"_tloader_config;
then
	if	make platform; then
		if make together; then
			is_ok=1
		fi		
	fi
fi

if [ $is_ok -eq 1 ];then

	echo "";
	echo "Configuring ["$chip"_"$board"_tloader_config] for ["$chip" "$board" "$key_path"] board ...";
		
	mkdir -p $KEYS_PATH/Input
	mkdir -p $KEYS_PATH/Output
	chmod -R 777 $SRC_PATH/
	cp z-load.bin $KEYS_PATH/Input/tloader.bin
	cd $KEYS_PATH
	./SignImage -z ./Input/tloader.bin ./test_key/$key_path/private.k
	cp ./Input/tloader.bin $SRC_PATH/prj/$chip/$board/bin/tloader.bin
	rm -rf Input
	rm -rf Output
	
	echo "--Finished build [tloader.bin ] ...";
	echo "................................................OK....";		
fi


