#include <linux/kallsyms.h>
#include <asm/cacheflush.h>
#include <asm/exception.h>
#include <asm/unistd.h>
#include <asm/traps.h>
#include <asm/unwind.h>
#include <asm/tls.h>
#include <asm/system_misc.h>
#include <asm/stacktrace.h>

#include <linux/syscalls.h>

#include <linux/kprobes.h>
#include <asm/traps.h>
#include <linux/fs.h>
#include <asm/uaccess.h>
#include <linux/kmod.h>

#include <net/SI/net_track.h>

#include <linux/timer.h>
#include <linux/timex.h>
#include <linux/rtc.h>


#define STACK_ERRNO_LENMAX	100
char errno_proc_name[21] = {0};
int errno_stack_track = 0;

int errno_write_file(char *pbuf)
{
	char sig[32] = {0};
	char *argv[4];
	
	argv[0] = "/bin/errno_monitor";	
	argv[1] = "errno";
	argv[2] = pbuf;
	argv[3] = NULL;
	
	static char *envp[] = {
		"HOME=/",
		"TERM=linux",
		"PATH=/sbin:/bin:/usr/sbin:/usr/bin", NULL };

	return call_usermodehelper( argv[0], argv, envp, UMH_WAIT_EXEC);
}


int errno_track(int errno, int linenum, char *filename)
{
	char mytmp[STACK_ERRNO_LENMAX] = {0};
	char mybkp[STACK_ERRNO_LENMAX+200] = {0};
	struct timex  txc;
	struct rtc_time tm;
	int len = 0;
    struct file *fp;
    mm_segment_t fs;
    loff_t pos;
	int flag = 0;
	
	/*ĴΪ0˵δֱӷز*/
	if (errno >= 0)
		return errno;

	/*ΪNULL߲ǵǰӼҲΪallʱ¼errno*/
	if (errno_proc_name[0]=='\0' || 
		((strstr(current->comm,errno_proc_name)==NULL)
		&& strcmp(errno_proc_name,"all")))
	{
		return errno;
	}
		
	//ӡʱ
	do_gettimeofday(&(txc.time));
	rtc_time_to_tm(txc.time.tv_sec,&tm);
	memset(mytmp, 0, sizeof(mytmp));
	sprintf(mytmp,"%04d-%02d-%02d %02d:%02d:%02d ",tm.tm_year+1900,tm.tm_mon+1, tm.tm_mday,
		tm.tm_hour,tm.tm_min,tm.tm_sec);
	strncat(mybkp,mytmp,strlen(mytmp)); 	
	
	memset(mytmp, 0, sizeof(mytmp));
	sprintf(mytmp,"%s-%d %s:%d %d ",current->comm,current->pid,filename,linenum,errno);
	strncat(mybkp,mytmp,strlen(mytmp)); 	
	memset(mytmp, 0, sizeof(mytmp));

	//ӡջϵ
	if (1 == errno_stack_track)
	{
		get_stack_func(mytmp, STACK_ERRNO_LENMAX);	
		strncat(mybkp,mytmp,strlen(mytmp)); 
	}		

	errno_write_file(mybkp);
		
	return errno;
}


