/**
 * @file at_utils.h
 * @brief ṩӦʹõsoftapƽ̨ӿ
 *
 * Copyright (C) 2017 Sanechips Technology Co., Ltd.
 * @author
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 *
 */
#ifndef __AT_UTILS_H__
#define __AT_UTILS_H__
#include "os_type_def.h"
#include "softap_api.h"

/*******************************************************************************
 *                             Type definitions                                *
 ******************************************************************************/


/*******************************************************************************
 *                       Global function declarations                          *
 ******************************************************************************/
/**
 * @brief ATĵǰ״̬Ծһ
 * @param AT_END          AT̽ͻ˿ϲappӦϢҪatͨatӦ
 * @param AT_CONTINUE     AT̼
 * @param AT_END_AND_MSG  ڷյATظOK룬ͬʱ跢ϢAPP
 * @param AT_STATE_MAX    ޺
 */
#ifndef DOXYGEN_SHOULD_SKIP_THIS
enum at_context_state {
	AT_END = 0, //AT̽ͻ˿ϲappӦϢҪatͨatӦ
	AT_CONTINUE,//AT̼
	AT_END_AND_MSG,//ڷյATظOK룬ͬʱ跢ϢAPP
	AT_WAIT_AUTO,//յӦδȡҪϱʱظֵĿǰPDPzgipdnsϱOKϱ
	AT_STATE_MAX,//޺
};
#endif

/**
 * @brief Ϊ˵յat_ctlصķˣյ֮Ϊͬʽֱڸúдok
 *DEMO(ͻοעķ)յ󣬱ͨ첽ϢķʽDEMOAPPͨϢӦ
 * @param at_fd 		 ATͨ
 * @param at_paras		 AT
 * @param res_msg		 Ϊͬʽres_msgΪظĽ룻Ϊ첽ʽres_msgΪATתϢṹ
 * @param res_msglen	 res_msgĳ
 * @return intͽ   enum at_context_stateöֵAT_ENDʾͬӦʽAT_CONTINUEʾ첽Ӧʽ,ɿܾһ
 * @note ɲοʾ: user_regist.c
 */
typedef int (*ser_req_func2)(int at_fd, char *at_paras, void ** res_msg, int *res_msglen);


/**
 * @brief APP͵ӦϢATװװATӦ󣬴at_fdͨ͸Զ˿ͻ
 * @param rsp_msg		 APP͵ӦϢ
 * @param ret			 AT
 * @param retlen		 AT
 * @return intͽ   enum at_context_stateöֵ
 * @note ɲοʾ: user_regist.c
 */
typedef int (*app_rsp_proc)(void *rsp_msg, void**ret, int *retlen);

/**
 * @brief ϱatѯмϱat
 *	psصϱͲѯмϱһ轫ϱݷ͸ģӦã˾ʹnvȫֱķʽ
 *	չatмϱһҪѯ͸ģӦã̬ڴ棬contextеapp_para
 * @param at_paras	ATַ
 * @return charַʾתat
 * @note
 * at_paraָȥATͷĵһַ
 * صATҲ': 'ͷAT 
 * +CSQ: <rssi>,<ber>,<act>, at_paraΪ: <rssi>,<ber>,<act>, : <rssi>,<ber>
 */

typedef char * (*format_inform_func)(char *at_paras);


/**
 * @brief at
 * @param cmd	 AT
 * @param param  AT
 * @return atַָ
 * @note at_ctlͷڴ
 */
char* at_act_build(char* cmd, char* param);

/**
 * @brief atѯ
 * @param cmd	AT
 * @return atѯַָ
 * @note at_ctlͷڴ
 */
char* at_query_build(char* cmd);


/**
 * @brief  atѯӦмϱʱser_ops_t2rsp_actã
 * úнмϱokatװһͨmallocʹõڴ棬
 * ָúʹãúͷŸڴ
 * @param cmd	ATӦ
 * @param param  ATӦ
 * @return atӦַָ
 * @note input:  cmd  "xx"   
 *           	param    "yy,zz" 
 *       output:   \r\n+xx:yy,zz\r\n
 */
char* at_query_result_build(char* cmd, char* param);



/**
 * @brief atӦOK
 * @return atӦOKַָ
 * @note at_ctlͷڴ
 */
char* at_ok_build();


/**
* @brief at
* @param fmt ÿݸʽ
* @param buf ԭʼ
* @param pval ʽֵ
* @return ȷĸ
* @note ʽ֧%d%s,ͬʱÿʽǰָ
	 ԸֵĿռСλΪֽڣ%2dʾܴ洢ռΪ2ֽڣ%5sʾ'\0'
	 5ַ%dָʱ4ֽڽиֵ%sʵʽַȫֵп
	 Խ硣
*ʾ
<pre>
	char buf[]="1,2,\"test\"";
	int n1 = 0;
	int n2 = 0;
	char *n3 = malloc(strlen(buf));
	char *p[] = {&n1,&n2,n3};
	ret = parse_param2("%d,%d,%s", buf, (void**)p);
	//n1==1 n2==2 n3=="test"	 
	ret = parse_param2("%4d,%d,%3s", buf, (void**)p);
	//n1==1 n2==2 n3=="te"	 
	retֵΪ3
</pre>
*/
int parse_param2(char *fmt, char *buf, void **pval);


/**
 * @brief ATӿ
 * @param fmt ATӦĸʽʽ
 * @param buf  ATӦַָ벻ͷͿո
 * @param pval	ʽAT
 * @return 0ʾڲϸĲ飬һԼ飬ڿѡҪп
 * @note  
 * 1. AT밴3GPP27007׼Э飬ԶŸַ˫ţ
 * 2. ַʱγȱڿַܽȣԽ
 * 3. ֵοöenum SAP_ERRѡһԼ
 * 4. fmtָĲͱpvalָһһӦ
 * 5. ʾ
<pre>
	char buf[]="1,2,\"test\"";
	int n1 = 0;
	int n2 = 0;
	char *n3 = malloc(strlen(buf));
	char *p[] = {&n1,&n2,n3};
	ret = parse_param_safe("%d,%d,%s", buf, (void**)p);
	//n1==1 n2==2 n3=="test"	 
	ret = parse_param_safe("%4d,%d,%3s", buf, (void**)p);
	//n1==1 n2==2 n3=="te"	 
</pre>
 * @warning 
 */
int  parse_param_safe(char *fmt, char *buf, void **pval);


/**
 * @brief Ӧ÷ͶѯAT3GPPЭջʱȴע⣺ýӿֻڲѯúִͨνмڲ
		  мϱʱֻ֧һмϱ
 * @param req_at  ATСдУд
 * @param info_fmt ATӦĸʽʽ
 * @param pval	ʽATӦʹòοparse_paramӿ
 * @param safe_parm_check	ָʾǷԲһԼ飬0ʾѡԲм;1ʾԲϸ
 * @param timeout timeout==0 ʾõȴ룬ȴʱΪ[timeout]
 * @return 0ʾسɹֵʾʧܴ
 * @note  
 * 1. ûʹʱɸýӿڲвĸʽԽinfo_fmtֵΪ"%s"pvalֵΪchar **p˫ָ룬Ϊַظ
 * 2. ZMGL,CPBR, COPS=?һжмú
 * 3. ַʱγȱڿַܽȣԽ
 * 4. мϱʱpvalinfo_fmtΪգΪмϱʱΪ
 * 5. pvalinfo_fmtҪôΪNULL,ҪôΪNULLܴһΪNULLһΪNULL
 * 6. ʾ
<pre>
	int ret = 0;
	ret = get_modem_info2("AT+CFUN=1\r", NULL,  NULL);
	//ؼʾִгɹ

	char *pstr = malloc(50);
	memset(pstr,0,50);
	ret = get_modem_info2("AT+CIMI\r", "%s",  (void**)&pstr,0,10);
	//غpstr==111111111111111

	int n1 = 0;
	int n2 = 0;
	int n3 = 0;
	char *p2[] = {&n1,&n2,&n3};
	ret = get_modem_info2("AT+CCIOTOPT?\r", "%d,%d,%d",	(void**)p2,0,10);
	//+CCIOTOPT: 1,2,3n1==1 n2==2 n3==3
</pre>
 * @warning 
 */
int  get_modem_info2(char *req_at,char *info_fmt,void **pval, int safe_parm_check, int timeout);


/**
 * @brief ڿעеķ˾AT¼ϲ㼰ͻƣ׼PSЭջ
 * @param at_cmd_prefix  ATǰ׺ָ
 * @param module_id 	 Դģid
 * @param req_msg_id	 Ϣid
 * @param rsp_msg_id	 ӦϢid
 * @param req_rcv_act	 յϢʱĴ
 * @param rsp_act		 յӦʱĴ
 * @return intͽ
 * @retval ɹ 0
 * @note ɲοʾ: user_regist.c
 */
int  register_serv_func2(char *at_cmd_prefix, int  module_id, int  req_msg_id, int	rsp_msg_id, ser_req_func2 req_rcv_act, app_rsp_proc rsp_act);

/**
 * @brief עϱATĸʽⲿMCUATmodemصмⲿMCUĸʽҪ
Ҫat_ctlת
 * @param at_cmd_prefix  ATǰ׺ָ
 * @param inform_act  յATмת
 * @return intͽ
 * @retval ɹ 0
 * @note
 */
int  register_formatInform_func(char *at_cmd_prefix, format_inform_func inform_act);

#ifndef DOXYGEN_SHOULD_SKIP_THIS
/**
 * @brief ɴӡַתΪֽ 磺
                "C8329BFD0E01" --> {0xC8, 0x32, 0x9B, 0xFD, 0x0E, 0x01}
 * @param pSrc Դַָ
 * @param pDst Ŀָ
 * @param nSrcLength Դַ
 * @return Ŀݳ
 * @note
 * @warning
 */
int string2bytes(const char* pSrc, unsigned char* pDst, int nSrcLength);
/**
 * @brief ֽתΪɴӡַ 磺
                     {0xC8, 0x32, 0x9B, 0xFD, 0x0E, 0x01} --> "C8329BFD0E01"
 * @param pSrc Դָ
 * @param pDst Ŀַָ
 * @param nSrcLength Դݳ
 * @return Ŀݳȣ
 * @note
 * @warning
 */
int bytes2string(const unsigned char* pSrc, char* pDst, int nSrcLength);



 /**
  * @brief ںԴСд£ȽatַǷͬ
  * @param dest  Ŀַ
  * @param source Դַ
  * @return 0ʾַȫͬһδڵڶΣֵ򷵻ظֵ
  * @note
  * @warning 
  */
 int at_strcmp(const char *dest, const char *source);


 /**
  * @brief ںԴСд£ȽatַǰsizeǷͬ
  * @param dest  Ŀַ
  * @param source Դַ
  * @param size Ƚϵֽ
  * @return 0ʾַǰsizeȫͬһδڵڶΣֵ򷵻ظֵ
  * @note
  * @warning 
  */
 int at_strncmp(const char *dest, const char *source, int size);

  /**
  * @brief ںԴСд£sourceѰsubstrӴλ
  * @param dest  Ŀַ
  * @param source Դַ
  * @return ҵֱӷsubstrsourceеһγֵλãûҵNULL
  * @note
  * @warning 
  */
 char * at_strstr(const char * source, const char * substr);

 
  //ڼۼӵCHECKSUMֵ
 unsigned short get_chksum(const unsigned char *ptr, unsigned short len);
#endif

#endif

