/**
 * @file soft_timer.h
 * @brief ʱͷļ
 *
 * Copyright (C) 2017 Sanechips Technology Co., Ltd.
 *
 */

#ifndef _SOFT_TIMER_H_
#define _SOFT_TIMER_H_

/*******************************************************************************
 *                           Include header files                              *
 ******************************************************************************/
#ifdef __cplusplus
extern "C" {
#endif

#include "message.h"
#include "os_type_def.h"


/*******************************************************************************
 *                             Macro definitions                               *
 ******************************************************************************/
/**
 * @brief ʱ
 */
#define MAX_SOFT_TIMER_NUM 32

/**
 * @brief ʱͱ־λucFlagĺ,˶ʱֻһ
 */
#define TIMER_FLAG_ONCE  0

/**
 * @brief ʱͱ־λucFlagĺ,˶ʱЧ
 */
#define TIMER_FLAG_RESTART 1

/**
 * @brief ʱ붨壬صΪ
 */
#define SOFTTIMER_ERRCODE_CALLBACK_NULL 1

/**
 * @brief ʱ붨壬ʼʧ
 */
#define SOFTTIMER_ERRCODE_INIT_FAIL 	2

/**
 * @brief ʱ붨壬ʱ
 */
#define SOFTTIMER_ERRCODE_QUEUE_FULL 	3

/**
 * @brief ʱ붨壬ʱidѾ
 */
#define SOFTTIMER_ERRCODE_TIMERID_EXIST 4


#ifndef DOXYGEN_SHOULD_SKIP_THIS

/**
 * @brief ӲʱĲ10ms
 */
#define TIMER_STEP 10

/*if the thread of soft timer is exist, 0 means not exist*/
#define   SOFT_TIMER_THREAD_NULL  0
#define   SOFT_TIMER_THREAD_EXIST  1

#endif//#ifndef DOXYGEN_SHOULD_SKIP_THIS


/*******************************************************************************
 *                             Type definitions                                *
 ******************************************************************************/
#ifndef DOXYGEN_SHOULD_SKIP_THIS

/*ʱݽṹ*/
typedef struct tagSOFT_TIMER {
	struct tagSOFT_TIMER *prev;
	struct tagSOFT_TIMER *next;
	int used;
	int done;
	int timerValue;

	USHORT usTimerID;      /*ʱID,ֲͬʱ, 0ʶ*/
	UCHAR  ucFlag;         /*ʱͱ־λ*/
	UCHAR  ucReserved;     /*ֶ*/
	ULONG  ulCurInterval;   /*ǰʱʱʣʱ䣬λ (עⲻ΢)붨ΪӲʱı*/
	ULONG  ulNextInterval;  /*ʱʱõļλ (עⲻ΢)*/
	void * (*procCallBack)(void *); /*嶨ʱʱĻصָ*/
	void   *args;                /*嶨ʱʱĻصĲ*/
} SOFT_TIMER;

typedef struct tagMSG_TIMERBUF {
	LONG   lMsgType;        /*ϢͣϢȡ˳*/
	USHORT usMsgCmd;        /*Ϣ룬ָʾϢʲô*/
	USHORT usDataLen;       /*ЯЧݳ*/
	UCHAR  aucDataBuf[4];   /*ЯЧbuffer,Ŷʱindex*/
	ULONG  ulMagic;         /*ħֵ֣ΪMSG_MAGIC_WORD*/
} T_TIMER_MSG_BUF;

#endif//#ifndef DOXYGEN_SHOULD_SKIP_THIS

/*******************************************************************************
 *                       Global variable declarations                          *
 ******************************************************************************/


/*******************************************************************************
 *                       Global function declarations                          *
 ******************************************************************************/
/**
 * @brief ʱӿ
 * @param usTimerID      Σʱidֲͬʱ
 * @param ucFlag         Σʱͱ־λ
 * @param ulInterval     Σʱʱʱλms
 * @param procCallBack   ΣʱʱĻصָ
 * @param args           ΣʱʱĻص
 * @return OK ɹֵʧ
 * @retval OK  ɹ
 * @retval SOFTTIMER_ERRCODE_CALLBACK_NULL  ʱĻصַΪ
 * @retval SOFTTIMER_ERRCODE_INIT_FAIL      ʱʼʧ
 * @retval SOFTTIMER_ERRCODE_QUEUE_FULL     ʱ
 * @retval SOFTTIMER_ERRCODE_TIMERID_EXIST  ʱidѾ
 * @note
 * @warning
 */
LONG sc_timer_create(USHORT usTimerID,
                     UCHAR ucFlag,
                     ULONG ulInterval,
                     void * (*procCallBack)(void *),
                     void *args);

/**
 * @brief ɾʱӿ
 * @param usTimerID   ΣҪɾʱid
 * @return OKɹERRORʧ
 * @retval OK  ɹ
 * @retval ERROR  ʧ
 * @note
 * @warning
 */
LONG sc_timer_delete(USHORT usTimerID);

#ifndef LIBSOFT_TIMER_API_NEW
LONG CreateSoftTimer(USHORT usTimerID,
                     UCHAR ucFlag,
                     ULONG ulInterval,
                     void * (*procCallBack)(void *),
                     void *args);
LONG DeleteSoftTimer(USHORT usTimerID);
#endif

/*******************************************************************************
 *                      Inline function implementations                        *
 ******************************************************************************/


#ifdef __cplusplus
}
#endif


#endif  // #ifndef _SOFT_TIMER_H_

