#include <stdio.h>
#include <unistd.h>
#include <string.h>
#include <stdlib.h>
#include "pthread.h"
#include <stdbool.h>
#include <fcntl.h>
#include <signal.h>
#include <stdint.h>
#include <errno.h>
#include <semaphore.h>
#include "message.h"

#define  _USE_TEST_

static char *Voice_buff_devName     = (char *)"/dev/voice_buffer_dev";

static  int VOICE_Fd;
static int  g_call_msgId = 0;
static int s_rw_data_count = 320;
static int thread_running = 0;
static int  thread_stop_read = 0, thread_stop_write = 0;
static pthread_t ca_thread_tid = NULL;
static pthread_t pb_thread_tid = NULL;
static pthread_mutex_t  call_mutex = PTHREAD_MUTEX_INITIALIZER;
static pthread_cond_t  call_cond = PTHREAD_COND_INITIALIZER;

static pthread_mutex_t  rw_mutex = PTHREAD_MUTEX_INITIALIZER;
static pthread_cond_t  rw_cond = PTHREAD_COND_INITIALIZER;
//static pthread_mutex_t  stop_mutex = PTHREAD_MUTEX_INITIALIZER;

//static  sem_t  wr_sem;

/*
*20sʱص
*/
void  timer_cb(int signum)    
{
	//printf("timer_cb my_handler\n");
	pthread_cond_broadcast(&rw_cond);   
	return;
}

void  *voice_ca_thread(void *arg)
{
	char buf_data[320] = {0};
	unsigned int count = 0;
	printf("voice_ca_thread start\n");
	while(1) {
		pthread_mutex_lock(&call_mutex);
		pthread_cond_wait(&call_cond, &call_mutex);
		pthread_mutex_unlock(&call_mutex);
		printf("voice_ca_thread start 2\n");

		while(thread_running) {
			///usbģȡȻдں
			pthread_mutex_lock(&rw_mutex);
			pthread_cond_wait(&rw_cond, &rw_mutex);
			pthread_mutex_unlock(&rw_mutex);	
		//	printf("voice_ca_thread start 3\n");
		//	memcpy(buf_data, s_lowPowerPcm + count, s_rw_data_count);  //usbȡ
			write(VOICE_Fd, buf_data, s_rw_data_count);
			count += s_rw_data_count;
		//	if (count >= sizeof(s_lowPowerPcm) - s_rw_data_count)
			//	count = 0;
		}
		thread_stop_read = 1;
		printf("voice_ca_thread stop\n");
		
	}
	pthread_exit (0);
}
void  *voice_pb_thread(void *arg)
{
	FILE *file = NULL;
	char  buf_data[320] ;
	printf("voice_pb_thread start\n");

	while (1)	{
		pthread_mutex_lock(&call_mutex);
		pthread_cond_wait(&call_cond, &call_mutex);
		pthread_mutex_unlock(&call_mutex);
		printf("voice_pb_thread start 2\n");

		file = fopen("/mnt/userdata/cache/voice_data.bin", "wb");
		if (!file)  {
			printf("voice_data open fail\n");
			continue;
		}
		while (thread_running)	{        ///ں˶ȡȻдusbģ
			pthread_mutex_lock(&rw_mutex);
			pthread_cond_wait(&rw_cond, &rw_mutex);
			pthread_mutex_unlock(&rw_mutex);	
			//printf("voice_pb_thread start 3\n");
			read(VOICE_Fd, buf_data, s_rw_data_count);
			fwrite(buf_data, 1, s_rw_data_count, file); //дusbдļ
		} ;
		thread_stop_write = 1;
		printf("voice_pb_thread stop\n");
		fclose(file);
	}
	pthread_exit (0);
}

/*
*  òΪ800016000ȻٿʼͨҶϵ绰
*/
#ifndef _USE_TEST_
VOID z_cc_msg_proc(MSG_BUF *ptMsgBuf)
{
	int oflags;
	switch ()
	{
	case 0:            // NB(8000)  WB(16000)
		if (rate == 8000)
			s_rw_data_count = 320;  // NB:320  WB:640
		else if (rate == 16000)
			s_rw_data_count = 640;  // NB:320  WB:640
		break;
	case  1:              //ʼͨ
		VOICE_Fd = open(Voice_buff_devName, O_RDWR);
		if (VOICE_Fd < 0)
		{
			printf("voltestart: open device error.\n");
			return -1;
		}

		/* set fd's owner process */
		fcntl(VOICE_Fd, F_SETOWN, getpid());
		/* get old fd flags */
		oflags = fcntl(VOICE_Fd, F_GETFL);
		/* set new fd flags */
		fcntl(VOICE_Fd, F_SETFL, oflags | O_ASYNC);   //ں첽֪ͨ
		
		thread_running = 1;
		pthread_mutex_lock(&call_mutex);
		pthread_cond_broadcast(&call_cond);
		pthread_mutex_unlock(&call_mutex);	
		
		break;
	case 2:          //Ҷϵ绰
		thread_running = 0;
		pthread_cond_broadcast(&rw_cond);  //ͷźʹ߳̾˳
		while(1) {
			if ((thread_stop_write == 1) && (thread_stop_read == 1)) {
				close(VOICE_Fd);
				break;
			}
			else
				usleep(4000);
		}
		thread_stop_read = 0;
		thread_stop_write = 0; 
		break;
	default:
		break;
	}
}
#endif

#ifdef _USE_TEST_
static int capturing = 1;
void sigint_handler(int sig) // __unused)
{
    capturing = 0;
}
#endif

int main(int argc, char** argv)
{
	int ret, count = 0;
	MSG_BUF QueueMsg = {0};
	int oflags;
//	sem_init(&&wr_sem, 0, 0);

	ret = pthread_create(&ca_thread_tid, NULL, voice_ca_thread, NULL);
	if (ret != 0)
	{
		printf("Create pthread error!\n");
		exit(-1);
	}
	
	ret = pthread_create(&pb_thread_tid, NULL, voice_pb_thread, NULL);
	if (ret != 0)
	{
		printf("Create pthread error!\n");
		exit(-1);
	}

	signal(SIGIO, timer_cb);
	
#ifdef _USE_TEST_
	VOICE_Fd = open(Voice_buff_devName, O_RDWR);
	if (VOICE_Fd < 0)
	{
		printf("voltestart: open device error.\n");
		return -1;
	}
	
	/* set fd's owner process */
	fcntl(VOICE_Fd, F_SETOWN, getpid());
	/* get old fd flags */
	oflags = fcntl(VOICE_Fd, F_GETFL);
	/* set new fd flags */
	fcntl(VOICE_Fd, F_SETFL, oflags | O_ASYNC);   //ں첽֪ͨ  O_ASYNC

   	signal(SIGINT, sigint_handler);
	
	thread_running = 1;
	sleep(2);
	pthread_mutex_lock(&call_mutex);
	pthread_cond_broadcast(&call_cond);
	pthread_mutex_unlock(&call_mutex);	
	printf("main 2\n");

	while(capturing) {
		sleep(2);
	};

	thread_running = 0;
	pthread_cond_broadcast(&rw_cond);  //ͷźʹ߳̾˳

	close(VOICE_Fd);
	usleep(200000);

	thread_stop_read = 0;
	thread_stop_write = 0; 

	printf("main end\n");
#else
	g_call_msgId = msgget(key, IPC_CREAT | 0600);  //key Ҫݾģ

	while (1)
	{
			//CCģղ绰Ҷϵ绰Ϣ
		ret = msgrcv(g_call_msgId, &QueueMsg,  sizeof(MSG_BUF) - sizeof(LONG), 0, 0); 
		if (ret == -1)
		{
			printf(" msgrcv return  ret= %d errno=%d\n", ret, errno);
			continue;
		}
		else
		{
			switch (QueueMsg.src_id)
			{
			case 0: // message from CC
				z_cc_msg_proc(&QueueMsg);
				break;
			default: 
				break;
			}
		}
	};
#endif
	pthread_join(ca_thread_tid, NULL);
	pthread_join(pb_thread_tid, NULL);
	return 0;
}

