/**
 * @file at_context.h 
 * @brief at_contextڲӿںݽṹ
 *
 * Copyright (C) 2017 Sanechips Technology Co., Ltd.
 * @author 
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation. 
 *
 */
#ifndef __AT_CONTEXT_H__
#define __AT_CONTEXT_H__

/*******************************************************************************
 *                           Include header files                              *
 ******************************************************************************/
#include "at_com.h"
#include "recv_thread.h"
#include "atcmd_stream_proc.h"
#include "at_register.h"
/*******************************************************************************
 *                             Macro definitions                               *
 ******************************************************************************/
//
#define AT_RSP_OK   0
#define AT_RSP_ERR  1

#define AtTimerID            66 //δʹõ
#define PdpTimerID           67 //pdp³Լʱ
#define CopstestTimerID      68 //at+cops=?ʱIDԭûʹõ
#define AtWaitTimerID        69 //ATͨҪATԣڷⲿATͨ
#define AutoPdpActTimerID    70 //PDPضʱع
#define PbsmsInitTimerID     71 //pbsmsʼʼʱӻPBSMSʼ㣬Լӿ쿪
#define AtWaitRspTimeID      72 //ȴӦַʱʱsend_reqat_to_farps

#define AtWaitCompleteStart  80 //farpsⲿMCUʱʱʼid
#define AtWaitCompleteEnd  100 //farpsⲿMCUʱʱid

#define PdpTimer_INTERVAL          1000 /* 1s pdpʱ */
#define CopstestTimer_INTERVAL     150000   /* 150s ֶʱ */
#define PbsmsInitTimer_INTERVAL    10000  /* 10s pbsmsʼɺʱ */

#define ATCONTEXT_ABNORMAL_TIME    5*60*1000*1000 /*ͨATĳʱʱ 5*/
#define AT_PORT_NAME_LEN 30

#define BL_PTY_MAX       4
#define VOLTE_PTY1_MAX    4
#define VOLTE_PTY2_MAX    4
//ÿϵͳƽ̨򿪵ĸһ
#if (APP_OS_TYPE == APP_OS_LINUX)
//PSĿͨ
#define NEAR_PS_FD_MAX      6
//ԶPSĿͨ
#define FAR_PS_FD_MAX         20

#elif (APP_OS_TYPE == APP_OS_TOS)

//PSĿͨ
#define NEAR_PS_FD_MAX      6
//ԶPSĿͨ
#define FAR_PS_FD_MAX         10

#endif
#define MAXSTR(x, y)           ((strlen(x)>y)?strlen(x):y)
/*******************************************************************************
 *                             Type definitions                                *
 ******************************************************************************/
/* ͨľ̬ʹϵʹͷţ*/
enum context_type{
    AT_CLIENT  = 0,  //ͻˣ󵽷
    AT_SERVER ,      //ˣտͻ˵
    AT_FWD_UP ,      //תζ˵ģԶ˵AT
    AT_FWD_DOWN,     //תζ˵ģԶ˵ATתԶ˷
};

enum channel_attri{
	CH_AUTOIND = 0, //ʾͨǷϱλΪ0ʾ򿪸ͨϱܣ1ʾرϱ Ĭ0
	CH_COMM    = 1, //ʾͨǷǺ˼ͨͨ0ʾ1ʾǺ˼ͨͨ        Ĭ0
};
/* atͨϢ*/
struct at_channel_info
{
    struct at_channel_info* next;	//Ϊʼʱͨ
    int work_state;					//λͼʽʾ,жЧλӦͻˡˡΡ4ֵԼ⹲ͻ
    int at_fd;						//atͨatĽʽԷΪ࣬1ʵatͨ豸 2ϢʱģID
    int position;					//01,ӦNEAR_PSFAR_PS
    struct at_monitor_info  monitor_log;//֮ǰat
    int reserved;					//ǵǰfdǷ붯̬䣬0ʾ붯̬䣬1ʾ붯̬䣬ڿͻƻģID
    char store_cmd[AT_CMD_MAX];  	//洢at
    char last_cmd[AT_CMD_MAX];  	//洢ϴȷatfor A/
    struct at_netdog_info netdog_log[AT_NETDOG_ARRAY_MAX];//atnetdogصĽṹ
    int at_netdog_count_num;		//¼ǰnetdog
    int ch_dev_name;				//¼˼ͨ, CPʹ
    int attribution;                //λͼʾ bit0ʾͨǷϱ,0ʾ򿪸ͨϱܣ1ʾرϱ
    								//bit1ʾͨǷǺ˼ͨͨ0ʾ1ʾǺ˼ͨͨ
	int cmd_state; 					//ͨ״̬0:շͨat1:շPDU
	int timeout;					//Ϊ0FFʱЧʾͨⲿMCUཻƳʱȴӦĻ
	int is_xinke_msg;				//ϢATĶƣΪ0ʱΪƽ̨̬ܶϢͨΪ1ʱſרãӦϢMSG_CMD_SET_MSG_IS_FD
};

/* ATģӦͨ;ϱ*/
struct	at_context
{
    struct at_context *next;
    struct at_channel_info *at_channel;//ĶӦATͨʱ̬룬ͷʱ̬ͷ
    int	context_type;//ȡֵΪcontext_type0ͻˣ1ˣ2תΣ3ת
    void  *at_proc;//ָʾǰĶӦľATopsָ
    int source;//ԴģID,ڵⲿչATøñATͨ
    unsigned short msg_id; //ϢID
    void   	*app_param;//ɾAPPʹʱؽпռ飬ΪգҪ
	//void 	*at_str;	//ڴͨжȡatڵǰvolteΪat ӦʱڲԼ״̬жǷܹ
					//atܴatҪ͵modemﱣ棬volteat
					//ӦϢrsp_actзAT_CONTINUEָʾat_ctlatmodem
    //int    req_type; //ͻ˾òѯ˶ѯatעʱעἴɣעĸӦñȽ
	char at_cmd_prefix[AT_CMD_PREFIX];//ѯatǰ׺жϱatǷΪѯϱ
    struct at_context *fwd_context;//
	int cmdId;
    unsigned long cur_tick;
};


/* ʧʱ͸ϢأԼ*/
struct fwd_resend_t
{
    struct at_context * context;//
    char *at_str;//תAT
    int positon;	//ͨλãпBL/VOLTE/MODEMеһ
};

/* ͻʧʱ͸ϢԼͻ*/
struct client_resend_t
{    
    char at_str[AT_CMD_MAX];
    int position;
};
/* ϱͨݽṹ*/
struct channel_devnum_fd
{
	int ch_dev_num; //ñڴ򿪿ϱд˼ͨʱҽcpʹã¼˼ͨţapñΪ0
	int fd; //ATͨ豸
};

/* checksum鷵ֵ */
enum CHECKSUM_ERR {
	CHECKSUM_SUCC = 0,
	CHECKSUM_ERROR,
	WAIT_CHECKSUM,
};

typedef enum 
{
	POWER_ON_NORMAL = 0,
	POWER_ON_FOTA,
	POWER_ON_CHARGING,
	POWER_ON_RTC,
	POWER_ON_RESET,
	POWER_ON_HDT_TEST,
	POWER_ON_EXCEPTRESET,
	POWER_ON_LOCALUPDATE,
	POWER_ON_BOOST_IN,
	POWER_ON_AMT,
	POWER_ON_PRODUCTION,
	POWER_ON_INVALID,
}T_ZDrvSys_PowerOn_Type;

/*******************************************************************************
 *                        Global variable definitions                          *
 ******************************************************************************/
//PSͨȫ
extern int FD_NEAR_PS[NEAR_PS_FD_MAX];

//ԶPSͨȫ
extern int FD_FAR_PS[FAR_PS_FD_MAX];


//extern int volte_mainpty[VOLTE_PTY_MAX];

//atͨÿλ϶Ӧһ
extern struct at_channel_info  *at_channel_head[POSITION_MAX];
//at¼ÿλ϶Ӧһ׷̵й¶ҪnetdogԼջ켣١
extern struct at_context *context_head[POSITION_MAX];

/*******************************************************************************
 *                       Global function declarations                          *
 ******************************************************************************/
struct at_context * context_alloc_at_context(struct at_channel_info *at_channel, int type);

/**
 * @brief ͨfdȡϢλposition
 * @param 
 * @return 
 * @note   
 * @warning 
 */
int at_context_get_pos_by_fd(int at_fd);
/**
 * @brief ½һatͨڵ㲢atͨڵ
 * @param 
 * @return 
 * @note   
 * @warning 
 */
struct at_channel_info* add_new_channel(int at_fd,int position);

/**
 * @brief ʼatͨ
 * @param 
 * @return 
 * @note   ϵͳԼʵԼĳʼ뱣֤ͳһ
 * @note   ͺŻͽ֣ܻ˫CP˫AP7100ĸֵе
 * @note   ͨľȡȫУٽκβĶ̬ʹЩ
 * @warning 
 */
void at_context_at_chn_init();

/**
 * @brief ĽڵϢat
 * @param 
 * @return 
 * @note  ڿͻ˺תηATڿͻڲǰ׺ҵӦĴӺ
 * @warning 
 */
void at_context_write_by_ctx(struct at_context * context ,char *data,int len);
/**
 * @brief ͨfdatͨڵϢ
 * @param 
 * @return 
 * @note   
 * @warning 
 */
struct at_channel_info * at_context_find_chn_by_fd(int  at_fd);
/**
 * @brief fdͲ
 * @param 
 * @return 
 * @note   ڽյͨϱATĴ
 * @warning 
 */
struct at_context  * at_context_find_ctx_by_fd_type(int  at_fd,int type);

//ͺԴģIDҵģĿǰ첽ʽķӦ
struct at_context  * at_context_find_ctx_by_moduleid(int module_id, int type);

/**
 * @brief ϢpositionĽڵ㼰ͨ
 * @param 
 * @return 
 * @note   ӽڵ㵽context_head[direct]
 * @note   ATͨ׼תATķͣͿͻ˵ATֹ
 * @warning 
 */
struct	at_context  *at_context_alloc_ctx_by_pos(int position);
/**
 * @brief ͨĽڵ
 * @param 
 * @return 
 * @note   λˣռ
 * @note   ڽյATʱļͨ
 * @warning 
 */
struct	at_context  *at_context_alloc_ctx_by_fd(int  at_fd,int context_type);
/**
 * @brief Ľڵ
 * @param 
 * @return 
 * @note   ATͨ׼ڿͻ˵ATͣתATķֹͣ
 * @note   յӦͷŸ
 * @warning 
 */
struct	at_context *at_context_alloc_ctx_by_fwdctx(int position, struct at_context *fwd_context);
/**
 * @brief ͷĳ¼
 * @param 
 * @return 
 * @note   յӦϢãԼһЩ쳣
 * @warning 
 */
int  at_context_free_ctx(struct	at_context *at_context);


/**
 * @brief жǷΪͬһģ鷢һϢ
 * @param 
 * @return 
 * @note  
 * @warning 
 */
int at_context_clt_abort_handle(MSG_BUF *msg_buf);
/**
 * @brief λûȡatͨ
 * @param 
 * @return 
 * @note  ˼ͨѶʹãϱʽҪcontext.positionfd,
 *        ȡ һõͨ
 * @warning 
 */
int at_context_get_fd_by_pos(int position);
/**
 * @brief ָλõͨat
 * @param 
 * @return 
 * @note  תӦʹã㲥ʽ
 * @warning 
 */
int at_context_write_by_pos(int position,char *data);
/**
 * @brief Ϣͨ߳ϢǰϢϢ
 * @param 
 * @return 
 * @note  
 * @warning 
 */void at_context_proc_special_msg(void);
/**
 * @brief ͨϢʼ
 * @param 
 * @return 
 * @note  
 * @warning 
 */
void at_context_chn_info_init(char *at_paras);
int del_channel_info(int at_fd, int position);
int at_context_write_data(int at_fd ,char *data,int len);
void resend_rcv_atstr(int at_fd, char *at_str);
struct at_channel_info * at_context_find_chn_by_devname(int ch_devname, int position);
void delay_resend_atstr(int at_fd, char *at_str);
int rcv_checksum_func(char *rcv_str, char *new_str);

#ifdef _USE_VOLTE
int posix_openpt(int oflag);
int ptsname_r(int fd, char *buf, int buflen);
int unlockpt(int fd);
#endif

#endif


