/**
 * @file mnet_whitelist.h 
 * @brief ṩat_ctlCPAPɾϱATĽӿ
 *
 * Copyright (C) 2017 Sanechips Technology Co., Ltd.
 * @author 
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation. 
 *
 */
#ifndef __MNET_WHITELIST_H__
#define __MNET_WHITELIST_H__

/*******************************************************************************
 *                           Include header files                              *
 ******************************************************************************/
/*******************************************************************************
 *                             Macro definitions                               *
 ******************************************************************************/
/*******************************************************************************
 *                             Type definitions                                *
 ******************************************************************************/
/*******************************************************************************
 *                       Global function declarations                          *
 ******************************************************************************/

typedef enum 
{
	MNET_WHITELIST_OPER_SUCC,
	MNET_WHITELIST_DEL_CMD_EMPTY,
	MNET_WHITELIST_DEL_TARGET_EMPTY,
	MNET_WHITELIST_OPER_ALREADY_IN,
	MNET_WHITELIST_OPER_NOMORESPACE,
	MNET_WHITELIST_OPER_CMD_TOO_LONG,
}mnet_whitelist_err_code_e;

typedef struct
{
	int result;
}mnet_whitelist_oper_result;

int cmdtolower(char* cmd);
int mnet_whitelist_add(char* cmd);
int mnet_whitelist_del(char* cmd);
void mnet_whitelist_insert(char* cmd);
void mnet_whitelist_delete(char* cmd);
void mnet_whitelist_fetch();

#endif
