/**
 * @file at_log.c
 * @brief at_ctlļأ漰ͨϽܺͷĴ洢ϢĴ洢
 *        ӡlogϢĽӿ
 *
 * Copyright (C) 2017 Sanechips Technology Co., Ltd.
 * @author 
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation. 
 *
 */

/*******************************************************************************
 *                           Include header files                              *
 ******************************************************************************/
#include "at_register.h"
#include "at_netdog.h"
#include "ppp_dial.h"
/*******************************************************************************
 *                             Macro definitions                               *
 ******************************************************************************/
/*******************************************************************************
 *                             Type definitions                                *
 ******************************************************************************/
struct at_noilde_info
{
    struct at_context context;
    unsigned long cur_tick;
};
/*******************************************************************************
 *                        Local function declarations                          *
 ******************************************************************************/
 
static void sig_usr(int signo);
/*******************************************************************************
 *                         Local variable definitions                          *
 ******************************************************************************/
static int at_snap = 3;//atտأĬϿ
static char print_small_str[20] = {0};/*ӡרãֹӡԽ磬ֻӡǰ19ֽ*/

static struct at_context abort_context[AT_ABORT_ARRAY_MAX] = { 0 };
static struct at_noilde_info noidle_info[AT_NOIDLE_ARRAY_MAX] = { 0 };

static  void print_at_statistics(void);
/* ȤĴ洢飬ȤֻҪؼ֣Ҫͣԭ
   ǰ׺ĳ*/
static char interested_at_cmd[][AT_CMD_PREFIX] =
    {
        "COPS",
        "CGACT",
        "ZPDPACT",
        "CPMS",
        "CNMI",
        "CSMS",
        "CSCA",
        "ZMGL",
        "CPBS",
        "SCPBR",
        "SYSCONFIG"
    };
/*******************************************************************************
 *                        Global variable definitions                          *
 ******************************************************************************/
int soctime_switch = SOCTIME_LOG_OFF;
extern int g_smspb_init;
extern int g_need_smspb_init;
/*******************************************************************************
 *                      Local function implementations                         *
 ******************************************************************************/
/* Ȥatƥ*/
static int match_interested_at_cmd(char *data)
{
    int i = 0;
    int tableSize = sizeof(interested_at_cmd)/AT_CMD_PREFIX;

    for(i = 0; i < tableSize; i++)
    {
        if(0 == at_strncmp(data,interested_at_cmd[i], strlen(interested_at_cmd[i])))
        {
            return 1;
        }
    }
    return 0;
}
/* ӡָĽڵϢ*/
static void at_context_print(struct at_context * ct_node)
{
    struct list_head * entry = NULL;
    at_print(AT_ERR,"ch=%p type=%d src=%x msgid=%x para=%p fwdct=%p tick=%ld\n",ct_node->at_channel
             ,ct_node->context_type,ct_node->source,ct_node->msg_id,ct_node->app_param,ct_node->fwd_context,ct_node->cur_tick);
    at_print(AT_ERR,"prefix=%s\n",ct_node->at_cmd_prefix);
    list_for_each(entry,&g_appclt_list)
    {
        if(entry == ct_node->at_proc)
            at_print(AT_ERR,"appclt req_id=%x rsp_id=%x\n",((struct app_clt_ops_t *)entry)->req_msg_id, ((struct app_clt_ops_t *)entry)->rsp_msg_id);
    }
    list_for_each(entry,&g_clt_list)
    {
        if(entry == ct_node->at_proc)
            at_print(AT_ERR,"clt prefix=%s\n",((struct clt_ops_t *)entry)->at_cmd_prefix);
    }
    list_for_each(entry,&g_inform_list)
    {
        if(entry == ct_node->at_proc)
            at_print(AT_ERR,"inform prefix=%s\n",((struct inform_ops_t *)entry)->at_cmd_prefix);
    }
    list_for_each(entry,&g_fwd_list)
    {
        if(entry == ct_node->at_proc)
            at_print(AT_ERR,"fwd prefix=%s\n",((struct fwd_ops_t *)entry)->at_cmd_prefix);
    }
    list_for_each(entry,&g_ser_list2)
    {
        if(entry == ct_node->at_proc)
            at_print(AT_ERR,"ser prefix=%s\n",((struct ser_ops_t2 *)entry)->at_cmd_prefix);
    }
}

#if (APP_OS_TYPE == APP_OS_TOS)
static int at_debug_tos_shell(T_Shell_CommandMessage *CmdMsg )
{
    if (1 == CmdMsg->paraCount && 0 == strcmp((char *)CmdMsg->para[0], "help"))
    {
        at_print(AT_ERR,"at_debug ӡǰATͨ״̬");
        return;
    }
    if (1 == CmdMsg->paraCount && 0 == strcmp((char *)CmdMsg->para[0], "1"))
    {
        at_channel_context_print();
        return;
    }
    ipc_send_message(MODULE_ID_AT_CTL, MODULE_ID_AT_CTL, ATCTL_DEBUG_PRINT_MSG, 0, NULL, 0);
    return;
}
#endif
/*******************************************************************************
 *                      Global function implementations                        *
 ******************************************************************************/
/**
 * @brief ӡרãֹӡԽ磬ֻǰ19ֽ
 * @param 
 * @return 
 * @note   
 * @warning 
 */
char *get_small_str(const char *buff)
{
    strncpy(print_small_str,buff,sizeof(print_small_str)-1);
    print_small_str[19]='\0';
    return print_small_str;
}

/**
 * @brief ͬһģ鷢һ(ȡ)Ϣ
 * @param 
 * @return 
 * @note   
 * @warning 
 */
void save_abort_client_context(struct at_context *context)
{
    static int idx = 0;
    memcpy(&abort_context[idx], context ,sizeof(struct at_context));
    idx++;
    if(idx >= AT_ABORT_ARRAY_MAX)
    {
        idx = 0;
    }
}

/**
 * @brief ָpositionĽڵĵǰʱ
 * @param 
 * @return 
 * @note   ͻȡͨʱ޷ȡͨϢ
 * @warning 
 */
void save_noidle_fd(int position)
{
    struct at_context * ct_node = context_head[position];
    static int idx = 0;
    while(ct_node != NULL)
    {
        memcpy(&noidle_info[idx].context, ct_node ,sizeof(struct at_context));
		at_print(AT_ERR,"prefix=%s, type=%d, tick=%ld\n",ct_node->at_cmd_prefix
             ,ct_node->context_type,ct_node->cur_tick);
#if (APP_OS_TYPE == APP_OS_LINUX)
        noidle_info[idx].cur_tick = get_time_us();
#elif (APP_OS_TYPE == APP_OS_TOS)

        noidle_info[idx].cur_tick = read_persistent_us();
#endif
        ct_node = ct_node->next;
        idx++;
        if(idx >= AT_NOIDLE_ARRAY_MAX)
        {
            idx = 0;
        }
    }
}
/**
 * @brief ָATǰ׺ATϢм
 * @param 
 * @return 
 * @note  ԸȤATмأȤinterested_at_cmdУ
          ʷ¼ΪAT_NETDOG_ARRAY_MAX,at_netdog_flagλΪ1ʱʾ򿪴˹
 * @warning 
 */
int at_netdog_monitor(int fd, char *data, char *at_prefix)
{
    char netdog_flag[3] = {0};
    int temp_count = 0;
    int len = strlen(data);

    if((at_snap & 1) == 0)
        return -1;

    struct at_channel_info * ch_info = at_context_find_chn_by_fd(fd);
    if(ch_info == NULL)
    {
        return -1;
    }
    if(match_interested_at_cmd(at_prefix))
    {
        temp_count = ch_info->at_netdog_count_num;

#if (APP_OS_TYPE == APP_OS_LINUX)

        ch_info->netdog_log[temp_count].cur_tick = get_time_us();
#elif (APP_OS_TYPE == APP_OS_TOS)

        ch_info->netdog_log[temp_count].cur_tick = read_persistent_us();
#endif

        memset(ch_info->netdog_log[temp_count].partial_cmd, 0, AT_NETDOG_AT_CMD_MAX+1);
        snprintf(ch_info->netdog_log[temp_count].partial_cmd, strlen(at_prefix)+3, "[%s]", at_prefix);
        int buf_size = (AT_NETDOG_AT_CMD_MAX-strlen(at_prefix)-2)>len?len:(AT_NETDOG_AT_CMD_MAX-strlen(at_prefix)-2);
        memcpy(ch_info->netdog_log[temp_count].partial_cmd+strlen(ch_info->netdog_log[temp_count].partial_cmd), data, buf_size);

        (ch_info->at_netdog_count_num)++;
        if(ch_info->at_netdog_count_num == AT_NETDOG_ARRAY_MAX)
            ch_info->at_netdog_count_num = 0;
    }
	return 0;
}

/**
 * @brief д뵽ͨͨATм
 * @param 
 * @return 
 * @note  ʷ¼дͶΪAT_MONITOR_ARRAY_MAXat_netdog_flagελΪ1ʱʾ򿪴˹
 * @warning 
 */
int save_monitor_at_buf(int fd, char *buf,int len, AT_TIME_TYPE time_type)
{
    int buf_size = 0;
    int temp_count = 0;

    if((at_snap & 2) == 0)
        return -1;

    struct at_channel_info * ch_info = at_context_find_chn_by_fd(fd);
    if(ch_info == NULL)
    {
        return -1;
    }
    switch(time_type)
    {
    case AT_RECV_TYPE:
        {
            temp_count = ch_info->monitor_log.monitor_read_count_num;
#if (APP_OS_TYPE == APP_OS_LINUX)

            ch_info->monitor_log.read_info[temp_count].cur_read_tick = get_time_us();
#elif (APP_OS_TYPE == APP_OS_TOS)

            ch_info->monitor_log.read_info[temp_count].cur_read_tick = read_persistent_us();
#endif

            buf_size = AT_NETDOG_AT_CMD_MAX>len?len:(AT_NETDOG_AT_CMD_MAX);
            memset(ch_info->monitor_log.read_info[temp_count].read_buf, 0, AT_NETDOG_AT_CMD_MAX+1);
            memcpy(ch_info->monitor_log.read_info[temp_count].read_buf, buf, buf_size);
            ch_info->monitor_log.read_info[temp_count].read_len = len;

            (ch_info->monitor_log.monitor_read_count_num)++;
            if(ch_info->monitor_log.monitor_read_count_num == AT_MONITOR_ARRAY_MAX)
                ch_info->monitor_log.monitor_read_count_num = 0;
            break;
        }
    case AT_SEND_TYPE:
        {
            temp_count = ch_info->monitor_log.monitor_write_count_num;
#if (APP_OS_TYPE == APP_OS_LINUX)

            ch_info->monitor_log.write_info[temp_count].cur_write_tick = get_time_us();
#elif (APP_OS_TYPE == APP_OS_TOS)

            ch_info->monitor_log.write_info[temp_count].cur_write_tick = read_persistent_us();
#endif

            buf_size = AT_NETDOG_AT_CMD_MAX>len?len:(AT_NETDOG_AT_CMD_MAX);
            memset(ch_info->monitor_log.write_info[temp_count].write_buf, 0, AT_NETDOG_AT_CMD_MAX);
            memcpy(ch_info->monitor_log.write_info[temp_count].write_buf, buf, buf_size);
            ch_info->monitor_log.write_info[temp_count].write_len = len;

            (ch_info->monitor_log.monitor_write_count_num)++;
            if(ch_info->monitor_log.monitor_write_count_num == AT_MONITOR_ARRAY_MAX)
                ch_info->monitor_log.monitor_write_count_num = 0;
            break;
        }
    default:
        break;
    }

    return 0;
}

/**
 * @brief ͨϢϢĴӡ
 * @param 
 * @return 
 * @note   
 * @warning 
 */
void at_channel_context_print(void)
{
#ifndef CONFIG_MIN_8M_VERSION
    int i = 0;
    int j = 0;
    struct at_channel_info * ch_node = NULL;
    struct at_context * ct_node = NULL;

    at_print(AT_ERR,"<============ at_debug start ============>\n");

    at_print(AT_ERR,"<============at statistics global============>\n");
    print_at_statistics();
#if (APP_OS_TYPE == APP_OS_LINUX)

    at_print(AT_ERR,"print netdog current tick = %lld\n", get_time_us());
#elif (APP_OS_TYPE == APP_OS_TOS)

    at_print(AT_ERR,"print netdog current tick = %ld\n", read_persistent_us());
#endif

    for(i = 0; i < POSITION_MAX; i++)
    {
        ch_node = at_channel_head[i];
        while(ch_node != NULL)
        {
            if(ch_node->position != i)
            {
                at_print(AT_ERR,"ERROR position %d %d\n",i,ch_node->position);
            }
            at_print(AT_ERR,"=================at_channel_head[%d][%p][fd=%d] info===================\n", i, ch_node,ch_node->at_fd);
            at_print(AT_ERR,"state=%d, reserved=%d\n",ch_node->work_state,ch_node->reserved);
            at_print(AT_ERR,"the earliest index of read monitor=%d, write monitor=%d, netdoginfo=%d\n",
                     ch_node->monitor_log.monitor_read_count_num,ch_node->monitor_log.monitor_write_count_num,ch_node->at_netdog_count_num);
            for(j = 0; j < AT_MONITOR_ARRAY_MAX; j++)
            {
                if(ch_node->monitor_log.read_info[j].cur_read_tick != 0)
                    at_print(AT_ERR,"read monitor tick = %ld, len=%d buf=%s\n", ch_node->monitor_log.read_info[j].cur_read_tick,ch_node->monitor_log.read_info[j].read_len,ch_node->monitor_log.read_info[j].read_buf);
            }
            for(j = 0; j < AT_MONITOR_ARRAY_MAX; j++)
            {
                if(ch_node->monitor_log.write_info[j].cur_write_tick != 0)
                    at_print(AT_ERR,"write monitor tick = %ld, len=%d buf=%s\n",ch_node->monitor_log.write_info[j].cur_write_tick, ch_node->monitor_log.write_info[j].write_len,ch_node->monitor_log.write_info[j].write_buf);
            }
            for(j = 0; j < AT_NETDOG_ARRAY_MAX; j++)
            {
                if(ch_node->netdog_log[j].cur_tick != 0 && strlen(ch_node->netdog_log[j].partial_cmd) != 0)
                    at_print(AT_ERR,"netdoginfo cmd tick = %ld, cmd data=%s\n",ch_node->netdog_log[j].cur_tick,ch_node->netdog_log[j].partial_cmd);
            }
            ch_node = ch_node->next;
        }
    }

    for(i = 0; i < POSITION_MAX; i++)
    {
        ct_node = context_head[i];
        while(ct_node != NULL)
        {
            at_print(AT_ERR,"====================context_head[%d][%p]info===================\n", i, ct_node);
            at_context_print(ct_node);
            ct_node = ct_node->next;
        }
    }

    for(i = 0; i < AT_ABORT_ARRAY_MAX; i++)
    {
        if(abort_context[i].cur_tick == 0)
        {
            continue;
        }
        at_print(AT_ERR,"====================abort_client[%d]===================\n", i);
        at_context_print(&abort_context[i]);
    }
    for(i = 0; i < AT_NOIDLE_ARRAY_MAX; i++)
    {
        if(noidle_info[i].cur_tick == 0)
        {
            continue;
        }
        at_print(AT_ERR,"====================noidle_info[%d]===================\n", i);
        at_context_print(&noidle_info[i].context);
    }
    at_print(AT_ERR,"<============ at_debug end ============>\n");
#endif	
}

//ֵӡ
void other_variable_print()
{
	at_print(AT_ERR,"<============ other variable start ============>\n");
	at_print(AT_ERR,"[sms pb init variable] g_smspb_init: %d, g_need_smspb_init: %d\n", g_smspb_init, g_need_smspb_init);
	at_print(AT_ERR,"<============ other variable end ==============>\n");
}

/* źŴ*/
static void sig_usr(int signo)
{
#if 0//(APP_OS_TYPE == APP_OS_LINUX)
	char snap_flag[3] = {0};
	sc_cfg_get("at_snap_flag",snap_flag,sizeof(snap_flag));
	at_snap = atoi(snap_flag);
	
    if (signo == SIGUSR1)
    {
        at_print(AT_NORMAL,"AT_CTL receive SIGUSR1!\n");
        at_channel_context_print();
		ppp_dial_info();
		channel_info_print();
		other_variable_print();
    }
    else
    {
        at_print(AT_NORMAL,"AT_CTL receive signo %d", signo);
    }
#endif
}

/**
 * @brief ʼatͨ״̬Ϣӡ
 * @param 
 * @return 
 * @note   
 * @warning 
 */
void at_debug_init(void)
{
    char at_debug[5] = {0};
	char snap_flag[3] = {0};
	
    at_print(AT_NORMAL,"<====== AT_CTL start ======>\n");
    at_print(AT_ERR,"AT_CTL build date===>%s,%s\n", __DATE__, __TIME__);


#if (APP_OS_TYPE == APP_OS_LINUX)
	sc_cfg_get("at_snap_flag",snap_flag,sizeof(snap_flag));
	at_snap = atoi(snap_flag);
    if (signal(SIGUSR1, sig_usr) == SIG_ERR)
    {
        at_print(AT_ERR,"ERR: AT_CTL not catch SIGUSR1\n");
    }
#elif (APP_OS_TYPE == APP_OS_TOS)
    if(zOss_AddShellCmd("at_debug", at_debug_tos_shell, "ATͨ״̬ӡ") != ZOSS_SUCCESS)
    {
        return;
    }
#endif
}
//ȡatctlеĹؼ֧ĵȫλͼǷãatctlڲ,ýӿΪset_test_bitmapֵΪatctltest_branch_t
int check_test_bitmap(int test_flag)
{
    char temp[10] = {0};
    int  bitmap;
    sc_cfg_get("test_flag",temp,sizeof(temp));
    bitmap = atoi(temp);
    return (bitmap&(1<<test_flag));
}
//˳׷Ӹ쳣ͳƺȫϢ
struct at_debug_stat at_netdog = {0};
void print_at_statistics(void)
{
    at_print(AT_ERR,"rcv_undesirable_rsp=%d\n",	at_netdog.rcv_undesirable_rsp);

	at_print(AT_ERR,"wait_farps_rsp_timeout=%d\n",at_netdog.wait_farps_rsp_timeout);
	
	at_print(AT_ERR,"channel_info_null=%d\n",		at_netdog.channel_info_null);
	
	at_print(AT_ERR,"farps_cmd_err=%d\n",			at_netdog.farps_cmd_err);
	
	at_print(AT_ERR,"farps_cmd_again=%d\n",		at_netdog.farps_cmd_again);
	
	at_print(AT_ERR,"wait_farps_end_timeout=%d\n",at_netdog.wait_farps_end_timeout);
	
	at_print(AT_ERR,"multicore_write_err=%d\n",	at_netdog.multicore_write_err);

	at_print(AT_ERR,"parase error package=%d\n",	at_netdog.ip_package_err);
	
	at_print(AT_ERR,"recv zero chr=%d\n",	at_netdog.dbg_uart_zero_chr_num);

	at_print(AT_ERR,"recv no print chr=%d\n",	at_netdog.dbg_uart_no_print_num);
}
