/**
 * @file at_register.c
 * @brief at_ctlڲע¼Ľӿʵ֣漰ͻˡת¼עӿڵľʵ
 *
 * Copyright (C) 2017 Sanechips Technology Co., Ltd.
 * @author 
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation. 
 *
 */

/*******************************************************************************
 *                           Include header files                              *
 ******************************************************************************/
#include "at_register.h"

/*******************************************************************************
 *                             Macro definitions                               *
 ******************************************************************************/

/*******************************************************************************
 *                             Type definitions                                *
 ******************************************************************************/
/*******************************************************************************
 *                        Local function declarations                          *
 ******************************************************************************/
/*******************************************************************************
 *                         Local variable definitions                          *
 ******************************************************************************/
/*******************************************************************************
 *                        Global variable definitions                          *
 ******************************************************************************/
/*ڵATעᣬҪATעᣬok_acterr_actڲAT˳շ*/
struct list_head g_clt_list;

/*עתATشתATأҪPDPء
req_actڲв飬װATӦַظڲװӦATдATͨAT_END */
struct list_head g_fwd_list;

/* עеϱ/мϱAT¼*/
struct list_head g_inform_list;


/* עҪʽмϱAT¼ */
struct list_head g_formatinform_list;


/*ⲿMCUͨչATSoCwifiϲӦÿƣҲں˼at_ctlڲ򵥵ʴʽѯ緵NVֵȣ
ڲϲӦüͨ˼Ϣʵּɣ׼ʹøýӿڡ
at_ctlյӦǰ׺ATעreq_rcv_actAT󣬷req_msg_idϢӦķAPP
APPϺ󣬷rsp_msg_idϢat_ctlat_ctlڲrsp_actӦϢĴװATӦ󣬴at_fdͨ͸Զ˿ͻˡ
ϲAPP첽Ϣעʱעat_cmd_prefixreq_rcv_actɣ
ΪNULLҪעǣʱreq_rcv_actӿڲҪAT_ENDսᵱǰATġ*/
struct list_head g_ser_list2;

struct list_head g_ser_list;


/* ͻӦýעӦϢϢӦATװӿ*/
struct list_head g_appclt_list;


/*modemصƽ̨չATעᣬĿǰPDPƽ̨ṩƽ̨չATע*/
struct list_head g_modem_extat_list;

struct list_head g_inform_list0;
struct list_head g_ser_list0;

/*******************************************************************************
*                      Local function implementations                         *
******************************************************************************/
/*******************************************************************************
*                      Global function implementations                        *
******************************************************************************/
/**
 * @brief APPIDҶӦĲڵ
 * @param 
 * @return 
 * @note   g_appclt_listв
 * @warning 
 */
struct app_clt_ops_t *find_extclt_by_msg(int msg_id)
{
    struct app_clt_ops_t *entry;
    list_for_each_entry(entry,&g_appclt_list,list)
    {
        if(entry->req_msg_id == msg_id)
            return entry;
    }
    return NULL;
}
/**
 * @brief ݷעatǰ׺ҶӦڵ
 * @param 
 * @return 
 * @note   g_ser_listв
 * @note   Ӧ÷APP͵ӦϢƥ䵽Ӧķ˽ṹڵ
 * @warning 
 */
struct ser_ops_t2 *find_ser_by_msg(int  rsp_msg_id)
{
    struct ser_ops_t2 *entry;
    list_for_each_entry(entry,&g_ser_list2,list)
    {
        if(entry->rsp_msg_id == rsp_msg_id && entry->context != NULL)
            return entry;
    }
    return NULL;
}

/**
 * @brief ݿͻatǰ׺ҶӦڵ
 * @param 
 * @return 
 * @note   g_clt_listв
 * @warning 
 */
struct clt_ops_t* find_req_by_prefix(void *at_cmd_prefix, int prefix_len)
{
    struct clt_ops_t *entry;
    list_for_each_entry(entry,&g_clt_list,list)
    {
        if(0 == at_strncmp(entry->at_cmd_prefix, (char*)at_cmd_prefix, MAXSTR(entry->at_cmd_prefix, prefix_len)))
            return entry;
    }
    return NULL;
}

/**
 * @brief תatǰ׺ҶӦڵ
 * @param 
 * @return 
 * @note   g_fwd_listв
 * @warning 
 */
struct fwd_ops_t* find_fwd_by_prefix(void *at_cmd_prefix, int prefix_len)
{
    struct fwd_ops_t*entry;
    list_for_each_entry(entry,&g_fwd_list,list)
    {
        if(0 == at_strncmp(entry->at_cmd_prefix, (char*)at_cmd_prefix, MAXSTR(entry->at_cmd_prefix, prefix_len)))
            return entry;
    }
    return NULL;
}

/**
 * @brief ϱ/мatǰ׺ҶӦڵ
 * @param 
 * @return 
 * @note   g_inform_listв
 * @warning 
 */
struct inform_ops_t* find_inform_by_prefix(void *at_cmd_prefix, int prefix_len)
{
    struct inform_ops_t* entry;
    list_for_each_entry(entry,&g_inform_list,list)
    {
        if(0 == at_strncmp(entry->at_cmd_prefix,(char*)at_cmd_prefix, prefix_len))
            return entry;
    }
    return NULL;
}

/**
 * @brief ݷעǰ׺atƥ
 * @param 
 * @return עķ¼ڵ
 * @note  עʱҪȫͬһatĲ̬ͬ(ִУѯԵ)
          עǰ׺ȫƥ
 * @note  g_ser_listв
 * @warning 
 */
struct ser_ops_t2* find_ser2_by_prefix(void *at_cmd_prefix, int prefix_len)
{
    struct ser_ops_t2* entry;
    list_for_each_entry(entry,&g_ser_list2,list)
    {
        //עᵽser_ops_t2еǰ׺ȣпܱȸatǰ׺Ҫ
        if(0 == at_strncmp(entry->at_cmd_prefix, (char*)at_cmd_prefix,MAXSTR(entry->at_cmd_prefix, prefix_len)))
            return entry;
    }
    return NULL;
}

struct ser_ops_t* find_ser_by_prefix(void *at_cmd_prefix, int prefix_len)
{
    struct ser_ops_t* entry;
    list_for_each_entry(entry,&g_ser_list,list)
    {
        //עᵽser2_ops_tеǰ׺ȣпܱȸatǰ׺Ҫ
        if(0 == at_strncmp(entry->at_cmd_prefix, (char*)at_cmd_prefix,MAXSTR(entry->at_cmd_prefix, prefix_len)))
            return entry;
    }
    return NULL;
}


/* չATֻעһ */
struct extat_ser_ops_t* find_extat_by_prefix(void *at_cmd_prefix, int prefix_len)
{
    struct ser_ops_t2* entry;
    list_for_each_entry(entry,&g_modem_extat_list,list)
    {
        if(0 == at_strncmp(entry->at_cmd_prefix, (char*)at_cmd_prefix,MAXSTR(entry->at_cmd_prefix, prefix_len)))
            return entry;
    }
    return NULL;
}


/**
 * @brief ͨOKרͨýϱ׼ڲѯදOK
          װϢresult
 * @param 
 * @return 
 * @note  Ӧʹregister_psclt_funcregister_serv_func2register_extclt_funcעʱ
          Ľ룬ӦҪעܴýrsp_msg_idģrsp_msg_idNULL
 * @note  result 0:OK;1:ERROR
 * @warning 
 */
int rsp_common_ok(char *at_paras,struct at_context *context,void **next_req,int *next_len)
{
    int *result = NULL;

    result = malloc(sizeof(int));
    if(result == NULL)
    {
        softap_assert("");
		return	AT_END;
    }
    *result=0;
    //װӦϢϱӦAPPӦAPPĽҪܴϢ
    *next_req = result;
    *next_len = sizeof(result);
    return  AT_END;
}

/**
 * @brief ͨERRרͨýϱ׼ڲѯදERROR
 * @param 
 * @return 
 * @note  ͬrsp_common_ok
 * @warning 
 */
int rsp_common_err(char *at_paras,struct at_context *context,void **next_req,int *next_len)
{
    int *result = NULL;

    at_print(AT_NORMAL,"rsp_common_err error_code:%s\n",at_paras);
    result = malloc(sizeof(int));
    if(result == NULL)
    {
        softap_assert("");
		return	AT_END;
    }
    *result=1;
    //װӦϢϱӦAPPӦAPPĽҪܴϢ
    *next_req = result;
    *next_len = sizeof(result);
    return  AT_END;
}

/**
 * @brief ѯදOK
 * @param 
 * @return 
 * @note  ش룬أעʱΪNULL
 * @warning 
 */
int query_common_ok(char *at_paras,struct at_context *context,void **next_req,int *next_len)
{
    return  AT_END;
}

/**
 * @brief ѯදERROR
 * @param 
 * @return 
 * @note  ش룬أעʱΪNULL
 * @warning 
 */
int query_common_err(char *at_paras,struct at_context *context,void **next_req,int *next_len)
{
    at_print(AT_NORMAL,"query_common_err error_code:%s\n",at_paras);
    return  AT_END;
}

/*ⲿͷǵչATעᣬĿǰûⷢʹʱ!
ͻ˷req_msg_idϢat_ctlat_ctlڲϢIDҵӦreq_procӿڣATķ͡
at_ctlյokerrмϱʱֱעok_act,err_actauto_actinform_actӦм
Ϣģat_cmd_prefixinform_actмinform_actΪNULL */
int  register_extclt_func(int position,char *at_cmd_prefix,int req_msg_id,int rsp_msg_id,clt_req_func req_proc,clt_ok_func  ok_act,clt_err_func  err_act, inform_act_func inform_act)
{
    struct app_clt_ops_t *clt_node = find_extclt_by_msg(req_msg_id);

    if(clt_node)
    {
        if(clt_node->rsp_msg_id!= rsp_msg_id || clt_node->req_act != req_proc || clt_node->position != position)
        {
            softap_assert("duplicate register_extclt");
        }

        return -1;
    }

    clt_node =(struct app_clt_ops_t *)malloc(sizeof(struct app_clt_ops_t ));
    if(!clt_node){
        softap_assert("malloc fail  ");
        return -1;
    }
    memset(clt_node,0,sizeof(struct app_clt_ops_t ));
    clt_node->position = position;
    clt_node->req_msg_id = req_msg_id;
    clt_node->rsp_msg_id = rsp_msg_id;
    clt_node->req_act = req_proc;
    list_add_tail((struct list_head *)clt_node,&g_appclt_list);
    if(at_cmd_prefix)
        register_clt_func(at_cmd_prefix,ok_act,err_act);

    if(at_cmd_prefix&&inform_act)
        register_inform_func(at_cmd_prefix,inform_act);
    return 0;
}

/*PSصƽ̨Ϣעƣreq_procϢATװ
ڲʧܻظҪںڲsend_rsp_msgӿڽӦϢATķͣNULL*/
int  register_psclt_func(int  req_msg_id,int rsp_msg_id,clt_req_func req_proc)
{
    struct app_clt_ops_t *clt_node =(struct app_clt_ops_t *)malloc(sizeof(struct app_clt_ops_t ));

    if(!clt_node){
        softap_assert("malloc fail  ");
        return -1;
    }
    memset(clt_node, 0, sizeof(struct app_clt_ops_t ));

    clt_node->position = NEAR_PS;
    clt_node->req_msg_id = req_msg_id;
    clt_node->rsp_msg_id = rsp_msg_id;
    clt_node->req_act = req_proc;
    list_add_tail((struct list_head *)clt_node,&g_appclt_list);
    return 0;
}
struct extat_ser_ops_t *find_modem_open_extat_by_msg(int msg_id)
{
    struct extat_ser_ops_t *entry;
    list_for_each_entry(entry,&g_modem_extat_list,list)
    {
        if(entry->req_msg_id == msg_id)
            return entry;
    }
    return NULL;
}
/*modemصƽ̨չATעᣬĿǰPDPƽ̨ṩƽ̨չATע
жӦϢṹ壬ǰ4ֽڱΪ룬ָʾɹһͳ룻
һmodem_errȫֱrcvmsg_rsp_at_clientндֵת뼰ATӦװ뷢͡ */
int  reg_modem_opencpu_extat(char *at_cmd_prefix, int  req_msg_id,parse_at2msg_func parse_proc, parse_msg2at_func rsp_proc)
{
    struct extat_ser_ops_t *ser_node = NULL;

    if(at_cmd_prefix != NULL)
    {
        ser_node = (struct extat_ser_ops_t *)malloc(sizeof(struct extat_ser_ops_t));
        if(!ser_node){
            softap_assert("malloc fail  ");
			return -1;
        }
        if(find_extat_by_prefix(at_cmd_prefix, strlen(at_cmd_prefix)))
            softap_assert("duplicate at_cmd_prefix");

        memset(ser_node, 0, sizeof(struct extat_ser_ops_t));
        strncpy(ser_node->at_cmd_prefix, at_cmd_prefix,AT_CMD_PREFIX-1);
        ser_node->req_msg_id =  req_msg_id;
        ser_node->parse_act =  parse_proc;	
        ser_node->rsp_proc =  rsp_proc;

        list_add_tail((struct list_head *)ser_node,&g_modem_extat_list);
    }
    return 0;
}

/*ڵATעᣬҪATעᣬok_acterr_actڲAT˳շ*/
int  register_clt_func(char *at_cmd_prefix,clt_ok_func  ok_act,clt_err_func  err_act)
{
    struct clt_ops_t *send_req_node =(struct clt_ops_t *)malloc(sizeof(struct clt_ops_t ));
    if(!send_req_node){
        softap_assert("malloc fail  ");
		return -1;
    }
    if(find_req_by_prefix(at_cmd_prefix, strlen(at_cmd_prefix)))
    {
        free(send_req_node);
        at_print(AT_ERR,"ERR: duplicate at_cmd_prefix: %s\n",at_cmd_prefix);
        //softap_assert("duplicate at_cmd_prefix");
        return -1;

    }
    memset(send_req_node,0,sizeof(struct clt_ops_t ));
    strncpy(send_req_node->at_cmd_prefix,at_cmd_prefix,AT_CMD_PREFIX-1);
    send_req_node->err_act = err_act;
    send_req_node->ok_act = ok_act;
    list_add_tail((struct list_head *)send_req_node,&g_clt_list);
    return 0;
}

/*עתATشתATأҪPDPء
req_actڲв飬װATӦַظڲװӦATдATͨAT_END */
int  register_fwd_func(char *at_cmd_prefix,fwd_req_func  req_act,fwd_ok_func  ok_act ,fwd_err_func  err_act)
{
    struct fwd_ops_t *at_forward_node =(struct fwd_ops_t *)malloc(sizeof(struct fwd_ops_t ));
    if(!at_forward_node){
        softap_assert("malloc fail  ");
		return -1;
    }
    if(find_fwd_by_prefix(at_cmd_prefix, strlen(at_cmd_prefix)))
        softap_assert("duplicate at_cmd_prefix");
    memset(at_forward_node,0,sizeof(struct fwd_ops_t ));
    strncpy(at_forward_node->at_cmd_prefix,at_cmd_prefix,AT_CMD_PREFIX-1);
    at_forward_node->req_act = req_act;
    at_forward_node->err_act= err_act;
    at_forward_node->ok_act= ok_act;
    list_add_tail((struct list_head *)at_forward_node,&g_fwd_list);
    return 0;
}

/*עϱAT¼ѯмϱϱ */
int  register_inform_func(char *at_cmd_prefix, inform_act_func inform_act)
{
    struct inform_ops_t *rcv_inform_node = find_inform_by_prefix(at_cmd_prefix, strlen(at_cmd_prefix));

    if(inform_act == NULL)
    {
        softap_assert("");
    }
    if(rcv_inform_node)
    {    	
        if(rcv_inform_node->inform_act != inform_act)
        {
			at_print(AT_ERR,"ERR: duplicate register_inform_func at_cmd_prefix: %s\n",at_cmd_prefix);
        }
        else
        {
            return -1;
        }
    }
    rcv_inform_node = (struct inform_ops_t *)malloc(sizeof(struct inform_ops_t ));
    if(!rcv_inform_node){
        softap_assert("malloc fail  ");
		return -1;
    }
    memset(rcv_inform_node,0,sizeof(struct inform_ops_t ));
    strncpy(rcv_inform_node->at_cmd_prefix,at_cmd_prefix,AT_CMD_PREFIX-1);
    rcv_inform_node->inform_act = inform_act;
    list_add_tail((struct list_head *)rcv_inform_node,&g_inform_list);
    return 0;
}

/*ⲿMCUͨչATSoCwifiϲӦÿƣҲں˼at_ctlڲ򵥵ʴʽѯ緵NVֵȣ
ڲϲӦüͨ˼Ϣʵּɣ׼ʹøýӿڡ
at_ctlյӦǰ׺ATעreq_rcv_actAT󣬷req_msg_idϢӦķAPP
APPϺ󣬷rsp_msg_idϢat_ctlat_ctlڲrsp_actӦϢĴװATӦ󣬴at_fdͨ͸Զ˿ͻˡ
ϲAPP첽Ϣעʱעat_cmd_prefixreq_rcv_actɣ
ΪNULLҪעǣʱreq_rcv_actӿڲҪAT_ENDսᵱǰATġ*/
int  register_serv_func2(char *at_cmd_prefix,int  module_id,int  req_msg_id,int  rsp_msg_id,ser_req_func2 req_rcv_act,app_rsp_proc   rsp_act)
{
    struct ser_ops_t2 *rcv_req_node =(struct ser_ops_t2 *)malloc(sizeof(struct ser_ops_t2));
    if(!rcv_req_node){
        softap_assert("malloc fail  ");
		return -1;
    }
    if(find_ser2_by_prefix(at_cmd_prefix, strlen(at_cmd_prefix)))
        softap_assert("duplicate at_cmd_prefix");

    rcv_req_node->context =  NULL;
    memset(rcv_req_node,0,sizeof(struct ser_ops_t2));
    strncpy(rcv_req_node->at_cmd_prefix,at_cmd_prefix,AT_CMD_PREFIX-1);
    rcv_req_node->module_id = module_id;
    rcv_req_node->req_msg_id =  req_msg_id;
    rcv_req_node->rsp_msg_id =  rsp_msg_id;
    rcv_req_node->req_rcv_act =  req_rcv_act;
    rcv_req_node->rsp_act = rsp_act;

    list_add_tail((struct list_head *)rcv_req_node,&g_ser_list2);
    return 0;
}

/**
 * @brief עûοķAT֧ͬ첽ִʽ
 * @param at_cmd_prefix	ATǰ׺ָ
 * @param module_id      Դģid
 * @return intͽ
 * @retval ɹ 0
 * @note עắregister_serv_func2ֻat_cmd_prefixmodule_idreq_rcv_act
 *  at_ctlյAT󣬵עreq_rcv_actat_ctlܷشֱӽ뷢͸ⲿMCU
 յⲿ͵ATͨϢMSG_CMD_SEND_REQ_TO_APP͸Ӧã 
 Ӧôͨúsend_rsp_str_to_farpsat_ctlӦ͵ⲿMCU
 */
int  register_serv_func(char *at_cmd_prefix, int  module_id, ser_req_func req_rcv_act)
{
	struct ser_ops_t *rcv_req_node =(struct ser_ops_t *)malloc(sizeof(struct ser_ops_t));
	if(!rcv_req_node){
		softap_assert("malloc fail	");
		return -1;
	}
	if(find_ser_by_prefix(at_cmd_prefix, strlen(at_cmd_prefix)))
		softap_assert("duplicate at_cmd_prefix");

	memset(rcv_req_node,0,sizeof(struct ser_ops_t));
	strncpy(rcv_req_node->at_cmd_prefix,at_cmd_prefix,AT_CMD_PREFIX-1);
	rcv_req_node->module_id = module_id;	
	rcv_req_node->req_rcv_act = req_rcv_act;
	
	list_add_tail((struct list_head *)rcv_req_node,&g_ser_list);
	return 0;
}


/*עϱATĸʽⲿMCUATmodemصмⲿMCUĸʽҪ
Ҫat_ctlת*/
int  register_formatInform_func(char *at_cmd_prefix, format_inform_func inform_act)
{
    struct formatinform_ops_t *rcv_inform_node = NULL;
	struct formatinform_ops_t * entry;

	if(inform_act == NULL)
	{
	   softap_assert("");
	}

	list_for_each_entry(entry,&g_formatinform_list,list)
    {
        if(0 == at_strncmp(entry->at_cmd_prefix,at_cmd_prefix,  strlen(at_cmd_prefix)))
            rcv_inform_node = entry;
    }
   
    if(rcv_inform_node)
    {       
       softap_assert("duplicate at_cmd_prefix");        
    }
    rcv_inform_node = (struct formatinform_ops_t *)malloc(sizeof(struct formatinform_ops_t));
    if(!rcv_inform_node){
        softap_assert("malloc fail  ");
		return -1;
    }
    memset(rcv_inform_node,0,sizeof(struct formatinform_ops_t ));
    strncpy(rcv_inform_node->at_cmd_prefix,at_cmd_prefix,AT_CMD_PREFIX-1);
    rcv_inform_node->inform_act = inform_act;
    list_add_tail((struct list_head *)rcv_inform_node,&g_formatinform_list);
    return 0;
}


//طӦⲿĿģIDΪʱװӦATдATͨϢĿģ
int send_rsp_msg(int dst_id,unsigned short req_cmd,unsigned short rsp_cmd,unsigned short datalen,unsigned char *pData)
{
	//еƽ̨ϢӦϢ ֧zpdpactget_modem_info
	if(0 == check_is_fd(dst_id)&& rsp_cmd != 0 && (dst_id < MODULE_ID_ATDYNAMIC_BASE || dst_id > MODULE_ID_ATDYNAMIC_END))
	{
		int err_ret = AT_RSP_ERR;
		int unix_sockfd = get_unix_sockfd(dst_id);
		//δֵĻΪȱʡ!!!!!!!!!!!!!!!!!!!!!!
		if(datalen == 0)
        {   
            if(unix_sockfd>=0)
            {
                unix_send_proc(unix_sockfd, dst_id, rsp_cmd, 4, &err_ret,0);
            }
            else
            {
			    ipc_send_message(MODULE_ID_AT_CTL,dst_id,rsp_cmd,4,&err_ret,0);
            }
        }
		else
        {    
            if(unix_sockfd >= 0)
            {
                unix_send_proc(unix_sockfd, dst_id, rsp_cmd, datalen, pData,0);
            }
            else
            {
			    ipc_send_message(MODULE_ID_AT_CTL,dst_id,rsp_cmd,datalen,pData,0);
            }
        }
	}
	//ĿģΪATͨװӦATдͨ ֧zpdpactget_modem_info
	else if(1 == check_is_fd(dst_id) || (dst_id >= MODULE_ID_ATDYNAMIC_BASE && dst_id <= MODULE_ID_ATDYNAMIC_END))
	{
		struct extat_ser_ops_t *nod = find_modem_open_extat_by_msg(req_cmd);
		if(nod == NULL)
		{
			softap_assert("cmdid %d has no AT registr!!!!", req_cmd);
			return 0;
		}

		//δעӦ޽룬Ϊɹ˴з
		if(rsp_cmd==0 || datalen==0 || pData==NULL)
			at_context_write_data(dst_id,"\r\nOK\r\n",strlen("\r\nOK\r\n"));
		else
		{
			char *rsp_at = NULL;			
			
			if(nod && nod->rsp_proc)
				nod->rsp_proc(pData, &rsp_at);
			if(rsp_at == NULL)
			{
				if(datalen>=4 && *((int *)pData) == 0)
					at_context_write_data(dst_id,"\r\nOK\r\n",strlen("\r\nOK\r\n"));
				else//ŷڴ˴ƽ̨
				{				
					char* err_str = at_err_build(ATERR_PROC_FAILED);
					at_context_write_data(dst_id, err_str,strlen(err_str));
		            free(err_str);					
					at_print(AT_ERR,"ERR: send_rsp_msg rsp_proc can not create rsp at \n");
				}
			}
			else
			{
				at_context_write_data(dst_id,rsp_at,strlen(rsp_at));
				free(rsp_at);
			}
		}			
	}

	return 0;
}

struct ser_ops_t0 *find_ser_by_msg_modid0(int  rsp_msg_id, int module_id)
{
    struct ser_ops_t0 *entry;
    list_for_each_entry(entry,&g_ser_list0,list)
    {
        if(entry->rsp_msg_id == rsp_msg_id && entry->context != NULL && entry->module_id == module_id)
            return entry;
    }
    return NULL;
}

struct ser_ops_t0* find_ser_by_prefix0(void *at_cmd_prefix, int prefix_len)
{
    struct ser_ops_t0* entry;
    list_for_each_entry(entry,&g_ser_list0,list)
    {
        //עᵽser_ops_t2еǰ׺ȣпܱȸatǰ׺Ҫ
        if(0 == at_strncmp(entry->at_cmd_prefix, (char*)at_cmd_prefix,MAXSTR(entry->at_cmd_prefix, prefix_len)))
            return entry;
    }
    return NULL;
}

int  register_inform_func0(char *at_cmd_prefix,int  module_id, int  req_msg_id)
{
    struct inform_ops_t0 *rcv_inform_node;
    list_for_each_entry(rcv_inform_node,&g_inform_list0,list)
    {
        if(0 == at_strncmp(rcv_inform_node->at_cmd_prefix,(char*)at_cmd_prefix, strlen(at_cmd_prefix)))
        {
            if(rcv_inform_node->req_msg_id != req_msg_id || rcv_inform_node->module_id != module_id)
            {
                at_print(AT_ERR,"ERR: duplicate register_inform_func at_cmd_prefix: %s msg=%x\n",at_cmd_prefix,rcv_inform_node->req_msg_id);
                continue;
            }
            else
            {
                return -1;
            }
        }
    }

    rcv_inform_node = (struct inform_ops_t0 *)malloc(sizeof(struct inform_ops_t0 ));
    if(!rcv_inform_node){
        softap_assert("malloc fail  ");
		return -1;
    }
    memset(rcv_inform_node,0,sizeof(struct inform_ops_t0 ));
    strncpy(rcv_inform_node->at_cmd_prefix,at_cmd_prefix,AT_CMD_PREFIX-1);
    rcv_inform_node->req_msg_id = req_msg_id;
    rcv_inform_node->module_id = module_id;
    list_add_tail((struct list_head *)rcv_inform_node,&g_inform_list0);
    return 0;
}

int  unregister_inform_func0(char *at_cmd_prefix, int  req_msg_id)
{
    struct inform_ops_t0 *rcv_inform_node;
    list_for_each_entry(rcv_inform_node,&g_inform_list0,list)
    {
        if(0 == at_strncmp(rcv_inform_node->at_cmd_prefix,(char*)at_cmd_prefix, strlen(at_cmd_prefix)))
        {
            if(rcv_inform_node->req_msg_id == req_msg_id)
            {
                list_del((struct list_head *)rcv_inform_node);
                free(rcv_inform_node);
                return 0;
            }
        }
    }
    return -1;
}

int  register_serv_func0(char *at_cmd_prefix,int  module_id,int  req_msg_id,int  rsp_msg_id)
{
    struct ser_ops_t0 *rcv_req_node;
    
    if(find_ser_by_prefix0(at_cmd_prefix, strlen(at_cmd_prefix)))
    {
        at_print(AT_ERR,"ERR: duplicate register_serv_func0 prefix: %s\n",at_cmd_prefix);
        return -1;
    }
    rcv_req_node =(struct ser_ops_t0 *)malloc(sizeof(struct ser_ops_t0));
    if(!rcv_req_node)
    {
        softap_assert("malloc fail  ");
        return -1;
    }
    rcv_req_node->context = NULL;
    memset(rcv_req_node,0,sizeof(struct ser_ops_t0));
    strncpy(rcv_req_node->at_cmd_prefix,at_cmd_prefix,AT_CMD_PREFIX-1);
    rcv_req_node->module_id = module_id;
    rcv_req_node->req_msg_id =  req_msg_id;
    rcv_req_node->rsp_msg_id =  rsp_msg_id;

    list_add_tail((struct list_head *)rcv_req_node,&g_ser_list0);
    return 0;
}

int  unregister_serv_func0(char *at_cmd_prefix, int  req_msg_id)
{
    struct ser_ops_t0 *rcv_req_node;
    list_for_each_entry(rcv_req_node,&g_ser_list0,list)
    {
        if(0 == at_strncmp(rcv_req_node->at_cmd_prefix,(char*)at_cmd_prefix, strlen(at_cmd_prefix)))
        {
            if(rcv_req_node->req_msg_id == req_msg_id)
            {
                list_del((struct list_head *)rcv_req_node);
                free(rcv_req_node);
                return 0;
            }
        }
    }
    return -1;
}


