/**
 * @file at_timeout.c
 * @brief at_ctlڲʱʵֽӿ
 *
 * Copyright (C) 2017 Sanechips Technology Co., Ltd.
 * @author 
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation. 
 *
 */

/*******************************************************************************
 *							 Include header files							   *
 ******************************************************************************/
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include "at_com.h"
#include "softap_api.h"
#include "at_context.h"
#include "ps_pdp.h"
#if (APP_OS_TYPE == APP_OS_LINUX)
#include "cfg_api.h"
#include "soft_timer.h"
#endif

#include <limits.h>

/*******************************************************************************
 *                             Macro definitions                               *
 ******************************************************************************/
#define MAX_TRY_TIME    10 //Դ
#ifndef IPC_NOWAIT
#define IPC_NOWAIT      04000
#endif

//pdpʱʱʱ,ʼʱΪ5s
#define PDPRECONNECT_BASE_TIME 5000
//ʱʱʱΪ20s
#define MAX_RECONNECT_TIME 20000

/*******************************************************************************
 *                             Type definitions                                *
 ******************************************************************************/
typedef void *(*at_timer_fnc)(void *);  /* ʱص   */

/* ʱʱϢ */
struct req_waitmsg
{
    struct list_head list;
    MSG_BUF msg_buf;
};
/*******************************************************************************
 *                        Local function declarations                          *
 ******************************************************************************/
static void *QueryTimer(void * arg);
static void* delayed_msg_timeout(void * arg);
static void* at_pdpreconnect_proc(void * arg);

/*******************************************************************************
 *                         Local variable definitions                          *
 ******************************************************************************/
/* 󻺴еĶʱid*/
static void *waittimer_id = NULL;

/* pdpӶʱȱʡʱ*/
static int pdpreconnect_time = PDPRECONNECT_BASE_TIME;

/* ǰpdp󻺴еĶʱǷѾ*/
static int at_waittimer_start = 0;


/* pdpδɣµpdpǰ
 * 󻺴ڸöеУڶʱڳʱ֮Ϣ̴̣߳߳лϢ
  */
static LIST_HEAD(at_timer_waitqueue);

/* ǰ󻺴Уڿͻ޷䵽atͨ,ǰ󻺴ڸöе,ͨͷʱû
*/
static LIST_HEAD(at_nochannel_waitqueue);

USHORT get_timerID_by_fd(int fd);
/*******************************************************************************
 *                        Global variable definitions                          *
 ******************************************************************************/
extern struct defcid_mng_t g_defcid_mng;
extern int fwd_fd;
extern int g_smspb_init;
extern int g_need_smspb_init;
extern int g_support_sms;
extern int g_support_pb;

/*******************************************************************************
*                      Local function implementations                         *
******************************************************************************/
static void *QueryTimer(void * arg)
{
    unsigned char tmp[64] = {0};
    //ڸҪtmp

    ipc_send_message(MODULE_ID_AT_CTL,MODULE_ID_AT_CTL,ATCTL_INNER_PERIO_QUERY_MSG,sizeof(tmp),tmp,0);
    return 0;
}

/* Ϣ̣߳󻺴еĴ*/
static void* delayed_msg_timeout(void * arg)
{
    ipc_send_message(MODULE_ID_AT_CTL, MODULE_ID_AT_CTL, ATCTL_DELAY_TIMEOUT_MSG, 0, NULL, IPC_NOWAIT);
    return 0;
}
/* Ϣ̣߳PDP¼Ĵ*/
static void* at_pdpreconnect_proc(void * arg)
{
	return proc_pdpreconnect_req();
}

/*******************************************************************************
 *                      Global function implementations                        *
 ******************************************************************************/
/**
 * @brief Ϣʱѯ
 * @param 
 * @return 
 * @note  at_ctlеãڲatquerytimenvֵȷǷʱ:
		  atquerytimeΪ0ʱʾҪʱ
		  atquerytime0ʱʱҶʱһֱЧ
		  öʱΪڴat_ctlѯĳЩ״̬źǿȣѯ浽ӦnvУԹ
		  webuimmiѯȡ
		  ʱʱʱʱ״̬ѯеСѯʱ䡣
 * @warning 
 */
void at_timeout_start_perio_query(void)
{
    int QueryWaitTime = 0;
    char nv_query_time[30] = {0};
#if (APP_OS_TYPE == APP_OS_LINUX)

    sc_cfg_get("atquerytime", nv_query_time, sizeof(nv_query_time));
    QueryWaitTime = atoi(nv_query_time);
#if 1    // kw 3 SV.TAINTED.CALL.BINOP
    if(QueryWaitTime < 0 || QueryWaitTime > INT_MAX-1)
    {
        QueryWaitTime = 0;
    }
#endif    
    
    if(QueryWaitTime > 0)
        sc_timer_create(AtTimerID, TIMER_FLAG_RESTART, QueryWaitTime, QueryTimer, NULL);
#endif
}
/*ӳٴϢһõ㣬ǳʱʱ䵽*/
void delayed_msg_proc(void)
{
    struct list_head *head = NULL;
    struct list_head *pnext = NULL;
    struct list_head *temp = NULL;
	struct list_head bak_wait_queue;
    
	if(at_waittimer_start == 0)
		return;
#if (APP_OS_TYPE == APP_OS_LINUX)

    sc_timer_delete(waittimer_id);
#elif (APP_OS_TYPE == APP_OS_TOS)

    zOss_StopTimer(waittimer_id);
#endif
	at_waittimer_start = 0;
    head = &at_timer_waitqueue;

    if(list_empty(head))
    {
        at_print(AT_ERR,"ERR: delayed_msg_proc is empty\n");
        return;
    }
    else
    {
        //ȫֵʱͷԭȫͷ
        list_replace_init(&at_timer_waitqueue,&bak_wait_queue);
        head = &bak_wait_queue;
        pnext = head->next;
        do
        {
            MSG_BUF *msg_buf = NULL;
            temp = pnext;
            pnext = pnext->next;
            list_del(temp);
            msg_buf = &(((struct req_waitmsg *)temp)->msg_buf);
            rcv_msg_proc(msg_buf);
            free(temp);
        }
        while(pnext != head);
    }
    return;
}
/**
 * @brief ϢʱȴУʱȴ
 * @param 
 * @return 
 * @note   
 * @warning 
 */
int add_one_delayed_msg(MSG_BUF *msg)
{
    int ret = 0;
    int WaitTime = 1000;
    struct req_waitmsg *waitmsg = malloc(sizeof(struct req_waitmsg));
	if(waitmsg == NULL)
		return -1;
    memset(waitmsg, 0x00, sizeof(struct req_waitmsg));
    memcpy(&waitmsg->msg_buf, msg, sizeof(MSG_BUF));
    
    list_add(&waitmsg->list, &at_timer_waitqueue);
    
    at_print(AT_DEBUG,"timer list_add  source is %x, cmd is %x!!!\n", msg->src_id, msg->usMsgCmd);
    if(at_waittimer_start == 0)
    {
        if(NULL == waittimer_id)
        {
#if (APP_OS_TYPE == APP_OS_LINUX)
            waittimer_id = AtWaitTimerID;
#elif (APP_OS_TYPE == APP_OS_TOS)

            waittimer_id = zOss_CreateTimer("AtWaitTimerID", delayed_msg_timeout, NULL, TRUE);
#endif

        }

#if (APP_OS_TYPE == APP_OS_LINUX)
        ret = sc_timer_create(waittimer_id, TIMER_FLAG_RESTART, WaitTime, delayed_msg_timeout, NULL);
#elif (APP_OS_TYPE == APP_OS_TOS)

        ret = zOss_StartTimer((ZOSS_TIMER_ID)waittimer_id, WaitTime, delayed_msg_timeout, NULL);
#endif

    }

    if(ret == 0)
    {
        at_waittimer_start = 1;
    }
    else
    {
        at_print(AT_ERR,"ERR: start_resend_msg start timer fail!\n");
        softap_assert("");
    }
    return ret;
}


/*ԻϢĴһõ㣬ͨͷ*/
void cache_msg_proc(void)
{
    struct list_head *head = NULL;
    struct list_head *pnext = NULL;
    struct list_head *temp = NULL;
	struct list_head bak_wait_queue;    
	int fwd_fd_temp = fwd_fd;	
		
    head = &at_nochannel_waitqueue;

    if(list_empty(head))
    {
        at_print(AT_DEBUG,"cache_msg_proc is empty\n");
        return;
    }
    else
    {
        //ȫֵʱͷԭȫͷ
        list_replace_init(&at_nochannel_waitqueue,&bak_wait_queue);
        head = &bak_wait_queue;
        pnext = head->next;
        do
        {
            MSG_BUF *msg_buf = NULL;
            temp = pnext;
            pnext = pnext->next;
            list_del(temp);
            msg_buf = &(((struct req_waitmsg *)temp)->msg_buf);
			at_print(AT_ERR,"cache_msg_proc proc\n");
            rcv_msg_proc(msg_buf);
            free(temp);
        }
        while(pnext != head);
		//ָ֮ǰϵתȫ
		fwd_fd = fwd_fd_temp;
    }
    return;
}

/**
ϢȴУͨͷʱϢ
 */
int add_one_cache_msg(MSG_BUF *msg)
{
    struct req_waitmsg *waitmsg = malloc(sizeof(struct req_waitmsg));
	if(waitmsg == NULL)
		return -1;
    memset(waitmsg, 0x00, sizeof(struct req_waitmsg));
    memcpy(&waitmsg->msg_buf, msg, sizeof(MSG_BUF));
    
    list_add(&waitmsg->list, &at_nochannel_waitqueue);
    
    at_print(AT_ERR,"timer list_add  source is %x, cmd is %x!!!\n", msg->src_id, msg->usMsgCmd);
    return 0;
}


/**
 * @brief λPDPʱʱ
 * @param 
 * @return 
 * @note   
 * @warning 
 */
void at_timeout_reset_pdpreconn_time(void)
{
    pdpreconnect_time = PDPRECONNECT_BASE_TIME;
}

/**
 * @brief PDPʱ
 * @param 
 * @return 
 * @note   
 * @warning 
 */
int at_timeout_start_pdpreconn_timer(void)
{
    int ret = 0;
    int max_reconnrct_time = MAX_RECONNECT_TIME;
    char creg_stat[20] = {0};
	char cereg_stat[20] = {0};
    char reconnect_time[20] = {0};

    sc_cfg_get("cgreg_stat", creg_stat, sizeof(creg_stat));
	sc_cfg_get("cereg_stat", cereg_stat, sizeof(cereg_stat));
    at_print(AT_DEBUG,"@@@@@@@@@@@@@at_timeout_start_pdpreconn_timer  creg stat=%s, cereg stat=%s!\n",creg_stat,cereg_stat);
	//zhangfen 1106 CS&EPSעʧܣʱ,Ҫʱ
	if(1 != atoi(creg_stat) && 5 != atoi(creg_stat) && 1 != atoi(cereg_stat) && 5 != atoi(cereg_stat))
	{
		return 0;
	}

	
    sc_cfg_get("max_reconnect_time", reconnect_time, sizeof(reconnect_time));
    if(atoi(reconnect_time) > 0)
    {
        max_reconnrct_time = atoi(reconnect_time);
    }
    if(pdpreconnect_time > max_reconnrct_time)
    {
        pdpreconnect_time = max_reconnrct_time;
    }

    if(NULL == g_defcid_mng.pdpreconnect_timerid)
    {
#if (APP_OS_TYPE == APP_OS_LINUX)
        g_defcid_mng.pdpreconnect_timerid = AutoPdpActTimerID;
#elif (APP_OS_TYPE == APP_OS_TOS)

        g_defcid_mng.pdpreconnect_timerid = zOss_CreateTimer("AutoPdpActTimerID", at_pdpreconnect_proc, NULL, TRUE);
#else
        //pdpreconnect_timerid = zOss_CreateTimer("AutoPdpActTimerID", at_pdpreconnect_proc, NULL, TRUE);
#endif

    }
    else
    {
#if (APP_OS_TYPE == APP_OS_LINUX)
        sc_timer_delete(g_defcid_mng.pdpreconnect_timerid);
#elif (APP_OS_TYPE == APP_OS_TOS)

        zOss_StopTimer(g_defcid_mng.pdpreconnect_timerid);
#else
        //zOss_StopTimer(pdpreconnect_timerid); goo
#endif

    }

#if (APP_OS_TYPE == APP_OS_LINUX)
    ret = sc_timer_create(g_defcid_mng.pdpreconnect_timerid, TIMER_FLAG_ONCE, pdpreconnect_time, at_pdpreconnect_proc, NULL);
#elif (APP_OS_TYPE == APP_OS_TOS)

    ret = zOss_StartTimer((ZOSS_TIMER_ID)g_defcid_mng.pdpreconnect_timerid, pdpreconnect_time, at_pdpreconnect_proc, NULL);
#else
    //ret = zOss_StartTimer((ZOSS_TIMER_ID)pdpreconnect_timerid, pdpreconnect_time, at_pdpreconnect_proc, NULL);
#endif

    pdpreconnect_time = pdpreconnect_time*2;

    if(ret != 0)
    {
        at_print(AT_ERR,"ERR:start_resend_msg start timer fail!\n");
        softap_assert("");
    }
    return ret;

}


void timeout_proc_wait_outside_rsp(MSG_BUF *msg_buf)
{
	int at_fd = *(int *)(msg_buf->aucDataBuf);	
	struct at_context *up_context = at_context_find_ctx_by_fd_type(at_fd, AT_FWD_UP);
	char *at_str = NULL;

	at_print(AT_ERR,"at_fd: %d!!!!\n", at_fd);

	if(up_context == NULL)//Ҳup_contextֱӷ
	{
		return;
	}
	//쳬ʱ͸Ӧ
	at_str = at_err_build(ATERR_WAIT_RSP_TIMEOUT);
	at_context_write_data(up_context->at_channel->at_fd,at_str,strlen(at_str));
	free(at_str);	

	//ͷcontextμ	
	at_context_free_ctx(up_context->fwd_context);
	at_context_free_ctx(up_context);

}

//ȡʱʱʱ
int get_timeout_by_cmd()
{
	char timeout[10] = {0};
    int i_timeout = 0;
	
	sc_cfg_get("wait_timeout", timeout, sizeof(timeout));
	i_timeout = atoi(timeout);
#if 1    // kw 3 SV.TAINTED.CALL.BINOP
    if(i_timeout < 0 || i_timeout > INT_MAX-1)
    {
        i_timeout = 0;
    }
#endif 

    return i_timeout;
}

//farpsⲿMCUʱʱ
void *wait_reqcmd_timeout_proc(void *arg)
{
	int at_fd = (int)arg;

	at_print(AT_ERR,"at_fd: %d!!!!\n", at_fd);
	ipc_send_message(MODULE_ID_AT_CTL, MODULE_ID_AT_CTL, ATCTL_INNER_WAITCOMPLETE_MSG, sizeof(int), &at_fd, IPC_NOWAIT);
	
	NETDOG_AT_STATICS(wait_farps_end_timeout++);
    return 0;
}

//farpsⲿMCUʱʱ
void set_wait_reqcmd_timeout(int waitid, int wait_req_timeout,int fd)
{
	int ret = 0;
	int i = 0;
	#if (APP_OS_TYPE == APP_OS_LINUX)
		
	if(waitid < 0)
		softap_assert("");
	sc_timer_delete(waitid);	
	
    ret = sc_timer_create(waitid,
              TIMER_FLAG_ONCE,
              wait_req_timeout*1000,
              wait_reqcmd_timeout_proc,
              (void *)fd);
	#endif
	if(ret != 0)
		softap_assert("");
}

void start_farps_waittimer(int fd)
{
	struct at_channel_info * ch_info = at_context_find_chn_by_fd(fd);
	int wait_req_timeout = 0;//ʱʱ䣬λΪ
	int waitid = 0;
	if(ch_info == NULL)
	{
		softap_assert("");
	}
	
	if(check_is_farps(fd))//far_psݲ
	{
		//ڲʱʱ
		wait_req_timeout = get_timeout_by_cmd();//ȡʱʱʱ
		waitid = get_timerID_by_fd(fd);//ͨȡʱʱid
		set_wait_reqcmd_timeout(waitid, wait_req_timeout, fd);//ʱʱ
	}
}


//farpsⲿMCUʱϢ
void  wait_complete_msg_proc(MSG_BUF *msg_buf)
{
	int at_fd = *(int *)(msg_buf->aucDataBuf);

	at_print(AT_ERR,"at_fd: %d!!!!\n", at_fd);

	struct at_channel_info * ch_info = at_context_find_chn_by_fd(at_fd);
	if(ch_info == NULL)//ҲfdӦchannel_infoֱӷ
	{
		NETDOG_AT_STATICS(channel_info_null++);
		return;
	}
	at_print(AT_ERR,"store data is timeout!!!!\n");
	//Ӧ൫ǲȷatظerror
	if(is_req_at(ch_info->store_cmd))
	{
	    //atӡشⲿ	
		char* err_str = at_err_build(ATERR_WAIT_REQ_END_TIMEOUT);
        at_context_write_data(ch_info->at_fd, err_str, strlen(err_str));
        free(err_str);
	}
	//ͨеĻ
	memset(ch_info->store_cmd, 0, AT_CMD_MAX);	
}

int send_pbsmsinit_msg()
{
	T_zAt_ZpbicRes pAtRes_sms = {0};
	T_zAt_ZpbicRes pAtRes_pb = {0};
	int ret1 =0;
	int ret2 =0;

	sscanf("1,0", "%ld,%ld", &pAtRes_sms.result, &pAtRes_sms.opertype);
	sscanf("1,1", "%ld,%ld", &pAtRes_pb.result, &pAtRes_pb.opertype);
if(g_support_pb)	
	ret1 = ipc_send_message2(MODULE_ID_AT_CTL,MODULE_ID_PB,MSG_CMD_ZPBIC_IND, sizeof(T_zAt_ZpbicRes), (UCHAR *)&pAtRes_pb,0);

if(g_support_sms)	
	ret2 = ipc_send_message2(MODULE_ID_AT_CTL,MODULE_ID_SMS,MSG_CMD_ZPBIC_IND, sizeof(T_zAt_ZpbicRes), (UCHAR *)&pAtRes_sms,0);

	if(ret1 == 0 && ret2 == 0)
	{
		at_print(AT_DEBUG,"pbsmsinit send pb_sms init msg success!!!\n");
		g_smspb_init = 0;
		g_need_smspb_init = 1;
		return 0;
	}
	else
	{
		at_print(AT_ERR,"pbsmsinit send pb_sms init msg failed!!!\n");
		return -1;
	}
}


/*pb smsʼʱĴ*/
void* pbsmsinittimeractstart(VOID *arg)
{
	at_print(AT_ERR,"enter pbsmsinittimeractstart!!!!\n");
	ipc_send_message(MODULE_ID_AT_CTL, MODULE_ID_AT_CTL, ATCTL_INNER_SMSPBINIT_MSG, 0, NULL, IPC_NOWAIT);
	return NULL;
}

void pbsms_init_msg_proc()
{
	if(((g_smspb_init & 0x03) == 0x03) && (g_need_smspb_init == 0))
	{
		int ret = send_pbsmsinit_msg();
		if(ret == 0)
		{
			at_print(AT_ERR,"pbsms_init_msg_proc send pb_sms init msg success!!!\n");
		}
	}
}

/*pb smsʼʱʱںpbsmsӦ÷Ϣ*/
void pbsms_init_timerout(void *msg)
{
	#if (APP_OS_TYPE == APP_OS_LINUX)
    /*smspbʼɺʱʱںpbsmsӦ÷Ϣ*/
    sc_timer_create(PbsmsInitTimerID,
                        TIMER_FLAG_ONCE,
                        PbsmsInitTimer_INTERVAL,
                        pbsmsinittimeractstart,
                        NULL);
	#endif
}



int  rcv_timeout_msg_proc(MSG_BUF *msg_buf)
{
	switch (msg_buf->usMsgCmd)
    {
		case ATCTL_DELAY_TIMEOUT_MSG:/* ʱʱϢ*/
		{
			delayed_msg_proc();
			return 1;
		}
		case ATCTL_INNER_WAIT_OUTSIDE_RSP_MSG:
		{
			timeout_proc_wait_outside_rsp(msg_buf);
			return 1;
		}
		//farpsⲿMCUʱϢ
		case ATCTL_INNER_WAITCOMPLETE_MSG:
		{
			wait_complete_msg_proc(msg_buf);
			return 1;
		}
		case ATCTL_INNER_SMSPBINIT_MSG:
		{
			pbsms_init_msg_proc();
			return 1;
		}
        
		default:
			break;
	}
	return 0;
}


