/*  demo
|| xujinyou@20150313
|| usb config set/change etc.
*/

#include <assert.h>
#include <stdio.h>  
#include <stdlib.h>  
#include <stdarg.h>
#include <string.h>  
#include <ctype.h>  
#include <sys/un.h>  
#include <sys/ioctl.h>  
#include <sys/socket.h>  
#include <linux/types.h>  
#include <linux/netlink.h>  
#include <errno.h>  
#include <unistd.h>  
#include <arpa/inet.h>  
#include <netinet/in.h> 
#include "zte_drv_usb_ctrl.h"
#include <pthread.h>
#include <semaphore.h>
#include "nv_api.h"
#include "cfg_api.h"
#include "softap_api.h"
#include "drv_msg.h"

#include <time.h>

unsigned char enum_functions[USB_STR_FUNCTIONS_MAX_LEN] = {0};
T_UsbCfg_MsLunInfo g_usbcfg_lunInfo;
T_REF_NV_USB g_USBRefNV = {0};

T_ZDrvUsb_OSType g_OS_type = OSType_Windows;
unsigned int usb_acmNum = 0;   /*ACMԸͺŻӦ*/
unsigned int usb_serialNum = 0;   /*SERIALԸͺŻӦ*/

unsigned int cp_need_udisk = 0; /*CPҪT֧TUл*/
unsigned char netMacAddr[32] = {0};

pthread_mutex_t g_usbcfg_usbenum_mutex;

T_USBCFG_UDISKFunc g_usbcfg_udiskProcFnc = NULL;
ZDrvEfuse_Secure  g_efuse_chipinfo;

#if 0
/*ȰβϢʹ*/
hotplug_parse_func usb_hotplug_parse_ptr[DEV_TYPE_MAX] = {NULL};
hotplug_proc_func usb_hotplug_proc_ptr[DEV_TYPE_MAX] = {NULL};
#endif

extern char g_usbcfg_cdrom_partition_name[USBCFG_LUN_PATH_MAX_LENGTH];

void usb_NvGetCdromState(void);
void usb_setMSInfo(e_usbEnum_type type);
void usb_setLunPath(unsigned int lun_id, e_usb_MsType lun_type, char *lun_path);
e_usbEnum_Tcardtype usb_getSdcardModeOption(void);

#if 0
/*netlinkڽں˲usbμлϢ*/
static int init_hotplug_sock(void)  
{  
    const int buffersize = UEVENT_BUFFER_SIZE;  
    int ret;  

    struct sockaddr_nl snl;  
    bzero(&snl, sizeof(struct sockaddr_nl));  
    snl.nl_family = AF_NETLINK;  
    snl.nl_pid = getpid();  
    snl.nl_groups = 1;  
    //snl.nl_groups = 0xffffffff;  

    int s = socket(PF_NETLINK, SOCK_DGRAM, NETLINK_KOBJECT_UEVENT);  
    if (s == -1)   
    {  
        perror("socket");  
        return -1;  
    }  
    //setsockopt(s, SOL_SOCKET, SO_RCVBUF, &buffersize, sizeof(buffersize));  

    ret = bind(s, (struct sockaddr *)&snl, sizeof(struct sockaddr_nl));  
    if (ret < 0)   
    {  
        perror("bind");  
        close(s);  
        return -1;  
    }  

    return s;  
}  
#endif

/*дļزbegin*/
static int filelength(FILE *fp)
{
    int num;
    fseek(fp,0,SEEK_END);
    num=ftell(fp);
    fseek(fp,0,SEEK_SET);
    return num;
}

static int readfile(char *path, char* buf, unsigned len)
{
    FILE *fp;
    unsigned int length;
    if((fp=fopen(path,"r"))==NULL)
    {
        slog(USBCFGMNG_PRINT,SLOG_ERR, "[usbCfgMng] open file %s error.\n",path);
        return -1;
    }
    length=filelength(fp);
    length = length > len? len: length;
    //ch=(char *)malloc(length+1);
    int read_len = fread(buf,length,1,fp);
    if(read_len < 1)  // cov M CHECKED_RETURN
    {
        slog(SDCARD_PRINT, SLOG_ERR, "fread %s error.\n",path); 
    }
	
    fclose(fp);
    *(buf+length)='\0';
    return (int)length;
}

static int writefile(char*path, char*buf, unsigned len)
{
    FILE *fp;
    int rtv;
    if((fp=fopen(path,"w"))==NULL)
    {
        slog(USBCFGMNG_PRINT,SLOG_ERR, "[usbCfgMng] open file %s error.\n",path);
        return -1;
    }
    rtv = fwrite(buf,len,1, fp);
    fclose(fp);
    return rtv;
}
/*дļزend*/

int usbcfg_createtMutex(pthread_mutex_t *mutex_id)
{
    return pthread_mutex_init(mutex_id,NULL);
}

int usbcfg_getMutex(pthread_mutex_t *mutex_id)
{
    return pthread_mutex_lock(mutex_id);
}

int usbcfg_putMutex(pthread_mutex_t *mutex_id)
{
    return pthread_mutex_unlock(mutex_id);
}

/*USB_EVENTе'\0' 滻'\n'ֹȡ'\0'*/
void usb_event_analyse(char*buf, int count)
{
    int index = 0;
    
    if(!buf)        
        return; 
    
    for(index = 0; index < count; ++index)
    {
        if(buf[index] == '\0')
        {
            buf[index] = '\n';
        }
    }
}

void usb_sendUsbOperateRlt(int state)
{
    int rtv = -1;
    
    if(state == 0)//remove usb
    {
        rtv = usbcfg_send_message( MSG_CMD_USBFLAG_STAT_REQ, 2, "0");//md by usb remove event is actived by usbcfg zhangwei0045000296 on 20170101
    }
    else if(state == 1)//add usb
    {
	  rtv = usbcfg_send_message( MSG_CMD_USBFLAG_STAT_REQ, 2, "1");//by usbcfg 0045002184
    }
    else if(state == 2)//power with usb added
    {
	  rtv = usbcfg_send_message( MSG_CMD_USBFLAG_STAT_REQ, 2, "2");//by usbcfg 0045002184
    }
    else if(state == 3)//power with usb added
    {
	  rtv = usbcfg_send_message( MSG_CMD_USBFLAG_STAT_REQ, 2, "3");//by usbcfg 0045002184
    }
    slog(USBCFGMNG_PRINT,SLOG_NORMAL,"usbcfg usb_sendUsbOperateRlt send state:%d msg reult: %d \n",state,rtv);
}
static void usb_enable()
{
    slog(USBCFGMNG_PRINT,SLOG_DEBUG, "[usbCfgMng] usb_enable\n");
     if(strstr((char *)enum_functions, "rndis"))
	 	writefile(USB_RNDIS_MAC_ADDR_PATH,(char *)netMacAddr,strlen((const char *)netMacAddr));
     else if(strstr((char *)enum_functions, "ecm"))
	 	writefile(USB_ECM_MAC_ADDR_PATH,(char *)netMacAddr,strlen((const char *)netMacAddr));
    writefile(USB_ENABLE_FILE_PATH,"1",1);
}
void usb_disable()
{
    slog(USBCFGMNG_PRINT,SLOG_DEBUG, "[usbCfgMng] usb_disable\n");
    writefile(USB_ENABLE_FILE_PATH,"0",1);
}

/*PID*/
static void usb_param_config(char *buf, int bufLen, char*path)
{
    //config pid/vid
    if(!buf || !path)
    {
        slog(USBCFGMNG_PRINT,SLOG_ERR, "[usbCfgMng] usb_param_config buf or path error\n");
        return;
    }
    
    writefile(path, buf, bufLen);
}


void usb_setEcmNum(void)
{
    if(strstr((char *)enum_functions, "ecm"))
    {
        char strEcmNum[2] = {0};
        int ecmNum = 0;
   
        sc_cfg_get(STR_ECM_NUM, strEcmNum,sizeof(strEcmNum));
        ecmNum = atoi(strEcmNum);
        slog(USBCFGMNG_PRINT,SLOG_DEBUG, "[usbCfgMng]usb_setEcmNum strEcmNum=%s, ecmNum = %d\n", strEcmNum, ecmNum);
        
        if(ecmNum >= 1 && ecmNum <= 3)
        {
            writefile(USB_ECM_FILE_PATH, strEcmNum, strlen(strEcmNum));
        }
    }
}

void usb_setRndisPktNum(void)
{
    if(strstr((char *)enum_functions, "rndis"))
    {
        char strPktNum[3] = {0};
        int pktNum = 0;
        
        sc_cfg_get(STR_RNDIS_PKT_NUM, strPktNum,sizeof(strPktNum));
        pktNum = atoi(strPktNum);
        slog(USBCFGMNG_PRINT,SLOG_DEBUG, "[usbCfgMng]usb_setRndisPktNum strPktNum=%s, pktNum = %d\n", strPktNum, pktNum);
        
        if(pktNum >= 1 && pktNum <= 10)
        {
            writefile(USB_RNDIS_PKTNUM_FILE_PATH, strPktNum, strlen(strPktNum));
        }
    }
}
void usb_setMbimPktNum(void)
    {
        if(strstr((char *)enum_functions, "mbim"))
        {
            char strPktNum[3] = {0};
            int pktNum = 0;
            
            sc_cfg_get(STR_MBIM_PKT_NUM, strPktNum,sizeof(strPktNum));
            pktNum = atoi(strPktNum);
            slog(USBCFGMNG_PRINT,SLOG_DEBUG, "[usbCfgMng]usb_setMbimPktNum strPktNum=%s, pktNum = %d\n", strPktNum, pktNum);
            
            if(pktNum >= 1 && pktNum <= 10)
            {
                writefile(USB_MBIM_PKTNUM_FILE_PATH, strPktNum, strlen(strPktNum));
            }
        }
    }


#if 0
//lunnumwangzhen
static int usb_getLunNum(e_usbEnum_type type)
{
    int lunNum = -1;
    char lunNumStr[2] = {0};

    switch(type)
    {
    case USB_CDROM:
	   sc_cfg_get(USB_LUN_NUM_CDROM, lunNumStr, sizeof(lunNumStr));
        break;
	 
    case USB_DEBUG:
        sc_cfg_get(USB_LUN_NUM_DEBUG, lunNumStr, sizeof(lunNumStr));
        break;
		
    case USB_USER:
        sc_cfg_get(USB_LUN_NUM_USER, lunNumStr, sizeof(lunNumStr));
        break;
		
    default:
        return -1;
    }

    lunNum = atoi(lunNumStr);
    slog(USBCFGMNG_PRINT,SLOG_DEBUG, "[usbCfgMng]usb_getLunNum LunNum = %d\n", lunNum); 
    if(lunNum >= 0 && lunNum <= USBCFG_MS_LUN_MAX_NUM)
    {
        return lunNum;
    }
    
    return -1;
}

static void usb_setLunNum(e_usbEnum_type type)
{
    unsigned char lunNumbuf[2] = {0};
    int lunNum = -1;

    lunNum = usb_getLunNum(type);
    if(lunNum == -1)
    {
    	 slog(USBCFGMNG_PRINT,SLOG_ERR, "[usbCfgMng] usb_setLunNum err, lunnum:%s\n",lunNum);
        return;
    }
    
    g_usbcfg_lunInfo.usb_lunNum= lunNum;
    sprintf((char *)lunNumbuf,"%d", lunNum);
    writefile(USB_MS_LUN_NUM, (char *)lunNumbuf, strlen((const char *)lunNumbuf)); 
    slog(USBCFGMNG_PRINT,SLOG_DEBUG,"[usbCfgMng]usb_setLunNum:%s\n",lunNumbuf);
}
#endif

static int usb_has_luntype_mmc(e_usbEnum_type type)
{
	char lunType[64] = {0};
	
	int i = 0;
        
    switch(type)
   	{
	case USB_CDROM:
		sc_cfg_get(USB_LUN_TYPE_CDROM, lunType, sizeof(lunType));
		break;

	case USB_DEBUG:
		sc_cfg_get(USB_LUN_TYPE_DEBUG, lunType, sizeof(lunType));
		break;
		
	case USB_USER:
		sc_cfg_get(USB_LUN_TYPE_USER, lunType, sizeof(lunType));
		break;
    }
	slog(USBCFGMNG_PRINT,SLOG_DEBUG,"[usbCfgMng]usb_has_luntype_mmc type is %d, luntype:%s\n",type,lunType);

	if(!strstr(lunType, NV_MMC)){		
		return 0;
	}
	
	return 1;
}

static int usb_getLunType(e_usbEnum_type type)
{
	char lunType[64] = {0};
	char *p;
	char *token;
	e_usb_MsType lun_type=MS_TYPE_CDROM;
	int i = 0;
	unsigned char lunNumbuf[2] = {0};
    
    /*޸ģɽUSB_LUN0_TYPEԶŸֱòͬLUNtypeϢ
	Ŀǰȫȡ*/
    
    switch(type)
   	{
	case USB_CDROM:
		sc_cfg_get(USB_LUN_TYPE_CDROM, lunType, sizeof(lunType));
		break;

	case USB_DEBUG:
		sc_cfg_get(USB_LUN_TYPE_DEBUG, lunType, sizeof(lunType));
		break;
		
	case USB_USER:
		sc_cfg_get(USB_LUN_TYPE_USER, lunType, sizeof(lunType));
		break;
    }
	slog(USBCFGMNG_PRINT,SLOG_DEBUG,"[usbCfgMng]usb_getLunType type is %d, luntype:%s\n",type,lunType);
	p = lunType;
	while((token = strsep(&p,",")) != NULL){
		if(strlen(token) > 0){
			if(!strcmp(token, NV_MMC))
				lun_type = MS_TYPE_MMC;
			else if(!strcmp(token, NV_CDROM))
				lun_type = MS_TYPE_CDROM;
			else{
				slog(USBCFGMNG_PRINT,SLOG_ERR, "[usbCfgMng]usb_getLunType err ms type:%s\n",token);
				continue;
			}
		}
		g_usbcfg_lunInfo.lun_info[i].mstype  = lun_type;
		i++;
		slog(USBCFGMNG_PRINT,SLOG_DEBUG, "[usbCfgMng]usb_getLunType type is %d, lun type num:%d eachluntype:%d,:%s\n",type,i,lun_type,token);
	}
	if(i == 0){
		slog(USBCFGMNG_PRINT,SLOG_ERR, "[usbCfgMng]usb_getLunType ERR type is %d, lun num:%d\n",type,i);
		return 0;
	}else{
		g_usbcfg_lunInfo.usb_lunNum=i;
		snprintf((char *)lunNumbuf,sizeof(lunNumbuf),"%d", i);
    		writefile(USB_MS_LUN_NUM, (char *)lunNumbuf, strlen((const char *)lunNumbuf)); 
		return 1;
	}
}

static void usb_getLunPath(int lun_id)
{
	char lunpath[MAX_FILENAME_LEN] = {0};
	if(lun_id >= USBCFG_MS_LUN_MAX_NUM)
	{
		return;
	}

	memset(g_usbcfg_lunInfo.lun_info[lun_id].lun_path, 0, MAX_FILENAME_LEN);
		
	if(g_usbcfg_lunInfo.lun_info[lun_id].mstype == MS_TYPE_CDROM){
		sc_cfg_get(STR_CDROM_LUNPATH, lunpath, sizeof(lunpath));
	}else if(g_usbcfg_lunInfo.lun_info[lun_id].mstype == MS_TYPE_MMC){
		sc_cfg_get(STR_TCARD_LUNPATH, lunpath, sizeof(lunpath));
	}else{
		slog(USBCFGMNG_PRINT,SLOG_ERR, "[usbCfgMng]usb_getLunPath err, lun%d,type:%d\n",lun_id,g_usbcfg_lunInfo.lun_info[lun_id].mstype);
		return;
	}

	usb_setLunPath(lun_id, g_usbcfg_lunInfo.lun_info[lun_id].mstype, lunpath);
	//memcpy(g_usbcfg_lunInfo.lun_info[lun_id].lun_path, lunpath, strlen(lunpath));
	slog(USBCFGMNG_PRINT,SLOG_DEBUG,"[usbCfgMng]usb_getLunPath, lun%d\n",lun_id);
}

/*Mstypecdromڵroڵ*/
void usb_setMsLunAttrByMsType(e_usb_MsType type, char*cpath,char*rpath)
{

    slog(USBCFGMNG_PRINT,SLOG_DEBUG, "[usbCfgMng]usb_SetMsLunAttrByMsType type = %d\n", type);
    if(type == MS_TYPE_CDROM)
    {  
        writefile(cpath, "1", strlen("1"));
    	 writefile(rpath,  "1", strlen("1"));
    }
    else 
    {
        writefile(cpath,  "0", strlen("0"));
    	 writefile(rpath,  "0", strlen("0"));
    }

}


void usb_NvGetMsInquiryString(e_usb_MsType mstype, char *path)
{
    char inquiryString[USB_MS_INQUIRY_LEN] = {0};
    char vendor[USB_MS_VENDOR_LEN + 1] = {0};
    char product[USB_MS_PRODUCT_LEN + 1] = {0};
    char release[USB_MS_RELEASE_LEN + 1] = {0};
    int i = 0;

    if(mstype == MS_TYPE_CDROM)
    {
	 sc_cfg_get(STR_INQUIRY_MS_CDROM, inquiryString, USB_MS_INQUIRY_LEN);
    }
    else
    {
	 sc_cfg_get(STR_INQUIRY_MS_MMC, inquiryString, USB_MS_INQUIRY_LEN);
    }

    for(i=0; i< USB_MS_INQUIRY_LEN; i++)
    {
        if(inquiryString[i] == 0)
        {
            inquiryString[i] = 32;
        }
    }
    inquiryString[USB_MS_INQUIRY_LEN-1] = '\0';

    slog(USBCFGMNG_PRINT,SLOG_DEBUG, "[usbCfgMng] usb_NvGetMsInquiryString inquiryString = %s\n", inquiryString);

    writefile(path, inquiryString, strlen(inquiryString));
}

/*lun豸·ÿ*/
void usb_resetMsLunFilePath(void)
{
    char filepath[MAX_FILENAME_LEN] = {0};
    unsigned int x = 0;

    for(x = 0; x < g_usbcfg_lunInfo.usb_lunNum; x++)
    {
        memset(filepath , 0 , sizeof(filepath));
        snprintf(filepath, sizeof(filepath) , "%s%d%s", USB_MS_LUN_FILE_PATH, x, STR_USB_MS_LUN_FILE);
        writefile(filepath, "NULL", strlen("NULL"));//·
    }
}


/*ô洢lun豸*/
int set_lun_num(unsigned int lun_num)
{
    if(lun_num > USBCFG_MS_LUN_MAX_NUM)
    {
        return -1;
    }
    
    g_usbcfg_lunInfo.usb_lunNum = lun_num;
    return 0;
}



/*Xlun豸Ľ·g_usbcfg_lunInfo*/
int set_lunx_path(unsigned int lun_id, e_usb_MsType lun_type, char *lun_path)
{
    if(lun_id >= USBCFG_MS_LUN_MAX_NUM || NULL == lun_path)
    {
        return -1;
    }

    if(strlen(lun_path) >= MAX_FILENAME_LEN)
    {
        return -1;
    }

    g_usbcfg_lunInfo.lun_info[lun_id].mstype = lun_type;
    memset(g_usbcfg_lunInfo.lun_info[lun_id].lun_path, 0, MAX_FILENAME_LEN);
    memcpy(g_usbcfg_lunInfo.lun_info[lun_id].lun_path, lun_path, strlen(lun_path));
    return 0;
}


/*Xlun豸Ľ·g_usbcfg_lunInfo*/
void usb_setLunPath(unsigned int lun_id, e_usb_MsType lun_type, char *lun_path)
{
    e_usbEnum_Tcardtype tcardType = usb_getSdcardModeOption();
    int  mmcState = usb_isMmcExist();
    if(lun_id >= USBCFG_MS_LUN_MAX_NUM || NULL == lun_path)
    {
        return;
    }

    if(strlen(lun_path) >= MAX_FILENAME_LEN)
    {
        return;
    }

    g_usbcfg_lunInfo.lun_info[lun_id].mstype = lun_type;
    memset(g_usbcfg_lunInfo.lun_info[lun_id].lun_path, 0, MAX_FILENAME_LEN);
    if((tcardType == USBCFG_HTTPSHARE) && (g_usbcfg_lunInfo.lun_info[lun_id].mstype == MS_TYPE_MMC)){
    		slog(USBCFGMNG_PRINT,SLOG_DEBUG, "[usbCfgMng]usb_setLunPath TCARD is httpshare mode\n");
    	}else{
   		 memcpy(g_usbcfg_lunInfo.lun_info[lun_id].lun_path, lun_path, strlen(lun_path));
    	}
    return;
}

/*õxlun豸Ľ·inquiryString*/
int usb_setMsLunxFilePathAndInquiryString(unsigned int lun_id, struct lun_info *lun_info)
{
    char filepath[MAX_FILENAME_LEN] = {0};
    char inquirypath[MAX_FILENAME_LEN] = {0};
    char cdrompath[MAX_FILENAME_LEN] = {0};
    char ropath[MAX_FILENAME_LEN] = {0};

    if(lun_id > USBCFG_MS_LUN_MAX_NUM || NULL == lun_info || 0 == strlen(lun_info->lun_path))
    {
        slog(USBCFGMNG_PRINT,SLOG_ERR, "[usbCfgMng][%s][%d]set lunx path failed!\n", __func__, __LINE__);
        return -1;
    }

    snprintf(filepath, sizeof(filepath) , "%s%d%s", USB_MS_LUN_FILE_PATH, lun_id, STR_USB_MS_LUN_FILE);
    snprintf(inquirypath, sizeof(inquirypath) , "%s%d%s", USB_MS_LUN_FILE_PATH, lun_id,STR_USB_MS_LUN_INQUIRY);
    snprintf(cdrompath, sizeof(cdrompath) , "%s%d%s", USB_MS_LUN_FILE_PATH, lun_id, STR_USB_MS_LUN_CDROM);
    snprintf(ropath, sizeof(ropath) , "%s%d%s", USB_MS_LUN_FILE_PATH, lun_id,STR_USB_MS_LUN_RO);

    slog(USBCFGMNG_PRINT,SLOG_ERR, "[usbCfgMng][%s][%d]lun_id = %d, msType = %d, lun_path = %s, filepath = %s\n", 
        __func__, __LINE__, lun_id, lun_info->mstype, lun_info->lun_path, filepath);

    usb_setMsLunAttrByMsType(lun_info->mstype, cdrompath, ropath);//cdromڵ㼰roڵ
    writefile(filepath, lun_info->lun_path, strlen(lun_info->lun_path));//·
    usb_NvGetMsInquiryString(lun_info->mstype, inquirypath);//inquiryϢ
    return 0;
}


/*lunϢ*/
void usb_setMsLunInfoToDrv(void)
{
    unsigned int i = 0;
    unsigned char buf[2] = {0};

    if(!g_usbcfg_lunInfo.usb_lunNum)
    {
        slog(USBCFGMNG_PRINT,SLOG_ERR, "[usbCfgMng]usb_setMsLunInfoToDrv usb_lunNum = 0 return\n");
        return;
    }
    
    for(i = 0; i < g_usbcfg_lunInfo.usb_lunNum; i++)
    {
        usb_setMsLunxFilePathAndInquiryString(i, &g_usbcfg_lunInfo.lun_info[i]);
    }

    snprintf((char *)buf,sizeof(buf),"%d", g_usbcfg_lunInfo.usb_lunNum);
    writefile(USB_MS_LUN_NUM, (char *)buf, strlen((const char *)buf));
}

/*洢*/
void usb_setMsDev(e_usbEnum_type type)
{
    int i = 0;
    int j = 0;

    /*ȡÿLuntype*/
    j = usb_getLunType(type);
    if(j == 0){
		slog(USBCFGMNG_PRINT,SLOG_ERR, "[usbCfgMng]usb_setMsDev error, get lun type failed\n");
    }else{
    	for(i = 0;i < g_usbcfg_lunInfo.usb_lunNum; i++)
    	{
    		/*ȡÿLunpath*/
			usb_getLunPath(i);

	       	/*ÿlunԲ*/
			usb_setMsLunxFilePathAndInquiryString(i, &g_usbcfg_lunInfo.lun_info[i]);
   	 	}
    }
}




/*ȡڶ׶ι̽·*/
void usb_getCdromStep2LunPath(char *lun_path, int len)
{
    if(g_USBRefNV.CDROMFlagStep2 == 2) /*ؽ*/
    {
        sc_cfg_get(STR_CDROM_LUNPATH, lun_path, len);
        slog(USBCFGMNG_PRINT,SLOG_ERR, "[usbCfgMng]usb_getCdromStep2LunPath lun_path = %s\n", lun_path); 
    }
    else
    {
        sprintf((char *)(lun_path), "NULL");
    }
}


/*mass_storageʱlun·*/
void usb_setLunPathForHttpShare(void)
{
    int  mmcState = usb_isMmcExist();
    e_usbEnum_Tcardtype tcardType = usb_getSdcardModeOption();
    char lun_path[MAX_FILENAME_LEN] = {0};
    char cdrom_path[MAX_FILENAME_LEN] = {0};
    
    if(strstr((char *)enum_functions, USB_STR_MASSSTORAGE))
    {
    	if(g_usbcfg_lunInfo.has_mmc)
    	{
	        if(mmcState > 0 && tcardType == USBCFG_USB)
	        {
	            sc_cfg_get(STR_TCARD_LUNPATH, lun_path, sizeof(lun_path));
	            slog(USBCFGMNG_PRINT,SLOG_ERR, "[usbCfgMng][%s][%d]lun_path1 = %s\n", __func__, __LINE__, lun_path);
	        }
	        
	        //if(!g_USBRefNV.CDROMFlagStep2)
	        if(g_USBRefNV.CDROMFlagStep2 == 0 || g_USBRefNV.CDROMFlagStep2 == 1)
	        {
	            set_lun_num(USB_NUM_LUN_1);
	            set_lunx_path(0, MS_TYPE_MMC, lun_path);
	        }
	        else if(g_USBRefNV.CDROMFlagStep2 == 2)
	        {
	            set_lun_num(USB_NUM_LUN_2);
	            usb_getCdromStep2LunPath(cdrom_path, sizeof(cdrom_path));
	            set_lunx_path(0, MS_TYPE_CDROM, cdrom_path);
	            set_lunx_path(1, MS_TYPE_MMC, lun_path);
	        }
    	}
		else
		{
			if(g_USBRefNV.CDROMFlagStep2 == 2)
			{
	            set_lun_num(USB_NUM_LUN_1);
	            usb_getCdromStep2LunPath(cdrom_path, sizeof(cdrom_path));
	            set_lunx_path(0, MS_TYPE_CDROM, cdrom_path);
			}
			else
				set_lun_num(0);
		}
	}
	else
	{
		slog(USBCFGMNG_PRINT,SLOG_ERR, "[usbCfgMng][%s][%d]no mass storage Step2 = %d\n", __func__, __LINE__, g_USBRefNV.CDROMFlagStep2);
	}
    
    return; 
}


void usb_NvGetParamConfig(void)
{
    char vid[5] = {0};
    char manufacturer[256] = {0};
    char product[256] = {0};
    char iSerial[256] = {0};
    char config[256] = {0};

    sc_cfg_get(STR_VID_TSP, vid, sizeof(vid));
    sc_cfg_get(STR_MANUFACTURER_TSP, manufacturer, sizeof(manufacturer));
    sc_cfg_get(STR_PRODUCT_TSP, product, sizeof(product));
    sc_cfg_get(STR_SERIAL_TSP, iSerial, sizeof(iSerial));
    sc_cfg_get(STR_CONFIG_TSP, config, sizeof(config));

		#if 0
		/*if need different id for different devices, need to change NV to be something else excetp 123456789ABCDEF
		* and change 0 to 1*/
    if(strcmp(iSerial,"1234567890ABCDEF"))
    {
		srand((int)time(0));
		sprintf(iSerial,"%08x%08x",rand(),rand());
		sc_cfg_set(STR_SERIAL_TSP, iSerial);
    }
    #endif
	
    usb_param_config(vid, strlen(vid), USB_IDVENDOR_FILE_PATH);
    usb_param_config(manufacturer, strlen(manufacturer), USB_MANUFACTURER_FILE_PATH);
    usb_param_config(product, strlen(product), USB_PRODUCT_FILE_PATH);
    usb_param_config(iSerial, strlen(iSerial), USB_ISERIAL_FILE_PATH);
    usb_param_config(config, strlen(config), USB_CONFIG_FILE_PATH);

    usb_setEcmNum();
    usb_setRndisPktNum();
    usb_setMbimPktNum();
}

/*жforceͣforce_invalidҪжselect͡
   force; */
T_SYS_NV_FORCE_NETCARD_TYPE zDrvRef_NvGetForceNetCardType(VOID)
{
    T_SYS_NV_FORCE_NETCARD_TYPE  flag = FORCE_ERR;
    char fType[16] = {0};
    int ret = 0;

    ret = nv_get_item(NV_RO, STR_FORCE_NETCARD_TYPE, fType, sizeof(fType));
    
    slog(USBCFGMNG_PRINT,SLOG_DEBUG, "[usbCfgMng] zDrvRef_NvGetForceNetCardType ret = %d, fType = %s\n",ret, fType);
    
    if(!strcmp(fType, "force_ndis"))
    {
        flag = FORCE_NDIS; 
    }
    else if(!strcmp(fType, "force_rndis"))
    {
        flag = FORCE_RNDIS;
    }
    else if(!strcmp(fType, "force_ecm"))
    {
        flag = FORCE_ECM;
    }
    else if(!strcmp(fType, "force_mbim"))
    {
        flag = FORCE_MBIM;
    }
    else if(!strcmp(fType, "force_invalid"))
    {
        flag = FORCE_INVALID;
    }
    return flag;
}

T_SYS_NV_NETCARD_TYPE_FOR_WIN zDrvRef_NvGetNetCardTypeForWin(VOID)
{
    T_SYS_NV_NETCARD_TYPE_FOR_WIN  flag = SELECT_ERR;
    char sType[16] = {0};

    sc_cfg_get(STR_SELECT_TYPE, sType, sizeof(sType));
    slog(USBCFGMNG_PRINT,SLOG_DEBUG, "[usbCfgMng] zDrvRef_NvGetNetCardTypeForWin sType = %s\n",sType);
    if(!strcmp(sType, "select_ndis"))
    {
        flag = SELECT_NDIS; 
    }
    else if(!strcmp(sType, "select_rndis"))
    {
        flag = SELECT_RNDIS;
    }
    else if(!strcmp(sType, "select_mbim"))
    {
        flag = SELECT_MBIM;
    }

    return flag;

}

T_ZDrvUsb_OSType zDrvSys_GetOSType(VOID)
{
    int sysId = 0;
    char idBuf[10]={0};
    int rtv = 0;
    
    rtv = readfile(USB_SYS_ID_FILE_NAME, idBuf, 8);

    if(rtv < 0){
        slog(USBCFGMNG_PRINT,SLOG_ERR, "[usbCfgMng] warning: readfile %s fail \n", USB_SYS_ID_FILE_NAME);
        exit(0);
    }

    sysId = atoi(idBuf);

    if(sysId == 0){
        slog(USBCFGMNG_PRINT,SLOG_DEBUG, "[usbCfgMng] sys is windows \n");
        g_OS_type = OSType_Windows;
    }else{
        slog(USBCFGMNG_PRINT,SLOG_DEBUG, "[usbCfgMng] sys is mac or linux \n");
        g_OS_type = OSType_Others;
    }

    return g_OS_type;
}

void usb_enumNetcardProc(unsigned char* netcardType)
{
    if(!netcardType)
    {
        return;
    }

    slog(USBCFGMNG_PRINT,SLOG_DEBUG, "[usbCfgMng] usb_enumNetcardProc >>>>netcardType:%s\n", netcardType);
    sprintf((char *)enum_functions, (const char *)netcardType);
}
void usb_set_remote_wakeup_attr(void)
{
    unsigned char serialNumbuf[4] = {0};
	//USB_CONFIG_ATT_ONE | USB_CONFIG_ATT_SELFPOWER | USB_CONFIG_ATT_WAKEUP
    sprintf((char *)serialNumbuf,"%d", ((1<<7) | (1<<6) | (1<<5)));
    slog(USBCFGMNG_PRINT,SLOG_ERR, "[usbCfgMng]set_remote_wakeup_attr:%s\n",serialNumbuf);
    writefile(USB_BMATTR_FILE_PATH, (char *)serialNumbuf, strlen((const char *)serialNumbuf)); 	
}
/*ж*/
void usb_getNetcardType(void)
{
    T_ZDrvUsb_OSType osType = zDrvSys_GetOSType();
    T_SYS_NV_FORCE_NETCARD_TYPE  fType  = FORCE_ERR;
    T_SYS_NV_NETCARD_TYPE_FOR_WIN sType = SELECT_ERR;
    
    fType = zDrvRef_NvGetForceNetCardType();
    sType = zDrvRef_NvGetNetCardTypeForWin();
    slog(USBCFGMNG_PRINT,SLOG_DEBUG, "[usbCfgMng] usb_getUsbCfgType fType:%d >>>>sType:%d\n", fType,sType);
    
    if(fType == FORCE_INVALID)
    {
        if(OSType_Windows == osType)
        {
            switch(sType)
            {
                case SELECT_NDIS:
                    usb_enumNetcardProc((unsigned char*)"ndis");
                    break;
                case SELECT_RNDIS:
                    usb_enumNetcardProc((unsigned char*)"rndis");
                    break;
                case SELECT_MBIM:
                    usb_enumNetcardProc((unsigned char*)"mbim");
					usb_set_remote_wakeup_attr();
                    break;
                default:
                    slog(USBCFGMNG_PRINT,SLOG_ERR, "[usbCfgMng] usb_getUsbCfgType default>>> window sType:%d >>>>error\n", sType);
                    break;
            }
        }
        else
        {
            usb_enumNetcardProc((unsigned char*)"ecm");
        }
    }
    else
    {
        switch(fType)
        {
            case FORCE_NDIS:
                usb_enumNetcardProc((unsigned char*)"ndis");
                break;
            case FORCE_RNDIS:
                usb_enumNetcardProc((unsigned char*)"rndis");
                break;
            case FORCE_ECM:
                usb_enumNetcardProc((unsigned char*)"ecm");
                break;
            case FORCE_MBIM:
                usb_enumNetcardProc((unsigned char*)"mbim");
				usb_set_remote_wakeup_attr();
                break;
            default:
                slog(USBCFGMNG_PRINT,SLOG_ERR, "[usbCfgMng] usb_getUsbCfgType fType error fType = %d\n", fType);
                break;
        }
    }
}


static void usb_enum_CdromProc(void)
{
    char cdrom_path[MAX_FILENAME_LEN] = {0};
    char udisk_path[MAX_FILENAME_LEN] = {0};
    char tempModeType[2] = {0};
    
    usb_NvGetCdromState();
	g_usbcfg_lunInfo.has_mmc = usb_has_luntype_mmc(USB_CDROM);
    if(g_USBRefNV.CDROMFlag)
    { 
		writefile(USB_ENMODS_FILE_NAME, "1", 1);
        sprintf((char *)enum_functions, USB_STR_MASSSTORAGE);
        writefile(USB_FUNCTIONS_FILE_PATH, USB_STR_MASSSTORAGE, strlen(USB_STR_MASSSTORAGE));

        sc_cfg_get(STR_CDROM_LUNPATH, cdrom_path, USB_STR_FUNCTIONS_MAX_LEN);
		sc_cfg_get(STR_TCARD_LUNPATH, udisk_path, USB_STR_FUNCTIONS_MAX_LEN);
		sc_cfg_get(STR_SDCARD_MODE_OPT, tempModeType, sizeof(tempModeType));

		slog(USBCFGMNG_PRINT,SLOG_ERR, "[usbCfgMng]  usb_enum_CdromProc cdrom tempModeType =%s\n",tempModeType); 
		if(g_usbcfg_lunInfo.has_mmc)
		{
			if(strcmp(tempModeType, "1") == 0)
			{
				set_lun_num(USB_NUM_LUN_1);
				set_lunx_path(0, MS_TYPE_CDROM, cdrom_path);
			}
			else
			{
				set_lun_num(USB_NUM_LUN_2);
				set_lunx_path(0, MS_TYPE_CDROM, cdrom_path);
				set_lunx_path(1, MS_TYPE_MMC, udisk_path);
			}
		}
		else
		{
				set_lun_num(USB_NUM_LUN_1);
				set_lunx_path(0, MS_TYPE_CDROM, cdrom_path);		
		}
        usb_setMsLunInfoToDrv();
        //writefile(USB_ENMODS_FILE_NAME, "1", 1);
    }
}

#if 0
static void usb_enum_CdromProc(void)
{
    if(g_USBRefNV.CDROMFlag)
    { 
	writefile(USB_ENMODS_FILE_NAME, "1", 1);
        sprintf((char *)enum_functions, USB_STR_MASSSTORAGE);
        writefile(USB_FUNCTIONS_FILE_PATH, USB_STR_MASSSTORAGE, strlen(USB_STR_MASSSTORAGE));

    	slog(USBCFGMNG_PRINT,SLOG_DEBUG, "[usbCfgMng]  usb_enum_CdromProc\n"); 

    	usb_setMSInfo(USB_CDROM);
        //usb_setMsLunInfoToDrv();
    }
}
#endif


/*ȡSERIAL*/
static int usb_getSerialNum(e_usbEnum_type type)
{
    int serialNum = -1;
    char serialNumStr[2] = {0};

    switch(type)
    {
    case USB_DEBUG:
        sc_cfg_get(USB_SERIAL_NUM_DEBUG, serialNumStr, sizeof(serialNumStr));
        break;
    case USB_USER:
        sc_cfg_get(USB_SERIAL_NUM_USER, serialNumStr, sizeof(serialNumStr));
        break;
    case USB_FACTORY:
        sc_cfg_get(USB_SERIAL_NUM_FACTORY, serialNumStr, sizeof(serialNumStr));
        break;
    case USB_AMT:
        sc_cfg_get(USB_SERIAL_NUM_AMT, serialNumStr, sizeof(serialNumStr));
        break;
    default:
        return -1;
    }

    serialNum = atoi(serialNumStr);
    slog(USBCFGMNG_PRINT,SLOG_DEBUG, "[usbCfgMng]usb_getAcmNum serialNum = %d\n", serialNum); 
    if(serialNum >= 0 && serialNum <= USBCFG_MAX_SERIAL_NUM)
    {
        return serialNum;
    }
    
    return -1;
}

/*SERIAL*/
static void usb_setSerialNum(e_usbEnum_type type)
{
    unsigned char serialNumbuf[2] = {0};
    int serialNum = -1;

    usb_serialNum = 0;
    serialNum = usb_getSerialNum(type);
    if(serialNum == -1)
    {
        return;
    }
    
    usb_serialNum = serialNum;
    sprintf((char *)serialNumbuf,"%d", usb_serialNum);
    slog(USBCFGMNG_PRINT,SLOG_DEBUG, "[usbCfgMng]instance serialNumbuf:%s\n",serialNumbuf);
    writefile(USB_SERIAL_FILE_PATH, (char *)serialNumbuf, strlen((const char *)serialNumbuf)); 
}


/*ȡACM*/
static int usb_getAcmNum(e_usbEnum_type type)
{
    int acmNum = -1;
    char acmNumStr[2] = {0};

    switch(type)
    {
    case USB_DEBUG:
        sc_cfg_get(USB_ACM_NUM_DEBUG, acmNumStr, sizeof(acmNumStr));
        break;
    case USB_USER:
        sc_cfg_get(USB_ACM_NUM_USER, acmNumStr, sizeof(acmNumStr));
        break;
    default:
        return -1;
    }

    acmNum = atoi(acmNumStr);
    slog(USBCFGMNG_PRINT,SLOG_DEBUG, "[usbCfgMng]usb_getAcmNum acmNum = %d\n", acmNum); 
    if(acmNum >= 0 && acmNum <= USBCFG_MAX_ACM_NUM)
    {
        return acmNum;
    }
    
    return -1;
}

/*ACM*/
static void usb_setAcmNum(e_usbEnum_type type)
{
    unsigned char acmNumbuf[2] = {0};
    int acmNum = -1;

    usb_acmNum = 0;
    acmNum = usb_getAcmNum(type);
    if(acmNum == -1)
    {
        return;
    }
    
    usb_acmNum = acmNum;
    sprintf((char *)acmNumbuf,"%d", usb_acmNum);
    slog(USBCFGMNG_PRINT,SLOG_DEBUG, "[usbCfgMng]instance acmNumbuf:%s\n",acmNumbuf);
    writefile(USB_ACM_FILE_PATH, (char *)acmNumbuf, strlen((const char *)acmNumbuf)); 
}


static BOOL usb_isUserVnicExist(e_usbEnum_type type)
{
    BOOL isVnicExist = TRUE;
    char vnicState[8] = {0};

    if(type == USB_USER)
    {
        sc_cfg_get(STR_USB_VNIC_USER, vnicState, sizeof(vnicState));
    }

    slog(USBCFGMNG_PRINT,SLOG_DEBUG, "[usbCfgMng] usb_isUserVnicExist vnicState = %s\n",vnicState);
    
    if(!strncmp(vnicState, "off", strlen("off")))
    {
        isVnicExist = FALSE; 
    }
    else
    {
        isVnicExist = TRUE; 
    }

    slog(USBCFGMNG_PRINT,SLOG_DEBUG, "[usbCfgMng]usb_isUserVnicExist isVnicExist = %d\n", isVnicExist);  
    return isVnicExist;
}

void usb_ProcessUdiskProc(void)
{   
    if(g_usbcfg_udiskProcFnc != NULL)
    {
        g_usbcfg_udiskProcFnc();
    }
}

static void usb_enum_DebugProc(void)
{
    char usbDevice[USB_STR_FUNCTIONS_MAX_LEN] = {0};
    
    usb_getNetcardType();	
	g_usbcfg_lunInfo.has_mmc = usb_has_luntype_mmc(USB_DEBUG);
    if(zDrvRef_NvGetForceNetCardType() == FORCE_MBIM)
	    sc_cfg_get(USB_STR_ENUM_DEVICES_DEBUG_MBIM, usbDevice, sizeof(usbDevice));
	else
    sc_cfg_get(USB_STR_ENUM_DEVICES_DEBUG, usbDevice, sizeof(usbDevice));
    if(strlen((const char*)enum_functions) != 0 && strlen((const char*)usbDevice) != 0)
    { 
        strcat((char *)enum_functions, ",");
    }
    
    strncat((char *)enum_functions,usbDevice,30);
    slog(USBCFGMNG_PRINT,SLOG_DEBUG, "[usbCfgMng] usb_enum_DebugProc >>>>>>>enum_functions = %s, usbDevice = %s\n", enum_functions, usbDevice); 

    usb_ProcessUdiskProc();
    slog(USBCFGMNG_PRINT,SLOG_DEBUG, "[usbCfgMng] usb_enum_DebugProc enum_functions = %s, usbDevice = %s\n", enum_functions, usbDevice); 
    g_USBRefNV.currentModeType = USB_DEBUG;
    usb_setSerialNum(USB_DEBUG);
    usb_setAcmNum(USB_DEBUG);
    writefile(USB_FUNCTIONS_FILE_PATH, (char *)enum_functions, strlen((const char *)enum_functions));
	writefile(USB_ENUM_MODE_PATH, "0", 1);

  //  usb_setMSInfo(USB_DEBUG);
    usb_setLunPathForHttpShare();
    usb_setMsLunInfoToDrv();
}

static void usb_enum_UserProc(void)
{
    char usbDevice[USB_STR_FUNCTIONS_MAX_LEN] = {0};
    
    if(usb_isUserVnicExist(USB_USER))
    {
        usb_getNetcardType();
    }
	
	g_usbcfg_lunInfo.has_mmc = usb_has_luntype_mmc(USB_USER);
	if((zDrvRef_NvGetForceNetCardType() == FORCE_MBIM) || (zDrvRef_NvGetNetCardTypeForWin() == SELECT_MBIM)){
		printf("usb_enum_UserProc, for mbim, only mbim show\n");
		goto AFTER_FUNCTION;
	}
	
    sc_cfg_get(USB_STR_ENUM_DEVICES_USER, usbDevice, sizeof(usbDevice));
    if(strlen((const char*)enum_functions) != 0 && strlen((const char*)usbDevice) != 0)
    { 
        strcat((char *)enum_functions, ",");
    }
    strncat((char *)enum_functions, (const char *)usbDevice, 30);
	
AFTER_FUNCTION:	
    usb_ProcessUdiskProc();
    g_USBRefNV.currentModeType = USB_USER;

    usb_setSerialNum(USB_USER);
    usb_setAcmNum(USB_USER);
    writefile(USB_FUNCTIONS_FILE_PATH, (char *)enum_functions, strlen((const char *)enum_functions));
	writefile(USB_ENUM_MODE_PATH, "1", 1);
    //usb_setMSInfo(USB_USER);
    usb_setLunPathForHttpShare();
    usb_setMsLunInfoToDrv();
    slog(USBCFGMNG_PRINT,SLOG_DEBUG, "[usbCfgMng] usb_enum_UserProc enum_functions = %s,usbDevice=%s\n", enum_functions,usbDevice); 
}

static void usb_enum_FastPowerOffProc(void)
{
    if(g_USBRefNV.nvModeType != USB_MODETYPE_DEBUG)
    {
        slog(USBCFGMNG_PRINT,SLOG_DEBUG, "[usbCfgMng] usb_enum_FastPowerOffProc g_USBRefNV.nvModeType = %d\n", g_USBRefNV.nvModeType);
        return;
    }
    if(g_USBRefNV.CDROMFlag)
    {
        slog(USBCFGMNG_PRINT,SLOG_DEBUG, "[usbCfgMng] usb_enum_FastPowerOffProc debug enum USB_CDROM\n");
        do_usb_enum(USB_CDROM);
    }
    else
    {
        slog(USBCFGMNG_PRINT,SLOG_DEBUG, "[usbCfgMng] usb_enum_FastPowerOffProc debug enum USB_DEBUG\n");
        do_usb_enum(USB_DEBUG);
    }
}

static void usb_enum_AmtProc(void)
{
    char usbDevice[USB_STR_FUNCTIONS_MAX_LEN] = {0};

    sc_cfg_get(USB_STR_ENUM_DEVICES_AMT, usbDevice, sizeof(usbDevice));
    strncat((char *)enum_functions,usbDevice,30);
    slog(USBCFGMNG_PRINT,SLOG_DEBUG, "[usbCfgMng] usb_enum_AmtProc >>>>>>>enum_functions = %s, usbDevice = %s\n", enum_functions, usbDevice); 

    g_USBRefNV.currentModeType = USB_AMT;
	writefile(USB_ENUM_MODE_PATH, "3", 1);

    usb_setSerialNum(USB_AMT);
    writefile(USB_FUNCTIONS_FILE_PATH, (char *)enum_functions, strlen((const char *)enum_functions));
}

static void usb_enum_Eye_diagramProc(void)
{
	char inquirypath[MAX_FILENAME_LEN] = {0};
    char cdrompath[MAX_FILENAME_LEN] = {0};
    char ropath[MAX_FILENAME_LEN] = {0};
    char filepath[MAX_FILENAME_LEN] = {0};
    char cdrom_path[MAX_FILENAME_LEN] = {0};
    char lunpath[MAX_FILENAME_LEN] = {0};
	
    g_USBRefNV.currentModeType = USB_EYE_DIAGRAM;
    writefile(USB_FUNCTIONS_FILE_PATH, "mass_storage", strlen("mass_storage"));
	writefile(USB_ENUM_MODE_PATH, "4", 1);

	snprintf(inquirypath, sizeof(inquirypath) , "%s%d%s", USB_MS_LUN_FILE_PATH, 0,STR_USB_MS_LUN_INQUIRY);
    snprintf(filepath, sizeof(filepath) , "%s%d%s", USB_MS_LUN_FILE_PATH, 0, STR_USB_MS_LUN_FILE);
    snprintf(cdrompath, sizeof(cdrompath) , "%s%d%s", USB_MS_LUN_FILE_PATH, 0, STR_USB_MS_LUN_CDROM);
    snprintf(ropath, sizeof(ropath) , "%s%d%s", USB_MS_LUN_FILE_PATH, 0,STR_USB_MS_LUN_RO);

	usb_NvGetMsInquiryString(MS_TYPE_MMC, inquirypath);//inquiryϢ
    usb_setMsLunAttrByMsType(MS_TYPE_MMC, cdrompath, ropath);

    writefile(USB_MS_LUN_NUM, "1" , 1); 
    sc_cfg_get(STR_TCARD_LUNPATH, lunpath, sizeof(lunpath));

    writefile(filepath,lunpath,strlen(lunpath));

     strncat((char *)enum_functions,  "mass_storage", strlen("mass_storage"));
}

static void usb_enum_FactoryProc(void)
{
    char usbDevice[USB_STR_FUNCTIONS_MAX_LEN] = {0};

    sc_cfg_get(USB_STR_ENUM_DEVICES_FACTORY, usbDevice, sizeof(usbDevice));
    strncat((char *)enum_functions,usbDevice,30);
    slog(USBCFGMNG_PRINT,SLOG_DEBUG, "[usbCfgMng] usb_enum_FactoryProc >>>>>>>enum_functions = %s, usbDevice = %s\n", enum_functions, usbDevice); 

    g_USBRefNV.currentModeType = USB_FACTORY;
	writefile(USB_ENUM_MODE_PATH, "2", 1);

    usb_setSerialNum(USB_FACTORY);
    writefile(USB_FUNCTIONS_FILE_PATH, (char *)enum_functions, strlen((const char *)enum_functions));
}

int usb_getPidByVnicType(e_usbEnum_type type, char* pid, int len)
{
    int ret = -1;
    
    if(type == USB_DEBUG)
    {
        if(strstr((char *)enum_functions, "rndis"))
        {
            ret = sc_cfg_get(STR_PID_TSP_RNDIS, pid, len);
        }
        else if(strstr((char *)enum_functions, "ecm"))
        {
            ret = sc_cfg_get(STR_PID_TSP_ECM, pid, len);
        }
        else if(strstr((char *)enum_functions, "ndis"))
        {
            ret = sc_cfg_get(STR_PID_TSP_NDIS, pid, len);
        }
        else if(strstr((char *)enum_functions, "mbim"))
        {
            ret = sc_cfg_get(STR_PID_TSP_MBIM, pid, len);
        }

    }
    else if(type == USB_USER)
    {
        if(strstr((char *)enum_functions, "rndis"))
        {
            ret = sc_cfg_get(STR_PID_USER_RNDIS, pid, len);
        }
        else if(strstr((char *)enum_functions, "ecm"))
        {
            ret = sc_cfg_get(STR_PID_USER_ECM, pid, len);
        }
        else if(strstr((char *)enum_functions, "ndis"))
        {
            ret = sc_cfg_get(STR_PID_USER_NDIS, pid, len);
        }
        else if(strstr((char *)enum_functions, "mbim"))
        {
            ret = sc_cfg_get(STR_PID_USER_MBIM, pid, len);
        }
        else if(!usb_isUserVnicExist(USB_USER))
        {
            ret = sc_cfg_get(STR_PID_USER_NOVNIC, pid, len);
            slog(USBCFGMNG_PRINT,SLOG_DEBUG, "[usbCfgMng] usb_getPidByVnicType STR_PID_USER_NOVNIC pid =%s\n", pid);
        }
    }

    if(ret != -1)
    {
        return ret;
    }

    ret = sc_cfg_get(STR_PID_TEST, pid, len);
    slog(USBCFGMNG_PRINT,SLOG_DEBUG, "[usbCfgMng] usb_getPidByVnicType error type = %d, enum_functions = %s, ret = %d\n", type, enum_functions, ret);
    return ret; 
}

void usb_NvGetPid(e_usbEnum_type type, char* pid, unsigned int pid_len )
{
    char temppid[8] = {0};
    int ret = -1;
    
    switch(type)
    {
        case USB_CDROM:
            if(g_USBRefNV.nvModeType == USB_MODETYPE_USER)
            {
                ret = sc_cfg_get(STR_PID_USER_CDROM, temppid, sizeof(temppid));
            }
            else if(g_USBRefNV.nvModeType == USB_MODETYPE_DEBUG)
            {
                ret = sc_cfg_get(STR_PID_TSP_CDROM, temppid, sizeof(temppid));
            }
            else
            {
                slog(USBCFGMNG_PRINT,SLOG_ERR, "[usbCfgMng] usb_NvGetPid cdrom pid error\n");
            }
            break;
        case USB_DEBUG:
            /*òͬpid*/
            ret = usb_getPidByVnicType(USB_DEBUG, temppid, sizeof(temppid));
            break;
        case USB_USER:
            /*òͬpid*/
            ret = usb_getPidByVnicType(USB_USER, temppid, sizeof(temppid));
            break;
        case USB_FACTORY:
            ret = sc_cfg_get(STR_PID_FACTORY, temppid, sizeof(temppid));
            break;
        case USB_AMT:
            ret = sc_cfg_get(STR_PID_AMT, temppid, sizeof(temppid));
            break;
	  case USB_EYE_DIAGRAM:
            ret = sc_cfg_get(STR_PID_EYE_DIAGRAM, temppid, sizeof(temppid));
            break;
        default:
            ret = sc_cfg_get(STR_PID_TEST, temppid, sizeof(temppid));
            slog(USBCFGMNG_PRINT,SLOG_DEBUG, "[usbCfgMng] usb_NvGetPid default..type = %d\n",type);
            break; 
    }
    
    if(strlen(temppid) != 0)
    {
        snprintf((char *)pid, pid_len, "%s",temppid);
    }
    else
    {
        sprintf((char *)pid, "ff00");
    }
    
    slog(USBCFGMNG_PRINT,SLOG_DEBUG, "[usbCfgMng] usb_NvGetPid pid=%s..type=%d, ret = %d\n", pid, type, ret);
}

void usb_param_SetReleaseID(e_usbEnum_type type)
{
    char releaseid[5] = {0};
    
    switch(type)
    {
        case USB_CDROM:
            if(g_USBRefNV.nvModeType == USB_MODETYPE_USER)
            {
                sc_cfg_get(STR_RELEASEID_USER, releaseid, sizeof(releaseid));
            }
            else
            {
                sc_cfg_get(STR_RELEASEID_TSP, releaseid, sizeof(releaseid));
            }

            break;
        case USB_USER:
            sc_cfg_get(STR_RELEASEID_USER, releaseid, sizeof(releaseid));
            break;
        default:
            sc_cfg_get(STR_RELEASEID_TSP, releaseid, sizeof(releaseid));
            slog(USBCFGMNG_PRINT,SLOG_DEBUG, "[usbCfgMng] usb_param_SetReleaseID default..type = %d\n",type);
            break; 
    }
    
    usb_param_config(releaseid, strlen(releaseid), USB_RELEASEID_FILE_PATH);
}

int usb_isMmcExist(void)
{
    int ret = 0;
    FILE *fd = NULL;
    char size_sd[12] = {0};
// sd card only can be attached to mmc1
	// fd = popen("cat /sys/kernel/debug/mmc0/present","r");	
    fd = popen("cat /sys/kernel/debug/mmc1/present","r");

    if(fd == NULL)
    {
        slog(USBCFGMNG_PRINT,SLOG_ERR, "[usbCfgMng]usb_isMmcExist popen file = NULL\n");
        return ret;
    }
    if(fgets(size_sd, sizeof(size_sd), fd) != NULL)
    {
        ret = atoi(size_sd);
    }

    pclose(fd);

    slog(USBCFGMNG_PRINT,SLOG_DEBUG, "[usbCfgMng]usb_isMmcExist :get size data = %d\n",ret);

    return ret;
}

e_usbEnum_Tcardtype usb_getSdcardModeOption(void)
{
    char tempModeType[2] = {0};
    int ret = -1;
    
    ret = sc_cfg_get(STR_SDCARD_MODE_OPT, tempModeType, sizeof(tempModeType));

    slog(USBCFGMNG_PRINT,SLOG_DEBUG, "[usbCfgMng] usb_getSdcardModeOption tempModeType =%s,ret = %d\n", tempModeType,ret);

    if(strcmp(tempModeType, "1") == 0)
    {
        return  USBCFG_HTTPSHARE; 
    }
    else
    {
        return USBCFG_USB;
    }
}

/*lun豸Ϣ*/
void usb_resetLunInfo(void)
{
    usb_resetMsLunFilePath();
    memset(&g_usbcfg_lunInfo, 0, sizeof(g_usbcfg_lunInfo));
    slog(USBCFGMNG_PRINT,SLOG_DEBUG, "[usbCfgMng]  usb_resetLunInfo\n"); 
}

#if 0
/*ȡڶ׶ι̽·*/
void usb_getCdromStep2LunPath(char *lun_path, int len)
{
    if(g_USBRefNV.CDROMFlagStep2 == 2) /*ؽ*/
    {
        sc_cfg_get(STR_CDROM_LUNPATH, lun_path, len);
        slog(USBCFGMNG_PRINT,SLOG_ERR, "[usbCfgMng]usb_getCdromStep2LunPath lun_path = %s\n", lun_path); 
    }
    else
    {
        sprintf((char *)(lun_path), "NULL");
    }
}
#endif

/*mass_storageʱlun·*/
void usb_setMSInfo(e_usbEnum_type type)
{
    //e_usbEnum_Tcardtype tcardType = usb_getSdcardModeOption();   //wangzhen
    
    if(strstr((char *)enum_functions, USB_STR_MASSSTORAGE))
    {
		usb_setMsDev(type);
    }
    
    return; 
}

void do_usb_enum(e_usbEnum_type type)
{
    char pid[8] = {0};
    memset(enum_functions, 0, USB_STR_FUNCTIONS_MAX_LEN);
    slog(USBCFGMNG_PRINT,SLOG_NORMAL, "[usbCfgMng] do_usb_enum type = %d\n", type); 

    /*öʱǰLUNϢ*/
    //usb_resetLunInfo();

    switch(type)
    {
        case USB_CDROM:
            usb_enum_CdromProc();
            break;
        case USB_DEBUG:
            usb_enum_DebugProc();
            break;
        case USB_USER:
            usb_enum_UserProc();
            break;
        case USB_FACTORY:
            usb_enum_FactoryProc();
            break;
        case USB_AMT:
            usb_enum_AmtProc();
            break;
        case USB_EYE_DIAGRAM:
            usb_enum_Eye_diagramProc();
            break;
        default:
            slog(USBCFGMNG_PRINT,SLOG_ERR, "[usbCfgMng] do_usb_enum default..\n");
            break;
    }
    usb_NvGetPid(type, pid,sizeof(pid));
    usb_param_config(pid, 4, USB_IDPRODUCT_FILE_PATH);
    usb_param_SetReleaseID(type);
    usb_NvGetParamConfig();
        
    if(strlen((const char*)enum_functions) != 0)
    { 
        usb_enable();
    }
    slog(USBCFGMNG_PRINT,SLOG_NORMAL, "[usbCfgMng] usb_enable end...\n"); 
}

void usb_NvGetUsbModeType(void)
{
    char tempModeType[12] = {0};
	char verMode[4] = {0};
    int ret = 0;

	ret = sc_cfg_get(STR_VER_MODE, verMode, sizeof(verMode));
    if(!strncmp(verMode, "0", strlen("0")))
    {
        g_USBRefNV.nvModeType = USB_MODETYPE_AMT;
		writefile(USB_ENUM_MODE_PATH, "3", 1);
        slog(USBCFGMNG_PRINT,SLOG_DEBUG, "### usbCfgMng usb_NvGetUsbModeType#### ver_mode amt\n");
        return;
    }
    
    if(!strncmp(verMode, "2", strlen("2")))
    {
        g_USBRefNV.nvModeType = USB_MODETYPE_FACTORY;
		writefile(USB_ENUM_MODE_PATH, "2", 1);
        slog(USBCFGMNG_PRINT,SLOG_DEBUG, "### usbCfgMng usb_NvGetUsbModeType#### ver_mode factory\n");
        return;
    }
	
    ret = nv_get_item(NV_RO, STR_USB_MODE_TYPE, tempModeType, sizeof(tempModeType));

    slog(USBCFGMNG_PRINT,SLOG_DEBUG, "[usbCfgMng] usb_NvGetUsbModeType ret = %d, tempModeType =%s\n", ret, tempModeType);

    if(!strcmp(tempModeType, "debug"))
    {
        g_USBRefNV.nvModeType = USB_MODETYPE_DEBUG;
		writefile(USB_ENUM_MODE_PATH, "0", 1);
    }
    else if(!strcmp(tempModeType, "user"))
    {
        g_USBRefNV.nvModeType = USB_MODETYPE_USER;
		writefile(USB_ENUM_MODE_PATH, "1", 1);
    }
    else if(!strcmp(tempModeType, "factory"))
    {
        g_USBRefNV.nvModeType = USB_MODETYPE_FACTORY;
		writefile(USB_ENUM_MODE_PATH, "2", 1);
    }
    else if(!strcmp(tempModeType, "amt"))
    {
        g_USBRefNV.nvModeType = USB_MODETYPE_AMT;
		writefile(USB_ENUM_MODE_PATH, "3", 1);
    }
    else
    {
        slog(USBCFGMNG_PRINT,SLOG_ERR, "[usbCfgMng] usb_NvGetUsbModeType error tempModeType =%s\n", tempModeType);
        g_USBRefNV.nvModeType = USB_MODETYPE_USER;
		writefile(USB_ENUM_MODE_PATH, "1", 1);

        slog(USBCFGMNG_PRINT,SLOG_ERR, "### usbCfgMng usb_NvGetUsbModeType error\n");
    }

    slog(USBCFGMNG_PRINT,SLOG_DEBUG, "[usbCfgMng] usb_NvGetUsbModeType#### g_USBRefNV.nvModeType =%d\n", g_USBRefNV.nvModeType);
}

void usb_NvSetUsbModeType(e_usbEnum_modeType modeType)
{
    char strModeType[12] = {0};
    e_usbEnum_type currentModeType = USB_INVALID;
    int ret =0;
    switch(modeType)
    {
        case USB_MODETYPE_DEBUG:
            strncpy(strModeType, "debug", 10);
            currentModeType = USB_DEBUG;
            break;
        case USB_MODETYPE_USER:
            strncpy(strModeType, "user", 10);
            currentModeType = USB_USER;
            break;
        case USB_MODETYPE_FACTORY:
            strncpy(strModeType, "factory", 10);
            currentModeType = USB_FACTORY;
            break;
        case USB_MODETYPE_AMT:
            strncpy(strModeType, "amt", 10);
            currentModeType = USB_AMT;
            break;
        default:
            slog(USBCFGMNG_PRINT,SLOG_DEBUG, "[usbCfgMng] usb_NvSetUsbModeType default..modeType = %d\n", modeType);
            break;
    }
    
    strModeType[9] = '\0';
    ret = nv_set_item(NV_RO, "usb_modetype", strModeType, 1);

    slog(USBCFGMNG_PRINT,SLOG_DEBUG, "[usbCfgMng] usb_NvSetUsbModeType sc_cfg_set ret = %d,modeType =%d\n", ret, modeType);
    ret = nv_commit(NV_RO); //ɾҪ̱NV

    slog(USBCFGMNG_PRINT,SLOG_DEBUG, "[usbCfgMng] usb_NvSetUsbModeType sc_cfg_save ret = %d\n", ret);
    g_USBRefNV.nvModeType = modeType;
    g_USBRefNV.currentModeType= currentModeType;//¼ǰģʽ
}

void usb_NvGetCdromState(void)
{
    char cdromFlag[2] = {0};
    
    sc_cfg_get(NV_NEED_CDROM_STEP1, cdromFlag, sizeof(cdromFlag));

    if(0 == strcmp(cdromFlag, "1"))
    {
        g_USBRefNV.CDROMFlag = 1;
		writefile(USB_FORCE_NET_FILE_NAME, "0", 1);
    }
    else
    {
        g_USBRefNV.CDROMFlag = 0;
		writefile(USB_FORCE_NET_FILE_NAME, "1", 1);
    }

    memset(cdromFlag, 0, sizeof(cdromFlag));
    sc_cfg_get(NV_NEED_CDROM_STEP2, cdromFlag, sizeof(cdromFlag));
    if(0 == strcmp(cdromFlag, "1"))
    {
        g_USBRefNV.CDROMFlagStep2 = 1;
    }
    else if(0 == strcmp(cdromFlag, "2"))
    {
        g_USBRefNV.CDROMFlagStep2 = 2;
    }
    else
    {
        g_USBRefNV.CDROMFlagStep2 = 0;
    }

    slog(USBCFGMNG_PRINT,SLOG_DEBUG, "[usbCfgMng]  CDROMFlag:%d, CDROMFlagStep2:%d\n",
		g_USBRefNV.CDROMFlag, g_USBRefNV.CDROMFlagStep2);
}

void usb_CfgInfoInit(void)
{
    usb_NvGetUsbModeType();
    usb_NvGetCdromState();
}

/*usb룬ݲ״̬usbģʽusb豸*/
void usb_PlugInProc(int plugType)
{  
    if(plugType){
        if(g_USBRefNV.Fast_PowerOffFlag)/*ȲʱҪֱӽٹػģʽ*/
            usb_enum_FastPowerOffProc();
        else if(g_USBRefNV.CDROMFlag && g_USBRefNV.nvModeType != USB_MODETYPE_FACTORY 
            && g_USBRefNV.nvModeType != USB_MODETYPE_AMT)
            do_usb_enum(USB_CDROM);/*cdrom*/
        else if(g_USBRefNV.nvModeType == USB_MODETYPE_DEBUG)
            do_usb_enum(USB_DEBUG);/*cdromusb豸*/
        else if(g_USBRefNV.nvModeType == USB_MODETYPE_USER)
            do_usb_enum(USB_USER);
        else if(g_USBRefNV.nvModeType == USB_MODETYPE_FACTORY)
            do_usb_enum(USB_FACTORY);
        else if(g_USBRefNV.nvModeType == USB_MODETYPE_AMT)
            do_usb_enum(USB_AMT);
    }
    else
        slog(USBCFGMNG_PRINT,SLOG_DEBUG, "[usbCfgMng] usb_PlugInProc plugType = %d\n", plugType);
}

/*cdromлusb*/
void usb_enum_CdromObject(void)
{
    writefile(USB_ENMODS_FILE_NAME, "0", 1);
    usb_NvGetUsbModeType();
	
	if(OSType_Windows != zDrvSys_GetOSType()){
		g_USBRefNV.CDROMFlagStep2 = 0;
		printf("--gsn--for non windows, CDROMFlagStep2 = %d\n", g_USBRefNV.CDROMFlagStep2);
	}

    if(g_USBRefNV.nvModeType == USB_MODETYPE_DEBUG){
        slog(USBCFGMNG_PRINT,SLOG_DEBUG, "[usbCfgMng] usb_enum_CdromObject debug\n");
        do_usb_enum(USB_DEBUG);
    }
    else if(g_USBRefNV.nvModeType == USB_MODETYPE_USER){
        slog(USBCFGMNG_PRINT,SLOG_DEBUG, "[usbCfgMng] usb_enum_CdromObject user\n");
        do_usb_enum(USB_USER);
    }
    else if(g_USBRefNV.nvModeType == USB_MODETYPE_FACTORY){
        slog(USBCFGMNG_PRINT,SLOG_DEBUG, "[usbCfgMng] usb_enum_CdromObject factory\n");
        do_usb_enum(USB_FACTORY);
    }
    else if(g_USBRefNV.nvModeType == USB_MODETYPE_AMT){
        slog(USBCFGMNG_PRINT,SLOG_DEBUG, "[usbCfgMng] usb_enum_CdromObject amt\n");
        do_usb_enum(USB_AMT);
    }
    slog(USBCFGMNG_PRINT,SLOG_DEBUG, "[usbCfgMng] usbconfig change USBEVENT=usb_switch g_USBRefNV.currentModeType =%d\n", g_USBRefNV.currentModeType);
}

int usb_GetUsbPlugState(void)
{
    int usbPlugtype =  -1;
    int rtv = -1;
    char flagBuf[USB_FLAG_BUF_LEN]={0};

    rtv = readfile(USB_PLUG_FILE_NAME, flagBuf, USB_FLAG_BUF_LEN -1);
    if(rtv < 0){
        slog(USBCFGMNG_PRINT,SLOG_ERR, "[usbCfgMng] usb_GetUsbPlugState: readfile %s fail \n", USB_PLUG_FILE_NAME);
        return -1;
    }
    
    usbPlugtype = atoi(flagBuf);
    return usbPlugtype;
}

void usb_usbCfgMngInit(int usbPlugType)
{
    g_USBRefNV.currentModeType = USB_INVALID;

    /*ʼϢ߳*/
    usb_initUsbCfgMsg();
    usbcfg_AppInitProc();
    
    usbcfg_getMutex(&g_usbcfg_usbenum_mutex);
    usb_CfgInfoInit();
    usb_PlugInProc(usbPlugType);
    usbcfg_putMutex(&g_usbcfg_usbenum_mutex);
}

void usb_PowerOffChargerEntry(void)
{
    int usbPlugtype = -1;
    char need_cp_udisk[8] = {0};
	
    usb_NvGetUsbModeType();

    if(g_USBRefNV.nvModeType == USB_MODETYPE_USER)
    {
	 usbPlugtype = usb_GetUsbPlugState();
	 if(usbPlugtype == 1){
	 	sc_cfg_get(NV_NEED_CP_UDISK, need_cp_udisk,sizeof(need_cp_udisk));
		 if(strncmp(need_cp_udisk, "yes", strlen("yes")) != 0) /*Sys֧֧CPU/Tл*/
    		{
	 		sprintf((char *)enum_functions, USB_STR_MASSSTORAGE);
        		writefile(USB_FUNCTIONS_FILE_PATH, USB_STR_MASSSTORAGE, strlen(USB_STR_MASSSTORAGE));
			g_usbcfg_lunInfo.usb_lunNum=1;
			writefile(USB_MS_LUN_NUM, "1", strlen("1")); 
			g_usbcfg_lunInfo.lun_info[0].mstype=MS_TYPE_CDROM;
			//usb_getLunPath(0);			
			usb_setMsLunInfoToDrv();
			usb_param_config("2004", 4, USB_IDPRODUCT_FILE_PATH);
			usb_enable();
		 }else{
		 	slog(USBCFGMNG_PRINT,SLOG_DEBUG, "[usbCfgMng] ### usb_PowerOffChargerEntry cp need udisk\n");
		 }
	 }else{
		slog(USBCFGMNG_PRINT,SLOG_ERR, "[usbCfgMng] ### usb_PowerOffChargerEntry exit usb is not in\n");
	 }
	 pthread_exit(0);
    }
}

int usb_change_event_proc(int usb_event)
{
    int plug_state = 0;

    plug_state = usb_GetUsbPlugState();
    if(plug_state < 0)
    {
        slog(USBCFGMNG_PRINT,SLOG_ERR, "[usbCfgMng]usb_change_event_proc get plugstate fail \n");
        return -1;
    }

    switch(usb_event)
    {
    case USB_EVENT_CDROMOBJ:
        usb_enum_CdromObject();
        break;
    case USB_EVENT_USER:
        usb_NvSetUsbModeType(USB_MODETYPE_USER);
        usb_PlugInProc(plug_state);
        break;
    case USB_EVENT_DEBUG:
        usb_NvSetUsbModeType(USB_MODETYPE_DEBUG);
        usb_PlugInProc(plug_state);
        break;
    case USB_EVENT_FACTORY:
        do_usb_enum(USB_FACTORY);
        usb_NvSetUsbModeType(USB_MODETYPE_FACTORY);
        break;
    case USB_EVENT_AMT:
        do_usb_enum(USB_AMT);
        usb_NvSetUsbModeType(USB_MODETYPE_AMT);
        break;
    case USB_EVENT_EYE_DIAGRAM:
        do_usb_enum(USB_EYE_DIAGRAM);
        break;
    case USB_EVENT_RESET:
        slog(USBCFGMNG_PRINT,SLOG_DEBUG, "[usbCfgMng]usb_change_event_proc event reset \n");
        usb_disable();
        usb_enable();
        break;
    default:
        break;
    }
	config_console_input();

    return 0;
}

/*jb.qi add for usb wakelock on 20230918 start*/
#define RPMSG_IOC_MAGIC     'R'

/*ioctl cmd usd by device*/
#define RPMSG_CREATE_CHANNEL          _IOW(RPMSG_IOC_MAGIC, 1, char *)
#define RPMSG_GET_DATASIZE       _IOWR(RPMSG_IOC_MAGIC, 2, char *)
#define RPMSG_SET_INT            _IOW(RPMSG_IOC_MAGIC, 3, char *)
#define RPMSG_SET_INT_FLAG        _IOW(RPMSG_IOC_MAGIC, 4, char *)
#define RPMSG_CLEAR_INT_FLAG      _IOW(RPMSG_IOC_MAGIC, 5, char *)
#define RPMSG_SET_POLL_FLAG       _IOW(RPMSG_IOC_MAGIC, 6, char *)
#define RPMSG_CLEAR_POLL_FLAG     _IOW(RPMSG_IOC_MAGIC, 7, char *)

#define USB_PLUG_WAKE_CAP_DEV    "/dev/rpmsg50"

int usbplug_fd = -1;

int usbplug_icp_init(void)
{
    usbplug_fd = open(USB_PLUG_WAKE_CAP_DEV, O_RDWR);

    if(0 > usbplug_fd){
        printf("%s: open the channel(%s) error!\n", __func__, USB_PLUG_WAKE_CAP_DEV);
        return -1;
    }

    if(0 > ioctl(usbplug_fd, RPMSG_CREATE_CHANNEL, 64)){
        printf("%s: ioctl RPMSG_CREATE_CHANNEL fail!\n", __func__);
        close(usbplug_fd);
        usbplug_fd = -1;
        return -1;
    }

    if(0 > ioctl(usbplug_fd, RPMSG_SET_INT_FLAG, NULL)){ //
        printf("%s: ioctl RPMSG_SET_INT_FLAG fail!\n", __func__);
        close(usbplug_fd);
        usbplug_fd = -1;
        return -1;
    }

    printf("yanming %s create success!\n",__func__);

    return 0;
}

int usbplug_rpmsg_send(int value)
{
    int write_len = 0;
    char usbplug_in[20]="usbplug_in";
    char usbplug_out[20]="usbplug_out";

    printf("usbplug_rpmsg_send value:%d\n",value);

    if(value == 1){
        write_len = write(usbplug_fd, usbplug_in, sizeof(usbplug_in));
    }

    if(value == 0){
        write_len = write(usbplug_fd, usbplug_out, sizeof(usbplug_out));
    }

    if(write_len <0){
        printf("usbplug rpmsg write FAIL\n");
        close(usbplug_fd);
    }

    return write_len;
}
/*jb.qi add for usb wakelock on 20230918 end*/
/*usbȰβ¼*/
int usb_event_proc(unsigned short usb_msg, int usb_event)
{
    usbcfg_getMutex(&g_usbcfg_usbenum_mutex);
    switch(usb_msg)
    {
    case MSG_CMD_DRV_USB_CHANGE:
        /*change¼*/
        set_wake_lock(USBCFG_MAIN_LOCK_ID);
        usb_disable(); 
        usb_resetLunInfo();
        usbcfg_putMutex(&g_usbcfg_usbenum_mutex);
		usleep(1000 * 300);
        usbcfg_getMutex(&g_usbcfg_usbenum_mutex);
        /*usb event¼*/
        usb_change_event_proc(usb_event);

        set_wake_unlock(USBCFG_MAIN_LOCK_ID);
        break;
    case MSG_CMD_DRV_USB_ADD:
        /*¼*/
        if(USB_EVENT_DEVICE == usb_event)
        {
            usb_CfgInfoInit();
            usb_PlugInProc(1);
	     if (cp_need_udisk == 1)
	    	   usb_sendUsbOperateRlt(1);
        }
        else if(USB_EVENT_CHARGE == usb_event)
        {
            slog(USBCFGMNG_PRINT,SLOG_NORMAL, "[usbCfgMng] usb charger plugin \n");
        }
	usbplug_rpmsg_send(1);//jb.qi add for usb wakelock on 20230918
        break;
    case MSG_CMD_DRV_USB_REMOVE:
        /*γ¼*/
        if(USB_EVENT_DEVICE == usb_event)
        {
            usb_UnRegisterUdiskHook();
            set_wake_lock(USBCFG_MAIN_LOCK_ID);
            usb_disable();
            usb_resetLunInfo();
            set_wake_unlock(USBCFG_MAIN_LOCK_ID);
	      if (cp_need_udisk == 1)
	     	  usb_sendUsbOperateRlt(0);
        }
        else if(USB_EVENT_CHARGE == usb_event)
        {
            slog(USBCFGMNG_PRINT,SLOG_NORMAL, "[usbCfgMng] usb charger plugOut \n");
        }
	usbplug_rpmsg_send(0);//jb.qi add for usb wakelock on 20230918
        break;
    default:
        break;
    }
    usbcfg_putMutex(&g_usbcfg_usbenum_mutex);
    return 0;
}
#if 0
/*usbȰβʼ*/
static void usb_hotplug_init()
{
    hotplug_parse_register(DEV_TYPE_USB, usb_msg_parse);
    hotplug_proc_register(DEV_TYPE_USB, usb_event_proc);
}

/*ȰβϢ*/
static int hotplug_msg_parse(char *msg, int msglen, struct hotplug_event *event)
{
    int act_type = 0;
    int i = 0;
    int ret = 0;

    /*Ϣе\0滻\n*/
    usb_event_analyse(msg, msglen);
    
    act_type = get_action_type(msg, msglen);
    if(act_type < 0)
    {
        slog(USBCFGMNG_PRINT,SLOG_ERR, "[usbCfgMng]hotplug get action type failed!\n");
        return -1;        
    }
    event->action = act_type;

    for(i = 0; i < DEV_TYPE_MAX; i++)
    {
        if(usb_hotplug_parse_ptr[i])
        {
            ret = usb_hotplug_parse_ptr[i](msg, msglen, event);
            if(0 == ret)
                return 0;
        }
    }

    return -1;
}

/*Ȱβ¼*/
int hotplug_event_proc(struct hotplug_event *event)
{
    int ret = 0;
    if(event->type < DEV_TYPE_MAX && event->type >= 0)
    {
        if(usb_hotplug_proc_ptr[event->type])
        {
            ret = usb_hotplug_proc_ptr[event->type](event);
            return ret;
        }
    }

    return -1;
}

/*Ȱβʼ*/
void hotplug_proc_init()
{
    char need_cp_udisk[8] = {0};
    
    sc_cfg_get(NV_NEED_CP_UDISK, need_cp_udisk,sizeof(need_cp_udisk));
    
    usb_hotplug_init();

    if(0 == strncmp(need_cp_udisk, "yes", strlen("yes"))) /*Sys֧֧CPU/Tл*/
    {
        cp_need_udisk = 1;
        sdcard_hotplug_init();
        virtual_sdcard_hotplug_init();
    }
}
#endif
void usb_msg_proc(MSG_BUF* stMsg)
{
	int usb_event = 0;

    slog(USBCFGMNG_PRINT,SLOG_DEBUG,"recv usMsgCmd = %x\n",stMsg->usMsgCmd);
	if(stMsg->usMsgCmd < MSG_CMD_DRV_SD_ADD) {
		memcpy(&usb_event,stMsg->aucDataBuf,sizeof(int));
		usb_event_proc(stMsg->usMsgCmd, usb_event);
	}
	else if(stMsg->usMsgCmd < MSG_CMD_DRV_VSD_ADD)
		sd_event_proc(stMsg->usMsgCmd);
	else
		vsd_event_proc(stMsg->usMsgCmd);
}
void config_console_input(void)
{
	int ret = 0;
    char tempModeType[12] = {0};

    ret = nv_get_item(NV_RO, STR_USB_MODE_TYPE, tempModeType, sizeof(tempModeType));

    slog(USBCFGMNG_PRINT,SLOG_DEBUG, "[usbCfgMng] config_console_input ret = %d, tempModeType =%s\n", ret, tempModeType);

    if(!strcmp(tempModeType, "user"))
    {
		writefile(UART_CONSOLE_INPUT_PATH, "0", 1);
    }else{
		writefile(UART_CONSOLE_INPUT_PATH, "1", 1);
    } 
writefile(UART_CONSOLE_INPUT_PATH, "1", 1);
}
static int usb_ctrl_init(void)
{
	int usbPlugtype = -1;
	char verMode[4] = {0};
	char gpio_detect[4] = {0};
	char need_cp_udisk[8] = {0};
	int ret = 0;
	unsigned char read_mac[32] = {0};
	void *p1[]={read_mac};
    sc_cfg_get(NV_USB_GPIO_DETECT,gpio_detect,sizeof(gpio_detect));
    if(strncmp(gpio_detect,"1",sizeof("1")) == 0){
		writefile(USB_GPIO_DETECT_ENABLE, "1", 1);
	     slog(USBCFGMNG_PRINT,SLOG_ERR, "[usbCfgMng] set gpio detect enable\n");		 
    }

	pthread_mutex_init(&g_usbcfg_usbenum_mutex,NULL);

#if (PRODUCT_TYPE != PRODUCT_TH)   
    sc_cfg_get(STR_VER_MODE,verMode,sizeof(verMode));
    if(strncmp(verMode,"0",sizeof("0")) != 0){
	    ret = get_modem_info2("at+usbmac?\r\n","%s",p1,0,5);
		if(ret < 0){
			slog(USBCFGMNG_PRINT,SLOG_ERR, "[usbCfgMng] get mac addr faild\n");
		}
		sprintf (netMacAddr, "%c%c:%c%c:%c%c:%c%c:%c%c:%c%c",
		         read_mac[0], read_mac[1], read_mac[2], read_mac[3], read_mac[4], read_mac[5],
		         read_mac[6], read_mac[7], read_mac[8], read_mac[9], read_mac[10], read_mac[11]);
	     slog(USBCFGMNG_PRINT,SLOG_ERR, "[usbCfgMng] usb net mac addr is:%s\n",netMacAddr);
    	}
#endif

	sc_cfg_get(NV_NEED_CP_UDISK, need_cp_udisk,sizeof(need_cp_udisk));

	if(0 == strncmp(need_cp_udisk, "yes", strlen("yes"))) /*Sys֧֧CPU/Tл*/
    	cp_need_udisk = 1;

	/*ȶȡusb״̬ڿ֮ǰѾUSB豸
      ֮usb״̬UEVENTϱ״̬ж*/
    usbPlugtype = usb_GetUsbPlugState();
    if(usbPlugtype < 0){
        slog(USBCFGMNG_PRINT,SLOG_ERR, "[usbCfgMng] warning: readfile %s fail \n", USB_PLUG_FILE_NAME);
        return -1;
    }
    /*jb.qi add for usb wakelock on 20230918 start*/
    printf("usbPlugtype:%d\n",usbPlugtype);
    if(usbPlugtype == 1)
	sc_cfg_set("usbplug_nv","1");
   
    if(usbPlugtype == 0)
	sc_cfg_set("usbplug_nv","0");
    usbplug_icp_init();
    /*jb.qi add for usb wakelock on 20230918 end*/
    usb_usbCfgMngInit(usbPlugtype);
    if (usbPlugtype == 1 && cp_need_udisk == 1)
		usb_sendUsbOperateRlt(2);

	return 0;
}

/*
 *check and set usb serial number by chip id from efuse
 *
 *
 */
void usb_set_serialid_by_chipid(void)
{
	int en_flag = -1;
	int ret = 0;
	char str_en_flag[2] = {0};
	int fd_efuse = -1;
	char iSerial[32] = {0};


        sc_cfg_get(USB_SET_SERNUM_BY_CHIPID, str_en_flag, sizeof(str_en_flag));

	slog(USBCFGMNG_PRINT,SLOG_ERR, "[usbCfgMng] usb_set_sernum_by_chipid ret = %d, tempModeType =%s\n", ret, str_en_flag);

	en_flag = atoi(str_en_flag);   
	
	if(en_flag == 0){
		printf(" don't need chipid return\n");
		return ;
	}
	sc_cfg_get(STR_SERIAL_TSP, iSerial, sizeof(iSerial));
	if(strcmp(iSerial, "1234567890ABCDEF")){
		printf("iSerial already set, value is:%s \n", iSerial);
		return ;
	}
	memset(&g_efuse_chipinfo, 0, sizeof(g_efuse_chipinfo));
	
	fd_efuse = open("/dev/efuse", O_RDWR);
	if(fd_efuse < 0){
		printf(" open /dev/efuse fail, ret:%d return\n", fd_efuse);
		return ;
	}	
	ret = ioctl(fd_efuse, EFUSE_GET_DATA, &g_efuse_chipinfo);
	if(ret < 0){
		printf(" read EFUSE_GET_DATA fail, ret:%d \n", ret);
		
		goto END;
		
	}
	printf("usb_set_serialid_by_chipid, now set chipid for serid,%x\n", (g_efuse_chipinfo.secureDevId[0]));
	printf("usb_set_serialid_by_chipid, now set chipid for serid,%x\n", (g_efuse_chipinfo.secureDevId[1]));
	printf("usb_set_serialid_by_chipid, now set chipid for serid,%x\n", (g_efuse_chipinfo.secureDevId[2]));
	memset(iSerial, 0, 32);
	
	sprintf(iSerial,"%X%X%X", g_efuse_chipinfo.secureDevId[0], g_efuse_chipinfo.secureDevId[1], g_efuse_chipinfo.secureDevId[2] );
	
	sc_cfg_set(STR_SERIAL_TSP, iSerial);
	sc_cfg_save();
END:
	close(fd_efuse);
	fd_efuse = -1;
	
}
int zte_drv_usb_ctrl_main(int argc, char* argv[])  
{     
    int ret = 0;
	int i = 0;
	int iMsgHandle = 0;
	MSG_BUF stMsg;
	LONG msgSize =  sizeof(MSG_BUF)-sizeof(LONG);
	int interruptSIG = 0;
	prctl(PR_SET_NAME, "usb_ctrl", 0, 0, 0);
	pthread_detach(pthread_self());//bug72309̰߳
    if(argc >= 2)
    {
        usb_PowerOffChargerEntry();
        slog(USBCFGMNG_PRINT,SLOG_ERR, "[usbCfgMng] ###POWER OFF CHARGER Entry####\n");
    }
	config_console_input();
	usb_set_serialid_by_chipid();
	if(zDrvRef_NvGetForceNetCardType() == FORCE_MBIM){
		writefile(UART_CONSOLE_INPUT_PATH, "1", 1);
	}
	usb_ctrl_init();

	iMsgHandle = msgget(MODULE_ID_USBHOTPLUG, IPC_CREAT | 0600);
	
	if(-1 == iMsgHandle)
    {
        slog(USBCFGMNG_PRINT,SLOG_ERR,"usbCfgMng create msg queue fail!\n");
        return -1;
    }
    
    while(1){      
        
        ret = msgrcv(iMsgHandle, &stMsg, msgSize, 0, 0); 
        if(ret == -1)
        {
            if (EINTR == errno)
            {
                interruptSIG = 1;
                continue;
            }
            else
            {
				slog(USBCFGMNG_PRINT,SLOG_ERR,"usbCfgMng recv msg fail \n");
                return -1;
            }
        }
		else
		{
			usb_msg_proc(&stMsg);
		}
    }       
}



