#include <sys/syscall.h>
#include <linux/reboot.h>
#include <openssl/aes.h>

#include "rtc_timer.h"
#include "zte_mainctrl.h"
#include "libcpnv.h"
/**************************************************************************
 *                           Global Variables                             *
 **************************************************************************/

char ps_wan[ZTE_ROUTER_WAN_IF_NAME_LEN] = {0};
char usb_wan[ZTE_ROUTER_WAN_IF_NAME_LEN] = {0};
char eth_wan[ZTE_ROUTER_WAN_IF_NAME_LEN] = {0};
char wifi_wan[ZTE_ROUTER_WAN_IF_NAME_LEN] = {0};

unsigned char ethwan_id = 0; //RJ45ڵĳʱ
unsigned char wifiwan_id = 0;//wifiڵĳʱ

int g_limit_time_flag = 0; //ڼҳģʽ 1ֹʱ 0 ʱ

//¼Ƿڻָã˽׶βsc_cfg_saveȲ
int g_mainctrl_factory_reset    = 0;
int g_mainctrl_reset_ext_cmd    = 0;
int g_mainctrl_poweroff_ext_cmd = 0;
int g_mainctrl_restart_ext_cmd  = 0;

struct list_head g_mainctrl_reset_notify;
struct list_head g_mainctrl_poweroff_notify;
struct list_head g_mainctrl_restart_notify;
#if (MODEM_TYPE == vehicle_dc)
extern struct list_head g_firewall_ip;
#endif

//reset𷽲Ҫ豸rebootresetϢκ
static int g_restart_from = 0;
static int g_restart_subaction = Operate_By_SOC;
static int g_poweroff_from = 0;

//ATpdpϢATһûڶAT
static int g_pdpact_reqing = 0;//pdpϢһδյظ
static int g_pdpdeact_reqing = 0;//pdpȥϢһδյظ
int g_poweron_type = 0;
#define itoa(i,a,b) (((b) == 16) ? sprintf((a), "%x", (i)) : sprintf((a), "%d", (i)))

//bsim
typedef struct
{
	unsigned int pubKeyRsaE[32];
	unsigned int pubKeyRsaN[32];
	unsigned int secureFlag;
	unsigned int pubKeyHash[4];
	unsigned int secureDevId[3];
}T_ZDrvEfuse_Secure;

#define EFUSE_IOC_MAGIC 	'E'
#define EFUSE_GET_DATA 		_IOWR(EFUSE_IOC_MAGIC, 1, char *)
#define PPPOE_CODE_LEN 		32 //webui limit 30

unsigned char pppoe_aes_key[16] = {0};

static int bs_string2bytes(const char* pSrc, unsigned char* pDst, int nSrcLength)
{
    int i=0;

    //У
    if(pSrc ==  NULL || pDst == NULL || nSrcLength < 0)
    {
        return -1;
    }

    for(i = 0; i < nSrcLength; i += 2)
    {
        // 4λ
        if(*pSrc >= '0' && *pSrc <= '9')
        {
            *pDst = (*pSrc - '0') << 4;
        }
        else
        {
            *pDst = ((toupper(*pSrc) - 'A') + 10) << 4;
        }

        pSrc++;

        // 4λ
        if(*pSrc >= '0' && *pSrc <= '9')
        {
            *pDst |= *pSrc - '0';
        }
        else
        {
            *pDst |= (toupper(*pSrc) - 'A') + 10;
        }

        pSrc++;
        pDst++;
    }

    // Ŀݳ
    return nSrcLength / 2;
}

static int bs_bytes2string(const unsigned char* pSrc, char* pDst, int nSrcLength)
{
    const char tab[]="0123456789ABCDEF";	// 0x0-0xfַұ
    int i = 0;

    //У
    if(pSrc ==  NULL || pDst == NULL || nSrcLength < 0)
    {
        return -1;
    }

    for(i=0; i<nSrcLength; i++)
    {
        *pDst++ = tab[*pSrc >> 4];		// 4λ
        *pDst++ = tab[*pSrc & 0x0f];	// 4λ
        pSrc++;
    }

    // Ŀַ
    return nSrcLength * 2;
}

static int bs_aes_init_key(unsigned char *aes_key, int k_len)
{
	int efuse_fd = -1;
	T_ZDrvEfuse_Secure efuse = {0};
	
	memset(&efuse, 0, sizeof(efuse));
	efuse_fd = open("/dev/efuse", O_RDWR);
	if (efuse_fd < 0) {
		printf("wifi_aes_init_key efuse open errno=%d\n", errno);
		return 0;
	}
	if(ioctl(efuse_fd , EFUSE_GET_DATA, &efuse) != 0) {
		printf("wifi_aes_init_key efuse ioctl errno=%d\n", errno);
		close(efuse_fd);
		return 0;
	}
	close(efuse_fd);
	memcpy(aes_key, efuse.pubKeyHash, k_len);
	
	return 1;
}

static int bs_aes_encrypt(char* in, int len, char* out, unsigned char* key, int key_len)
{
    if (!in || !out || !key || len <=0 || (len%AES_BLOCK_SIZE)!=0 || (key_len!=16 && key_len!=24 && key_len!=32)) {
		printf("bs_aes_encrypt err in=%p out=%p key=%p len=%d key_len=%d\n",in,key,out,len,key_len);
        return 0;
    }
 
    AES_KEY aes = {0}; //cov h
    if (AES_set_encrypt_key(key, key_len*8, &aes) < 0) {
		printf("bs_aes_encrypt AES_set_encrypt_key err\n");
        return 0;
    }
 
    int en_len = 0;
    while (en_len < len) {
        AES_encrypt((unsigned char*)in, (unsigned char*)out, &aes);
        in	+= AES_BLOCK_SIZE;
        out += AES_BLOCK_SIZE;
        en_len += AES_BLOCK_SIZE;
    }
 
    return 1;
}

static int bs_aes_decrypt(char* in, int len, char* out, char* key, int key_len)
{
    if (!in || !out || !key || len <=0 || (len%AES_BLOCK_SIZE)!=0 || (key_len!=16 && key_len!=24 && key_len!=32)) {
		printf("bs_aes_decrypt err in=%p out=%p key=%p len=%d key_len=%d\n",in,key,out,len,key_len);
        return 0;
    }
 
    AES_KEY aes = {0}; //cov h
    if (AES_set_decrypt_key((unsigned char*)key, key_len*8, &aes) < 0) {
		printf("bs_aes_decrypt AES_set_decrypt_key err\n");
        return 0;
    }
 
    int en_len = 0;
    while (en_len < len) {
        AES_decrypt((unsigned char*)in, (unsigned char*)out, &aes);
        in	+= AES_BLOCK_SIZE;
        out += AES_BLOCK_SIZE;
        en_len += AES_BLOCK_SIZE;
    }
 
    return 1;
}

int pppoe_encrypt_code(void)
{
	char w_code[PPPOE_CODE_LEN + 1]= {0};
	char b_aes[PPPOE_CODE_LEN + 1] = {0};
	char s_aes[PPPOE_CODE_LEN*2 + 1] = {0};

	sc_cfg_get("pppoe_cc", w_code, sizeof(w_code));
	bs_aes_encrypt(w_code, PPPOE_CODE_LEN, b_aes, pppoe_aes_key, sizeof(pppoe_aes_key));
	bs_bytes2string(b_aes, s_aes, PPPOE_CODE_LEN);
	sc_cfg_set("pppoe_password", s_aes);
	printf("encrypt pppoe_cc w_code=%s, s_aes=%s\n", w_code, s_aes);

	return 1;
}
//2ʾfotaϰ汾pppoe_password룬°汾
int pppoe_decrypt_code(void)
{
	char w_code[PPPOE_CODE_LEN + 1]= {0};
	char b_aes[PPPOE_CODE_LEN + 1] = {0};
	char s_aes[PPPOE_CODE_LEN*2 + 1] = {0};
	int flag = 0;

	sc_cfg_get("pppoe_password", s_aes, sizeof(s_aes));
	if (strlen(s_aes) == PPPOE_CODE_LEN*2) {
		bs_string2bytes(s_aes, b_aes, PPPOE_CODE_LEN*2);
		bs_aes_decrypt(b_aes, PPPOE_CODE_LEN, w_code, pppoe_aes_key, sizeof(pppoe_aes_key));
		sc_cfg_set("pppoe_cc", w_code);
//		printf("decrypt pppoe_cc w_code=%s, s_aes=%s\n", w_code, s_aes);
	} else if (strlen(s_aes) > 0){
		sc_cfg_set("pppoe_cc", s_aes);
		return 2;
	}

	return 1;
}

int pppoe_aes_init(void)
{
	bs_aes_init_key(pppoe_aes_key, sizeof(pppoe_aes_key));
	if (2 == pppoe_decrypt_code())
		pppoe_encrypt_code();

	return 1;
}

/* ¼restartͣ¼ǷչAT ԼǷREBOOT */
void record_restart_type(MSG_BUF *msg)
{
	restart_info *msgData = NULL;
	
	//չATҪATϢsubActionΪRestart_By_MCUĲҪreboot
	if (msg->usMsgCmd == MSG_CMD_RESET_REQUEST || msg->usMsgCmd == MSG_CMD_RESTART_REQUEST) {
		if (msg->src_id == MODULE_ID_AT_CTL) { //չAT
			g_restart_from = msg->src_id;
		} else {
			g_restart_from = 0;
		}
		
		if (msg->usDataLen > 0) {
			msgData = (restart_info*)msg->aucDataBuf;
			if (msgData->subaction == Operate_By_MCU) {
				g_restart_subaction = Operate_By_MCU;
			} else {
				g_restart_subaction = Operate_By_SOC;
			}
		} else {
			g_restart_subaction = Operate_By_SOC;
		}
	}
	slog(NET_PRINT, SLOG_NORMAL, "record_restart_type = %d--%d\n", g_restart_from, g_restart_subaction);

}

void record_poweroff_type(MSG_BUF *msg)
{
	slog(NET_PRINT, SLOG_NORMAL, "record_poweroff_type msg->src_id = 0x%x, msg->usMsgCmd = 0x%x\n", msg->src_id, msg->usMsgCmd);

	//Ҫreboot
	if (msg->src_id == MODULE_ID_AT_CTL && msg->usMsgCmd == MSG_CMD_POWEROFF_REQUEST) //չAT
		g_poweroff_from = msg->src_id;
	else
		g_poweroff_from = 0;
	slog(NET_PRINT, SLOG_NORMAL, "record_poweroff_type = 0x%x\n", g_poweroff_from);
}

/**********************************************************************************
:õǷ߿ģʽ:1:;0:
***********************************************************************************/
static int get_wan_mode()
{
	char blc_wan_mode[16] = {0};
	char blc_wan_auto_mode[16] = {0};

	sc_cfg_get("blc_wan_mode", blc_wan_mode, sizeof(blc_wan_mode));
	sc_cfg_get("blc_wan_auto_mode", blc_wan_auto_mode, sizeof(blc_wan_auto_mode));
	if (strcmp("PPP", blc_wan_mode) == 0 || (strcmp("AUTO", blc_wan_mode) == 0 && strcmp("AUTO_PPP", blc_wan_auto_mode) == 0)) {
		slog(NET_PRINT, SLOG_NORMAL, "blc_wan_mode=%s, blc_wan_auto_mode=%s, now is auto or PPP mode\n", blc_wan_mode, blc_wan_auto_mode);
		return 0;
	} else {
		slog(NET_PRINT, SLOG_NORMAL, "blc_wan_mode=%s, blc_wan_auto_mode=%s, now is not auto or PPP mode \n", blc_wan_mode, blc_wan_auto_mode);
		return 1;
	}
}


void set_wan_auto_mode(char * mode)
{
	char blc_wan_mode[16] = {0};

	sc_cfg_get("blc_wan_mode", blc_wan_mode, sizeof(blc_wan_mode));

	if (strcmp(blc_wan_mode, "AUTO") == 0) {
		sc_cfg_set("blc_wan_auto_mode", mode);
		slog(NET_PRINT, SLOG_NORMAL, "blc_set_wan_mode: mode = %s\n", mode);
	}
}


/**********************************************************************************
:õͨģʽ-wifistation ص:1:wifistation;0:ر
***********************************************************************************/
static int get_wifiwan_onoff()
{
	int result = -1;
	char nv_wifiap_state[32] = {0};
	char wifi_cur_state[8] = {0};

	sc_cfg_get("wifi_cur_state", wifi_cur_state, sizeof(wifi_cur_state));
	sc_cfg_get("wifi_sta_connection", nv_wifiap_state, sizeof(nv_wifiap_state));
	slog(NET_PRINT, SLOG_NORMAL, "get_wifiwan_onoff wifi_cur_state:%s,nv_wifiap_state:%s\n", wifi_cur_state, nv_wifiap_state);
	if (!strcmp(nv_wifiap_state, "1") && !strcmp(wifi_cur_state, "1")) {   //wifistation 
		result = 1;
	} else {
		result = 0;
	}

	slog(NET_PRINT, SLOG_DEBUG, "get_wifiwan_onoff result:%d\n", result);
	return result;
}


/**********************************************************************************
:õͨģʽ-wifistation ȵ:1:wifistation;0:modem 
***********************************************************************************/
static int get_wifiwan_pre()
{
	int result = 0;
	char nv_wifi_state[32] = {0};
	char ps_wan_pri[32] = {0};
	char wifi_wan_pri[32] = {0};
	int ps_pri = 0;
	int wifi_pri = 0;

	sc_cfg_get("wifi_sta_connection", nv_wifi_state, sizeof(nv_wifi_state));
	sc_cfg_get("pswan_priority", ps_wan_pri, sizeof(ps_wan_pri));
	sc_cfg_get("wifiwan_priority", wifi_wan_pri, sizeof(wifi_wan_pri));

	ps_pri = atoi(ps_wan_pri);
	wifi_pri = atoi(wifi_wan_pri);

	if (!strcmp(nv_wifi_state, "1")) {  //wifistation 
		if (wifi_pri > ps_pri) {
			result = 1;
		}
	}

	slog(NET_PRINT, SLOG_NORMAL, "get_wifiwan_pre result:%d\n", result);
	return result;
}


/**********************************************************************************
:ͨģʽ-wifistation ر
***********************************************************************************/
static int close_wifiwan_access()
{
	int ret = 0;

	ret = ipc_send_message(MODULE_ID_MAIN_CTRL, MODULE_ID_WIFI, MSG_CMD_BLC_CLOSE_WIFISTATION_ACCESS, 0, NULL, 0);
	if (0 != ret) {
		return -1;
	}

	slog(NET_PRINT, SLOG_NORMAL, "close_wifiwan_access request ok!\n");
	return 0;
}


/**********************************************************************************
:ͨģʽ-wifistation 
***********************************************************************************/
static int open_wifiwan_access()
{
	char blc_wan_mode[16] = {0};
	char blc_wan_auto_mode[16] = {0};
	int ret = 0;

	sc_cfg_get("blc_wan_mode", blc_wan_mode, sizeof(blc_wan_mode));
	sc_cfg_get("blc_wan_auto_mode", blc_wan_auto_mode, sizeof(blc_wan_auto_mode));

	/*Ϊ߽룬wifi*/
	if (strcmp("PPP", blc_wan_mode) == 0 || (strcmp("AUTO", blc_wan_mode) == 0 && strcmp("AUTO_PPP", blc_wan_auto_mode) == 0)) {
		slog(NET_PRINT, SLOG_NORMAL, "blc_wan_mode=%s, can open WifiStation\n", blc_wan_mode);

		ret = ipc_send_message(MODULE_ID_MAIN_CTRL, MODULE_ID_WIFI, MSG_CMD_BLC_OPEN_WIFISTATION_ACCESS, 0, NULL, 0);
		if (0 != ret) {
			return -1;
		}

		slog(NET_PRINT, SLOG_NORMAL, "open wifiwan request ok!\n");
		return 0;
	}

	slog(NET_PRINT, SLOG_ERR, "blc_wan_mode=%s, can not open WifiStation\n", blc_wan_mode);
	return -1;
}


/**********************************************************************************
:ͨģʽ-Modem رӵָ
***********************************************************************************/
static int close_pswan_access()
{
	int ret = 0;
	if(g_pdpdeact_reqing != 0){
		slog(NET_PRINT, SLOG_ERR, "last close pswan request without rsp!\n");
		return -1;
	}
	sc_cfg_set("user_blc_disconnect", "1");	//Ͽ

	ret = ipc_send_message(MODULE_ID_MAIN_CTRL, MODULE_ID_AT_CTL, MSG_CMD_PDP_DEACT_REQ, 0, NULL, 0);
	if (0 != ret) {
		return -1;
	}
	g_pdpdeact_reqing = 1;
	slog(NET_PRINT, SLOG_NORMAL, "close pswan request ok!\n");
	return 0;
}


/**********************************************************************************
:ͨģʽ-Modem ӵָ
***********************************************************************************/
static int open_pswan_access()
{
	char needInit[10] = {0};
	char blc_wan_mode[16] = {0};
	char blc_wan_auto_mode[16] = {0};
	char dial_mode [20] = {0};
	char user_initiate_disconnect[20] = {0};
    char sta_ip_status[30] = {0};
    char work_state[30] = {0};
    
	int ret = 0;

	if(g_pdpact_reqing != 0){
		slog(NET_PRINT, SLOG_ERR, "last open_modem request without rsq!\n");
		return -1;
	}

    sc_cfg_get ("sta_ip_status", sta_ip_status, sizeof (sta_ip_status));
    if (0 == strcmp(sta_ip_status, "connect"))
    {
        slog(NET_PRINT, SLOG_ERR, "ap station have connected, can not open modem\n");
        return -1;
    }
    
    sc_cfg_get("rj45_state", work_state, sizeof(work_state));    
    if (0 == strcmp(work_state, "connect"))
    {
        slog(NET_PRINT, SLOG_ERR, "rj45 have connected, can not open modem\n");
        return -1;
    }
    
	sc_cfg_get("need_init_modem", needInit, sizeof(needInit));
	if (0 != strcmp(needInit, "yes"))
		return -1;

	sc_cfg_get("blc_wan_mode", blc_wan_mode, sizeof(blc_wan_mode));
	sc_cfg_get("blc_wan_auto_mode", blc_wan_auto_mode, sizeof(blc_wan_auto_mode));
	sc_cfg_get("user_initiate_disconnect", user_initiate_disconnect, sizeof(user_initiate_disconnect));
	sc_cfg_get("dial_mode", dial_mode, sizeof(dial_mode));

	if (0 == strcmp(user_initiate_disconnect, "1"))
		return -1;

	if (0 == strcmp("auto_dial", dial_mode) && (strcmp("PPP", blc_wan_mode) == 0 || (strcmp("AUTO", blc_wan_mode) == 0 && strcmp("AUTO_PPP", blc_wan_auto_mode) == 0))) {
		slog(NET_PRINT, SLOG_NORMAL, "blc_wan_mode=%s, can open modem\n", blc_wan_mode);

		sc_cfg_set("user_blc_disconnect", "0");	//˳Ͽ
		ret = ipc_send_message(MODULE_ID_MAIN_CTRL, MODULE_ID_AT_CTL, MSG_CMD_PDP_ACT_REQ, 0, NULL, 0);
		if (0 != ret) {
			return -1;
		}
		g_pdpact_reqing = 1;

		slog(NET_PRINT, SLOG_NORMAL, "open_modem request ok!\n");
		return 0;
	}

	slog(NET_PRINT, SLOG_ERR, "blc_wan_mode=%s, can not open modem\n", blc_wan_mode);
	return -1;
}

static void set_modem_off()
{
#if (PRODUCT_TYPE == PRODUCT_PHONE)//ܻcpв֪ͨAP,ԲҪ
	return;
#else //cov m
	if(g_poweron_type == 2){//ػmodemڲat+cfun=0
		return;
	}
	int ret = get_modem_info("at+cfun=0\r\n", NULL, NULL);
	if(ret){
		slog(NET_PRINT, SLOG_ERR, "at+cfun=0 err =%d, can not close modem\n", ret);
	}
#endif
}

static int pdp_auto_dial()
{
	int ret;

	char needInit[10] = {0};//жǷ֧modemʼ
	char pppStatus [20] = {0};
	char blc_wan_mode[20] = {0};
	char blc_wan_auto_mode[20] = {0};
	char user_initiate_disconnect[20] = {0};
	char user_blc_disconnect[20] = {0};
	char dial_mode [20] = {0};

	sc_cfg_get("need_init_modem", needInit, sizeof(needInit));
	sc_cfg_get(NV_BLC_WAN_MODE, blc_wan_mode, sizeof(blc_wan_mode));
	sc_cfg_get(NV_BLC_WAN_AUTO_MODE, blc_wan_auto_mode, sizeof(blc_wan_auto_mode));
	sc_cfg_get(NV_DIAL_MODE, dial_mode, sizeof(dial_mode));
	sc_cfg_get("user_initiate_disconnect", user_initiate_disconnect, sizeof(user_initiate_disconnect));
	sc_cfg_get("user_blc_disconnect", user_blc_disconnect, sizeof(user_blc_disconnect));

	if (0 != strcmp(needInit, "yes")) {
		return -1;
	}

	if (0 != strcmp("PPP", blc_wan_mode) && 0 != strcmp("AUTO", blc_wan_mode)) {
		return -1;
	}

	if (0 != strcmp("auto_dial", dial_mode)) {
		return  -1;
	}

	if (0 == strcmp(user_initiate_disconnect, "1") || 0 == strcmp(user_blc_disconnect, "1")) {
		return -1;
	}

	ret = ipc_send_message(MODULE_ID_MAIN_CTRL, MODULE_ID_AT_CTL, MSG_CMD_PDP_ACT_REQ, 0, NULL, 0);
	if (0 != ret) {
		slog(NET_PRINT, SLOG_ERR, "pdp_auto_dial err!\n");
	}
	g_pdpact_reqing = 1;

	slog(NET_PRINT, SLOG_NORMAL, "pdp_auto_dial ok!\n");
	return ret;

}


/**********************************************************************************
:Ĭڴ
***********************************************************************************/
void net_default_wan_proc(struct default_dev_info *dev)
{
	char dev_coexist[32] = {0};
	char modem_wan_pri[32] = {0};
	char wifi_wan_pri[32] = {0};
	char rj45_wan_pri[32] = {0};
	int modem_pri = 0;
	int wifi_pri  = 0;
	int rj45_pri  = 0;

	slog(NET_PRINT, SLOG_NORMAL, "net_default_wan_proc dev_id:%d \n", dev->dev_id);

	sc_cfg_get("netdev_coexist", dev_coexist, sizeof(dev_coexist));

	/*ڹ*/
	if (0 == strcmp(dev_coexist, "1")) {
		/*ڼʱwan_ipv4.shΪһĬ·ɣڶڹʱ
		  Ĭ·ǷӦĬ·ΪʵĬ·???
		 */
		slog(NET_PRINT, SLOG_NORMAL, "net device coexist!\n");
		if (dev->dev_id == RJ45_WAN_DEV || dev->dev_id == SW_WAN_DEV) {

			slog(NET_PRINT, SLOG_DEBUG, "Now rj45 is open!\n");

		} else if (dev->dev_id == WIFI_WAN_DEV) {
			int ret = -1;
			slog(NET_PRINT, SLOG_DEBUG, "Now wifi station is open.\n");

			ret = ipc_send_message(MODULE_ID_MAIN_CTRL, MODULE_ID_WIFI, MSG_CMD_WIFI_STATION_BLC_CONNECTED, 0, NULL, 0);
			if (0 != ret) {
				softap_assert("send msg to wlan_server error");
				return;
			}
		} else if (dev->dev_id == PS_NET_DEV) {
			slog(NET_PRINT, SLOG_DEBUG, "Now ps is open\n");
		} else if (dev->dev_id == NO_DEV) {
			if (get_wifiwan_onoff()) {
				open_wifiwan_access();
			}
			open_pswan_access();
		} else
			slog(NET_PRINT, SLOG_ERR, "dev_id:%d is unknow!!!\n", dev->dev_id);
	} else {
		sc_cfg_get("pswan_priority", modem_wan_pri, sizeof(modem_wan_pri));
		sc_cfg_get("wifiwan_priority", wifi_wan_pri, sizeof(wifi_wan_pri));
		sc_cfg_get("ethwan_priority", rj45_wan_pri, sizeof(rj45_wan_pri));
		modem_pri = atoi(modem_wan_pri);
		wifi_pri  = atoi(wifi_wan_pri);
		rj45_pri  = atoi(rj45_wan_pri);

		if (dev->dev_id == RJ45_WAN_DEV || dev->dev_id == SW_WAN_DEV) {
			slog(NET_PRINT, SLOG_DEBUG, "Now wan is rj45, need close modem or wifi\n");
			//ر
			if (rj45_pri > modem_pri) {
				close_pswan_access();
			}
			if (rj45_pri > wifi_pri) {
				if (get_wifiwan_onoff()) {
					close_wifiwan_access();
				}
			}
		} else if (dev->dev_id == WIFI_WAN_DEV) {

			int ret = -1;
			slog(NET_PRINT, SLOG_DEBUG, "Now wan is wifi station.\n");

			ret = ipc_send_message(MODULE_ID_MAIN_CTRL, MODULE_ID_WIFI, MSG_CMD_WIFI_STATION_BLC_CONNECTED, 0, NULL, 0);
			if (0 != ret) {
				softap_assert("send msg to wlan_server error");
				return;
			}

			if (wifi_pri > rj45_pri) { // ʱûرrj45ĳ
				int result = -1;
			}
			if (wifi_pri > modem_pri) {
				close_pswan_access();
			}


		} else if (dev->dev_id == PS_NET_DEV) {
			slog(NET_PRINT, SLOG_DEBUG, "Now wan is ps\n");
			if (modem_pri > rj45_pri) { // ʱûرrj45ĳ
				int result = -1;
			} else if (modem_pri > wifi_pri) {
				if (get_wifiwan_onoff()) {
					close_wifiwan_access();
				}
			}
		} else if (dev->dev_id == NO_DEV) {
			slog(NET_PRINT, SLOG_NORMAL, "Now wan is None, need open ps or wifi\n");
			if (get_wifiwan_onoff()) {
				open_wifiwan_access();
			}
			open_pswan_access();
		} else
			slog(NET_PRINT, SLOG_ERR, "dev_id:%d is unknow!!!\n", dev->dev_id);
	}
}



/**********************************************************************************
:ָò
***********************************************************************************/
//Ϣģ飬Ҫģлظ
void notify_list_add(struct list_head *head, int dst_id)
{
	struct mainctrl_notify_queue *tmp = NULL, *notify = NULL;

	slog(NET_PRINT, SLOG_DEBUG, "notify_list_add start, id:0x%x!!!\n", dst_id);

	list_for_each_entry(tmp, head, list) {
		//͸target_idģϢѾ¼
		if (tmp->notify_id == dst_id) {
			slog(NET_PRINT, SLOG_ERR, "notify_list_add dst_id:0x%x alread existed! \n", dst_id);
			return;
		}
	}

	notify = malloc(sizeof(struct mainctrl_notify_queue));
	if (notify == NULL) {
		slog(NET_PRINT, SLOG_ERR, "notify_list_add id:0x%x malloc failed! \n", dst_id);
		return;
	}

	INIT_LIST_HEAD(&notify->list);
	notify->notify_id = dst_id;
	list_add_tail(&notify->list, head);

	slog(NET_PRINT, SLOG_NORMAL, "notify_list_add id:0x%x success !!!\n", dst_id);
}

//Ϣģ飬Ҫģлظ
void notify_list_del(struct list_head *head, int id)
{
	struct mainctrl_notify_queue *tmp = NULL, *notify = NULL;

	slog(NET_PRINT, SLOG_DEBUG, "notify_list_del start, id:0x%x!!!\n", id);

	list_for_each_entry(tmp, head, list) {
		if (tmp->notify_id == id) {
			slog(NET_PRINT, SLOG_NORMAL, "notify_list_del id = 0x%x\n", id);
			list_del(&tmp->list);
			free(tmp);
			break;
		}
	}

	slog(NET_PRINT, SLOG_DEBUG, "notify_list_del success !!!\n");
}

static void reset_factory_configure()
{
	char port_mode[16] = {0};
	char time_to_2000[16] = {0};
	char path_log[32] = {0};
	char cmd[128] = {0};
	int ret = -1;

	sc_cfg_get("port_stat", port_mode, 16);
	if (strcmp(port_mode, "port_open") == 0) {
		system("killall -9 monitor");
	}
	//  system("rm -rf /etc_rw/config/sms_db/sms.db"); ATãٴ
	//   system("rm -rf /etc_rw/config/pbm.db");ATãٴ

	// ûfotaݻָ
	system("rm -rf  /usr/dm/config.ini");
	system("rm -rf  /usr/dm/zteconfig/userseting_nvconfig.txt");

	sc_cfg_get("time_to_2000_when_restore", time_to_2000, 16);
	if (strcmp(time_to_2000, "yes") == 0) {
        system("rm -rf /etc_rw/TZ");
		system("date -s \"2000-01-01 00:00:00\"");
		system("zte-rtc-clock");
	}

	//ӿ
	tcpip_reset_configure();

	//add by diaolifang  begin ָʱɾlogļ
	system("killall -9 syslogd");
	sc_cfg_get("path_log", path_log, sizeof(path_log));
	sprintf(cmd, "/bin/rm -rf %s*.*", path_log);
	zxic_system(cmd);//kw 3
	//add by diaolifang end

	sc_cfg_reset();
	ret = cpnv_ResetNVFactory();
	slog(NET_PRINT, SLOG_NORMAL, "cpnv_ResetNVFactory ret=%d.\n",ret);

	slog(NET_PRINT, SLOG_NORMAL, "reset_factory_configure !\n");
}

/*ػ*/
static void poweroff_charging_process()
{
	char reboot_cmd[20] = {0};

	slog(NET_PRINT, SLOG_NORMAL, "poweroff_charging_process start!!!\n");

	sprintf(reboot_cmd, "mmi_key reboot");
	syscall(SYS_reboot, LINUX_REBOOT_MAGIC1, LINUX_REBOOT_MAGIC2, LINUX_REBOOT_CMD_RESTART2, reboot_cmd);

	slog(NET_PRINT, SLOG_NORMAL, "poweroff_charging_process success!!!\n");
}
/*  RTCػģʽ*/
static VOID poweroff_clock_process(void)
{
	slog(NET_PRINT, SLOG_NORMAL, "poweroff_clock_process start!!!\n");
	char reboot_cmd[20] = {0};
	sprintf(reboot_cmd, "mmi_rtc reboot");
	syscall(SYS_reboot, LINUX_REBOOT_MAGIC1, LINUX_REBOOT_MAGIC2, LINUX_REBOOT_CMD_RESTART2, reboot_cmd);
}
//mmiݿٿػʵʴԤڲһ
static int execute_ext_cmd(int cmd)
{
	//if (cmd <= Ext_Cmd_Base || cmd >= Ext_Cmd_MAX)
	//	return 0;

	if (cmd == Ext_Cmd_REBOOT || cmd == Ext_Cmd_POWEROFF)
		system("app_monitor.sh off");

	if (cmd == Ext_Cmd_REBOOT)
		system("reboot");
	else if (cmd == Ext_Cmd_POWEROFF)
		system("poweroff");
	else if (cmd == Ext_Cmd_POWEROFF_CHARGING)
		poweroff_charging_process();
	else if (cmd == Ext_Cmd_POWEROFF_FAKE) {
		set_wake_unlock(MAINCTRL_LOCK);
		sc_cfg_set("doingPowerOff", "0");
		slog(NET_PRINT, SLOG_NORMAL, "execute_ext_cmd Ext_Cmd_POWEROFF_FAKE!!!\n");
	} else if (cmd == Ext_Cmd_POWEROFF_CLOCK) {
		slog(NET_PRINT, SLOG_NORMAL, "execute_ext_cmd Ext_Cmd_POWEROFF_CLOCK!!!\n");
		poweroff_clock_process();
	} else {
		return 0; //kw 3
	}
	return 1;
}

/*ģRESET_RSPϢ*/
void reset_rsp_process(MSG_BUF *msg)
{
	int id;
	struct mainctrl_notify_queue *temp = NULL;

	slog(NET_PRINT, SLOG_NORMAL, "reset_rsp_process start!!!\n");

	if (msg) {
		id = msg->src_id;
		slog(NET_PRINT, SLOG_NORMAL, "reset_rsp_process id = %x!!!\n", id);
		//MMIٿػĴڣմûͬ
		if (msg->src_id == MODULE_ID_MMI && msg->usDataLen > 0) {
			struct ext_msg_data *ext_data = (struct ext_msg_data *) msg->aucDataBuf;
			g_mainctrl_reset_ext_cmd = ext_data->cmd;
		}
		notify_list_del(&g_mainctrl_reset_notify, id);
	}

	//֪ͨresetģ鶼ظٽصĻָò
	if (list_empty(&g_mainctrl_reset_notify)) {
		system("app_monitor.sh off");//reset NV ֮ǰ
		slog(NET_PRINT, SLOG_NORMAL, "reset_rsp_process success, ext_cmd:%d, from:0x%x  subaction:%d!!!\n", g_mainctrl_reset_ext_cmd, g_restart_from, g_restart_subaction);
		reset_factory_configure();//ûָ
		set_modem_off();

		/* չATresetҪATظϢ*/
		if (g_restart_from != 0) {
			ipc_send_message(MODULE_ID_MAIN_CTRL, g_restart_from, MSG_CMD_RESTART_RSP, 0, NULL, 0);
			//return;
		}
		/* subactionжrebootϵȲǷⲿMCU*/
		if (g_restart_subaction == Operate_By_MCU) {
			return;
		}
		// mmiݿٿػʵʴԤڲһ
		if (execute_ext_cmd(g_mainctrl_reset_ext_cmd))
			return;

		system("reboot");
		return;
	}

	slog(NET_PRINT, SLOG_NORMAL, "reset_rsp_process still wait for reply !!!\n");
}

/*ģRESET_RSPϢ*/
void poweroff_rsp_process(MSG_BUF *msg)
{
	int id;
	struct mainctrl_notify_queue *temp = NULL;

	slog(NET_PRINT, SLOG_NORMAL, "poweroff_rsp_process start!!!\n");

	if (msg) {
		id = msg->src_id;
		//MMIٿػĴڣմûͬ
		if (msg->src_id == MODULE_ID_MMI && msg->usDataLen > 0) {
			struct ext_msg_data *ext_data = (struct ext_msg_data *) msg->aucDataBuf;
			g_mainctrl_poweroff_ext_cmd = ext_data->cmd;
		}
		notify_list_del(&g_mainctrl_poweroff_notify, id);
	}

	//֪ͨresetģ鶼ظٽصĻָò
	if (list_empty(&g_mainctrl_poweroff_notify)) {
		slog(NET_PRINT, SLOG_NORMAL, "poweroff_rsp_process success, g_poweroff_from:0x%x, ext_cmd:%d!!!\n", g_poweroff_from, g_mainctrl_poweroff_ext_cmd);
		if (g_mainctrl_factory_reset == 0)
			sc_cfg_save();
		if(g_mainctrl_poweroff_ext_cmd != Ext_Cmd_POWEROFF_FAKE){//ٹػԷat_cfun=0
			set_modem_off();
		}
		/* չATresetrebootϵȲAT*/
		if (g_poweroff_from != 0) {
			ipc_send_message(MODULE_ID_MAIN_CTRL, g_poweroff_from, MSG_CMD_POWEROFF_RSP, 0, NULL, 0);
			slog(NET_PRINT, SLOG_NORMAL, "poweroff_rsp_process MSG_CMD_POWEROFF_RSP to AT !!!\n");
			return;
		}
		// mmiݿٿػʵʴԤڲһ
		if (execute_ext_cmd(g_mainctrl_poweroff_ext_cmd))
			return;
		system("app_monitor.sh off");
		system("poweroff");
		return;
	}

	slog(NET_PRINT, SLOG_NORMAL, "poweroff_rsp_process still wait for reply !!!\n");
}

/*ģRESTART_RSPϢ*/
void restart_rsp_process(MSG_BUF *msg)
{
	int id;
	struct mainctrl_notify_queue *temp = NULL;

	slog(NET_PRINT, SLOG_NORMAL, "restart_rsp_process start!!!\n");

	if (msg) {
		id = msg->src_id;
		//MMIٿػĴڣմûͬ
		if (msg->src_id == MODULE_ID_MMI && msg->usDataLen > 0) {
			struct ext_msg_data *ext_data = (struct ext_msg_data *) msg->aucDataBuf;
			g_mainctrl_restart_ext_cmd = ext_data->cmd;
		}
		notify_list_del(&g_mainctrl_restart_notify, id);
	}

	//֪ͨresetģ鶼ظٽصĻָò
	if (list_empty(&g_mainctrl_restart_notify)) {
		slog(NET_PRINT, SLOG_NORMAL, "restart_rsp_process success, ext_cmd:%d, subaction:%d!!!\n", g_mainctrl_restart_ext_cmd, g_restart_subaction);
		if (g_mainctrl_factory_reset == 0)
			sc_cfg_save();
		
		set_modem_off();
		
		// ATҪظ
		if (g_restart_from != 0) {
			ipc_send_message(MODULE_ID_MAIN_CTRL, g_restart_from, MSG_CMD_RESTART_RSP, 0, NULL, 0);
		}
		if (g_restart_subaction == Operate_By_MCU) {
			return;
		}
		
		// mmiݿٿػʵʴԤڲһ
		if (execute_ext_cmd(g_mainctrl_restart_ext_cmd))
			return;

		system("app_monitor.sh off");
		system("reboot");
		return;
	}

	slog(NET_PRINT, SLOG_NORMAL, "restart_rsp_process still wait for reply !!!\n");
}

/**********************************************************************************
:ָϢ
***********************************************************************************/
void reset_msg_process(MSG_BUF *msg)
{
	struct mainctrl_notify_queue *notify = NULL;
	char fota_update_flag[32] = {0};

	slog(NET_PRINT, SLOG_NORMAL, "reset_msg_process start!!!\n");

	//fotaʱָ
	sc_cfg_get("fota_update_flag", fota_update_flag, sizeof(fota_update_flag));
	if (atoi(fota_update_flag) == 1) {
		slog(NET_PRINT, SLOG_ERR, "reset_msg_process: fota is in upgrading process! can not reset!!!\n");
		return;
	}

#if 0
	//CPϢҪCPϢ֪ͨCP resetҪյظ
	//if (msg->usMsgCmd != MSG_CMD_SOC_RESET_REQUEST)
	slog(NET_PRINT, SLOG_NORMAL, "reset_msg_process msg->src_id = %x!!!\n", msg->src_id);
	if (msg->src_id & MODULE_ID_APBASE) {
		if (send_soc_msg(NEAR_PS, MODULE_ID_AT_CTL, MSG_CMD_RESET_NOTIFY, 0, NULL) == 0) {
			slog(NET_PRINT, SLOG_NORMAL, "reset_msg_process: send msg to CP ok!!!\n");
			//notify_list_add(&g_mainctrl_reset_notify, MODULE_ID_AT_CTL);
			notify_list_add(&g_mainctrl_reset_notify, MODULE_ID_CP_AT_CTL);
		}
	}
#endif

	//RTCϢҪյظ
	if (rtc_timer_del_all(MODULE_ID_MAIN_CTRL, MSG_CMD_RESET_RSP) == 0) {
		slog(NET_PRINT, SLOG_DEBUG, "reset_msg_process: send msg to rtc ok!!!\n");
		notify_list_add(&g_mainctrl_reset_notify, MODULE_ID_RTC_SERVICE);
	}

#if (MODEM_TYPE != vehicle_dc)
	//SMSϢҪյظ
	if (ipc_send_message(MODULE_ID_MAIN_CTRL, MODULE_ID_SMS, MSG_CMD_RESET_NOTIFY, 0, NULL, 0) == 0) {
		slog(NET_PRINT, SLOG_DEBUG, "reset_msg_process: send msg to sms ok!!!\n");
		notify_list_add(&g_mainctrl_reset_notify, MODULE_ID_SMS);
	}

	//FOTAϢҪյظ
	if (ipc_send_message(MODULE_ID_MAIN_CTRL, MODULE_ID_DM_WEBUI_AT, MSG_CMD_RESET_NOTIFY, 0, NULL, 0) == 0) {
		slog(NET_PRINT, SLOG_DEBUG, "reset_msg_process: send msg to FOTA ok!!!\n");
		notify_list_add(&g_mainctrl_reset_notify, MODULE_ID_DM_WEBUI_AT);
	}

	//PBϢҪյظ
	if (ipc_send_message(MODULE_ID_MAIN_CTRL, MODULE_ID_PB, MSG_CMD_RESET_NOTIFY, 0, NULL, 0) == 0) {
		slog(NET_PRINT, SLOG_DEBUG, "reset_msg_process: send msg to pb ok!!!\n");
		notify_list_add(&g_mainctrl_reset_notify, MODULE_ID_PB);
	}

	//MMIϢҪյظ,Ҫreset򲻸MMI
	if (g_restart_subaction == Operate_By_SOC) {
		if (ipc_send_message(MODULE_ID_MAIN_CTRL, MODULE_ID_MMI, MSG_CMD_RESET_NOTIFY, 0, NULL, 0) == 0) {
			slog(NET_PRINT, SLOG_DEBUG, "reset_msg_process: send msg to mmi ok!!!\n");
			notify_list_add(&g_mainctrl_reset_notify, MODULE_ID_MMI);
		}
	}
#endif

	//ӦòڣӦ
	if (list_empty(&g_mainctrl_reset_notify)) {
		reset_rsp_process(NULL);
	} else {
		slog(NET_PRINT, SLOG_NORMAL, "reset_msg_process success!!!\n");
	}
}

/**********************************************************************************
:Ƿٹػ
***********************************************************************************/
static BOOL blc_is_fakepoweroff()
{
	char nv_abnormal_poweroff[2] = {0};
	char rj45_sta[24] = {0};
	char nv_poweron_mode[8] = {0};
	char nv_sim_pin[8] = {0};

	sc_cfg_get("abnormal_poweroff_flag", nv_abnormal_poweroff, sizeof(nv_abnormal_poweroff));
	sc_cfg_get("rj45_plug", rj45_sta, sizeof(rj45_sta));
	sc_cfg_get("mgmt_quicken_power_on", nv_poweron_mode, sizeof(nv_poweron_mode));
	sc_cfg_get("need_sim_pin", nv_sim_pin, sizeof(nv_sim_pin));
	slog(NET_PRINT, SLOG_NORMAL, "blc_is_fakepoweroff nv_abnormal_poweroff= %s,rj45_sta= %s,nv_poweron_mode= %s,nv_sim_pin= %s\n", nv_abnormal_poweroff, rj45_sta, nv_poweron_mode, nv_sim_pin);
	if ((!strncmp(rj45_sta, "wan_on_lan_off", strlen("wan_on_lan_off")))
	    || (!strncmp(rj45_sta, "wan_off_lan_on", strlen("wan_off_lan_on")))
	    || (!strncmp(rj45_sta, "wan_lan_on", strlen("wan_lan_on")))) {
		return FALSE;
	}
	if (strncmp(nv_poweron_mode, "1", sizeof("1"))) {
		return FALSE;
	}
	if (!strncmp(nv_sim_pin, "yes", sizeof("yes"))) {
		return FALSE;
	}
	if (!strncmp(nv_abnormal_poweroff, "1", 1)) {
		return FALSE;
	}
	slog(NET_PRINT, SLOG_NORMAL, "blc_is_fakepoweroff !\n");
	return TRUE;
}


/**********************************************************************************
:ػϢ
***********************************************************************************/
void poweroff_msg_process(MSG_BUF *msg)
{
	struct ext_msg_data *msgData = NULL;

	slog(NET_PRINT, SLOG_NORMAL, "poweroff_msg_process !\n");

#if (PRODUCT_TYPE == PRODUCT_PHONE)
	if (g_poweroff_from == 0) { //չATĹػ󣬲ػԭ򣬲Ҫ̣CPĹػ
		if (!msg || msg->usDataLen <= 0) {
			slog(NET_PRINT, SLOG_ERR, "poweroff_msg_process msg is empty \n");
			return;
		}

		msgData = (struct ext_msg_data*)msg->aucDataBuf;
		if (!msgData) {
			slog(NET_PRINT, SLOG_ERR, "poweroff_msg_process param is NULL \n");
			return;
		}
		g_mainctrl_poweroff_ext_cmd = (T_zUfi_ExtCmd)msgData->cmd;
	}
#endif

#if (MODEM_TYPE != vehicle_dc)
	//dataϢҪյظ
	if (ipc_send_message(MODULE_ID_MAIN_CTRL, MODULE_ID_FLUXSTAT, MSG_CMD_DATA_END, 0, NULL, 0) != 0) {
		slog(NET_PRINT, SLOG_ERR, "send msg to data fail!!!\n");
	}
#endif

	//ǼٹػʱRTCϢҪյظ
	if (!blc_is_fakepoweroff()) {
		if (rtc_timer_del_all(MODULE_ID_MAIN_CTRL, MSG_CMD_POWEROFF_RSP) == 0) {
			slog(NET_PRINT, SLOG_NORMAL, "poweroff_msg_process: send msg to rtc ok!!!\n");
			notify_list_add(&g_mainctrl_poweroff_notify, MODULE_ID_RTC_SERVICE);
		}
	}

#if (MODEM_TYPE != vehicle_dc)
	//MMIϢҪյظ
	if (g_poweroff_from == 0) {
		if (ipc_send_message(MODULE_ID_MAIN_CTRL, MODULE_ID_MMI, MSG_CMD_POWEROFF_NOTIFY, 0, NULL, 0) == 0) {
			slog(NET_PRINT, SLOG_NORMAL, "poweroff_msg_process: send msg to mmi ok!!!\n");
			notify_list_add(&g_mainctrl_poweroff_notify, MODULE_ID_MMI);
		}
	}
#endif

	//ӦòڣӦ
	if (list_empty(&g_mainctrl_poweroff_notify)) {
		poweroff_rsp_process(NULL);
	} else {
		slog(NET_PRINT, SLOG_NORMAL, "poweroff_msg_process success!!!\n");
	}
}

/**********************************************************************************
:Ϣ
***********************************************************************************/
void restart_msg_process(void)
{
	slog(NET_PRINT, SLOG_NORMAL, "restart_msg_process !\n");

#if (MODEM_TYPE != vehicle_dc)
	//dataϢҪյظ
	if (ipc_send_message(MODULE_ID_MAIN_CTRL, MODULE_ID_FLUXSTAT, MSG_CMD_DATA_END, 0, NULL, 0) != 0) {
		slog(NET_PRINT, SLOG_ERR, "send msg to data fail!!!\n");
	}
#endif

	//RTCϢҪյظ
	if (rtc_timer_del_all(MODULE_ID_MAIN_CTRL, MSG_CMD_RESTART_RSP) == 0) {
		slog(NET_PRINT, SLOG_NORMAL, "restart_msg_process: send msg to rtc ok!!!\n");
		notify_list_add(&g_mainctrl_restart_notify, MODULE_ID_RTC_SERVICE);
	}

#if (MODEM_TYPE != vehicle_dc)
	//MMIϢҪյظ
	if (g_restart_subaction == Operate_By_SOC) {
		if (ipc_send_message(MODULE_ID_MAIN_CTRL, MODULE_ID_MMI, MSG_CMD_RESTART_NOTIFY, 0, NULL, 0) == 0) {
			slog(NET_PRINT, SLOG_NORMAL, "restart_msg_process: send msg to mmi ok!!!\n");
			notify_list_add(&g_mainctrl_restart_notify, MODULE_ID_MMI);
		}
	}
#endif

	//ӦòڣӦ
	if (list_empty(&g_mainctrl_restart_notify)) {
		restart_rsp_process(NULL);
	} else {
		slog(NET_PRINT, SLOG_NORMAL, "restart_msg_process success!!!\n");
	}
}

/*rj45ΪʱwifipsȼߵΪ*/
void set_rj45_lan()
{
	int result = -1;
	int wifi_pre = 0;

	set_wan_auto_mode("AUTO_PPP");

	wifi_pre = get_wifiwan_pre();
	if (wifi_pre == 1) { //wifistation 
		open_wifiwan_access();
	} else if (wifi_pre == 0) { //modem 
		open_pswan_access();
	}
}

static void check_limit_time(void)
{
	/* 0:ʱ 1:ʱ*/
	if (g_limit_time_flag == 1) {
		zte_children_start_nonet();
	} else if (g_limit_time_flag == 0) {
		zte_children_stop_nonet();
	}
}

static int create_msg_queue(void)
{
	return msgget(MODULE_ID_MAIN_CTRL, IPC_CREAT | 0600);
}

void get_wan_name()
{
	sc_cfg_get("pswan", ps_wan, sizeof(ps_wan));
	sc_cfg_get("wifiwan", wifi_wan, sizeof(wifi_wan));
	sc_cfg_get("ethwan", eth_wan, sizeof(eth_wan));
}

void mainctrl_init()
{
	INIT_LIST_HEAD(&g_mainctrl_reset_notify);
	INIT_LIST_HEAD(&g_mainctrl_poweroff_notify);
	INIT_LIST_HEAD(&g_mainctrl_restart_notify);
	pppoe_aes_init();

#if (MODEM_TYPE == vehicle_dc)
	INIT_LIST_HEAD(&g_firewall_ip);
#endif
}

void Router_msg_proc(MSG_BUF *msg)
{
	if (NULL == msg) {
		slog(NET_PRINT, SLOG_ERR, "NULL para input!");
		return;
	}

	switch (msg->usMsgCmd) {
	/*صϢ*/
	case MSG_CMD_NET_IPPORT_FILTER: {
		slog(NET_PRINT, SLOG_DEBUG, "recv msg MSG_CMD_NET_IPPORT_FILTER \n");
		zte_iptables_filter_run();
		zte_iptables_filter_run_v6();
		break;
	}
	case MSG_CMD_NET_IPPORT_FORWARD: {
		slog(NET_PRINT, SLOG_DEBUG, "recv msg MSG_CMD_NET_IPPORT_FORWARD \n");
		zte_iptables_sys_fw_run();
		zte_iptables_port_forward_run();
		break;
	}
	case MSG_CMD_NET_DMZ: {
		slog(NET_PRINT, SLOG_DEBUG, "recv msg MSG_CMD_NET_DMZ \n");
		zte_iptables_DMZ_Run();
		break;
	}
	/* EC: 616000297057, ԭ: 粻ֶ֧˿ӳ */
	case MSG_CMD_NET_IPPORT_MAPPING: {
		slog(NET_PRINT, SLOG_DEBUG, "recv msg MSG_CMD_NET_IPPORT_MAPPING \n");
		zte_iptables_port_map_all_run();
		break;
	}
	case MSG_CMD_NET_UPNP: {
		slog(NET_PRINT, SLOG_DEBUG, "recv msg MSG_CMD_NET_UPNP \n");
		zte_unpn_set();
		break;
	}
	case MSG_CMD_NET_URL_FILTER: {
		slog(NET_PRINT, SLOG_DEBUG, "recv msg MSG_CMD_NET_URL_FILTER \n");
		zte_iptables_Webs_Filter_Run();
		break;
	}
	case MSG_CMD_NET_MTU: {
		slog(NET_PRINT, SLOG_DEBUG, "recv msg MSG_CMD_NET_MTU \n");
		zte_router_mtu_set_process();
		break;
	}
	case MSG_CMD_NET_WAN4_CHANGE: {
		slog(NET_PRINT, SLOG_DEBUG, "recv msg MSG_CMD_NET_WAN4_CHANGE %s\n", msg->aucDataBuf);
		proc_wan_change_v4(atoi(msg->aucDataBuf));
		break;
	}
	case MSG_CMD_NET_WAN6_CHANGE: {
		slog(NET_PRINT, SLOG_DEBUG, "recv msg MSG_CMD_NET_WAN6_CHANGE %s\n", msg->aucDataBuf);
		proc_wan_change_v6(atoi(msg->aucDataBuf));
		break;
	}
	case MSG_CMD_NET_PLUGIN: {
		slog(NET_PRINT, SLOG_DEBUG, "recv msg MSG_CMD_NET_PLUGIN \n");
		if(g_poweron_type != 2)//ػ粻豸̰汾ػhotplugᷢusbplugin
		net_netdev_plugin_proc(*((unsigned char *)msg->aucDataBuf));
		break;
	}
	case MSG_CMD_NET_PLUGOUT: {
		slog(NET_PRINT, SLOG_DEBUG, "recv msg MSG_CMD_NET_PLUGOUT \n");
		net_netdev_plugout_proc(*((unsigned char *)msg->aucDataBuf));
		break;
	}
	case MSG_CMD_NET_CONNECT: {
		slog(NET_PRINT, SLOG_DEBUG, "recv msg MSG_CMD_NET_CONNECT \n");
		net_netdev_connect_internet(*((unsigned char *)msg->aucDataBuf));
		break;
	}
	case MSG_CMD_NET_DISCON: {
		slog(NET_PRINT, SLOG_DEBUG, "recv msg MSG_CMD_NET_DISCON \n");
		net_netdev_disconnect_internet(*((unsigned char *)msg->aucDataBuf));
		break;
	}
	case MSG_CMD_NET_PDP_ACT: {
		slog(NET_PRINT, SLOG_DEBUG, "recv msg MSG_CMD_NET_PDP_ACT \n");
		net_pdp_act_proc((struct pdp_active_info *)msg->aucDataBuf);
		break;
	}
	case MSG_CMD_NET_PDP_DEACT: {
		slog(NET_PRINT, SLOG_DEBUG, "recv msg MSG_CMD_NET_PDP_DEACT \n");
		struct pdp_deactive_info temp = *((struct pdp_deactive_info *)msg->aucDataBuf);
		net_pdp_deact_proc(temp.c_id, temp.ip46flag);
		break;
	}
	case MSG_CMD_NET_TC_CTRL: {
		slog(NET_PRINT, SLOG_DEBUG, "recv msg MSG_CMD_NET_TC_CTRL \n");
		net_tc_control((struct tc_control_info *)msg->aucDataBuf,msg->src_id);
		break;
	}
	case MSG_CMD_NET_GET_HOSTNAME: {
		slog(NET_PRINT, SLOG_DEBUG, "recv msg MSG_CMD_NET_GET_HOSTNAME \n");
		get_mac_hostname_pro((struct mac_hostname_info *)msg->aucDataBuf);
		break;
	}
	case MSG_CMD_NET_STATIC_DHCP: {
		slog(NET_PRINT, SLOG_DEBUG, "recv msg MSG_CMD_NET_STATIC_DHCP \n");
		zte_macip_list_run();
		break;
	}
	case MSG_CMD_NET_DHCP_SETTING_REQ: {
		slog(NET_PRINT, SLOG_DEBUG, "recv msg MSG_CMD_NET_DHCP_SETTING_REQ \n");
		zte_router_dhcp_setting_req_process((dhcp_setting_req *)msg->aucDataBuf);
		break;
	}
	case MSG_CMD_NET_TIMER_OUT: {
		slog(NET_PRINT, SLOG_DEBUG, "recv msg MSG_CMD_NET_TIMER_OUT \n");
		out_of_time(*((unsigned char *)msg->aucDataBuf));
		break;
	}
	case MSG_CMD_NET_TIMER_DEL: {
		slog(NET_PRINT, SLOG_DEBUG, "recv msg MSG_CMD_NET_TIMER_DEL \n");
		char wanname[20] = {0};
		strncpy(wanname, (char *)msg->aucDataBuf, sizeof(wanname)-1);//klocwork
		slog(NET_PRINT, SLOG_ERR, "MSG_CMD_NET_TIMER_DEL:%s \n", wanname);
		if (0 == strcmp("ethwan", wanname))
			deletetimer(ethwan_id);
		else if (0 == strcmp("wifiwan", wanname))
			deletetimer(wifiwan_id);
		break;
	}
	case MSG_CMD_NET_BIND_STATIC_ADDRESS: {
		slog(NET_PRINT, SLOG_DEBUG, "recv msg MSG_CMD_NET_BIND_STATIC_ADDRESS \n");
		zte_bind_macip_list();
		break;
	}
	case MSG_CMD_NET_BIND_STATIC_ADDRESS_ADD: {
		slog(NET_PRINT, SLOG_DEBUG, "recv msg MSG_CMD_NET_BIND_STATIC_ADDRESS_ADD \n");
		zte_bind_macip_list_add((struct static_macip_info*)msg->aucDataBuf);
		break;
	}
	case MSG_CMD_NET_BIND_STATIC_ADDRESS_DEL: {
		slog(NET_PRINT, SLOG_DEBUG, "recv msg MSG_CMD_NET_BIND_STATIC_ADDRESS_DEL \n");
		zte_bind_macip_list_del((char*)msg->aucDataBuf);
		break;
	}
	case MSG_CMD_NET_ADD_CHILDREN_DEVICE: {
		slog(NET_PRINT, SLOG_DEBUG, "recv msg MSG_CMD_NET_ADD_CHILDREN_DEVICE \n");
		children_device_add((struct mac_hostname_info *)msg->aucDataBuf);
		slog(NET_PRINT, SLOG_ERR, "edit_hostname MESSAGE TO MC END");
		check_limit_time();
		break;
	}
	case MSG_CMD_NET_DEL_CHILDREN_DEVICE: {
		slog(NET_PRINT, SLOG_DEBUG, "recv msg MSG_CMD_NET_DEL_CHILDREN_DEVICE \n");
		children_device_del((char *)msg->aucDataBuf);
		slog(NET_PRINT, SLOG_ERR, "edit_hostname MESSAGE TO MC END");
		check_limit_time();
		break;
	}
	case MSG_CMD_NET_ADD_WHITE_SITE: {
		slog(NET_PRINT, SLOG_DEBUG, "recv msg MSG_CMD_NET_ADD_WHITE_SITE \n");
		white_site_add((struct white_site_info *)msg->aucDataBuf);
		slog(NET_PRINT, SLOG_ERR, "edit_hostname MESSAGE TO MC END");
		check_limit_time();
		break;
	}
	case MSG_CMD_NET_REMOVE_WHITE_SITE: {
		slog(NET_PRINT, SLOG_DEBUG, "recv msg MSG_CMD_NET_REMOVE_WHITE_SITE \n");
		white_site_remove((char *)msg->aucDataBuf);
		slog(NET_PRINT, SLOG_DEBUG, "edit_hostname MESSAGE TO MC END");
		check_limit_time();
		break;
	}
	case MSG_CMD_NET_START_NONET: {
		g_limit_time_flag = 1;
		slog(NET_PRINT, SLOG_DEBUG, "recv msg MSG_CMD_NET_START_NONET \n");
		zte_children_start_nonet();
		break;
	}
	case MSG_CMD_NET_STOP_NONET: {
		g_limit_time_flag = 0;
		slog(NET_PRINT, SLOG_DEBUG, "recv msg MSG_CMD_NET_STOP_NONET \n");
		zte_children_stop_nonet();
		break;
	}
	case MSG_CMD_PDP_ACT_RSP: {
		slog(NET_PRINT, SLOG_DEBUG, "recv msg MSG_CMD_PDP_ACT_RSP \n");
		g_pdpact_reqing = 0;
		break;
	}
	case MSG_CMD_PDP_DEACT_RSP: {
		slog(NET_PRINT, SLOG_DEBUG, "recv msg MSG_CMD_PDP_DEACT_RSP \n");
		g_pdpdeact_reqing = 0;
		break;
	}
	//case MSG_CMD_SOC_RESET_REQUEST:
	case MSG_CMD_RESET_REQUEST: {
		slog(NET_PRINT, SLOG_DEBUG, "recv msg MSG_CMD_RESET_REQUEST, cmd:0x%x \n", msg->usMsgCmd);
		set_wake_lock(MAINCTRL_LOCK);  //resetػٽ
		g_mainctrl_factory_reset = 1;
		sc_cfg_set("doingPowerOff", "1");
		record_restart_type(msg);
		reset_msg_process(msg);
		break;
	}
	case MSG_CMD_POWEROFF_REQUEST: {
		slog(NET_PRINT, SLOG_DEBUG, "recv msg MSG_CMD_POWEROFF_REQUEST \n");
		set_wake_lock(MAINCTRL_LOCK);
		sc_cfg_set("doingPowerOff", "1");
		record_poweroff_type(msg);
		poweroff_msg_process(msg);
		break;
	}
	//Ĭaction : 1-RESET,  0 -RESTART ;  subaction:1-ָ,  0-ֻҪָ֮ǰĶ
	case MSG_CMD_RESTART_REQUEST: {
		slog(NET_PRINT, SLOG_DEBUG, "recv msg MSG_CMD_RESTART_REQUEST \n");
		set_wake_lock(MAINCTRL_LOCK);
		sc_cfg_set("doingPowerOff", "1");
		record_restart_type(msg);

		if (msg->usDataLen > 0) {
			restart_info *msgData = (restart_info*)msg->aucDataBuf;
			if (msgData->action == Restart_Action_RESET) {
				g_mainctrl_factory_reset = 1;
				reset_msg_process(msg);
			} else {
				restart_msg_process();
			}
		} else {
			restart_msg_process();
		}
		break;
	}
	/*ģ鴦resetصϢ*/
	//case MSG_CMD_SOC_RESET_RSP:
	case MSG_CMD_RESET_RSP: {
		slog(NET_PRINT, SLOG_DEBUG, "recv msg MSG_CMD_RESET_RSP, cmd:0x%x \n", msg->usMsgCmd);
		reset_rsp_process(msg);
		break;
	}
	/*ģ鴦poweroffصϢ*/
	case MSG_CMD_POWEROFF_RSP: {
		slog(NET_PRINT, SLOG_DEBUG, "recv msg MSG_CMD_POWEROFF_RSP \n");
		poweroff_rsp_process(msg);
		break;
	}
	/*ģ鴦restartصϢ*/
	case MSG_CMD_RESTART_RSP: {
		slog(NET_PRINT, SLOG_DEBUG, "recv msg MSG_CMD_RESTART_RSP \n");
		restart_rsp_process(msg);
		break;
	}
	case MSG_CMD_NET_SET_RJ45_LAN: {
		set_rj45_lan();
		break;
	}
	case MSG_CMD_NET_PING_DIAGNOSTICS: {
		slog(NET_PRINT, SLOG_DEBUG, "recv msg MSG_CMD_PING_DIAGNOSTICS \n");
		zte_router_ping_diagnostics();
		break;
	}
#if (MODEM_TYPE == vehicle_dc)
	case MSG_CMD_NET_FIREWALL_ADD_REQ: {
		slog(NET_PRINT, SLOG_DEBUG, "recv msg MSG_CMD_NET_FIREWALL_ADD_REQ \n");
		zte_iptables_firewall_add((char *)msg->aucDataBuf);
		break;
	}
	case MSG_CMD_NET_FIREWALL_DEL_REQ: {
		slog(NET_PRINT, SLOG_DEBUG, "recv msg MSG_CMD_NET_FIREWALL_DEL_REQ \n");
		zte_iptables_firewall_del((char *)msg->aucDataBuf);
		break;
	}
	case MSG_CMD_NET_FIREWALL_CLEANUP_REQ: {
		slog(NET_PRINT, SLOG_DEBUG, "recv msg MSG_CMD_NET_FIREWALL_CLEANUP_REQ \n");
		zte_iptables_firewall_cleanup();
		break;
	}
#endif

	default:
		//assert(0);
		break;
	}
}

static void print_mainctrl_info(void)
{
	struct mainctrl_notify_queue *temp = NULL;
	int ret;

	if (!list_empty(&g_mainctrl_poweroff_notify)) {
		list_for_each_entry(temp, &g_mainctrl_poweroff_notify, list) {
			slog(NET_PRINT, SLOG_ERR, "mainctrl g_mainctrl_poweroff_notify: module_id = 0x%x\n", temp->notify_id);
		}
	} else {
		slog(RTC_PRINT, SLOG_ERR, "mainctrl g_mainctrl_poweroff_notify list is empty! \n");
	}

	if (!list_empty(&g_mainctrl_restart_notify)) {
		list_for_each_entry(temp, &g_mainctrl_restart_notify, list) {
			slog(NET_PRINT, SLOG_ERR, "mainctrl g_mainctrl_restart_notify: module_id = 0x%x\n", temp->notify_id);
		}
	} else {
		slog(RTC_PRINT, SLOG_ERR, "mainctrl g_mainctrl_restart_notify list is empty! \n");
	}

	if (!list_empty(&g_mainctrl_reset_notify)) {
		list_for_each_entry(temp, &g_mainctrl_reset_notify, list) {
			slog(NET_PRINT, SLOG_ERR, "mainctrl g_mainctrl_reset_notify: module_id = 0x%x\n", temp->notify_id);
		}
	} else {
		slog(RTC_PRINT, SLOG_ERR, "mainctrl g_mainctrl_reset_notify list is empty! \n");
	}
}

static void mainctrl_sig_usr1(int signo)
{
	/*if (signo == SIGUSR1) {
		slog(NET_PRINT, SLOG_ERR, "mainctrl receive SIGUSR1!\n");

		print_mainctrl_info();
	} else {
		slog(NET_PRINT, SLOG_ERR, "mainctrl receive signo %d", signo);
	}*/
}

static void nv_save_timeout(void)
{
	slog(NET_PRINT, SLOG_DEBUG, "nv_save_timeout factory_reset:%d \n", g_mainctrl_factory_reset);

	if (g_mainctrl_factory_reset == 0)
		sc_cfg_save();
}

static void zte_security_log_entry(char *arg)
{
	int msg_handle = msgget(MODULE_ID_SECURITY_LOG, IPC_CREAT | 0600);
	int ret = 0;	
	MSG_BUF stMsg;
	LONG msgSize =  sizeof(MSG_BUF) - sizeof(LONG);
	char seclog[32] = {0};

	sc_cfg_get("seclog_switch", seclog, sizeof(seclog));
	prctl(PR_SET_NAME, "seclog", 0, 0, 0);
	slog(NET_PRINT, SLOG_ERR, "security_log begin --build date: %s %s \n", __DATE__, __TIME__);
	if (msg_handle == -1) {
		slog(NET_PRINT, SLOG_ERR, "can not create msg queue for security_log!\n");
		return;
	}
	for (;;) {
		memset(&stMsg, 0, sizeof(stMsg));
		ret = msgrcv(msg_handle, &stMsg, msgSize, 0, 0);
		if (ret == -1) {
			if (EINTR == errno) {
				slog(NET_PRINT, SLOG_ERR, "sl_recev msg EINTR\n");
				continue;
			} else {
				slog(NET_PRINT, SLOG_ERR, "sl_recev msg fail errno = %d \n", errno);
				break;
			}
		}
		slog(NET_PRINT, SLOG_NORMAL, "sl:%s\n", stMsg.aucDataBuf);
		if(seclog[0] == '1')
		{
			file_write("security",stMsg.aucDataBuf);
		}
	}
}

int zte_mainctrl_main(int argc, char * argv[])
{
	int iMsgHandle = 0;
	int iRet = 0;
	MSG_BUF stMsg;
	MSG_BUF send_stMsg;
	LONG msgSize =  sizeof(MSG_BUF) - sizeof(LONG);
	int interruptSIG = 0;
	char nv_save_interval[32] = {0};
	unsigned int interval_time = 0;
	int i = 0;
	prctl(PR_SET_NAME, "mainctrl", 0, 0, 0);
	//NVʼӡ𣬲עᶯ̬ӡź
	loglevel_init();

	slog(NET_PRINT, SLOG_ERR, "mainctrl begin ======= build date: %s %s \n", __DATE__, __TIME__);

	pthread_t zte_security_log_tid;
	if (pthread_create(&zte_security_log_tid, NULL, (void *)zte_security_log_entry, NULL) != 0) //cov m
		slog(NET_PRINT, SLOG_ERR, "security_log_entry create fail\n");

	iMsgHandle = create_msg_queue();
	if (-1 == iMsgHandle) {
		slog(NET_PRINT, SLOG_ERR, "can not create msg queue for router!\n");
		return -1;
	}

	if (signal(SIGUSR1, mainctrl_sig_usr1) == SIG_ERR)
		slog(NET_PRINT, SLOG_ERR, "mainctrl cat not catch SIGUSR1!\n");
#ifndef USE_CAP_SUPPORT
	sc_cfg_get("nv_save_interval", nv_save_interval, sizeof(nv_save_interval));
	interval_time = atoi(nv_save_interval);
	if (interval_time < 0x400000) {//klocwork Ϊ˲
		interval_time = interval_time*1000;
		sc_timer_create(TIMER_MainCtrl_NvSaveID, TIMER_FLAG_RESTART, interval_time, nv_save_timeout, NULL);
	}
#endif
	/*init the router*/
	//zte_router_init();
	get_wan_name();

	//ʼȫֱ
	mainctrl_init();
	if (argc >= 2) {
		g_poweron_type = 2;//ػ
	}
	if(g_poweron_type != 2)
	system("internet.sh");
	//at_ctl׼
	while (i < 10) {
		char ppp_status[20] = {0};
		sc_cfg_get("ppp_status", ppp_status, sizeof(ppp_status));
		if (0 != strcmp("", ppp_status))
			break;
		usleep(200000);
		i++;
	}
	pdp_auto_dial();

	for (;;) {
		if (0 == interruptSIG) {
			slog(NET_PRINT, SLOG_ERR, "router begin to rcv msg from queue %d. \n", iMsgHandle);
		}
		memset(&stMsg, '\0', sizeof(stMsg));
		iRet = 0;
		iRet = msgrcv(iMsgHandle, &stMsg, msgSize, 0, 0);
		if (-1 == iRet) {
			if (EINTR == errno) {
				slog(NET_PRINT, SLOG_ERR, "received msg EINTR\n");
				// we use SIGALRM to timer, but the SIG will interrupt mgsrcv, so we should
				//do this action
				//DEBUG(LOG_ERR, "msgrcv faild as received a signal EINTR, need continue...\n");
				//usleep(1000);
				interruptSIG = 1;
				continue;
			} else {
				//ZTE_LOG(LOG_ERR, "recv msg from the Goahead fail errno=%d!", errno);
				slog(NET_PRINT, SLOG_ERR, "recv msg fail errno = %d \n", errno);
				return -1;
			}
		} else {
			interruptSIG = 1;
		}
		slog(NET_PRINT, SLOG_NORMAL, "mainctrl received msg usMsgCmd=0x%x, src=0x%x \n", stMsg.usMsgCmd, stMsg.src_id);

		/*set the firewall or router*/
		Router_msg_proc(&stMsg);
	}
	//closelog();
}



