/*****************************************************************************
*  汾 (C)ͨѶɷ޹˾
*  ģ    MMI
*  ļ    mmi_adapter.c
*  ļʶ  
*  ļ  
*  ʵֹ  MMI䣬 䲻ͬϵͳ
*        
*  汾      V1.0
*    2014-12-24
*  ˵  
*
******************************************************************************/

/*****************************************************************************
 ͷļ
******************************************************************************/

#include <wdt_common.h>

/************************************************************************************
                            ȫֱ
***********************************************************************************/
static int g_wdt_handle = -1;



/**********************************************************************************
:Mutex
***********************************************************************************/

/**********************************************************************************
:Semaphore
***********************************************************************************/

/**********************************************************************************
:дļ
***********************************************************************************/
SINT32 wdt_file_operate(char *filepath, char *buf)
{
	SINT32 ret_fd = 0;
	SINT32 len = 0;

	ret_fd = open(filepath, O_RDWR);
	if (ret_fd == -1) {
		perror("WDT wdt_file_operate open file fail:!\n");
		return WDT_ERROR;
	}

	len = strlen(buf);
	if (write(ret_fd, buf, len) != len) {
		perror("WDT wdt_file_operate write file fail:!\n");
		close((int)ret_fd);
		return WDT_ERROR;
	}
	slog(MMI_PRINT, SLOG_ERR, "WDT wdt_file_operate write file: %s success!!\n", filepath);
	close((int)ret_fd);
	return WDT_SUCCESS;
}

/**********************************************************************************
:
***********************************************************************************/

VOID wdt_rtc_add(UINT32 time_in_ms)
{
	int  ret = -1;

	ret = rtc_timer_add(time_in_ms / 1000, WDT_TEMP_PROTECT, MODULE_ID_WDT);

	if (ret != 0) {
		slog(MMI_PRINT, SLOG_ERR, "WDT wdt_rtc_add failed!\n");
	}
}
VOID wdt_rtc_delete()
{
	int ret = -1;

	ret = rtc_timer_del(WDT_TEMP_PROTECT, MODULE_ID_MMI);

	if (ret != 0) {
		slog(MMI_PRINT, SLOG_ERR, "WDT wdt_rtc_delete failed\n");
	}
}

VOID wdt_feet()
{
	int  ret = -1;
	if (g_wdt_handle == -1) {
		slog(MMI_PRINT, SLOG_ERR,  "WDT wdt didn't open !\n");
		return;
	}
	ret = ioctl(g_wdt_handle, ZX_WDT_FEED_DOG, NULL);
	if (ret < 0) {
		slog(MMI_PRINT, SLOG_ERR, "WDT wdt feed dog failed!\n");
	}
}

VOID wdt_init()
{
	g_wdt_handle = open(ZX_SOFT_WDT_DEV, 0);
	if (g_wdt_handle == -1) {
		slog(MMI_PRINT, SLOG_ERR, "WDT Couldn't open wdt:%s  %s!\n", ZX_SOFT_WDT_DEV, strerror(errno));
		return;
	}

	int timeout = WDT_INTERVAL_TIME / 1000;
	if (ioctl(g_wdt_handle, ZX_WDT_SET_INTERNAL, timeout) < 0) {
		slog(MMI_PRINT, SLOG_ERR, "WDT The wdt setting failed!\n");
		return;
	}
	wdt_feet();
	slog(MMI_PRINT, SLOG_ERR, "WDT INIT END: %d seconds\n", timeout);
}


