/**
 * @file message.h
 * @brief ӦùϢkey, Ϣ, ϢID, ϢAPIӿ
 * Copyright (C) 2017 Sanechips Technology Co., Ltd.
 * @author
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 *
 */

#ifndef _MESSAGE_H_
#define _MESSAGE_H_

#ifdef __cplusplus
extern "C" {
#endif


#include "max_macro.h"

/*******************************************************************************
 *                             Type definitions                                *
 ******************************************************************************/
#ifndef DOXYGEN_SHOULD_SKIP_THIS
/**
 * @brief ӦģϢIDϢеɣԼָʾϢշģ
 * @note MODULE_ID_USER_BASEʾͻӦԶģϢIDʼ
 */

/* -- AP˴ڵģIDûӦģIDҪڴenumеMODULE_ID_USER_BASE -- */
typedef enum AP_Module_ID{
	MODULE_ID_APBASE = 0x1000,		/*APģIDʼֵַ<0x2000(MODULE_ID_CPBASE)*/
	MODULE_ID_WEB_CGI,				/*WEB CGIģϢID*/
	MODULE_ID_SLAAC,
	MODULE_ID_WIFI,					/*wifi control*/
	MODULE_ID_WLAN_SERVER,			/*wifiԼԼϢmsg id*/
	MODULE_ID_MMI,
	MODULE_ID_FLUXSTAT,				/*fluxstat*/
	MODULE_ID_AP_RTC_SERVICE,
	MODULE_ID_SMS,					/*SMSϢ*/
	MODULE_ID_SMS_LOCAL,			/*SMSϢ, SMSģڲʹãŴ˴ͳһ*/
	MODULE_ID_PB,					/*PBϢ*/
	MODULE_ID_PB_LOCAL,				/*PBϢ, PBģڲʹãŴ˴ͳһ*/
	MODULE_ID_SNTP,
	MODULE_ID_PPPD,
	MODULE_ID_WDT,

	MODULE_ID_AP_AT_CTL,			/*at ctlģID*/
	MODULE_ID_SLIC,					/*slicģϢID*/
	MODULE_ID_DM,					/*DMģ*/
	MODULE_ID_DM_POLLING,			/*DM POLLING*/
	MODULE_ID_DM_WEBUI_AT,
	MODULE_ID_FAC_DIAL,				/*ģ ϢID*/
	MODULE_ID_TR069,				/*TR069 ģ*/
	MODULE_ID_MAIN_CTRL,			/*ģID*/
	MODULE_ID_ZSSID,
	MODULE_ID_LOG_AGENT,
	MODULE_ID_LOCALUPDATE,			/*localUpdateID*/
	MODULE_ID_PARENT_CONTROL_SET,
	MODULE_ID_WPA_SUPPLICANT,
	MODULE_ID_EMBMS_CTRL,
	MODULE_ID_HOTPLUG,				/*ȲģID*/
	MODULE_ID_VOLTE,
	MODULE_ID_VOLTE_TEMP1,	/*ʹMODULE_ID_ATCTL_TO_VOLTE */
	MODULE_ID_VOLTE_TEMP2,  /*ʹMODULE_ID_VOLTE_TO_ATCTL */

	MODULE_ID_USBCFGMNG,  /* ˴˶Ϊ˸VOLTEԤαͨ */
	MODULE_ID_DRVCOMMNG,
	

	/********************************************************************/
	//ӿʱģIDΪݸģ
	/********************************************************************/
	MODULE_ID_CALL_CTRL,
	MODULE_ID_CALL_CTRL_LOCAL,
	MODULE_ID_CALL_CTRL_RSP,
	MODULE_ID_NV,
	MODULE_ID_UICTL,
	MODULE_ID_ISMS,
	MODULE_ID_DMREG,
	MODULE_ID_DMSENDMSG,
	MODULE_ID_SAFECARE,
	MODULE_ID_CODEC,				/*audio*/
	MODULE_ID_AT_TOOL,				/*ڿatӦ*/
	MODULE_ID_AT_TEST,				/*ڿatӦ*/
	MODULE_ID_IP_PROXY,             /*ip proxyģID*/

	MODULE_ID_BIP,					/* BIPӦ */
	MODULE_ID_MNET_WHITELIST,		//whitelistģ

	/* ----- ƽ̨ڲ̬ģIDĽβƽ̨ڲIDϷ ------ */
	
	//Ϊ̬еIDʶ̬͹رգ뾲̬ģIDһ£κʱ̵ֻһʹ÷
	//׼мID
	MODULE_ID_SOFTTIMER_BASE,												/*APʱ̬IDʼֵ*/
	MODULE_ID_SOFTTIMER_END = MODULE_ID_SOFTTIMER_BASE + 0x100,				/*APʱ̬IDֵ*/
	MODULE_ID_AP_ATDYNAMIC_BASE,											/*APѯat̬IDʼֵ*/
	MODULE_ID_AP_ATDYNAMIC_END = MODULE_ID_AP_ATDYNAMIC_BASE + 0x100,		/*APѯat̬IDֵ*/
	MODULE_ID_AP_AUDIODYNAMIC_BASE,											/*APaudio̬IDʼֵ*/
	MODULE_ID_AP_AUDIODYNAMIC_END = MODULE_ID_AP_AUDIODYNAMIC_BASE + 0x100,	/*APaudio̬IDʼֵ*/
	MODULE_ID_AP_GETHOSTBYNAME_BASE,										 /*apgethostbyname̬IDʼֵ*/
	MODULE_ID_AP_GETHOSTBYNAME_END = MODULE_ID_AP_GETHOSTBYNAME_BASE + 0x100, /*apgethostbyname̬IDֵ*/
	//AP̬END

	//ǰcmux֧4·Ҫ4socket proxỵcmuxֵ֧ͨиı䣬ҲҪ޸
	MODULE_ID_SOCKET_PROXY,    //ͻοӦø֧0x100ɶ̬޸
	MODULE_ID_SOCKET_PROXY_END = MODULE_ID_SOCKET_PROXY + 3, 
	MODULE_ID_GUODIAN_BASE,
	MODULE_ID_GPS,  //	GPSӦģID
	
	//absvr
	MODULE_ID_ABSVR,
	MODULE_ID_ABCLIENT,
	
	// for audio-ctrl
	MODULE_ID_ZCORE,
	MODULE_ID_CALL_23G,
	MODULE_ID_CLAL_VOLTE,
	MODULE_ID_ZCORE_TEMP,
	MODULE_ID_CALL_23G_TEMP,
	MODULE_ID_CLAL_VOLTE_TEMP,
	MODULE_ID_LOCKNET,
	//kwatchtest
	MODULE_ID_KWATCH_CTRL, /*ֱ̨ͯģID*/
	MODULE_ID_KWATCH_CTRL_LOCAL,
	MODULE_ID_MMI_SVR, /*zte_phone MMIģID*/
	MODULE_ID_MMI_SVR_LOCAL,

	MODULE_ID_AMT,	
	
	/********************************************************************/
	//ͻοӦõϢIDʼֵ<0x2000(MODULE_ID_CPBASE)
	/********************************************************************/
	MODULE_ID_USER_BASE,
	MODULE_ID_AP_GPS_APP,
	MODULE_ID_USER_END = MODULE_ID_USER_BASE + 0x100,

	MODULE_ID_ATCTL_TO_VOLTE, /*ӦʵӦãֻʶVOLTEͨѶαͨţMODULEIDӦat_ctlVOLTEαͨ */
	MODULE_ID_VOLTE_TO_ATCTL = MODULE_ID_ATCTL_TO_VOLTE +10, /*ӦʵӦãֻʶVOLTEͨѶαͨţMODULEIDӦVOLTEat_ctlαͨ */
	MODULE_ID_USBHOTPLUG,
	MODULE_ID_POC_CTRL, /*POC̨ģID*/
	MODULE_ID_SECURITY_LOG,
	MODULE_ID_MBIM,
	MODULE_ID_VSIM,

    //voice
    MODULE_ID_VOICE_SERVER,
    MODULE_ID_VOICE_CLIENT,
	MODULE_ID_WLAN_PROXY,		//capwifi
	MODULE_ID_MNET_WHITELIST_PROXY,		//capwhitelist
} T_AP_Module_ID;

/* ------------- CP˴ڵģIDƽ̨ڲʹãŸͻ ------------- */
typedef enum {
	MODULE_ID_CPBASE = 0x2000,		/*CPģIDʼַ*/
	MODULE_ID_BL,
	MODULE_ID_FP_CLOCK,				/*ģID*/
//	MODULE_ID_ZCORE,
	MODULE_ID_CP_AT_CTL,
	MODULE_ID_CP_RTC_SERVICE,
	MODULE_ID_CP_MMI,
	MODUEL_ID_TCARD,
	MODULE_ID_CP_GPS_APP,

	// for audio ctrl
//	MODULE_ID_CALL_23G,
//	MODULE_ID_CLAL_VOLTE,
//	MODULE_ID_ZCORE_TEMP,
//	MODULE_ID_CALL_23G_TEMP,
//	MODULE_ID_CLAL_VOLTE_TEMP,
	
	/////Ϊ̬еIDʶ̬͹رգ뾲̬ģIDһ£κʱ̵ֻһʹ÷
	//׼мID
	//MODULE_ID_SOFTTIMER_BASE,
	//MODULE_ID_SOFTTIMER_END = MODULE_ID_SOFTTIMER_BASE + 0x100,
	MODULE_ID_CP_ATDYNAMIC_BASE,											/*cpѯat̬IDʼֵ*/
	MODULE_ID_CP_ATDYNAMIC_END = MODULE_ID_CP_ATDYNAMIC_BASE + 0x100,		/*cpѯat̬IDֵ*/
	MODULE_ID_CP_AUDIODYNAMIC_BASE,											/*cpaudio̬IDʼֵ*/
	MODULE_ID_CP_AUDIODYNAMIC_END = MODULE_ID_CP_AUDIODYNAMIC_BASE + 0x100,	/*cpaudio̬IDֵ*/
	//CP̬END

	MODULE_ID_MAX, /*Чmdouleidֵ*/
} T_CP_Module_ID;

#if 0//(APP_OS_TYPE == APP_OS_TOS)
#define  MODULE_ID_AT_CTL  MODULE_ID_AP_AT_CTL
#define  MODULE_ID_EXTERNAL_AT_CTL  MODULE_ID_AP_AT_CTL
#define  MODULE_ID_RTC_SERVICE MODULE_ID_CP_RTC_SERVICE
#define  MODULE_ID_EXTERNAL_RTC_SERVICE MODULE_ID_AP_RTC_SERVICE
#define  MODULE_ID_ATDYNAMIC_BASE MODULE_ID_CP_ATDYNAMIC_BASE
#define  MODULE_ID_ATDYNAMIC_END MODULE_ID_CP_ATDYNAMIC_END
#define  MODULE_ID_AUDIODYNAMIC_BASE MODULE_ID_CP_AUDIODYNAMIC_BASE
#define  MODULE_ID_AUDIODYNAMIC_END MODULE_ID_CP_AUDIODYNAMIC_END
#define  MODULE_ID_GPS_APP  MODULE_ID_CP_GPS_APP
//#elif(APP_OS_TYPE == APP_OS_LINUX)
#else
#define  MODULE_ID_AT_CTL  MODULE_ID_AP_AT_CTL
#define  MODULE_ID_EXTERNAL_AT_CTL  MODULE_ID_AP_AT_CTL
#define  MODULE_ID_RTC_SERVICE MODULE_ID_AP_RTC_SERVICE
#define  MODULE_ID_EXTERNAL_RTC_SERVICE MODULE_ID_AP_RTC_SERVICE
#define  MODULE_ID_ATDYNAMIC_BASE MODULE_ID_AP_ATDYNAMIC_BASE
#define  MODULE_ID_ATDYNAMIC_END MODULE_ID_AP_ATDYNAMIC_END
#define  MODULE_ID_AUDIODYNAMIC_BASE MODULE_ID_AP_AUDIODYNAMIC_BASE
#define  MODULE_ID_AUDIODYNAMIC_END MODULE_ID_AP_AUDIODYNAMIC_END
#define  MODULE_ID_GPS_APP  MODULE_ID_AP_GPS_APP
#endif

/* ģIDϢ MSG CMDΧ */
enum MSG_CDM_SCOPE {
	/**/
	MSG_CMD_MAINCTRL_BASE 	= 0x1000,
	MSG_CMD_MAINCTRL_END	= 0x1500,
	/**/
	MSG_CMD_ATCTL_BASE 		= 0x1501,
	MSG_CMD_ATCTL_END		= 0x1800,
	/**/
	MSG_CMD_ATCTL_INNER_BASE = 0x1801,
	MSG_CMD_ATCTL_INNER_END	= 0x2000,
	/**/
	MSG_CMD_SMS_BASE 		= 0x2001,
	MSG_CMD_SMS_END			= 0x2200,
	/**/
	MSG_CMD_PB_BASE 		= 0x2201,
	MSG_CMD_PB_END			= 0x2400,
	/**/
	MSG_CMD_BL_BASE 		= 0x2401,
	MSG_CMD_BL_END			= 0x3500,
	/**/
	MSG_CMD_OTHER_BASE  	= 0x3501,
	MSG_CMD_OTHER_END		= 0x4000,
	/**/
	MSG_CMD_WIFI_BASE 		= 0x4001,
	MSG_CMD_WIFI_END		= 0x4200,
	/**/
	MSG_CMD_MMI_BASE		= 0x4201,
	MSG_CMD_MMI_END			= 0x4400,
	/**/
	MSG_CMD_FOTA_BASE 		= 0x4401,
	MSG_CMD_FOTA_END		= 0x4600,

	/**/
	MSG_CMD_DM_BASE 		= 0x4801,
	MSG_CMD_DM_END			= 0x5000,
	/**/
	MSG_CMD_RTC_BASE 		= 0x5001,
	MSG_CMD_RTC_END			= 0x5200,
	/**/
	MSG_CMD_USER_BASE 		= 0x5201,
	MSG_CMD_USER_END		= 0x5700,
	/**/
	MSG_CMD_EXTAT_BASE 		= 0x5701,
	MSG_CMD_EXTAT_END		= 0x6000,

	/**/
	MSG_CMD_SOCMSG_BASE		= 0x6001,
	MSG_CMD_SOCMSG_END		= 0x6800,
	
	/**/
	MSG_CMD_LQ_BASE		    = 0x6801,
	MSG_CMD_LQ_END		    = 0x6900,

	/**/
	MSG_CMD_DRV_BASE 		= 0x6901,
	MSG_CMD_DRV_END			= 0x7000,

	/*wifi cap inter*/
	MSG_CMD_WIFI_CAP_BASE 		= 0x7201,
	MSG_CMD_WIFI_CAP_END		= 0x7400,

	//kwatchtest
	MSG_CMD_KWATCH_BASE      = 0x8001,
	MSG_CMD_KWATCH_END      = 0x9000,

	//amt device test
	MSG_CMD_AMT_DEVICE_TEST_BASE      = 0x9001,
	MSG_CMD_AMT_DEVICE_TEST_END      = 0x90C8,

    //VOICE
	MSG_CMD_VOICE_BASE      = 0x90D0,
	MSG_CMD_VOICE_END      = 0x90FF,
	
	//pocsvr
	MSG_CMD_POCSVR_BASE      = 0x9101,
	MSG_CMD_POCSVR_END      = 0x9200,
	
	//absvr
	MSG_CMD_ABSVR_BASE      = 0x9201,
	MSG_CMD_ABSVR_END      = 0x9300,

	//mnet_whitelist
	MSG_CMD_MNET_WHITELIST_BASE      = 0x9301,
	MSG_CMD_MNET_WHITELIST_END      = 0x9400,
};
#endif

#define MSG_MAGIC_WORD       0x3A3A3A3A  /*ȱʡħ*/
#define MSG_TYPE_DEFAULT     1   /*lMsgTypeĬϵϢ*/
#define MSG_TYPE_SOFTTIMER_TIMEOUT  2     /*soft timerʱϢ,ɾʱɾʱϢʱҪָ*/

/*ͨõϢṹ*/

/**
 * @brief message queue body for processes to exchange data
 * @param lMsgType ϢͣϢȡ˳
 * @param usTargetModuleID ĿģϢID
 * @param usSourceModuleID ԴģϢID
 * @param usMsgCmd Ϣ룬ָʾϢʲô
 * @param usDataLen ЯЧݳ
 * @param aucDataBuf ЯЧbuffer
 * @param ulMagic ħֵ֣ΪMSG_MAGIC_WORD
 */
typedef struct tagMSG_BUF {
	long   lMsgType;                /*ϢͣϢȡ˳*/
	int dst_id;                     /*ĿģϢID*/
	int src_id;                     /*ԴģϢID*/
	unsigned short usMsgCmd;        /*Ϣ룬ָʾϢʲô*/
	unsigned short usDataLen;       /*ЯЧݳ*/
	unsigned long  ulMagic;         /*ħֵ֣ΪMSG_MAGIC_WORD*/
	unsigned char  aucDataBuf[MSG_DATA_MAX_LEN]; /*ЯЧbuffer*/
} MSG_BUF;



#ifndef DOXYGEN_SHOULD_SKIP_THIS
/**
 * @brief ͨAT͵ĺ˼Ϣ
 * @param targetId Ϣģ
 * @param position  Ϣ͵ķ
 * @param msg_cmd  Ϣid
 * @param len  ݳ
 * @param msg  
 */
typedef struct {
	int srcId;
	int targetId;
	unsigned short position;
	unsigned short msg_cmd;
	unsigned short len;
	unsigned char  msg[SOC_MSG_MAX_LEN];
} T_Soc_Msg;
#endif

#ifdef __cplusplus
}
#endif

#endif

