/**
* @file rtc_timer.h
* @brief Public APIs of Sanechips
*
* Copyright (C) 2017 Sanechips Technology Co., Ltd.
* @author  Linxu Gebin
* @defgroup si_id Sanechips
*
* This program is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License version 2 as
* published by the Free Software Foundation.
*************************************************************************
*/

#ifndef _RTC_TIMER_H
#define _RTC_TIMER_H

/*******************************************************************************
 *                           Include header files                              *
 ******************************************************************************/
#include  <sys/time.h>
#include "message.h"

/*******************************************************************************
 *                             Macro definitions                               *
******************************************************************************/

#ifndef DOXYGEN_SHOULD_SKIP_THIS
/*******************************************************************************
 *                             Type definitions                                *
 ******************************************************************************/
/**
* @brief rtc message type
* @note
*/
enum RTC_CPU {
	RTC_CPU_CAP = 0,   //rtcCAP
	RTC_CPU_AP,       //rtcAP
};

/**
* @brief rtc type
* @note
*/
typedef enum {
	RTC_ID_START = 0,
	WIFI_INTERVAL_SLEEP,
	WIFI_PWR_SAVE,
	WIFI_WAKE_UP_SYSTEM,
	WIFI_WPS_RESULT_CHECK,
	WIFI_TSW_SLEEP,
	WIFI_TSW_WAKEUP,
	WIFI_ACL_SERVICE,
	WDT_TEMP_PROTECT,
	RTC_SAFECARE_CONTIME,
	RTC_SAFECARE_DELAY,
	RTC_ID_FP_CLOCK,
	RTC_ID_NOTDISTURB_BEGIN,
	RTC_ID_NOTDISTURB_END,
	RTC_ID_MMI_ALARM,
	RTC_ID_MMI_CLOCK_MODE_CHECK,
	RTC_ID_TRACK_BEGIN,
	RTC_ID_TRACK_UPLOAD=RTC_ID_TRACK_BEGIN,
	RTC_ID_TRACK_BASE,
	RTC_ID_TRACK_SERVER_CON,
	RTC_ID_TRACK_SLAVE_SERVER_CON,
	RTC_ID_TRACK_SLAVE_SERVER_CMD,
	RTC_ID_TRACK_DEBUG_SERVER_CON,
	RTC_ID_TRACK_LINK,
	RTC_ID_TRACK_LINK_TIMEOUT,
	RTC_ID_TRACK_AGPS,
	RTC_ID_TRACK_WEATHER_UPDATE,
	RTC_ID_TRACK_END,
	RTC_ID_SC_TIMER,
	RTC_ID_SC_ALARM,
	RTC_ID_END,
} RTC_ID;
#endif

/**
* @brief rtc Ϣ
* @param RTC_MSG_ALARM_ELAPSED ʱʱᷢϢʱӵ
* @param RTC_MSG_TIME_CHANGED RTCʱ:ʾʱ䷢仯ʱͬɻûֶõǰʱˣʱRTC̻㲥עʱģ飬ģʱ䶨ʱ
* @note
*/
#ifndef DOXYGEN_SHOULD_SKIP_THIS
enum RTC_MSG_CMD {
	RTC_MSG_GET_TIME = MSG_CMD_RTC_BASE,	//ȡʱ䣬ֱӵlinuxϵͳʱӿ
	RTC_MSG_SET_TIME,						//ʱ
	RTC_MSG_ADD_ALARM,						//rtcʱ
	RTC_MSG_DEL_ALARM,						//ɾrtcʱ
	RTC_MSG_ALARM_TIMEOUT,					//RTC alarmʱʱ䳬ʱ
	RTC_MSG_TIMER_TIMEOUT,					//RTC timerʱʱ䳬ʱ
	RTC_MSG_ALARM_ELAPSED,					//ʱʱᷢϢʱӵ
	RTC_MSG_DEL_ALL,						//йػĶʱrtcʱ㻹ϱ
	RTC_MSG_TIME_CHANGED,					//RTCʱ:ʾʱ䷢仯ʱͬɻûֶõǰʱˣʱRTC̻㲥עʱģ飬ģʱ䶨ʱ
	RTC_MSG_SNTP_UPDATE,					//SNTPͬ
};
#endif

/**
* @brief rtc data buffer
* @param srcModule ʱģ
* @param module ʱid
* @param ulSec ʱ䣬λ:s
* @param time_val  ǰʱ
* @param wakeup   ػѣ1:򿪣0:ر
* @param is_utc  Ƿutcʱ䣬
* @param cpu  rtccpu 0: cp, 1:ap
* @note utcʱȽϳWKALMʱ
*/
typedef struct tag_RTC_DATA_BUF {
	int srcModule;
	unsigned int   module;
	unsigned long   ulSec;
	unsigned long time_val;
	int wakeup;
	int is_utc;
	int cpu;
} RTC_DATA_BUF;


/*******************************************************************************
 *                       Global function declarations                          *
 ******************************************************************************/
/**
* @brief  Ӷʱ
* @param ulSec	ʱʱ䣬λ
* @param rtc_id	ʱID
* @param src_id	ʱģID
* @return ɹ0ʧܷ-1
*/
int rtc_timer_add(unsigned long ulSec, RTC_ID rtc_id, int src_id);

/**
* @brief Ӷʱ
* @param time	ʱʱ䣬λʱ,Ҫ: tm_sec/tm_min/tm_hour/tm_mday/tm_mon/tm_year
* @param rtc_id	ʱID
* @param src_id	ʱģID
* @param wakeup	ػǷ
* @note wakeup	0, 1 
* @return ɹ0ʧܷ-1
*/
int rtc_timer_add_utc(struct tm *time, RTC_ID rtc_id, int src_id, int wakeup);


/**
* @brief ɾʱ
* @param rtc_id	ʱID
* @param src_id	ʱģID
* @return ɹ0ʧܷ-1
*/
int rtc_timer_del(RTC_ID rtc_id, int src_id);


/**
* @brief ɾжʱ
* @param src_id		ɾʱģID
* @param req_cmd	ظϢcmd
* @return ɹ0ʧܷ-1
*/
int rtc_timer_del_all(int src_id, unsigned short req_cmd);


/**
* @brief rtcǰʱ
* @param src_id	ʱģID
* @return rtcǰʱ
*/
int  rtc_set_time(int src_id);

#endif


