#include <ctype.h>
#include <errno.h>
#include <unistd.h>
#include <getopt.h>
#include <limits.h>
#include <netdb.h>
#include <stdbool.h>
#include <stdint.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>
#include <syslog.h>
#include <pthread.h>
#include <sys/socket.h>
#include <sys/types.h>
#include <sys/un.h>
#include <sys/ioctl.h>
#include <fcntl.h>
#include "linklist.h"
#include "socket_tok.h"

/*command max len 64*/
#define SOCKET_CMD_MAX_LEN 		1024
#define BUF_SIZE 1024

#define EXIT_CMD_STOP	"stop\n"
#define EXIT_CMD_Q	"q\n"
#define EXIT_CMD_EXIT	"exit\n"

#define SOCKET_CREATE	"sock_create"
#define SOCKET_CREATECLIENT	"sock_createclient"
#define SOCKET_CREATESERVER	"sock_createserver"
#define SOCKET_BIND	    "sock_bind"
#define SOCKET_LISTEN	"sock_listen"
#define SOCKET_ACCEPT	"sock_accept"
#define SOCKET_CONN	    "sock_conn"
#define SOCKET_SEND		"sock_send"
#define SOCKET_SENDTO	"sock_sendto"
#define SOCKET_WRITE	"sock_write"
#define SOCKET_RECV     "sock_recv"
#define SOCKET_RECVFROM "sock_recvfrom"
#define SOCKET_READ     "sock_read"
#define SOCKET_CLOSE    "sock_close"
#define SOCKET_LOCALTEST    "sock_localtest"

#define sock_param_len 4096

typedef unsigned short      UINT16;
typedef unsigned long int   UINT32;

static int g_sockfd = -1;

static char* sms_convert_cardinfo_state(int type, int value);

static void printUsage(const char *Opt)
{
	printf("Usage: %s\n", Opt);
	printf("sock_create:type        create a new socket(eg. sock_create:1)\n");
	printf("sock_createclient:type,addr,data       create a new client socket(eg. sock_createclient:1,/var/sockclient,data)\n");
	printf("sock_createserver:type,addr,backlog       create a new server socket(eg. sock_createserver:1,/var/sockserver,30)\n");
	printf("sock_bind:fd,addr        socket bind(eg. sock_bind:fd,/var/sockclient)\n");
	printf("sock_listen:fd,backlog   socket listen(eg. sock_listen:fd,30)\n");
	printf("sock_accept:fd           socket accept(eg. sock_accept:fd)\n");
	printf("sock_conn:fd,srvaddr        conn server socket(eg. sock_conn:fd, /var/sockserver)\n");
	printf("sock_send:fd,message         send socket message(eg. sock_send:fd,ipc test)\n");
	printf("sock_sendto:fd,srvaddr,message   sendto socket message(eg. sock_sendto:fd,/var/sockserver,ipc test)\n");
	printf("sock_write:fd,message         write socket message(eg. sock_write:fd,ipc test)\n");
	printf("sock_recv:fd        recv socket message(eg. sock_recv: fd)\n");
	printf("sock_recvfrom:fd        recvfrom socket message(eg. sock_recvfrom: fd)\n");
	printf("sock_read:fd        read socket message(eg. sock_read: fd)\n");
	printf("sock_close:fd       close socket message(eg. sock_close: fd)\n");
	printf("sock_localtest:     test local socket operation\n");
	printf("\n");
}

static int parseOpts(int argc, char *argv[]) 
{
	int rc = 0;
    int c;
    while ((c = getopt(argc, argv, "?n:a:")) != -1) {
        switch (c) {
        case 'a':
            break;
		case 'n':
			break;
        case '?':
        default:
            printUsage(argv[0]);
            return -1;
        }
    }

    return rc;
}

/**
enum sock_type {
	SOCK_STREAM	= 1,
	SOCK_DGRAM	= 2,
	SOCK_RAW	= 3,
	SOCK_RDM	= 4,
	SOCK_SEQPACKET	= 5,
	SOCK_DCCP	= 6,
	SOCK_PACKET	= 10,
};
**/
static int socket_create(char *data, int data_len)
{
	int sockfd = -1;
	int type = 0;
	printf("socket_create test \n");	
	
	if (at_tok_start(&data) < 0) {
		printf("socket_create:at_tok_start error\n");
	}
	
	if(at_tok_nextint(&data, &type) < 0) {
		printf("socket_create:at_tok_nextstr error\n");
	}
	printf("socket_create:type=%d\n", type);
	
	sockfd = socket(AF_UNIX, type, 0);
	if(sockfd < 0){
		printf("socket_create error: %s(errno: %d) \n", strerror(errno), errno);
	}else{
		printf("socket_create sucess:sockfd=%d\n", sockfd);
	}
	g_sockfd = sockfd;
	return 0;
}

static int socket_test_local()
{
	int clientfd = -1;
	int serverfd = -1;
	int numRecv;
	char data[BUF_SIZE] = {0};
	struct sockaddr_un my_addr = {0};
	
	if((clientfd  = socket(AF_UNIX, 2, 0))<0){
		printf("socket_test_local: create client socket error \n");
		return -1;
	}

	if((serverfd  = socket(AF_UNIX, 2, 0))<0){
		printf("socket_test_local: create server socket error \n");
		return -1;
	}

	memset(&my_addr, 0, sizeof(struct sockaddr_un));
	my_addr.sun_family = AF_UNIX;
	strncpy(my_addr.sun_path, "/var/socktest", sizeof(my_addr.sun_path)-1);

	//˰󶨵ַ
	if(bind(serverfd, (struct sockaddr*)&my_addr, sizeof(my_addr)) == 0){
		printf("server socket 󶨳ɹ \n");
	}
	else{
		printf("server socket ʧ \n");		
	}

	//δӣͻֱӸ˷
	if(sendto(clientfd, "send data to server test one", 28, 0, &my_addr, sizeof(my_addr)) < 0){
		printf("send data to server test one failed \n");		
	}
	
	//ȡ
	if(read(serverfd, data, BUF_SIZE-1) < 0){
		printf("recv data test one failed \n");
	}else{
		printf("recv data test one sucess \n");
	}

	//ӷ
	if(connect(clientfd, (struct sockaddr*)&my_addr, sizeof(my_addr)) < 0){
		printf("connect error: %s(errno: %d) \n", strerror(errno), errno);
		return -1;
	}

	if(send(clientfd, "send data to server test two", 28, 0) < 0){
		printf("send data to server test two failed: %s(errno: %d) \n", strerror(errno), errno);
			
	}else{
		printf("send data to server test two sucess \n");
	}	

	memset(data, 0, sizeof(data));
	if(numRecv = recv(serverfd, data, sizeof(data)-1, 0) == -1){
		printf("recv data test two failed \n");		
	}else{
		printf("recv data test two sucess \n");
	}

	//Է˸ͻ˷ϢǷͨ
	if(send(serverfd, "send data to server test three", 30, 0) < 0){
		printf("send data to server test three failed: %s(errno: %d) \n", strerror(errno), errno);			
	}else{
		printf("send data to server test three sucess \n");
	}	
	fcntl(clientfd, F_SETFL, O_NONBLOCK);
	memset(data, 0, sizeof(data));
	if(numRecv = recv(clientfd, data, sizeof(data)-1, 0) == -1){
		printf("recv data test three failed \n");		
	}else{
		printf("recv data test three sucess \n");
	}

	//ͻ˰󶨵ַ
	memset(&my_addr, 0, sizeof(struct sockaddr_un));
	my_addr.sun_family = AF_UNIX;
	strncpy(my_addr.sun_path, "/var/sockclient", sizeof(my_addr.sun_path)-1);

	//ͻ˰󶨵ַ
	if(bind(clientfd, (struct sockaddr*)&my_addr, sizeof(my_addr)) == 0){
		printf("client socket 󶨳ɹ \n");
	}
	else{
		printf("client socket ʧ \n");		
	}

	//δӣֱӸͻ˷
	if(sendto(serverfd, "send data to server test four", 29, 0, &my_addr, sizeof(my_addr)) < 0){
		printf("send data to server test four failed \n");		
	}else{
		printf("send data to server test four sucess \n");
	}
	
	//ȡ
	if(read(clientfd, data, BUF_SIZE-1) < 0){
		printf("recv data test four failed \n");
	}else{
		printf("recv data test four sucess \n");
	}

	close(clientfd);
	close(serverfd);
}

void socket_test_dgram_data(int fd, char* paddr, char* pdata){
	struct sockaddr_un other_addr = {0};
	ssize_t numRead;
	ssize_t numRecv;
	char buf[2048] = {0};
	int sockfd = -1;
	sockfd = fd;
	int ret;
	memset(&other_addr, 0, sizeof(struct sockaddr_un));
	other_addr.sun_family = AF_UNIX;
	strncpy(other_addr.sun_path, paddr, sizeof(other_addr.sun_path)-1);
	
	//һַzZ򴴽socket
	if(other_addr.sun_path[0] == 'z' || other_addr.sun_path[0]=='Z'){
		printf("socket_test_dgram_data: anonymous socket\n");
		other_addr.sun_path[0] = '\0';
	}
	//δӣͻֱӸ˷
	if(sendto(sockfd, "send dgram data to server test one", 34, 0, &other_addr, sizeof(other_addr)) < 0){
		printf("sendto dgram data to server test one failed \n");		
	}else{
		printf("sendto dgram data to server test one sucess \n");
	}
#if 0
	memset(buf, 0, sizeof(buf));
	if(recvfrom(sockfd, buf, sizeof(buf)-1, 0, (struct sockaddr*)&other_addr, sizeof(other_addr)) <= 0){
		printf("recvfrom: dgram data to server test one failed \n");
	}else{
		printf("recvfrom: dgram data to server test one sucess \n");
	}
#endif
	//ӷ
	if(ret = connect(sockfd, (struct sockaddr*)&other_addr, sizeof(other_addr)) < 0){
		printf("socket_create_client: connect error:ret=%d, %s(errno: %d) \n", ret, strerror(errno), errno);
		
		return -1;
	}else{
		printf("ɹ: sockfd=%d\n", sockfd);
	}
		
	
	printf("send msg to server: \n");
	memset(buf, 0, sizeof(buf));

	if(sendto(sockfd, "send dgram data to server test two", 34, 0, &other_addr, sizeof(other_addr)) < 0){
		printf("sendto dgram data to server test two failed \n");		
	}else{
		printf("sendto dgram data to server test two sucess \n");
	}
	
#if 0
	if(recvfrom(sockfd, buf, sizeof(buf)-1, 0, (struct sockaddr*)&other_addr, sizeof(other_addr)) <= 0){
		printf("recvfrom: dgram data to server two failed \n");
	}else{
		printf("recvfrom: dgram data to server two sucess \n");
	}
#endif

	memset(buf, 0, sizeof(buf));
	// sendrecv
	if(send(sockfd, "send dgram data to server test three", 36, 0) < 0){
		printf("send dgram data to server test three failed \n");		
	}else{
		printf("send dgram data to server test three sucess \n");
	}

#if 0
	if(recv(sockfd, buf, sizeof(buf)-1, 0) <= 0){
		printf("recvfrom: dgram data to server three failed \n");
	}else{
		printf("recvfrom: dgram data to server three sucess \n");
	}
#endif
	memset(buf, 0, sizeof(buf));
	// writeread
	if(write(sockfd, "send dgram data to server test four", 35) < 0){
		printf("write dgram data to server test four failed \n");		
	}else{
		printf("write dgram data to server test four sucess \n");
	}
	
#if 0
	if(read(sockfd, buf, sizeof(buf)-1) <= 0){
		printf("recvfrom: dgram data to server four failed \n");
	}else{
		printf("recvfrom: dgram data to server four sucess \n");
	}
#endif
	
	if(pdata != NULL){
		if(send(sockfd, pdata, strlen(pdata), 0) < 0){
			printf("socket_create_client: send dgram msg error: %s(errno: %d) \n", strerror(errno), errno);
			return -1;	
		}
		printf("send sucess: %s \n", pdata);
	}else{
		if(send(sockfd, "send dgram msg to server test", 29, 0) < 0){
			printf("socket_create_client: send dgram msg error: %s(errno: %d) \n", strerror(errno), errno);
			return -1;	
		}
		printf("send msg to server test \n");
	}
	
#if 0
	if(numRecv = recv(sockfd, buf, sizeof(buf), 0) == -1){
		printf("socket_create_client: recv error \n");
		return -1;
	}
	printf("socket_create_client Receieved: %s \n", buf);
#endif	
	if(close(sockfd) == 0){
		printf("clsoe sockfd:%d sucess \n", sockfd);
	}else{
		printf("clsoe sockfd:%d failed \n", sockfd);
	}
}

void socket_test_stream_data(int fd, char* paddr, char* pdata){
	struct sockaddr_un other_addr = {0};
	ssize_t numRead;
	ssize_t numRecv;
	char buf[2048] = {0};
	int sockfd = -1;
	sockfd = fd;
	memset(&other_addr, 0, sizeof(struct sockaddr_un));
	other_addr.sun_family = AF_UNIX;
	strncpy(other_addr.sun_path, paddr, sizeof(other_addr.sun_path)-1);	
	
	//һַzZ򴴽socket
	if(other_addr.sun_path[0] == 'z' || other_addr.sun_path[0]=='Z'){
		printf("socket_test_stream_data: anonymous socket\n");
		other_addr.sun_path[0] = '\0';
	}
	//ӷ
	if(connect(sockfd, (struct sockaddr*)&other_addr, sizeof(other_addr)) < 0){
		printf("socket_create_client: connect error: %s(errno: %d) \n", strerror(errno), errno);
		close(fd);
		return -1;
	}else{
		printf("ɹ: sockfd=%d\n", sockfd);
	}		
	
	printf("send msg to server: \n");	

	memset(buf, 0, sizeof(buf));
	// sendrecv
	if(send(sockfd, "send stream data to server test one", 35, 0) < 0){
		printf("send stream data to server test one failed \n");		
	}else{
		printf("send stream data to server test one sucess \n");
	}

	if(recv(sockfd, buf, sizeof(buf)-1, 0) <= 0){
		printf("recv: stream data to server one failed \n");
	}else{
		printf("recv: stream data to server one sucess \n");
	}

	memset(buf, 0, sizeof(buf));
	// writeread
	if(write(sockfd, "send stream data to server test two", 35) < 0){
		printf("write stream data to server test two failed \n");		
	}else{
		printf("write stream data to server test two sucess \n");
	}

	if(read(sockfd, buf, sizeof(buf)-1) <= 0){
		printf("read: stream data to server two failed \n");
	}else{
		printf("read: stream data to server two sucess \n");
	}

	memset(buf, 0, sizeof(buf));	
	if(pdata != NULL){
		if(send(sockfd, pdata, strlen(pdata), 0) < 0){
			printf("socket_create_client: send stream msg error: %s(errno: %d) \n", strerror(errno), errno);
			close(fd);
			return -1;	
		}
		printf("send sucess: %s \n", pdata);
	}else{
		if(send(sockfd, "send stream msg to server test", 30, 0) < 0){
			printf("socket_create_client: send stream msg error: %s(errno: %d) \n", strerror(errno), errno);
			close(fd);
			return -1;	
		}
		printf("send stream msg to server test \n");
	}

	if(numRecv = recv(sockfd, buf, sizeof(buf), 0) == -1){
		printf("socket_create_client: recv error \n");
		close(fd);
		return -1;
	}
	printf("recv sucess: %s \n", buf);
	if(close(sockfd) == 0){
		printf("clsoe sockfd:%d sucess \n", sockfd);
	}else{
		printf("clsoe sockfd:%d failed \n", sockfd);
	}
}
static int socket_create_client(char *data, int data_len)
{
	int sockfd = -1;	
	int type = 0;
	char* paddr = NULL;
	char* pdata = NULL;
	struct sockaddr_un other_addr = {0};
	int backlog = 0;
	ssize_t numRead;
	ssize_t numRecv;
	char buf[2048] = {0};
	int i=0;
	printf("socket_create_client test \n");	
	
	if (at_tok_start(&data) < 0) {
		printf("socket_create_client:at_tok_start error\n");
	}
	
	if(at_tok_nextint(&data, &type) < 0) {
		printf("socket_create_client:at_tok_nextstr error\n");
	}
	printf("socket_create_client:type=%d\n", type);

	if(at_tok_nextstr(&data, &paddr) < 0) {
		printf("socket_create_client:at_tok_nextstr error\n");
	}

	printf("socket_create_client: addr=%s \n", paddr);

	if(at_tok_nextstr(&data, &pdata) < 0) {
		printf("socket_create_client: no test data\n");
	}
	
	if(strlen(paddr) > sizeof(other_addr.sun_path)-1)
	{
		printf("socket_create_client:server socket path too logn: %s\n", paddr);
		return -1;
	}	
	
    if(type == 1){
		while(true){
			if((sockfd = socket(AF_UNIX, type, 0))<0){
				printf("socket_create_client: create socket error \n");
				return -1;
			}		
			printf("socket_create_client: socket_create:sockfd=%d(%d)\n", sockfd, i);
			socket_test_stream_data(sockfd, paddr, pdata);
			sleep(1);
			i++;
		}
	}else if(type ==2){
		while(true){
			if((sockfd = socket(AF_UNIX, type, 0))<0){
				printf("socket_create_client: create socket error \n");
				return -1;
			}
				
			printf("socket_create_client: socket_create:sockfd=%d(%d)\n", sockfd, i);
			socket_test_dgram_data(sockfd, paddr, pdata);
			sleep(1);
			i++;
		}
	}	
	
	return 0;
}

static void do_recv(int fd)
{
	int ret = -1;
	char buf[BUF_SIZE];
	char resp_buf[BUF_SIZE+10];
	printf("do_recv loop enter, fd=%d \n", fd);
	while(1)
	{
		memset(buf, 0, BUF_SIZE);
		do
		{
			ret = read(fd,buf,BUF_SIZE-1);
		}while(ret < 0 && errno == EINTR);//д
		
		if(ret < 0)
		{
			printf("fd %d read error, ret=%d!\n", fd, ret);
			continue;
		}
		if(ret == 0)//Էѹر
		{
			printf("client is close!\n");
			//close(fd);
			continue;
		}
		
		if(ret > 0)
		{
			printf("read sucess, fd:%d, recv data=%s \n", fd, buf);
			
			//ret = write(fd, buf, ret);
			
			//printf("write back data=%s, len=%d \n",buf, ret);
		}
	}
}

static void do_select(int fd)
{
	linklist fdlist,sun_list;
	fdlist = create_linklist();
	datatype sun_data = {0};
	sun_data.fd = fd;
	int maxfd = fd;	
	//struct timeval tout = {5,0};

	insert_end_linklist(fdlist,sun_data);//lsten()fdб
	//show_linklist(fdlist);
	
	fd_set fdset;
	int newfd = -1;
	int ret = -1;
	char buf[BUF_SIZE];
	char resp_buf[BUF_SIZE+10];
	struct sockaddr_un addr_un;
	socklen_t cun_addr_len = sizeof(addr_un);
	/* select()ʵI/O·*/
	while(1)
	{
		int i;
		FD_ZERO(&fdset);
		if(get_length_linklist(fdlist) >= 1)//беfdϽд
		{			
			for(i=0;i<get_length_linklist(fdlist);i++)
			{
				sun_list = get_list_pos_linklist(fdlist,i);
				sun_data = sun_list->data;
				FD_SET(sun_data.fd,&fdset);
				maxfd = sun_data.fd > maxfd ? sun_data.fd : maxfd;
				printf(" %d fd:%dip:%sport:%d\n",i,sun_data.fd,sun_data.ipv4_addr,sun_data.port);
			}
			//show_linklist(fdlist);
		}
		else
		{
			continue ;
		}
		//switch(select(maxfd+1,&fdset,NULL,NULL,&tout))
		switch(ret=select(maxfd+1,&fdset,NULL,NULL,NULL))
		{			
			case 0:
			{
				printf("time out!\n");
				goto _error1;
			}
			case -1:
			{
				printf("select error\n");
				goto _error1;
			}
			default:
			{
				printf("select ret=%d \n", ret);
				if(FD_ISSET(fd,&fdset))//пͻ˷
				{				    
					bzero(&addr_un, sizeof(addr_un));
				    //if((newfd = accept(fd,NULL,0)) < 0)
					if((newfd = accept(fd,(struct sockaddr *)&addr_un,&cun_addr_len)) < 0)
					{
						printf("connect failed: newfd=%d\n", newfd);
						
						goto _error1;
					}
					/* ɹ׽newfdóɷģʽ*/
					int b_on = 1;
   					ioctl(newfd, FIONBIO, &b_on);//ɹ׽newfdΪʽ
					sun_data.fd = newfd;
					printf("get a new client->(ip:%s)(port:%d)(fd:%d)\n",sun_data.ipv4_addr,sun_data.port,sun_data.fd);
					
					insert_end_linklist(fdlist,sun_data);//ͻӵfdб
					//show_linklist(fdlist);
				}
				else//ӺõĿͻ˷
				{				
					for(i=0;i<get_length_linklist(fdlist);i++)//еfdһ
					{
						
						sun_list = get_list_pos_linklist(fdlist,i);
						sun_data = sun_list->data;
						
						//printf("readung fd is ->( %d )(fd:%d)(ip:%s)(port:%d)\n",i,sun_data.fd,sun_data.ipv4_addr,sun_data.port);
						if(sun_data.fd == fd)//ǽӺnewfd
							continue ;
												
						bzero(buf,BUF_SIZE);
						do
						{
							ret = read(sun_data.fd,buf,BUF_SIZE-1);
						}while(ret < 0 && errno == EINTR);//д
						
						if(ret < 0)
						{
							printf("fd %d read error, ret=%d, errno=%d!\n", sun_data.fd, ret, errno);
							continue;
						}
						if(ret == 0)//Էѹر
						{
							printf("client is close, errno=%d!\n", errno);
							close(sun_data.fd);
							delete_locate_linklist(fdlist,sun_data);
							continue;
						}
						
						printf("read sucess, fd(:%d) receive data: %s \n",sun_data.fd,buf);
						ret = write(sun_data.fd, buf, ret);	
						printf("write back data=%s, len=%d \n",buf, ret);
					}
				}			
			}
		}
	}

	close(newfd);
_error1:
	printf("exit cause by _error1!\n");
	close(fd);
	clear_linklist(fdlist);
}

//"/tmp/us_xfr"  "zmysocket"
static int socket_create_server(char *data, int data_len)
{
	int sockfd = -1;
	int cfd = -1;
	int type = 0;
	char* paddr = NULL;	
	struct sockaddr_un my_addr = {0};
	int backlog = 0;
	ssize_t numRead;
	char buf[2048] = {0};
	printf("socket_create_server test \n");	
	
	if (at_tok_start(&data) < 0) {
		printf("socket_create_server:at_tok_start error\n");
	}
	
	if(at_tok_nextint(&data, &type) < 0) {
		printf("socket_create_server:at_tok_nextstr error\n");
	}
	printf("socket_create_server:type=%d\n", type);

	if(at_tok_nextstr(&data, &paddr) < 0) {
		printf("socket_create_server:at_tok_nextstr error\n");
	}

	printf("socket_create_server: addr=%s \n", paddr);

	if(at_tok_nextint(&data, &backlog) < 0) {
		printf("socket_create_server:at_tok_nextstr error\n");
	}
	
	if((sockfd = socket(AF_UNIX, type, 0)) < 0)
	{
		printf("socket_create_server failed, type=%d \n", type);
		return -1;
	}
	g_sockfd = sockfd;
	printf("socket_create_server:type=%d, sockfd=%d\n", type, sockfd);

	/*󶨵ַ */ 
	int b_reuse = 1;
	setsockopt(sockfd,SOL_SOCKET,SO_REUSEADDR,&b_reuse,sizeof(int)); 
	
	if(strlen(paddr) > sizeof(my_addr.sun_path)-1)
	{
		printf("socket_bind:server socket path too long: %s\n", paddr);
		goto error;
	}

	if(access(paddr,F_OK))
	{
		unlink(paddr);//ɾļ	
	}
	
	memset(&my_addr, 0, sizeof(struct sockaddr_un));
	my_addr.sun_family = AF_UNIX;
	strncpy(my_addr.sun_path, paddr, sizeof(my_addr.sun_path)-1);
	//һַzZ򴴽socket
	if(my_addr.sun_path[0] == 'z' || my_addr.sun_path[0]=='Z'){
		printf("socket_create_server: anonymous socket\n");
		my_addr.sun_path[0] = '\0';
	}
	if(bind(sockfd, (struct sockaddr*)&my_addr, sizeof(my_addr)) == 0){
		printf("socket󶨳ɹ \n");
	}
	else{
		printf("socketʧ errno=%d, strerror=%s\n", errno, strerror(errno));	
		goto error;
	}

	if(type == 1){
		if(listen(sockfd, backlog) == 0){
			printf("socketɹ \n");
		}else{
			printf("socketʧ \n");
			goto error;
		}
		do_select(sockfd);
	}else{
		do_recv(sockfd);
	}

	
	
#if 0

	for(;;){
		cfd = accept(sockfd, NULL, NULL);
		if(cfd  == -1){
			printf("socket_create_server: accept failed");
			continue;
		}

		printf("socket_create_server cfd=%d \n", cfd);
		while((numRead = recv(cfd, buf, sizeof(buf), 0)) > 0){
			printf("socket_create_server:read data=%s \n", buf);
		}

		if(numRead == -1){
			printf("socket_create_server: read data failed \n");
			
		}

		if(!fork()){
			if(send(cfd, "you are connected! \n", 19, 0) == -1)
			{
				printf("socket_create_server: send error \n");
				close(cfd);
				exit(0);
			}
		}
		if(close(cfd) == -1){
			printf("socket_create_server: cfd close failed\n");
		}
		
	}
#endif

error:
	close(sockfd);
	return 0;
	
}

static int socket_bind(char *data, int data_len)
{
	int sockfd = -1;
	char* paddr = NULL;
	struct sockaddr_un my_addr = {0};
	
	if (at_tok_start(&data) < 0) {
		printf("socket_bind:at_tok_start error\n");
	}
	
	if(at_tok_nextint(&data, &sockfd) < 0) {
		printf("socket_bind:at_tok_nextstr error\n");
	}

	if(at_tok_nextstr(&data, &paddr) < 0) {
		printf("socket_bind:at_tok_nextstr error\n");
	}

	printf("socket_bind: sockfd=%d, addr=%s \n", sockfd, paddr);
	
	if(strlen(paddr) > sizeof(my_addr.sun_path)-1)
	{
		printf("socket_bind:server socket path too logn: %s\n", paddr);
		return -1;
	}

	memset(&my_addr, 0, sizeof(struct sockaddr_un));
	my_addr.sun_family = AF_UNIX;
	strncpy(my_addr.sun_path, paddr, sizeof(my_addr.sun_path)-1);
	
	//һַzZ򴴽socket
	if(my_addr.sun_path[0] == 'z' || my_addr.sun_path[0]=='Z'){
		printf("socket_bind: anonymous socket\n");
		my_addr.sun_path[0] = '\0';
	}

	if(access(paddr,F_OK))
	{
		unlink(paddr);//ɾļ	
	}
	
	if(bind(sockfd, (struct sockaddr*)&my_addr, sizeof(my_addr)) == 0){
		printf("socket󶨳ɹ \n");
	}
	else{
		printf("socketʧ errno=%d, strerror=%s\n", errno, strerror(errno));		
	}
	return 0;
}

static int socket_listen(char *data, int data_len)
{
	int sockfd = -1;
	int backlog = 0;
	struct sockaddr_un my_addr = {0};
	
	if (at_tok_start(&data) < 0) {
		printf("socket_listen:at_tok_start error\n");
	}
	
	if(at_tok_nextint(&data, &sockfd) < 0) {
		printf("socket_listen:at_tok_nextint error\n");
	}

	if(at_tok_nextint(&data, &backlog) < 0) {
		printf("socket_listen:at_tok_nextint error\n");
	}

	printf("socket_bind: sockfd=%d, backlog=%d \n", sockfd, backlog);

	if(listen(sockfd, backlog) == 0){
		printf("socketɹ \n");
	}else{
		printf("socketʧ \n");
	}
	return 0;
}

static int socket_accept(char *data, int data_len)
{
	int sockfd = -1;
	int newfd = -1;
	int ret = -1;
	struct sockaddr_un addr_un;
	socklen_t cun_addr_len = sizeof(addr_un);
	
	if (at_tok_start(&data) < 0) {
		printf("socket_accept:at_tok_start error\n");
	}
	
	if(at_tok_nextint(&data, &sockfd) < 0) {
		printf("socket_accept:at_tok_nextint error\n");
	}
	
	printf("socket_accept sockfd=%d \n", sockfd);
	
	if((newfd = accept(sockfd,(struct sockaddr *)&addr_un,&cun_addr_len)) < 0)						
	{
		printf("socket_accept failed: newfd=%d\n", newfd);		
	}else{
		printf("socket_accept sucess: newfd=%d\n", newfd);
	}
	return 0;
}


static int socket_connect(char *data, int data_len)
{
	int sockfd = -1;
	char* paddr = NULL;
	struct sockaddr_un my_addr = {0};
	
	if (at_tok_start(&data) < 0) {
		printf("socket_connect:at_tok_start error\n");
	}
	
	if(at_tok_nextint(&data, &sockfd) < 0) {
		printf("socket_connect:at_tok_nextstr error\n");
	}

	if(at_tok_nextstr(&data, &paddr) < 0) {
		printf("socket_connect:at_tok_nextstr error\n");
	}

	printf("socket_connect: sockfd=%d, addr=%s \n", sockfd, paddr);
	
	if(strlen(paddr) > sizeof(my_addr.sun_path)-1)
	{
		printf("socket_connect:server socket path too logn: %s\n", paddr);
		return -1;
	}

	memset(&my_addr, 0, sizeof(struct sockaddr_un));
	my_addr.sun_family = AF_UNIX;
	strncpy(my_addr.sun_path, paddr, sizeof(my_addr.sun_path)-1);
	printf("socket_connect: my_addr.sun_path=%s \n", my_addr.sun_path);

	//һַzZ򴴽socket
	if(my_addr.sun_path[0] == 'z' || my_addr.sun_path[0]=='Z'){
		printf("socket_connect: anonymous socket\n");
		my_addr.sun_path[0] = '\0';
	}
	
	if(connect(sockfd, (struct sockaddr*)&my_addr, sizeof(my_addr)) == 0){
		printf("ɹ \n");
	}
	else{
		printf("ʧ\n");
	}

	return 0;
}

static int socket_send(char *data, int data_len)
{	
	int sockfd = -1;
	char* pdata = NULL;	
	int len = 0;
	if (at_tok_start(&data) < 0) {
		printf("socket_send:at_tok_start error\n");
	}
	
	if(at_tok_nextint(&data, &sockfd) < 0) {
		printf("socket_send:at_tok_nextstr error\n");
	}

	if(at_tok_nextstr(&data, &pdata) < 0) {
		printf("socket_send:at_tok_nextstr error\n");
		return -1;
	}

	printf("socket_send: sockfd=%d, pdata=%s \n", sockfd, pdata);
	
	len = send(sockfd, pdata, strlen(pdata), 0);
	
	if(len > 0){
		printf("socket_send sucess, data=%s, len=%d \n", pdata, len);
	}else{
		printf("socket_send failed, error: %s(errno: %d) \n", strerror(errno), errno);
	}
	
	return 0;
}

static int socket_sendto(char *data, int data_len)
{	
	int sockfd = -1;
	char* pdata = NULL;
	char* paddr = NULL;	
	struct sockaddr_un other_addr = {0};
	int len = 0;
	if (at_tok_start(&data) < 0) {
		printf("socket_sendto:at_tok_start error\n");
	}
	
	if(at_tok_nextint(&data, &sockfd) < 0) {
		printf("socket_sendto:at_tok_nextstr error\n");
	}

	if(at_tok_nextstr(&data, &paddr) < 0) {
		printf("socket_sendto:at_tok_nextstr error\n");
		return -1;
	}
	
	if(at_tok_nextstr(&data, &pdata) < 0) {
		printf("socket_sendto:at_tok_nextstr error\n");
		return -1;
	}

	printf("socket_sendto: sockfd=%d, addr=%s \n", sockfd, paddr);
	
	if(strlen(paddr) > sizeof(other_addr.sun_path)-1)
	{
		printf("socket_sendto:server socket path too logn: %s\n", paddr);
		return -1;
	}

	memset(&other_addr, 0, sizeof(struct sockaddr_un));
	other_addr.sun_family = AF_UNIX;
	strncpy(other_addr.sun_path, paddr, sizeof(other_addr.sun_path)-1);
	printf("socket_sendto: other_addr.sun_path=%s \n", other_addr.sun_path);

	//һַzZ򴴽socket
	if(other_addr.sun_path[0] == 'z' || other_addr.sun_path[0]=='Z'){
		printf("socket_sendto: anonymous socket\n");
		other_addr.sun_path[0] = '\0';
	}		
	
	len = sendto(sockfd, pdata, strlen(pdata), 0, &other_addr, sizeof(other_addr));

	if(len >= 0){
		printf("socket_sendto sucess, data=%s, len=%d \n", pdata, len);
	}else{
		printf("socket_sendto failed, error: %s(errno: %d) \n", strerror(errno), errno);
	}
	return 0;
}

static int socket_write(char *data, int data_len)
{	
	int sockfd = -1;
	char* pdata = NULL;	
	int len = 0;
	if (at_tok_start(&data) < 0) {
		printf("socket_write:at_tok_start error\n");
	}
	
	if(at_tok_nextint(&data, &sockfd) < 0) {
		printf("socket_write:at_tok_nextstr error\n");
	}

	if(at_tok_nextstr(&data, &pdata) < 0) {
		printf("socket_write:at_tok_nextstr error\n");
		return -1;
	}

	printf("socket_write: sockfd=%d, pdata=%s \n", sockfd, pdata);
		
	len = write(sockfd, pdata, strlen(pdata));
	if(len > 0){
		printf("socket_write sucess, data=%s, len=%d \n", pdata, len);
	}else{
		printf("socket_write failed, error: %s(errno: %d) \n", strerror(errno), errno);
	}
	
	return 0;
}

static int socket_recv(char *data, int data_len)
{
	int sockfd = -1;
	char pdata[2048] = {0};	
	int len = 0;
	if (at_tok_start(&data) < 0) {
		printf("socket_recv:at_tok_start error\n");
	}
	
	if(at_tok_nextint(&data, &sockfd) < 0) {
		printf("socket_recv:at_tok_nextstr error\n");
	}

	printf("socket_recv: sockfd=%d \n", sockfd);

	len = recv(sockfd, pdata, sizeof(pdata), 0);
	if(len > 0){
		printf("recv sucess, data=%s, len=%d \n", pdata, len);
	}else if(len == 0){
		printf("client is close! \n");
	}else{
		printf("recv failed, error: %s(errno: %d) \n", strerror(errno), errno);
	}
	return 0;
}

static int socket_recvfrom(char *data, int data_len)
{
	int sockfd = -1;
	char pdata[2048] = {0};
	struct sockaddr_un other_addr = {0};
	int len = 0;
	if (at_tok_start(&data) < 0) {
		printf("socket_recvfrom:at_tok_start error\n");
	}
	
	if(at_tok_nextint(&data, &sockfd) < 0) {
		printf("socket_recvfrom:at_tok_nextstr error\n");
	}

	printf("socket_recvfrom: sockfd=%d \n", sockfd);

	len = recvfrom(sockfd, pdata, sizeof(pdata)-1, 0, (struct sockaddr*)&other_addr, sizeof(other_addr));
	if(len > 0){
		printf("recvfrom sucess:  other_addr.sun_path=%s\n", other_addr.sun_path);
		printf("data=%s, len=%d\n", pdata, len);
	}else if(len == 0){
		printf("client is close! \n");
	}else{
		printf("recvfrom failed, error: %s(errno: %d) \n", strerror(errno), errno);
	}
	return 0;
}

static int socket_read(char *data, int data_len)
{
	int sockfd = -1;
	char pdata[2048] = {0};	
	int len = 0;
	if (at_tok_start(&data) < 0) {
		printf("socket_read:at_tok_start error\n");
	}
	
	if(at_tok_nextint(&data, &sockfd) < 0) {
		printf("socket_read:at_tok_nextstr error\n");
	}

	printf("socket_read: sockfd=%d \n", sockfd);

	len = read(sockfd, pdata, sizeof(pdata));
	if(len > 0){
		printf("read sucess, data=%s, len=%d \n", pdata, len);
	}else if(len == 0){
		printf("client is close! \n");
	}else{
		printf("read failed, error: %s(errno: %d) \n", strerror(errno), errno);
	}
	return 0;
}

static int socket_close(char *data, int data_len)
{
	int sockfd = -1;
	
	if (at_tok_start(&data) < 0) {
		printf("socket_close:at_tok_start error\n");
	}
	
	if(at_tok_nextint(&data, &sockfd) < 0) {
		printf("socket_close:at_tok_nextint error\n");
	}

	printf("socket_close: sockfd=%d \n", sockfd);
	
	if(close(sockfd) == 0){
		printf("رsocketɹ \n");
	}else{
		printf("رsocketʧ \n");
	}
	return 0;
}


static void socket_cmd_proc(char *cmdstr)
{	
	char *data = cmdstr;
	int data_len = strlen(data) - 1;/* -strlen("\r")*/	
	char request = data[0];

	cmdstr[data_len] = '\0';
	printf("socket_cmd_proc data=%s \n", data);
	if(0 == strncmp(data, SOCKET_CREATECLIENT, strlen(SOCKET_CREATECLIENT))) {
		printf("Request create client socket.\n");
		socket_create_client(data, data_len);
	}else if(0 == strncmp(data, SOCKET_CREATESERVER, strlen(SOCKET_CREATESERVER))) {
		printf("Request create server socket.\n");
		socket_create_server(data, data_len);
	}else if(0 == strncmp(data, SOCKET_CREATE, strlen(SOCKET_CREATE))) {
		printf("Request create socket.\n");
		socket_create(data, data_len);
	}else if(0 == strncmp(data, SOCKET_BIND, strlen(SOCKET_BIND))) {
		printf("Request bind socket.\n");
		socket_bind(data, data_len);
	}else if(0 == strncmp(data, SOCKET_LISTEN, strlen(SOCKET_LISTEN))) {
		printf("Request listen socket.\n");
		socket_listen(data, data_len);
	}else if(0 == strncmp(data, SOCKET_ACCEPT, strlen(SOCKET_ACCEPT))) {
		printf("Request accept socket.\n");
		socket_accept(data, data_len);
	}else if(0 == strncmp(data, SOCKET_CONN, strlen(SOCKET_CONN))) {
		printf("Request connect socket.\n");
		socket_connect(data, data_len);
	}else if(0 == strncmp(data, SOCKET_SENDTO, strlen(SOCKET_SENDTO))) {
		printf("Request sendto message.\n");
		socket_sendto(data, data_len);
	}else if(0 == strncmp(data, SOCKET_SEND, strlen(SOCKET_SEND))) {
		printf("Request send message.\n");
		socket_send(data, data_len);
	}else if(0 == strncmp(data, SOCKET_WRITE, strlen(SOCKET_WRITE))) {
		printf("Request write message.\n");
		socket_write(data, data_len);
	}else if(0 == strncmp(data, SOCKET_RECVFROM, strlen(SOCKET_RECVFROM))) {
		printf("Request recvfrom message.\n");
		socket_recvfrom(data, data_len);
	}else if(0 == strncmp(data, SOCKET_RECV, strlen(SOCKET_RECV))) {
		printf("Request recv message.\n");
		socket_recv(data, data_len);
	}else if(0 == strncmp(data, SOCKET_READ, strlen(SOCKET_READ))) {
		printf("Request read message.\n");
		socket_read(data, data_len);
	}else if(0 == strncmp(data, SOCKET_CLOSE, strlen(SOCKET_CLOSE))) {
		printf("Request close socket.\n");
		socket_close(data, data_len);
	}else if(0 == strncmp(data, SOCKET_LOCALTEST, strlen(SOCKET_LOCALTEST))){
		printf("Request local test.\n");
		socket_test_local();
	}else {
		printf("Request unknow.\n");
		printUsage(cmdstr);
	}
}
int main(int argc, char *argv[])
{
	char cmdstr[SOCKET_CMD_MAX_LEN] = {0};		
	
	printf("socket_ipc:Demo go.\n");
	if(parseOpts(argc,argv) == -1) {
		printf("socket_ipc:Arg error.\n");
		return -1;
	}
	
	while(1) {
		memset(cmdstr,0,SOCKET_CMD_MAX_LEN);
		
		printf("Please input an socket command:\n");
	
		if(NULL != fgets(cmdstr,SOCKET_CMD_MAX_LEN - 1,stdin)) {			
			if(0 == strcmp(EXIT_CMD_STOP,cmdstr) || 
				0 == strcmp(EXIT_CMD_Q,cmdstr) || 
				0 == strcmp(EXIT_CMD_EXIT,cmdstr)) {
				if(g_sockfd != -1){
					if(close(g_sockfd) == 0){
						printf("close g_sockfd=%d sucess \n", g_sockfd);
					}else{
						printf("close g_sockfd=%d failed \n", g_sockfd);
					}
				}
				break;
			}
			
			printf("cmdstr:%d %s\n",strlen(cmdstr),cmdstr);
			if(1 >= strlen(cmdstr)) {
				continue;
			}
			
			socket_cmd_proc(cmdstr);			
		}
	}
	
	printf("socket_ipc:Demo end.\n");
	return 0;
}

