
/************************************************************************
*ܽܣat_ctl͵绰ص¼ʵֺӿ
*ˣ
*޸գ
*޸ݣ
*汾ţ
************************************************************************/

#include "ps_pb_api.h"

#include "at_context.h"
#include "cfg_nv_def.h"
#include "at_com.h"
#include "softap_api.h"


#define ZAT_TAB_REPLACE                     ((unsigned char )(0xFC))    /* Ʊ滻     */
#define ZAT_NULL_FILL                       ((unsigned char )(0xFD))    /* մռλ       */
#define ZAT_SPACE_REPLACE                   ((unsigned char )(0xFE))    /* ո滻       */
#define ZAT_LF_REPLACE                      ((unsigned char )(0xFB))    /* LF滻         */
#define ZAT_CR_REPLACE                      ((unsigned char )(0xFA))    /* CR滻         */

/*Ԥ*/
VOID string_preprocess(char *pParaLine, int paraSize)
{
    long  flg                                     = 0;
    UINT32  i                                       = 0;
    UINT32  length                                  = 0;
    char    *pSource                                = pParaLine;
    char    *pDest                                  = NULL;
    
    if(pParaLine == NULL){
		softap_assert("");
		return;
	}
    char    *pStrDestMalloc = (char *)malloc(AT_CMD_MAX);
    if(NULL == pStrDestMalloc)
    {
        return;
    }
    memset(pStrDestMalloc, 0, AT_CMD_MAX); 
    
    pDest = pStrDestMalloc;
    length = strlen(pParaLine);
    if ((length == 0) || (length >= AT_CMD_MAX))
    {
        free(pStrDestMalloc);
        return;
    }
    for (i = 0; (i < length )&& (pDest - pStrDestMalloc < AT_CMD_MAX); i++)
    {
        if ('"' == *pSource)
        {
            flg = (0 == flg)?1:0;                           /* ˫ ɾ  */
            if ('"' == *(pSource + 1))                      /* ǺźǺţմռλ */
            {
                *pDest++ = (char)ZAT_NULL_FILL;
            }
        }
        else if ((',' == *pSource) && (0 == flg))
        {
            *pDest++ = ' ';                                 /* ˫Ķţ滻ɿո */
            if(',' == *(pSource + 1))                       /* źţԶŽβմռλ */
            {
                *pDest++ = '9';                             //9ʱ
            }
            else if('\0' == *(pSource + 1))                 /* źţԶŽβմռλ */
            {
                *pDest++ = (char)ZAT_NULL_FILL;
            }
        }
        else
        {
            if((' ' == *pSource) && (1 == flg))
			{
				*pDest++ = (char)ZAT_SPACE_REPLACE;
			}
			else if(('\t' == *pSource) && (1 == flg))
			{
				*pDest++ = (char)ZAT_TAB_REPLACE;
			}
			else if(('\n' == *pSource) && (1 == flg))
			{
				*pDest++ = (char)ZAT_LF_REPLACE;
			}
			else if(('\r' == *pSource) && (1 == flg))
			{
				*pDest++ = (char)ZAT_CR_REPLACE;
			}
			else
			{
				*pDest++ = *pSource;
			}
        }
        pSource++;
    }
    memset(pParaLine, 0, paraSize);                           /* Ԥݿز */
    strncpy(pParaLine, pStrDestMalloc,paraSize-1);
    free(pStrDestMalloc);
}

/*ָԤ*/
VOID string_restore(CHAR *pStringPara)
{
    long  i           = 0;
    long  length      = 0;
    char*   pstrTemp    = 0;
    /*   ȼ*/
    if(pStringPara == NULL){
		softap_assert("");
        return;
	}
	
    length = (long)strlen(pStringPara);
	if ( 0 == length)
    {
        return;
    }
	
    /* մռλָ */
    if ((1 == length) && ((CHAR) ZAT_NULL_FILL == *pStringPara))
    {
        *pStringPara = '\0';
        return;
    }
    /* ѭָո滻Ʊ滻 */
    pstrTemp = pStringPara;
    for (i = 0; i < length; i++)
    {
        if ((char) ZAT_SPACE_REPLACE == *pstrTemp)
        {
            *pstrTemp = ' ';
        }
        else if ((char) ZAT_TAB_REPLACE == *pstrTemp)
        {
            *pstrTemp = '\t';
        }
        else if((char) ZAT_LF_REPLACE == *pstrTemp)
        {
            *pstrTemp = '\n';
        }
        else if((char) ZAT_CR_REPLACE == *pstrTemp)
        {
            *pstrTemp = '\r';
        }
        else
        {
            ;
        }
        pstrTemp++;
    }
}

char* atPb_SendScpbrReq(void *param,  struct at_context *context)//ȡpbһ
{
	char *pAtcmdStr  = NULL;
	MSG_BUF *msgbuf = (MSG_BUF *)param;
	T_zPb_ScpbrReadRes *scpbrReadInfo = (T_zPb_ScpbrReadRes *)msgbuf->aucDataBuf;

	pAtcmdStr = malloc(30);
    if(pAtcmdStr == NULL){
		return NULL;
	}
	memset(pAtcmdStr, 0, 30);
	
	snprintf(pAtcmdStr, 30, "AT^SCPBR=%d,%d\r\n", scpbrReadInfo->minIndex, scpbrReadInfo->maxIndex);
	at_print(AT_DEBUG,"corem atPb_SendScpbrReq: %s\n", pAtcmdStr);
	return pAtcmdStr;
}   

int atPb_RecvScpbrErr(char *at_str,struct at_context *context,void **next_req, int *next_len)
{
	T_zPb_optRsp* optRsp = NULL;
	
	optRsp = malloc(sizeof(T_zPb_optRsp));
    if(optRsp == NULL){
		softap_assert("");
		return AT_END;
	}
	memset(optRsp, 0 , sizeof(T_zPb_optRsp));
    //cme error:22ʾûжݣ¼
    if(strcmp(at_str,"22")==0)
    {
        optRsp->result = 1;
    }
    else
    {
	    optRsp->result = -1;
    }
	*next_req = optRsp;
	*next_len = sizeof(T_zPb_optRsp);
	at_print(AT_DEBUG,"corem atPb_RecvScpbrErr %s\n",at_str);
	return AT_END;
}

static VOID atPb_ScpbwEncodeNum(CHAR *pbNum, CHAR *atcmdMsg)
{
    int  numType = 0;
    CHAR    strtmp[512]= {0};

    if(strlen(pbNum) == 0)
    {
        strcat(atcmdMsg,",\"\",");
    }
    else
    {
        /*ǰ"+"Ϊʺ룬145Ϊں룬129*/
        numType = strncmp(pbNum, "+", 1)? 129: 145;
        (VOID)snprintf(strtmp, 512,",\"%s\",%d", pbNum, numType);
        strcat(atcmdMsg, strtmp);
    }
}

char* atPb_SendScpbwReq(void *param,  struct at_context *context)//ӻ޸pb
{
	char *atcmdMsg  = NULL;
	char texttmp[ZPB_TEXT_SIZE_BYTES]      = {0};
    char emailtmp[ZPB_TEXT_SIZE_BYTES]    = {0};

	MSG_BUF *msgbuf = (MSG_BUF *)param;
	T_zPb_ScpbwParam *pbRecord = (T_zPb_ScpbwParam *)msgbuf->aucDataBuf;

	atcmdMsg = malloc(ZPB_TEXT_SIZE_BYTES + ZPB_TEXT_SIZE_BYTES + 4*ZPB_NUM_SIZE + 50);
	if(atcmdMsg == NULL)
		return NULL;
	memset(atcmdMsg, 0, ZPB_TEXT_SIZE_BYTES + ZPB_TEXT_SIZE_BYTES + 4*ZPB_NUM_SIZE + 50);
	
	snprintf(atcmdMsg, 20, "AT^SCPBW=%d", pbRecord->pbIndex);

    /*һΪգ129*/
    if(strlen(pbRecord->mobilNumber) == 0)
    {
        strcat(atcmdMsg,",\"\",129");
    }
    else
    {
        atPb_ScpbwEncodeNum(pbRecord->mobilNumber,atcmdMsg);
    }

    /*ΪգҲΪ*/
    atPb_ScpbwEncodeNum(pbRecord->officeNumber,atcmdMsg);
    atPb_ScpbwEncodeNum(pbRecord->homeNumber,atcmdMsg);
    atPb_ScpbwEncodeNum(pbRecord->faxNumber,atcmdMsg);

    /*Ĭweb·趼ucs2ucs2д*/
    snprintf(texttmp,ZPB_TEXT_SIZE_BYTES,",\"%s\",%d",pbRecord->name, pbRecord->coding);
    strcat(atcmdMsg, texttmp);

    /*emailΪATtextıͽ*/
    if(strlen(pbRecord->email) != 0)
    {
        snprintf(emailtmp,ZPB_TEXT_SIZE_BYTES, ",\"%s\"",pbRecord->email);
        strcat(atcmdMsg, emailtmp);
    }
	strcat(atcmdMsg, "\r\n");
	at_print(AT_DEBUG,"corem atPb_SendScpbwDelReq: %s\n", atcmdMsg);
	return atcmdMsg;
} 
  
char* atPb_SendScpbwDelReq(void *param,  struct at_context *context)//ɾһpb
{
	char *pAtcmdStr  = NULL;
	MSG_BUF *msgbuf = (MSG_BUF *)param;
	int *scpbwDelReqIndex = (int *)msgbuf->aucDataBuf;

	pAtcmdStr = malloc(30);
	if(pAtcmdStr == NULL)
		return NULL;
	memset(pAtcmdStr, 0, 30);
	
	snprintf(pAtcmdStr, 30,"AT^SCPBW=%d\r\n", *scpbwDelReqIndex);
	at_print(AT_DEBUG,"corem atPb_SendScpbwDelReq: %s\n", pAtcmdStr);
	return pAtcmdStr;
}  

char* atPb_SendCpbsReq(void *param,  struct at_context *context)
{
	char *pAtcmdStr  = NULL;
	//ڶʱʱ治ɾʱյpbʼϢɾʱ
#if (APP_OS_TYPE == APP_OS_LINUX)	
	sc_timer_delete(PbsmsInitTimerID);
#elif (APP_OS_TYPE == APP_OS_TOS)	
	zOss_StopTimer(PbsmsInitTimerID);
#endif
	pAtcmdStr = malloc(30);
	if(pAtcmdStr == NULL)
		return NULL;
	memset(pAtcmdStr, 0, 30);
	
    snprintf(pAtcmdStr, 30,"AT+CPBS=\"SM\"\r\n");
	at_print(AT_DEBUG,"corem atPb_SendCpbsReq: %s\n", pAtcmdStr);
	return pAtcmdStr;
}

int atPb_RecvCpbsOk(char *at_str,struct at_context *context,void **next_req,int *next_len)
{
	char   *pAtcmdStr  = NULL;

	pAtcmdStr = malloc(30);
	if(pAtcmdStr == NULL)
		return AT_END;
	memset(pAtcmdStr, 0, 30);

	strncpy(pAtcmdStr,"AT+CPBS?\r\n",30-1);

	*next_req = pAtcmdStr;
	*next_len = strlen(pAtcmdStr);	
	
	return AT_CONTINUE;    
}

int atPb_RecvCpbsQueryOk(char *at_str,struct at_context *context,void **next_req,int *next_len)
{
	char   *pAtcmdStr  = NULL;

	pAtcmdStr = malloc(30);
	if(pAtcmdStr == NULL)
		return AT_END;
	memset(pAtcmdStr, 0, 30);

	strncpy(pAtcmdStr,"AT^SCPBR=?\r\n",30-1);

	*next_req = pAtcmdStr;
	*next_len = strlen(pAtcmdStr);	
	
	return AT_CONTINUE;    
}

int atPb_RecvOk(char *at_str,struct at_context *context,void **next_req,int *next_len)//ظok
{
	T_zPb_optRsp* optRsp = NULL;

	optRsp = malloc(sizeof(T_zPb_optRsp));
	if(optRsp == NULL){
		softap_assert("");
		return AT_END;
	}
	memset(optRsp, 0 , sizeof(T_zPb_optRsp));
	optRsp->result = 1;
	*next_req = optRsp;
	*next_len = sizeof(T_zPb_optRsp);
	at_print(AT_DEBUG,"corem atPb_RecvOk receive ok\n");
	return AT_END;
}


int atPb_RecvErr(char *at_str,struct at_context *context,void **next_req, int *next_len)
{
	T_zPb_optRsp* optRsp = NULL;
	
	optRsp = malloc(sizeof(T_zPb_optRsp));
	if(optRsp == NULL){
		softap_assert("");
		return AT_END;
	}
	memset(optRsp, 0 , sizeof(T_zPb_optRsp));
	optRsp->result = -1;
	*next_req = optRsp;
	*next_len = sizeof(T_zPb_optRsp);
	at_print(AT_DEBUG,"corem atPb_RecvErr %s\n",at_str);
	return AT_END;
}

int atPb_RecvCpbsRsp(char *at_str ,int is_query_report)
{
	T_zPb_AtCpbsReadRes*  cpbsInd = NULL;
	at_print(AT_DEBUG, "---atPb_RecvCpbsRsp str: %s!! \n", at_str);
	cpbsInd = malloc(sizeof(T_zPb_AtCpbsReadRes));
    if(cpbsInd == NULL){
		softap_assert("");
		return AT_END;
	}
	memset(cpbsInd, 0, sizeof(T_zPb_AtCpbsReadRes));
	
    void *p[3] = {cpbsInd->locType,&cpbsInd->usedEntries,&cpbsInd->totalEntries};
    at_print(AT_DEBUG,"atPb_RecvCpbsRsp at_paras=%s!\n",at_str);
    parse_param2("%s,%d,%d", at_str, p);
    at_print(AT_DEBUG,"atPb_RecvCpbsRsp locType=%s,usedEntries=%d,totalEntries=%d!\n",
    cpbsInd->locType,cpbsInd->usedEntries,cpbsInd->totalEntries);  

    ipc_send_message(MODULE_ID_AT_CTL, MODULE_ID_PB, MSG_CMD_CPBS_IND, sizeof(T_zPb_AtCpbsReadRes), (unsigned char *)cpbsInd,0);
    free(cpbsInd);
	return AT_CONTINUE;
}

int atPb_RecvScpbsRsp(char *at_str ,int is_query_report)
{  
    struct at_context *context = (struct at_context *)is_query_report;
    
    
    if(context == NULL)
        return AT_END;   
    
    
    if(0 == at_strncmp(context->at_cmd_prefix, "SCPBR=?", MAXSTR(context->at_cmd_prefix,strlen("SCPBR=?"))))
    {
        T_zPb_AtScpbrTestRes*  scpbsInd = NULL;	
        at_print(AT_DEBUG, "---atPb_RecvScpbsRsp str: %s!! \n", at_str);
        scpbsInd = malloc(sizeof(T_zPb_AtScpbrTestRes));
        if(scpbsInd == NULL){
			softap_assert("");
			return AT_END;	 
		}
        memset(scpbsInd, 0, sizeof(T_zPb_AtScpbrTestRes));
        sscanf(at_str,
               "(%d-%d),%d,%d,%d",
               &scpbsInd->minIndex,
               &scpbsInd->maxIndex,
               &scpbsInd->maxNumberLen,
               &scpbsInd->maxTextLen,
               &scpbsInd->maxEmailLen);
        at_print(AT_DEBUG, "---atPb_RecvScpbsRsp\n");
        at_print(AT_DEBUG, "---minIndex:%d, maxIndex:%d, maxNumLen:%d, txtLen:%d, emailLen:%d\n",
                 scpbsInd->minIndex,
                 scpbsInd->maxIndex,
                 scpbsInd->maxNumberLen,
                 scpbsInd->maxTextLen,
                 scpbsInd->maxEmailLen);
        
        ipc_send_message(MODULE_ID_AT_CTL, MODULE_ID_PB, MSG_CMD_SCPBR_IND, sizeof(T_zPb_AtScpbrTestRes), (unsigned char *)scpbsInd,0);
        free(scpbsInd);
        return AT_END;
    }
    else if(0 == at_strncmp(context->at_cmd_prefix, "SCPBR=", MAXSTR(context->at_cmd_prefix,strlen("SCPBR="))))
    {
        
        
        T_zPb_ScpbrSetRes *atRes = NULL;
        
        atRes = malloc(sizeof(T_zPb_ScpbrSetRes));
        if(atRes == NULL){
			softap_assert("");
			return AT_END;
		}
        memset(atRes, 0, sizeof(T_zPb_ScpbrSetRes));
#if 0		
		void *p[12] = {&atRes->index,atRes->number1,&atRes->num1Type,
               atRes->number2,&atRes->num2Type,atRes->number3,
               &atRes->num3Type,atRes->number4,&atRes->num4Type,
               atRes->text,&atRes->coding,atRes->email};
	    at_print(AT_DEBUG,"atPb_RecvScpbsRsp at_paras=%s!\n",at_str);
	    parse_param2("%d,%s,%d,%s,%d,%s,%d,%s,%d,%s,%d,%s", at_str, p);
	    at_print(AT_DEBUG,"atPb_RecvScpbsRsp index=%d,number1=%s,num1Type=%d,number2=%s,\
			num2Type=%d,number3=%s,num3Type=%d,number4=%s,num4Type=%d,text=%s,coding=%d,email=%s!\n",
	    	atRes->index,atRes->number1,atRes->num1Type,
               atRes->number2,atRes->num2Type,atRes->number3,
               atRes->num3Type,atRes->number4,atRes->num4Type,
               atRes->text,atRes->coding,atRes->email);  
#endif
        at_print(AT_DEBUG, "---atPb_RecvScpbsRsp readpb0:%s\n",at_str);	
        string_preprocess(at_str, strlen(at_str));
        at_print(AT_DEBUG, "---atPb_RecvScpbsRsp readpb1:%s\n",at_str);	    
        sscanf(at_str, "%u %41s %d %41s %d %41s %d %41s %d %181s %d %181s",
               &atRes->index,
               atRes->number1,(int *)&atRes->num1Type,
               atRes->number2,(int *)&atRes->num2Type,
               atRes->number3,(int *)&atRes->num3Type,
               atRes->number4,(int *)&atRes->num4Type,
               atRes->text,(int *)&atRes->coding,
               atRes->email);//int->char?
        
        string_restore(atRes->number1);
        string_restore(atRes->number2);
        string_restore(atRes->number3);
        string_restore(atRes->number4);
        string_restore(atRes->text);
        string_restore(atRes->email);
        at_print(AT_DEBUG, "---atPb_RecvScpbsRsp readpb\n");
        at_print(AT_DEBUG, "---number1:%s, num1Type:%d, number2:%s, num2Type:%d,\
                 number3:%s, num3Type:%d, number4:%s, num4Type:%d,\
                 index:%d, text:%s, codeding%d, email:%s\n",
                 atRes->number1, atRes->num1Type, atRes->number2, atRes->num2Type,
                 atRes->number3, atRes->num3Type, atRes->number4, atRes->num4Type,
                 atRes->index, atRes->text, atRes->coding, atRes->email);
        

        ipc_send_message(MODULE_ID_AT_CTL, MODULE_ID_PB, MSG_CMD_SCPBR_READ_IND, sizeof(T_zPb_ScpbrSetRes), (unsigned char *)atRes,0);
        free(atRes);
        return AT_END;
        
    }
    return AT_END;
    
}

