/**
 * @file at_context.c
 * @brief at_ctlڲϢݣ漰ͻ˺תĵĳʼ
 *        롢ͷŵ
 *
 * Copyright (C) 2017 Sanechips Technology Co., Ltd.
 * @author 
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation. 
 *
 */

/*******************************************************************************
 *                           Include header files                              *
 ******************************************************************************/
#include "at_context.h"
#include "at_register.h"
#include "at_msg.h"
#include "softap_api.h"
#include "at_netdog.h"
#if (APP_OS_TYPE == APP_OS_TOS)
#include "drvs_comm.h"
#endif
#if (APP_OS_TYPE == APP_OS_LINUX)
#include "include/linux/rpmsg_zx29.h"
#include <termios.h>        //termios, tcgetattr(), tcsetattr()
#include <limits.h>
#endif
#include <sys/syscall.h>

/*******************************************************************************
 *                             Macro definitions                               *
 ******************************************************************************/
/*******************************************************************************
 *                             Type definitions                                *
 ******************************************************************************/
/*******************************************************************************
 *                        Local function declarations                          *
 ******************************************************************************/
static void channel_config(int fd);
#ifdef USE_CAP_SUPPORT
static void cap_at_chn_init(void);
#endif
static void volte_at_channel_init();
static void linux_at_channel_init();
static void tos_at_channel_init();
static int context_del_at_context(struct at_context * node);
static struct at_channel_info *context_get_free_chninfo_node(int position,int context_type);
extern int add_one_cache_msg(MSG_BUF *msg);

/*******************************************************************************
 *                         Local variable definitions                          *
 ******************************************************************************/


/*******************************************************************************
 *                        Global variable definitions                          *
 ******************************************************************************/
extern int g_auto_fd;
//ʼʱȷĸý鿿psĸýԶps

extern int g_ppp_ttyfd;		//pppӦtty豸

extern int g_farps_select_timeout;

//atͨģIDһһӦcontextĸ
struct at_channel_info  *at_channel_head[POSITION_MAX] = { 0 };

//at¼ĳchannelжһ
struct at_context *context_head[POSITION_MAX] =  { 0 };

extern void cache_msg_proc(void);

/* 翪£Ҫ˼ͨѶat_ctlҪʼͨģʽЭջʼ
NEAR_PSܴͨ */
T_ZDrvSys_PowerOn_Type g_powerOnType;

int g_write_failed_flag = 0;
/*******************************************************************************
 *                      Local function implementations                         *
 ******************************************************************************/
static void channel_config(int fd)
{
#if (APP_OS_TYPE == APP_OS_LINUX)
    //ioctl(fd, (('R'<<8)|1|(0x4004<<16)), 0x800);
    //ioctl(fd, (('R'<<8)|4|(0x4004<<16)), 0);
    //PortSet(fd, &g_sPortInfo); 
    if(ioctl(fd, RPMSG_CREATE_CHANNEL, AT_CHAN_MAX_BUF_LEN) < 0) // cov M CHECKED_RETURN
    {
        // todo:
    }
	// Ϣʱж
	if(ioctl(fd, RPMSG_SET_INT_FLAG, NULL) < 0) // cov M CHECKED_RETURN
	{
	    // todo:
	}

	 // ķʽ
	if(ioctl(fd, RPMSG_CLEAR_POLL_FLAG, NULL) < 0) // cov M CHECKED_RETURN
	{
	    // todo:
	}
#endif
}

static void turnon_echo_by_fd(int fd)
{
	if(fd >=0 ){
		struct termios termios_old;
		bzero(&termios_old, sizeof(termios_old));
		tcgetattr(fd, &termios_old); 	//get the serial port attributions
		termios_old.c_lflag |= ECHO;	//ģʽû
		tcflush(fd, TCIFLUSH);			//ݿԽ,
		tcsetattr(fd, TCSANOW, &termios_old);	//, TCSANOW: ɸıЧ
	}
}

static void turnoff_echo_by_fd(int fd)
{
	if(fd >=0 ){
		struct termios termios_old;
		bzero(&termios_old, sizeof(termios_old));
		tcgetattr(fd, &termios_old); 	//get the serial port attributions
		termios_old.c_lflag &= ~ECHO;	//ģʽرջ
		tcflush(fd, TCIFLUSH);			//ݿԽ,
		tcsetattr(fd, TCSANOW, &termios_old);	//, TCSANOW: ɸıЧ
	}
}

#ifdef USE_CAP_SUPPORT
static void cap_at_chn_init(void)
{
	#define CAP_FD_MAX 6
	int i;
	int CHL_CAP[CAP_FD_MAX] = {34,35,36,37,38,39};
	int fd = -1;
	char ch_name[16] = {0};

	for(i=0;i<CAP_FD_MAX;i++)
    {
        sprintf(ch_name, "/dev/rpmsg%d",CHL_CAP[i]);
        fd = at_open(ch_name,O_RDWR);
        if(fd < 0) {
        	at_print(AT_ERR,"ERR: cap_at_chn_init at_open %s error\n",ch_name);
			continue;
        }
        channel_config(fd);
        if(at_cap_set_state_proc(ch_name,1,fd) != 0){
			at_close(fd);
			at_print(AT_ERR,"ERR: cap_at_chn_init at_portmng_set_state_proc error\n");
		}
		at_print(AT_NORMAL,"cap_at_chn_init success!ch_name %s fd %d\n",ch_name, fd);
	}
}

#define USB_PORT_MAX 2
#define PROT_NAME_SIZE_MAX 16
extern int at_sys_write(int fd,char *buf,int len);
struct cap_usb_proxy_info
{
	char usb_name[PROT_NAME_SIZE_MAX];
	char rpm_name[PROT_NAME_SIZE_MAX];
	int usbtocap_pid;
	int usb_fd;
	int captoap_pid;
	int rpm_fd;
};
struct cap_usb_proxy_info g_cap_usb_proxy[USB_PORT_MAX];

static void usbtocap_mainloop(void *param)
{
	int i = (int)param;
	int ret, datalen;
	char buf[AT_CHAN_MAX_BUF_LEN];
	int rfd = -1;
	int wfd = -1;
	struct cap_usb_proxy_info *proxy = &g_cap_usb_proxy[i];
	fd_set readfds;
	struct timeval timeout;

	prctl(PR_SET_NAME, "usbtocap", 0, 0, 0);
	wfd = proxy->rpm_fd;
	proxy->usbtocap_pid = syscall(SYS_gettid);
	
	while(i < USB_PORT_MAX){
		rfd = proxy->usb_fd;
		FD_ZERO(&readfds);
		FD_SET(rfd, &readfds);
		timeout.tv_sec = 0;
		timeout.tv_usec = g_farps_select_timeout*1000;
		ret = at_select(rfd + 1, &readfds, NULL, NULL, &timeout);
		if (ret <= 0){
			if(ret < 0 && errno != EINTR){
				at_print(AT_ERR,"select usbtocap_read%d faild, errno = %d\n", i, errno);
				usleep(100000);//ֹεUSB쳣ˢ
			}
			continue;
		}
		datalen = at_read(rfd, buf, sizeof(buf));
		if(datalen <= 0){
			if(errno != EINTR){
				at_print(AT_ERR,"usbtocap_read from %d failed, len:%d, errno:%d\n", rfd, datalen, errno);
				sleep(1);//ֹεUSB쳣readʧѭ
			}
			continue;
		}
		ret = at_sys_write(wfd, buf, datalen);
		if(ret <= 0){
			at_print(AT_ERR,"usbtocap_write from %d failed, len:%d, ret:%d\n", wfd, datalen, ret);
			continue;
		}
	}
	at_print(AT_ERR,"ERR: usbtocap i=%d err\n",i);
}

static void captoap_mainloop(void *param)
{
	int i = (int)param;
	int ret, datalen;
	char buf[AT_CHAN_MAX_BUF_LEN];
	int rfd = -1;
	int wfd = -1;
	struct cap_usb_proxy_info *proxy = &g_cap_usb_proxy[i];
	
	prctl(PR_SET_NAME, "captoap", 0, 0, 0);
	rfd = proxy->rpm_fd;
	proxy->captoap_pid = syscall(SYS_gettid);
	while(i < USB_PORT_MAX){
		datalen = at_read(rfd, buf, sizeof(buf));
		if(datalen <= 0){
			at_print(AT_ERR,"captoap_read from %d failed, len:%d, errno:%d\n", rfd, datalen, errno);
			continue;
		}
		wfd = proxy->usb_fd;
		if(at_strstr(buf, "ATE0\r\n\r\nOK\r\n")){
			turnoff_echo_by_fd(wfd);
			at_sys_write(wfd, "\r\nOK\r\n", strlen("\r\nOK\r\n"));
			continue;
		}
		if(at_strstr(buf, "ATE1\r\n\r\nOK\r\n")){
			turnon_echo_by_fd(wfd);
			at_sys_write(wfd, "\r\nOK\r\n", strlen("\r\nOK\r\n"));
			continue;
		}
		ret = at_sys_write(wfd, buf, datalen);
		if(ret <= 0){
			at_print(AT_ERR,"captoap_write from %d failed, len:%d, ret:%d\n", wfd, datalen, ret);
			continue;
		}
	}
	at_print(AT_ERR,"ERR: captoap i=%d err\n",i);
}

static void cap_usb_proxy_init(unsigned int i)
{
	if(i < USB_PORT_MAX){
		pthread_t recv_thread_tid0;
		pthread_t recv_thread_tid1;

		g_cap_usb_proxy[i].rpm_fd = at_open(g_cap_usb_proxy[i].rpm_name,O_RDWR);
		if(g_cap_usb_proxy[i].rpm_fd < 0) {
			at_print(AT_ERR,"ERR: captoap at_open %s err%d\n",g_cap_usb_proxy[i].rpm_name, errno);
			return;
		}
		channel_config(g_cap_usb_proxy[i].rpm_fd);
		g_cap_usb_proxy[i].usb_fd = at_open(g_cap_usb_proxy[i].usb_name,O_RDWR);
		if(g_cap_usb_proxy[i].usb_fd < 0) {
			at_print(AT_ERR,"ERR: captoap at_open %s err%d\n",g_cap_usb_proxy[i].usb_name, errno);
		}
		if (pthread_create(&recv_thread_tid0, NULL, (void *)usbtocap_mainloop, i) != 0)
			at_print(AT_ERR,"%s->cap proxyth create fail\n",g_cap_usb_proxy[i].usb_name);
		if (pthread_create(&recv_thread_tid1, NULL, (void *)captoap_mainloop, i) != 0)
			at_print(AT_ERR,"%s->ap proxyth create fail\n",g_cap_usb_proxy[i].rpm_name);
		at_print(AT_NORMAL,"cap_usb_proxy_init success!%s<->%s\n",g_cap_usb_proxy[i].usb_name, g_cap_usb_proxy[i].rpm_name);
		return;
	}
	at_print(AT_NORMAL,"cap_at_chn_init %d fail\n", i);
}

int cap_usb_hotplug(const char *name, int is_open)
{
	int i;
	
	for(i = 0; i < USB_PORT_MAX; i++){
		if(strcmp(name, g_cap_usb_proxy[i].usb_name) == 0){
			if(is_open == 0)
				return 1;
			if(g_cap_usb_proxy[i].usb_fd >= 0)
				at_close(g_cap_usb_proxy[i].usb_fd);
			g_cap_usb_proxy[i].usb_fd = at_open(g_cap_usb_proxy[i].usb_name,O_RDWR);
			if(g_cap_usb_proxy[i].usb_fd < 0) 
				at_print(AT_ERR,"ERR: cap_usb_hotplug at_open %s err%d\n",g_cap_usb_proxy[i].usb_name, errno);
			else{
				at_print(AT_NORMAL,"cap_usb_hotplug %s fd=%d\n",g_cap_usb_proxy[i].usb_name, g_cap_usb_proxy[i].usb_fd);
				if(g_cap_usb_proxy[i].usbtocap_pid > 0)
					kill(g_cap_usb_proxy[i].usbtocap_pid, SIGUSR1);
				if(g_cap_usb_proxy[i].captoap_pid > 0)
					kill(g_cap_usb_proxy[i].captoap_pid, SIGUSR1);
			}
			return 1;
		}
	}
	return 0;
}
#endif


/* ʼVOLTEͨ
   VOLTEЭջptyͨpty0at_ctlVOLTEЭջ,VOLTEЭջԭ·أ
   VOLTEЭջ򷵻ӦVOLTEЭջϱҲpty0ϱʸָͨʽյ
   pty1VOLTEЭջmodem󣬼ΪתΣat_ctlյpty1תNEAR_PSͨ
*/
static void volte_at_channel_init()
{
	struct at_channel_info* new_chan = NULL;	
	int i = 0;
#ifdef _USE_VOLTE	
	//VOLTEͨѶαͨ1, at_ctlVOLTEЭջ
	for(i = 0; i < VOLTE_PTY1_MAX; i++)
	{
		new_chan = add_new_channel(MODULE_ID_ATCTL_TO_VOLTE+i, POSITION_VOLTE); 
		if(new_chan)
		new_chan->attribution |= (1<<CH_AUTOIND);
	}
	
	//VOLTEͨѶαͨ, VOLTEЭջmodem
	for(i = 0; i < VOLTE_PTY2_MAX; i++)
	{
		new_chan = add_new_channel(MODULE_ID_VOLTE_TO_ATCTL+i, POSITION_VOLTE);
		if(new_chan){
		new_chan->reserved = 1;
		if(i != 0)
		{
			new_chan->attribution |= (1<<CH_AUTOIND);
		}
		}
	}
#endif
#if 0
	memset(volte_mainpty, -1, sizeof(volte_mainpty));
#ifdef _USE_VOLTE
    char slaveptyname[AT_PORT_NAME_LEN] = {0};
    char nvname[AT_PORT_NAME_LEN] = {0};
    struct at_channel_info* pty_node = NULL;
	struct termios tios = {0};
    int i;
    for(i = 0; i < VOLTE_PTY_MAX; i++)
    {
        //pty豸ӿ
        volte_mainpty[i] = posix_openpt(O_RDWR | O_NOCTTY);

        if(volte_mainpty[i] < 0)
        {
            at_print(AT_ERR,"ERR: open pty dev abnormal\n");
            softap_assert("");
        }
        //Ӧ÷pty豸
        if(unlockpt(volte_mainpty[i]) == -1)
        {
            at_print(AT_ERR,"ERR: unlock pty dev abnormal\n");
            softap_assert("");
        }
        //ȡ豸
        if(ptsname_r(volte_mainpty[i],slaveptyname,AT_PORT_NAME_LEN) != 0)
        {
            at_print(AT_ERR,"ERR: can not get slave devname\n");
            softap_assert("");
        }
		//豸pty豸ԣֹԺַת
		memset(&tios, 0x00, sizeof(tios));
		if (tcgetattr(volte_mainpty[i], &tios) == 0) 
		{
			tios.c_cflag &= ~(CSIZE | CSTOPB | PARENB);
			tios.c_cflag |= CS8 | CREAD | CLOCAL;
			tios.c_iflag  = IGNPAR;
			tios.c_oflag  = 0;
			tios.c_lflag  &= ~ECHO;
			if (tcsetattr(volte_mainpty[i], TCSAFLUSH, &tios) < 0)
			{
				printf("couldn't set attributes on pty");
					
				//printf( "couldn't set attributes on pty");
				return -1;
			}
				
		} 
		else
		{
			printf("couldn't get attributes on pty");
			//printf( "couldn't get attributes on pty");
			return -1;
		}
        //pty豸volteӦûȡ򿪴豸
        sprintf(nvname,"volte_slavepty%d",i);
        sc_cfg_set(nvname, slaveptyname);
        at_print(AT_DEBUG,"%s = %s\n",nvname, slaveptyname);

        pty_node = add_new_channel(volte_mainpty[i],POSITION_VOLTE);
        if(i == 1)
        {
            pty_node->reserved = 1;
        }
    }
#endif
#endif
}
int g_farps_fd0=-1;
int g_farps_fd1=-1;
int g_farps_fd2=-1;

/* ʼlinuxatͨ*/
static void linux_at_channel_init()
{
#if (APP_OS_TYPE == APP_OS_LINUX)
    int i;
    /*PSͨ,ͨps򿪵ͨһһӦڸ飬ɾı˳*/
    int CH_NEAR_PS[NEAR_PS_FD_MAX] = {3,4,5,6,7,8};//{36,37,38,39,40,41};
    char ch_name[AT_PORT_NAME_LEN] = {0};
	struct at_channel_info* node;

	/*
		豸ļ֧־fdֵ00ЧڳʼȫֱʱΪ-1
	*/
    memset(FD_FAR_PS,-1,sizeof(FD_FAR_PS));
	memset(FD_NEAR_PS,-1, sizeof(FD_NEAR_PS));

    for(i=0;i<NEAR_PS_FD_MAX;i++)
    {
        sprintf(ch_name, "/dev/rpm%d",CH_NEAR_PS[i]);
        FD_NEAR_PS[i] = at_open(ch_name,O_RDWR);
        if(FD_NEAR_PS[i] < 0)
            softap_assert("");
        channel_config(FD_NEAR_PS[i]);
        node = add_new_channel(FD_NEAR_PS[i],NEAR_PS);	
		if(node)
		node->attribution |= (1<<CH_COMM);		//APCPͨѶͨԱ־λ
    }
    //at_ctlͨϱat
    g_auto_fd = FD_NEAR_PS[0];
	{
		char timeout_nv[20] = {0};
		int timeout;
		sc_cfg_get("at_select_timeout",timeout_nv,sizeof(timeout_nv));	
		timeout = atoi(timeout_nv);
		if(timeout > 0 && timeout < INT_MAX/1000)//kw 3
			g_farps_select_timeout = timeout;
	}
	/*
		ʱΪatڵatat_ctlʼʱͽ˿ڴ򿪣ںյ˿ڴϢ
		ٴ򿪡
	*/
	char port_name[64] = {0};
	sc_cfg_get("notify_forbiden_ports",port_name,sizeof(port_name));
	
	if(strstr(port_name,"/dev/ttyS0") == NULL)
	{
		g_farps_fd0 = at_open("/dev/ttyS0",O_RDWR);	
		at_print(AT_ERR,"init open ttyS0 => fd: %d er_no: %d\n", g_farps_fd0, errno);
		if(g_farps_fd0 >= 0){
			if(at_portmng_set_state_proc("/dev/ttyS0",1,g_farps_fd0) != 0){
				at_close(g_farps_fd0);
				g_farps_fd0 = -1;
			}
		}
	}
#ifdef USE_CAP_SUPPORT
	char cap_port_name[64] = {0};
	sc_cfg_get("cap_port_name",cap_port_name,sizeof(cap_port_name));
#endif
	
	if((strstr(port_name,"/dev/ttyGS0") == NULL)
#ifdef USE_CAP_SUPPORT
		&& (strstr(cap_port_name, "/dev/ttyGS0") == NULL)
#endif
	){
		g_farps_fd1 = at_open("/dev/ttyGS0",O_RDWR);
		at_print(AT_ERR,"init open ttyGS0 => fd: %d er_no: %d\n", g_farps_fd1, errno);
		if(g_farps_fd1 >= 0){
			if(at_portmng_set_state_proc("/dev/ttyGS0",1,g_farps_fd1) != 0){
				at_close(g_farps_fd1);
				g_farps_fd1=-1;
			}
		}
	}
	if((strstr(port_name,"/dev/ttyGS1") == NULL)
#ifdef USE_CAP_SUPPORT
		&& (strstr(cap_port_name, "/dev/ttyGS1") == NULL)
#endif
	){
		g_farps_fd2 = at_open("/dev/ttyGS1",O_RDWR);
		at_print(AT_ERR,"init open ttyGS1 => fd: %d er_no: %d\n", g_farps_fd2, errno);
		if(g_farps_fd2 >= 0){
			if(at_portmng_set_state_proc("/dev/ttyGS1",1,g_farps_fd2) != 0){
				at_close(g_farps_fd2);
				g_farps_fd2=-1;
			}
		}
	}
#ifdef USE_CAP_SUPPORT
	if((strstr(port_name,"/dev/ttyGS0") == NULL) && (strstr(cap_port_name, "/dev/ttyGS0") != NULL)){
		strncpy(g_cap_usb_proxy[0].usb_name, "/dev/ttyGS0", sizeof(g_cap_usb_proxy[0].usb_name)-1);
		strncpy(g_cap_usb_proxy[0].rpm_name, "/dev/rpmsg30", sizeof(g_cap_usb_proxy[0].rpm_name)-1);
		cap_usb_proxy_init(0);
	}
	if((strstr(port_name,"/dev/ttyGS1") == NULL) && (strstr(cap_port_name, "/dev/ttyGS1") != NULL)){
		strncpy(g_cap_usb_proxy[1].usb_name, "/dev/ttyGS1", sizeof(g_cap_usb_proxy[1].usb_name)-1);
		strncpy(g_cap_usb_proxy[1].rpm_name, "/dev/rpmsg31", sizeof(g_cap_usb_proxy[1].rpm_name)-1);
		cap_usb_proxy_init(1);
	}
#endif
	{
		char echo_nv[20] = {0};
		int echo;
		sc_cfg_get("tty_echo",echo_nv,sizeof(echo_nv));	
		echo = atoi(echo_nv);
		if((echo >> 0)&1)
			turnon_echo_by_fd(g_farps_fd0);
		if((echo >> 1)&1)
			turnon_echo_by_fd(g_farps_fd1);
		if((echo >> 2)&1)
			turnon_echo_by_fd(g_farps_fd2);
	}

	
#ifdef USE_CAP_SUPPORT
	cap_at_chn_init();
#endif
#endif
}

/* ʼtosatͨ*/
static void tos_at_channel_init()
{
#if (APP_OS_TYPE == APP_OS_TOS)
    //PSͨȫ
    int CH_NEAR_PS[NEAR_PS_FD_MAX] = {1,2,3,4,5,6};
    //ԶPSͨȫ
    int CH_FAR_PS[FAR_PS_FD_MAX] = {30,31,32,33,34,35,36,37,38,39};
	struct at_channel_info* node;
    int i;
    char ch_name[AT_PORT_NAME_LEN] = {0};
	
	memset(FD_FAR_PS,-1,sizeof(FD_FAR_PS));
	memset(FD_NEAR_PS,-1, sizeof(FD_NEAR_PS));
	//翪ģʽ£ЭջУʱmodematͨ
    if(g_powerOnType != POWER_ON_CHARGING)
    {
        for(i=0;i<NEAR_PS_FD_MAX;i++)
        {
            sprintf(ch_name, "PS_%d",CH_NEAR_PS[i]);
            FD_NEAR_PS[i] = at_open(ch_name,0);
            if(FD_NEAR_PS[i] < 0)
                softap_assert("");
            add_new_channel(FD_NEAR_PS[i],NEAR_PS);
        }
    }

    //at_ctlͨϱat
    g_auto_fd = FD_NEAR_PS[0];


    for(i=0;i<FAR_PS_FD_MAX;i++)
    {

        sprintf(ch_name, "%d",CH_FAR_PS[i]);
        FD_FAR_PS[i] = at_open(ch_name,0);
        if(FD_FAR_PS[i] < 0)
            softap_assert("");
        node = add_new_channel(FD_FAR_PS[i],FAR_PS);
        node->ch_dev_name = CH_FAR_PS[i];		
        if(CH_FAR_PS[i] >= 30 && CH_FAR_PS[i] <= 35)//Ϊ˼ͨ30-35ͨⶨ
            node->reserved = 1;
		else
			node->attribution |= (1<<CH_COMM);      //APCPͨѶͨԱ־λ
    }
#endif
}


/* ɾָĽڵ*/
static int context_del_at_context(struct at_context * node)
{
    struct at_context * tmp = context_head[node->at_channel->position];
    if(tmp == NULL)
    {
        at_print(AT_ERR,"context_head is NULL");
		free(node);//kw_3
        return -1;
    }
    if(tmp == node)
    {
        context_head[node->at_channel->position] = tmp->next;
    }
    else
    {
        while(tmp && (tmp->next != node))
        {
            tmp = tmp->next;
        }
        if(tmp == NULL)
        {
            at_print(AT_ERR,"context not found");
			free(node);//kw_3
            return -1;
        }
        tmp->next = node->next;
    }	
    free(node);
    return 0;
}

/* һĽڵ㣬ӽڵ㵽Ӧλõcontext_head[position]*/
struct at_context * context_alloc_at_context(struct at_channel_info *at_channel, int type)
{
	struct at_context * tmp = NULL;
	int position = at_context_get_pos_by_fd(at_channel->at_fd);
	if(position < 0)
		return NULL;
    struct at_context * node = (struct at_context *)malloc(sizeof(struct at_context));
    if (node == NULL){
        softap_assert("context_alloc_at_context malloc fail");
		return NULL;
    }

    memset(node,0,sizeof(struct at_context));

    node->context_type= type;
    node->at_channel = at_channel;
#if (APP_OS_TYPE == APP_OS_LINUX)

    node->cur_tick = get_time_us();
#elif (APP_OS_TYPE == APP_OS_TOS)

    node->cur_tick = read_persistent_us();
#endif

	tmp = context_head[position];
	if(tmp == NULL)
		context_head[position] = node;
	else
	{
		while(tmp->next)
		{
			tmp = tmp->next;
		}
		tmp->next = node;
	}

    return node;
}

#if 0
static void at_context_abnormal_proc(int position)
{
	struct at_context * ct_node = context_head[position];
    unsigned long cur_tick = 0 ;
	unsigned long earlist_tick = 0;

#if (APP_OS_TYPE == APP_OS_LINUX)
	cur_tick = get_time_us();
#elif (APP_OS_TYPE == APP_OS_TOS)

	cur_tick = read_persistent_us();
#endif
	earlist_tick = cur_tick;
	at_print(AT_ERR,"at_context_exception_proc position=%d\n",position);

	while(ct_node != NULL)
	{
		//Կͻ˺תΣδյӦʱ
		if(AT_CLIENT == ct_node->context_type 
			|| AT_FWD_DOWN == ct_node->context_type)
		{			
			if((cur_tick - ct_node->cur_tick) < earlist_tick)
				earlist_tick = cur_tick - ct_node->cur_tick;
			at_print(AT_ERR,"at_context_alloc_exception cur_tick=%ld, ct_node->cur_tick=%ld, prefix=%s\n",
			cur_tick, ct_node->cur_tick, ct_node->at_cmd_prefix);	
		}
		
		ct_node = ct_node->next;
		
	}

	if(earlist_tick >= ATCONTEXT_ABNORMAL_TIME)
	{
		softap_assert("at_context_abnormal");
	}
}
#endif

/* ͣȡеͨڵ,תκͿͻ
   Լʵķڲat_channel_head[direct]ҵеATͨ󣬵Ǽϣ
*/
static struct at_channel_info *context_get_free_chninfo_node(int position,int context_type)
{
    struct at_channel_info* node = at_channel_head[position];
    struct at_channel_info* tmp_node = NULL;

    for(;node; node = node->next)
    {
        if((context_type == AT_CLIENT || context_type == AT_FWD_DOWN) && (node->reserved == 1))
            continue;

        //ǰnear_psתͨյatat_ctlڲɺֱӽԭʼat͸תͨ
        //AP࣬תͨCPӦͨCPĿͻռãڸתͨյat
        //ʹatֱתΣ޸ĵĿǼתͨCPӦͨatͻѡͻͨĸʣû
        //תͨյat
        //ѡûκԵatͨ
        if(!node->work_state)
        {
            node->work_state |= (1<<context_type);
            return node;
        }
        if (!(node->work_state & ((1<<AT_CLIENT)|(1<<AT_FWD_DOWN))))
        {
            if(!tmp_node)
            {
                tmp_node = node;
            }
            //node->work_state |= (1<<context_type);
            //return node;
        }
    }
    if(tmp_node)
    {
        tmp_node->work_state |= (1<<context_type);
        return tmp_node;
    }
    else
    {    	
        save_noidle_fd(position);
		//at_context_abnormal_proc(position);
        at_print(AT_ERR,"context_get_free_chninfo_node fail \n");
    }
    return NULL;
}


/*******************************************************************************
 *                      Global function implementations                        *
 ******************************************************************************/
/**
 * @brief ͨfdȡϢλposition
 * @param 
 * @return 
 * @note   
 * @warning 
 */
int at_context_get_pos_by_fd(int at_fd)
{
    int pos = 0;
    struct at_channel_info* tmp = NULL;

	/*תatԴʵatͨģIDatͨ;
	FD_FAR_PS¼ʵatͨϢָatͨ
	ʵatͨatͨselectʱá
	
	ҪȡָatͨλʱҪʹat_channel_headȷ
	*/
	for( ; pos<POSITION_MAX; pos++)
	{
		tmp = at_channel_head[pos];
		while(tmp)
		{
			if(tmp->at_fd == at_fd)
            	return pos;
        	tmp = tmp->next;
		}
	}
   
    return -1;
}

int del_channel_info(int at_fd, int position)
{
	struct at_channel_info* tmp = at_channel_head[position];
	struct at_context *context = NULL;
	struct at_channel_info* prev = tmp;
	while(tmp)
	{
		if(tmp->at_fd == at_fd)
		{
			break;
		}
		prev = tmp;
		tmp = tmp->next;
	}
	if(tmp == NULL)
	{
		at_print(AT_ERR,"del_channel_info can not find fd!!!\n");
		return -1;
	}
	if(tmp == at_channel_head[position])
	{
		at_channel_head[position] = tmp->next;
	}
	else
	{
		prev->next = tmp->next;
	}
	context = context_head[position];

    for(;context;context = context->next)
    {
    	/*ǰͨϻģеͨΪ-1ʾǰͨ
    	ѾٿãcontextͷʱٽͨϢͷ*/
        if(context->at_channel == tmp)
        {
			context->at_channel->at_fd = -1;
			return 0;
        }
    }
	free(tmp);
	return 0;
}


/*һATͨ*/
struct at_channel_info* add_new_channel(int at_fd,int position)
{
    struct at_channel_info* node = NULL;
	struct at_channel_info* tmp = at_channel_head[position];

	
	while(tmp)
	{
		if(tmp->at_fd == at_fd)
			return tmp;
		tmp = tmp->next;
	}
	
	node = (struct at_channel_info*)malloc(sizeof(struct at_channel_info));
	if(!node){
        softap_assert("add_new_channel malloc fail");
		return NULL;
	}
    memset(node, 0, sizeof(struct at_channel_info));
    //node->next = NULL;
    node->at_fd = at_fd;
    //node->work_state = 0;
    node->position = position;
    node->cmd_state = 0;
	//ʵͨ붯̬
	if(check_is_fd(at_fd)==0)
		node->reserved = 1;
	
	if(NULL == at_channel_head[position])
	{
		at_channel_head[position] = node;
	}
	else
	{
		node->next= at_channel_head[position];
		at_channel_head[position]=node;
	}

    return node;
}


/**
 * @brief ʼatͨ
 * @param 
 * @return 
 * @note   ϵͳԼʵԼĳʼ뱣֤ͳһ
 * @note   ͺŻͽ֣ܻ˫CP˫AP7100ĸֵе
 * @note   ͨľȡȫУٽκβĶ̬ʹЩ
 * @warning 
 */
void at_context_at_chn_init()
{
    linux_at_channel_init();

    volte_at_channel_init();

    tos_at_channel_init();
}

/**
 * @brief ϢpositionĽڵ㼰ͨ
 * @param 
 * @return 
 * @note   ӽڵ㵽context_head[direct]
 * @note   ATͨ׼תATķͣͿͻ˵ATֹ
 * @warning 
 */
struct	at_context  *at_context_alloc_ctx_by_pos(int position)
{
    struct at_channel_info * at_channel = NULL;

    at_channel = context_get_free_chninfo_node(position,AT_CLIENT);
    if (!at_channel)
    {
        //softap_assert("");
        return NULL;
    }
    return context_alloc_at_context(at_channel,AT_CLIENT);
}

/**
 * @brief ͨfdatͨڵϢ
 * @param 
 * @return 
 * @note   
 * @warning 
 */
struct at_channel_info * at_context_find_chn_by_fd(int  at_fd)
{
    int position = at_context_get_pos_by_fd(at_fd);
    if(position < 0)
        return NULL;

    struct at_channel_info * at_channel = at_channel_head[position];

    for(;at_channel;at_channel = at_channel->next)
    {
        if(at_channel->at_fd == at_fd)
            break;
    }

    return at_channel;
}


/* ȡָpositionָͨATͨ豸ͨϢ*/
struct at_channel_info * at_context_find_chn_by_devname(int ch_devname, int position)
{
	struct at_channel_info * at_channel = at_channel_head[position];

	for(;at_channel;at_channel = at_channel->next)
	{
		 if(at_channel->ch_dev_name == ch_devname)
			return at_channel;
	}

	return NULL;
}


/**
 * @brief fdͲ
 * @param 
 * @return 
 * @note   ڽյͨϱATĴ
 * @warning 
 */
struct at_context  * at_context_find_ctx_by_fd_type(int  at_fd,int type)
{
    struct at_context *context = NULL;
    int position = at_context_get_pos_by_fd(at_fd);
    if(position < 0)
        return NULL;
    context = context_head[position];

    for(;context;context = context->next)
    {
        if(context->at_channel->at_fd == at_fd && context->context_type == type)
            return  context;
    }

    return NULL;
}

//ͺԴģIDҵģĿǰ첽ʽķӦ
struct at_context  * at_context_find_ctx_by_moduleid(int module_id, int type)
{
    struct at_context * context = NULL;
    int i = 0;

    /* at¼*/
    for(i = 0; i < POSITION_MAX; i++)
    {
        context = context_head[i];
        for(;context;context = context->next)
        {
            if(context->context_type == type && context->source == module_id)
            {
				return  context;
            }
        }
    }
    return  NULL;
}

/**
 * @brief жǷΪͬһģ鷢һϢ
 * @param 
 * @return 
 * @note  
 * @warning 
 */
int at_context_clt_abort_handle(MSG_BUF *msg_buf)
{
    struct at_context * context = NULL;
    int i = 0;

    /* at¼*/
    for(i = 0; i < POSITION_MAX; i++)
    {
        context = context_head[i];
        for(;context;context = context->next)
        {
            if(context->context_type == AT_CLIENT && context->source==msg_buf->src_id&& context->msg_id==msg_buf->usMsgCmd && msg_buf->src_id != MODULE_ID_AT_CTL)
            {
                save_abort_client_context(context);
                at_print(AT_NORMAL,"at_context_clt_abort_handle modid=%x msgid=%x position=%d\n",context->source, context->msg_id, i);
				//softap_assert("");
				return  1;
            }
        }
    }
    return  0;
}

/**
 * @brief ͨĽڵ
 * @param 
 * @return 
 * @note   λˣռ
 * @note   ڽյATʱļͨ
 * @warning 
 */
struct	at_context * at_context_alloc_ctx_by_fd(int  at_fd,int context_type)
{
    struct at_context * context = NULL;
    struct at_channel_info * at_channel = at_context_find_chn_by_fd(at_fd);

	if(context_type != AT_FWD_UP&&context_type != AT_SERVER)
	{
		softap_assert("api only support up and server, now context_type is %d",context_type);
	}
	//atͨѾرʱchannel_infoѾͷţʱ޷ҵֱӷ
    if (!at_channel)
    {
        at_print(AT_ERR,"ERR: at_context_alloc_ctx_by_fd check err \n");
		return NULL;
    }

    if(at_channel->work_state&(1<<context_type))
    {
        at_print(AT_ERR,"ERR: work_state err ,work_state is %d, context type is %d\n",at_channel->work_state,context_type);
    }
    at_channel->work_state |= (1<<context_type);
    context = context_alloc_at_context(at_channel,context_type);
    return context;
}

/**
 * @brief Ľڵ
 * @param 
 * @return 
 * @note   ATͨ׼ڿͻ˵ATͣתATķֹͣ
 * @note   յӦͷŸ
 * @warning 
 */
struct	at_context *at_context_alloc_ctx_by_fwdctx(int position, struct at_context *fwd_context)
{
    struct at_context * context = NULL;
    struct at_channel_info * at_channel = NULL;
    //int position = 1 ^ (fwd_context->at_channel->position);
    at_channel = context_get_free_chninfo_node(position,AT_FWD_DOWN);
    if (!at_channel)
    {
        return NULL;
    }
    context = context_alloc_at_context(at_channel,AT_FWD_DOWN);

    at_channel->work_state = at_channel->work_state |(1<<AT_FWD_DOWN);
	if(context){
	    context->fwd_context = fwd_context;
	    context->at_proc= fwd_context->at_proc;
	}
    return context;

}

/**
 * @brief ͷĳ¼
 * @param 
 * @return 
 * @note   յӦϢãԼһЩ쳣
 * @warning 
 */
int  at_context_free_ctx(struct at_context *context)
{
    int ret = 0;
	struct at_channel_info *at_chann = context->at_channel;
   	int contextType = context->context_type;
		
    if(context->app_param)
        free(context->app_param);
    //նӦͨϵλͼ
    at_chann->work_state ^= (1<<context->context_type);
    at_print(AT_DEBUG,"at_context_free_ctx at_fd = %d  state = %d \n",at_chann->at_fd,at_chann->work_state);
    ret = context_del_at_context(context);
	//at_fdС0˵ǰatͨѾرգҪͨҲͷŵ
	if(at_chann->at_fd < 0)
	{
		free(at_chann);
	}

	if(contextType == AT_CLIENT || contextType == AT_FWD_DOWN)
	{
		//пͻ˻תεͨıͷʱĵĻϢ
		cache_msg_proc();
	}
    return ret;
}


/**
 * @brief ĽڵϢat
 * @param 
 * @return 
 * @note  ڿͻ˺תηATڿͻڲǰ׺ҵӦĴӺ
 * @warning 
 */
void at_context_write_by_ctx(struct at_context * context ,char *data,int len)
{
    int ret = 0;
    struct clt_ops_t *send_req_node;
    void * at_cmd_prefix = NULL;
    int prefix_len = 0;
    void *at_cmd_paras = NULL;
    int paras_len = 0;

    if(len != strlen(data))
    {
        softap_assert("");
    }

    ret = parase_at_cmd(data, &at_cmd_prefix, &prefix_len, &at_cmd_paras, &paras_len);

    if(ret < 0)
    {
        softap_assert("");
    }

    //ػǰ׺ӦopsֵģյӦʱops
    if(context->context_type == AT_CLIENT)
    {
        send_req_node = find_req_by_prefix(at_cmd_prefix, prefix_len); // kw 3
        if(send_req_node)
        {
            context->at_proc = (void *)send_req_node;//а˴atǰ׺,send_req_nodeǰ׺鼴Ϊעеƥַ
        }
        else
        {
            context->at_proc = NULL;
            at_print(AT_ERR,"ERR: find prefix err len=%d, prefix=%s\n",len,(char *)at_cmd_prefix);
        }
    }

    //ǰ׺ȴǰ׺󱣴泤ʱ
    if(prefix_len >= AT_CMD_PREFIX)
    {
        softap_assert("");
    }

    memset(context->at_cmd_prefix, 0x00, AT_CMD_PREFIX);
	if(at_cmd_prefix != NULL && prefix_len < AT_CMD_PREFIX) {
		snprintf(context->at_cmd_prefix,prefix_len+1,"%s",(char *)at_cmd_prefix);
    //strncpy(context->at_cmd_prefix,at_cmd_prefix,prefix_len);
	context->at_cmd_prefix[AT_CMD_PREFIX-1]=0;
    at_netdog_monitor(context->at_channel->at_fd, data, context->at_cmd_prefix);
	}
}
#ifdef AT_CHECKSUM
//ΣAT ΣchecksumchecksumNULL
char* add_checksum_single_at(char *at_str)
{
	int at_str_type;	
	int prefix_len = 0;	
	int paras_len = 0;
	void *at_cmd_prefix = NULL;
	void *at_cmd_paras = NULL;		

	/* ATǰ׺Ϣʶǰ׺ݼAT*/
	at_str_type = parase_at_cmd(at_str, &at_cmd_prefix, &prefix_len, &at_cmd_paras, &paras_len);

	if((at_str_type == AT_TYPE_REQUEST || at_str_type == AT_TYPE_INFORM) && paras_len > 0)
	{	
		char checksum_flag[20] = {0};
		char checksum_cmd[AT_CMD_MAX] = {0};
		char temp_prefix[20]= {0};
		int tempPrefixlen = 0;
		
		tempPrefixlen = (prefix_len>20)? 20: prefix_len;
	 	strncpy(temp_prefix, at_cmd_prefix, tempPrefixlen);
		/*checksum_flagȡֵ
		all(дҪchecksum)
		partial(ִҪchecksum		ͨchecksum_cmd鿴)
		none(checksum)*/
		sc_cfg_get("checksum_flag",checksum_flag,sizeof(checksum_flag));	
		sc_cfg_get("checksum_cmd",checksum_cmd,sizeof(checksum_cmd));

		if(0 == strcmp(checksum_flag, "all")||(0 == strcmp(checksum_flag, "partial")&& at_strstr(checksum_cmd, temp_prefix)))
		{		
			char *csm_str = NULL;
			unsigned int csm = 0;

			//checksum
			csm_str = malloc(50);
			if(csm_str == NULL) softap_assert("");
			memset(csm_str, 0x00, 50);
			csm = get_chksum((char*)at_cmd_paras,paras_len);
			sprintf(csm_str, "\r\n+checksum: %d,%d\r\n", paras_len, csm);			
			return  csm_str;

		}		
	}

	return NULL;
}

/*Σ͵far_psΣchecksum֮AT
磺\r\n+creg: 1,1\r\n\r\nOK\r\n
أ\r\n+creg: 1,1\r\n\r\n+checksum: 3,xx\r\n\r\nOK\r\n 
*/
char* add_checksum_func(char *data)
{	
	char *next_str = data;
	char *next_str_rn = NULL;		
	char *next_str_r = NULL;
	char *new_str = NULL;  //checksumַ֮

	new_str = malloc(strlen(data)*2);
	if(new_str == NULL) softap_assert("");
	memset(new_str, 0x00, strlen(data)*2);

	while(next_str < data + strlen(data))
	{
		char *single_at = NULL;
		char *csm_str = NULL;

        next_str_rn = find_sub_str(next_str,"\r\n",strlen(next_str));
        next_str_r = find_sub_str(next_str,"\r",strlen(next_str));

        if((next_str_rn!=NULL)&&(next_str_r!=NULL)&&(next_str_rn==next_str_r))
        {
			//ATͷΪ"\r\n"
			if(next_str == next_str_rn)
			{		
				memcpy(new_str+strlen(new_str), next_str, 2);
				next_str += 2;
				continue;
			}
			single_at = (char *)malloc(next_str_rn-next_str+1);
			memset(single_at, 0x00, next_str_rn-next_str+1);
			memcpy(single_at, next_str,next_str_rn-next_str);
			csm_str = add_checksum_single_at(single_at);

			if(csm_str)
			{
				memcpy(new_str+strlen(new_str), next_str, next_str_rn-next_str+2);
				memcpy(new_str+strlen(new_str), csm_str, strlen(csm_str));
				free(csm_str);
			}
			else
			{
				memcpy(new_str+strlen(new_str), next_str, next_str_rn-next_str+2);
			}
			
			free(single_at);
			next_str = next_str_rn+2;		

		}
		//һAT"\r"β
        else if((next_str_r!=NULL)&&(next_str_rn>next_str_r || next_str_rn==NULL))
        {
			//ATͷΪ"\r"
			if(next_str == next_str_r)
			{		
				softap_assert("");
			}
			single_at = (char *)malloc(next_str_r-next_str+1);
			memset(single_at, 0x00, next_str_r-next_str+1);
			memcpy(single_at, next_str,next_str_r-next_str);
			csm_str = add_checksum_single_at(single_at);

			if(csm_str)
			{
				memcpy(new_str+strlen(new_str), next_str, next_str_r-next_str+1);
				memcpy(new_str+strlen(new_str), csm_str, strlen(csm_str));
				free(csm_str);
			}
			else
			{
				memcpy(new_str+strlen(new_str), next_str, next_str_r-next_str+1);
			}
			
			free(single_at);
			next_str = next_str_r+1;
        }
		else
		{
			softap_assert("send far_ps unkonw str!");
		}
	}
	
	return new_str;	
}

/* յATchecksum鷵ؽ
Σ rcv_str յAT
Σ    new_str ˵checksum֮AT
ֵ enum CHECKSUM_ERR
磺 at+creg=1\r\r\n+check_sum: 1,1\r\n
       at+creg=1\r*/
int rcv_checksum_func(char *rcv_str, char *new_str)
{
	char *next_str = rcv_str;
	char *next_str_rn = NULL;		
	char *next_str_r = NULL;

	while(next_str < rcv_str + strlen(rcv_str))
	{
		char *single_at = NULL;
		char *csm_str = NULL;

		next_str_rn = find_sub_str(next_str,"\r\n",strlen(next_str));
		next_str_r = find_sub_str(next_str,"\r",strlen(next_str));

		if((next_str_rn!=NULL)&&(next_str_r!=NULL)&&(next_str_rn==next_str_r))
		{
			//ATͷΪ"\r\n"
			if(next_str == next_str_rn)
			{		
				memcpy(new_str+strlen(new_str), next_str, 2);
				next_str += 2;
				continue;
			}
			single_at = (char *)malloc(next_str_rn-next_str+1);
			memset(single_at, 0x00, next_str_rn-next_str+1);
			memcpy(single_at, next_str,next_str_rn-next_str);
			csm_str = add_checksum_single_at(single_at);

			memcpy(new_str+strlen(new_str), next_str, next_str_rn-next_str+2);

			free(single_at);
			next_str = next_str_rn+2;		

			//Ҫchecksum
			if(csm_str)
			{
				if(at_strstr(next_str, "checksum"))
				{
					//checksumȷnext_strָ/r/n+checksum:xx,yy/r/n֮
					if(at_strstr(next_str, csm_str))
					{
						next_str += strlen(csm_str); 
						
						if(next_str >= rcv_str + strlen(rcv_str))
						{
							return CHECKSUM_SUCC;
						}											
					}
					else
					{
						return CHECKSUM_ERROR;
					}
				}
				else
				{
					return  WAIT_CHECKSUM;
				}				
				free(csm_str);
			}
		}
		//һAT"\r"β
		else if((next_str_r!=NULL)&&(next_str_rn>next_str_r || next_str_rn==NULL))
		{
			//ATͷΪ"\r"
			if(next_str == next_str_r)
			{		
				softap_assert("");
			}
			
			single_at = (char *)malloc(next_str_r-next_str+1);
			memset(single_at, 0x00, next_str_r-next_str+1);
			memcpy(single_at, next_str,next_str_r-next_str);
			csm_str = add_checksum_single_at(single_at);

			memcpy(new_str+strlen(new_str), next_str, next_str_r-next_str+1);

			free(single_at);
			next_str = next_str_r+1;		

			//Ҫchecksum
			if(csm_str)
			{
				if(at_strstr(next_str, "checksum"))
				{
					//checksumȷnext_strָ/r/n+checksum:xx,yy/r/n֮
					if(at_strstr(next_str, csm_str))
					{
						next_str += strlen(csm_str); 
						
						if(next_str >= rcv_str + strlen(rcv_str))
						{
							return CHECKSUM_SUCC;
						}						
					}
					else
					{
						return CHECKSUM_ERROR;
					}
				}
				else
				{
					return	WAIT_CHECKSUM;
				}				
				free(csm_str);
			}		
		}
		else
		{
			softap_assert("send far_ps unkonw str!");
		}
	}
	
	return CHECKSUM_SUCC;	
}
#endif
#if (APP_OS_TYPE == APP_OS_LINUX)
int at_context_write_data_ap(int at_fd ,char *data,int len)
{
	//struct at_channel_info * at_chan = NULL;
	int ret = -1;
	//int resendcnt = 0;
	//int written_bytes = 0; 
	//int left_len = len;
	char *pstr = data;	
	char *new_str = NULL;
	
	if(at_fd < 0)	
		return -1;
	
	//at_chan = at_context_find_chn_by_fd(at_fd);
	//if(NULL == at_chan)
		//return -1;
#ifdef AT_CHECKSUM
	//͵ⲿMCUchecksumУ
	if(check_is_farps(at_fd))
	{	
		char checksum_flag[20] = "none";

		if(at_strcmp(checksum_flag, "none") != 0)
		{
			new_str = add_checksum_func(data);
			left_len = strlen(new_str);
			pstr = new_str;
		}
	}
#endif
#if 0
	//volte ptyͨⶨƣдvolte ptyͨݣȹ̶Ϊ1024
	if(check_is_volte_ptyfd(at_fd))
	{
		char volte_str[1024] = {0};
		int str_len = len<(sizeof(volte_str)-1)?len:(sizeof(volte_str)-1);
		memcpy(volte_str,data,str_len);
		left_len = sizeof(volte_str);
		pstr = volte_str;
	}
#endif
	ret = at_write(at_fd, pstr, len);	
#ifdef AT_CHECKSUM
	if(new_str)
		free(new_str);
#endif
	//if(left_len == 0)
		//ret = len;
		
	at_print(AT_ERR,"at_write fd=%d,len=%d,ret=%d,data=%s \n",at_fd,len,ret,get_small_str(data));
	
	return ret;
}
#endif

#if (APP_OS_TYPE == APP_OS_TOS)	
int at_context_write_data_cp(int at_fd ,char *data,int len)
{
	struct at_channel_info * at_chan = NULL;
	int ret = -1;
	int resendcnt = 0;
	
	if(at_fd < 0)
	{	
		return -1;
	}
	at_chan = at_context_find_chn_by_fd(at_fd);
	if(NULL == at_chan)
		return -1;

RESEND:	
	ret = at_write(at_fd, data, len);
	resendcnt++;
	if(ret != 0)
	{	
		at_print(AT_ERR,"ERR: at_write errno:%d,fd=%d, len=%d, data=%s\n",errno,at_fd, len,get_small_str(data));
		
		if(at_chan->attribution & (1<<CH_COMM))
		{	
			if(resendcnt > 10)
			{
				softap_assert("at_write AP and CP fail!");
			}
			else
			{
				zOss_Sleep(100 * resendcnt);
				goto RESEND;
			}			
		}
	}
	else
	{
		at_print(AT_ERR,"at_write success fd=%d, len=%d, data=%s\n",at_fd, len,get_small_str(data));
	}
	return ret;
}
#endif

//дĳATͨתATϽڵײãϲͨfwd_all_at_str(fwd_fd,whole_cmd_str);ʽдͨ
int at_context_write_data(int at_fd ,char *data,int len)
{
#if (APP_OS_TYPE == APP_OS_LINUX)	
	return at_context_write_data_ap(at_fd, data, len);
#endif
#if (APP_OS_TYPE == APP_OS_TOS)	
	return at_context_write_data_cp(at_fd, data, len);
#endif
}

/**
 * @brief ָλõͨat
 * @param 
 * @return 
 * @note  תӦʹã㲥ʽ
 * @warning 
 */
int at_context_write_by_pos(int position,char *data)
{
    int i,ret=0;
	struct at_channel_info * at_chan = at_channel_head[position];

	for(; NULL !=at_chan; at_chan = at_chan->next)
	{
		//bit0Ϊ0
		if((at_chan->attribution & (1<<CH_AUTOIND)) == 0)
			at_context_write_data(at_chan->at_fd, data, strlen(data));
	}
	return 0;
}
//·ATͨϱAT
void resend_rcv_atstr(int at_fd, char *at_str)
{
	MSG_BUF stMsg = {0};

	at_print(AT_ERR,"Enter resend_rcv_atstr, fd:%d str:%s!!!\n", at_fd, at_str);

	if(at_fd >= MODULE_ID_ATCTL_TO_VOLTE && at_fd < MODULE_ID_ATCTL_TO_VOLTE+VOLTE_PTY1_MAX)
	{
		VOLTE_MSG_DATA	volte_req = {0};
		
		volte_req.msg_len = strlen(at_str)+3;
		snprintf(volte_req.msg_data, sizeof(volte_req.msg_data),"%s\r\n",at_str);
		volte_req.at_fd = at_fd + 1 - MODULE_ID_ATCTL_TO_VOLTE;
		
	    stMsg.ulMagic = MSG_MAGIC_WORD;
	    stMsg.lMsgType = MSG_TYPE_DEFAULT;
	    stMsg.src_id = MODULE_ID_VOLTE;
	    stMsg.dst_id = MODULE_ID_AT_CTL;
	    stMsg.usMsgCmd = MSG_CMD_FD1_VOLTE_TO_ATCTL;
	    stMsg.usDataLen = sizeof(struct at_msg_data);
	    memcpy(stMsg.aucDataBuf, &volte_req, sizeof(volte_req));
	}
	else if(at_fd >= MODULE_ID_VOLTE_TO_ATCTL && at_fd < MODULE_ID_VOLTE_TO_ATCTL+VOLTE_PTY2_MAX)
	{
		VOLTE_MSG_DATA	volte_req = {0};
		
		volte_req.msg_len = strlen(at_str)+3;
		snprintf(volte_req.msg_data, sizeof(volte_req.msg_data),"%s\r\n",at_str);
		volte_req.at_fd = at_fd + 1 - MODULE_ID_VOLTE_TO_ATCTL;
		
	    stMsg.ulMagic = MSG_MAGIC_WORD;
	    stMsg.lMsgType = MSG_TYPE_DEFAULT;
	    stMsg.src_id = MODULE_ID_VOLTE;
	    stMsg.dst_id = MODULE_ID_AT_CTL;
	    stMsg.usMsgCmd = MSG_CMD_FD2_VOLTE_TO_ATCTL;
	    stMsg.usDataLen = sizeof(struct at_msg_data);
	    memcpy(stMsg.aucDataBuf, &volte_req, sizeof(volte_req));
	}
	else
	{
		struct at_msg_data at_msg = {0};
		int at_len = strlen(at_str)+3;
		at_msg.at_fd = at_fd;

		//zdm atɺѾ\r\nȥatͨʱҪat
		//µatͨȡat̴߳Ҫ\r\n
		at_msg.at_str = malloc(at_len);
		if(NULL == at_msg.at_str) {
			softap_assert("");
			return;
		}
		memset(at_msg.at_str, 0x00, at_len);
		sprintf(at_msg.at_str, "%s\r\n",at_str);
	    at_msg.at_len = strlen(at_msg.at_str);
	    stMsg.ulMagic = MSG_MAGIC_WORD;
	    stMsg.lMsgType = MSG_TYPE_DEFAULT;
	    stMsg.src_id = MODULE_ID_AT_CTL;
	    stMsg.dst_id = MODULE_ID_AT_CTL;
	    stMsg.usMsgCmd = ATCTL_RCV_AT_STR_MSG;
	    stMsg.usDataLen = sizeof(struct at_msg_data);
	    memcpy(stMsg.aucDataBuf, &at_msg, sizeof(struct at_msg_data));
	}
    add_one_cache_msg(&stMsg);
}


//ĳЩҪȴϱATҪʱط
void delay_resend_atstr(int at_fd, char *at_str)
{
	struct at_msg_data at_msg = {0};
	int at_len = strlen(at_str)+3;
    MSG_BUF stMsg = {0};
	at_msg.at_fd = at_fd;

	at_print(AT_ERR,"Enter delay_resend_atstr, at_str:%s!!!\n", at_str);

	//zdm atɺѾ\r\nȥatͨʱҪat
	//µatͨȡat̴߳Ҫ\r\n
	at_msg.at_str = malloc(at_len);
	if(NULL == at_msg.at_str) {
		softap_assert("");
		return;
	}
	memset(at_msg.at_str, 0x00, at_len);
	sprintf(at_msg.at_str, "%s\r\n",at_str);
    at_msg.at_len = strlen(at_msg.at_str);
	
    stMsg.ulMagic = MSG_MAGIC_WORD;
    stMsg.lMsgType = MSG_TYPE_DEFAULT;
    stMsg.src_id = MODULE_ID_AT_CTL;
    stMsg.dst_id = MODULE_ID_AT_CTL;
    stMsg.usMsgCmd = ATCTL_RCV_AT_STR_MSG;
    stMsg.usDataLen = sizeof(struct at_msg_data);
    memcpy(stMsg.aucDataBuf, &at_msg, sizeof(struct at_msg_data));
    add_one_delayed_msg(&stMsg);
}


/**
 * @brief λûȡatͨ
 * @param 
 * @return 
 * @note  ˼ͨѶʹãϱʽҪcontext.positionfd,
 *        ȡ һõͨ
 * @warning 
 */
int at_context_get_fd_by_pos(int position)
{
    struct at_channel_info* node = at_channel_head[position];
    int fd = 0;

    for(;node; node = node->next)
    {
        if(node->reserved != 1)
        {
            fd = node->at_fd;
            return fd;
        }
    }

    if(!node)
    {
        assert(0);
    }
	return -1;
}

