/************************************************************************
* Ȩ (C)2001,ͨѶɷ޹˾
* 
* ļƣ zbl_ci_stk.c
* ļʶ
* ժҪ STKרõĹͽģ顣дһļļ¡
*
* ޸     汾     ޸ı     ޸	     ޸      
* ---------------------------------------------------------------------
* 2008/12/26   V1.0	        XXXX	             
************************************************************************/
#if _USE_BL


/**************************************************************************
 *                        ͷļ                                      *
 **************************************************************************/
#include "zbl_at_parser.h"
#include "zbl_at_atcode.h"
#include "zbl_ati_stk_msg.h"
#include "zcore_type.h"
#include "at_netdog.h"

//ASSERTFILE(__FILE__)

static SINT32 stkDecodeDuration(ParsingText* parsing, CHAR* timeUnit);
static atiUsatItem* decode90Item(ParsingText* parsing,UINT32 iItemNum);
static CHAR* decode90TextData(CHAR* dest, SINT32 dest_len, CHAR* source);
static CHAR* decode90ItemTextData(CHAR* dest, SINT32 dest_len, CHAR* source);
static UINT8 packSmsPdu(CHAR* src, CHAR* dst);
VOID initStkCmdDtl(VOID);
extern SINT32 SerializeNumbers(CONST CHAR* pSrc, CHAR* pDst, SINT32 nSrcLength);
extern SINT32 Encode8bit(CONST CHAR* pSrc, UINT8* pDst, SINT32 nSrcLength);
extern VOID atiCmdIdSet(T_CI_CMD_ID eId);
extern SINT32 Encode7bit(CONST CHAR* pSrc, UINT8* pDst, SINT32 nSrcLength);
extern OS_STATUS tp_os_mem_free(VOID *mem_ptr);
extern UINT32 ZTE_Trace(UINT32 nModNo, UINT8 nPrintLevel, const VOID *pFormat, ...);
extern ZBL_CHANNEL_MSG_INFO * zblMallocChannelMsg(UINT32 nSize);
extern VOID zblFreeChannelMsg(ZBL_CHANNEL_MSG_INFO **ppMsg);
extern SINT32 String2Bytes(CONST CHAR* pSrc, UINT8* pDst, SINT32 nSrcLength);
stkCmdDtl g_stk_cmd_dtl = {0};
UINT8 zblStkGetCodeType(UINT8 dcs);

static BOOL bIsMmiWaiting = FALSE;


/**************************************************************************
 *                                                                    *
 **************************************************************************/


/**************************************************************************
 *                                                                      *
 **************************************************************************/


/**************************************************************************
 *                                                                 *
 **************************************************************************/


/**************************************************************************
 *                           ȫֱ                                      *
 **************************************************************************/
/**
 * תʽ : '0' -> 0
 */
static CHAR charToValue(CHAR ch)
{
	if ('0' <= ch && ch <= '9')
	{
		return ch - '0';
	}
//lianglingling054850 20090515 modify:ʱдСд
	if('A'<= ch && ch <='Z')
    {
	    return ch - 'A' +10;
    }

    if('a'<= ch && ch <='z')
    {
	    return ch - 'a' +10;
    }
	return 0;
}

SINT32 Parse_Zuec_PpSmsDown(ParsingText* parsing, ZBL_CHANNEL_MSG_INFO **ppMsg)
{
    Token *pToken = NULLPTR;
	atiUsatDataDlSmsPpAck *msg_ptr = NULLPTR;

	if(NULL == ppMsg || NULL == parsing)
	    return -1;
	    
	ZTE_Trace(ZBL_AT, 2, "Parse_Zuec_PpSmsDown");
	*ppMsg = zblMallocChannelMsg(sizeof(atiUsatDataDlSmsPpAck));
    if(NULLPTR == *ppMsg)
    {
        zblAssert(0);
        return -1;
    }
    
    (*ppMsg)->msgId = ATI_STK_DATA_DL_SMS_PP_RSP;
    (*ppMsg)->msgSize = sizeof(atiUsatDataDlSmsPpAck);
	msg_ptr = (atiUsatDataDlSmsPpAck*)(*ppMsg)->msgData;
	if(NULL == msg_ptr)
	{
	    zblFreeChannelMsg(ppMsg);
	    return -1;
	}
    memset(msg_ptr, 0, sizeof(atiUsatDataDlSmsPpAck));

    //<SmsDownRlt>
	pToken = GetParam(parsing);
	if(NULL == pToken)
	{
	    zblFreeChannelMsg(ppMsg);
	    return -1;
	}
	msg_ptr->result_code= Str2Int(pToken->text);

    if(parsing->offset >= parsing->length)
    {
        return 0;
    }
    //[<Tpdu>]
	pToken = GetParam(parsing);
	if(NULL == pToken)
	{
	    zblFreeChannelMsg(ppMsg);
        if (parsing->token.text)
        {
            free(parsing->token.text);
            parsing->token.text = NULLPTR;
        }
	    return -1;
	}	
	if(13 != pToken->text[0])  //в
	{
	    UINT32 taduLen = 0;
        taduLen = String2Bytes(pToken->text, msg_ptr->ack_data, strlen(pToken->text));//zxj mod

        {
            UINT8 tempStr[ATI_USAT_SMS_PP_ACK_TPDU_LEN+1] = {0};
            tempStr[0] = taduLen;

            memcpy(&tempStr[1], msg_ptr->ack_data, ATI_USAT_SMS_PP_ACK_TPDU_LEN);            
            memcpy(msg_ptr->ack_data, tempStr, ATI_USAT_SMS_PP_ACK_TPDU_LEN + 1); 
        }
    }
    if (parsing->token.text)
    {
        free(parsing->token.text);
        parsing->token.text = NULLPTR;
    }
	return 0;	
}

SINT32 Parse_Zuec_CallCtrl(ParsingText* parsing, ZBL_CHANNEL_MSG_INFO **ppMsg)
{
    Token *pToken = NULLPTR;
	atiUsatUsimControlAck *msg_ptr = NULLPTR;
    UINT8 object_type = 0;

	if(NULL == ppMsg || NULL == parsing)
	    return -1;
	    
	ZTE_Trace(ZBL_AT, 2, "Parse_Zuec_CallCtrl");
	*ppMsg = zblMallocChannelMsg(sizeof(atiUsatUsimControlAck));
    if(NULLPTR == *ppMsg)
    {
        zblAssert(0);
        return -1;
    }
    
    (*ppMsg)->msgId = ATI_STK_USIM_CTL_RESULT;
    (*ppMsg)->msgSize = sizeof(atiUsatUsimControlAck);
	msg_ptr = (atiUsatUsimControlAck*)(*ppMsg)->msgData;
	if(NULL == msg_ptr)
	{
	    zblFreeChannelMsg(ppMsg);
	    return -1;
	}
    memset(msg_ptr, 0, sizeof(atiUsatUsimControlAck));
    /*
    Flag:ǰҵͣ0x00CCУ0x01ҵ0x02ǽṹҵ0x03PSݣ0xffЧ
    */
     /*
     <CallCtrRlt>,<Flag>,
     <data*>,
     <Capa1>,<subaddr>,<Alpha>,[<BcReptr>],<Capa2>
        ע<DevType>ȡֵͬ<data*>ݲͬ
        0<Ton>,<NPI>,<CallNum>
        1<Ton>,<NPI>,<SsStr>
        2<Dcs>,<UssdStr>
        3<Pd>,<TransId>,<MsgType>,<Nsapi>,<LlcSapi>,<Dlyclss>
        <ReliableClss>,<PeakPut>,<PrecClss>,<MeanPut>,
        [<TraffClss>],[<DelivOrd>],[<DelivErrSDU>],[<MaxSDUsiz>],
        [<MaxBitUp>],[<MaxBitDown>],[<ResiBER>],[<SDUerrRat>],
        [<TranLay>],[<TrafHand>],[<GuarBitUp>],[<GuarBitDown>],
        [<SignInd>],[<SourDescr>],[<MaxBitExt>],[<GuarBitExt>],
        <Pdptype>,<PdptypeNum>,<AddrInfo>,
        [<APN>],
        [<CfgProto>,<ProtoIDLen>[,<ProID>,<ProtoIDCont>]]
    */
    //<CallCtrRlt>
	pToken = GetParam(parsing);
	if(NULL == pToken)
	{
	    zblFreeChannelMsg(ppMsg);
	    return -1;
	}
	msg_ptr->ack_type = Str2Int(pToken->text);

    //<type>
	pToken = GetParam(parsing);
	if(NULL == pToken || 13 == pToken->text[0])
	{
	    zblFreeChannelMsg(ppMsg);
        if (parsing->token.text)
        {
            free(parsing->token.text);
            parsing->token.text = NULLPTR;
        }
	    return -1;
	}	
    object_type = Str2Int(pToken->text);
    switch (object_type)
    {
        case 0:
            {
                msg_ptr->object_type = ATI_USAT_USIM_CTL_TYPE_CALL;
                //<Ton>,<NPI>,<CallNum>
        	    pToken = GetParam(parsing);
        	    pToken = GetParam(parsing);
                pToken = GetParam(parsing);
            	if(NULL == pToken  || 13 == pToken->text[0])
            	{
            	    zblFreeChannelMsg(ppMsg);
                    if (parsing->token.text)
                    {
                        free(parsing->token.text);
                        parsing->token.text = NULLPTR;
                    }
            	    return -1;
            	}	   
                memcpy(&msg_ptr->usim_data.call_data.called_num_a, pToken->text, ATI_MAX_PHONE_NUM_LENGTH);
                
             }
            break;
        case 1:
            {
                msg_ptr->object_type = ATI_USAT_USIM_CTL_TYPE_SS;
        	    //<Ton>,<NPI>,<SsStr>
        	    pToken = GetParam(parsing);
        	    pToken = GetParam(parsing);
                pToken = GetParam(parsing);
            	if(NULL == pToken  || 13 == pToken->text[0])
            	{
            	    zblFreeChannelMsg(ppMsg);
                    if (parsing->token.text)
                    {
                        free(parsing->token.text);
                        parsing->token.text = NULLPTR;
                    }
            	    return -1;
            	}	   
                memcpy(&msg_ptr->usim_data.ss_data.ss_a, pToken->text, ATI_USAT_SS_STRING_SIZE_MAX);
            }
            break;
        case 2:
            {
                msg_ptr->object_type = ATI_USAT_USIM_CTL_TYPE_USSD;
                //[<Dcs>,<UssdStr>,]
                pToken = GetParam(parsing);
            	if(NULL == pToken  || 13 == pToken->text[0])
            	{
            	    zblFreeChannelMsg(ppMsg);
                    if (parsing->token.text)
                    {
                        free(parsing->token.text);
                        parsing->token.text = NULLPTR;
                    }
            	    return -1;
            	}	   
                msg_ptr->usim_data.ussd_data.ussd_str.alphabet = Str2Int(pToken->text);
                //<UssdStr>
                pToken = GetParam(parsing);
				if(NULL == pToken  || 13 == pToken->text[0])
            	{
            	    zblFreeChannelMsg(ppMsg);
                    if (parsing->token.text)
                    {
                        free(parsing->token.text);
                        parsing->token.text = NULLPTR;
                    }
            	    return -1;
            	}	
                memcpy(&msg_ptr->usim_data.ussd_data.ussd_str.text_a, pToken->text, ATI_USAT_SEND_USS_STRING_LENGTH);
            }
            break;
        case 3:
            {
                /* 
                <Pd>,<TransId>,<MsgType>,<Nsapi>,<LlcSapi>,<Dlyclss>
                <ReliableClss>,<PeakPut>,<PrecClss>,<MeanPut>,
                [<TraffClss>],[<DelivOrd>],[<DelivErrSDU>],[<MaxSDUsiz>],
                [<MaxBitUp>],[<MaxBitDown>],[<ResiBER>],[<SDUerrRat>],
                [<TranLay>],[<TrafHand>],[<GuarBitUp>],[<GuarBitDown>],
                [<SignInd>],[<SourDescr>],[<MaxBitExt>],[<GuarBitExt>],
                <Pdptype>,<PdptypeNum>,<AddrInfo>,
                [<APN>],
                [<CfgProto>,<ProtoIDLen>[,<ProID>,<ProtoIDCont>]]
                */
                msg_ptr->object_type = ATI_USAT_USIM_CTL_TYPE_PDP_ACT;
                pToken = GetParam(parsing);
                if(NULL == pToken  || 13 == pToken->text[0])
            	{
            	    zblFreeChannelMsg(ppMsg);
                    if (parsing->token.text)
                    {
                        free(parsing->token.text);
                        parsing->token.text = NULLPTR;
                    }
            	    return -1;
            	}	                   
                pToken = GetParam(parsing);
                pToken = GetParam(parsing);
                pToken = GetParam(parsing);
                pToken = GetParam(parsing);
                pToken = GetParam(parsing);
                pToken = GetParam(parsing);
                pToken = GetParam(parsing);
                pToken = GetParam(parsing);
                pToken = GetParam(parsing);
                if(NULL == pToken  || 13 == pToken->text[0])
            	{
            	    zblFreeChannelMsg(ppMsg);
                    if (parsing->token.text)
                    {
                        free(parsing->token.text);
                        parsing->token.text = NULLPTR;
                    }
            	    return -1;
            	}	   
                /* 
                [<TraffClss>],[<DelivOrd>],[<DelivErrSDU>],[<MaxSDUsiz>],
                [<MaxBitUp>],[<MaxBitDown>],[<ResiBER>],[<SDUerrRat>],
                [<TranLay>],[<TrafHand>],[<GuarBitUp>],[<GuarBitDown>],
                [<SignInd>],[<SourDescr>],[<MaxBitExt>],[<GuarBitExt>],
                <Pdptype>,<PdptypeNum>,<AddrInfo>,
                [<APN>],
                [<CfgProto>,<ProtoIDLen>[,<ProID>,<ProtoIDCont>]]
                */

                if((parsing->offset < parsing->length)&&(',' == parsing->text[parsing->offset]))//
                {
            		parsing->offset++;
            	}
                else
				{
					pToken = GetParam(parsing);//[<TraffClss>],
				}

				if((parsing->offset < parsing->length)&&(',' == parsing->text[parsing->offset]))//
                {
            		parsing->offset++;
            	}
				else
				{
					pToken = GetParam(parsing);//[<DelivOrd>],
				}

				if((parsing->offset < parsing->length)&&(',' == parsing->text[parsing->offset]))//
                {
            		parsing->offset++;
            	}
				else
				{
					pToken = GetParam(parsing);//[<DelivErrSDU>],
				}

				if((parsing->offset < parsing->length)&&(',' == parsing->text[parsing->offset]))//
                {
            		parsing->offset++;
            	}
				else
				{
					pToken = GetParam(parsing);//[<MaxSDUsiz>],
				}
				if((parsing->offset < parsing->length)&&(',' == parsing->text[parsing->offset]))//
                {
            		parsing->offset++;
            	}
				else
				{
					pToken = GetParam(parsing);//[<MaxBitUp>],
				}
				if((parsing->offset < parsing->length)&&(',' == parsing->text[parsing->offset]))//
                {
            		parsing->offset++;
            	}
				else
				{
					pToken = GetParam(parsing);//[<MaxBitDown>],
				}
				if((parsing->offset < parsing->length)&&(',' == parsing->text[parsing->offset]))//
                {
            		parsing->offset++;
            	}
				else
				{
					pToken = GetParam(parsing);//[<ResiBER>],
				}
				if((parsing->offset < parsing->length)&&(',' == parsing->text[parsing->offset]))//
                {
            		parsing->offset++;
            	}
				else
				{
					pToken = GetParam(parsing);//[<SDUerrRat>],
				}
				if((parsing->offset < parsing->length)&&(',' == parsing->text[parsing->offset]))//
                {
            		parsing->offset++;
            	}
				else
				{
					pToken = GetParam(parsing);//[<TranLay>],
				}
				if((parsing->offset < parsing->length)&&(',' == parsing->text[parsing->offset]))//
                {
            		parsing->offset++;
            	}
				else
				{
					pToken = GetParam(parsing);//[<TrafHand>],
				}
				if((parsing->offset < parsing->length)&&(',' == parsing->text[parsing->offset]))//
                {
            		parsing->offset++;
            	}
				else
				{
					pToken = GetParam(parsing);//[<GuarBitUp>],
				}
				if((parsing->offset < parsing->length)&&(',' == parsing->text[parsing->offset]))//
                {
            		parsing->offset++;
            	}
				else
				{
					pToken = GetParam(parsing);//[<GuarBitDown>],
				}
				if((parsing->offset < parsing->length)&&(',' == parsing->text[parsing->offset]))//
                {
            		parsing->offset++;
            	}
				else
				{
					pToken = GetParam(parsing);//[<SignInd>],
				}
				if((parsing->offset < parsing->length)&&(',' == parsing->text[parsing->offset]))//
                {
            		parsing->offset++;
            	}
				else
				{
					pToken = GetParam(parsing);//[<SourDescr>],
				}
				if((parsing->offset < parsing->length)&&(',' == parsing->text[parsing->offset]))//
                {
            		parsing->offset++;
            	}
				else
				{
					pToken = GetParam(parsing);//[<MaxBitExt>],
				}
				if((parsing->offset < parsing->length)&&(',' == parsing->text[parsing->offset]))//
                {
            		parsing->offset++;
            	}
				else
				{
					pToken = GetParam(parsing);//[<GuarBitExt>],
				}
				//<Pdptype>,<PdptypeNum>,<AddrInfo>,
                pToken = GetParam(parsing);
                if(NULL == pToken  || 13 == pToken->text[0])
            	{
            	    zblFreeChannelMsg(ppMsg);
                    if (parsing->token.text)
                    {
                        free(parsing->token.text);
                        parsing->token.text = NULLPTR;
                    }
            	    return -1;
            	}	   
                if((parsing->offset < parsing->length)&&(',' == parsing->text[parsing->offset]))//
                {
                    zblFreeChannelMsg(ppMsg);
            		return -1;
            	}
                else
                {
                    memcpy(&msg_ptr->usim_data.pdp_data.pdp_param_a, pToken->text, ATI_USAT_MAX_PDP_APN_LEN);
                }
				pToken = GetParam(parsing);//<PdptypeNum>
                pToken = GetParam(parsing);//<AddrInfo>


				/*  [<APN>],
                    [<CfgProto>,<ProtoIDLen>[,<ProID>,<ProtoIDCont>]]
                    */
				if((parsing->offset < parsing->length)&&(',' == parsing->text[parsing->offset]))//
                {
            		parsing->offset++;
            	}
				else
				{
					pToken = GetParam(parsing);//[<APN>]
				}  
				if((parsing->offset < parsing->length)&&(',' == parsing->text[parsing->offset]))//
                {
					parsing->offset++;
            	}
				else
				{
					pToken = GetParam(parsing);//<CfgProto>
				} 
				if((parsing->offset < parsing->length)&&(',' == parsing->text[parsing->offset]))//
                {
					parsing->offset++;
            	}
				else
				{
					pToken = GetParam(parsing);//<ProtoIDLen>
				} 

				if((parsing->offset < parsing->length)&&(',' == parsing->text[parsing->offset]))//
                {
            		parsing->offset++;
            	}
				else
				{
					pToken = GetParam(parsing);//<ProID>
				} 
				if((parsing->offset < parsing->length)&&(',' == parsing->text[parsing->offset]))//
                {
					parsing->offset++;
            	}
				else
				{
					pToken = GetParam(parsing);//<ProtoIDCont>
				} 
            }
            break;
        default:
            {
                zblFreeChannelMsg(ppMsg);
                return -1;
            }
    }
    //<Capa1>,<subaddr>,<Alpha>,[<BcReptr>],<Capa2> 
	pToken = GetParam(parsing);
	if(NULL == pToken || 13 == pToken->text[0])
	{
	    zblFreeChannelMsg(ppMsg);
        if (parsing->token.text)
        {
            free(parsing->token.text);
            parsing->token.text = NULLPTR;
        }
	    return -1;
	}	
    memcpy(&msg_ptr->usim_data.call_data.cap_1_a, pToken->text, ATI_USAT_BC_CONTENTS_MAX_LENGTH+1);
	
    //<subaddr>
	pToken = GetParam(parsing);
	if(NULL == pToken || 13 == pToken->text[0])
	{
	    zblFreeChannelMsg(ppMsg);
        if (parsing->token.text)
        {
            free(parsing->token.text);
            parsing->token.text = NULLPTR;
        }
	    return -1;
	}	
    memcpy(&msg_ptr->usim_data.call_data.called_subaddr_st.subaddr_a, pToken->text, ATI_USAT_SUBADDR_NUM_MAX);
    //[<Alpha>]
	pToken = GetParam(parsing);
	if(NULL == pToken || 13 == pToken->text[0])
	{
	    zblFreeChannelMsg(ppMsg);
        if (parsing->token.text)
        {
            free(parsing->token.text);
            parsing->token.text = NULLPTR;
        }
	    return -1;
	}	
    //[<BcReptr>]
    if((parsing->offset < parsing->length)&&(',' == parsing->text[parsing->offset]))//
    {
		parsing->offset++;
	}
	else
	{
		pToken = GetParam(parsing);
	}
    //<Capa2>  
	pToken = GetParam(parsing);
	if(NULL == pToken || 13 == pToken->text[0])
	{
	    zblFreeChannelMsg(ppMsg);
        if (parsing->token.text)
        {
            free(parsing->token.text);
            parsing->token.text = NULLPTR;
        }
	    return -1;
	}	
    memcpy(&msg_ptr->usim_data.call_data.cap_2_a, pToken->text, ATI_USAT_BC_CONTENTS_MAX_LENGTH+1);

    if (parsing->token.text)
    {
        free(parsing->token.text);
        parsing->token.text = NULLPTR;
    }
	return 0;	
}

SINT32 Parse_Zuec_SmsCtrl(ParsingText* parsing, ZBL_CHANNEL_MSG_INFO **ppMsg)
{
    Token *pToken = NULLPTR;
	atiUsatUsimControlAck *msg_ptr = NULLPTR;

	if(NULL == ppMsg || NULL == parsing)
	    return -1;
	    
	ZTE_Trace(ZBL_AT, 2, "Parse_Zuec_SmsCtrl");
	*ppMsg = zblMallocChannelMsg(sizeof(atiUsatUsimControlAck));
    if(NULLPTR == *ppMsg)
    {
        zblAssert(0);
        return -1;
    }
    
    (*ppMsg)->msgId = ATI_STK_USIM_CTL_RESULT;
    (*ppMsg)->msgSize = sizeof(atiUsatUsimControlAck);
	msg_ptr = (atiUsatUsimControlAck*)(*ppMsg)->msgData;
	if(NULL == msg_ptr)
	{
	    zblFreeChannelMsg(ppMsg);
	    return -1;
	}
    memset(msg_ptr, 0, sizeof(atiUsatUsimControlAck));
     /*<SmsCtrRlt>
     [,<RpTon>,<RpNPI>,<RpCallNum>
            [,<TpTon>,<TpNPI>,<TpCallNum>
                [,<Alpha>]
             ]
     ]*/
    //<SmsCtrRlt>
    msg_ptr->object_type = ATI_USAT_USIM_CTL_TYPE_SMS;
	pToken = GetParam(parsing);
	if(NULL == pToken)
	{
	    zblFreeChannelMsg(ppMsg);
	    return -1;
	}
	msg_ptr->ack_type = Str2Int(pToken->text);
    /*[,<RpTon>,<RpNPI>,<RpCallNum>
            [,<TpTon>,<TpNPI>,<TpCallNum>
                [,<Alpha>]
             ]
     ]*/
	if(parsing->offset >= parsing->length)
    {
	    if (parsing->token.text)
	    {
	        free(parsing->token.text);
	        parsing->token.text = NULLPTR;
	    }
        return 0;
    }
     //<RpTon>,<RpNPI>,<RpCallNum>
    if((parsing->offset < parsing->length)&&(',' == parsing->text[parsing->offset]))
    {
		parsing->offset++;
	}
    else
    {
    	pToken = GetParam(parsing);
    }
    if((parsing->offset < parsing->length)&&(',' == parsing->text[parsing->offset]))
    {
		parsing->offset++;
	}
    else
    {
    	pToken = GetParam(parsing);
    }
	
	if((parsing->offset < parsing->length)&&(',' == parsing->text[parsing->offset]))
    {
		parsing->offset++;
	}
	 else
    {
		pToken = GetParam(parsing);
		if (NULL != pToken)
            memcpy(&msg_ptr->usim_data.sms_data.src_addr_a, pToken->text, ATI_MAX_PHONE_NUM_LENGTH);
    } 
        
     //[<TpTon>,<TpNPI>,<TpCallNum>],[<Alpha>]
    if(parsing->offset >= parsing->length)
	{
        if (parsing->token.text)
        {
            free(parsing->token.text);
            parsing->token.text = NULLPTR;
        }
	    return 0;
	}	
    //<TpTon>,<TpNPI>,<TpCallNum>
    if((parsing->offset < parsing->length)&&(',' == parsing->text[parsing->offset]))
    {
		parsing->offset++;
	}
    else
    {
    	pToken = GetParam(parsing);
    }
    if((parsing->offset < parsing->length)&&(',' == parsing->text[parsing->offset]))
    {
		parsing->offset++;
	}
    else
    {
    	pToken = GetParam(parsing);
    }
    if((parsing->offset < parsing->length)&&(',' == parsing->text[parsing->offset]))//[<TpTon>,<TpNPI>,<TpCallNum>],[<Alpha>]
    {
		parsing->offset++;
	}
    else
    {
        pToken = GetParam(parsing);   
		if (NULL != pToken)
        	memcpy(&msg_ptr->usim_data.sms_data.dest_addr_a, pToken->text, ATI_MAX_PHONE_NUM_LENGTH);
    }
    
    if (parsing->token.text)
    {
        free(parsing->token.text);
        parsing->token.text = NULLPTR;
    }
	return 0;	
}
SINT32 Parse_Zupci_SetupEvnt(ParsingText* parsing, ZBL_CHANNEL_MSG_INFO **ppMsg)
{
    Token *pToken = NULLPTR;
	atiUsatSetupEvtList *msg_ptr= NULLPTR;
	
	ZTE_Trace(ZBL_AT, 0, "Parse_Zupci_SetupEvnt");
	*ppMsg = zblMallocChannelMsg(sizeof(atiUsatSetupEvtList));
    if(NULLPTR == *ppMsg)
    {
        zblAssert(0);
        return -1;
    }
    
    (*ppMsg)->msgId = ATI_STK_SETUP_EVENT_LIST_IND;
    (*ppMsg)->msgSize = sizeof(atiUsatSetupEvtList);
	msg_ptr = (atiUsatSetupEvtList*)(*ppMsg)->msgData;
	if(NULL ==msg_ptr)
	{
	    zblFreeChannelMsg(ppMsg);
	    return -1;
	}
    memset(msg_ptr, ZBL_EVT_NUM_MAX, sizeof(atiUsatSetupEvtList));
    msg_ptr->evt_num = 0;
    
    //<CmdNum>,<CmdQual>    
	//CmdNum
	pToken = GetParam(parsing);
	if(NULL == pToken)
	{
	    zblFreeChannelMsg(ppMsg);
	    return -1;
	}	
	g_stk_cmd_dtl.cmdNum = Str2Int(pToken->text);	
	
	//CmdQual
	pToken = GetParam(parsing);
	if(NULL == pToken)
	{
	    zblFreeChannelMsg(ppMsg);
        if (parsing->token.text)
        {
            free(parsing->token.text);
            parsing->token.text = NULLPTR;
        }
	    return -1;
	}		
	g_stk_cmd_dtl.cmdQual = Str2Int(pToken->text);	
	
	//<EvtNum>
	pToken = GetParam(parsing);
	if(NULL == pToken)
	{
	    zblFreeChannelMsg(ppMsg);
        if (parsing->token.text)
        {
            free(parsing->token.text);
            parsing->token.text = NULLPTR;
        }
	    return -1;
	}	
	msg_ptr->evt_num = Str2Int(pToken->text);	
    
	//<EvtLst>
	pToken = GetParam(parsing);
	if(NULL == pToken)
	{
	    zblFreeChannelMsg(ppMsg);
        if (parsing->token.text)
        {
            free(parsing->token.text);
            parsing->token.text = NULLPTR;
        }
	    return -1;
	}	
    {
        CHAR tmpStr[3] = {0};
        UINT8 listStrLen = strlen(pToken->text);
        UINT8 eventNum = 0;
        
        while(listStrLen != 0)
        {
            strncpy(tmpStr, (CHAR*)&(pToken->text[eventNum*2]), 2);    
            msg_ptr->evt_list_a[eventNum] = HexStr2Int(tmpStr);
            listStrLen -= 2;
            eventNum++;
        }
    }
    if (parsing->token.text)
    {
        free(parsing->token.text);
        parsing->token.text = NULLPTR;
    }
	return 0;
}
SINT32 Parse_Zupci_SelItem(ParsingText* parsing, ZBL_CHANNEL_MSG_INFO **ppMsg)
{
    Token *pToken = NULLPTR;
	atiUsatSelectItem  selectItem = {0};
	atiUsatSelectItem *msg_ptr = NULLPTR;
	atiUsatItem* item_ptr = NULLPTR;
	
	ZTE_Trace(ZBL_AT, 0, "Parse_Zupci_SelItem");
	
    memset(&selectItem, 0, sizeof(atiUsatSelectItem));

	//CmdNum
	pToken = GetParam(parsing);
	if(NULL == pToken)
	{
	    return -1;
	}
	g_stk_cmd_dtl.cmdNum = Str2Int(pToken->text);	
	//CmdQual
	pToken = GetParam(parsing);
	if(NULL == pToken)
	{
	    goto selitemenderr;
	}	
	g_stk_cmd_dtl.cmdQual = Str2Int(pToken->text);	
	if(g_stk_cmd_dtl.cmdQual & (0x01<<STK_BIT_7))
	{
		selectItem.help_avail = 1;
	}
	//Alpha
	if((parsing->offset < parsing->length)&&(',' == parsing->text[parsing->offset]))
    {
		parsing->offset++;
	}
	else
	{
	    pToken = GetParam(parsing);
    	if(NULL == pToken)
    	{
    	    goto selitemenderr;
    	}	    
		selectItem.alpha_st.alpha_presence = 1;
		decode90TextData(selectItem.alpha_st.alpha_a, ATI_USAT_MAX_LENGTH_ALPHA_ID, pToken->text);

	}
	//ItemNum
	pToken = GetParam(parsing);
	if(NULL == pToken)
	{
	    goto selitemenderr;
	}	
	selectItem.item_num = Str2Int(pToken->text);
	//Item
	item_ptr = decode90Item(parsing,selectItem.item_num);
	if(item_ptr == NULL)
	{	
		at_print(AT_ERR,"Parse_Zupci_SelItem decode90Item fail \r\n");	
		goto selitemenderr;
	}	

	//[<ItemId>],
	if(',' == parsing->text[parsing->offset])// û[<ItemId>]
    {
		parsing->offset++;
	}
	else
	{
	 	pToken = GetParam(parsing);
    	if(NULL == pToken)
    	{
    	    goto selitemenderr;
    	}	
	}

	if(parsing->offset >= parsing->length)
	{
		goto selitemend;
	}
	else
	{
		if(',' == parsing->text[parsing->offset])// û[<ItemLstQuf>]
	    {
			parsing->offset++;
		}
		else
		{
		 	pToken = GetParam(parsing);
	    	if(NULL == pToken)
	    	{
	    	    goto selitemenderr;
	    	}	
		}
	}
	//[<IconWithDesc>,<IconId> [,<TxtAtr>]]
	if(parsing->offset >= parsing->length)
	{
		goto selitemend;
	}
	else
	{
		if(',' == parsing->text[parsing->offset])// //IconWithDesc
	    {
			parsing->offset++;
		}
		else
		{
			pToken = GetParam(parsing);
         	if(NULL == pToken)
        	{
        	   goto selitemenderr;
        	}	    			
			selectItem.icon_st.self_explanatory = Str2Int(pToken->text);
        }
		if(',' == parsing->text[parsing->offset])// <IconId>
	    {
			parsing->offset++;
			selectItem.icon_st.id = 0xff;
		}
		else
		{
			//IconId
		    pToken = GetParam(parsing);
        	if(NULL == pToken)
        	{
        	    goto selitemenderr;
        	}		    
			selectItem.icon_st.id = Str2Int(pToken->text);
		}
	}
selitemend:
	//selectItem.default_item_id = 0xff; //psδϱ

	*ppMsg = zblMallocChannelMsg(sizeof(atiUsatSelectItem) + sizeof(atiUsatItem)*selectItem.item_num);
	if(NULLPTR == *ppMsg)
	{
		//if(item_ptr != NULL)
			free(item_ptr);
		zblAssert(0);
		return -1;
	}	
	
	(*ppMsg)->msgId = ATI_STK_SELECT_ITEM_IND;
	(*ppMsg)->msgSize = sizeof(atiUsatSelectItem)+sizeof(atiUsatItem)*selectItem.item_num;
	msg_ptr = (atiUsatSelectItem*)(*ppMsg)->msgData;
	if(NULL == msg_ptr)
	{
		zblFreeChannelMsg(ppMsg);
		goto selitemenderr;
	}
	msg_ptr->default_item_id = 0xff; //psδϱ
	msg_ptr->help_avail = selectItem.help_avail;
	msg_ptr->item_num	= selectItem.item_num;
	memcpy(&msg_ptr->alpha_st, &selectItem.alpha_st, sizeof(atiUsatAlphaId));
	memcpy(&msg_ptr->icon_st, &selectItem.icon_st, sizeof(atiUsatIconId));
	memcpy(&msg_ptr->item_list_head_ptr, item_ptr, sizeof(atiUsatItem)*selectItem.item_num);
	if(item_ptr != NULL)
		free(item_ptr);
	item_ptr = NULL;
	
	at_print(AT_ERR,"Parse_Zupci_SelItem end msgid=%x msgsize=%d, struct_size=%d\r\n", ATI_STK_SELECT_ITEM_IND, (*ppMsg)->msgSize, sizeof(atiUsatSelectItem));	
	
	if (parsing->token.text)
    {
        free(parsing->token.text);
        parsing->token.text = NULLPTR;
    }
	return 0;

selitemenderr:
	if (parsing->token.text)
    {
        free(parsing->token.text);
        parsing->token.text = NULLPTR;
    }
	if(item_ptr != NULL)
		free(item_ptr);
    return -1;
}

SINT32 Parse_Zupci_MoreTime(ParsingText* parsing, ZBL_CHANNEL_MSG_INFO **ppMsg)
{
    Token *pToken = NULLPTR;

	ZTE_Trace(ZBL_AT, 0, "Parse_Zupci_MoreTime");
	*ppMsg = zblMallocChannelMsg(0);
    if(NULLPTR == *ppMsg)
    {
        zblAssert(0);
        return -1;
    }
    (*ppMsg)->msgId = ATI_STK_MORE_TIME_IND;
    (*ppMsg)->msgSize = 0;

    //<CmdNum>,<CmdQual>    
	//CmdNum
	pToken = GetParam(parsing);
	if(NULL == pToken)
	{
	    zblFreeChannelMsg(ppMsg);
	    return -1;
	}	
	g_stk_cmd_dtl.cmdNum = Str2Int(pToken->text);	
	
	//CmdQual
	pToken = GetParam(parsing);
	if(NULL == pToken)
	{
	    zblFreeChannelMsg(ppMsg);
        if (parsing->token.text)
        {
            free(parsing->token.text);
            parsing->token.text = NULLPTR;
        }
	    return -1;
	}		
	g_stk_cmd_dtl.cmdQual = Str2Int(pToken->text);	
    if (parsing->token.text)
    {
        free(parsing->token.text);
        parsing->token.text = NULLPTR;
    }
	return 0;	
}

SINT32 Parse_Zupci_GetInkey(ParsingText* parsing, ZBL_CHANNEL_MSG_INFO **ppMsg)
{
    Token *pToken = NULLPTR;
	atiUsatGetInkey *msg_ptr = NULLPTR;
	SINT32 iLen = sizeof(atiUsatGetInkey);
	
	ZTE_Trace(ZBL_AT, 0, "Parse_Zupci_GetInkey");

	*ppMsg = zblMallocChannelMsg(iLen);
    if(NULLPTR == *ppMsg)
    {
        zblAssert(0);
        return -1;
    }
    (*ppMsg)->msgId = ATI_STK_GET_INKEY_IND;
    (*ppMsg)->msgSize = iLen;
	
	msg_ptr = (atiUsatGetInkey*)(*ppMsg)->msgData;
	if(NULL == msg_ptr)
	{
	    zblFreeChannelMsg(ppMsg);
	    return -1;
	}		
	memset(msg_ptr, 0, iLen);
	/*<CmdNum>,<CmdQual>,<CodeMode>,<Txt>,[<IconWithDesc>,<IconId>],
						[<TimeUnit>,<TimeFreq>][,<TxtAtr>]*/
	//CmdNum
	pToken = GetParam(parsing);
	if(NULL == pToken)
	{
	    zblFreeChannelMsg(ppMsg);
	    return -1;
	}		
	g_stk_cmd_dtl.cmdNum = Str2Int(pToken->text);	
	
	//CmdQual
	pToken = GetParam(parsing);
	if(NULL == pToken)
	{
	    zblFreeChannelMsg(ppMsg);
        if (parsing->token.text)
        {
            free(parsing->token.text);
            parsing->token.text = NULLPTR;
        }
	    return -1;
	}		
	g_stk_cmd_dtl.cmdQual = Str2Int(pToken->text);	
	if(g_stk_cmd_dtl.cmdQual & (0x01<<STK_BIT_7))
	{
		msg_ptr->help_avail	= 1;
	}
	if(g_stk_cmd_dtl.cmdQual & (0x01<<STK_BIT_3))
	{
		msg_ptr->imm_digit_resp	= 1;
	}

	if (g_stk_cmd_dtl.cmdQual & (0x01<<STK_BIT_2))
	{
		msg_ptr->char_type = ATI_USAT_CHAR_TYPE_YES_OR_NO;
	}
	else
	{
		if (g_stk_cmd_dtl.cmdQual & (0x01))
		{
			if (g_stk_cmd_dtl.cmdQual & (0x01<<STK_BIT_1))
			{
				msg_ptr->char_type = ATI_USAT_CHAR_TYPE_UCS2_ALPHABET;
			}
			else
			{
				msg_ptr->char_type = ATI_USAT_CHAR_TYPE_SMS_ALPHABET;
			}			
		}
		else
		{
			msg_ptr->char_type = ATI_USAT_CHAR_TYPE_DIGITS;
		}
	}
	//CodeMode
	pToken = GetParam(parsing);
	if(NULL == pToken)
	{
	    zblFreeChannelMsg(ppMsg);
        if (parsing->token.text)
        {
            free(parsing->token.text);
            parsing->token.text = NULLPTR;
        }
	    return -1;
	}		
	msg_ptr->text_st.alphabet = zblStkGetCodeType(Str2Int(pToken->text));
	//Txt
	pToken = GetParam(parsing);
	if(NULL == pToken)
	{
	    zblFreeChannelMsg(ppMsg);
        if (parsing->token.text)
        {
            free(parsing->token.text);
            parsing->token.text = NULLPTR;
        }
	    return -1;
	}		
	msg_ptr->text_st.text_a[0] = 0x80;
	decode90TextData((CHAR*)(msg_ptr->text_st.text_a) + 1, ATI_USAT_MAX_LENGTH_LONG_TEXT_STRING-1,
		pToken->text);

	//[<IconWithDesc>,<IconId>],	
	if(parsing->offset >= parsing->length)
	{
		goto getinkeyend;
	}
	else
	{
		if(',' == parsing->text[parsing->offset])// [<IconWithDesc>,<IconId>]
	    {
			parsing->offset++;
		}
		else
		{
		    pToken = GetParam(parsing);
	    	if(NULL == pToken)
	    	{
	    	    zblFreeChannelMsg(ppMsg);
	            if (parsing->token.text)
	            {
	                free(parsing->token.text);
	                parsing->token.text = NULLPTR;
	            }
	    	    return -1;
	    	}		    
			//IconWithDesc
			msg_ptr->icon_st.self_explanatory = Str2Int(pToken->text);
        }
		if(',' == parsing->text[parsing->offset])// <IconId>
	    {
			parsing->offset++;
			msg_ptr->icon_st.id = 0xff;
		}
		else
		{
			//IconId
			pToken = GetParam(parsing);
	    	if(NULL == pToken)
	    	{
	    	    zblFreeChannelMsg(ppMsg);
	            if (parsing->token.text)
	            {
	                free(parsing->token.text);
	                parsing->token.text = NULLPTR;
	            }
	    	    return -1;
	    	}			
			msg_ptr->icon_st.id = Str2Int(pToken->text);
		}
	}
	//[<TimeUnit>,<TimeFreq>[,<TxtAtr>]]
	if(parsing->offset >= parsing->length)
	{
		goto getinkeyend;
	}
	else
	{
		if(',' == parsing->text[parsing->offset])// [<TimeUnit>,<TimeFreq>]
	    {
			parsing->offset++;
		}
		else
		{
			pToken = GetParam(parsing);
			if(NULL == pToken)
			{
			    zblFreeChannelMsg(ppMsg);
		        if (parsing->token.text)
		        {
		            free(parsing->token.text);
		            parsing->token.text = NULLPTR;
		        }
			    return -1;
			}		
		}
        if(',' == parsing->text[parsing->offset])// [<TimeUnit>,<TimeFreq>]
	    {
			parsing->offset++;
		}
        else
        {
			msg_ptr->duration = stkDecodeDuration(parsing, pToken->text);				
		}
	}
getinkeyend:	
    if (parsing->token.text)
    {
        free(parsing->token.text);
        parsing->token.text = NULLPTR;
    }
	return 0;
}

BOOL gHasReceivedSetupMenu = FALSE;//Ƿյsetup menu

//޸ĺ

SINT32 Parse_Zupci_GetInput(ParsingText* parsing, ZBL_CHANNEL_MSG_INFO **ppMsg)
{
    Token *pToken = NULLPTR;
	atiUsatGetInput *msg_ptr = NULLPTR;
	SINT32 iLen = sizeof(atiUsatGetInput);
    SINT32 tResponseFormat=0;
	ZTE_Trace(ZBL_AT, 0, "Parse_Psstk_GetInput");

	*ppMsg = zblMallocChannelMsg(iLen);
    if(NULLPTR == *ppMsg)
    {
        zblAssert(0);
        return -1;
    }
    (*ppMsg)->msgId = ATI_STK_GET_INPUT_IND;
    (*ppMsg)->msgSize = iLen;
	
	msg_ptr = (atiUsatGetInput*)(*ppMsg)->msgData;
	if(NULL == msg_ptr)
	{
	    zblFreeChannelMsg(ppMsg);
	    return -1;
	}	
	memset(msg_ptr, 0, iLen);
	
	/*<CmdNum>,<CmdQual>,<CodeMode>,<Txt>,<MinRspLen>,<MaxRspLen>
			[,<DefCodeMode>,<DefTxt>[,<IconWithDesc>,<IconId>[,<TxtAtr>]]]*/
	//CmdNum
	pToken = GetParam(parsing);
	if(NULL == pToken)
	{
	    zblFreeChannelMsg(ppMsg);
	    return -1;
	}	
	g_stk_cmd_dtl.cmdNum = Str2Int(pToken->text);	
	
	//CmdQual
	pToken = GetParam(parsing);
	if(NULL == pToken)
	{
	    zblFreeChannelMsg(ppMsg);
        if (parsing->token.text)
        {
            free(parsing->token.text);
            parsing->token.text = NULLPTR;
        }
	    return -1;
	}		
	g_stk_cmd_dtl.cmdQual = Str2Int(pToken->text);	
	if(g_stk_cmd_dtl.cmdQual & (0x01<<STK_BIT_7))
	{
		msg_ptr->help_avail	= 1;
	}
	if(g_stk_cmd_dtl.cmdQual & (0x01<<STK_BIT_2))
	{
		msg_ptr->hide_entry	= 1;
	}
	
	if (g_stk_cmd_dtl.cmdQual & (0x01))
	{
		if (g_stk_cmd_dtl.cmdQual & (0x01<<STK_BIT_1))
		{
		       ZTE_Trace(ZBL_AT, 0, "Parse_Psstk_GetInput char_type = 2");
			msg_ptr->char_type = ATI_USAT_CHAR_TYPE_UCS2_ALPHABET;
			msg_ptr->alphabet = ATI_USAT_TEXT_ALPHABET_16_BIT;
		}
		else
		{
		       ZTE_Trace(ZBL_AT, 0, "Parse_Psstk_GetInput char_type = 1");
			msg_ptr->char_type = ATI_USAT_CHAR_TYPE_SMS_ALPHABET;
			if (g_stk_cmd_dtl.cmdQual & (0x01<<STK_BIT_3))
			{
				msg_ptr->alphabet = ATI_USAT_TEXT_ALPHABET_8_BIT;
			}
			else
			{
				msg_ptr->alphabet = ATI_USAT_TEXT_ALPHABET_7_BIT;
			}
		}			
	}
	else
	{
	       ZTE_Trace(ZBL_AT, 0, "Parse_Psstk_GetInput char_type = 0");
		msg_ptr->char_type = ATI_USAT_CHAR_TYPE_DIGITS;
		if (g_stk_cmd_dtl.cmdQual & (0x01<<STK_BIT_3))
		{
			msg_ptr->alphabet = ATI_USAT_TEXT_ALPHABET_8_BIT;
		}
		else
		{
			msg_ptr->alphabet = ATI_USAT_TEXT_ALPHABET_7_BIT;
		}
	}	
	
	//CodeMode
	pToken = GetParam(parsing);
	if(NULL == pToken)
	{
	    zblFreeChannelMsg(ppMsg);
        if (parsing->token.text)
        {
            free(parsing->token.text);
            parsing->token.text = NULLPTR;
        }
	    return -1;
	}		
	msg_ptr->text_st.alphabet = zblStkGetCodeType(Str2Int(pToken->text));
	//Txt
	pToken = GetParam(parsing);
	if(NULL == pToken)
	{
	    zblFreeChannelMsg(ppMsg);
        if (parsing->token.text)
        {
            free(parsing->token.text);
            parsing->token.text = NULLPTR;
        }
	    return -1;
	}		
    if(!gHasReceivedSetupMenu)//δյsetup menu,Ϊܿ
    {//zxj mod
        CHAR tempText[ATI_USAT_MAX_LENGTH_LONG_TEXT_STRING/2] = {0};
        
    	msg_ptr->text_st.text_a[0] = 0x80;
        memcpy((void*)tempText, pToken->text, strlen(pToken->text)+1);
        String2Bytes((CHAR*)tempText, (UINT8*)&(msg_ptr->text_st.text_a[1]), strlen(tempText));
	}
    else
    {
		msg_ptr->text_st.text_a[0] = 0x80;
		decode90TextData((CHAR*)(msg_ptr->text_st.text_a) + 1, ATI_USAT_MAX_LENGTH_LONG_TEXT_STRING-1,
		pToken->text);
    }
	//MinRspLen
	pToken = GetParam(parsing);
	if(NULL == pToken)
	{
	    zblFreeChannelMsg(ppMsg);
        if (parsing->token.text)
        {
            free(parsing->token.text);
            parsing->token.text = NULLPTR;
        }
	    return -1;
	}		
	msg_ptr->min_len = Str2Int(pToken->text);
	//MaxRspLen
	pToken = GetParam(parsing);
	if(NULL == pToken)
	{
	    zblFreeChannelMsg(ppMsg);
        if (parsing->token.text)
        {
            free(parsing->token.text);
            parsing->token.text = NULLPTR;
        }
	    return -1;
	}		
	msg_ptr->max_len = Str2Int(pToken->text);
	
	//[<DefCodeMode>,<DefTxt>
	if(parsing->offset >= parsing->length)
	{
		goto getinputend;
	}
	else
	{
		if(',' == parsing->text[parsing->offset])// û<DefCodeMode>,<DefTxt>
	    {
			parsing->offset++;
		}
		else         // [<DefCodeMode>,<DefTxt>]
		{
			//DefCodeMode
			pToken = GetParam(parsing);
	    	if(NULL == pToken)
	    	{
	    	    zblFreeChannelMsg(ppMsg);
	            if (parsing->token.text)
	            {
	                free(parsing->token.text);
	                parsing->token.text = NULLPTR;
	            }
	    	    return -1;
	    	}			
			msg_ptr->default_text_st.alphabet = zblStkGetCodeType(Str2Int(pToken->text));
        }
		if(',' == parsing->text[parsing->offset])// û<DefCodeMode>,<DefTxt>
	    {
			parsing->offset++;
		}
		else         // [<DefCodeMode>,<DefTxt>]
		{
			//DefTxt
			pToken = GetParam(parsing);
	    	if(NULL == pToken)
	    	{
	    	    zblFreeChannelMsg(ppMsg);
	            if (parsing->token.text)
	            {
	                free(parsing->token.text);
	                parsing->token.text = NULLPTR;
	            }
	    	    return -1;
	    	}			
			decode90TextData((CHAR*)(msg_ptr->default_text_st.text_a), ATI_USAT_MAX_LENGTH_LONG_TEXT_STRING,
				pToken->text);
		}
	}
	
	//<IconWithDesc>,<IconId> or [,<TxtAtr>]
	if(parsing->offset >= parsing->length)
	{
		goto getinputend;
	}
	else
	{
		if(',' == parsing->text[parsing->offset])//û[<IconWithDesc>,<IconId>]
		{
			parsing->offset++;
		}
		else// [<IconWithDesc>,<IconId>]
		{
			pToken = GetParam(parsing);
			if(NULL == pToken)
			{
			    zblFreeChannelMsg(ppMsg);
		        if (parsing->token.text)
		        {
		            free(parsing->token.text);
		            parsing->token.text = NULLPTR;
		        }
			    return -1;
			}		
					
		    //IconWithDesc
			msg_ptr->icon_st.self_explanatory = Str2Int(pToken->text);
        }

		if(',' == parsing->text[parsing->offset])//û[<IconWithDesc>,<IconId>]
		{
			parsing->offset++;
			msg_ptr->icon_st.id = 0xff;
		}
		else// [<IconWithDesc>,<IconId>]
		{
			//IconId
		    pToken = GetParam(parsing);
        	if(NULL == pToken)
        	{
        	    zblFreeChannelMsg(ppMsg);
                if (parsing->token.text)
                {
                    free(parsing->token.text);
                    parsing->token.text = NULLPTR;
                }
        	    return -1;
        	}			    
			msg_ptr->icon_st.id = Str2Int(pToken->text);
					
		}
	}
getinputend:	
    if (parsing->token.text)
    {
        free(parsing->token.text);
        parsing->token.text = NULLPTR;
    }
	return 0;	
}

SINT32 Parse_Zupci_SetupMenu(ParsingText* parsing, ZBL_CHANNEL_MSG_INFO **ppMsg)
{
	atiUsatSetupMenu* msg_ptr = NULLPTR;
	atiUsatSetupMenu  setupMenu = {0};
	atiUsatItem *item_ptr = NULL;
    Token *pToken = NULLPTR;

	at_print(AT_ERR,"Parse_Zupci_SetupMenu\r\n");	
	memset(&setupMenu, 0, sizeof(atiUsatSetupMenu));
    setupMenu.icon_st.id = 0xff;
    gHasReceivedSetupMenu = TRUE;
    
	//CmdNum
	pToken = GetParam(parsing);
	if(NULL == pToken)
	{
	    return -1;
	}	
	g_stk_cmd_dtl.cmdNum = Str2Int(pToken->text);	
	//CmdQual
	pToken = GetParam(parsing);
	if(NULL == pToken)
	{
	    goto setupmenuenderr;
	}	
	g_stk_cmd_dtl.cmdQual = Str2Int(pToken->text);	
	if(g_stk_cmd_dtl.cmdQual & (0x01<<STK_BIT_7))
	{
		setupMenu.help_avail	= 1;
	}
	//Alpha
	pToken = GetParam(parsing);
	if(NULL == pToken)
	{
	    goto setupmenuenderr;
	}	
	if (strncmp(",", pToken->text, 1))
	{
		setupMenu.alpha_st.alpha_presence = 1;
		decode90TextData(setupMenu.alpha_st.alpha_a, ATI_USAT_MAX_LENGTH_ALPHA_ID, pToken->text);
	}
	//ItemNum
	pToken = GetParam(parsing);
	if(NULL == pToken)
	{
	    goto setupmenuenderr;
	}	
	setupMenu.item_num = Str2Int(pToken->text);
	//Item
	item_ptr = decode90Item(parsing,setupMenu.item_num);
	if(item_ptr == NULL)
	{	
		at_print(AT_ERR,"Parse_Zupci_SetupMenu decode90Item fail \r\n");	
	    goto setupmenuenderr;
	}			

	if(parsing->offset >= parsing->length)
	{	
		goto setupmenuend;
	}
	else
	{
		if(',' == parsing->text[parsing->offset])// û[<ItemLstQuf>]
	    {
			parsing->offset++;
		}
		else
		{
		 	pToken = GetParam(parsing);
	    	if(NULL == pToken)
	    	{
				goto setupmenuenderr;
	    	}	
		}
	}
	//[<IconWithDesc>,<IconId> [,<TxtAtr>]]
	if(parsing->offset >= parsing->length)
	{	
		goto setupmenuend;
	}
	else
	{
	    //IconWithDesc
		if(',' == parsing->text[parsing->offset])// û[<IconWithDesc>,<IconId>]
	    {
			parsing->offset++;
		}
		else
		{
			pToken = GetParam(parsing);
            if(NULL == pToken)
        	{
				goto setupmenuenderr;
        	}  
			setupMenu.icon_st.self_explanatory = Str2Int(pToken->text);
        }
		//IconId
		if(',' == parsing->text[parsing->offset])// û[<IconWithDesc>,<IconId>]
	    {
			parsing->offset++;
			setupMenu.icon_st.id = 0xff;
		}
		else
		{			
		    pToken = GetParam(parsing);
        	if(NULL == pToken)
        	{
				goto setupmenuenderr;
        	}		    
			setupMenu.icon_st.id = Str2Int(pToken->text);
		}
	}
setupmenuend:	
	*ppMsg = zblMallocChannelMsg(sizeof(atiUsatSetupMenu) + sizeof(atiUsatItem)*setupMenu.item_num);
	if(NULLPTR == *ppMsg)
	{
		//if(item_ptr != NULL)
			free(item_ptr);
		zblAssert(0);
		return -1;
	}	
	
	(*ppMsg)->msgId = ATI_STK_SETUP_MENU_IND;
	(*ppMsg)->msgSize = sizeof(atiUsatSetupMenu)+sizeof(atiUsatItem)*setupMenu.item_num;
	msg_ptr = (atiUsatSetupMenu*)(*ppMsg)->msgData;
	if(NULL == msg_ptr)
	{
		zblFreeChannelMsg(ppMsg);
		goto setupmenuenderr;
	}
	msg_ptr->help_avail = setupMenu.help_avail;
	msg_ptr->item_num   = setupMenu.item_num;
	memcpy(&msg_ptr->alpha_st, &setupMenu.alpha_st, sizeof(atiUsatAlphaId));
	memcpy(&msg_ptr->icon_st, &setupMenu.icon_st, sizeof(atiUsatIconId));
	memcpy(&msg_ptr->item_list_head_ptr, item_ptr, sizeof(atiUsatItem)*setupMenu.item_num);
	if(item_ptr != NULL)
	    free(item_ptr);
	item_ptr = NULL;
	
	at_print(AT_ERR,"Parse_Zupci_SetupMenu end msgid=%x msgsize=%d, struct_size=%d\r\n", ATI_STK_SETUP_MENU_IND, (*ppMsg)->msgSize, sizeof(atiUsatSetupMenu));	
	
    if (parsing->token.text)
    {
        free(parsing->token.text);
        parsing->token.text = NULLPTR;
    }
	return 0;

setupmenuenderr:
	if (parsing->token.text)
    {
        free(parsing->token.text);
        parsing->token.text = NULLPTR;
    }
	if(item_ptr != NULL)
	    free(item_ptr);
	return -1;
}

SINT32 Parse_Zupci_DisplayText(ParsingText* parsing, ZBL_CHANNEL_MSG_INFO **ppMsg)
{
    Token *pToken = NULL;
	atiUsatDisplatText *msg_ptr;
	
	ZTE_Trace(ZBL_AT, 0, "Parse_Zupci_DisplayText");
	*ppMsg = zblMallocChannelMsg(sizeof(atiUsatDisplatText));
    if(NULLPTR == *ppMsg)
    {
        zblAssert(0);
        return -1;
    }
	
    (*ppMsg)->msgId = ATI_STK_DISPLAY_TEXT_IND;
    (*ppMsg)->msgSize = sizeof(atiUsatDisplatText);
	msg_ptr = (atiUsatDisplatText*)(*ppMsg)->msgData;
	if(NULL == msg_ptr)
	{
	    zblFreeChannelMsg(ppMsg);
	    return -1;
	}		
    memset(msg_ptr, 0, sizeof(atiUsatDisplatText));
	
	//CmdNum
	pToken = GetParam(parsing);
	if(NULL == pToken)
	{
	    zblFreeChannelMsg(ppMsg);
	    return -1;
	}	
	g_stk_cmd_dtl.cmdNum = Str2Int(pToken->text);	
	//CmdQual
	pToken = GetParam(parsing);
	if(NULL == pToken)
	{
	    zblFreeChannelMsg(ppMsg);
        if (parsing->token.text)
        {
            free(parsing->token.text);
            parsing->token.text = NULLPTR;
        }
	    return -1;
	}	
	g_stk_cmd_dtl.cmdQual = Str2Int(pToken->text);	
	if(g_stk_cmd_dtl.cmdQual & (0x01<<STK_BIT_7))
	{
		msg_ptr->user_clear_msg	= 1;
	}	
	if(g_stk_cmd_dtl.cmdQual & (0x01))
	{
		msg_ptr->priority	= 1;
	}

	//CodeMode
	pToken = GetParam(parsing);
	if(NULL == pToken)
	{
	    zblFreeChannelMsg(ppMsg);
        if (parsing->token.text)
        {
            free(parsing->token.text);
            parsing->token.text = NULLPTR;
        }
	    return -1;
	}	
	msg_ptr->text_st.alphabet = zblStkGetCodeType(Str2Int(pToken->text));	

	//Txt
	pToken = GetParam(parsing);
	if(NULL == pToken)
	{
	    zblFreeChannelMsg(ppMsg);
        if (parsing->token.text)
        {
            free(parsing->token.text);
            parsing->token.text = NULLPTR;
        }
	    return -1;
	}	
	if(STK_CODE_MODE_UCS2==msg_ptr->text_st.alphabet)
    {   
        CHAR strText[ATI_USAT_MAX_LENGTH_LONG_TEXT_STRING/2] = {0};
	    strText[0] = '8';
	    strText[1] = '0';
	    memcpy(&strText[2], pToken->text, strlen(pToken->text));
	    decode90ItemTextData((CHAR*)(msg_ptr->text_st.text_a), ATI_USAT_MAX_LENGTH_LONG_TEXT_STRING,
		strText);
    }
    else
    {
	    decode90ItemTextData((CHAR*)(msg_ptr->text_st.text_a), ATI_USAT_MAX_LENGTH_LONG_TEXT_STRING,
		pToken->text);
    }

	//[<IconWithDesc>,<IconId>]
	if(parsing->offset >= parsing->length)
	{
		goto displaytextend;
	}
	else
	{
		if(',' == parsing->text[parsing->offset])// [<IconWithDesc>,<IconId>]
	    {
			parsing->offset++;
		}
		else
		{
		    pToken = GetParam(parsing);
	    	if(NULL == pToken)
	    	{
	    	    zblFreeChannelMsg(ppMsg);
	            if (parsing->token.text)
	            {
	                free(parsing->token.text);
	                parsing->token.text = NULLPTR;
	            }
				ZTE_Trace(ZBL_AT, 0, "Parse_Zupci_DisplayText IconWithDesc");

	    	    return -1;
	    	}	    
			msg_ptr->icon_st.self_explanatory = Str2Int(pToken->text);
        }
		if(',' == parsing->text[parsing->offset])// [<IconWithDesc>,<IconId>]
	    {
			parsing->offset++;  //ҪôͬʱڣҪôͬʱ
		}
		else
		{
			pToken = GetParam(parsing);
	    	if(NULL == pToken)
	    	{
	    	    zblFreeChannelMsg(ppMsg);
	            if (parsing->token.text)
	            {
	                free(parsing->token.text);
	                parsing->token.text = NULLPTR;
	            }
				ZTE_Trace(ZBL_AT, 0, "Parse_Zupci_DisplayText IconId");

	    	    return -1;
	    	}		
			msg_ptr->icon_st.id = Str2Int(pToken->text);
		}
	}
	
	//[<ImtRspExt>]	
	if(parsing->offset >= parsing->length)
	{
		goto displaytextend;
	}
	else
	{
		if(',' == parsing->text[parsing->offset])// [<ImtRspExt>]
	    {
			parsing->offset++;
		}
		else
		{
		    pToken = GetParam(parsing);
	    	if(NULL == pToken)
	    	{
	    	    zblFreeChannelMsg(ppMsg);
	            if (parsing->token.text)
	            {
	                free(parsing->token.text);
	                parsing->token.text = NULLPTR;
	            }
				ZTE_Trace(ZBL_AT, 0, "Parse_Zupci_DisplayText ImtRspExt");

	    	    return -1;
	    	}	    
		    msg_ptr->immediate_resp = Str2Int(pToken->text);
		}
	}

	//[<TimeUnit>,<TimeFreq>[,<TxtAtr>]]
	if(parsing->offset >= parsing->length)
	{
		goto displaytextend;
	}
	else
	{
		if((parsing->offset < parsing->length)&&(',' == parsing->text[parsing->offset]))
		{
			parsing->offset++;  //ҪôͬʱڣҪôͬʱ

		}
		else
		{
		    pToken = GetParam(parsing);
	    	if(NULL == pToken)
	    	{
	    	    zblFreeChannelMsg(ppMsg);
	            if (parsing->token.text)
	            {
	                free(parsing->token.text);
	                parsing->token.text = NULLPTR;
	            }
				ZTE_Trace(ZBL_AT, 0, "Parse_Zupci_DisplayText TimeUnit");

	    	    return -1;
	    	}
		}
		if((parsing->offset < parsing->length)&&(',' == parsing->text[parsing->offset]))
		{
			parsing->offset++;  //ҪôͬʱڣҪôͬʱ
		}
		else
		{
			msg_ptr->duration = stkDecodeDuration(parsing, pToken->text);
		}
	}
	
displaytextend:	
    if (parsing->token.text)
    {
        free(parsing->token.text);
        parsing->token.text = NULLPTR;
    }
	return 0;
}

SINT32 Parse_Zupci_SendSms(ParsingText* parsing, ZBL_CHANNEL_MSG_INFO **ppMsg)
{
    Token *pToken = NULL;
	atiUsatSendSms *msg_ptr;
    SINT32 taduLen = 0;
	
	ZTE_Trace(ZBL_AT, 0, "Parse_Zupci_SendSms");
	*ppMsg = zblMallocChannelMsg(sizeof(atiUsatSendSms));
    if(NULLPTR == *ppMsg)
    {
        zblAssert(0);
        return -1;
    }
    
    (*ppMsg)->msgId = ATI_STK_SEND_SMS_PDU_REQ;
    (*ppMsg)->msgSize = sizeof(atiUsatSendSms);
	msg_ptr = (atiUsatSendSms*)(*ppMsg)->msgData;
	if(NULL == msg_ptr)
	{
	    zblFreeChannelMsg(ppMsg);
	    return -1;
	}		
    memset(msg_ptr, 0, sizeof(atiUsatSendSms));
	/*<CmdNum>,<CmdQual>,[<Alpha>],[<Ton>,<NPI>,<CallNum>],
						<TPdu>[,<IconWithDesc>,<IconId>[,<TxtAtr>]]]*/
	//CmdNum
	pToken = GetParam(parsing);
	if(NULL == pToken)
	{
	    zblFreeChannelMsg(ppMsg);
        if (parsing->token.text)
        {
            free(parsing->token.text);
            parsing->token.text = NULLPTR;
        }
	    return -1;
	}	
	g_stk_cmd_dtl.cmdNum = Str2Int(pToken->text);	
	//CmdQual
	pToken = GetParam(parsing);
	if(NULL == pToken)
	{
	    zblFreeChannelMsg(ppMsg);
        if (parsing->token.text)
        {
            free(parsing->token.text);
            parsing->token.text = NULLPTR;
        }
	    return -1;
	}	
	g_stk_cmd_dtl.cmdQual = Str2Int(pToken->text);	

	//Alpha
	if((parsing->offset < parsing->length)&&(',' == parsing->text[parsing->offset]))
    {
		parsing->offset++;
	}
	else
	{
	    pToken = GetParam(parsing);
    	if(NULL == pToken)
    	{
    	    zblFreeChannelMsg(ppMsg);
            /*modify by zxj 2009-08-05 ߲飬ڴй©*/
            if (parsing->token.text)
            {
                free(parsing->token.text);
                parsing->token.text = NULLPTR;
            }
    	    return -1;
    	}	    
		msg_ptr->alpha_st.alpha_presence = 1;
		//msg_ptr->alpha_st->alphabet 90δ?MMIûõ 
		decode90TextData(msg_ptr->alpha_st.alpha_a, ATI_USAT_MAX_LENGTH_ALPHA_ID, pToken->text);
	}	

	
	//[<Ton>,<NPI>,<CallNum>,<TPdu>]
	if(parsing->offset >= parsing->length)
	{
		goto sendsmsend;
	}
	else
	{
		if(',' == parsing->text[parsing->offset])
		{
			parsing->offset++;
		}
		else
		{
			pToken = GetParam(parsing);
        }
        if(',' == parsing->text[parsing->offset])
		{
			parsing->offset++;
		}
		else
		{
			pToken = GetParam(parsing);
        }
        if(',' == parsing->text[parsing->offset])
		{
			parsing->offset++;
		}
		else
		{
		    pToken = GetParam(parsing);
		}

		msg_ptr->alpha_st.alphabet = ATI_USAT_TEXT_ALPHABET_16_BIT;//temp add 
		if(',' == parsing->text[parsing->offset])
		{
			parsing->offset++;
		}
		else
		{        
			//[TPdu]
			pToken = GetParam(parsing);
			if(NULL == pToken)
			{
			    zblFreeChannelMsg(ppMsg);
		        if (parsing->token.text)
		        {
		            free(parsing->token.text);
		            parsing->token.text = NULLPTR;
		        }
			    return -1;
			}	  	

		    if(g_stk_cmd_dtl.cmdQual & (0x01)) //ҪME
		    {
		        CHAR tempStr[ATI_USAT_MAX_LENGTH_SHORT_TEXT_STRING] = {0};//"010005810180F6 00040953494D435848465A48";
		        if(strlen(pToken->text) >ATI_USAT_MAX_LENGTH_SHORT_TEXT_STRING)
		        {
		            ZTE_Trace(ZBL_AT, 0, "Parse_Zupci_SendSms error!");
		            zblFreeChannelMsg(ppMsg);
		            return -1;
		        }
		        else
		        {
		            packSmsPdu(pToken->text, (CHAR*)&tempStr);
		            taduLen = String2Bytes((CHAR*)&tempStr, msg_ptr->tpdu_data_a, strlen(tempStr));
		        }          
		    }
		    else
		    {
		        taduLen = String2Bytes(pToken->text, msg_ptr->tpdu_data_a, strlen(pToken->text));//zxj mod
		    }
		    {
		        UINT8 tempStr[ATI_USAT_MAX_LENGTH_SHORT_TEXT_STRING+4] = {0};

		        /* ΪƵЭջ luyuexia*/
		        tempStr[0] = taduLen + 2;
		        tempStr[1] = 0x01;
		        tempStr[2] = 0x00;

		        memcpy(&tempStr[3], msg_ptr->tpdu_data_a, ATI_USAT_MAX_LENGTH_SHORT_TEXT_STRING);
	        
		        memcpy(msg_ptr->tpdu_data_a, tempStr, ATI_USAT_MAX_LENGTH_SHORT_TEXT_STRING + 1); 
	    	}
	    }

	}
	    
        
	//<IconWithDesc>,<IconId> or [,<TxtAtr>]	
	if(parsing->offset >= parsing->length)
	{
		goto sendsmsend;
	}
	else
	{
	    //IconWithDesc
		if(',' == parsing->text[parsing->offset])//û[<IconWithDesc>,<IconId>]
		{
			parsing->offset++;
		}
		else// [<IconWithDesc>,<IconId>]
		{
			pToken = GetParam(parsing);
			if(NULL == pToken)
			{
			    zblFreeChannelMsg(ppMsg);
		        if (parsing->token.text)
		        {
		            free(parsing->token.text);
		            parsing->token.text = NULLPTR;
		        }
			    return -1;
			}		
					
		    //IconWithDesc
			msg_ptr->icon_st.self_explanatory = Str2Int(pToken->text);
        }
		//IconId
		if(',' == parsing->text[parsing->offset])
		{
			parsing->offset++;
			msg_ptr->icon_st.id = 0xff;
		}
		else
		{
		    pToken = GetParam(parsing);
        	if(NULL == pToken)
        	{
        	    zblFreeChannelMsg(ppMsg);
                if (parsing->token.text)
                {
                    free(parsing->token.text);
                    parsing->token.text = NULLPTR;
                }
        	    return -1;
        	}			    
			msg_ptr->icon_st.id = Str2Int(pToken->text);
					
		}
	}	
sendsmsend:	
    if (parsing->token.text)
    {
        free(parsing->token.text);
        parsing->token.text = NULLPTR;
    }
	return 0;
}

SINT32 Parse_Zupci_SetupCall(ParsingText* parsing, ZBL_CHANNEL_MSG_INFO **ppMsg)
{
    Token *pToken = NULLPTR;
    atiUsatSetupCall *msg_ptr= NULLPTR;

    ZTE_Trace(ZBL_AT, 0, "Parse_Zupci_SetupCall");
    *ppMsg = zblMallocChannelMsg(sizeof(atiUsatSetupCall));
    if(NULLPTR == *ppMsg)
    {
        zblAssert(0);
        return -1;
    }
    
    (*ppMsg)->msgId = ATI_STK_CALL_MO_SETUP_REQ;
    (*ppMsg)->msgSize = sizeof(atiUsatSetupCall);
    msg_ptr = (atiUsatSetupCall*)(*ppMsg)->msgData;
    if(NULL ==msg_ptr)
    {
        zblFreeChannelMsg(ppMsg);
        return -1;
    }
    memset(msg_ptr, 0, sizeof(atiUsatSetupCall));

    /*<CmdNum>,<CmdQual>,[<AlphaCnf>],<Ton>,<NPI>,<CallNum>
    [,<subaddr>
       [,<Capa>
          [,<TimeUnit>,<TimeFreq>
              [,<IconWithDescCnf>,<IconIdCnf>
                    [,<AlphaStup>
                        [,<IconWithDescStup>,<IconIdStup>
                            [,<TxtAtrCnf>[,<TxtAtrStup>]]]]]]]]*/

    //CmdNum
    pToken = GetParam(parsing);
    if(NULL == pToken)
    {
        zblFreeChannelMsg(ppMsg);
        return -1;
    }	
    g_stk_cmd_dtl.cmdNum = Str2Int(pToken->text);	
    
    //CmdQual
    pToken = GetParam(parsing);
    if(NULL == pToken)
    {
        zblFreeChannelMsg(ppMsg);
        if (parsing->token.text)
        {
            free(parsing->token.text);
            parsing->token.text = NULLPTR;
        }
        return -1;
    }	
    g_stk_cmd_dtl.cmdQual = Str2Int(pToken->text);	
    msg_ptr->call_opera_type = g_stk_cmd_dtl.cmdQual;

    //AlphaCnf
    if((parsing->offset < parsing->length)&&(',' == parsing->text[parsing->offset]))
    {
        parsing->offset++;
    }
    else
    {
        pToken = GetParam(parsing);
        if(NULL == pToken)
        {
            zblFreeChannelMsg(ppMsg);
            if (parsing->token.text)
            {
                free(parsing->token.text);
                parsing->token.text = NULLPTR;
            }
            return -1;
        }	    
        msg_ptr->alpha_confirm_st.alpha_presence = 1;
        msg_ptr->alpha_confirm_st.alphabet = ATI_USAT_TEXT_ALPHABET_16_BIT;//temp add 
        decode90TextData(msg_ptr->alpha_confirm_st.alpha_a, ATI_USAT_MAX_LENGTH_ALPHA_ID, pToken->text);
    }	
	
    //<Ton>,<NPI>,<CallNum>
    if((parsing->offset < parsing->length)&&(',' == parsing->text[parsing->offset]))
    {
        parsing->offset++;
    }
    else
    {
        pToken = GetParam(parsing);
    }
	if((parsing->offset < parsing->length)&&(',' == parsing->text[parsing->offset]))
    {
        parsing->offset++;
	}
    else
	{
        pToken = GetParam(parsing);
    }
	if((parsing->offset < parsing->length)&&(',' == parsing->text[parsing->offset]))
    {
        parsing->offset++;
	}
	else
	{
        pToken = GetParam(parsing);
        if(NULL == pToken)
        {
            zblFreeChannelMsg(ppMsg);
            if (parsing->token.text)
            {
                free(parsing->token.text);
                parsing->token.text = NULLPTR;
            }
            return -1;
        }
        else
        {
            UINT8 cmpLen = strlen(pToken->text);
            if(cmpLen > ATI_MAX_PHONE_NUM_LENGTH) 
            {
                cmpLen = ATI_MAX_PHONE_NUM_LENGTH;
            }
            if(cmpLen != 0)
            {
                memcpy(&msg_ptr->addr_a, pToken->text, cmpLen);
            }
        }
    }

    //[<subaddr> [XXX]]
    if(parsing->offset >= parsing->length)
    {
        goto setupcallend;
    }
    else
    {
        if(',' == parsing->text[parsing->offset])
        {
            parsing->offset++;
        }
        else
        {    
            pToken = GetParam(parsing);
            if(NULL == pToken)
            {
                zblFreeChannelMsg(ppMsg);
                if (parsing->token.text)
                {
                    free(parsing->token.text);
                    parsing->token.text = NULLPTR;
                }
                return -1;
            }
            else
            {
                UINT8 cmpLen = strlen(pToken->text);
                if(cmpLen > ATI_USAT_SUBADDR_NUM_MAX) 
                {
                    cmpLen = ATI_USAT_SUBADDR_NUM_MAX;
                }
                if(cmpLen != 0)
                {
                    memcpy(&msg_ptr->subaddr_st.subaddr_a, pToken->text, cmpLen);
                }
            }
        }
    }

	//[<Capa> [XXX]]]
    if(parsing->offset >= parsing->length)
    {
        goto setupcallend;
    }
    else
    {
        if(',' == parsing->text[parsing->offset])
        {
            parsing->offset++;
        }
        else
        { 
            pToken = GetParam(parsing);
            if(NULL == pToken)
            {
                zblFreeChannelMsg(ppMsg);
                if (parsing->token.text)
                {
                    free(parsing->token.text);
                    parsing->token.text = NULLPTR;
                }
                return -1;
            }
            else
            {
                UINT8 cmpLen = strlen(pToken->text);
                if(cmpLen > ATI_USAT_BC_CONTENTS_MAX_LENGTH+1) 
                {
                    cmpLen = ATI_USAT_BC_CONTENTS_MAX_LENGTH+1;
                }
                memcpy(&msg_ptr->cap_a, pToken->text, cmpLen);
            }        
        }
    }
    
    /*<TimeUnit>,<TimeFreq>*/
    if(parsing->offset >= parsing->length)
    {
        goto setupcallend;
    }
    else
    {
        if(',' == parsing->text[parsing->offset])
        {
            parsing->offset++;
        }
        else
        {
            //[<TimeUnit>,<TimeFreq>]
            pToken = GetParam(parsing);
            if(NULL == pToken)
            {
                zblFreeChannelMsg(ppMsg);
                if (parsing->token.text)
                {
                    free(parsing->token.text);
                    parsing->token.text = NULLPTR;
                }
                return -1;
            }	
        }
		if(',' == parsing->text[parsing->offset])
        {
			parsing->offset++;
		}
		else
        {
            //<TimeUnit>,<TimeFreq>
		if(pToken)
            msg_ptr->duration = stkDecodeDuration(parsing, pToken->text);
        }
    }

    /*<IconWithDescCnf>,<IconIdCnf>*/
    if(parsing->offset >= parsing->length)
    {
        goto setupcallend;
    }
    else
    {
        if(',' == parsing->text[parsing->offset])
        {
            parsing->offset++;
        }
        else
        {
            //[<IconWithDescCnf>,<IconIdCnf>]
            pToken = GetParam(parsing);
        	if(NULL == pToken)
            {
        	    zblFreeChannelMsg(ppMsg);
                if (parsing->token.text)
                {
                    free(parsing->token.text);
                    parsing->token.text = NULLPTR;
                }
        	    return -1;
        	}		    
            //IconWithDesc
            msg_ptr->icon_confirm_st.self_explanatory= Str2Int(pToken->text);
        }       		
                
		if(',' == parsing->text[parsing->offset])
	    {
	        msg_ptr->icon_confirm_st.id = 0xff;
			parsing->offset++;
		}
		else
		{
            //IconId
            pToken = GetParam(parsing);
            if(NULL == pToken)
            {
                zblFreeChannelMsg(ppMsg);
                if (parsing->token.text)
                {
                    free(parsing->token.text);
                    parsing->token.text = NULLPTR;
                }
                return -1;
            }		    
            msg_ptr->icon_confirm_st.id = Str2Int(pToken->text);
        }
    }
	
    //<AlphaStup>
    if(parsing->offset >= parsing->length)
    {
        goto setupcallend;
    }
    else
    {
        if(',' == parsing->text[parsing->offset])// 
        {
            parsing->offset++;
        }
        else
        {
            pToken = GetParam(parsing);
            if(NULL == pToken)
            {
                zblFreeChannelMsg(ppMsg);
                if (parsing->token.text)
                {
                    free(parsing->token.text);
                    parsing->token.text = NULLPTR;
                }
                return -1;
            }	    
            msg_ptr->alpha_setup_st.alpha_presence = 1;
            msg_ptr->alpha_setup_st.alphabet = ATI_USAT_TEXT_ALPHABET_16_BIT;//temp add 
            decode90TextData(msg_ptr->alpha_setup_st.alpha_a, ATI_USAT_MAX_LENGTH_ALPHA_ID, pToken->text);
        }	
    }
    
    //<IconWithDescStup>,<IconIdStup>
    if(parsing->offset >= parsing->length)
    {
        goto setupcallend;
    }
    else
    {
        if(',' == parsing->text[parsing->offset])
        {
            parsing->offset++;
        }
        else
        {
            //[<IconWithDescStup>,<IconIdStup>]
            pToken = GetParam(parsing);
        	if(NULL == pToken)
            {
        	    zblFreeChannelMsg(ppMsg);
                if (parsing->token.text)
                {
                    free(parsing->token.text);
                    parsing->token.text = NULLPTR;
                }
        	    return -1;
        	}
            msg_ptr->icon_setup_st.self_explanatory= Str2Int(pToken->text);
        }
        //IconId
		if(',' == parsing->text[parsing->offset])
	    {
			parsing->offset++;
            msg_ptr->icon_setup_st.id = 0xff;
		}
		else
		{
            //<IconWithDescStup>,<IconIdStup>
            pToken = GetParam(parsing);
            if(NULL == pToken)
            {
                zblFreeChannelMsg(ppMsg);
                if (parsing->token.text)
                {
                    free(parsing->token.text);
                    parsing->token.text = NULLPTR;
                }
                return -1;
            }		    
            msg_ptr->icon_setup_st.id = Str2Int(pToken->text);
        }
    }
setupcallend:		 
    
    if (parsing->token.text)
    {
        free(parsing->token.text);
        parsing->token.text = NULLPTR;
    }
	return 0;	
}
SINT32 Parse_Zupci_SendSs(ParsingText* parsing, ZBL_CHANNEL_MSG_INFO **ppMsg)
{
    Token *pToken = NULL;
	atiUsatSendSs* msg_ptr;
   
	ZTE_Trace(ZBL_AT, 0, "Parse_Zupci_SendSs");
	*ppMsg = zblMallocChannelMsg(sizeof(atiUsatSendSs));
    if(NULLPTR == *ppMsg)
    {
        zblAssert(0);
        return -1;
    }
    
    (*ppMsg)->msgId = ATI_STK_SEND_SS_REQ;
    (*ppMsg)->msgSize = sizeof(atiUsatSendSs);
	msg_ptr = (atiUsatSendSs*)(*ppMsg)->msgData;
	if(NULL == msg_ptr)
	{
	    zblFreeChannelMsg(ppMsg);
	    return -1;
	}		
    memset(msg_ptr, 0, sizeof(atiUsatSendSs));
    
    //<CmdNum>,<CmdQual>    
	//CmdNum
	pToken = GetParam(parsing);
	if(NULL == pToken)
	{
	    zblFreeChannelMsg(ppMsg);
	    return -1;
	}	
	g_stk_cmd_dtl.cmdNum = Str2Int(pToken->text);	
	
	//CmdQual
	pToken = GetParam(parsing);
	if(NULL == pToken)
	{
	    zblFreeChannelMsg(ppMsg);
        if (parsing->token.text)
        {
            free(parsing->token.text);
            parsing->token.text = NULLPTR;
        }
	    return -1;
	}		
	g_stk_cmd_dtl.cmdQual = Str2Int(pToken->text);	
	
	/*[<Alpha>],<Ton>,<NPI>,<SsStr>, [<IconWithDesc>,<IconId>][,<TxtAtr>]*/
	//Alpha
	if((parsing->offset < parsing->length)&&(',' == parsing->text[parsing->offset]))// 
    {
		parsing->offset++;
	}
	else
	{
	    pToken = GetParam(parsing);
    	if(NULL == pToken)
    	{
    	    zblFreeChannelMsg(ppMsg);

            if (parsing->token.text)
            {
                free(parsing->token.text);
                parsing->token.text = NULLPTR;
            }
    	    return -1;
    	}	    
		msg_ptr->alpha_st.alpha_presence = 1;
		decode90TextData(msg_ptr->alpha_st.alpha_a, ATI_USAT_MAX_LENGTH_ALPHA_ID, pToken->text);
	}	
	
	//[<Ton>,<NPI>,<SsStr>]
	if (',' == parsing->text[parsing->offset])
	{
	    parsing->offset++;
	}
	else
	{
		pToken = GetParam(parsing);
		if(NULL == pToken)
		{
		    zblFreeChannelMsg(ppMsg);

	        if (parsing->token.text)
	        {
	            free(parsing->token.text);
	            parsing->token.text = NULLPTR;
	        }
		    return -1;
		}
	    {
	        SINT32 ton = Str2Int(pToken->text);
	        if(ton)
	        {
	            msg_ptr->ton_npi = TRUE;
	        }
	        else
	        {
	            msg_ptr->ton_npi = FALSE;
	        }

	    }         
	}  
	if (',' == parsing->text[parsing->offset])
	{
	    parsing->offset++;
	}
	else
	{
		pToken = GetParam(parsing);
	}
    //<SsStr>
	if (',' == parsing->text[parsing->offset])
	{
	    parsing->offset++;
	}
	else
	{
		pToken = GetParam(parsing);
		if(NULL == pToken  || 13 == pToken->text[0])
		{
		    zblFreeChannelMsg(ppMsg);
	        if (parsing->token.text)
	        {
	            free(parsing->token.text);
	            parsing->token.text = NULLPTR;
	        }
		    return -1;
		}	   
	    memcpy(&msg_ptr->ss_a, pToken->text, ATI_USAT_SS_STRING_SIZE_MAX);
	}

	//<IconWithDesc>,<IconId> or [,<TxtAtr>]	
	if(parsing->offset >= parsing->length)
    {
        if (parsing->token.text)
        {
            free(parsing->token.text);
            parsing->token.text = NULLPTR;
        }
    	return 0;
    }   
    
	if (',' == parsing->text[parsing->offset])
	{
	    parsing->offset++;
	}
	else
	{
		pToken = GetParam(parsing);
		if(NULL == pToken)
		{
		    zblFreeChannelMsg(ppMsg);
	        if (parsing->token.text)
	        {
	            free(parsing->token.text);
	            parsing->token.text = NULLPTR;
	        }
		    return -1;
		}	  		
		//IconWithDesc
		msg_ptr->icon_st.self_explanatory = Str2Int(pToken->text);  	
	}
		
	if (',' == parsing->text[parsing->offset])
	{
	    parsing->offset++;
		msg_ptr->icon_st.id = 0xff;
	}
	else
	{
			//IconId
		    pToken = GetParam(parsing);
        	if(NULL == pToken)
        	{
        	    zblFreeChannelMsg(ppMsg);
                if (parsing->token.text)
                {
                    free(parsing->token.text);
                    parsing->token.text = NULLPTR;
                }
        	    return -1;
        	}	  			    
			msg_ptr->icon_st.id = Str2Int(pToken->text);
		}

    if (parsing->token.text)
    {
        free(parsing->token.text);
        parsing->token.text = NULLPTR;
    }
	return 0;
}

SINT32 Parse_Zupci_SendUssd(ParsingText* parsing, ZBL_CHANNEL_MSG_INFO **ppMsg)
{
    Token *pToken = NULL;
	atiUsatSendUssd* msg_ptr;
	
	ZTE_Trace(ZBL_AT, 0, "Parse_Zupci_SendUssd");
	*ppMsg = zblMallocChannelMsg(sizeof(atiUsatSendUssd));
    if(NULLPTR == *ppMsg)
    {
        zblAssert(0);
        return -1;
    }
    
    (*ppMsg)->msgId = ATI_STK_SEND_USSD_REQ;
    (*ppMsg)->msgSize = sizeof(atiUsatSendUssd);
	msg_ptr = (atiUsatSendUssd*)(*ppMsg)->msgData;
	if(NULL == msg_ptr)
	{
	    zblFreeChannelMsg(ppMsg);
	    return -1;
	}		
    memset(msg_ptr, 0, sizeof(atiUsatSendUssd));
    
    //<CmdNum>,<CmdQual>    
	//CmdNum
	pToken = GetParam(parsing);
	if(NULL == pToken)
	{
	    zblFreeChannelMsg(ppMsg);
	    return -1;
	}	
	g_stk_cmd_dtl.cmdNum = Str2Int(pToken->text);	
	
	//CmdQual
	pToken = GetParam(parsing);
	if(NULL == pToken)
	{
	    zblFreeChannelMsg(ppMsg);
        if (parsing->token.text)
        {
            free(parsing->token.text);
            parsing->token.text = NULLPTR;
        }
	    return -1;
	}		
	g_stk_cmd_dtl.cmdQual = Str2Int(pToken->text);	
	
	/*[<Alpha>],<Dcs>,<UssdStr>,[<IconWithDesc>,<IconId>][,<TxtAtr>]*/
	//Alpha
	if((parsing->offset < parsing->length)&&(',' == parsing->text[parsing->offset]))// 
    {
		parsing->offset++;
	}
	else
	{
	    pToken = GetParam(parsing);
    	if(NULL == pToken)
    	{
    	    zblFreeChannelMsg(ppMsg);

            if (parsing->token.text)
            {
                free(parsing->token.text);
                parsing->token.text = NULLPTR;
            }
    	    return -1;
    	}	    
		msg_ptr->alpha_st.alpha_presence = 1;
		decode90TextData(msg_ptr->alpha_st.alpha_a, ATI_USAT_MAX_LENGTH_ALPHA_ID, pToken->text);
	}	
	
	//<Dcs>,<UssdStr>
	if (',' == parsing->text[parsing->offset])
    {
        parsing->offset++;
    }   
    else
    {
	    pToken = GetParam(parsing);
		if(NULL == pToken  || 13 == pToken->text[0])
		{
		    zblFreeChannelMsg(ppMsg);
	        if (parsing->token.text)
	        {
	            free(parsing->token.text);
	            parsing->token.text = NULLPTR;
	        }
		    return -1;
		}	   
	    msg_ptr->ussd_st.alphabet = Str2Int(pToken->text);
    }
    //<UssdStr>
	if (',' == parsing->text[parsing->offset])
    {
        parsing->offset++;
    }   
    else
    {
        pToken = GetParam(parsing);
        if(NULL == pToken )
        {
    	    zblFreeChannelMsg(ppMsg);
            if (parsing->token.text)
            {
                free(parsing->token.text);
                parsing->token.text = NULLPTR;
            }
    	    return -1;
        }
    	memcpy(&msg_ptr->ussd_st.text_a, pToken->text, ATI_USAT_SEND_USS_STRING_LENGTH);
    }

    //<IconWithDesc>,<IconId> or [,<TxtAtr>]	
	if(parsing->offset >= parsing->length)
    {
        if (parsing->token.text)
        {
            free(parsing->token.text);
            parsing->token.text = NULLPTR;
        }
    	return 0;
    }   
	if (',' == parsing->text[parsing->offset])
    {
        parsing->offset++;
    }   
    else
    {	
		pToken = GetParam(parsing);
		if(NULL == pToken)
		{
		    zblFreeChannelMsg(ppMsg);
	        if (parsing->token.text)
	        {
	            free(parsing->token.text);
	            parsing->token.text = NULLPTR;
	        }
		    return -1;
		}	  		
        //IconWithDesc
		msg_ptr->icon_st.self_explanatory = Str2Int(pToken->text);
    }

    if (',' == parsing->text[parsing->offset])
    {
        parsing->offset++;
        msg_ptr->icon_st.id = 0xff;
    } 
	else  //в
	{
			//IconId
		    pToken = GetParam(parsing);
        	if(NULL == pToken)
        	{
        	    zblFreeChannelMsg(ppMsg);
                if (parsing->token.text)
                {
                    free(parsing->token.text);
                    parsing->token.text = NULLPTR;
                }
        	    return -1;
        	}	  			    
			msg_ptr->icon_st.id = Str2Int(pToken->text);
	}
    if (parsing->token.text)
    {
        free(parsing->token.text);
        parsing->token.text = NULLPTR;
    }
	return 0;	
}

SINT32 Parse_Zupci_PlocInfo(ParsingText* parsing, ZBL_CHANNEL_MSG_INFO **ppMsg)
{
    Token *pToken = NULL;
	UINT8 *msg_ptr;
	
	ZTE_Trace(ZBL_AT, 0, "Parse_Zupci_PlocInfo");
	*ppMsg = zblMallocChannelMsg(sizeof(UINT8));
    if(NULLPTR == *ppMsg)
    {
        zblAssert(0);
        return -1;
    }
    
    (*ppMsg)->msgId = ATI_STK_LOCAL_INFO_IND;
    (*ppMsg)->msgSize = sizeof(UINT8);
	msg_ptr = (UINT8*)(*ppMsg)->msgData;
	if(NULL == msg_ptr)
	{
	    zblFreeChannelMsg(ppMsg);
	    return -1;
	}		
    memset(msg_ptr, 0, sizeof(UINT8));
	/*<CmdNum>,<CmdQual>]*/
	//CmdNum
	pToken = GetParam(parsing);
	if(NULL == pToken)
	{
	    zblFreeChannelMsg(ppMsg);
        if (parsing->token.text)
        {
            free(parsing->token.text);
            parsing->token.text = NULLPTR;
        }
	    return -1;
	}	
	g_stk_cmd_dtl.cmdNum = Str2Int(pToken->text);	
	//CmdQual
	pToken = GetParam(parsing);
	if(NULL == pToken)
	{
	    zblFreeChannelMsg(ppMsg);
        if (parsing->token.text)
        {
            free(parsing->token.text);
            parsing->token.text = NULLPTR;
        }
	    return -1;
	}	
	g_stk_cmd_dtl.cmdQual = Str2Int(pToken->text);	
    *msg_ptr = g_stk_cmd_dtl.cmdQual;
    
    if (parsing->token.text)
    {
        free(parsing->token.text);
        parsing->token.text = NULLPTR;
    }
	return 0;
}
SINT32 Parse_Zupci_TimerMng(ParsingText* parsing, ZBL_CHANNEL_MSG_INFO **ppMsg)
{
    Token *pToken = NULL;
    atiUsatTimerManagement *msg_ptr;
    SINT32 taduLen = 0;
	
	ZTE_Trace(ZBL_AT, 0, "Parse_Zupci_TimerMng");
	*ppMsg = zblMallocChannelMsg(sizeof(atiUsatTimerManagement));
    if(NULLPTR == *ppMsg)
    {
        zblAssert(0);
        return -1;
    }
    
    (*ppMsg)->msgId = ATI_STK_TIMER_MANAGEMENT_IND;
    (*ppMsg)->msgSize = sizeof(atiUsatTimerManagement);
	msg_ptr = (atiUsatTimerManagement*)(*ppMsg)->msgData;
	if(NULL == msg_ptr)
	{
	    zblFreeChannelMsg(ppMsg);
	    return -1;
	}		
      memset(msg_ptr, 0, sizeof(atiUsatTimerManagement));
	//<CmdNum>,<CmdQual>,<TimerId>[,<TimerVal>]
	//CmdNum
	pToken = GetParam(parsing);
	if(NULL == pToken)
	{
	    zblFreeChannelMsg(ppMsg);
        if (parsing->token.text)
        {
            free(parsing->token.text);
            parsing->token.text = NULLPTR;
        }
	    return -1;
	}	
	g_stk_cmd_dtl.cmdNum = Str2Int(pToken->text);	
	//CmdQual
	pToken = GetParam(parsing);
	if(NULL == pToken)
	{
	    zblFreeChannelMsg(ppMsg);
        if (parsing->token.text)
        {
            free(parsing->token.text);
            parsing->token.text = NULLPTR;
        }
	    return -1;
	}	
	g_stk_cmd_dtl.cmdQual = Str2Int(pToken->text);	

    
    if((g_stk_cmd_dtl.cmdQual & (0x01)) &&(!(g_stk_cmd_dtl.cmdQual & (0x01<<STK_BIT_1))))
    {
        msg_ptr->operation = ZBL_USAT_TIMER_MAN_CURRENT_VAL;            
	}  
    else if((!(g_stk_cmd_dtl.cmdQual & (0x01))) &&(!(g_stk_cmd_dtl.cmdQual & (0x01<<STK_BIT_1))))
    {
        msg_ptr->operation = ZBL_USAT_TIMER_MAN_START;            
	}
    else if((!(g_stk_cmd_dtl.cmdQual & (0x01))) &&(g_stk_cmd_dtl.cmdQual & (0x01<<STK_BIT_1)))
    {
        msg_ptr->operation = ZBL_USAT_TIMER_MAN_DEACTIVE;            
	}
    
	//TimerId
	pToken = GetParam(parsing);
	if(NULL == pToken)
	{
	    zblFreeChannelMsg(ppMsg);
        if (parsing->token.text)
        {
            free(parsing->token.text);
            parsing->token.text = NULLPTR;
        }
	    return -1;
	}	
	msg_ptr->timer = Str2Int(pToken->text);	
	//TimerVal
	if(parsing->offset >= parsing->length)
    {
        if (parsing->token.text)
        {
            free(parsing->token.text);
            parsing->token.text = NULLPTR;
        }
    	return 0;
    }   
	if(',' == parsing->text[parsing->offset])// [<TimerVal>]
    {
		parsing->offset++;
	}
	else
	{
	    pToken = GetParam(parsing);
    	if(NULL == pToken)
    	{
    	    zblFreeChannelMsg(ppMsg);
            if (parsing->token.text)
            {
                free(parsing->token.text);
                parsing->token.text = NULLPTR;
            }
    	    return -1;
    	}	    
        {
            UINT8 temStr[3] = {0}; 
            memcpy(&temStr, pToken->text, 2);
            msg_ptr->hour = Str2Int((CHAR*)temStr);	
            
            memset(&temStr, 0, 3);
            memcpy(&temStr, pToken->text +2, 2);
            msg_ptr->minute = Str2Int((CHAR*)temStr);	
            
            memset(&temStr, 0, 3);
            memcpy(&temStr, pToken->text +2, 2);
            msg_ptr->second = Str2Int((CHAR*)temStr);	
        }

	}	
    if (parsing->token.text)
    {
        free(parsing->token.text);
        parsing->token.text = NULLPTR;
    }
	return 0;
}
SINT32 Parse_Zupci_OpenChnl(ParsingText* parsing, ZBL_CHANNEL_MSG_INFO **ppMsg)
{
    Token *pToken = NULL;
	atiUsatOpenCsChl *msg_ptr;
	
	ZTE_Trace(ZBL_AT, 0, "Parse_Zupci_OpenChnl");
	*ppMsg = zblMallocChannelMsg(sizeof(atiUsatOpenCsChl));
    if(NULLPTR == *ppMsg)
    {
        zblAssert(0);
        return -1;
    }
    
    (*ppMsg)->msgId = ATI_STK_OPEN_CS_CHL_REQ;
    (*ppMsg)->msgSize = sizeof(atiUsatOpenCsChl);
	msg_ptr = (atiUsatOpenCsChl*)(*ppMsg)->msgData;
	if(NULL == msg_ptr)
	{
	    zblFreeChannelMsg(ppMsg);
	    return -1;
	}		
    memset(msg_ptr, 0, sizeof(atiUsatOpenCsChl));
	/*   <CmdNum>,<CmdQual>,[<Alpha>],[<IconWithDesc>],[<IconId>],<Ton>,<NPI>,<CallNum>,
	[<subaddr>],[<TimeUnit1>],[<TimeFreq1>],[<TimeUnit2>],[<TimeFreq2>],<BearType>,<Param>,<BufSize>
	[,AcessName
	    [,<OadrType>,<Oadr>
	        [,<LoginCodeMode>,<LoginTxt>
	            [,<PswdCodeMode>,<PswdTxt>
	                [,<PortNum>,<TranProType>
	                    [,<DataAdrType>,<DataAdr>
	                        [ ,<CodeType>,<RemAdr>[,<TxtAtr>]
	                        ]
	                    ]
	                ]
	            ]
	         ]
	     ]
	 ] */
	
	//CmdNum
	pToken = GetParam(parsing);
	if(NULL == pToken)
	{
	    zblFreeChannelMsg(ppMsg);
        if (parsing->token.text)
        {
            free(parsing->token.text);
            parsing->token.text = NULLPTR;
        }
		ZTE_Trace(ZBL_AT, 0, "Parse_Zupci_OpenChnl, NULL == CmdNum");
	    return -1;
	}	
	g_stk_cmd_dtl.cmdNum = Str2Int(pToken->text);	
	ZTE_Trace(ZBL_AT, 0, "Parse_Zupci_OpenChnl, CmdNum = %d", g_stk_cmd_dtl.cmdNum);
	//CmdQual
	pToken = GetParam(parsing);
	if(NULL == pToken)
	{
	    zblFreeChannelMsg(ppMsg);
        if (parsing->token.text)
        {
            free(parsing->token.text);
            parsing->token.text = NULLPTR;
        }
		ZTE_Trace(ZBL_AT, 0, "Parse_Zupci_OpenChnl, NULL == CmdQual");
	    return -1;
	}	
	g_stk_cmd_dtl.cmdQual = Str2Int(pToken->text);	
    msg_ptr->immediate_link = g_stk_cmd_dtl.cmdQual & (0x01);
    msg_ptr->auto_reconnecte = g_stk_cmd_dtl.cmdQual & (0x01<<STK_BIT_1);
    msg_ptr->background = g_stk_cmd_dtl.cmdQual & (0x01<<STK_BIT_2);
	ZTE_Trace(ZBL_AT, 0, "Parse_Zupci_OpenChnl, g_stk_cmd_dtl.cmdQual = %d", g_stk_cmd_dtl.cmdQual);
    //[<Alpha>]
	if((parsing->offset < parsing->length)&&(',' == parsing->text[parsing->offset]))//
    {
		parsing->offset++;
		ZTE_Trace(ZBL_AT, 0, "Parse_Zupci_OpenChnl, [<Alpha>]++");
	}
	else
	{
	    pToken = GetParam(parsing);
    	if(NULL == pToken)
    	{
    	    zblFreeChannelMsg(ppMsg);
            if (parsing->token.text)
            {
                free(parsing->token.text);
                parsing->token.text = NULLPTR;
            }
			ZTE_Trace(ZBL_AT, 0, "Parse_Zupci_OpenChnl, Alpha");
    	    return -1;
    	}	    
		msg_ptr->alpha_st.alpha_presence = 1;
		decode90TextData(msg_ptr->alpha_st.alpha_a, ATI_USAT_MAX_LENGTH_ALPHA_ID, pToken->text);
	}
    //[<IconWithDesc>]
	if((parsing->offset < parsing->length)&&(',' == parsing->text[parsing->offset])) 
    {
		parsing->offset++;
	}
	else
	{
    	pToken = GetParam(parsing);
    	if(NULL == pToken)
    	{
    	    zblFreeChannelMsg(ppMsg);
            if (parsing->token.text)
            {
                free(parsing->token.text);
                parsing->token.text = NULLPTR;
            }
    	    return -1;
    	}
    	msg_ptr->icon_st.self_explanatory = Str2Int(pToken->text);            
	}
    
    //[<IconId>],
	if((parsing->offset < parsing->length)&&(',' == parsing->text[parsing->offset])) 
    {
		parsing->offset++;
        msg_ptr->icon_st.id = 0xff;
	}
	else
    {   
	    pToken = GetParam(parsing);
        if(NULL == pToken)
	    {
            if (parsing->token.text)
            {
                free(parsing->token.text);
                msg_ptr->icon_st.id = 0xff;
                parsing->token.text = NULLPTR;
            }
    	    zblFreeChannelMsg(ppMsg);
    	    return -1;
	    }
		msg_ptr->icon_st.id = Str2Int(pToken->text);
    }
    //<Ton>,<NPI>,<CallNum>    
	if(',' == parsing->text[parsing->offset]) 
    {
		parsing->offset++;
	}
	else
	{
    	pToken = GetParam(parsing);
    }
	if(',' == parsing->text[parsing->offset]) 
    {
		parsing->offset++;
	}
	else
	{
    	pToken = GetParam(parsing);
    }
    if(',' == parsing->text[parsing->offset]) 
    {
		parsing->offset++;
	}
    else
    {
    	pToken = GetParam(parsing);
    	if(NULL == pToken)
    	{
    	    zblFreeChannelMsg(ppMsg);
            if (parsing->token.text)
            {
                free(parsing->token.text);
                parsing->token.text = NULLPTR;
            }
			ZTE_Trace(ZBL_AT, 0, "Parse_Zupci_OpenChnl, NULL == <Ton>,<NPI>,<CallNum>");
    	    return -1;
    	}
        memcpy(msg_ptr->addr_a, pToken->text, ATI_MAX_PHONE_NUM_LENGTH);
    }
    
	
    //[<subaddr>]
	if((parsing->offset < parsing->length)&&(',' == parsing->text[parsing->offset]))
    {
		parsing->offset++;
		ZTE_Trace(ZBL_AT, 0, "Parse_Zupci_OpenChnl, [<subaddr>]++");
	}
	else
	{
    	pToken = GetParam(parsing);
    	if(NULL == pToken)
    	{
    	    zblFreeChannelMsg(ppMsg);
            if (parsing->token.text)
            {
                free(parsing->token.text);
                parsing->token.text = NULLPTR;
            }
			ZTE_Trace(ZBL_AT, 0, "Parse_Zupci_OpenChnl, NULL == [<subaddr>]");
    	    return -1;
    	}
        memcpy(msg_ptr->subaddr_st.subaddr_a, pToken->text, ATI_USAT_SUBADDR_NUM_MAX);
		ZTE_Trace(ZBL_AT, 0, "Parse_Zupci_OpenChnl, subaddr pToken->text = %s", pToken->text);
	}
    //<TimeUnit1>,<TimeFreq1>
	if(',' == parsing->text[parsing->offset]) 
    {
    	ZTE_Trace(ZBL_AT, 0, "Parse_Zupci_OpenChnl,TimeUnit1++");
		parsing->offset++;
	}
	else
	{
	    pToken = GetParam(parsing);
    }
    if(',' == parsing->text[parsing->offset]) 
    {
        parsing->offset++;
	}
	else
	{
		if(pToken)
        msg_ptr->duration1= stkDecodeDuration(parsing, pToken->text);  
    }
    //<TimeUnit2>,<TimeFreq2>
	if(',' == parsing->text[parsing->offset]) 
    {
    	ZTE_Trace(ZBL_AT, 0, "Parse_Zupci_OpenChnl,TimeUnit2++");
		parsing->offset++;
	}
	else
	{
	    pToken = GetParam(parsing);
    }
    if(',' == parsing->text[parsing->offset]) 
    {
        parsing->offset++;
	}
	else
	{
		if(pToken)
        msg_ptr->duration2= stkDecodeDuration(parsing, pToken->text);  
    }
    //beartype
	if(',' == parsing->text[parsing->offset]) 
    {
		parsing->offset++;
	}
    else
    {
	    pToken = GetParam(parsing);    
		if(NULL == pToken)
		{
		    zblFreeChannelMsg(ppMsg);
	        if (parsing->token.text)
	        {
	            free(parsing->token.text);
	            parsing->token.text = NULLPTR;
	        }
			ZTE_Trace(ZBL_AT, 0, "Parse_Zupci_OpenChnl, NULL == beartype");
		    return -1;
		}	
		msg_ptr->bearer_type = Str2Int(pToken->text);
		ZTE_Trace(ZBL_AT, 0, "Parse_Zupci_OpenChnl, msg_ptr->bearer_type = %d", msg_ptr->bearer_type);
		if(msg_ptr->bearer_type == 2)
		{
			(*ppMsg)->msgId = ATI_STK_OPEN_PS_CHL_REQ;
		}
	}
    //Param
    if(',' == parsing->text[parsing->offset]) 
    {
		parsing->offset++;
	}
    else
    {
	    pToken = GetParam(parsing);    
		if(NULL == pToken)
		{
		    zblFreeChannelMsg(ppMsg);
	        if (parsing->token.text)
	        {
	            free(parsing->token.text);
	            parsing->token.text = NULLPTR;
	        }
			ZTE_Trace(ZBL_AT, 0, "Parse_Zupci_OpenChnl, NULL == Param");
		    return -1;
		}	
		memcpy(msg_ptr->bearer_param, pToken->text, 3);
    }
    //BufSize
    if(',' == parsing->text[parsing->offset]) 
    {
		parsing->offset++;
	}
    else
    {
	    pToken = GetParam(parsing);    
		if(NULL == pToken)
		{
		    zblFreeChannelMsg(ppMsg);
	        if (parsing->token.text)
	        {
	            free(parsing->token.text);
	            parsing->token.text = NULLPTR;
	        }
			ZTE_Trace(ZBL_AT, 0, "Parse_Zupci_OpenChnl, NULL == BufSize");
		    return -1;
		}	
		memcpy(msg_ptr->buffer_size, pToken->text, 2);
    }
    //AcessName
    if (parsing->offset >= parsing->length)
    {
        goto openchanlend;
    }
	if(',' == parsing->text[parsing->offset]) 
    {
		parsing->offset++;
	}
	else
	{
        pToken = GetParam(parsing); 
	}
    //[<AdrType>,<Adr>]
    if (parsing->offset >= parsing->length)
    {
        goto openchanlend;
    }
    if(',' == parsing->text[parsing->offset]) 
    {
		parsing->offset++;
	}
    else
    {
	    pToken = GetParam(parsing);    
    	if(NULL == pToken)
    	{
    	    zblFreeChannelMsg(ppMsg);
            if (parsing->token.text)
            {
                free(parsing->token.text);
                parsing->token.text = NULLPTR;
            }
			ZTE_Trace(ZBL_AT, 0, "Parse_Zupci_OpenChnl, NULL == AdrType");
    	    return -1;
    	}	
        msg_ptr->local_addr.type= Str2Int(pToken->text);	 
    }
    if(',' == parsing->text[parsing->offset]) 
    {
		parsing->offset++;
	}
	else
	{ 
        pToken = GetParam(parsing);
        if(NULL == pToken)
    	{
    	    zblFreeChannelMsg(ppMsg);
            if (parsing->token.text)
            {
                free(parsing->token.text);
                parsing->token.text = NULLPTR;
            }
			ZTE_Trace(ZBL_AT, 0, "Parse_Zupci_OpenChnl, NULL == Adr");
    	    return -1;
    	}
	    memcpy(msg_ptr->local_addr.address, pToken->text, ATI_USAT_MAX_IP_ADDRESS_LEN);
    }
    //[< LoginCodeMode>,<LoginTxt>]
    if (parsing->offset >= parsing->length)
    {
        goto openchanlend;
    }
    if(',' == parsing->text[parsing->offset]) 
    {
		parsing->offset++;
	}
    else
    {
	    pToken = GetParam(parsing);    
    	if(NULL == pToken)
    	{
    	    zblFreeChannelMsg(ppMsg);
            if (parsing->token.text)
            {
                free(parsing->token.text);
                parsing->token.text = NULLPTR;
            }
			ZTE_Trace(ZBL_AT, 0, "Parse_Zupci_OpenChnl, NULL == LoginCodeMode");
    	    return -1;
    	}	
        msg_ptr->login_text_st.alphabet= zblStkGetCodeType(Str2Int(pToken->text));
    }
    if(',' == parsing->text[parsing->offset]) 
    {
		parsing->offset++;
	}
	else
	{ 
		pToken = GetParam(parsing);
		if(NULL == pToken)
    	{
    	    zblFreeChannelMsg(ppMsg);
            if (parsing->token.text)
            {
                free(parsing->token.text);
                parsing->token.text = NULLPTR;
            }
			ZTE_Trace(ZBL_AT, 0, "Parse_Zupci_OpenChnl, NULL == LoginTxt");
    	    return -1;
    	}
    	memcpy(msg_ptr->login_text_st.text_a, pToken->text, ATI_USAT_MAX_LENGTH_LONG_TEXT_STRING);
    }
    
    //[<PswdCodeMode>,<PswdTxt>]
    if (parsing->offset >= parsing->length)
    {
        goto openchanlend;
    }
    //[<PswdCodeMode>,<PswdTxt>]
    if(',' == parsing->text[parsing->offset]) 
    {
		parsing->offset++;
	}
    else
    {
	    pToken = GetParam(parsing);    
    	if(NULL == pToken)
    	{
    	    zblFreeChannelMsg(ppMsg);
            if (parsing->token.text)
            {
                free(parsing->token.text);
                parsing->token.text = NULLPTR;
            }
			ZTE_Trace(ZBL_AT, 0, "Parse_Zupci_OpenChnl, NULL == PswdCodeMode");
    	    return -1;
    	}	
        msg_ptr->pw_text_st.alphabet= zblStkGetCodeType(Str2Int(pToken->text));
    }
    
    if(',' == parsing->text[parsing->offset]) 
    {
		parsing->offset++;
	}
	else
	{         
		pToken = GetParam(parsing);
		if(NULL == pToken)
    	{
    	    zblFreeChannelMsg(ppMsg);
            if (parsing->token.text)
            {
                free(parsing->token.text);
                parsing->token.text = NULLPTR;
            }
			ZTE_Trace(ZBL_AT, 0, "Parse_Zupci_OpenChnl, NULL == PswdTxt");
    	    return -1;
    	}
    	memcpy(msg_ptr->pw_text_st.text_a, pToken->text, ATI_USAT_MAX_LENGTH_LONG_TEXT_STRING);
	}
        
    //[<PortNum>,<TranProType>[,<DataAdrType>,<DataAdr>[ ,<CodeType>,<RemAdr>[,<TxtAtr>]]]]]]]]
    if (parsing->offset >= parsing->length)
    {
        goto openchanlend;
    }
    if(',' == parsing->text[parsing->offset]) 
    {
		parsing->offset++;
	}
    else
    {
		pToken = GetParam(parsing);
		if(NULL == pToken)
		{
		    zblFreeChannelMsg(ppMsg);
	        if (parsing->token.text)
	        {
	            free(parsing->token.text);
	            parsing->token.text = NULLPTR;
	        }
			ZTE_Trace(ZBL_AT, 0, "Parse_Zupci_OpenChnl, NULL == PortNum");
		    return -1;
		}	
		
		memcpy(msg_ptr->port, pToken->text, 2);
	}
		
	if(',' == parsing->text[parsing->offset]) //[,<TranProType>]
	{
        parsing->offset++;
	}
	else
	{
		pToken = GetParam(parsing);  
        if(NULL == pToken)
    	{
    	    zblFreeChannelMsg(ppMsg);
            if (parsing->token.text)
            {
                free(parsing->token.text);
                parsing->token.text = NULLPTR;
            }
    		ZTE_Trace(ZBL_AT, 0, "Parse_Zupci_OpenChnl, NULL == TranProType");
    	    return -1;
    	}
        msg_ptr->tp_type= Str2Int(pToken->text);
	}
	
    //[,<CodeType>,<RemAdr>]
    if (parsing->offset >= parsing->length)
    {
        goto openchanlend;
    }
    if (',' == parsing->text[parsing->offset])
    {
        parsing->offset++;
    }
    else
    {
		pToken = GetParam(parsing);
		if(NULL == pToken)
		{
		    zblFreeChannelMsg(ppMsg);
	        if (parsing->token.text)
	        {
	            free(parsing->token.text);
	            parsing->token.text = NULLPTR;
	        }
			ZTE_Trace(ZBL_AT, 0, "Parse_Zupci_OpenChnl, NULL == CodeType");
		    return -1;
		}	
	    msg_ptr->data_destination_addr.type = Str2Int(pToken->text);
    }
	if(',' == parsing->text[parsing->offset]) 
	{
        parsing->offset++;
	}
    else
	{
        pToken = GetParam(parsing);
        if(NULL == pToken)
        {
            zblFreeChannelMsg(ppMsg);
            if (parsing->token.text)
            {
                free(parsing->token.text);
                parsing->token.text = NULLPTR;
            }
            ZTE_Trace(ZBL_AT, 0, "Parse_Zupci_OpenChnl, NULL == RemAdr");
            return -1;
        }
        memcpy(msg_ptr->data_destination_addr.address, pToken->text, ATI_USAT_MAX_IP_ADDRESS_LEN);
	}
   
openchanlend:
    if (parsing->token.text)
    {
        free(parsing->token.text);
        parsing->token.text = NULLPTR;
    }
	return 0;
}

SINT32 Parse_Zupci_RecvData(ParsingText* parsing, ZBL_CHANNEL_MSG_INFO **ppMsg)
{
    Token *pToken = NULL;
    atiUsatReceiveData* msg_ptr;
   
    ZTE_Trace(ZBL_AT, 0, "Parse_Zupci_RecvData");
    *ppMsg = zblMallocChannelMsg(sizeof(atiUsatReceiveData));
    if(NULLPTR == *ppMsg)
    {
        zblAssert(0);
        return -1;
    }
    
    (*ppMsg)->msgId = ATI_STK_RECEIVE_DATA_REQ;
    (*ppMsg)->msgSize = sizeof(atiUsatReceiveData);
    msg_ptr = (atiUsatReceiveData*)(*ppMsg)->msgData;
    if(NULL == msg_ptr)
    {
        zblFreeChannelMsg(ppMsg);
        return -1;
    }		
    memset(msg_ptr, 0, sizeof(atiUsatReceiveData));
    
    //<CmdNum>,<CmdQual>    
	//CmdNum
	pToken = GetParam(parsing);
	if(NULL == pToken)
	{
	    zblFreeChannelMsg(ppMsg);
	    return -1;
	}	
	g_stk_cmd_dtl.cmdNum = Str2Int(pToken->text);	
	
	//CmdQual
	pToken = GetParam(parsing);
	if(NULL == pToken)
	{
	    zblFreeChannelMsg(ppMsg);
        if (parsing->token.text)
        {
            free(parsing->token.text);
            parsing->token.text = NULLPTR;
        }
	    return -1;
	}		
	g_stk_cmd_dtl.cmdQual = Str2Int(pToken->text);	
    
	//[<Alpha>],[<IconWithDesc>,<IconId>],<DataLen>[,<TxtAtr>]
	//Alpha
	if((parsing->offset < parsing->length)&&(',' == parsing->text[parsing->offset]))// 
    {
		parsing->offset++;
	}
	else
	{
	    pToken = GetParam(parsing);
    	if(NULL == pToken)
    	{
    	    zblFreeChannelMsg(ppMsg);

            if (parsing->token.text)
            {
                free(parsing->token.text);
                parsing->token.text = NULLPTR;
            }
    	    return -1;
    	}	    
		msg_ptr->alpha_st.alpha_presence = 1;
		decode90TextData(msg_ptr->alpha_st.alpha_a, ATI_USAT_MAX_LENGTH_ALPHA_ID, pToken->text);
	}	
	
	//[<IconWithDesc>,<IconId>]
	if((parsing->offset < parsing->length)&&(',' == parsing->text[parsing->offset]))// 
    {
		parsing->offset++;
	}
	else
	{
		pToken = GetParam(parsing);
    	if(NULL == pToken)
    	{
    	    zblFreeChannelMsg(ppMsg);
            if (parsing->token.text)
            {
                free(parsing->token.text);
                parsing->token.text = NULLPTR;
            }
    	    return -1;
    	}	  
		//IconWithDesc
		msg_ptr->icon_st.self_explanatory = Str2Int(pToken->text);
    }

	//[<IconId>]
    if((parsing->offset < parsing->length)&&(',' == parsing->text[parsing->offset]))// 
    {
		parsing->offset++;
		msg_ptr->icon_st.id = 0xff;
	}
	else
	{
	    pToken = GetParam(parsing);
    	if(NULL == pToken)
    	{
    	    zblFreeChannelMsg(ppMsg);

            if (parsing->token.text)
            {
                free(parsing->token.text);
                parsing->token.text = NULLPTR;
            }
    	    return -1;
    	}	  			    
		msg_ptr->icon_st.id = Str2Int(pToken->text);
     }
    
    //<DataLen>	
	pToken = GetParam(parsing);
	if(NULL == pToken)
	{
	    zblFreeChannelMsg(ppMsg);
        if (parsing->token.text)
        {
            free(parsing->token.text);
            parsing->token.text = NULLPTR;
        }
	    return -1;
	}	  		
    msg_ptr->channel_data_len =  Str2Int(pToken->text);

    if (parsing->token.text)
    {
        free(parsing->token.text);
        parsing->token.text = NULLPTR;
    }
	return 0;	
}

SINT32 Parse_Zupci_SendData(ParsingText* parsing, ZBL_CHANNEL_MSG_INFO **ppMsg)
{
    Token *pToken = NULL;
    atiUsatSendData* msg_ptr;
   
    ZTE_Trace(ZBL_AT, 0, "Parse_Zupci_SendData");
    *ppMsg = zblMallocChannelMsg(sizeof(atiUsatSendData));
    if(NULLPTR == *ppMsg)
    {
        zblAssert(0);
        return -1;
    }
    
    (*ppMsg)->msgId = ATI_STK_SEND_DATA_REQ;
    (*ppMsg)->msgSize = sizeof(atiUsatSendData);
    msg_ptr = (atiUsatSendData*)(*ppMsg)->msgData;
    if(NULL == msg_ptr)
    {
        zblFreeChannelMsg(ppMsg);
        return -1;
    }		
    memset(msg_ptr, 0, sizeof(atiUsatSendData));
    
    /*<CmdNum>,<CmdQual>,<DesDevID>,
    [<Alpha>],[<IconWithDesc>],[<IconId>],
    <ChnlData>[,<TxtAtr>] */  
	//CmdNum
	pToken = GetParam(parsing);
	if(NULL == pToken)
	{
	    zblFreeChannelMsg(ppMsg);
	    return -1;
	}	
	g_stk_cmd_dtl.cmdNum = Str2Int(pToken->text);	
	
	//CmdQual
	pToken = GetParam(parsing);
	if(NULL == pToken)
	{
	    zblFreeChannelMsg(ppMsg);
        if (parsing->token.text)
        {
            free(parsing->token.text);
            parsing->token.text = NULLPTR;
        }
	    return -1;
	}		
	g_stk_cmd_dtl.cmdQual = Str2Int(pToken->text);	
    
	//<DesDevID>,[<Alpha>],[<IconWithDesc>,<IconId>],<ChnlData>[,<TxtAtr>]
	//DesDevID
	pToken = GetParam(parsing);
	if(NULL == pToken)
	{
	    zblFreeChannelMsg(ppMsg);
        if (parsing->token.text)
        {
            free(parsing->token.text);
            parsing->token.text = NULLPTR;
        }
	    return -1;
	}	  		
    msg_ptr->channel_id = Str2Int(pToken->text);
	//Alpha
	if((parsing->offset < parsing->length)&&(',' == parsing->text[parsing->offset]))// 
    {
		parsing->offset++;
	}
	else
	{
	    pToken = GetParam(parsing);
    	if(NULL == pToken)
    	{
    	    zblFreeChannelMsg(ppMsg);

            if (parsing->token.text)
            {
                free(parsing->token.text);
                parsing->token.text = NULLPTR;
            }
    	    return -1;
    	}	    
		msg_ptr->alpha_st.alpha_presence = 1;
		decode90TextData(msg_ptr->alpha_st.alpha_a, ATI_USAT_MAX_LENGTH_ALPHA_ID, pToken->text);
	}	
	
	//[<IconWithDesc>,<IconId>]
	if((parsing->offset < parsing->length)&&(',' == parsing->text[parsing->offset]))// 
    {
		parsing->offset++;
	}
	else
	{
		//IconWithDesc
		pToken = GetParam(parsing);
    	if(NULL == pToken)
    	{
    	    zblFreeChannelMsg(ppMsg);
            if (parsing->token.text)
            {
                free(parsing->token.text);
                parsing->token.text = NULLPTR;
            }
    	    return -1;
    	}	  
		//IconWithDesc
		msg_ptr->icon_st.self_explanatory = Str2Int(pToken->text);
    }

	//IconId
    if((parsing->offset < parsing->length)&&(',' == parsing->text[parsing->offset]))// 
    {
		parsing->offset++;
		msg_ptr->icon_st.id = 0xff;
	}
	else
	{
	    pToken = GetParam(parsing);
    	if(NULL == pToken)
    	{
    	    zblFreeChannelMsg(ppMsg);

            if (parsing->token.text)
            {
                free(parsing->token.text);
                parsing->token.text = NULLPTR;
            }
    	    return -1;
    	}	  			    
		msg_ptr->icon_st.id = Str2Int(pToken->text);
     }
    
    //<ChnlData>[,<TxtAtr>]
	pToken = GetParam(parsing);
	if(NULL == pToken)
	{
	    zblFreeChannelMsg(ppMsg);
        if (parsing->token.text)
        {
            free(parsing->token.text);
            parsing->token.text = NULLPTR;
        }
	    return -1;
	}	  		
    memcpy(&msg_ptr->channel_data, pToken->text, ATI_USAT_MAX_CHANNEL_DATA_LEN);

    if (parsing->token.text)
    {
        free(parsing->token.text);
        parsing->token.text = NULLPTR;
    }
	return 0;	
}          
           
SINT32 Parse_Zupci_GetChlStatus(ParsingText* parsing, ZBL_CHANNEL_MSG_INFO **ppMsg)
{   
    Token *pToken = NULLPTR;
	UINT8 *msg_ptr = NULLPTR;
	SINT32 iLen = sizeof(UINT8);
	
	ZTE_Trace(ZBL_AT, 0, "Parse_Zupci_GetChlStatus");

	*ppMsg = zblMallocChannelMsg(iLen);
    if(NULLPTR == *ppMsg)
    {
        zblAssert(0);
        return -1;
    }
    (*ppMsg)->msgId = ATI_STK_GET_CHL_STATUS_REQ;
    (*ppMsg)->msgSize = iLen;
	
	msg_ptr = (UINT8*)(*ppMsg)->msgData;
	if(NULL == msg_ptr)
	{
	    zblFreeChannelMsg(ppMsg);
	    return -1;
	}		
	memset(msg_ptr, 0, iLen);

    //<CmdNum>,<CmdQual>    
	//CmdNum
	pToken = GetParam(parsing);
	if(NULL == pToken)
	{
	    zblFreeChannelMsg(ppMsg);
	    return -1;
	}	
	g_stk_cmd_dtl.cmdNum = Str2Int(pToken->text);	
	
	//CmdQual
	pToken = GetParam(parsing);
	if(NULL == pToken)
	{
	    zblFreeChannelMsg(ppMsg);
        if (parsing->token.text)
        {
            free(parsing->token.text);
            parsing->token.text = NULLPTR;
        }
	    return -1;
	}		
	g_stk_cmd_dtl.cmdQual = Str2Int(pToken->text);	
	pToken = GetParam(parsing);
    pToken = GetParam(parsing);
	if(NULL == pToken)
	{
	    zblFreeChannelMsg(ppMsg);
        if (parsing->token.text)
        {
            free(parsing->token.text);
            parsing->token.text = NULLPTR;
        }
	    return -1;
	}	
    *msg_ptr = Str2Int(pToken->text);
    if (parsing->token.text)
    {
        free(parsing->token.text);
        parsing->token.text = NULLPTR;
    }
	return 0;	
}
SINT32 Parse_Zupci_Refresh(ParsingText* parsing, ZBL_CHANNEL_MSG_INFO **ppMsg)
{   
    Token *pToken = NULLPTR;
	atiUsatRefresh *msg_ptr = NULLPTR;
	SINT32 iLen = sizeof(atiUsatRefresh);
	
	ZTE_Trace(ZBL_AT, 0, "Parse_Zupci_Refresh");

	*ppMsg = zblMallocChannelMsg(iLen);
    if(NULLPTR == *ppMsg)
    {
        zblAssert(0);
        return -1;
    }
    (*ppMsg)->msgId = ATI_STK_REFRESH_REQ;
    (*ppMsg)->msgSize = iLen;
	
	msg_ptr = (atiUsatRefresh*)(*ppMsg)->msgData;
	if(NULL == msg_ptr)
	{
	    zblFreeChannelMsg(ppMsg);
	    return -1;
	}		
	memset(msg_ptr, 0, iLen);

    //<CmdNum>,<CmdQual>,[<Aid>][,<FileNum>,<Fid>]
	//CmdNum
	pToken = GetParam(parsing);
	if(NULL == pToken)
	{
	    zblFreeChannelMsg(ppMsg);
	    return -1;
	}	
	g_stk_cmd_dtl.cmdNum = Str2Int(pToken->text);	
	
	//CmdQual
	pToken = GetParam(parsing);
	if(NULL == pToken)
	{
	    zblFreeChannelMsg(ppMsg);
        if (parsing->token.text)
        {
            free(parsing->token.text);
            parsing->token.text = NULLPTR;
        }
	    return -1;
	}		
	g_stk_cmd_dtl.cmdQual = Str2Int(pToken->text);	
    msg_ptr->operation = g_stk_cmd_dtl.cmdQual;        

    if(ATI_USAT_REF_FILE_CHANGE == msg_ptr->operation || ATI_USAT_REF_INIT_AND_FILE_CHA == msg_ptr->operation || ATI_USAT_REF_SESSION_RESET == msg_ptr->operation)
    {
    	if((parsing->offset < parsing->length)&&(',' == parsing->text[parsing->offset])) 
        {
    		parsing->offset++;
    	}
    	else
    	{
    	    //[<Aid>]
    	    pToken = GetParam(parsing);
    	}
        //[,<FileNum>,<Fid>]
        pToken = GetParam(parsing);
        if(NULL == pToken)
    	{
    	    zblFreeChannelMsg(ppMsg);

            if (parsing->token.text)
            {
                free(parsing->token.text);
                parsing->token.text = NULLPTR;
            }
    	    return -1;
    	}	
        msg_ptr->file_num = Str2Int(pToken->text);
        //[<Fid>]
        if(parsing->offset < parsing->length)
        {
		    pToken = GetParam(parsing);
	    	if(NULL == pToken)
	    	{
	    	    zblFreeChannelMsg(ppMsg);

	            if (parsing->token.text)
	            {
	                free(parsing->token.text);
	                parsing->token.text = NULLPTR;
	            }
	    	    return -1;
	    	}	    
			decode90TextData(msg_ptr->file_index_a, ATI_USAT_MAX_REFRESH_FILES_LIST_LEN, pToken->text);
        }
    }
    if (parsing->token.text)
    {
        free(parsing->token.text);
        parsing->token.text = NULLPTR;
    }
	return 0;	
}
SINT32 Parse_Zupci_PollOff(ParsingText* parsing, ZBL_CHANNEL_MSG_INFO **ppMsg)
{   
    Token *pToken = NULLPTR;
	UINT8 *msg_ptr = NULLPTR;

	*ppMsg = zblMallocChannelMsg(0);
    if(NULLPTR == *ppMsg)
    {
        zblAssert(0);
        return -1;
    }
    (*ppMsg)->msgId = ATI_STK_INACTIVE_POLLING_REQ;
    (*ppMsg)->msgSize = 0;
   
    //<CmdNum>,<CmdQual>    
	//CmdNum
	pToken = GetParam(parsing);
	if(NULL == pToken)
	{
	    zblFreeChannelMsg(ppMsg);
	    return -1;
	}	
	g_stk_cmd_dtl.cmdNum = Str2Int(pToken->text);	
	
	//CmdQual
	pToken = GetParam(parsing);
	if(NULL == pToken)
	{
	    zblFreeChannelMsg(ppMsg);
        if (parsing->token.text)
        {
            free(parsing->token.text);
            parsing->token.text = NULLPTR;
        }
	    return -1;
	}		
	g_stk_cmd_dtl.cmdQual = Str2Int(pToken->text);	
	if (parsing->token.text)
    {
        free(parsing->token.text);
        parsing->token.text = NULLPTR;
    }
	return 0;	
}
SINT32 Parse_Zupci_CloseChnl(ParsingText* parsing, ZBL_CHANNEL_MSG_INFO **ppMsg)
{   
    Token *pToken = NULL;
    atiUsatCloseChl *msg_ptr;
	
    ZTE_Trace(ZBL_AT, 0, "Parse_Zupci_CloseChnl");
    *ppMsg = zblMallocChannelMsg(sizeof(atiUsatCloseChl));
    if(NULLPTR == *ppMsg)
    {
        zblAssert(0);
        return -1;
    }
    
    (*ppMsg)->msgId = ATI_STK_CLOSE_CHL_REQ;
    (*ppMsg)->msgSize = sizeof(atiUsatCloseChl);
    msg_ptr = (atiUsatCloseChl*)(*ppMsg)->msgData;
    if(NULL == msg_ptr)
    {
        zblFreeChannelMsg(ppMsg);
        return -1;
    }		
    memset(msg_ptr, 0, sizeof(atiUsatCloseChl));

    //<CmdNum>,<CmdQual>    
	//CmdNum
	pToken = GetParam(parsing);
	if(NULL == pToken)
	{
	    zblFreeChannelMsg(ppMsg);
	    return -1;
	}	
	g_stk_cmd_dtl.cmdNum = Str2Int(pToken->text);	
	
	//CmdQual
	pToken = GetParam(parsing);
	if(NULL == pToken)
	{
	    zblFreeChannelMsg(ppMsg);
        if (parsing->token.text)
        {
            free(parsing->token.text);
            parsing->token.text = NULLPTR;
        }
	    return -1;
	}		
	g_stk_cmd_dtl.cmdQual = Str2Int(pToken->text);	
	
    //<SDvcId>,<DDvcId>,[<Alpha>],[<IconWithDesc>,<IconId>[,<TxtAtr>]]
	if(',' == parsing->text[parsing->offset]) 
    {
		parsing->offset++;
	}
    else
    {
		pToken = GetParam(parsing);
    }
	if(',' == parsing->text[parsing->offset]) 
    {
		parsing->offset++;
	}
    else
    {
	    pToken = GetParam(parsing);
		if(NULL == pToken)
		{
		    zblFreeChannelMsg(ppMsg);
	        if (parsing->token.text)
	        {
	            free(parsing->token.text);
	            parsing->token.text = NULLPTR;
	        }
		    return -1;
		}	
	    msg_ptr->channel_id = Str2Int(pToken->text);
    }
    //[<Alpha>]
	if((parsing->offset < parsing->length)&&(',' == parsing->text[parsing->offset])) 
    {
		parsing->offset++;
	}
	else
	{
	    pToken = GetParam(parsing);
    	if(NULL == pToken)
    	{
    	    zblFreeChannelMsg(ppMsg);

            if (parsing->token.text)
            {
                free(parsing->token.text);
                parsing->token.text = NULLPTR;
            }
    	    return -1;
    	}	    
		msg_ptr->alpha_st.alpha_presence = 1;
		decode90TextData(msg_ptr->alpha_st.alpha_a, ATI_USAT_MAX_LENGTH_ALPHA_ID, pToken->text);
	}	
	
	//[<IconWithDesc>,<IconId>[,<TxtAtr>]]
    if (parsing->offset >= parsing->length)
    {
        if (parsing->token.text)
        {
            free(parsing->token.text);
            parsing->token.text = NULLPTR;
        }
    	return 0;	
    }
	//pToken = GetParam(parsing);
    //[<IconWithDesc>,<IconId>[,<TxtAtr>]]	
    if (',' == parsing->text[parsing->offset])
    {
        parsing->offset++;
    }
    else
    {
		pToken = GetParam(parsing);
		if(NULL == pToken)
		{
		    zblFreeChannelMsg(ppMsg);
	        if (parsing->token.text)
	        {
	            free(parsing->token.text);
	            parsing->token.text = NULLPTR;
	        }
		    return -1;
		}		
        //IconWithDesc
		msg_ptr->icon_st.self_explanatory = Str2Int(pToken->text);
    }
    if (',' == parsing->text[parsing->offset])
    {
        parsing->offset++;
        msg_ptr->icon_st.id = 0xff;
    }
    else
    {
			//IconId
		    pToken = GetParam(parsing);
        	if(NULL == pToken)
        	{
        	    zblFreeChannelMsg(ppMsg);
                if (parsing->token.text)
                {
                    free(parsing->token.text);
                    parsing->token.text = NULLPTR;
                }
        	    return -1;
        	}			    
			msg_ptr->icon_st.id = Str2Int(pToken->text);
		}

    if (parsing->token.text)
    {
        free(parsing->token.text);
        parsing->token.text = NULLPTR;
    }
	return 0;	
}
SINT32 Parse_Zupci_PolIntvl(ParsingText* parsing, ZBL_CHANNEL_MSG_INFO **ppMsg)
{   
    Token *pToken = NULL;
    atiUsatPollInterval *msg_ptr;

    ZTE_Trace(ZBL_AT, 0, "Parse_Zupci_PolIntvl");
    *ppMsg = zblMallocChannelMsg(sizeof(atiUsatPollInterval));
    if(NULLPTR == *ppMsg)
    {
        zblAssert(0);
        return -1;
    }
    
    (*ppMsg)->msgId = ATI_STK_ACTIVE_POLLING_REQ;
    (*ppMsg)->msgSize = sizeof(atiUsatPollInterval);
    msg_ptr = (atiUsatPollInterval*)(*ppMsg)->msgData;
    if(NULL == msg_ptr)
    {
        zblFreeChannelMsg(ppMsg);
        return -1;
    }		
    memset(msg_ptr, 0, sizeof(atiUsatPollInterval));

    //<CmdNum>,<CmdQual>    
	//CmdNum
	pToken = GetParam(parsing);
	if(NULL == pToken)
	{
	    zblFreeChannelMsg(ppMsg);
	    return -1;
	}	
	g_stk_cmd_dtl.cmdNum = Str2Int(pToken->text);	
	
	//CmdQual
	pToken = GetParam(parsing);
	if(NULL == pToken)
	{
	    zblFreeChannelMsg(ppMsg);
        if (parsing->token.text)
        {
            free(parsing->token.text);
            parsing->token.text = NULLPTR;
        }
	    return -1;
	}		
	g_stk_cmd_dtl.cmdQual = Str2Int(pToken->text);	
	
	//<TimeUnit>,<TimeFreq>  
	pToken = GetParam(parsing);
	if(NULL == pToken)
	{
	    zblFreeChannelMsg(ppMsg);
        if (parsing->token.text)
        {
            free(parsing->token.text);
            parsing->token.text = NULLPTR;
        }
	    return -1;
	}	
	msg_ptr->duration = stkDecodeDuration(parsing, pToken->text);

    if (parsing->token.text)
    {
        free(parsing->token.text);
        parsing->token.text = NULLPTR;
    }
	return 0;	
}

SINT32 Parse_Zupci_SendDtmf(ParsingText* parsing, ZBL_CHANNEL_MSG_INFO **ppMsg)
{
    Token *pToken = NULLPTR; 
    
	*ppMsg = zblMallocChannelMsg(0);
    if(NULLPTR == *ppMsg)
    {
        zblAssert(0);
        return -1;
    }
    (*ppMsg)->msgId = ATI_STK_SEND_DTMF_IND;
    (*ppMsg)->msgSize = 0;

    //<CmdNum>,<CmdQual>    
	//CmdNum
	pToken = GetParam(parsing);
	if(NULL == pToken)
	{
	    zblFreeChannelMsg(ppMsg);
	    return -1;
	}	
	g_stk_cmd_dtl.cmdNum = Str2Int(pToken->text);	
	
	//CmdQual
	pToken = GetParam(parsing);
	if(NULL == pToken)
	{
	    zblFreeChannelMsg(ppMsg);
        if (parsing->token.text)
        {
            free(parsing->token.text);
            parsing->token.text = NULLPTR;
        }
	    return -1;
	}		
	g_stk_cmd_dtl.cmdQual = Str2Int(pToken->text);	
	if (parsing->token.text)
    {
        free(parsing->token.text);
        parsing->token.text = NULLPTR;
    }
	return 0;		
}

SINT32 Parse_Zupci_LaunchBrower(ParsingText* parsing, ZBL_CHANNEL_MSG_INFO **ppMsg)
{
	atiUsatLaunchBrowser* msg_ptr = NULLPTR;
    Token *pToken = NULLPTR;
    SINT32 iFileNum = 0;

	*ppMsg = zblMallocChannelMsg(sizeof(atiUsatLaunchBrowser));
    if(NULLPTR == *ppMsg)
    {
        zblAssert(0);
        return -1;
    }	
	
    (*ppMsg)->msgId = ATI_STK_LAUNCH_BROWSER_REQ;
    (*ppMsg)->msgSize = sizeof(atiUsatLaunchBrowser);
    msg_ptr = (atiUsatLaunchBrowser*)(*ppMsg)->msgData;
	if(NULL == msg_ptr)
	{
	    zblFreeChannelMsg(ppMsg);
	    return -1;
	}	    
	memset(msg_ptr, 0, sizeof(atiUsatLaunchBrowser));
    msg_ptr->icon_st.id = 0xff;

    /*
     <CmdNum>,<CmdQual>,<SDvcId>,<DDvcId>,[<BrowerId>],<Url>
     [,<BearType>
        [,<FileNum>
            [,<Fid>[,<Fid>]]
            [,<CodeMode>,<Txt>
                [,<Alpha>
                    [,<IconWithDesc>,<IconId>
                        [,<TxtAtr>]
                     ]
                 ]
             ]
         ]
     ]
    */
	//CmdNum
	pToken = GetParam(parsing);
	if(NULL == pToken)
	{
	    zblFreeChannelMsg(ppMsg);
	    return -1;
	}	
	g_stk_cmd_dtl.cmdNum = Str2Int(pToken->text);	
	//CmdQual
	pToken = GetParam(parsing);
	if(NULL == pToken)
	{
	    zblFreeChannelMsg(ppMsg);
        if (parsing->token.text)
        {
            free(parsing->token.text);
            parsing->token.text = NULLPTR;
        }
	    return -1;
	}	
	g_stk_cmd_dtl.cmdQual = Str2Int(pToken->text);	
    if (0 == g_stk_cmd_dtl.cmdQual || 2 == g_stk_cmd_dtl.cmdQual || 3== g_stk_cmd_dtl.cmdQual)
    {
        msg_ptr->qualifier = g_stk_cmd_dtl.cmdQual;
    }
    //<SDvcId>,<DDvcId>
    pToken = GetParam(parsing);
    pToken = GetParam(parsing);
    //[<BrowerId>]
	if((parsing->offset < parsing->length)&&(',' == parsing->text[parsing->offset]))
    {
		parsing->offset++;
	}
	else
	{
	    pToken = GetParam(parsing);
	    if(NULL == pToken)
	    {
	        zblFreeChannelMsg(ppMsg);
            if (parsing->token.text)
            {
                free(parsing->token.text);
                parsing->token.text = NULLPTR;
            }
	        return -1;
	    }	
        msg_ptr->browser_identity = Str2Int(pToken->text);
    }
    //<Url>
	pToken = GetParam(parsing);
	if(NULL == pToken)
	{
	    zblFreeChannelMsg(ppMsg);
        if (parsing->token.text)
        {
            free(parsing->token.text);
            parsing->token.text = NULLPTR;
        }
	    return -1;
	}	
    decode90TextData((CHAR*)(msg_ptr->url), ATI_USAT_MAX_URL_LEN, pToken->text);
    //[<BearType>],
    if(parsing->offset >= parsing->length)
	{
		goto launchbrowerend;
	}
	if(',' == parsing->text[parsing->offset])
    {
		parsing->offset++;
	}
	else
	{
	    pToken = GetParam(parsing);
		if(NULL == pToken)
	    {
	        zblFreeChannelMsg(ppMsg);
            if (parsing->token.text)
            {
                free(parsing->token.text);
                parsing->token.text = NULLPTR;
            }
	        return -1;
    	}	
        decode90TextData((CHAR*)(msg_ptr->bearer_list), ATI_USAT_MAX_BEARER_LIST_LEN, pToken->text);
    }    
    //[<FileNum>,<Fid>[,<Fid>]],  
    if(parsing->offset >= parsing->length)
	{
		goto launchbrowerend;
	}
    if(',' == parsing->text[parsing->offset])
    {
		parsing->offset++;
	}
	else
	{
	    pToken = GetParam(parsing);
        if (NULL == pToken)
        {
            zblFreeChannelMsg(ppMsg);
            if (parsing->token.text)
            {
                free(parsing->token.text);
                parsing->token.text = NULLPTR;
            }
	        return -1;
        }
        iFileNum = Str2Int(pToken->text);
        //pToken = GetParam(parsing);
        //while((parsing->offset < parsing->length)&&(',' != parsing->text[parsing->offset]))
        while (iFileNum != 0)//ȡеFid߼ٶfilenumǶ٣жٸfileid
        {
            pToken = GetParam(parsing);
            iFileNum--;    		
    	}      
    }    
    //[<CodeMode>,<Txt>]
    if(parsing->offset >= parsing->length)
	{
		goto launchbrowerend;
	}
    if(',' == parsing->text[parsing->offset])
    {
		parsing->offset++;
	}
	else
	{
	    pToken = GetParam(parsing);
		if(NULL == pToken)
	    {
	        zblFreeChannelMsg(ppMsg);
            if (parsing->token.text)
            {
                free(parsing->token.text);
                parsing->token.text = NULLPTR;
            }
	        return -1;
	    }	
        msg_ptr->text_st.alphabet = zblStkGetCodeType(Str2Int(pToken->text));
    }
    if(',' == parsing->text[parsing->offset])
    {
		parsing->offset++;
	}
	else
	{
        pToken = GetParam(parsing);
		if(NULL == pToken)
	    {
	        zblFreeChannelMsg(ppMsg);
            if (parsing->token.text)
            {
                free(parsing->token.text);
                parsing->token.text = NULLPTR;
            }
	        return -1;
	    }	
        decode90TextData((CHAR*)(msg_ptr->text_st.text_a), ATI_USAT_MAX_LENGTH_LONG_TEXT_STRING, pToken->text);
    }     
	//Alpha
	if(parsing->offset >= parsing->length)
	{
		goto launchbrowerend;
	}
	if(',' == parsing->text[parsing->offset])
    {
		parsing->offset++;
	}
	else
	{
	    pToken = GetParam(parsing);
    	if(NULL == pToken)
    	{
    	    zblFreeChannelMsg(ppMsg);
            if (parsing->token.text)
            {
                free(parsing->token.text);
                parsing->token.text = NULLPTR;
            }
    	    return -1;
    	}	    
		msg_ptr->alpha_st.alpha_presence = 1;
		decode90TextData(msg_ptr->alpha_st.alpha_a, ATI_USAT_MAX_LENGTH_ALPHA_ID, pToken->text);
	}	
    //[,<IconWithDesc>,<IconId>[,<TxtAtr>]]
    if(parsing->offset >= parsing->length)
	{
		goto launchbrowerend;
	}
  	if(',' == parsing->text[parsing->offset])
    {
		parsing->offset++;
	}
	else
	{
		pToken = GetParam(parsing);
		if(NULL == pToken)
		{
		    zblFreeChannelMsg(ppMsg);
	        if (parsing->token.text)
	        {
	            free(parsing->token.text);
	            parsing->token.text = NULLPTR;
	        }
		    return -1;
		}	  		
	    //IconWithDesc
		msg_ptr->icon_st.self_explanatory = Str2Int(pToken->text);
    }

  	if(',' == parsing->text[parsing->offset])
    {
		parsing->offset++;
        msg_ptr->icon_st.id = 0xff;
	}
	else
	{
			//IconId
		    pToken = GetParam(parsing);
        	if(NULL == pToken)
        	{
        	    zblFreeChannelMsg(ppMsg);
                if (parsing->token.text)
                {
                    free(parsing->token.text);
                    parsing->token.text = NULLPTR;
                }
        	    return -1;
        	}	  			    
			msg_ptr->icon_st.id = Str2Int(pToken->text);
		}

launchbrowerend:
    if (parsing->token.text)
    {
        free(parsing->token.text);
        parsing->token.text = NULLPTR;
    }
	return 0;	
}

SINT32 Parse_Zupci_PlayTone(ParsingText* parsing, ZBL_CHANNEL_MSG_INFO **ppMsg)
{
	atiUsatPlayTone* msg_ptr = NULLPTR;
    Token *pToken = NULLPTR;

	ZTE_Trace(ZBL_AT, 0, "Parse_Psstk_SetupMenu");

	*ppMsg = zblMallocChannelMsg(sizeof(atiUsatPlayTone));
    if(NULLPTR == *ppMsg)
    {
        zblAssert(0);
        return -1;
    }	
	
    (*ppMsg)->msgId = ATI_STK_PLAY_TONE_IND;
    (*ppMsg)->msgSize = sizeof(atiUsatPlayTone);
    msg_ptr = (atiUsatPlayTone*)(*ppMsg)->msgData;
	if(NULL == msg_ptr)
	{
	    zblFreeChannelMsg(ppMsg);
	    return -1;
	}	    
	memset(msg_ptr, 0, sizeof(atiUsatPlayTone));
    msg_ptr->icon_st.id = 0xff;

    /*<CmdNum>,<CmdQual>,<SDvcId>,<DDvcId>
    [,<Alpha>
        [,<Tone>
            [,<TimeUnit>,<TimeFreq>
                [,<IconWithDesc>,<IconId>
                    [,<TxtAtr>]]]]]    

	*/
	//CmdNum
	pToken = GetParam(parsing);
	if(NULL == pToken)
	{
	    zblFreeChannelMsg(ppMsg);
	    return -1;
	}	
	g_stk_cmd_dtl.cmdNum = Str2Int(pToken->text);	
	
	//CmdQual
	pToken = GetParam(parsing);
	if(NULL == pToken)
	{
	    zblFreeChannelMsg(ppMsg);
        if (parsing->token.text)
        {
            free(parsing->token.text);
            parsing->token.text = NULLPTR;
        }
	    return -1;
	}		
	g_stk_cmd_dtl.cmdQual = Str2Int(pToken->text);	
	
    //<SDvcId>,<DDvcId>,[<Alpha>],[<Tone>],[<TimeUnit>,<TimeFreq>],[<IconWithDesc>,<IconId>][,<TxtAtr>]
	pToken = GetParam(parsing);
    pToken = GetParam(parsing);
	//Alpha
	if(parsing->offset >= parsing->length)
    {
        if (parsing->token.text)
        {
            free(parsing->token.text);
            parsing->token.text = NULLPTR;
        }
    	return 0;	
    }   
	if(',' == parsing->text[parsing->offset])
    {
		parsing->offset++;
	}
	else
	{
	    pToken = GetParam(parsing);
    	if(NULL == pToken)
    	{
    	    zblFreeChannelMsg(ppMsg);
            if (parsing->token.text)
            {
                free(parsing->token.text);
                parsing->token.text = NULLPTR;
            }
    	    return -1;
    	}	    
		msg_ptr->alpha_st.alpha_presence = 1;
		decode90TextData(msg_ptr->alpha_st.alpha_a, ATI_USAT_MAX_LENGTH_ALPHA_ID, pToken->text);
	}	
	//[<Tone>]
	if(parsing->offset >= parsing->length)
    {
        if (parsing->token.text)
        {
            free(parsing->token.text);
            parsing->token.text = NULLPTR;
        }
    	return 0;	
    }   
	if(',' == parsing->text[parsing->offset])
    {
		parsing->offset++;
	}
	else
	{
	    pToken = GetParam(parsing);
    	if(NULL == pToken)
    	{
    	    zblFreeChannelMsg(ppMsg);
            if (parsing->token.text)
            {
                free(parsing->token.text);
                parsing->token.text = NULLPTR;
            }
    	    return -1;
    	}	    
		msg_ptr->tone_type = Str2Int(pToken->text);
	}
    //[,<TimeUnit>,<TimeFreq>
	if(parsing->offset >= parsing->length)
    {
        if (parsing->token.text)
        {
            free(parsing->token.text);
            parsing->token.text = NULLPTR;
        }
    	return 0;	
    }   
    if(',' == parsing->text[parsing->offset])
    {
		parsing->offset++;
	}
	else
	{
		pToken = GetParam(parsing);
    	if(NULL == pToken)
    	{
    	    zblFreeChannelMsg(ppMsg);
            if (parsing->token.text)
            {
                free(parsing->token.text);
                parsing->token.text = NULLPTR;
            }
    	    return -1;
    	}
    }
	if(',' == parsing->text[parsing->offset])
    {
        parsing->offset++;
	}
	else
	{
		if(pToken)
	    msg_ptr->duration = stkDecodeDuration(parsing, pToken->text);
    }

    //[<IconWithDesc>,<IconId>][,<TxtAtr>]
	if(parsing->offset >= parsing->length)
    {
        if (parsing->token.text)
        {
            free(parsing->token.text);
            parsing->token.text = NULLPTR;
        }
    	return 0;	
    }   
	if(',' == parsing->text[parsing->offset])
    {
        parsing->offset++;
	}
	else
    {
		pToken = GetParam(parsing);
		if(NULL == pToken)
		{
		    zblFreeChannelMsg(ppMsg);
	        if (parsing->token.text)
	        {
	            free(parsing->token.text);
	            parsing->token.text = NULLPTR;
	        }
		    return -1;
		}	  		
		//IconWithDesc
		msg_ptr->icon_st.self_explanatory = Str2Int(pToken->text);
    }   
	if(',' == parsing->text[parsing->offset])
    {
        parsing->offset++;
        msg_ptr->icon_st.id = 0xff;
	}
	else 
	{
		//IconId
	    pToken = GetParam(parsing);
    	if(NULL == pToken)
    	{
    	    zblFreeChannelMsg(ppMsg);
            if (parsing->token.text)
            {
                free(parsing->token.text);
                parsing->token.text = NULLPTR;
            }
    	    return -1;
    	}	  			    
		msg_ptr->icon_st.id = Str2Int(pToken->text);
	}

    if (parsing->token.text)
    {
        free(parsing->token.text);
        parsing->token.text = NULLPTR;
    }
	return 0;	
}

SINT32 Parse_Zupci_SetupIdleText(ParsingText* parsing, ZBL_CHANNEL_MSG_INFO **ppMsg)
{
	atiUsatIdleModeText* msg_ptr = NULLPTR;
    Token *pToken = NULLPTR;

	ZTE_Trace(ZBL_AT, 0, "Parse_Psstk_SetupMenu");

	*ppMsg = zblMallocChannelMsg(sizeof(atiUsatIdleModeText));
    if(NULLPTR == *ppMsg)
    {
        zblAssert(0);
        return -1;
    }	
	
    (*ppMsg)->msgId = ATI_STK_SETUP_IDLE_TEXT_IND;
    (*ppMsg)->msgSize = sizeof(atiUsatIdleModeText);
    msg_ptr = (atiUsatIdleModeText*)(*ppMsg)->msgData;
	if(NULL == msg_ptr)
	{
	    zblFreeChannelMsg(ppMsg);
	    return -1;
	}	    
	memset(msg_ptr, 0, sizeof(atiUsatIdleModeText));
    msg_ptr->icon_st.id = 0xff;

    //<CmdNum>,<CmdQual>    
	//CmdNum
	pToken = GetParam(parsing);
	if(NULL == pToken)
	{
	    zblFreeChannelMsg(ppMsg);
	    return -1;
	}	
	g_stk_cmd_dtl.cmdNum = Str2Int(pToken->text);	
	
	//CmdQual
	pToken = GetParam(parsing);
	if(NULL == pToken)
	{
	    zblFreeChannelMsg(ppMsg);
        if (parsing->token.text)
        {
            free(parsing->token.text);
            parsing->token.text = NULLPTR;
        }
	    return -1;
	}		
	g_stk_cmd_dtl.cmdQual = Str2Int(pToken->text);	

    //<SDvcId>,<DDvcId>,<CodeMode>,<Txt>,[<IconWithDesc>,<IconId>][,<TxtAtr>]

	pToken = GetParam(parsing);
    pToken = GetParam(parsing);
    //<CodeMode>,<Txt>
    pToken = GetParam(parsing);
	if(NULL == pToken)
	{
	    zblFreeChannelMsg(ppMsg);
        if (parsing->token.text)
        {
            free(parsing->token.text);
            parsing->token.text = NULLPTR;
        }
	    return -1;
	}	
    msg_ptr->text_st.alphabet = zblStkGetCodeType(Str2Int(pToken->text));
    pToken = GetParam(parsing);
	if(NULL == pToken)
	{
	    zblFreeChannelMsg(ppMsg);
        if (parsing->token.text)
        {
            free(parsing->token.text);
            parsing->token.text = NULLPTR;
        }
	    return -1;
	}	
    decode90TextData((CHAR*)(msg_ptr->text_st.text_a), ATI_USAT_MAX_LENGTH_LONG_TEXT_STRING, pToken->text);
    //[<IconWithDesc>,<IconId>][,<TxtAtr>]
	if(parsing->offset >= parsing->length)
    {
        if (parsing->token.text)
        {
            free(parsing->token.text);
            parsing->token.text = NULLPTR;
        }
    	return 0;	
    }   
    if(',' == parsing->text[parsing->offset])
    {
        parsing->offset++;
	}
    else
    {
		pToken = GetParam(parsing);
		if(NULL == pToken)
		{
		    zblFreeChannelMsg(ppMsg);
	        if (parsing->token.text)
	        {
	            free(parsing->token.text);
	            parsing->token.text = NULLPTR;
	        }
		    return -1;
		}	  		
        //IconWithDesc
		msg_ptr->icon_st.self_explanatory = Str2Int(pToken->text);
    }	
    if(',' == parsing->text[parsing->offset])
    {
        parsing->offset++;
        msg_ptr->icon_st.id = 0xff;
	}
    else
    {
		//IconId
	    pToken = GetParam(parsing);
    	if(NULL == pToken)
    	{
    	    zblFreeChannelMsg(ppMsg);
            if (parsing->token.text)
            {
                free(parsing->token.text);
                parsing->token.text = NULLPTR;
            }
    	    return -1;
    	}	  			    
		msg_ptr->icon_st.id = Str2Int(pToken->text);
	}

    if (parsing->token.text)
    {
        free(parsing->token.text);
        parsing->token.text = NULLPTR;
    }
	return 0;	
}

SINT32 Parse_Zupci_LangNotif(ParsingText* parsing, ZBL_CHANNEL_MSG_INFO **ppMsg)
{
	atiUsatLangNotif* msg_ptr = NULLPTR;
    Token *pToken = NULLPTR;

	*ppMsg = zblMallocChannelMsg(sizeof(atiUsatLangNotif));
    if(NULLPTR == *ppMsg)
    {
        zblAssert(0);
        return -1;
    }	
	
    (*ppMsg)->msgId = ATI_STK_LANG_NOTIFICATION_IND;
    (*ppMsg)->msgSize = sizeof(atiUsatLangNotif);
    msg_ptr = (atiUsatLangNotif*)(*ppMsg)->msgData;
	if(NULL == msg_ptr)
	{
	    zblFreeChannelMsg(ppMsg);
	    return -1;
	}	    
	memset(msg_ptr, 0, sizeof(atiUsatLangNotif));

    //<CmdNum>,<CmdQual>,<SDvcId>,<DDvcId>[,<Lang>]
	//CmdNum
	pToken = GetParam(parsing);
	if(NULL == pToken)
	{
	    zblFreeChannelMsg(ppMsg);
	    return -1;
	}	
	g_stk_cmd_dtl.cmdNum = Str2Int(pToken->text);	
	//CmdQual
	pToken = GetParam(parsing);
	if(NULL == pToken)
	{
	    zblFreeChannelMsg(ppMsg);
        if (parsing->token.text)
        {
            free(parsing->token.text);
            parsing->token.text = NULLPTR;
        }
	    return -1;
	}	
	g_stk_cmd_dtl.cmdQual = Str2Int(pToken->text);	
    if(g_stk_cmd_dtl.cmdQual & (0x01))
	{
		msg_ptr->need_notification = 1;
	}
    //<SDvcId>,<DDvcId>
    pToken = GetParam(parsing);
    pToken = GetParam(parsing);
    //[,<Lang>]
    if(parsing->offset < parsing->length)
    {
		pToken = GetParam(parsing);
        if(NULL == pToken)
    	{
    	    zblFreeChannelMsg(ppMsg);
            if (parsing->token.text)
            {
                free(parsing->token.text);
                parsing->token.text = NULLPTR;
            }
    	    return -1;
    	}
		decode90TextData((CHAR*)(msg_ptr->lang_a), ATI_USAT_USIM_LANG_CODE_LEN +1, pToken->text);
	}
    

    if (parsing->token.text)
    {
        free(parsing->token.text);
        parsing->token.text = NULLPTR;
    }
	return 0;	
}

SINT32 Parse_Zupci_PrcdaPdu(ParsingText* parsing, ZBL_CHANNEL_MSG_INFO **ppMsg)
{
    Token *pToken = NULLPTR; 
	*ppMsg = zblMallocChannelMsg(0);
    if(NULLPTR == *ppMsg)
    {
        zblAssert(0);
        return -1;
    }
    (*ppMsg)->msgId = ATI_STK_PRCDA_PDU_REQ;
    (*ppMsg)->msgSize = 0;

    //<CmdNum>,<CmdQual>    
	//CmdNum
	pToken = GetParam(parsing);
	if(NULL == pToken)
	{
	    zblFreeChannelMsg(ppMsg);
	    return -1;
	}	
	g_stk_cmd_dtl.cmdNum = Str2Int(pToken->text);	
	
	//CmdQual
	pToken = GetParam(parsing);
	if(NULL == pToken)
	{
	    zblFreeChannelMsg(ppMsg);
        if (parsing->token.text)
        {
            free(parsing->token.text);
            parsing->token.text = NULLPTR;
        }
	    return -1;
	}		
	g_stk_cmd_dtl.cmdQual = Str2Int(pToken->text);	
	if (parsing->token.text)
    {
        free(parsing->token.text);
        parsing->token.text = NULLPTR;
    }
	return 0;
}

SINT32 Parse_Zupci_PonCard(ParsingText* parsing, ZBL_CHANNEL_MSG_INFO **ppMsg)
{
    Token *pToken = NULLPTR; 
	*ppMsg = zblMallocChannelMsg(0);
    if(NULLPTR == *ppMsg)
    {
        zblAssert(0);
        return -1;
    }
    (*ppMsg)->msgId = ATI_STK_PON_CARD_REQ;
    (*ppMsg)->msgSize = 0;

    //<CmdNum>,<CmdQual>    
	//CmdNum
	pToken = GetParam(parsing);
	if(NULL == pToken)
	{
	    zblFreeChannelMsg(ppMsg);
	    return -1;
	}	
	g_stk_cmd_dtl.cmdNum = Str2Int(pToken->text);	
	
	//CmdQual
	pToken = GetParam(parsing);
	if(NULL == pToken)
	{
	    zblFreeChannelMsg(ppMsg);
        if (parsing->token.text)
        {
            free(parsing->token.text);
            parsing->token.text = NULLPTR;
        }
	    return -1;
	}		
	g_stk_cmd_dtl.cmdQual = Str2Int(pToken->text);	
    if (parsing->token.text)
    {
        free(parsing->token.text);
        parsing->token.text = NULLPTR;
    }
	return 0;
}

SINT32 Parse_Zupci_PoffCard(ParsingText* parsing, ZBL_CHANNEL_MSG_INFO **ppMsg)
{
    Token *pToken = NULLPTR; 
	*ppMsg = zblMallocChannelMsg(0);
    if(NULLPTR == *ppMsg)
    {
        zblAssert(0);
        return -1;
    }
    (*ppMsg)->msgId = ATI_STK_POFF_CARD_REQ;
    (*ppMsg)->msgSize = 0;

    //<CmdNum>,<CmdQual>    
	//CmdNum
	pToken = GetParam(parsing);
	if(NULL == pToken)
	{
	    zblFreeChannelMsg(ppMsg);
	    return -1;
	}	
	g_stk_cmd_dtl.cmdNum = Str2Int(pToken->text);	
	
	//CmdQual
	pToken = GetParam(parsing);
	if(NULL == pToken)
	{
	    zblFreeChannelMsg(ppMsg);
        if (parsing->token.text)
        {
            free(parsing->token.text);
            parsing->token.text = NULLPTR;
        }
	    return -1;
	}		
	g_stk_cmd_dtl.cmdQual = Str2Int(pToken->text);	
    if (parsing->token.text)
    {
        free(parsing->token.text);
        parsing->token.text = NULLPTR;
    }
	return 0;
}

SINT32 Parse_Zupci_GetReaderStat(ParsingText* parsing, ZBL_CHANNEL_MSG_INFO **ppMsg)
{
    Token *pToken = NULLPTR;

	*ppMsg = zblMallocChannelMsg(0);
    if(NULLPTR == *ppMsg)
    {
        zblAssert(0);
        return -1;
    }
    (*ppMsg)->msgId = ATI_STK_GET_READER_STATUS_REQ;
    (*ppMsg)->msgSize = 0;
    
	//CmdNum
	pToken = GetParam(parsing);
	if(NULL == pToken)
	{
	    zblFreeChannelMsg(ppMsg);
	    return -1;
	}	
	g_stk_cmd_dtl.cmdNum = Str2Int(pToken->text);	
	//CmdQual
	pToken = GetParam(parsing);
	if(NULL == pToken)
	{
	    zblFreeChannelMsg(ppMsg);
        if (parsing->token.text)
        {
            free(parsing->token.text);
            parsing->token.text = NULLPTR;
        }
	    return -1;
	}	
	g_stk_cmd_dtl.cmdQual = Str2Int(pToken->text);	

    if (parsing->token.text)
    {
        free(parsing->token.text);
        parsing->token.text = NULLPTR;
    }
	return 0;	
}

SINT32 Parse_Zupci_RunAtCmd(ParsingText* parsing, ZBL_CHANNEL_MSG_INFO **ppMsg)
{
    Token *pToken = NULLPTR; 
	*ppMsg = zblMallocChannelMsg(0);
    if(NULLPTR == *ppMsg)
    {
        zblAssert(0);
        return -1;
    }
    (*ppMsg)->msgId = ATI_STK_RUN_ATCMD_REQ;
    (*ppMsg)->msgSize = 0;

    //<CmdNum>,<CmdQual>    
	//CmdNum
	pToken = GetParam(parsing);
	if(NULL == pToken)
	{
	    zblFreeChannelMsg(ppMsg);
	    return -1;
	}	
	g_stk_cmd_dtl.cmdNum = Str2Int(pToken->text);	
	
	//CmdQual
	pToken = GetParam(parsing);
	if(NULL == pToken)
	{
	    zblFreeChannelMsg(ppMsg);
        if (parsing->token.text)
        {
            free(parsing->token.text);
            parsing->token.text = NULLPTR;
        }
	    return -1;
	}		
	g_stk_cmd_dtl.cmdQual = Str2Int(pToken->text);	
	
    if (parsing->token.text)
    {
        free(parsing->token.text);
        parsing->token.text = NULLPTR;
    }
	return 0;
}

SINT32 Parse_Zupci_ServiceSearch(ParsingText* parsing, ZBL_CHANNEL_MSG_INFO **ppMsg)
{
    Token *pToken = NULLPTR;
    
	*ppMsg = zblMallocChannelMsg(0);
    if(NULLPTR == *ppMsg)
    {
        zblAssert(0);
        return -1;
    }
    (*ppMsg)->msgId = ATI_STK_SERVICE_SEARCH_REQ;
    (*ppMsg)->msgSize = 0;

    //<CmdNum>,<CmdQual>    
	//CmdNum
	pToken = GetParam(parsing);
	if(NULL == pToken)
	{
	    zblFreeChannelMsg(ppMsg);
	    return -1;
	}	
	g_stk_cmd_dtl.cmdNum = Str2Int(pToken->text);	
	
	//CmdQual
	pToken = GetParam(parsing);
	if(NULL == pToken)
	{
	    zblFreeChannelMsg(ppMsg);
        if (parsing->token.text)
        {
            free(parsing->token.text);
            parsing->token.text = NULLPTR;
        }
	    return -1;
	}		
	g_stk_cmd_dtl.cmdQual = Str2Int(pToken->text);	
	
    if (parsing->token.text)
    {
        free(parsing->token.text);
        parsing->token.text = NULLPTR;
    }
	return 0;
}

SINT32 Parse_Zupci_GetServiceInfo(ParsingText* parsing, ZBL_CHANNEL_MSG_INFO **ppMsg)
{
    Token *pToken = NULLPTR;
    
	*ppMsg = zblMallocChannelMsg(0);
    if(NULLPTR == *ppMsg)
    {
        zblAssert(0);
        return -1;
    }
    (*ppMsg)->msgId = ATI_STK_GET_SERVICE_INFO_REQ;
    (*ppMsg)->msgSize = 0;

    //<CmdNum>,<CmdQual>    
	//CmdNum
	pToken = GetParam(parsing);
	if(NULL == pToken)
	{
	    zblFreeChannelMsg(ppMsg);
	    return -1;
	}	
	g_stk_cmd_dtl.cmdNum = Str2Int(pToken->text);	
	
	//CmdQual
	pToken = GetParam(parsing);
	if(NULL == pToken)
	{
	    zblFreeChannelMsg(ppMsg);
        if (parsing->token.text)
        {
            free(parsing->token.text);
            parsing->token.text = NULLPTR;
        }
	    return -1;
	}		
	g_stk_cmd_dtl.cmdQual = Str2Int(pToken->text);	
	
    if (parsing->token.text)
    {
        free(parsing->token.text);
        parsing->token.text = NULLPTR;
    }
	return 0;
}

SINT32 Parse_Zupci_DeclearService(ParsingText* parsing, ZBL_CHANNEL_MSG_INFO **ppMsg)
{
    Token *pToken = NULLPTR;

	*ppMsg = zblMallocChannelMsg(0);
    if(NULLPTR == *ppMsg)
    {
        zblAssert(0);
        return -1;
    }
    (*ppMsg)->msgId = ATI_STK_DECLEAR_SERVICE_IND;
    (*ppMsg)->msgSize = 0;
    
	//CmdNum
	pToken = GetParam(parsing);
	if(NULL == pToken)
	{
	    zblFreeChannelMsg(ppMsg);
	    return -1;
	}	
	g_stk_cmd_dtl.cmdNum = Str2Int(pToken->text);	
	//CmdQual
	pToken = GetParam(parsing);
	if(NULL == pToken)
	{
	    zblFreeChannelMsg(ppMsg);
        if (parsing->token.text)
        {
            free(parsing->token.text);
            parsing->token.text = NULLPTR;
        }
	    return -1;
	}	
	g_stk_cmd_dtl.cmdQual = Str2Int(pToken->text);	

    if (parsing->token.text)
    {
        free(parsing->token.text);
        parsing->token.text = NULLPTR;
    }
	return 0;	
}

SINT32 Parse_TerminalRsp_Ok(ZBL_CHANNEL_MSG_INFO **ppMsg, SINT32 nResult)
{
    if(NULLPTR == ppMsg)
    {
        zblAssert(0);
        return -1;
    }
    if(nResult == 0)
    {
	    *ppMsg = zblMallocChannelMsg(0);
	    if(NULLPTR == *ppMsg)
	    {
	        zblAssert(0);
	        return -1;
	    }

		(*ppMsg)->msgId = ATI_STK_GEN_TERMINAL_RSP;
		
	    (*ppMsg)->msgSize = 0;
	    bIsMmiWaiting = TRUE;
    }
    else
    {
        UINT8 *msg_ptr = NULLPTR;
    	*ppMsg = zblMallocChannelMsg(sizeof(UINT8));
        if(NULLPTR == *ppMsg)
        {
            zblAssert(0);
            return -1;
        }
        (*ppMsg)->msgId = ATI_STK_SESSION_NOTIFICATION;
        (*ppMsg)->msgSize = sizeof(UINT8);
    	msg_ptr = (UINT8*)(*ppMsg)->msgData;
    	if(NULL == msg_ptr)
    	{
    	    zblFreeChannelMsg(ppMsg);
    	    return -1;
    	}
        ZTE_Trace(ZBL_AT,0,"\r\n: Parse_TerminalRsp_Ok, nResult != 0\r\n");
        *msg_ptr = ATI_USAT_SESSION_ERROR;
    }        

	ZTE_Trace( ZBL_AT, 0, "Parse_TerminalRsp_Ok");
    return 0;
}

SINT32 Parse_MenuSelection_Ok(ZBL_CHANNEL_MSG_INFO **ppMsg, SINT32 nResult)
{
    if(NULLPTR == ppMsg)
    {
        zblAssert(0);
        return -1;
    }
    if(nResult == 0)
    {
    *ppMsg = zblMallocChannelMsg(0);
    if(NULLPTR == *ppMsg)
    {
        zblAssert(0);
        return -1;
    }

	(*ppMsg)->msgId = ATI_STK_MENU_SELECTION_REQ;
	
    (*ppMsg)->msgSize = 0;
    }
    else
    {
        UINT8 *msg_ptr = NULLPTR;
    	*ppMsg = zblMallocChannelMsg(sizeof(UINT8));
        if(NULLPTR == *ppMsg)
        {
            zblAssert(0);
            return -1;
        }
        (*ppMsg)->msgId = ATI_STK_SESSION_NOTIFICATION;
        (*ppMsg)->msgSize = sizeof(UINT8);
    	msg_ptr = (UINT8*)(*ppMsg)->msgData;
    	if(NULL == msg_ptr)
    	{
    	    zblFreeChannelMsg(ppMsg);
    	    return -1;
    	}
        ZTE_Trace(ZBL_AT, 0, "\r\n: Parse_MenuSelection_Ok, nResult != 0\r\n");
    
        *msg_ptr = ATI_USAT_SESSION_ERROR;
    }        

	ZTE_Trace( ZBL_AT, 0, "Parse_MenuSelection_Ok");

    return 0;
}


SINT32 Parse_GetItemList_Ok(ZBL_CHANNEL_MSG_INFO **ppMsg, SINT32 nResult)
{
    if(NULLPTR == ppMsg)
    {
        zblAssert(0);
        return -1;
    }

    *ppMsg = zblMallocChannelMsg(0);
    if(NULLPTR == *ppMsg)
    {
        zblAssert(0);
        return -1;
    }

	(*ppMsg)->msgId = ATI_STK_GETITEMLIST_END;
	
    (*ppMsg)->msgSize = 0;
    

	ZTE_Trace( ZBL_AT, 0, "Parse_GetItemList_Ok");

    return 0;
}

/* AT+Zutp */
typedef struct
{
    SINT32 result;
}MdmZutpCnf;
SINT32 Parse_ProfileDownload_Ok(ZBL_CHANNEL_MSG_INFO **ppMsg, SINT32 nResult)
{
    MdmZutpCnf *msg_ptr = NULLPTR;
    if(NULLPTR == ppMsg)
    {
        zblAssert(0);
        return -1;
    }
    
    *ppMsg = zblMallocChannelMsg(sizeof(MdmZutpCnf));
    if(NULLPTR == *ppMsg)
    {
        zblAssert(0);
        return -1;
    }
    
    (*ppMsg)->msgId = ATI_STK_PROFILEDOWNLOAD_CNF;	
    (*ppMsg)->msgSize = sizeof(MdmZutpCnf);
    msg_ptr = (MdmZutpCnf*)(*ppMsg)->msgData;
    msg_ptr->result = nResult;
    
    ZTE_Trace( ZBL_AT, 0, "Parse_ProfileDownload_Ok");
    return 0;
}


SINT32 Parse_CommandReject_Ok(ZBL_CHANNEL_MSG_INFO **ppMsg, SINT32 nResult)
{
    if(NULLPTR == ppMsg)
    {
        zblAssert(0);
        return -1;
    }

    if(nResult == 0)
    {
	    *ppMsg = zblMallocChannelMsg(0);
	    if(NULLPTR == *ppMsg)
	    {
	        zblAssert(0);
	        return -1;
	    }

		(*ppMsg)->msgId = ATI_STK_COMMAND_REJECT_CNF;
		
	    (*ppMsg)->msgSize = 0;
	    bIsMmiWaiting = TRUE;
    }
    else
    {    
        UINT8 *msg_ptr = NULLPTR;
    	*ppMsg = zblMallocChannelMsg(sizeof(UINT8));
        if(NULLPTR == *ppMsg)
        {
            zblAssert(0);
            return -1;
        }
        (*ppMsg)->msgId = ATI_STK_SESSION_NOTIFICATION;
        (*ppMsg)->msgSize = sizeof(UINT8);
    	msg_ptr = (UINT8*)(*ppMsg)->msgData;
    	if(NULL == msg_ptr)
    	{
    	    zblFreeChannelMsg(ppMsg);
    	    return -1;
    	}
        ZTE_Trace(ZBL_AT,0,"\r\n: Parse_CommandReject_Ok, nResult != 0\r\n");
        *msg_ptr = ATI_USAT_SESSION_ERROR;
    }        
	ZTE_Trace( ZBL_AT, 0, "Parse_CommandRejectd_Ok()");

    return 0;
}

 SINT32 Parse_Zimg_Res(ZBL_CHANNEL_MSG_INFO **ppMsg, const CHAR *pRes, UINT32 nSize, UINT32 iChannel_id)
{
    ParsingText parsing = {0};
    Token *pToken = NULLPTR;    
    atiUsatImgInsDesSt *msg_ptr = NULLPTR;

    if(NULLPTR == pRes ||NULL == ppMsg)
    {
        zblAssert(0);
        return -1;
    }    
	ZTE_Trace(ZBL_AT, 0, "Parse_Zimg_Res");
	*ppMsg = zblMallocChannelMsg(sizeof(atiUsatImgInsDesSt));
    if(NULLPTR == *ppMsg)
    {
        zblAssert(0);
        return -1;
    }

    (*ppMsg)->msgId = ATI_STK_GET_IMAGE_CATALOG_CNF;
    (*ppMsg)->msgSize = sizeof(atiUsatImgInsDesSt);
	msg_ptr = (atiUsatImgInsDesSt*)(*ppMsg)->msgData;
	if(NULL == msg_ptr)
	{
	    zblFreeChannelMsg(ppMsg);
	    return -1;
	}
    memset(msg_ptr, 0, sizeof(atiUsatImgInsDesSt));
   
    parsing.text = pRes;
    parsing.length = nSize;
    parsing.offset = 0;
    parsing.start = 0;
    
    parsing.token.text = NULLPTR;
    parsing.token.start = 0;
    parsing.token.end = 0;	

    //:
    pToken = GetToken(&parsing);
    
    //<Image Instance Width>,
	pToken = GetParam(&parsing);
	if(NULL == pToken)
	{
	    zblFreeChannelMsg(ppMsg);
        if (parsing.token.text)
        {
            free(parsing.token.text);
            parsing.token.text = NULLPTR;
        }
	    return -1;
	}	
	msg_ptr->width= Str2Int(pToken->text);
    
    //<Image Instance Heigh>,
	pToken = GetParam(&parsing);
	if(NULL == pToken)
	{
	    zblFreeChannelMsg(ppMsg);
        if (parsing.token.text)
        {
            free(parsing.token.text);
            parsing.token.text = NULLPTR;
        }
	    return -1;
	}	
	msg_ptr->height= Str2Int(pToken->text);

    //<Image Coding Scheme>,
	pToken = GetParam(&parsing);
	if(NULL == pToken)
	{
	    zblFreeChannelMsg(ppMsg);
        if (parsing.token.text)
        {
            free(parsing.token.text);
            parsing.token.text = NULLPTR;
        }
	    return -1;
	}	
	msg_ptr->ics = Str2Int(pToken->text);

    //<Image Instance Keyid>,
	pToken = GetParam(&parsing);
	if(NULL == pToken)
	{
	    zblFreeChannelMsg(ppMsg);
        if (parsing.token.text)
        {
            free(parsing.token.text);
            parsing.token.text = NULLPTR;
        }
	    return -1;
	}	
	msg_ptr->fileid = Str2Int(pToken->text);

    //<Offset into Image Instance File>,
	pToken = GetParam(&parsing);
	if(NULL == pToken)
	{
	    zblFreeChannelMsg(ppMsg);
        if (parsing.token.text)
        {
            free(parsing.token.text);
            parsing.token.text = NULLPTR;
        }
	    return -1;
	}	
	msg_ptr->offset= Str2Int(pToken->text);

    //<Length of Image Instance Data>
	pToken = GetParam(&parsing);
	if(NULL == pToken)
	{
	    zblFreeChannelMsg(ppMsg);
        if (parsing.token.text)
        {
            free(parsing.token.text);
            parsing.token.text = NULLPTR;
        }
	    return -1;
	}	
	msg_ptr->length = Str2Int(pToken->text);
    
  	if (parsing.token.text)
	{
		free(parsing.token.text);
		parsing.token.text = NULLPTR;
	}
    return 0;
}


 SINT32 Parse_Zgiidf_Res(ZBL_CHANNEL_MSG_INFO **ppMsg, const CHAR *pRes, UINT32 nSize, UINT32 iChannel_id)
{
    ParsingText parsing = {0};
    Token *pToken = NULLPTR;    
    atiUsatImgInstanceSt *msg_ptr = NULLPTR;
    
	if(NULL == ppMsg || NULLPTR == pRes)
    {
        zblAssert(0);
        return -1;
    }    
	ZTE_Trace(ZBL_AT, 0, "Parse_Zgiidf_Res");
	*ppMsg = zblMallocChannelMsg(sizeof(atiUsatImgInstanceSt));
    if(NULLPTR == *ppMsg)
    {
        zblAssert(0);
        return -1;
    }

    (*ppMsg)->msgId = ATI_STK_GET_IMAGE_INSTANCE_RESULT;
    (*ppMsg)->msgSize = sizeof(atiUsatImgInstanceSt);
	msg_ptr = (atiUsatImgInstanceSt*)(*ppMsg)->msgData;
	if(NULL == msg_ptr)
	{
	    zblFreeChannelMsg(ppMsg);
	    return -1;
	}
    //memset(msg_ptr, 0, sizeof(atiUsatImgInstanceSt));
    
    parsing.text = pRes;
    parsing.length = nSize;
    parsing.offset = 0;
    parsing.start = 0;
    
    parsing.token.text = NULLPTR;
    parsing.token.start = 0;
    parsing.token.end = 0;	

    //:
    pToken = GetToken(&parsing);
    //data
    pToken = GetParam(&parsing);
	if(NULL == pToken || 13 == pToken->text[0])
	{
	    zblFreeChannelMsg(ppMsg);
        if (parsing.token.text)
        {
            free(parsing.token.text);
            parsing.token.text = NULLPTR;
        }
	    return -1;
	}	
    msg_ptr->length = strlen(pToken->text)+1;
    memset(msg_ptr->data_ptr, 0, msg_ptr->length);
    memcpy(&msg_ptr->data_ptr, pToken->text, msg_ptr->length);
    
  	if (parsing.token.text)
	{
		free(parsing.token.text);
		parsing.token.text = NULLPTR;
	}
    return 0;
}





static SINT32 stkDecodeDuration(ParsingText* parsing, CHAR* timeUnit)
{
	Token *pToken = NULL;
	SINT32 iTimeUnit = 0;
	SINT32 iTimeFreq = 0;
	SINT32 iDuration = 0;

	if (NULLPTR == parsing || NULLPTR == timeUnit)
	{
		zblAssert(0);
		return 0;
	}
    iTimeUnit = Str2Int(timeUnit);
	
	pToken = GetParam(parsing);
	if (NULLPTR != pToken)
	{
		iTimeFreq = Str2Int(pToken->text);
		if (0 == iTimeUnit)    //ʱ䵥λΪ
		{
			iDuration = iTimeFreq *60 *10;
		}	
		else if (1 == iTimeUnit)  //ʱ䵥λΪ
		{
			iDuration = iTimeFreq *10;
		}	
		else if (2 == iTimeUnit)   //ʱ䵥λΪ1/10
		{
			iDuration = iTimeFreq;
		}
		else 
		{
			iDuration = 0;
		}		
	}
    if (parsing->token.text)
    {
        free(parsing->token.text);
        parsing->token.text = NULLPTR;
    }
	return iDuration;

}

VOID initStkCmdDtl() 
{
	memset(&g_stk_cmd_dtl, 0, sizeof(g_stk_cmd_dtl));
	return;
}

static atiUsatItem* decode90Item(ParsingText* parsing,UINT32 iItemNum)
{
    Token *pToken = NULLPTR;
	atiUsatItem  *item_ptr = NULLPTR;
	//atiUsatItem  usatItem[0] = {0};
	UINT8 i = 0;
	UINT8 iItemId = 2;
	UINT32 iItemCount = 0;
	
	at_print(AT_ERR,"decode90Item 0 iItemNum=%d\r\n",iItemNum); 
	if (NULL == parsing)
	{
	
		at_print(AT_ERR,"decode90Item 1"); 
		return NULL;
	}
	
	//ItemID
	pToken = GetParam(parsing);
	if(NULL == pToken)
	{     
	
	at_print(AT_ERR,"decode90Item 2"); 
	    return NULL;
	}	

	item_ptr = (atiUsatItem *)malloc(sizeof(atiUsatItem)*iItemNum);
	if (NULL == item_ptr)
	{
		zblAssert(0);
		return NULL;
	}
	
	item_ptr->item_id = Str2Int(pToken->text);
	while(0 < iItemId )
	{	
	    iItemCount ++;
	    //ItemNAI		
	    if((parsing->offset < parsing->length)&&(',' == parsing->text[parsing->offset]))
    	{
			parsing->offset++;
	    }
		else
		{
		    pToken = GetParam(parsing);
        	if(NULL == pToken)
        	{      
        	
			at_print(AT_ERR,"decode90Item 3"); 
				goto DECODE_ERR;
        	}	 		    
			(item_ptr+i)->next_action = Str2Int(pToken->text);
	    }
		//ItemIconID
	    if((parsing->offset < parsing->length)&&(',' == parsing->text[parsing->offset]))
    	{
			parsing->offset++;
	    }
		else
		{
		    pToken = GetParam(parsing);
        	if(NULL == pToken)
        	{   
        	
			at_print(AT_ERR,"decode90Item 4"); 
				goto DECODE_ERR;
        	}	 		    
			(item_ptr+i)->icon_st.id = Str2Int(pToken->text);
		}
	
		//ItemTxtStr
	    if((parsing->offset < parsing->length)&&(',' == parsing->text[parsing->offset]))
    	{
			parsing->offset++;
	    }
		else
		{
		    pToken = GetParam(parsing);
        	if(NULL == pToken)
        	{      
        	
			at_print(AT_ERR,"decode90Item 5"); 
				goto DECODE_ERR;
        	}	 		    
			
			memset((item_ptr+i)->str_ptr, 0, ATI_USAT_MENU_TEXT_LEN_MAX);
			if(NULL == decode90ItemTextData((item_ptr+i)->str_ptr, ATI_USAT_MENU_TEXT_LEN_MAX, pToken->text))
			{       
			
			at_print(AT_ERR,"decode90Item 6"); 
				goto DECODE_ERR;
			}
		}
		//TxtAtr
	    if((parsing->offset < parsing->length)&&(',' == parsing->text[parsing->offset]))
    	{
			parsing->offset++;
	    }
		else
		{
	        pToken = GetParam(parsing);
		}
		if(iItemCount >= iItemNum)
		    break;		
		//Next ItemID or ItemLstQuf
		pToken = GetParam(parsing);
		if (NULL == pToken)
		{       
		
		at_print(AT_ERR,"decode90Item 7"); 
            goto DECODE_ERR;
		}
		iItemId = Str2Int(pToken->text);
		if (iItemId > 0)   //Next ItemID
		{			
			i++;
			(item_ptr+i)->item_id = iItemId;						
		}		 
	}//while

	at_print(AT_ERR,"decode90Item 8\r\n"); 

	if (parsing->token.text)
    {
        free(parsing->token.text);
        parsing->token.text = NULLPTR;
    }
	return item_ptr;
DECODE_ERR:	
    if (parsing->token.text)
    {
        free(parsing->token.text);
        parsing->token.text = NULLPTR;
    }
	if(item_ptr)
	{
		free(item_ptr);
		item_ptr = NULLPTR;
	}
	return NULL;	
}

static CHAR* decode90ItemTextData(CHAR* dest, SINT32 dest_len, CHAR* source)
{
	if (NULL == source)
	{
		return NULL;
	}
	int len = strlen(source);
	int src_pos = 0;
	int dest_pos = 0;
	CHAR textCvt[ATI_USAT_MAX_LENGTH_LONG_TEXT_STRING+2] = {0};
	UINT8 flag = 0;

	zblAssert(dest_len >= (len*2));
	//ĳЩ£Ϊա
	if (0 == len || NULL == dest)
	{
		return NULL;
	}
   	//ǿڴ
	memset(dest, 0, dest_len);
	
    if((source[0] == '8') && (source[1] == '1')) //81ʽ
    {
        UINT16 i = 0;
        UINT16 k = 0;
        UINT16 offSet = 0;
        UINT16 strBuf = 0;
        CHAR tempText[ATI_USAT_MAX_LENGTH_LONG_TEXT_STRING/2] = {0};
        CHAR tarText[ATI_USAT_MAX_LENGTH_LONG_TEXT_STRING] = {0};
        String2Bytes(source, tempText, strlen(source));

        /* 8102E4B8B8 */
        offSet = ((UINT16)tempText[2]) << 7;
        offSet &= 0x7F80;  //0111 1111 1000 0000
        //i = 0;
        
        while (k < tempText[1])
        {
            if (tempText[i + 3] != 0)
            {
                if (tempText[i + 3] >> 7) 
                {
                    strBuf = offSet + (((UINT16)tempText[i + 3]) & 0x007F);
                    sprintf((char *)&tarText[4 * k], "%X", strBuf);
					k++;
                }
                else
                {
                    sprintf((char *)&tarText[4 * k], "00%02X", tempText[i + 3] );
					k++;
                }                    
            }               
            i++;
        }
        tarText[4 * k] = 0; 
        textCvt[0] = '8';
        textCvt[1] = '0';
        memcpy((void*)&textCvt[2], tarText, ATI_USAT_MAX_LENGTH_LONG_TEXT_STRING);
    }
    else if((source[0] == '8') && (source[1] == '2')) //82ʽ
    {
        UINT16 i = 0;
        UINT16 k = 0;
        UINT16 offSet = 0;
        UINT16 strBuf = 0;
        CHAR tempText[ATI_USAT_MAX_LENGTH_LONG_TEXT_STRING/2] = {0};
        CHAR tarText[ATI_USAT_MAX_LENGTH_LONG_TEXT_STRING] = {0};
        String2Bytes(source, tempText, strlen(source));

        /* 8204820085852F4D  */
        offSet = (((UINT16)tempText[2]) << 8) | ((UINT16)tempText[3]);
        
        while (k < tempText[1])
        {
            if (tempText[i + 4] != 0)
            {
                if (tempText[i + 4] >> 7) 
                {
                    strBuf = offSet + (((UINT16)tempText[i + 4]) & 0x007F);
                    sprintf((char *)&tarText[4 * k], "%X", strBuf);
                    k++;
                }
                else
                {
                    sprintf((char *)&tarText[4 * k], "00%02X", tempText[i + 4] );
                    k++;
                }                    
            }               
            i++;
        }
        tarText[4 * k] = 0;  
        textCvt[0] = '8';
        textCvt[1] = '0';
        memcpy((void*)&textCvt[2], tarText, ATI_USAT_MAX_LENGTH_LONG_TEXT_STRING);
    }
    else if((source[0] == '8') && (source[1] == '0'))  //8080ʽ
    {
        memcpy(textCvt, source, strlen(source)+1);	
    }   
    else
    {
        //flag = 1;
        CHAR tmpStr[ATI_USAT_MAX_LENGTH_LONG_TEXT_STRING] = {0};
        memcpy(textCvt, source, strlen(source)+1);
        len = strlen(textCvt)/2;
        for (; dest_pos<len; )
        {
        	tmpStr[dest_pos] = ((charToValue(textCvt[src_pos]) << 4) | charToValue(textCvt[src_pos+1]));
        	dest_pos ++;
        	src_pos += 2;
        }
        atSMS7toUcs2(dest, tmpStr, len);
        //memcpy(dest, source, strlen(source));	
        return dest;
    }

	//ô˷ʱΪҪ21
	len = strlen(textCvt)/2;

	for (; dest_pos<len; )
	{
		dest[dest_pos] = ((charToValue(textCvt[src_pos]) << 4) | charToValue(textCvt[src_pos+1]));
		dest_pos ++;
		src_pos += 2;
	}
	return dest;
}
static CHAR* decode90TextData(CHAR* dest, SINT32 dest_len, CHAR* source)
{
	if (NULL == source)
	{
		return NULL;
	}
	int len = strlen(source);
	int src_pos = 0;
	int dest_pos = 0;
	CHAR textCvt[ATI_USAT_MAX_LENGTH_LONG_TEXT_STRING+2] = {0};

	zblAssert(dest_len >= (len*2));
	//ĳЩ£Ϊա
	if (0 == len || NULL == dest)
	{
		return NULL;
	}
       
    if((source[0] == '8') && (source[1] == '1')) //81ʽ
    {
        UINT16 i = 0;
        UINT16 k = 0;
        UINT16 offSet = 0;
        UINT16 strBuf = 0;
        CHAR tempText[ATI_USAT_MAX_LENGTH_LONG_TEXT_STRING/2] = {0};
        CHAR tarText[ATI_USAT_MAX_LENGTH_LONG_TEXT_STRING] = {0};
        String2Bytes(source, tempText, strlen(source));

        /* 8102E4B8B8 */
        offSet = ((UINT16)tempText[2]) << 7;
        offSet &= 0x7F80;  //0111 1111 1000 0000
        //i = 0;
        
        while (k < tempText[1])
        {
            if (tempText[i + 3] != 0)
            {
                if (tempText[i + 3] >> 7) 
                {
                    strBuf = offSet + (((UINT16)tempText[i + 3]) & 0x007F);
                    sprintf((char *)&tarText[4 * k], "%X", strBuf);
					k++;
                }
                else
                {
                    sprintf((char *)&tarText[4 * k], "00%02X", tempText[i + 3] );
					k++;
                }                    
            }               
            i++;
        }
        tarText[4 * k] = 0; 
        textCvt[0] = '8';
        textCvt[1] = '0';
        memcpy((void*)&textCvt[2], tarText, ATI_USAT_MAX_LENGTH_LONG_TEXT_STRING);
    }
    else if((source[0] == '8') && (source[1] == '2')) //82ʽ
    {
        UINT16 i = 0;
        UINT16 k = 0;
        UINT16 offSet = 0;
        UINT16 strBuf = 0;
        CHAR tempText[ATI_USAT_MAX_LENGTH_LONG_TEXT_STRING/2] = {0};
        CHAR tarText[ATI_USAT_MAX_LENGTH_LONG_TEXT_STRING] = {0};
        String2Bytes(source, tempText, strlen(source));

        /* 8204820085852F4D  */
        offSet = (((UINT16)tempText[2]) << 8) | ((UINT16)tempText[3]);
        
        while (k < tempText[1])
        {
            if (tempText[i + 4] != 0)
            {
                if (tempText[i + 4] >> 7) 
                {
                    strBuf = offSet + (((UINT16)tempText[i + 4]) & 0x007F);
                    sprintf((char *)&tarText[4 * k], "%X", strBuf);
                    k++;
                }
                else
                {
                    sprintf((char *)&tarText[4 * k], "00%02X", tempText[i + 4] );
                    k++;
                }                    
            }               
            i++;
        }
        tarText[4 * k] = 0;  
        textCvt[0] = '8';
        textCvt[1] = '0';
        memcpy((void*)&textCvt[2], tarText, ATI_USAT_MAX_LENGTH_LONG_TEXT_STRING);
    }
    else   //8080ʽ
    {
        memcpy(textCvt, source, strlen(source)+1);	
    }   

	//ǿڴ
	memset(dest, 0, dest_len);
	//ô˷ʱΪҪ21
	len = strlen(textCvt)/2;

	for (; dest_pos<len; )
	{
		dest[dest_pos] = ((charToValue(textCvt[src_pos]) << 4) | charToValue(textCvt[src_pos+1]));
		dest_pos ++;
		src_pos += 2;
	}
	return dest;
}

UINT8 zblStkGetCodeType(UINT8 dcs)
{
    UINT8 iValue76 = (dcs & 0xC0) >> 6; /* bit value range 7-6 of byte */
    UINT8 iValue74 = (dcs & 0xF0) >> 4; /* bit value range 7-4 of byte */
    UINT8 iValue32 = (dcs & 0xC) >> 2; /* bit value range 3-2 of byte */
    UINT8 iValue2 = (dcs & 0x4) >> 2; /* bit value 2th of byte */

    if (iValue76 == 0 || iValue76 == 1)
    {
        if (iValue32 == 0)
        {
            return STK_CODE_MODE_GSM7;
        }
        else if (iValue32 == 2)
        {
            return STK_CODE_MODE_UCS2;
        }        
        else
        {
            return STK_CODE_MODE_GSM8;
        }   
    }
    else if (iValue74 == 0xF)
    {
        if (iValue2 == 0)
        {
            return STK_CODE_MODE_GSM7;
        }    
        else
        {
            return STK_CODE_MODE_GSM8;
        }   
        
    }
    return -1;
}

static UINT8 packSmsPdu(CHAR* src, CHAR* dst)
{
    SINT32 tmpNum = 0;
    CHAR tempStr[ATI_USAT_MAX_LENGTH_LONG_TEXT_STRING] = {0};//"0100 05 810180F6 00040953494D435848465A48";
    CHAR* pSrc = src;
    UINT8 prelen = 0;
    SINT32 nDstLength = 0;
    BOOL vpfExist = FALSE;

    if (NULL == dst || NULL == src)
	{
		return -1;
	}    
	  
    memcpy((CHAR*)&tempStr, pSrc, 2);
    tmpNum = HexStr2Int((CHAR*)&tempStr); 
    if((tmpNum & 0x18) != 0 )
    {
        vpfExist= TRUE;
    }
    pSrc += 4;	
    prelen += 4;	
	
    memset(tempStr, 0 ,sizeof(tempStr));
    memcpy((CHAR*)&tempStr, pSrc, 2);
    tmpNum = HexStr2Int((CHAR*)&tempStr); 
    if(tmpNum & 1)                                     // ż
    {
        tmpNum += 1;
    }
    pSrc += 4;      
    pSrc += tmpNum;
    pSrc += 2;  
    prelen = prelen + 6 + tmpNum;
    memcpy(dst, src, prelen);  
	dst[prelen]=0;
    #if 0  //zxj 8bit
    strncat(dst, "04", 2);    
    memset(tempStr, 0 ,sizeof(tempStr));  
    pSrc += 2; 
    memcpy((CHAR*)&tempStr, pSrc, strlen(pSrc));
    strncat(dst, tempStr, strlen(tempStr));
    #else  //zxj 7bit
   
    memset(tempStr, 0 ,sizeof(tempStr));
    memcpy((CHAR*)&tempStr, pSrc, 2);
    tmpNum = Str2Int((CHAR*)&tempStr); 
    

    pSrc += 2;      
    memset(tempStr, 0 ,sizeof(tempStr));
    memcpy((CHAR*)&tempStr, pSrc, 2);
    tmpNum = Str2Int((CHAR*)&tempStr); //

    pSrc += 2;  
    memset(tempStr, 0 ,sizeof(tempStr));

    //tempStr
    nDstLength = String2Bytes(pSrc, tempStr, strlen(pSrc));			// ʽת
            
    //decode90TextData((CHAR*)&tempStr, USAT_MAX_LENGTH_LONG_TEXT_STRING, pSrc);
    {
        CHAR tmpStr[ATI_USAT_MAX_LENGTH_LONG_TEXT_STRING] = {0};
        SINT32 length = 0;	
        
        length = Encode7bit((CHAR *)tempStr, (UINT8 *)&(tmpStr), strlen(tempStr)+1);        
        memset(tempStr, 0 ,sizeof(tempStr));      
        

        bytes2string((UINT8*)tmpStr, (CHAR*)tempStr, length);
        
        strncat(dst, "00", 2);
        if(vpfExist == TRUE)
        {
            strncat(dst, "FF", 2);
        }
        memset(tmpStr, 0 ,sizeof(tmpStr));    
        snprintf(tmpStr, sizeof(tmpStr)-1, "%02X", nDstLength);
        strncat(dst, tmpStr, strlen(tmpStr));
        strncat(dst, tempStr, strlen(tempStr));
    }    
    #endif
	
    return 0;    
}
#if 0
/**************************************************************************
* ƣ codeTextData
*  sourceǰ0x80,ͬʱʵ'00'->"00"Ӷatucs-2ʱʧ
* ˵ (IN)
                                  (OUT)
*   ֵ 
* ˵ 
**************************************************************************/
UINT16 codeTextData(CHAR* dest, CHAR* source)
{
    UINT16 j;
    UINT8 tmpStr[ZBL_USAT_MAX_LENGTH_LONG_TEXT_STRING] = {0x00};
    
    memset((VOID*)tmpStr, 0x00,ZBL_USAT_MAX_LENGTH_LONG_TEXT_STRING);   

    ZTE_Trace(ZBL_AT,0,"liang:codeTextData source[0]=%d", source[0]);
            
    if (NULL == dest || NULL == source )
    {
        return 0;
    }    
/* modify by zhangfen CQNJ00195117                
    if (0 == source[0])
    {
        return 0;
    }
*/    
    tmpStr[0]=0x80;
    
    for(j = 0; j<source[0] * 2 + 1; j++)
    {
        tmpStr[1+j]= source[j]; 
    }
        
    for(j = 0; j < source[0] * 2 + 2; j++)
    {
        char temp[3] = {0};
        memset((VOID*)temp, 0x00,3); 
        snprintf(temp, 3, "%02x", tmpStr[j]);
       // ZTE_Trace(ZBL_AT,0,"liang:codeTextData temp[j]=%s", j, temp);
        strncat(dest, temp, 2);
       // ZTE_Trace(ZBL_AT,0,"liang:dest=%s", dest);        
    }
         
    return strlen(dest);
}
#endif


/**************************************************************************
* ƣ codeTextData90
*  sourceǰ0x80,ͬʱʵ'00'->"00"Ӷatucs-2ʱʧ
* ˵ (IN)
                                  (OUT)
*   ֵ 
* ˵ 
**************************************************************************/
UINT16 codeTextData90(CHAR* dest, CHAR* source)
{
    UINT16 j;
    UINT8 tmpStr[ATI_USAT_MAX_LENGTH_LONG_TEXT_STRING] = {0x00};
    
    memset((VOID*)tmpStr, 0x00,ATI_USAT_MAX_LENGTH_LONG_TEXT_STRING);   

    if (NULL == dest || NULL == source )
    {
        return 0;
    }    
    ZTE_Trace(ZBL_AT,0,"liang:codeTextData source[0]=%d", source[0]);
            
                
    if (0 == source[0])
    {
        return 0;
    }
    
    tmpStr[0]=0x80;
    
    for(j = 0; j<source[0] * 2 + 1; j++)
    {
        tmpStr[1+j]= source[j]; 
    }
        
    for(j = 0; j < source[0] * 2 + 2; j++)
    {
        char temp[3] = {0};
        memset((VOID*)temp, 0x00,3); 
        snprintf(temp, 3, "%02x", tmpStr[j]);
        //ZTE_Trace(ZBL_AT,0,"liang:codeTextData temp[j]=%s", j, temp);
        strncat(dest, temp, 2);
        ZTE_Trace(ZBL_AT,0,"liang:dest=%s", dest);        
    }
    {
        UINT8 tempStr[ATI_USAT_MAX_LENGTH_LONG_TEXT_STRING +1] = {0};
        memcpy(&tempStr, (void *)&dest[4], ATI_USAT_MAX_LENGTH_LONG_TEXT_STRING);       
        //memset((VOID*)&dest[2], 0x00,USAT_MAX_LENGTH_LONG_TEXT_STRING); 
        //memcpy((void *)&dest[2], (void *)&tempStr[0], USAT_MAX_LENGTH_LONG_TEXT_STRING); 
        memcpy((void *)dest, (void *)&tempStr, ATI_USAT_MAX_LENGTH_LONG_TEXT_STRING+1); 
    }  
     
    return strlen(dest);
}





 SINT32 Parse_Zupci_Res(ZBL_CHANNEL_MSG_INFO **ppMsg, const CHAR *pRes, UINT32 nSize, UINT32 iChannel_id)
{
    ParsingText parsing = {0};
    Token *pToken = NULLPTR;
    SINT32 iCmdType = 0;
    
    if(NULLPTR == ppMsg)
    {
        zblAssert(0);
        return -1;
    }
    
    if(NULLPTR == pRes)
    {
        zblAssert(0);
        return -1;
    }
    
    parsing.text = pRes;
    parsing.length = nSize;
    parsing.offset = 0;
    parsing.start = 0;
    
    parsing.token.text = NULLPTR;
    parsing.token.start = 0;
    parsing.token.end = 0;	

    //:
    pToken = GetToken(&parsing);
    //ҵҵ	
    pToken = GetParam(&parsing);
	if(pToken)
    iCmdType = Str2Int(pToken->text);
    g_stk_cmd_dtl.cmdType = iCmdType;   /*record for terminalRsp*/
    
    switch(iCmdType)
    {
    case STK_PROCMD_TYPE_REFRESH:  //1
        {
            if (-1 == Parse_Zupci_Refresh(&parsing, ppMsg))
            {
                ZTE_Trace(ZBL_AT, 0, "Parse_Zupci_Refresh ERROR! ");
            	if (parsing.token.text)
            	{
            		free(parsing.token.text);
            		parsing.token.text = NULLPTR;
            	}
                return -1;
            }		
            ZTE_Trace(ZBL_AT, 0, "Parse_Zupci_Res(): service= STK_PROCMD_TYPE_REFRESH, length=%d, end=%02x, pRes=%s", nSize, (nSize >0)?pRes[nSize-1]:0xff, pRes);
        } 
        break;
    case STK_PROCMD_TYPE_MORE_TIME://2
        {
            if (-1 == Parse_Zupci_MoreTime(&parsing, ppMsg))
            {
                ZTE_Trace(ZBL_AT, 0, "Parse_Zupci_MoreTime ERROR! ");       
            	if (parsing.token.text)
            	{
            		free(parsing.token.text);
            		parsing.token.text = NULLPTR;
            	}
                return -1;
            }		
            ZTE_Trace(ZBL_AT, 0, "Parse_Zupci_Res(): service= STK_PROCMD_TYPE_MORE_TIME, length=%d, end=%02x, pRes=%s", nSize, (nSize >0)?pRes[nSize-1]:0xff, pRes);
        }
        break;    
    case STK_PROCMD_TYPE_POLINTVL:  //3
        {
            if (-1 == Parse_Zupci_PolIntvl(&parsing, ppMsg))
            {
                ZTE_Trace(ZBL_AT, 0, "Parse_Zupci_CloseChnl ERROR! ");
            	if (parsing.token.text)
            	{
            		free(parsing.token.text);
            		parsing.token.text = NULLPTR;
            	}
                return -1;
            }		
            ZTE_Trace(ZBL_AT, 0, "Parse_Zupci_Res(): service= STK_PROCMD_TYPE_POLINTVL, length=%d, end=%02x, pRes=%s", nSize, (nSize >0)?pRes[nSize-1]:0xff, pRes);
        }
        break;
    case STK_PROCMD_TYPE_POLL_OFF:  //4
        {
            if (-1 == Parse_Zupci_PollOff(&parsing, ppMsg))
            {
                ZTE_Trace(ZBL_AT, 0, "Parse_Zupci_PollOff ERROR! ");
            	if (parsing.token.text)
            	{
            		free(parsing.token.text);
            		parsing.token.text = NULLPTR;
            	}
                return -1;
            }		
            ZTE_Trace(ZBL_AT, 0, "Parse_Zupci_Res(): service= STK_PROCMD_TYPE_POLL_OFF, length=%d, end=%02x, pRes=%s", nSize, (nSize >0)?pRes[nSize-1]:0xff, pRes);
        }
        break;
    case STK_PROCMD_TYPE_SETUP_EVNT://5
        {
            if (-1 == Parse_Zupci_SetupEvnt(&parsing, ppMsg))
            {
                ZTE_Trace(ZBL_AT, 0, "Parse_Zupci_SetupEvnt ERROR! ");
            	if (parsing.token.text)
            	{
            		free(parsing.token.text);
            		parsing.token.text = NULLPTR;
            	}
                return -1;
            }		
            ZTE_Trace(ZBL_AT, 0, "Parse_Zupci_Res(): service= STK_PROCMD_TYPE_SETUP_EVNT, length=%d, end=%02x, pRes=%s", nSize, (nSize >0)?pRes[nSize-1]:0xff, pRes);
        }
        break;
    case STK_PROCMD_TYPE_SETUP_CALL:     //10
        {
            if (-1 == Parse_Zupci_SetupCall(&parsing, ppMsg))
            {
                ZTE_Trace(ZBL_AT, 0, "Parse_Zupci_SetupCall ERROR! ");
            	if (parsing.token.text)
            	{
            		free(parsing.token.text);
            		parsing.token.text = NULLPTR;
            	}
                return -1;
            }		
            ZTE_Trace(ZBL_AT, 0, "Parse_Zupci_Res(): service= STK_PROCMD_TYPE_SETUP_CALL, length=%d, end=%02x, pRes=%s", nSize, (nSize >0)?pRes[nSize-1]:0xff, pRes);
        }
        break;
    case STK_PROCMD_TYPE_SEND_SS://11
        {
            if (-1 == Parse_Zupci_SendSs(&parsing, ppMsg))
            {
                ZTE_Trace(ZBL_AT, 0, "Parse_Zupci_SendSs ERROR! ");
            	if (parsing.token.text)
            	{
            		free(parsing.token.text);
            		parsing.token.text = NULLPTR;
            	}
                return -1;
            }		
            ZTE_Trace(ZBL_AT, 0, "Parse_Zupci_Res(): service= STK_PROCMD_TYPE_SEND_SS, length=%d, end=%02x, pRes=%s", nSize, (nSize >0)?pRes[nSize-1]:0xff, pRes);
        }
        break;        
    case STK_PROCMD_TYPE_SEND_USSD:      //12
        {
            if (-1 == Parse_Zupci_SendUssd(&parsing, ppMsg))
            {
                ZTE_Trace(ZBL_AT, 0, "Parse_Zupci_SendUssd ERROR! ");
            	if (parsing.token.text)
            	{
            		free(parsing.token.text);
            		parsing.token.text = NULLPTR;
            	}
                return -1;
            }		
            ZTE_Trace(ZBL_AT, 0, "Parse_Zupci_Res(): service= STK_PROCMD_TYPE_SEND_USSD, length=%d, end=%02x, pRes=%s", nSize, (nSize >0)?pRes[nSize-1]:0xff, pRes);
        }
        break;
    case STK_PROCMD_TYPE_SEND_SMS://13
        {
            if (-1 == Parse_Zupci_SendSms(&parsing, ppMsg))
            {
                ZTE_Trace(ZBL_AT, 0, "Parse_Zupci_SendSms ERROR! ");
                /*modify by zxj 2009-08-05 ߲飬ڴй©*/
            	if (parsing.token.text)
            	{
            		free(parsing.token.text);
            		parsing.token.text = NULLPTR;
            	}
                return -1;
            }		
            ZTE_Trace(ZBL_AT, 0, "Parse_Zupci_Res(): service= STK_PROCMD_TYPE_SEND_SMS, length=%d, end=%02x, pRes=%s", nSize, (nSize >0)?pRes[nSize-1]:0xff, pRes);
        }
        break;

    case STK_PROCMD_TYPE_DISPLAY_TEXT://21
        {
            if (-1 == Parse_Zupci_DisplayText(&parsing, ppMsg))
            {
                ZTE_Trace(ZBL_AT, 0, "Parse_Zupci_DisplayText ERROR! ");
                /*modify by zxj 2009-08-05 ߲飬ڴй©*/
            	if (parsing.token.text)
            	{
            		free(parsing.token.text);
            		parsing.token.text = NULLPTR;
            	}
                return -1;
            }		
            ZTE_Trace(ZBL_AT, 0, "Parse_Zupci_Res(): service= STK_PROCMD_TYPE_DISPLAY_TEXT, length=%d, end=%02x, pRes=%s", nSize, (nSize >0)?pRes[nSize-1]:0xff, pRes);
        }
        break;        
    case STK_PROCMD_TYPE_GET_INKEY://22
         {
            if (-1 == Parse_Zupci_GetInkey(&parsing, ppMsg))
            {
                ZTE_Trace(ZBL_AT, 0, "Parse_Zupci_GetInkey ERROR! ");
                /*modify by zxj 2009-08-05 ߲飬ڴй©*/        
            	if (parsing.token.text)
            	{
            		free(parsing.token.text);
            		parsing.token.text = NULLPTR;
            	}
                return -1;
            }		
            ZTE_Trace(ZBL_AT, 0, "Parse_Zupci_Res(): service= STK_PROCMD_TYPE_GET_INKEY, length=%d, end=%02x, pRes=%s", nSize, (nSize >0)?pRes[nSize-1]:0xff, pRes);
        }
        break;             
    case STK_PROCMD_TYPE_GET_INPUT://23
        {
            if (-1 == Parse_Zupci_GetInput(&parsing, ppMsg))
            {
                ZTE_Trace(ZBL_AT, 0, "Parse_Zupci_GetInput ERROR! ");
                /*modify by zxj 2009-08-05 ߲飬ڴй©*/        
            	if (parsing.token.text)
            	{
            		free(parsing.token.text);
            		parsing.token.text = NULLPTR;
            	}
                return -1;
            }		
            ZTE_Trace(ZBL_AT, 0, "Parse_Zupci_Res(): service= STK_PROCMD_TYPE_GET_INPUT, length=%d, end=%02x, pRes=%s", nSize, (nSize >0)?pRes[nSize-1]:0xff, pRes);
        }
        break;
    case STK_PROCMD_TYPE_SEL_ITEM://24
        {
            if (-1 == Parse_Zupci_SelItem(&parsing, ppMsg))
            {
                ZTE_Trace(ZBL_AT, 0, "Parse_Zupci_SelItem ERROR! ");
                /*modify by zxj 2009-08-05 ߲飬ڴй©*/
            	if (parsing.token.text)
            	{
            		free(parsing.token.text);
            		parsing.token.text = NULLPTR;
            	}
                return -1;
            }		
            ZTE_Trace(ZBL_AT, 0, "Parse_Zupci_Res(): service= STK_PROCMD_TYPE_SEL_ITEM, length=%d, end=%02x, pRes=%s", nSize, (nSize >0)?pRes[nSize-1]:0xff, pRes);
        }
        break;
    case STK_PROCMD_TYPE_SETUP_MENU://25
        {
            if (-1 == Parse_Zupci_SetupMenu(&parsing, ppMsg))
            {
                at_print(AT_ERR,"STK_PROCMD_TYPE_SETUP_MENU ERROR! ");
                /*modify by zxj 2009-08-05 ߲飬ڴй©*/
            	if (parsing.token.text)
            	{
            		free(parsing.token.text);
            		parsing.token.text = NULLPTR;
            	}
                return -1;
            }		
            at_print(AT_ERR,"Parse_Zupci_Res(): service= STK_PROCMD_TYPE_SETUP_MENU, length=%d, end=%02x, pRes=%s\r\n", nSize, (nSize >0)?pRes[nSize-1]:0xff, pRes);
        }
        break;
    case STK_PROCMD_TYPE_PLOC_INFO:  //26    
        {
            if (-1 == Parse_Zupci_PlocInfo(&parsing, ppMsg))
            {
                ZTE_Trace(ZBL_AT, 0, "Parse_Zupci_PlocInfo ERROR! ");
            	if (parsing.token.text)
            	{
            		free(parsing.token.text);
            		parsing.token.text = NULLPTR;
            	}
                return -1;
            }		
            ZTE_Trace(ZBL_AT, 0, "Parse_Zupci_Res(): service= STK_PROCMD_TYPE_PLOC_INFO, length=%d, end=%02x, pRes=%s", nSize, (nSize >0)?pRes[nSize-1]:0xff, pRes);
        }                           
        break;
    case STK_PROCMD_TYPE_TIMER_MNG:    //27  
        {
            if (-1 == Parse_Zupci_TimerMng(&parsing, ppMsg))
            {
                ZTE_Trace(ZBL_AT, 0, "Parse_Zupci_TimerMng ERROR! ");
            	if (parsing.token.text)
            	{
            		free(parsing.token.text);
            		parsing.token.text = NULLPTR;
            	}
                return -1;
            }		
            ZTE_Trace(ZBL_AT, 0, "Parse_Zupci_Res(): service= STK_PROCMD_TYPE_TIMER_MNG, length=%d, end=%02x, pRes=%s", nSize, (nSize >0)?pRes[nSize-1]:0xff, pRes);
        }
        break;
    case STK_PROCMD_TYPE_OPEN_CHNL:      //40
        {
            if (-1 == Parse_Zupci_OpenChnl(&parsing, ppMsg))
            {
                ZTE_Trace(ZBL_AT, 0, "Parse_Zupci_OpenChnl ERROR! ");
            	if (parsing.token.text)
            	{
            		free(parsing.token.text);
            		parsing.token.text = NULLPTR;
            	}
                return -1;
            }		
            ZTE_Trace(ZBL_AT, 0, "Parse_Zupci_Res(): service= STK_PROCMD_OPEN_CHNL, length=%d, end=%02x, pRes=%s", nSize, (nSize >0)?pRes[nSize-1]:0xff, pRes);
        }
        break;
    case STK_PROCMD_TYPE_CLOSE_CHNL:  //41
        {
            if (-1 == Parse_Zupci_CloseChnl(&parsing, ppMsg))
            {
                ZTE_Trace(ZBL_AT, 0, "Parse_Zupci_CloseChnl ERROR! ");
            	if (parsing.token.text)
            	{
            		free(parsing.token.text);
            		parsing.token.text = NULLPTR;
            	}
                return -1;
            }		
            ZTE_Trace(ZBL_AT, 0, "Parse_Zupci_Res(): service= STK_PROCMD_CLOSE_CHNL, length=%d, end=%02x, pRes=%s", nSize, (nSize >0)?pRes[nSize-1]:0xff, pRes);
        }     
        break;
    case STK_PROCMD_TYPE_RECV_DATA:      //42
        {
            if (-1 == Parse_Zupci_RecvData(&parsing, ppMsg))
            {
                ZTE_Trace(ZBL_AT, 0, "Parse_Zupci_RecvData ERROR! ");
            	if (parsing.token.text)
            	{
            		free(parsing.token.text);
            		parsing.token.text = NULLPTR;
            	}
                return -1;
            }		
            ZTE_Trace(ZBL_AT, 0, "Parse_Zupci_Res(): service= STK_PROCMD_RECV_DATA, length=%d, end=%02x, pRes=%s", nSize, (nSize >0)?pRes[nSize-1]:0xff, pRes);
        }
        break;
    case STK_PROCMD_TYPE_SEND_DATA:      //43
        {
            if (-1 == Parse_Zupci_SendData(&parsing, ppMsg))
            {
                ZTE_Trace(ZBL_AT, 0, "Parse_Zupci_SendData ERROR! ");
            	if (parsing.token.text)
            	{
            		free(parsing.token.text);
            		parsing.token.text = NULLPTR;
            	}
                return -1;
            }		
            ZTE_Trace(ZBL_AT, 0, "Parse_Zupci_Res(): service= STK_PROCMD_SEND_DATA, length=%d, end=%02x, pRes=%s", nSize, (nSize >0)?pRes[nSize-1]:0xff, pRes);
        }
        break;
    case STK_PROCMD_TYPE_GTCHSTAT:  //44
        {
            if (-1 == Parse_Zupci_GetChlStatus(&parsing, ppMsg))
            {
                ZTE_Trace(ZBL_AT, 0, "Parse_Zupci_GetChlStatus ERROR! ");
            	if (parsing.token.text)
            	{
            		free(parsing.token.text);
            		parsing.token.text = NULLPTR;
            	}
                return -1;
            }		
            ZTE_Trace(ZBL_AT, 0, "Parse_Zupci_Res(): service= STK_PROCMD_GTCHSTAT, length=%d, end=%02x, pRes=%s", nSize, (nSize >0)?pRes[nSize-1]:0xff, pRes);
        }        
        break;
    case STK_PROCMD_TYPE_SEND_DTMF:  //0x14
        {
            if (-1 == Parse_Zupci_SendDtmf(&parsing, ppMsg))
            {
            	if (parsing.token.text)
            	{
            		free(parsing.token.text);
            		parsing.token.text = NULLPTR;
            	}
                return -1;
            }		
        }  
        break;
    case STK_PROCMD_TYPE_LAUNCH_BROWSER:  //0x15
        {
            if (-1 == Parse_Zupci_LaunchBrower(&parsing, ppMsg))
            {
            	if (parsing.token.text)
            	{
            		free(parsing.token.text);
            		parsing.token.text = NULLPTR;
            	}
                return -1;
            }		
        }  
        break;
    case STK_PROCMD_TYPE_PLAY_TONE:  //0x20
        {
            if (-1 == Parse_Zupci_PlayTone(&parsing, ppMsg))
            {
            	if (parsing.token.text)
            	{
            		free(parsing.token.text);
            		parsing.token.text = NULLPTR;
            	}
                return -1;
            }		
        }  
        break;
    case STK_PROCMD_TYPE_STIDL_TXT:  //0x28
        {
            if (-1 == Parse_Zupci_SetupIdleText(&parsing, ppMsg))
            {
            	if (parsing.token.text)
            	{
            		free(parsing.token.text);
            		parsing.token.text = NULLPTR;
            	}
                return -1;
            }		
        }  
        break;
    case STK_PROCMD_TYPE_PRCDAPDU:  //0x30
        {
            if (-1 == Parse_Zupci_PrcdaPdu(&parsing, ppMsg))
            {
            	if (parsing.token.text)
            	{
            		free(parsing.token.text);
            		parsing.token.text = NULLPTR;
            	}
                return -1;
            }		
        }     
        break;
    case STK_PROCMD_TYPE_PON_CARD:  //0x31
        {
            if (-1 == Parse_Zupci_PonCard(&parsing, ppMsg))
            {
            	if (parsing.token.text)
            	{
            		free(parsing.token.text);
            		parsing.token.text = NULLPTR;
            	}
                return -1;
            }		
        }     
        break;
    case STK_PROCMD_TYPE_POFF_CARD:  //0x32
        {
            if (-1 == Parse_Zupci_PoffCard(&parsing, ppMsg))
            {
            	if (parsing.token.text)
            	{
            		free(parsing.token.text);
            		parsing.token.text = NULLPTR;
            	}
                return -1;
            }		
        }     
        break;
    case STK_PROCMD_TYPE_GTRDRSTA:  //0x33
        {
            if (-1 == Parse_Zupci_GetReaderStat(&parsing, ppMsg))
            {
            	if (parsing.token.text)
            	{
            		free(parsing.token.text);
            		parsing.token.text = NULLPTR;
            	}
                return -1;
            }		
        }     
        break;
    case STK_PROCMD_TYPE_RUN_ATCMD:  //0x34
        {
            if (-1 == Parse_Zupci_RunAtCmd(&parsing, ppMsg))
            {
            	if (parsing.token.text)
            	{
            		free(parsing.token.text);
            		parsing.token.text = NULLPTR;
            	}
                return -1;
            }		
        }     
        break;
    case STK_PROCMD_TYPE_LNGNOTFY:  //0x35
        {
            if (-1 == Parse_Zupci_LangNotif(&parsing, ppMsg))
            {
            	if (parsing.token.text)
            	{
            		free(parsing.token.text);
            		parsing.token.text = NULLPTR;
            	}
                return -1;
            }		
        }     
        break;
    case STK_PROCMD_TYPE_SERVSRCH:  //0x45
        {
            if (-1 == Parse_Zupci_ServiceSearch(&parsing, ppMsg))
            {
            	if (parsing.token.text)
            	{
            		free(parsing.token.text);
            		parsing.token.text = NULLPTR;
            	}
                return -1;
            }		
        }     
        break;
    case STK_PROCMD_TYPE_GTSERINF:  //0x46
        {
            if (-1 == Parse_Zupci_GetServiceInfo(&parsing, ppMsg))
            {
            	if (parsing.token.text)
            	{
            		free(parsing.token.text);
            		parsing.token.text = NULLPTR;
            	}
                return -1;
            }		
        }     
        break;
    case STK_PROCMD_TYPE_DECLSERV:  //0x47
        {
            if (-1 == Parse_Zupci_DeclearService(&parsing, ppMsg))
            {
            	if (parsing.token.text)
            	{
            		free(parsing.token.text);
            		parsing.token.text = NULLPTR;
            	}
                return -1;
            }		
        }         
        break;    
    default:
        {
            //ZTE_Trace(ZBL_AT, 0, "Parse_Zupci_Res(): service= %s, length=%d, end=%02x, pRes=%s", pToken->text, nSize, (nSize >0)?pRes[nSize-1]:0xff, pRes);
            g_stk_cmd_dtl.cmdType = 0;   /*δӦ¼*/
        }
        break;
    }
    bIsMmiWaiting = FALSE;
    if (parsing.token.text)
    {
        free(parsing.token.text);
        parsing.token.text = NULLPTR;
    }
    
    return 0;
}

 SINT32 Parse_Zuec_Res(ZBL_CHANNEL_MSG_INFO **ppMsg, const CHAR *pRes, UINT32 nSize, UINT32 iChannel_id)
{
    ParsingText parsing = {0};
    Token *pToken = NULLPTR;
    SINT32 iCmdType = 0;
    
    if(NULLPTR == ppMsg)
    {
        zblAssert(0);
        return -1;
    }
    
    if(NULLPTR == pRes)
    {
        zblAssert(0);
        return -1;
    }
    
    parsing.text = pRes;
    parsing.length = nSize;
    parsing.offset = 0;
    parsing.start = 0;
    
    parsing.token.text = NULLPTR;
    parsing.token.start = 0;
    parsing.token.end = 0;	
    
    //:
    pToken = GetParam(&parsing);//zxj mod 100118
    //ҵҵ	
    pToken = GetParam(&parsing);
	if(pToken)
    iCmdType = Str2Int(pToken->text);
    switch(iCmdType)
    {
    case STK_ENV_CONFIRM_TYPE_PP_SMS_DOWN:
        {
            if (-1 == Parse_Zuec_PpSmsDown(&parsing, ppMsg))
            {
                ZTE_Trace(ZBL_AT, 0, "Parse_Zuec_PpSmsDown ERROR! ");
            	if (parsing.token.text)
            	{
            		free(parsing.token.text);
            		parsing.token.text = NULLPTR;
            	}
                return -1;
            }		
            if(nSize >0)
            {
                ZTE_Trace(ZBL_AT, 0, "Parse_Zuec_Res(): service= STK_ENV_CONFIRM_TYPE_PP_SMS_DOWN, length=%d, end=%02x, pRes=%s", nSize, pRes[nSize-1], pRes);
            }
        }
        break;
    case STK_ENV_CONFIRM_TYPE_CALL_CTRL:
        {
            if (-1 == Parse_Zuec_CallCtrl(&parsing, ppMsg))
            {
                ZTE_Trace(ZBL_AT, 0, "Parse_Zuec_CallCtrl ERROR! ");
            	if (parsing.token.text)
            	{
            		free(parsing.token.text);
            		parsing.token.text = NULLPTR;
            	}
                return -1;
            }		
            if(nSize >0)
            {
                ZTE_Trace(ZBL_AT, 0, "Parse_Zuec_Res(): service= STK_ENV_CONFIRM_TYPE_CALL_CTRL, length=%d, end=%02x, pRes=%s", nSize, pRes[nSize-1], pRes);
            }
        }
        break;
    case STK_ENV_CONFIRM_TYPE_SMS_CTRL:
        {
            if (-1 == Parse_Zuec_SmsCtrl(&parsing, ppMsg))
            {
                ZTE_Trace(ZBL_AT, 0, "Parse_Zuec_SmsCtrl ERROR! ");
            	if (parsing.token.text)
            	{
            		free(parsing.token.text);
            		parsing.token.text = NULLPTR;
            	}
                return -1;
            }		
            if(nSize >0)
            {
                ZTE_Trace(ZBL_AT, 0, "Parse_Zuec_Res(): service= STK_ENV_CONFIRM_TYPE_SMS_CTRL, length=%d, end=%02x, pRes=%s", nSize, pRes[nSize-1], pRes);
            }
        }
        break;
        
    default:
        {
            if(nSize >0)
                ZTE_Trace(ZBL_AT, 0, "Parse_Zuec_Res(): length=%d, end=%02x, pRes=%s", nSize, pRes[nSize-1], pRes);
        }
        break;
    }
    /*modify by zxj 2009-08-05 ߲飬ڴй©*/        
	if (parsing.token.text)
	{
		free(parsing.token.text);
		parsing.token.text = NULLPTR;
	}
    return 0;
}

 SINT32 Parse_Zuend_Res(ZBL_CHANNEL_MSG_INFO **ppMsg, const CHAR *pRes, UINT32 nSize, UINT32 iChannel_id)
{
    ParsingText parsing = {0};
    Token *pToken = NULLPTR;    
    UINT8 *msg_ptr = NULLPTR;
    
	if(NULL == ppMsg || NULLPTR == pRes)
    {
        zblAssert(0);
        return -1;
    }    
    
    ZTE_Trace(ZBL_AT, 0, "Parse_Zuend_Res, bIsMmiWaiting = %d", bIsMmiWaiting);
	
	*ppMsg = zblMallocChannelMsg(sizeof(UINT8));
    if(NULLPTR == *ppMsg)
    {
        zblAssert(0);
        return -1;
    }
    (*ppMsg)->msgId = ATI_STK_SESSION_NOTIFICATION;
    (*ppMsg)->msgSize = sizeof(UINT8);
	msg_ptr = (UINT8*)(*ppMsg)->msgData;
	if(NULL == msg_ptr)
	{
	    zblFreeChannelMsg(ppMsg);
	    return -1;
	}
    memset(msg_ptr, 0, sizeof(UINT8));
    
    parsing.text = pRes;
    parsing.length = nSize;
    parsing.offset = 0;
    parsing.start = 0;
    
    parsing.token.text = NULLPTR;
    parsing.token.start = 0;
    parsing.token.end = 0;	

    //:
    pToken = GetToken(&parsing);
    //param
    pToken = GetParam(&parsing);
	if(pToken)
    *msg_ptr = Str2Int(pToken->text);

//zhangfen 20160624 ZUEND:1 ʾص˵
	ZTE_Trace(ZBL_AT, 0, "Parse_Zuend_Res, zuend = %d", *msg_ptr);
	if(FALSE == bIsMmiWaiting && *msg_ptr != 1)
    {
    	zblFreeChannelMsg(ppMsg);
	    if (parsing.token.text)
		{
			free(parsing.token.text);
			parsing.token.text = NULLPTR;
		}
        return -1;   //MMI is not waiting for this msg, drop it
    }
    bIsMmiWaiting = FALSE;
  	if (parsing.token.text)
	{
		free(parsing.token.text);
		parsing.token.text = NULLPTR;
	}
    return 0;
}










SINT32 Make_GeneralTerminalRsp_Cmd(CI_AT_CMD_LINE_T *pCmdLine, const  ZBL_CHANNEL_MSG_INFO *pMsg)
{
	atiUsatTerminalResponse * req_ptr = (atiUsatTerminalResponse*)pMsg->msgData;

#if 0 /*NXPõ*/
    //ǰûҪӦģֱӷ
    if (0 == strlen(response_str))
    {
        zblAssert(0);
    	return -1;
    }
    strncpy(pCmdLine->strCmdOperator, "=", 2);
    snprintf(pCmdLine->strCmdParas, AT_CMD_PARA_MAX_LEN-1, "\"%s\",1,0", response_str);
#endif
    /* ʽִн +ZUTR=<proactive command type>,[<cmd qualifier>],[<cmd num>],[<result>]
			                          [,<add result>][,<proactive cmd data>*]*/
    			                          
    if(0 == g_stk_cmd_dtl.cmdType)       
    {
        zblAssert(0);
    	return -1;         //ǰûҪӦģֱӷ 
    }	


    ZTE_Trace(ZBL_AT, 0, "Make_GeneralTerminalRsp_Cmd() g_stk_cmd_dtl.cmdType=|||%d|||, cause=|||%d|||", g_stk_cmd_dtl.cmdType, req_ptr->gen_cause);	
    strncpy(pCmdLine->strCmdOperator, "=", 2);

    if(ATI_USAT_ICON_NOT_DISPLAYED == req_ptr->icon_display && ATI_USAT_RST_SUCCESS == req_ptr->gen_cause)
    {
        req_ptr->gen_cause = ATI_USAT_RST_OK_ICON_NOT_DISPLAYED; 
    }

    //if(NULL != req_ptr->add_cause_ptr && 0 !=req_ptr->add_cause_len)
    if(0 !=req_ptr->add_cause_len)
    {
        if(0 == g_stk_cmd_dtl.cmdNum)
        {   
        	snprintf(pCmdLine->strCmdParas, AT_CMD_PARA_MAX_LEN-1, "%d,%d,%02d", g_stk_cmd_dtl.cmdType, 
        		 req_ptr->gen_cause, req_ptr->add_cause_ptr);
        }
        else
        {   
            snprintf(pCmdLine->strCmdParas, AT_CMD_PARA_MAX_LEN-1, "%d,%d,%d,%d,%02d", g_stk_cmd_dtl.cmdType, 
                g_stk_cmd_dtl.cmdQual, g_stk_cmd_dtl.cmdNum, req_ptr->gen_cause, req_ptr->add_cause_ptr);
        }
    }
    else
    {
        if(0 == g_stk_cmd_dtl.cmdNum)
        {   
            snprintf(pCmdLine->strCmdParas, AT_CMD_PARA_MAX_LEN-1, "%d,%d", g_stk_cmd_dtl.cmdType, 
            req_ptr->gen_cause);
        }
        else
        {
            snprintf(pCmdLine->strCmdParas, AT_CMD_PARA_MAX_LEN-1, "%d,%d,%d,%d", g_stk_cmd_dtl.cmdType, 
                g_stk_cmd_dtl.cmdQual, g_stk_cmd_dtl.cmdNum, req_ptr->gen_cause);
        }
    }
    initStkCmdDtl();
    atiCmdIdSet(CMD_STK_TERMINAL_RSP);
    return 0;
}
#if 0 //NXPõ,
static SINT32 Make_GetItemList_Cmd(CI_AT_CMD_LINE_T *pCmdLine, const  ZBL_CHANNEL_MSG_INFO *pMsg)
{
	SINT32* ptr;
    strncpy(pCmdLine->strCmdOperator, "=", 2);
	ptr = (SINT32*)(pMsg->msgData);
    ZTE_Trace(0, 0, "Make_GetItemList_Cmd() %d", (*ptr));
   	snprintf(pCmdLine->strCmdParas, AT_CMD_PARA_MAX_LEN-1, "\"GET ITEM LIST\",%d", (*ptr));
    atiCmdIdSet(CMD_STK_GETITEMLIST_REQ);
	return 0;
}
#endif
/**
 *
 */
SINT32 Make_MenuSelection_Cmd(CI_AT_CMD_LINE_T *pCmdLine, const  ZBL_CHANNEL_MSG_INFO *pMsg)
{
	atiUsatMenuSelection* ptr;
//zhangfen 20160516
	bIsMmiWaiting = TRUE;
    strncpy(pCmdLine->strCmdOperator, "=", 2);
	ptr = (atiUsatMenuSelection*)(pMsg->msgData);
    ZTE_Trace(ZBL_AT, 0, "Make_MenuSelection_Cmd() %d", ptr->item_id);
    //NXPõ
	//snprintf(pCmdLine->strCmdParas, AT_CMD_PARA_MAX_LEN-1, "\"MENU SELECTION\",%d", ptr->item_id);
    snprintf(pCmdLine->strCmdParas, AT_CMD_PARA_MAX_LEN-1, "%d,%d,%d", STK_ENV_TYPE_MENU_SEL, ptr->item_id, ptr->help_request);
    atiCmdIdSet(CMD_STK_MENU_SELECTION);
	return 0;
}


/**
 * ڶΪCommandNumberΪԭ
 */
SINT32 Make_CommandReject_Cmd(CI_AT_CMD_LINE_T *pCmdLine, const  ZBL_CHANNEL_MSG_INFO *pMsg)
{
    atiUsatCmdReject* ptr;

    strncpy(pCmdLine->strCmdOperator, "=", 2);
    ptr = (atiUsatCmdReject*)(pMsg->msgData);
    ZTE_Trace(ZBL_AT, 0, "Make_CommandReject_Cmd() %d", ptr->cause);
    //NXPõ 
    //snprintf(pCmdLine->strCmdParas, AT_CMD_PARA_MAX_LEN-1, "\"COMMAND REJECTED\",1,%d", ptr->cause);
    if(0 == g_stk_cmd_dtl.cmdType)       
    {
        zblAssert(0);
        return -1;         //ǰûҪӦģֱӷ 
    }	


    //if(NULL != ptr->add_cause_ptr && 0 != ptr->add_cause_len)
    if(0 != ptr->add_cause_len)
    {
        if(0 == g_stk_cmd_dtl.cmdNum)
        {   
            snprintf(pCmdLine->strCmdParas, AT_CMD_PARA_MAX_LEN-1, "%d,%d,%02d", g_stk_cmd_dtl.cmdType, 
            ptr->cause, ptr->add_cause_ptr);
        }
        else
        {   
            snprintf(pCmdLine->strCmdParas, AT_CMD_PARA_MAX_LEN-1, "%d,%d,%d,%d,%02d", g_stk_cmd_dtl.cmdType, 
            g_stk_cmd_dtl.cmdQual, g_stk_cmd_dtl.cmdNum, ptr->cause, ptr->add_cause_ptr);
        }
    }
    else
    {
        if(0 == g_stk_cmd_dtl.cmdNum)
        {   
            snprintf(pCmdLine->strCmdParas, AT_CMD_PARA_MAX_LEN-1, "%d,%d", g_stk_cmd_dtl.cmdType, ptr->cause);
        }
        else
        {
            snprintf(pCmdLine->strCmdParas, AT_CMD_PARA_MAX_LEN-1, "%d,%d,%d,%d", g_stk_cmd_dtl.cmdType, 
                g_stk_cmd_dtl.cmdQual, g_stk_cmd_dtl.cmdNum, ptr->cause);
        }
    }
    initStkCmdDtl();
    atiCmdIdSet(CMD_STK_COMMANDREJECT_REQ);	
    return 0;
}

/**
 */
SINT32 Make_SelectItemRsp_Cmd(CI_AT_CMD_LINE_T *pCmdLine, const  ZBL_CHANNEL_MSG_INFO *pMsg)
{
    atiUsatSelectItemResp *ptr = NULL;
    strncpy(pCmdLine->strCmdOperator, "=", 2);
    ptr = (atiUsatSelectItemResp*)(pMsg->msgData);
    ZTE_Trace(ZBL_AT, 0, "Make_SelectItemRsp_Cmd() %d", ptr->item_id);

    //NXPõ 
    //snprintf(pCmdLine->strCmdParas, AT_CMD_PARA_MAX_LEN-1, "\"SELECT ITEM\",%d,%d,0,0", ptr->item_id, ptr->item_id);
    snprintf(pCmdLine->strCmdParas, AT_CMD_PARA_MAX_LEN-1, "%d,%d,%d,0,,%d", STK_PROCMD_TYPE_SEL_ITEM,g_stk_cmd_dtl.cmdQual, g_stk_cmd_dtl.cmdNum,ptr->item_id);
    initStkCmdDtl();
    atiCmdIdSet(CMD_STK_SELECT_ITEM);
    return 0;
}

/**
 */
SINT32 Make_GetInputRsp_Cmd(CI_AT_CMD_LINE_T *pCmdLine, const  ZBL_CHANNEL_MSG_INFO *pMsg)
{
	atiUsatGetInputResp* ptr;
    CHAR tmpStr[ATI_USAT_MAX_LENGTH_LONG_TEXT_STRING*2+2] = {0x00};
    UINT16 len=0;

    strncpy(pCmdLine->strCmdOperator, "=", 2);
	ptr = (atiUsatGetInputResp*)(pMsg->msgData);
	ZTE_Trace(ZBL_AT, 0, "Make_GetInputRsp_Cmd() alphabet=%d, text=|||%s|||",
		ptr->text_st.alphabet, ptr->text_st.text_a);

#if 0 //NXPõ
/*lianglingling054850 20090515 modifynxpĽ޸ı뷽ʽalphabet ==2ʹucs-2룬0x80+len+textȻ޸Ϊ80...ķʽдͣ˲޸ĳȣԽ*/
	if (USAT_CHAR_TYPE_UCS2_ALPHABET == ptr->text_st.alphabet)
	{
		memcpy((CHAR*)tmpStr, (CHAR *)ptr->text_st.text_a, ATI_USAT_MAX_LENGTH_LONG_TEXT_STRING);
	    memset((VOID*)ptr->text_st.text_a, 0x00,ATI_USAT_MAX_LENGTH_LONG_TEXT_STRING);

        len=codeTextData((CHAR *)ptr->text_st.text_a, (CHAR *)tmpStr);
	}

    ZTE_Trace(0, 0, "Make_GetInputRsp_Cmd() text=|||%s|||",	ptr->text_st.text_a);
	snprintf(pCmdLine->strCmdParas, AT_CMD_PARA_MAX_LEN-1, "\"GET INPUT\",1,%d,\"%s\",%d",
		ptr->text_st.alphabet, ptr->text_st.text_a, ptr->icon_display);
#endif
	if (STK_CODE_MODE_UCS2 == ptr->text_st.alphabet)
	{
        codeTextData90((CHAR *)tmpStr, (CHAR *)ptr->text_st.text_a);
    }   
    /*else if(STK_CODE_MODE_GSM7== ptr->text_st.alphabet)
    {
        SINT32 length = 0;	        
    	memcpy((CHAR*)tmpStr, (CHAR *)ptr->text_st.text_a, ATI_USAT_MAX_LENGTH_LONG_TEXT_STRING);
	    memset((VOID*)ptr->text_st.text_a, 0x00,ATI_USAT_MAX_LENGTH_LONG_TEXT_STRING);
        length = Encode7bit((CHAR *)tmpStr, (UINT8 *)ptr->text_st.text_a, strlen(tmpStr)+1);
        Bytes2String((UINT8*)ptr->text_st.text_a, (CHAR*)tmpStr, length);
    }
    */
    else if (STK_CODE_MODE_OTHERS == ptr->text_st.alphabet)  //zxj mod for fwp
    {
        SINT32 length = 0;	       
        ptr->text_st.alphabet = STK_CODE_MODE_UCS2;
    	memcpy((CHAR*)tmpStr, (CHAR *)ptr->text_st.text_a, ATI_USAT_MAX_LENGTH_LONG_TEXT_STRING);
	    memset((VOID*)ptr->text_st.text_a, 0x00,ATI_USAT_MAX_LENGTH_LONG_TEXT_STRING);
        //length = Encode8bit((CHAR *)tmpStr, (UINT8 *)ptr->text_st.text_a, strlen(tmpStr));
        length = Encode8bit((CHAR *)tmpStr, (UINT8 *)ptr->text_st.text_a, 18);//zxj mod 20101021
        bytes2string((UINT8*)ptr->text_st.text_a, (CHAR*)tmpStr, length);
    }    
    else
    {
        SINT32 length = 0;	       
        ptr->text_st.alphabet = STK_CODE_MODE_GSM8;
    	memcpy((CHAR*)tmpStr, (CHAR *)ptr->text_st.text_a, ATI_USAT_MAX_LENGTH_LONG_TEXT_STRING);
	    memset((VOID*)ptr->text_st.text_a, 0x00,ATI_USAT_MAX_LENGTH_LONG_TEXT_STRING);
        length = Encode8bit((CHAR *)tmpStr, (UINT8 *)ptr->text_st.text_a, strlen(tmpStr));
        bytes2string((UINT8*)ptr->text_st.text_a, (CHAR*)tmpStr, length);
    }

    if (TRUE == ptr->help_req)
    {
		snprintf(pCmdLine->strCmdParas, AT_CMD_PARA_MAX_LEN-1, "%d,%d,%d,%d,", STK_PROCMD_TYPE_GET_INPUT, 
			g_stk_cmd_dtl.cmdQual, g_stk_cmd_dtl.cmdNum, ATI_USAT_RST_REQUEST_HELP_INFO);
    }
	else if(ATI_USAT_ICON_NOT_DISPLAYED == ptr->icon_display)
	{
		if(0 == ptr->text_st.text_a[0])
		{
			snprintf(pCmdLine->strCmdParas, AT_CMD_PARA_MAX_LEN-1, "%d,%d,%d,%d,,%d,\"\"", STK_PROCMD_TYPE_GET_INPUT, 
				g_stk_cmd_dtl.cmdQual, g_stk_cmd_dtl.cmdNum, ATI_USAT_RST_OK_ICON_NOT_DISPLAYED, ptr->text_st.alphabet);
		}
		else
		{
			snprintf(pCmdLine->strCmdParas, AT_CMD_PARA_MAX_LEN-1, "%d,%d,%d,%d,,%d,\"%s\"", STK_PROCMD_TYPE_GET_INPUT, 
				g_stk_cmd_dtl.cmdQual, g_stk_cmd_dtl.cmdNum,  ATI_USAT_RST_OK_ICON_NOT_DISPLAYED, ptr->text_st.alphabet, tmpStr);
		}
	}	
	else
	{
		if(0 == ptr->text_st.text_a[0])
		{
            snprintf(pCmdLine->strCmdParas, AT_CMD_PARA_MAX_LEN-1, "%d,%d,%d,%d,,%d,\"\"", STK_PROCMD_TYPE_GET_INPUT, 
				g_stk_cmd_dtl.cmdQual, g_stk_cmd_dtl.cmdNum, ATI_USAT_RST_SUCCESS, ptr->text_st.alphabet);
		}
		else
		{
			snprintf(pCmdLine->strCmdParas, AT_CMD_PARA_MAX_LEN-1, "%d,%d,%d,%d,,%d,\"%s\"", STK_PROCMD_TYPE_GET_INPUT, 
				g_stk_cmd_dtl.cmdQual, g_stk_cmd_dtl.cmdNum, ATI_USAT_RST_SUCCESS, ptr->text_st.alphabet, tmpStr);
		}
	}
	initStkCmdDtl();
    atiCmdIdSet(CMD_STK_GET_INPUT);	
	return 0;
}

/**
 * 
 */
SINT32 Make_GetInkeyRsp_Cmd(CI_AT_CMD_LINE_T *pCmdLine, const  ZBL_CHANNEL_MSG_INFO *pMsg)
{
	atiUsatGetInkeyResp* ptr;
	
    strncpy(pCmdLine->strCmdOperator, "=", 2);
	ptr = (atiUsatGetInkeyResp*)(pMsg->msgData);
	ZTE_Trace(ZBL_AT, 0, "Make_GetInkeyRsp_Cmd()");

    //NXPõ
    //snprintf(pCmdLine->strCmdParas, AT_CMD_PARA_MAX_LEN-1, "\"GET INKEY\",%d,%d,%d,\"%s\"",
    //ptr->char_type, ptr->help_req, ptr->icon_display, ptr->resp_val);

    if (TRUE == ptr->help_req)
    {
    	if (0 == ptr->resp_val[0])//cov_2 (NULLPTR == ptr->resp_val)
    	{
		    snprintf(pCmdLine->strCmdParas, AT_CMD_PARA_MAX_LEN-1, "%d,%d,%d,%d", STK_PROCMD_TYPE_GET_INKEY, 
				g_stk_cmd_dtl.cmdQual, g_stk_cmd_dtl.cmdNum, ATI_USAT_RST_REQUEST_HELP_INFO);
    	}
		else
		{
		    snprintf(pCmdLine->strCmdParas, AT_CMD_PARA_MAX_LEN-1, "%d,%d,%d,%d,%d,\"%s\",", STK_PROCMD_TYPE_GET_INKEY, 
				g_stk_cmd_dtl.cmdQual, g_stk_cmd_dtl.cmdNum, ATI_USAT_RST_REQUEST_HELP_INFO, ptr->char_type, ptr->resp_val);
		}

    }
	else if(ATI_USAT_ICON_NOT_DISPLAYED == ptr->icon_display)
	{
/*	cov2
    	if (NULLPTR == ptr->resp_val)
    	{
		    snprintf(pCmdLine->strCmdParas, AT_CMD_PARA_MAX_LEN-1, "%d,%d,%d,%d,",STK_PROCMD_TYPE_GET_INKEY, 
				g_stk_cmd_dtl.cmdQual, g_stk_cmd_dtl.cmdNum, ATI_USAT_RST_OK_ICON_NOT_DISPLAYED);
    	}
    	else
*/    	
    	{
		    snprintf(pCmdLine->strCmdParas, AT_CMD_PARA_MAX_LEN-1, "%d,%d,%d,%d,,%d,\"%s\",",STK_PROCMD_TYPE_GET_INKEY, 
				g_stk_cmd_dtl.cmdQual, g_stk_cmd_dtl.cmdNum, ATI_USAT_RST_OK_ICON_NOT_DISPLAYED, ptr->char_type, ptr->resp_val);
    	}
	}
	else
	{
	    snprintf(pCmdLine->strCmdParas, AT_CMD_PARA_MAX_LEN-1, "%d,%d,%d,%d,,%d,\"%s\",",STK_PROCMD_TYPE_GET_INKEY, 
			g_stk_cmd_dtl.cmdQual, g_stk_cmd_dtl.cmdNum, ATI_USAT_RST_SUCCESS, ptr->char_type, ptr->resp_val);
	}
	initStkCmdDtl();
    atiCmdIdSet(CMD_STK_GET_INKEY);	
	return 0;
}
/*modified by qianmeng 20090713*/
/**
 * 
 */

 SINT32 Make_LInfoLocaRsp_Cmd(CI_AT_CMD_LINE_T *pCmdLine, const  ZBL_CHANNEL_MSG_INFO *pMsg)
{
	atiUsatNetLocalInfo *ptr = NULL;
    
    if(NULL == pCmdLine || NULL ==pMsg )
    {
        return -1;
    }
    if(NULL == pMsg->msgData)
    {
        return -1;
    }
          
    strncpy(pCmdLine->strCmdOperator, "=", 2);
	ptr = (atiUsatNetLocalInfo*)(pMsg->msgData);
  
	snprintf(pCmdLine->strCmdParas, AT_CMD_PARA_MAX_LEN-1, "%d,%d,%d,%d,,%d,%d,%d,%d,%d,%d", STK_PROCMD_TYPE_PLOC_INFO,
        g_stk_cmd_dtl.cmdQual, g_stk_cmd_dtl.cmdNum, ATI_USAT_RST_SUCCESS, ZBL_USAT_LOCAL_INFO_LOCATION_INF, 
        ptr->mcc, ptr->mnc, ptr->lac, ptr->cell_id, ptr->ext_cell_id);
	initStkCmdDtl();
    atiCmdIdSet(CMD_STK_PROVIDE_LOCAL_INFORMATION);
	return 0;
}

/**
 * 
 */
 SINT32  Make_LInfoImeiRsp_Cmd(CI_AT_CMD_LINE_T *pCmdLine, const  ZBL_CHANNEL_MSG_INFO *pMsg)
{
	UINT8 *ptr = NULL;
    
    if(NULL == pCmdLine || NULL ==pMsg )
    {
        return -1;
    }
    if(NULL == pMsg->msgData)
    {
        return -1;
    }
          
    strncpy(pCmdLine->strCmdOperator, "=", 2);
	ptr = (UINT8*)(pMsg->msgData);
  
	snprintf(pCmdLine->strCmdParas, AT_CMD_PARA_MAX_LEN-1, "%d,%d,%d,%d,,%d,\"%s\"", STK_PROCMD_TYPE_PLOC_INFO, 
                g_stk_cmd_dtl.cmdQual, g_stk_cmd_dtl.cmdNum, ATI_USAT_RST_SUCCESS, ZBL_USAT_LOCAL_INFO_IMEI_OF_TERMINAL, ptr);
	initStkCmdDtl();
    atiCmdIdSet(CMD_STK_PROVIDE_LOCAL_INFORMATION);
	return 0;
}

/**
 * 
 */
SINT32 Make_LInfoNetMsrRsp_Cmd(CI_AT_CMD_LINE_T *pCmdLine, const  ZBL_CHANNEL_MSG_INFO *pMsg)
{
	atiUsatNetMeasurementInfo *ptr = NULL;
    
    if(NULL == pCmdLine || NULL ==pMsg )
    {
        return -1;
    }
    if(NULL == pMsg->msgData)
    {
        return -1;
    }
          
    strncpy(pCmdLine->strCmdOperator, "=", 2);
	ptr = (atiUsatNetMeasurementInfo*)(pMsg->msgData);
  
	snprintf(pCmdLine->strCmdParas, AT_CMD_PARA_MAX_LEN-1, "%d,%d,%d,%d,,%d,\"%s\"", STK_PROCMD_TYPE_PLOC_INFO,
        g_stk_cmd_dtl.cmdQual, g_stk_cmd_dtl.cmdNum, ATI_USAT_RST_SUCCESS, ZBL_USAT_LOCAL_INFO_NETWORK_MEASUREMENT_RST, ptr->nmr_info);
	initStkCmdDtl();
    atiCmdIdSet(CMD_STK_PROVIDE_LOCAL_INFORMATION);
	return 0;
}

/**
 * 
 */
 SINT32 Make_LInfoTimeZoneRsp_Cmd(CI_AT_CMD_LINE_T *pCmdLine, const  ZBL_CHANNEL_MSG_INFO *pMsg)
{
	atiUsatDateTimeZone *ptr = NULL;
    UINT8 day[7] = {0};
    UINT8 time[7] = {0};
    UINT8 timezone[3] = {0};
    UINT8 tmp[7] = {0};
    
    if(NULL == pCmdLine || NULL ==pMsg )
    {
        return -1;
    }
    if(NULL == pMsg->msgData)
    {
        return -1;
    }
          
    strncpy(pCmdLine->strCmdOperator, "=", 2);
	ptr = (atiUsatDateTimeZone*)(pMsg->msgData);

    snprintf(tmp, 6, "%d,%d,%d",ptr->year, ptr->month, ptr->day);
    SerializeNumbers(tmp, day, strlen(tmp));
    
    memset(tmp, 0, 7);
    snprintf(tmp, 6, "%d,%d,%d",ptr->hour, ptr->minute, ptr->second);
    SerializeNumbers(tmp, time, strlen(tmp));

    memset(tmp, 0, 7);
    snprintf(tmp, 2, "%d",ptr->time_zone);
    SerializeNumbers(tmp, timezone, strlen(tmp));
    
	snprintf(pCmdLine->strCmdParas, AT_CMD_PARA_MAX_LEN-1, "%d,%d,%d,%d,,%d,\"%s\",\"%s\",\"%s\"", STK_PROCMD_TYPE_PLOC_INFO,
        g_stk_cmd_dtl.cmdQual, g_stk_cmd_dtl.cmdNum, ATI_USAT_RST_SUCCESS, ZBL_USAT_LOCAL_INFO_DATE_TIME_ZONE, day, time, timezone);
	initStkCmdDtl();
    atiCmdIdSet(CMD_STK_PROVIDE_LOCAL_INFORMATION);
	return 0;
}

/**
 * 
 */
 SINT32 Make_LInfoLangSettingRsp_Cmd(CI_AT_CMD_LINE_T *pCmdLine, const  ZBL_CHANNEL_MSG_INFO *pMsg)
{
	UINT16 *ptr = NULL;
    
    if(NULL == pCmdLine || NULL ==pMsg )
    {
        return -1;
    }
    if(NULL == pMsg->msgData)
    {
        return -1;
    }
          
    strncpy(pCmdLine->strCmdOperator, "=", 2); 
	ptr = (UINT16 *)(pMsg->msgData);
  
	snprintf(pCmdLine->strCmdParas, AT_CMD_PARA_MAX_LEN-1, "%d,%d,%d,%d,,%d,%04x", STK_PROCMD_TYPE_PLOC_INFO,
        g_stk_cmd_dtl.cmdQual, g_stk_cmd_dtl.cmdNum, ATI_USAT_RST_SUCCESS,ZBL_USAT_LOCAL_INFO_LANG_SETTING, (*ptr));
	initStkCmdDtl();
    atiCmdIdSet(CMD_STK_PROVIDE_LOCAL_INFORMATION);
	return 0;
}

/**
 * 
 */
SINT32 Make_LInfoTaRsp_Cmd(CI_AT_CMD_LINE_T *pCmdLine, const  ZBL_CHANNEL_MSG_INFO *pMsg)
{
	atiUsatTimingAdvance *ptr = NULL;
    
    if(NULL == pCmdLine || NULL ==pMsg )
    {
        return -1;
    }
    if(NULL == pMsg->msgData)
    {
        return -1;
    }
          
    strncpy(pCmdLine->strCmdOperator, "=", 2);
	ptr = (atiUsatTimingAdvance*)(pMsg->msgData);
  
	snprintf(pCmdLine->strCmdParas, AT_CMD_PARA_MAX_LEN-1, "%d,%d,%d,%d,,%d,%d,%d", STK_PROCMD_TYPE_PLOC_INFO,
        g_stk_cmd_dtl.cmdQual, g_stk_cmd_dtl.cmdNum, ATI_USAT_RST_SUCCESS,ZBL_USAT_LOCAL_INFO_TA, ptr->me_status, ptr->timing_advance);
	initStkCmdDtl();
    atiCmdIdSet(CMD_STK_PROVIDE_LOCAL_INFORMATION);
	return 0;
}

/**
 * 
 */
 SINT32 Make_LInfoAccTechRsp_Cmd(CI_AT_CMD_LINE_T *pCmdLine, const  ZBL_CHANNEL_MSG_INFO *pMsg)
{
	UINT8 *ptr = NULL;
    
    if(NULL == pCmdLine || NULL ==pMsg )
    {
        return -1;
    }
    if(NULL == pMsg->msgData)
    {
        return -1;
    }
          
    strncpy(pCmdLine->strCmdOperator, "=", 2);
	ptr = (UINT8*)(pMsg->msgData);
  
	snprintf(pCmdLine->strCmdParas, AT_CMD_PARA_MAX_LEN-1, "%d,%d,%d,%d,,%d,%d", STK_PROCMD_TYPE_PLOC_INFO,
        g_stk_cmd_dtl.cmdQual, g_stk_cmd_dtl.cmdNum, ATI_USAT_RST_SUCCESS,ZBL_USAT_LOCAL_INFO_ACC_TECH, (*ptr));
	initStkCmdDtl();
    atiCmdIdSet(CMD_STK_PROVIDE_LOCAL_INFORMATION);
	return 0;
}

/**
 * 
 */
static SINT32 Make_LInfoEsnRsp_Cmd(CI_AT_CMD_LINE_T *pCmdLine, const  ZBL_CHANNEL_MSG_INFO *pMsg)
{
	SINT32 *ptr = NULL;
    
    if(NULL == pCmdLine || NULL ==pMsg )
    {
        return -1;
    }
    if(NULL == pMsg->msgData)
    {
        return -1;
    }
          
    strncpy(pCmdLine->strCmdOperator, "=", 2);
	ptr = (SINT32*)(pMsg->msgData);
  
	snprintf(pCmdLine->strCmdParas, AT_CMD_PARA_MAX_LEN-1, "%d,%d,%d,%d,,%d,%d", STK_PROCMD_TYPE_PLOC_INFO,
        g_stk_cmd_dtl.cmdQual, g_stk_cmd_dtl.cmdNum, ATI_USAT_RST_SUCCESS,ZBL_USAT_LOCAL_INFO_ESN_OF_TERMINAL, (*ptr));
	initStkCmdDtl();
    atiCmdIdSet(CMD_STK_PROVIDE_LOCAL_INFORMATION);
	return 0;
}

/**
 * 
 */
 SINT32 Make_EvtDownload_Cmd(CI_AT_CMD_LINE_T *pCmdLine, const  ZBL_CHANNEL_MSG_INFO *pMsg)
{        
	atiUsatEvtDownloadData *ptr = NULL;
    
    if(NULL == pCmdLine || NULL ==pMsg )
    {
        return -1;
    }
    if(NULL == pMsg->msgData)
    {
        return -1;
    }
    
    strncpy(pCmdLine->strCmdOperator, "=", 2);
	ptr = (atiUsatEvtDownloadData*)(pMsg->msgData);
    switch( ptr->evt_type)
    {
        case  ZBL_EVT_MT_CALL:
            {
                snprintf(pCmdLine->strCmdParas, AT_CMD_PARA_MAX_LEN-1, "%d,%d,,,\"%s\",\"%s\"", 0x07,ptr->evt_type, 
                    ptr->evt_data.mtCallData.calling_num_a,ptr->evt_data.mtCallData.calling_subaddr_st.subaddr_a);
	            break;
            }  
        case  ZBL_EVT_CALL_CONNECTED:
            {
                snprintf(pCmdLine->strCmdParas, AT_CMD_PARA_MAX_LEN-1, "%d,%d", 0x08,ptr->evt_type);
	            break;
            } 
        case  ZBL_EVT_CALL_DISCONNECTED:
            {
                snprintf(pCmdLine->strCmdParas, AT_CMD_PARA_MAX_LEN-1, "%d,%d,%d,%d,%d", 0x09,ptr->evt_type,83,83,ptr->evt_data.callDisConctData.cause);
	            break;
            }
        case  ZBL_EVT_LOCATION_STATUS:
            {
                atiUsatNetLocalInfo tem = {0};
                memcpy(&tem, &ptr->evt_data.locationStatus.info_st, sizeof(atiUsatNetLocalInfo));
                snprintf(pCmdLine->strCmdParas, AT_CMD_PARA_MAX_LEN-1, "%d,%d,%d,%d,%d,%d,%d,%d", 0x0a,
                    ptr->evt_type,ptr->evt_data.locationStatus.state,tem.mcc,tem.mnc,tem.lac,tem.cell_id,tem.ext_cell_id);
	            break;
            }
        case  ZBL_EVT_USER_ACTIVITY:
            {
                snprintf(pCmdLine->strCmdParas, AT_CMD_PARA_MAX_LEN-1, "%d", 0x0b);
	            break;
            }
        case  ZBL_EVT_IDLE_SCREEN_AVAILABLE:
            {
                snprintf(pCmdLine->strCmdParas, AT_CMD_PARA_MAX_LEN-1, "%d", 0x0c);
	            break;
            }
        case  ZBL_EVT_LANG_SELECTION:
            {
                snprintf(pCmdLine->strCmdParas, AT_CMD_PARA_MAX_LEN-1, "%d,%d", 0x0e,ptr->evt_data.langSelectdata.language_code);
	            break;
            }
        case  ZBL_EVT_BROWSER_TERMINATION:
            {
                snprintf(pCmdLine->strCmdParas, AT_CMD_PARA_MAX_LEN-1, "%d,%d", 0x0f,ptr->evt_data.browserTerminat.terminate_cause);
	            break;
            }
        case  ZBL_EVT_DATA_AVAILABLE:
            {
                atiUsatDataAvailable tem = {0};
                memcpy(&tem, &ptr->evt_data.dataAvailable, sizeof(atiUsatDataAvailable));
                snprintf(pCmdLine->strCmdParas, AT_CMD_PARA_MAX_LEN-1, "%d,%d,%d,%d,%d", 0x10,tem.channel_id,tem.established_activated,tem.further_info,tem.data_len);
	            break;
            }
        case  ZBL_EVT_CHANNEL_STATUS:
            {
                atiUsatChannelStatus tem = {0};
                memcpy(&tem, &ptr->evt_data.channelStatus, sizeof(atiUsatChannelStatus));
                snprintf(pCmdLine->strCmdParas, AT_CMD_PARA_MAX_LEN-1, "%d,%d,%d,%d", 0x11,tem.channel_id,tem.established_activated,tem.further_info);
	            break;
            }
        case  ZBL_EVT_ACC_TECH_CHANGE:
            {
                snprintf(pCmdLine->strCmdParas, AT_CMD_PARA_MAX_LEN-1, "%d,%d", 0x12,ptr->evt_data.accTechChange.tech);
	            break;
            }
        case  ZBL_EVT_DISP_PARAM_CHANGED:
            {
                atiUsatDispParamChanged tem = {0};
                memcpy(&tem, &ptr->evt_data.dispParamChange, sizeof(atiUsatDispParamChanged));
                snprintf(pCmdLine->strCmdParas, AT_CMD_PARA_MAX_LEN-1, "%d,%d%d%d", 0x13,tem.height_char_num,tem.width_char_num,tem.text_scrolling);
	            break;
            }
        case  ZBL_EVT_LOCAL_CONNECTION:
            {
                atiUsatLocalConnection tem = {0};
                memcpy(&tem, &ptr->evt_data.localConnection, sizeof(atiUsatLocalConnection));
                snprintf(pCmdLine->strCmdParas, AT_CMD_PARA_MAX_LEN-1, "%d,%d,%d,\"%s\"", 0x14,tem.bearType,tem.srvId,tem.srvRecord);
	            break;
            }
        default:
            {
                ZTE_Trace(ZBL_AT, 0, "Make_EvtDownload_Cmd() evt_type unsupported!");
                break;
            }
    }        
	initStkCmdDtl();
    atiCmdIdSet(CMD_STK_EVENT_DOWNLOAD);	
	return 0;
}
/**
 * 
 */
 SINT32 Make_PollIntervalRsp_Cmd(CI_AT_CMD_LINE_T *pCmdLine, const  ZBL_CHANNEL_MSG_INFO *pMsg)
{
	atiUsatPollIntervalResp *ptr = NULL;
    
    if(NULL == pCmdLine || NULL ==pMsg )
    {
        return -1;
    }
    if(NULL == pMsg->msgData)
    {
        return -1;
    }
    
    strncpy(pCmdLine->strCmdOperator, "=", 2);
	ptr = (atiUsatPollIntervalResp*)(pMsg->msgData);  
	snprintf(pCmdLine->strCmdParas, AT_CMD_PARA_MAX_LEN-1, "%d,%d,%d", STK_PROCMD_TYPE_POLINTVL,ptr->time_unit,ptr->time_interval);
	initStkCmdDtl();
    atiCmdIdSet(CMD_STK_POLL_INTERVAL);
	return 0;
}

/**
 * 
 */
SINT32 Make_RcvDataRsp_Cmd(CI_AT_CMD_LINE_T *pCmdLine, const  ZBL_CHANNEL_MSG_INFO *pMsg)
{
    atiUsatReceiveDataResp *ptr = NULL;
    
    if(NULL == pCmdLine || NULL ==pMsg )
    {
        return -1;
    }
    if(NULL == pMsg->msgData)
    {
        return -1;
    }
    
    strncpy(pCmdLine->strCmdOperator, "=", 2);
    ptr = (atiUsatReceiveDataResp*)(pMsg->msgData);
  
    snprintf(pCmdLine->strCmdParas, AT_CMD_PARA_MAX_LEN-1, "%d,%d,%s", STK_PROCMD_TYPE_RECV_DATA,ptr->chl_data_rcv_len,ptr->chl_data_ptr);
    initStkCmdDtl();
    atiCmdIdSet(CMD_STK_RECEIVE_DATA);
	return 0;
}

/**
 * 
 */
 SINT32 Make_UsimCtrl_Cmd(CI_AT_CMD_LINE_T *pCmdLine, const  ZBL_CHANNEL_MSG_INFO *pMsg)
{
	atiUsatUsimControl *ptr = NULL;
    
    if(NULL == pCmdLine || NULL ==pMsg )
    {
        return -1;
    }
    if(NULL == pMsg->msgData)
    {
        return -1;
    }
    
    strncpy(pCmdLine->strCmdOperator, "=", 2);
	ptr = (atiUsatUsimControl*)(pMsg->msgData);
    
    switch( ptr->object_type)
    {
        case  ATI_USAT_USIM_CTL_TYPE_CALL:
            {
                
                atiUsatNetLocalInfo tem = {0};
                memcpy(&tem, &ptr->usim_data.call_data.local_info_st, sizeof(atiUsatNetLocalInfo));
                snprintf(pCmdLine->strCmdParas, AT_CMD_PARA_MAX_LEN-1, "%d,%d,,,%s,%s,%s,%d,%d,%d,%d,%d,%s",STK_ENV_TYPE_CALL_CTRL,0,ptr->usim_data.call_data.called_num_a,
                    ptr->usim_data.call_data.cap_1_a,ptr->usim_data.call_data.called_subaddr_st.subaddr_a,tem.mcc,
                    tem.mnc,tem.lac,tem.cell_id,tem.ext_cell_id,ptr->usim_data.call_data.cap_2_a);
	            break;
            }  
        case  ATI_USAT_USIM_CTL_TYPE_SS:
            {                
                snprintf(pCmdLine->strCmdParas, AT_CMD_PARA_MAX_LEN-1, "%d,%d,,,%s",STK_ENV_TYPE_CALL_CTRL,1,ptr->usim_data.ss_data.ss_a);

	            break;
            } 
        case  ATI_USAT_USIM_CTL_TYPE_USSD:
            {
                snprintf(pCmdLine->strCmdParas, AT_CMD_PARA_MAX_LEN-1, "%d,%d,%d,%s",STK_ENV_TYPE_CALL_CTRL,2,ptr->usim_data.ussd_data.ussd_str.alphabet,
                    ptr->usim_data.ussd_data.ussd_str.text_a);
	            break;
            }
        case  ATI_USAT_USIM_CTL_TYPE_SMS:
            {
                atiUsatNetLocalInfo tem = {0};
                memcpy(&tem, &ptr->usim_data.sms_data.local_info_st, sizeof(atiUsatNetLocalInfo));
                snprintf(pCmdLine->strCmdParas, AT_CMD_PARA_MAX_LEN-1, "%d,,,%s,,,%s,%d,%d,%d,%d,%d",STK_ENV_TYPE_SMS_CTRL,
                    ptr->usim_data.sms_data.src_addr_a,ptr->usim_data.sms_data.dest_addr_a,
                    tem.mcc,tem.mnc,tem.lac,tem.cell_id,tem.ext_cell_id);	            
                break;
            }
        case  ATI_USAT_USIM_CTL_TYPE_PDP_ACT:
            {
                snprintf(pCmdLine->strCmdParas, AT_CMD_PARA_MAX_LEN-1, "%d,,,,,,,,,%s,,",STK_ENV_TYPE_CALL_CTRL,ptr->usim_data.pdp_data.pdp_param_a);
	            break;
            }

        default:
            {
                ZTE_Trace(ZBL_AT, 0, "Make_UsimCtrl_Cmd() type unsupported!");
                break;
            }
    }  
	initStkCmdDtl();
    atiCmdIdSet(CMD_STK_USIM_CONTROL);
	return 0;
}

/**
 * 
 */
 SINT32 Make_CallCtrlRsp_Cmd(CI_AT_CMD_LINE_T *pCmdLine, const  ZBL_CHANNEL_MSG_INFO *pMsg)
{
	atiUsatCallCtlResp *ptr = NULL;
    
    if(NULL == pCmdLine || NULL ==pMsg )
    {
        return -1;
    }
    if(NULL == pMsg->msgData)
    {
        return -1;
    }
    
    strncpy(pCmdLine->strCmdOperator, "=", 2);
	ptr = (atiUsatCallCtlResp*)(pMsg->msgData); 

    if(g_stk_cmd_dtl.cmdType == STK_PROCMD_TYPE_SETUP_CALL)
	{
	    ZTE_Trace(ZBL_AT, 0, "Make_CallCtrlRsp_Cmd and gen_cause = %d,%d,%d,%d\n", g_stk_cmd_dtl.cmdType,g_stk_cmd_dtl.cmdQual, g_stk_cmd_dtl.cmdNum, ptr->result1_add_cause_ptr);
	    if(NULL != ptr->result1_add_cause_ptr && 0 != ptr->result1_add_cause_len)
	    {
	            snprintf(pCmdLine->strCmdParas, AT_CMD_PARA_MAX_LEN-1, "%d,%d,%d,%d,%02d", STK_PROCMD_TYPE_SETUP_CALL, 
	            g_stk_cmd_dtl.cmdQual, g_stk_cmd_dtl.cmdNum, ptr->result1_gen_cause, *ptr->result1_add_cause_ptr);
	    }
	    else
	    {
	            snprintf(pCmdLine->strCmdParas, AT_CMD_PARA_MAX_LEN-1, "%d,%d,%d,%d", STK_PROCMD_TYPE_SETUP_CALL, 
	                g_stk_cmd_dtl.cmdQual, g_stk_cmd_dtl.cmdNum, ptr->result1_gen_cause);
	    }
    	 initStkCmdDtl();
        atiCmdIdSet(CMD_STK_SETUP_CALL);
    }
    else if(g_stk_cmd_dtl.cmdType == STK_PROCMD_TYPE_SEND_SS)
    {
        ZTE_Trace(ZBL_AT, 0, "Make_CallCtrlRsp_Cmd and gen_cause = %d\n", g_stk_cmd_dtl.cmdType);
           if(NULL != ptr->result1_add_cause_ptr && 0 != ptr->result1_add_cause_len)
	    {
	            snprintf(pCmdLine->strCmdParas, AT_CMD_PARA_MAX_LEN-1, "%d,%d,%d,%d,%02d", STK_PROCMD_TYPE_SEND_SS, 
	                g_stk_cmd_dtl.cmdQual, g_stk_cmd_dtl.cmdNum, ptr->result1_gen_cause, *ptr->result1_add_cause_ptr);
	    }
	    else
	    {
	            snprintf(pCmdLine->strCmdParas, AT_CMD_PARA_MAX_LEN-1, "%d,%d,%d,%d", STK_PROCMD_TYPE_SEND_SS, 
	                g_stk_cmd_dtl.cmdQual, g_stk_cmd_dtl.cmdNum, ptr->result1_gen_cause);
	    }
    	 initStkCmdDtl();
        atiCmdIdSet(CMD_STK_SEND_SS);
    }
    else
    {
        ZTE_Trace(ZBL_AT, 0, "Make_CallCtrlRsp_Cmd error gen_cause = %d\n", g_stk_cmd_dtl.cmdType);
        zblAssert(0);
    }
    
	return 0;
}

/**
 * 
 */
 SINT32 Make_OpenChlRsp_Cmd(CI_AT_CMD_LINE_T *pCmdLine, const  ZBL_CHANNEL_MSG_INFO *pMsg)
{
    atiUsatOpenChlResp *ptr = NULL;
    
    if(NULL == pCmdLine || NULL ==pMsg )
    {
        return -1;
    }
    if(NULL == pMsg->msgData)
    {
        return -1;
    }
    //[<BearType>,<Param>],[<BufSize>],[<AdrType>,<Adr>],[<ChnlID>,<Connt>,<Info>]
    strncpy(pCmdLine->strCmdOperator, "=", 2);
    ptr = (atiUsatOpenChlResp*)(pMsg->msgData);   
    snprintf(pCmdLine->strCmdParas, AT_CMD_PARA_MAX_LEN-1, "%d,%d,%s,%s,%d,%d,%d", STK_PROCMD_TYPE_OPEN_CHNL,
    ptr->bearer_type, ptr->bearer_param,ptr->buffer_size, ptr->channel_id, ptr->established_activated,ptr->further_info);
    initStkCmdDtl();
    atiCmdIdSet(CMD_STK_OPEN_CHANNEL);
    return 0;
}

/**
 * 
 */
SINT32 Make_SendDataRsp_Cmd(CI_AT_CMD_LINE_T *pCmdLine, const  ZBL_CHANNEL_MSG_INFO *pMsg)
{
    atiUsatSendDataResp *ptr = NULL;
    
    if(NULL == pCmdLine || NULL ==pMsg )
    {
        return -1;
    }
    if(NULL == pMsg->msgData)
    {
        return -1;
    }
    
    strncpy(pCmdLine->strCmdOperator, "=", 2);
    ptr = (atiUsatSendDataResp*)(pMsg->msgData);
  
    snprintf(pCmdLine->strCmdParas, AT_CMD_PARA_MAX_LEN-1, "%d,%s", STK_PROCMD_TYPE_SEND_DATA,ptr->chl_data_len);
    initStkCmdDtl();
    atiCmdIdSet(CMD_STK_SEND_DATA);
    return 0;
}

/**
 * 
 */
 SINT32 Make_CbDl_Cmd(CI_AT_CMD_LINE_T *pCmdLine, const  ZBL_CHANNEL_MSG_INFO *pMsg)
{
	atiUsatDataDlCb *ptr = NULL;
    
    if(NULL == pCmdLine || NULL ==pMsg )
    {
        return -1;
    }
    if(NULL == pMsg->msgData)
    {
        return -1;
    }
    
    strncpy(pCmdLine->strCmdOperator, "=", 2);
	ptr = (atiUsatDataDlCb*)(pMsg->msgData);
       
	snprintf(pCmdLine->strCmdParas, AT_CMD_PARA_MAX_LEN-1, "%d,%s", STK_ENV_TYPE_CBS_DOWN,(char *)ptr);
	initStkCmdDtl();
    atiCmdIdSet(CMD_STK_DATA_DL_CB);
	return 0;
}

/**
 * 
 */
 SINT32 Make_PpSmsDl_Cmd(CI_AT_CMD_LINE_T *pCmdLine, const  ZBL_CHANNEL_MSG_INFO *pMsg)
{
	atiUsatDataDlSmsPp *ptr = NULL;
    UINT8 * pdu_ptr = NULL;
    SINT32 scNumberLen = 0;
    UINT8 numberCvt = 0;
    CHAR tmpStr[3] = {0};
    UINT8 ton = 0;
    UINT8 npi = 0;
    UINT8 encoded_sc_a[25] = {0};
    CHAR sc_a[21] = {0};
    UINT8 encoded_tpdu_a[ATI_USAT_MAX_LENGTH_ENCODED_MSG_TPDU + 1] = {0};
    
    if(NULL == pCmdLine || NULL ==pMsg )
    {
        return -1;
    }
    if(NULL == pMsg->msgData)
    {
        return -1;
    }
    
    strncpy(pCmdLine->strCmdOperator, "=", 2);
	ptr = (atiUsatDataDlSmsPp*)(pMsg->msgData);
	
    bytes2string(ptr->encoded_sc_a, encoded_sc_a, strlen(ptr->encoded_sc_a));
    bytes2string(&ptr->encoded_tpdu_a[1], encoded_tpdu_a, ptr->encoded_tpdu_a[0]);
    //get ton,npi and scNumber
    pdu_ptr = (UINT8*)&encoded_sc_a;
    strncpy(tmpStr, pdu_ptr, 2);    
    scNumberLen = (Str2Int(tmpStr) - 1)*2;
    memset(tmpStr, 0, sizeof(tmpStr));
    pdu_ptr += 2;
    strncpy(tmpStr, pdu_ptr, 2);    
    numberCvt = HexStr2Int(tmpStr);
    ton = (numberCvt & 0x70)>>4;
    npi = (numberCvt & 0x0F);

    memset(ptr->encoded_sc_a, 0, sizeof(ptr->encoded_sc_a));    
    if((numberCvt & 0x70) >= 0x10)  //ΪInternation Number
    {
        pdu_ptr += 4;	            //ָSMSC
        if(scNumberLen < (25-2-4+2))//cov
        SerializeNumbers(pdu_ptr, (CHAR*)&(sc_a), scNumberLen-2);	
    }
    else
    {
        pdu_ptr += 2;
        if(scNumberLen < (25-2-2))//cov
        SerializeNumbers(pdu_ptr, sc_a, scNumberLen);	
    }
      
    //strncpy(ptr->encoded_sc_a, sc_a, strlen(sc_a));
    strncpy(ptr->encoded_sc_a, sc_a, sizeof(ptr->encoded_sc_a)-1);
	snprintf(pCmdLine->strCmdParas, AT_CMD_PARA_MAX_LEN-1, "%d,%d,%d,\"%s\",\"%s\"", STK_ENV_TYPE_PP_SMS_DOWN, ton, npi, ptr->encoded_sc_a, encoded_tpdu_a);
	initStkCmdDtl();
    atiCmdIdSet(CMD_STK_DATA_DL_SMS_PP);
	return 0;
}

/**
 * 
 */
 SINT32 Make_TimerManRsp_Cmd(CI_AT_CMD_LINE_T *pCmdLine, const  ZBL_CHANNEL_MSG_INFO *pMsg)
{
	atiUsatTimerManResp *ptr = NULL;
    
    if(NULL == pCmdLine || NULL ==pMsg )
    {
        return -1;
    }
    if(NULL == pMsg->msgData)
    {
        return -1;
    }
    
    strncpy(pCmdLine->strCmdOperator, "=", 2);
	ptr = (atiUsatTimerManResp*)(pMsg->msgData);
 	snprintf(pCmdLine->strCmdParas, AT_CMD_PARA_MAX_LEN-1, "%d,%d", STK_PROCMD_TYPE_TIMER_MNG,ptr->timer_id);
	initStkCmdDtl();
    atiCmdIdSet(CMD_STK_TIMER_MANAGEMENT);
	return 0;
}

/**
 * 
 */
SINT32 Make_TimerExpr_Cmd(CI_AT_CMD_LINE_T *pCmdLine, const  ZBL_CHANNEL_MSG_INFO *pMsg)
{
	atiUsatTimerExpiration *ptr = NULL;
    
    if(NULL == pCmdLine || NULL ==pMsg )
    {
        return -1;
    }
    if(NULL == pMsg->msgData)
    {
        return -1;
    }
    
    strncpy(pCmdLine->strCmdOperator, "=", 2);
	ptr = (atiUsatTimerExpiration*)(pMsg->msgData);
       
	snprintf(pCmdLine->strCmdParas, AT_CMD_PARA_MAX_LEN-1, "%d,%d", STK_ENV_TYPE_TIMER_EXPR,ptr->timer);
	initStkCmdDtl();
    atiCmdIdSet(CMD_STK_TIMER_EXPR);
	return 0;
}

/**
 * 
 */
 SINT32 Make_GetChlStatRsp_Cmd(CI_AT_CMD_LINE_T *pCmdLine, const  ZBL_CHANNEL_MSG_INFO *pMsg)
{
	BL_STK_CHL_STATUS_RESP *ptr = NULL;
    
    if(NULL == pCmdLine || NULL ==pMsg )
    {
        return -1;
    }
    if(NULL == pMsg->msgData)
    {
        return -1;
    }
    //<ChnlID>,<Connt>,<Info>  
    strncpy(pCmdLine->strCmdOperator, "=", 2);
	ptr = (BL_STK_CHL_STATUS_RESP*)(pMsg->msgData);
       
	snprintf(pCmdLine->strCmdParas, AT_CMD_PARA_MAX_LEN-1, "%d,%d,%d,%d", STK_PROCMD_TYPE_GTCHSTAT,ptr->channel_id, ptr->established_activated, ptr->further_info);
	initStkCmdDtl();
    atiCmdIdSet(CMD_STK_GET_CHANNEL_STATUS);
	return 0;
}

/**
 * 
 */
SINT32 Make_Profiledownload_Cmd(CI_AT_CMD_LINE_T *pCmdLine, const  ZBL_CHANNEL_MSG_INFO *pMsg)
{
	atiUsatProfile* pStkProfile = NULLPTR;

    if(NULL == pCmdLine || NULL ==pMsg )
    {
        return -1;
    }
    if(NULL == pMsg->msgData)
    {
        return -1;
    }        
    strncpy(pCmdLine->strCmdOperator, "=", 2);
	pStkProfile = (atiUsatProfile*)(pMsg->msgData);
	ZTE_Trace(ZBL_AT, 0, "Make_Profiledownload_Cmd()");

	snprintf(pCmdLine->strCmdParas, sizeof(pCmdLine->strCmdParas)-1, 
	    "%02x,%02x,%02x,%02x,%02x,%02x,%02x,%02x,%02x,%02x,%02x,%02x,%02x,%02x,%02x,%02x,%02x,%02x,%02x,%02x",
		*(UINT8 *)(&pStkProfile->v_first_byte), *(UINT8 *)(&pStkProfile->v_second_byte), *(UINT8 *)(&pStkProfile->v_third_byte), 
		*(UINT8 *)(&pStkProfile->v_fourth_byte), *(UINT8*)(&pStkProfile->v_fifth_byte),
		*(UINT8 *)(&pStkProfile->v_sixth_byte), *(UINT8*)(&pStkProfile->v_seventh_byte), *(UINT8*)(&pStkProfile->v_eighth_byte), *(UINT8*)(&pStkProfile->v_ninth_byte), *(UINT8*)(&pStkProfile->v_tenth_byte),
		*(UINT8 *)(&pStkProfile->v_eleventh_byte), *(UINT8 *)(&pStkProfile->v_twelveth_byte), *(UINT8 *)(&pStkProfile->v_thirteenth_byte), *(UINT8 *)(&pStkProfile->v_fourteenth_byte), *(UINT8 *)(&pStkProfile->v_fifteenth_byte),
		*(UINT8 *)(&pStkProfile->v_sixteenth_byte), *(UINT8 *)(&pStkProfile->v_seventeenth_byte), *(UINT8 *)(&pStkProfile->v_eighteenth_byte), *(UINT8 *)(&pStkProfile->v_nineteenth_byte), *(UINT8 *)(&pStkProfile->v_twentieth_byte));

	initStkCmdDtl();
    atiCmdIdSet(CMD_STK_PROFILE_DOWNLOAD_REQ);
	
	return 0;
}
/**
 * 
 */
SINT32 Make_CardMode_Cmd(CI_AT_CMD_LINE_T *pCmdLine, const ZBL_CHANNEL_MSG_INFO *pMsg)
{
	ZTE_Trace(ZBL_AT, 0, "Make_CardMode_Cmd()");

    atiCmdIdSet(CMD_CARDMODE);
	
	return 0;
}

/**
 * 
 */
 SINT32 Make_ImgCataLog_Cmd(CI_AT_CMD_LINE_T *pCmdLine, const  ZBL_CHANNEL_MSG_INFO *pMsg)
{
	BL_STK_GET_IMG_CATALOG_REQ *ptr = NULL;
    
    if(NULL == pCmdLine || NULL ==pMsg )
    {
        return -1;
    }
    if(NULL == pMsg->msgData)
    {
        return -1;
    }
    strncpy(pCmdLine->strCmdOperator, "=", 2);
	ptr = (BL_STK_GET_IMG_CATALOG_REQ*)(pMsg->msgData);
       
	snprintf(pCmdLine->strCmdParas, AT_CMD_PARA_MAX_LEN-1, "%d", ptr->index);
	initStkCmdDtl();
    atiCmdIdSet(CMD_STK_GET_IMG_CATALOG);
	return 0;
}

/**
 * 
 */
 SINT32 Make_ImgInstance_Cmd(CI_AT_CMD_LINE_T *pCmdLine, const  ZBL_CHANNEL_MSG_INFO *pMsg)
{
	BL_STK_GET_IMG_INSTANCE_REQ *ptr = NULL;
    
    if(NULL == pCmdLine || NULL ==pMsg )
    {
        return -1;
    }
    if(NULL == pMsg->msgData)
    {
        return -1;
    }

    strncpy(pCmdLine->strCmdOperator, "=", 2);
	ptr = (BL_STK_GET_IMG_INSTANCE_REQ*)(pMsg->msgData);
       
	snprintf(pCmdLine->strCmdParas, AT_CMD_PARA_MAX_LEN-1, "%d,%d,%d", ptr->fileid, ptr->offset, ptr->length);
	initStkCmdDtl();
    atiCmdIdSet(CMD_STK_GET_IMG_INSTANCE);
	return 0;
}
#endif


