/**************************************************************************
*
*                  Copyright (c) 2013 ZTE Corporation.
*
***************************************************************************
* ģ   : AT_SERVER
*    : sms_fnc.h
* ļ : 
* ʵֹ : 
*      : G.F
*      : V1.0
*  : 2013-09-29
* ˵ : 
**************************************************************************/

/**************************************************************************
* ޸ļ¼
**************************************************************************/
/**************************************************************************
* ޸ı : ¹
*    : chenjie10092374
* ޸ : 2014.6.24
* ޸ : ֧ufi monitorܴ
**************************************************************************/


#ifndef _SMS_FNC_H_
#define _SMS_FNC_H_

/**************************************************************************
* #include
**************************************************************************/
#ifdef __cplusplus
extern "C"  
{
#endif
#include "softap_api.h"
#include "cfg_nv_def.h"


/**************************************************************************
* 
**************************************************************************/
//NV


//ݿ洢λ
#ifdef _MBB_OS_UCLINUX
#define ZTE_WMS_DB_PATH "/mnt/jffs2/etc_rw/config/sms_db/sms.db"
#define ZTE_WMS_DB_DIR   "/mnt/jffs2/etc_rw/config/sms_db"
#define ZTE_WMS_DB_FLAG   "/mnt/jffs2/etc_rw/config/sms_db/sms_restore.flag"
#else
#ifdef WEBS_SECURITY
#define ZTE_WMS_DB_PATH "/tmp/sms.db"
#define ZTE_WMS_TMP0_PATH "/etc_rw/sms.tmp0"
#define ZTE_WMS_TMP1_PATH "/etc_rw/sms.tmp1"
#define ZTE_WMS_SEC_PATH "/etc_rw/sms.dat"
#else
#define ZTE_WMS_DB_PATH "/etc_rw/sms.db"
#endif
#define ZTE_WMS_DB_DIR   "/etc_rw/"
#define ZTE_WMS_DB_FLAG   "/etc_rw/sms_restore.flag"
#endif
#define ZTE_WMS_DB_SMS_TABLE "sms"
#define ZTE_WMS_DB_NV_TABLE "nv"
#define ZTE_WMS_DB_SIM_TABLE  "sim"
#define ZTE_WMS_DB_CMD_STATUS_TABLE  "cmd_status"
#define ZTE_WMS_DB_SMS_REPORT_TABLE  "sms_report"
#define ZTE_WMS_DB_PARAMETER_TABLE  "parameter"
#define ZTE_WMS_DB_CELL_BRO_TABLE  "cell_bro"
#define ZTE_WMS_DB_SEND_CONTENT_TABLE  "send_content"

#define ZTE_WMS_MAX_CONCAT_REF 255
#define ZTE_WMS_MAX_SMS_REF 255

#define     TBASE_VALUE_MAXLEN                      256  /*max length of cfg value*/

#define ZTE_WMS_NV_MEMORY_FULL   100

#define DCS_ASC 1
#define DCS_USC 2
#define DCS_UNKNOW 0
#define DCS_UNICODE 2
#define DCS_SPANISH  3
#define DCS_PORTUGUESE 5
#define DCS_TURKISH    6

#define DCS_GSM7_SPANISH  3
#define DCS_GSM7_DEFAULT  4
#define DCS_GSM7_PORTUGUESE  5
#define NOT_DEFINE_LANGUAGE  0


#define ZTE_WMS_SMS_CONCAT_ELEMNT_LANGUAGE_LEN            (147)  //160-udl(1 byte)-fii(1 byte) - concat_info(5) - LANG_LS(3 byte) - LANG_SS(3 byte)


#define ZTE_WMS_TP_SCTS_LEN_MAX                         (50)        /*modified by crw*/
#define ZTE_WMS_SMS_UD_HEADER_LEN_MAX                (30)
#define ZTE_WMS_SMS_CONCAT_ELEMNT_MAX                (3)
#define ZTE_WMS_SMS_CONCAT_ELEMNT_ASC_LEN            (153)
#define ZTE_WMS_SMS_CONCAT_ELEMNT_UCS_LEN            (67)
/*TP_VALIDITY_PERIOD*/
#define ZTE_WMS_SMS_DEFAULT_TP_VALIDITY_PERIOD_GW    (255)
#define ZTE_WMS_SMS_DEFAULT_TP_VALIDITY_PERIOD_CDMA (244)
#define ZTE_WMS_SMS_MSG_CONTENT_STORE_LEN_MAX     (2 * ZTE_WMS_SMS_MSG_CONTENT_LEN_MAX)

#define ZTE_WMS_SMS_MSG_CHAR_MAX                    (140)
#define ZTE_WMS_SCA_LEN_MAX                             (32)
#define WMS_ADDRESS_DIGIT_MAX_V01                       (20)

enum { WMS_GW_ADDRESS_MAX         = 20  };
enum { WMS_MESSAGE_LIST_MAX     = 255 };

typedef  unsigned long int  uint32;      /* Unsigned 32 bit value */
typedef  unsigned char     byte; 
typedef  unsigned short    word;   

#ifndef boolean
typedef  unsigned char      boolean;     /* Boolean value type. */
#endif

enum { WMS_UDH_OCTETS_PORT8                =2};
enum { WMS_UDH_OCTETS_PORT16               =4};
enum { WMS_UDH_OCTETS_CONCAT8              =3};
enum { WMS_UDH_OCTETS_SPECIAL_SM           =2};
enum { WMS_UDH_OCTETS_CONCAT16             =4};
enum { WMS_UDH_OCTETS_PRE_DEF              =2};
enum { WMS_UDH_OCTETS_TEXT_FORMATTING      =3};
enum { WMS_UDH_OCTETS_RFC822               =1};
/*add by yangpeng, 2011.4.5, begin*/
enum { WMS_UDH_OCTETS_NAT_LANG_SS      =1};
enum { WMS_UDH_OCTETS_NAT_LANG_LS      =1};
/*add by yangpeng, 2011.4.5, end*/
enum { WMS_UDH_OCTETS_USER_PROMPT          =1};
enum { WMS_UDH_OCTETS_EO_HEADER            =7};
enum { WMS_UDH_ANIM_NUM_BITMAPS  = 4 };
enum { WMS_UDH_LARGE_BITMAP_SIZE = 32 };
enum { WMS_UDH_SMALL_BITMAP_SIZE = 8 };
enum { WMS_UDH_LARGE_PIC_SIZE    = 128 };
enum { WMS_UDH_SMALL_PIC_SIZE    = 32  };
enum { WMS_UDH_VAR_PIC_SIZE      = 134 };  /* 140 - 1(UDHL) - 5(UDH) */

enum { WMS_SMS_UDL_MAX_7_BIT  = 160 }; /* as in the spec */
enum { WMS_SMS_UDL_MAX_8_BIT  = 140 }; /* as in the spec */

typedef enum {
  WMS_MESSAGE_FORMAT_ENUM_MIN_ENUM_VAL_V01 = -2147483647, /**< To force a 32 bit signed enum.  Do not change or use*/
  WMS_MESSAGE_FORMAT_CDMA_V01 = 0x00, 
  WMS_MESSAGE_FORMAT_GW_PP_V01 = 0x06, 
  WMS_MESSAGE_FORMAT_GW_BC_V01 = 0x07, 
  WMS_MESSAGE_FORMAT_MWI_V01 = 0x08, 
  WMS_MESSAGE_FORMAT_ENUM_MAX_ENUM_VAL_V01 = 2147483647 /**< To force a 32 bit signed enum.  Do not change or use*/
}wms_message_format_enum_v01;

typedef enum
{
    MSG_SMS_DEFAULT=0,
	MSG_SMS_NEW,
	MSG_SMS_READING,
	MSG_SMS_MAX,	
}wms_message_status_info;


#if !HAVE_UNISTD_H
#ifndef F_OK
#define F_OK	0
#endif /* !defined F_OK */
#ifndef R_OK
#define R_OK	4
#endif /* !defined R_OK */
#endif /* !HAVE_UNISTD_H */
/**************************************************************************
* ݽṹ
**************************************************************************/

typedef enum
{
    SMS_STATE_INITING = 0, /*ڳʼ*/
    SMS_STATE_INITED,  /*ʼ*/
    SMS_STATE_LOADING, /*ڴSIMload*/	
    SMS_STATE_LOADED,  /*loadɣ۳ɹ*/
    SMS_STATE_SENDING, /*ڷͶ*/
    SMS_STATE_SENDED,  /*ɣ۳ɹ*/
    SMS_STATE_DELING,  /*ɾ*/
    SMS_STATE_DELED,   /*ɾɣ۳ɹ*/
    SMS_STATE_RECVING, /*ڽն*/
    SMS_STATE_RECVED,  /*ɣ۳ɹ*/
    SMS_STATE_SAVING,  /*ڱ*/
    SMS_STATE_SAVED,  /*ţ۳ɹ*/
    SMS_STATE_DELSAVING,/*ɾѴ洢Ĳݸ*/
    SMS_STATE_DELSAVED,	/*ɾݸĶ*/
	SMS_STATE_SIM_LOADED,  /*SIMloadɣ۳ɹ*/
	SMS_STATE_SETTING,	/*öλ*/
	SMS_STATE_HAVESET,	/*öλ*/
	SMS_STATE_CONCAT_SENDING	/*ŷ*/
}T_zUfiSms_MainState;
//SMS TYPE
typedef enum _SMS_PUSH_TYPE
{
    SMS_NO_PUSH = 0,   
    SMS_PUSH,       
    SMS_NOTIFICATION,      
    SMS_BOOTSTRAP,         
}SMS_PUSH_TYPE;

/* TP-Status - ref. 3GPP TS 23.040 section 9.2.3.15
*/
typedef enum
{
  /* Short message transaction completed:
  */
  WMS_TP_STATUS_RECEIVED_OK                   = 0x00,
  WMS_TP_STATUS_UNABLE_TO_CONFIRM_DELIVERY    = 0x01,
  WMS_TP_STATUS_REPLACED                      = 0x02,
  /* reserved: 0x03 - 0x0f */
  /* specific to each SC: 0x10 - 0x1f */

  /* Temporary error, SC still trying to transfer SM:
  */
  WMS_TP_STATUS_TRYING_CONGESTION             = 0x20,
  WMS_TP_STATUS_TRYING_SME_BUSY               = 0x21,
  WMS_TP_STATUS_TRYING_NO_RESPONSE_FROM_SME   = 0x22,
  WMS_TP_STATUS_TRYING_SERVICE_REJECTED       = 0x23,
  WMS_TP_STATUS_TRYING_QOS_NOT_AVAILABLE      = 0x24,
  WMS_TP_STATUS_TRYING_SME_ERROR              = 0x25,
  /* reserved: 0x26 - 0x2f */
  /* specific to each SC: 0x30 - 0x3f */

  /* Permanent error, SC is not making any more attempts:
  */
  WMS_TP_STATUS_PERM_REMOTE_PROCEDURE_ERROR   = 0x40,
  WMS_TP_STATUS_PERM_INCOMPATIBLE_DEST        = 0x41,
  WMS_TP_STATUS_PERM_REJECTED_BY_SME          = 0x42,
  WMS_TP_STATUS_PERM_NOT_OBTAINABLE           = 0x43,
  WMS_TP_STATUS_PERM_QOS_NOT_AVAILABLE        = 0x44,
  WMS_TP_STATUS_PERM_NO_INTERWORKING          = 0x45,
  WMS_TP_STATUS_PERM_VP_EXPIRED               = 0x46,
  WMS_TP_STATUS_PERM_DELETED_BY_ORIG_SME      = 0x47,
  WMS_TP_STATUS_PERM_DELETED_BY_SC_ADMIN      = 0x48,
  WMS_TP_STATUS_PERM_SM_NO_EXISTING           = 0x49,
  /* reserved: 0x4a - 0x4f */
  /* specific to each SC: 0x50 - 0x5f */

  /* Temporary error, SC is not making any more attempts:
  */
  WMS_TP_STATUS_TEMP_CONGESTION               = 0x60,
  WMS_TP_STATUS_TEMP_SME_BUSY                 = 0x61,
  WMS_TP_STATUS_TEMP_NO_RESPONSE_FROM_SME     = 0x62,
  WMS_TP_STATUS_TEMP_SERVICE_REJECTED         = 0x63,
  WMS_TP_STATUS_TEMP_QOS_NOT_AVAILABLE        = 0x64,
  WMS_TP_STATUS_TEMP_SME_ERROR                = 0x65,
  /* reserved: 0x66 - 0x6f */
  /* specific to each SC: 0x70 - 0x7f */

  /* reserved: 0x80 - 0xff */

  WMS_TP_STATUS_LAST = 0xFF,
  WMS_TP_STATUS_MAX32 = 0x10000000   /* pas to 32 bit int */
} wms_tp_status_e_type;


/*Ŵŵλ*/
typedef enum _SMS_LOCATION
{
    SMS_LOCATION_SIM = 0,            //
    SMS_LOCATION_ME,            //豸
    SMS_LOCATION_PC,            //PC
    SMS_LOCATION_SR
}   SMS_LOCATION;

typedef enum {
  WMS_STORAGE_TYPE_ENUM_MIN_ENUM_VAL_V01 = -2147483647, /**< To force a 32 bit signed enum.  Do not change or use*/
  WMS_STORAGE_TYPE_UIM_V01 = 0x00, 
  WMS_STORAGE_TYPE_NV_V01 = 0x01, 
  WMS_STORAGE_TYPE_NONE_V01 = -1, 
  WMS_STORAGE_TYPE_ENUM_MAX_ENUM_VAL_V01 = 2147483647 /**< To force a 32 bit signed enum.  Do not change or use*/
}wms_storage_type_enum_v01,zUfiSms_StoreType;

/*memory storage */
typedef enum
{
    ZTE_WMS_DB_OK = 0,
    ZTE_SMS_DB_ERROR_INVAILD_PTR = 100,
    ZTE_SMS_DB_ERROR_NOT_OPEN_DB,
    ZTE_SMS_DB_ERROR_FULL,
    ZTE_SMS_DB_ERROR = -1
} T_zUfiSms_DbResult;

typedef enum
{
    ZTE_WMS_MEMORY_SIM=0,
    ZTE_WMS_MEMORY_NV,
    ZTE_WMS_MEMORY_MAX
}T_zUfiSms_MemoryType;



/* Ϣģʽ:
** determines which system mode is used for a message
*/
typedef enum
{
  WMS_MESSAGE_MODE_CDMA = 0,
  WMS_MESSAGE_MODE_GW,
  WMS_MESSAGE_MODE_MAX,
  WMS_MESSAGE_MODE_MAX32 = 0x100000
} wms_message_mode_e_type;

// еϢ״̬
typedef enum
{
  WMS_TAG_NONE        = 0x00,  //ʼֵ
  WMS_TAG_MT_READ     = 0x01,
  WMS_TAG_MT_NOT_READ = 0x03,
  WMS_TAG_MO_SENT     = 0x05, /* No status report requested */
  WMS_TAG_MO_NOT_SENT = 0x07,

  /* GSM/WCDMA only */
  WMS_TAG_MO_SENT_ST_NOT_RECEIVED = 0x0D,
  WMS_TAG_MO_SENT_ST_NOT_STORED   = 0x15,
  WMS_TAG_MO_SENT_ST_STORED       = 0x35,

  WMS_TAG_MO_TEMPLATE = 0x100, /* SMS parameters */
  WMS_TAG_STATUS_RPT  = 0x200  /* SMSR parameters*/
} T_zUfiSms_SmsTag;

//洢
typedef enum
{
  WMS_MEMORY_STORE_NONE = 0,//δָ洢

  /* GSM/WCDMA memory stores
  */
  WMS_MEMORY_STORE_RAM_GW,
  WMS_MEMORY_STORE_SIM,
  WMS_MEMORY_STORE_NV_GW,

  /* CDMA memory stores
  */
  WMS_MEMORY_STORE_RAM_CDMA,  /* NOT SUPPORTED */
  WMS_MEMORY_STORE_RUIM,
  WMS_MEMORY_STORE_NV_CDMA,

  WMS_MEMORY_STORE_MAX,
  WMS_MEMORY_STORE_MAX32  = 0x10000000
} wms_memory_store_e_type;

/* Message index:
** The message index in a message list
*/
typedef uint32  wms_message_index_type;

/* Header
*/
typedef struct wms_client_msg_hdr_s
{
	wms_message_mode_e_type   message_mode;
	T_zUfiSms_SmsTag    tag;
    wms_memory_store_e_type   mem_store;
	wms_message_index_type    index; //set to WMS_DUMMY_MESSAGE_INDEX when mem_store==WMS_MEMORY_STORE_NONE
} wms_client_msg_hdr_s_type;


typedef enum
{
  WMS_NUMBER_MODE_NONE_DATA_NETWORK      = 0,
  WMS_NUMBER_MODE_DATA_NETWORK           = 1,
  WMS_NUMBER_MODE_DATA_NETWORK_MAX32     = 0x10000000

} wms_number_mode_e_type;

typedef enum
{
  WMS_DIGIT_MODE_4_BIT     = 0,  /* DTMF digits */
  WMS_DIGIT_MODE_8_BIT     = 1,
  WMS_DIGIT_MODE_MAX32     = 0x10000000

} wms_digit_mode_e_type;

typedef enum
{
  WMS_NUMBER_UNKNOWN        = 0,

  WMS_NUMBER_INTERNATIONAL  = 1,
  WMS_NUMBER_NATIONAL       = 2,
  WMS_NUMBER_NETWORK        = 3,
  WMS_NUMBER_SUBSCRIBER     = 4,
  WMS_NUMBER_ALPHANUMERIC   = 5, /* GSM SMS: addr value is GSM 7-bit chars */
  WMS_NUMBER_ABBREVIATED    = 6,
  WMS_NUMBER_RESERVED_7     = 7,

  /* The above are used when number mode is not data network address.
     The following are used only when number mode is data network address
     mode.
  */
  WMS_NUMBER_DATA_IP        = 1

  , WMS_NUMBER_INTERNET_EMAIL = 2
    /* In the address data "digits", each UINT8 contains an ASCII character.
    ** Examples are "x@y.com,a@b.com" - ref TIA/EIA-637A 3.4.3.3.
    */

  , WMS_NUMBER_MAX32        = 0x10000000

} wms_number_type_e_type;

typedef enum
{
  WMS_NUMBER_PLAN_UNKNOWN     = 0,
  WMS_NUMBER_PLAN_TELEPHONY   = 1,  /* CCITT E.164 and E.163,
                                       including ISDN plan */
  WMS_NUMBER_PLAN_RESERVED_2  = 2,
  WMS_NUMBER_PLAN_DATA        = 3,  /* CCITT X.121 */
  WMS_NUMBER_PLAN_TELEX       = 4,  /* CCITT F.69 */
  WMS_NUMBER_PLAN_RESERVED_5  = 5,
  WMS_NUMBER_PLAN_RESERVED_6  = 6,
  WMS_NUMBER_PLAN_RESERVED_7  = 7,
  WMS_NUMBER_PLAN_RESERVED_8  = 8,
  WMS_NUMBER_PLAN_PRIVATE     = 9,
  WMS_NUMBER_PLAN_RESERVED_10 = 10,
  WMS_NUMBER_PLAN_RESERVED_11 = 11,
  WMS_NUMBER_PLAN_RESERVED_12 = 12,
  WMS_NUMBER_PLAN_RESERVED_13 = 13,
  WMS_NUMBER_PLAN_RESERVED_14 = 14,
  WMS_NUMBER_PLAN_RESERVED_15 = 15,
  WMS_NUMBER_PLAN_MAX32       = 0x10000000

} wms_number_plan_e_type;

enum { WMS_ADDRESS_MAX            = 48  };

typedef struct wms_address_s
{
  wms_digit_mode_e_type          digit_mode;
    /* Indicates 4-bit or 8-bit
    */

  wms_number_mode_e_type         number_mode;
    /* Used in CDMA only: only meaningful when digit_mode is 8-bit
    */

  wms_number_type_e_type         number_type;
    /* In case of CDMA address, this is used only when digit_mode is 8-bit.
    ** To specify an international address for CDMA, use the following:
    **   digit_mode  = 8-bit
    **   number_mode = NONE_DATA_NETWORK
    **   number_type = INTERNATIONAL
    **   number_plan = TELEPHONY
    **   number_of_digits = number of digits
    **   digits = ASCII digits, e.g. '1', '2', '3', '4' and '5'.
    */

  wms_number_plan_e_type         number_plan;
    /* In case of CDMA address, this is used only when digit_mode is 8-bit.
    */

  UINT8                          number_of_digits;

  UINT8                          digits[WMS_ADDRESS_MAX];
    /* Each UINT8 in this array represents a 4-bit or 8-bit digit of
    ** address data.
    */

} wms_address_s_type;

/* TS data formats
*/
typedef enum
{
  WMS_FORMAT_CDMA         = 0,  /* IS-95 */
  WMS_FORMAT_ANALOG_CLI,        /* IS-91 */
  WMS_FORMAT_ANALOG_VOICE_MAIL, /* IS-91 */
  WMS_FORMAT_ANALOG_SMS,        /* IS-91 */
  WMS_FORMAT_ANALOG_AWISMS,     /* IS-95 Alert With Information SMS */
  WMS_FORMAT_MWI,               /* Message Waiting Indication as voice mail */
  WMS_FORMAT_GW_PP,             /* GW Point-to-Point SMS */
  WMS_FORMAT_GW_CB,             /* GW CB SMS */
  WMS_FORMAT_MAX,
  WMS_FORMAT_MAX32        = 0x10000000

} wms_format_e_type;

/*  TP-Message-Type-IndicatorʾpduеݣǶţ״̬ */
typedef enum
{
  WMS_TPDU_DELIVER = 0,
  WMS_TPDU_DELIVER_REPORT_ACK,
  WMS_TPDU_DELIVER_REPORT_ERROR,
  WMS_TPDU_SUBMIT,
  WMS_TPDU_SUBMIT_REPORT_ACK,
  WMS_TPDU_SUBMIT_REPORT_ERROR,
  WMS_TPDU_STATUS_REPORT,
  WMS_TPDU_COMMAND,
  WMS_TPDU_MAX,
  WMS_TPDU_NONE,
  WMS_TPDU_MAX32 = 0x10000000
} wms_gw_tpdu_type_e_type,T_zUfiSms_TpduType;

enum { WMS_MAX_LEN                = 255 };

/* Over-the-air raw TS data structure
*/
typedef struct wms_raw_ts_data_s
{
  wms_format_e_type           format;
  wms_gw_tpdu_type_e_type     tpdu_type;
    /* only meaningful if format is GSM/WCDMA messages */
  int                      len;
  UINT8                       data[WMS_MAX_LEN];
} T_zUfiSms_RawTsData;
/* GW message
*/
typedef struct wms_gw_message_s
{
	UINT8                       is_broadcast;
	wms_address_s_type            sc_address;
	T_zUfiSms_RawTsData        raw_ts_data;
} wms_gw_message_s_type;
/* Information about a message of all types: MT, MO, regular message,
** report, template, CB message, etc.
*/
typedef struct wms_client_message_s
{
	wms_client_msg_hdr_s_type     msg_hdr; //message_modetagȷʹĸunionԱ

	union wms_client_message_u
	{
	    wms_gw_message_s_type        gw_message;
	} u;
} wms_client_message_s_type,T_zUfiSms_ClientMsg;

typedef struct
{
    char IndStr[256];  //ŵĴ洢, ӦݿеInd "0;1"
    char Seg_Seq[256];    //ŷֶεţӦCc_Seq "1;2"
    char FormatInd[256];
    char FormatSeq[256];
}T_zUfiSms_DbStoreStr;

/* ݿеĴ洢ṹ */
typedef struct
{
    unsigned long ID;
    unsigned long  mem_store;
    unsigned short index;        /*index stored*/
    unsigned short mode;        /*network mode*/
    unsigned short tag;  //ǲݸ

    unsigned char number[ZTE_WMS_ADDRESS_LEN_MAX + 1];
    unsigned char tp_scts[ZTE_WMS_TP_SCTS_LEN_MAX + 1];
    T_zUfiSms_Date julian_date;
    unsigned char date[50];

    unsigned short tp_udhi;
    unsigned char ud_header[ZTE_WMS_SMS_UD_HEADER_LEN_MAX + 1];
    unsigned short concat_sms;
    unsigned short  concat_info[ZTE_WMS_SMS_CONCAT_ELEMNT_MAX]; //ǰκźܶκ

    unsigned long RESERVED1;
    unsigned long RESERVED2;
    unsigned long RESERVED3;

    unsigned char alphabet;
    
    unsigned short tp_dcs;    /*1-->ASCII, 2-->UNICODE, 3-->GSM7 DEFAULT, 4-->GSM7 SPANISH, 5-->GSM7 PORTUGUESE*/
    unsigned short tp_pid;    /*0-->default*/
    int msg_ref;    /*message reference , only for submit TPDU */
    unsigned short submit_status;
    unsigned short sms_report;

    unsigned char call_back[ZTE_WMS_ADDRESS_LEN_MAX + 1];
    unsigned short priority_indicator;
    unsigned short privacy_indicator;
    unsigned short reply_option;
    unsigned short alert_delivery;
    unsigned short msg_displaymode;
    unsigned short sms_class;//added by tianfuling 20130301 for sms class

    unsigned char sms_content[ZTE_WMS_SMS_MSG_CONTENT_STORE_LEN_MAX * ZTE_WMS_CONCAT_SMS_COUNT_MAX + 1];
    unsigned char raw_data_string[ZTE_WMS_SMS_MSG_CONTENT_STORE_LEN_MAX + 1];
    /*hex string , not hex format*/
    unsigned short raw_data_strlen;
    unsigned char draft_group_id[32];
} zte_wms_db_sms_data_s_type,T_zUfiSms_DbStoreData;

typedef uint32  wms_message_number_type;

typedef enum
{
  /* values from 0x00 to 0x1f are for SM-AL protocols:
  */
  WMS_PID_DEFAULT           = 0x00,  /* default value to use */

  /* values from 0x20 to 0x3f are for telematic interworking:
  */
  WMS_PID_IMPLICIT          = 0x20,
  WMS_PID_TELEX             = 0x21,
  WMS_PID_G3_FAX            = 0x22,
  WMS_PID_G4_FAX            = 0x23,
  WMS_PID_VOICE_PHONE       = 0x24,
  WMS_PID_ERMES             = 0x25,
  WMS_PID_NAT_PAGING        = 0x26,
  WMS_PID_VIDEOTEX          = 0x27,
  WMS_PID_TELETEX_UNSPEC    = 0x28,
  WMS_PID_TELETEX_PSPDN     = 0x29,
  WMS_PID_TELETEX_CSPDN     = 0x2a,
  WMS_PID_TELETEX_PSTN      = 0x2b,
  WMS_PID_TELETEX_ISDN      = 0x2c,
  WMS_PID_UCI               = 0x2d,
  WMS_PID_RESERVED_0x2e     = 0x2e,
  WMS_PID_RESERVED_0x2f     = 0x2f,
  WMS_PID_MSG_HANDLING      = 0x30,
  WMS_PID_X400              = 0x31,
  WMS_PID_INTERNET_EMAIL    = 0x32,
  WMS_PID_RESERVED_0x33     = 0x33,
  WMS_PID_RESERVED_0x34     = 0x34,
  WMS_PID_RESERVED_0x35     = 0x35,
  WMS_PID_RESERVED_0x36     = 0x36,
  WMS_PID_RESERVED_0x37     = 0x37,
  WMS_PID_SC_SPECIFIC_1     = 0x38,
  WMS_PID_SC_SPECIFIC_2     = 0x39,
  WMS_PID_SC_SPECIFIC_3     = 0x3a,
  WMS_PID_SC_SPECIFIC_4     = 0x3b,
  WMS_PID_SC_SPECIFIC_5     = 0x3c,
  WMS_PID_SC_SPECIFIC_6     = 0x3d,
  WMS_PID_SC_SPECIFIC_7     = 0x3e,
  WMS_PID_GSM_UMTS          = 0x3f,

  /* values from 0x40 to 0x7f: */
  WMS_PID_SM_TYPE_0         = 0x40,
  WMS_PID_REPLACE_SM_1      = 0x41,
  WMS_PID_REPLACE_SM_2      = 0x42,
  WMS_PID_REPLACE_SM_3      = 0x43,
  WMS_PID_REPLACE_SM_4      = 0x44,
  WMS_PID_REPLACE_SM_5      = 0x45,
  WMS_PID_REPLACE_SM_6      = 0x46,
  WMS_PID_REPLACE_SM_7      = 0x47,
  /* ... values reserved not listed ... */
  WMS_PID_EMS               = 0x5e,
  WMS_PID_RETURN_CALL       = 0x5f,
  /* ... values reserved not listed ... */
  WMS_PID_ANSI136_R_DATA    = 0x7c,
  WMS_PID_ME_DATA_DOWNLOAD  = 0x7d,
  WMS_PID_ME_DEPERSONALIZE  = 0x7e,
  WMS_PID_SIM_DATA_DOWNLOAD = 0x7f,
  WMS_PID_E_MAX32 = 0x10000000   /* pas to 32 bit int */

  /* values from 0x80 to 0xbf are reserved */

  /* values from 0xc0 to 0xff are for SC specific use */

} wms_pid_e_type;

/* Message class:
** The message class in the Data Coding Scheme of a TPDU or CB message
*/
typedef enum
{
  /* the following are GW message classes
  */
  WMS_MESSAGE_CLASS_0 = 0,
  WMS_MESSAGE_CLASS_1,
  WMS_MESSAGE_CLASS_2,
  WMS_MESSAGE_CLASS_3,
  WMS_MESSAGE_CLASS_NONE,

  /* The following class is for CDMA only
  */
  WMS_MESSAGE_CLASS_CDMA,

  WMS_MESSAGE_CLASS_MAX,
  WMS_MESSAGE_CLASS_MAX32 = 0x10000000
} wms_message_class_e_type;

/* GW Alphabet sets
*/
typedef enum
{
  WMS_GW_ALPHABET_7_BIT_DEFAULT,
  WMS_GW_ALPHABET_8_BIT,
  WMS_GW_ALPHABET_UCS2,
  WMS_GW_ALPHABET_MAX32 = 0x10000000   /* pas to 32 bit int */
} wms_gw_alphabet_e_type;

typedef enum
{
  WMS_GW_MSG_WAITING_NONE,
  WMS_GW_MSG_WAITING_DISCARD,
  WMS_GW_MSG_WAITING_STORE,
  WMS_GW_MSG_WAITING_NONE_1111,
  WMS_GW_MSG_WAITING_MAX32 = 0x10000000 /* pas to 32 bit int */
} wms_gw_msg_waiting_e_type;

/* GW message waiting types
*/
typedef enum
{
  WMS_GW_MSG_WAITING_VOICEMAIL,
  WMS_GW_MSG_WAITING_FAX,
  WMS_GW_MSG_WAITING_EMAIL,
  WMS_GW_MSG_WAITING_OTHER,
  WMS_GW_MSG_WAITING_KIND_MAX32 = 0x10000000   /* pas to 32 bit int */
} wms_gw_msg_waiting_kind_e_type;

/* GW Data Coding Scheme
*/
typedef struct wms_gw_dcs_s
{
  wms_message_class_e_type          msg_class;
  UINT8                           is_compressed;
  wms_gw_alphabet_e_type            alphabet;
  wms_gw_msg_waiting_e_type         msg_waiting;
  UINT8                           msg_waiting_active;
  wms_gw_msg_waiting_kind_e_type    msg_waiting_kind;
  /* Raw DCS Byte */
  UINT8                             raw_dcs_data;
} wms_gw_dcs_s_type;

/* GW Validity Formats
*/
typedef enum
{
  WMS_GW_VALIDITY_NONE = 0,
  WMS_GW_VALIDITY_RELATIVE = 2,
  WMS_GW_VALIDITY_ABSOLUTE = 3,
  WMS_GW_VALIDITY_ENHANCED = 1,
  WMS_GW_VALIDITY_MAX32 = 0x10000000   /* pas to 32 bit int */
} wms_gw_validity_format_e_type;

typedef  signed char       sint7;        /* Signed 8  bit value */

typedef struct
{
  /* If 'year' is between 96 and 99, the actual year is 1900 + 'year';
     if 'year' is between 00 and 95, the actual year is 2000 + 'year'.
     NOTE: Each field has two BCD digits and UINT8 arrangement is <MSB, ... ,LSB>
  */
  UINT8      year;        /* 0x00-0x99 */
  UINT8      month;       /* 0x01-0x12 */
  UINT8      day;         /* 0x01-0x31 */
  UINT8      hour;        /* 0x00-0x23 */
  UINT8      minute;      /* 0x00-0x59 */
  UINT8      second;      /* 0x00-0x59 */
  sint7      timezone;    /* +/-, [-48,+48] number of 15 minutes - GW only */
} wms_timestamp_s_type, T_zUfiSms_TimeStamp;

/* GW Validity info
*/
typedef struct wms_gw_validity_s
{
  wms_gw_validity_format_e_type  format;
  union wms_gw_validity_u
  {
    wms_timestamp_s_type    time;
  } u;
  /*~ FIELD wms_gw_validity_s.u DISC _OBJ_.format */
} wms_gw_validity_s_type;

enum { WMS_MAX_UD_HEADERS       = 7};

// ַ
typedef enum _CODE_TYPE
{
    CODE_GSM7           = 0,                        // 7λASCII
    CODE_GSM8           = 4,                        // 8λASCII
    CODE_UCS2           = 8                         // UNICODE2
}CODE_TYPE;

/* SMS User Data Header IDs
*/
typedef enum
{
  WMS_UDH_CONCAT_8         = 0x00,
  WMS_UDH_SPECIAL_SM,
  /* 02 - 03    Reserved */
  WMS_UDH_PORT_8           = 0x04,
  WMS_UDH_PORT_16,
  WMS_UDH_SMSC_CONTROL,
  WMS_UDH_SOURCE,
  WMS_UDH_CONCAT_16,
  WMS_UDH_WCMP,
  WMS_UDH_TEXT_FORMATING,
  WMS_UDH_PRE_DEF_SOUND,
  WMS_UDH_USER_DEF_SOUND,
  WMS_UDH_PRE_DEF_ANIM,
  WMS_UDH_LARGE_ANIM,
  WMS_UDH_SMALL_ANIM,
  WMS_UDH_LARGE_PICTURE,
  WMS_UDH_SMALL_PICTURE,
  WMS_UDH_VAR_PICTURE,

  WMS_UDH_USER_PROMPT      = 0x13,
  WMS_UDH_EXTENDED_OBJECT  = 0x14,

  /* 15 - 1F    Reserved for future EMS */

  WMS_UDH_RFC822           = 0x20,

  WMS_UDH_NAT_LANG_SS      = 0x24,
  WMS_UDH_NAT_LANG_LS      = 0x25,

  /*  21 - 23, 26 - 6F    Reserved for future use */
  /*  70 - 7f    Reserved for (U)SIM Toolkit Security Headers */
  /*  80 - 9F    SME to SME specific use */
  /*  A0 - BF    Reserved for future use */
  /*  C0 - DF    SC specific use */
  /*  E0 - FF    Reserved for future use */

  WMS_UDH_OTHER            = 0xFFFF, /* For unsupported or proprietary headers */
  WMS_UDH_ID_MAX32 = 0x10000000   /* pas to 32 bit int */

} wms_udh_id_e_type;


typedef struct wms_udh_concat_8_s
{
  UINT8       msg_ref;
  /*indicates the reference number for a particular concatenated short message. */
  /*it is constant for every short message which makes up a particular concatenated short message*/
  UINT8       total_sm;
  /*indicates the total number of short messages within the concatenated short message.
   The value shall start at 1 and remain constant for every short message which makes up the concatenated short message.
   if it is 0 then the receiving entity shall ignore the whole Information Element*/
   UINT8      seq_num;
   /*it indicates the sequence number of a particular short message within the concatenated short */
   /* message. The value shall start at 1 and increment by one for every short message sent within the concatenated short message. If the value is zero or the value is greater than the value in octet 2 then the receiving entity shall ignore the whole Information Element.*/

} wms_udh_concat_8_s_type,T_zUfiSms_UdhConcat8;

typedef struct wms_udh_concat_16_s
{
  UINT16      msg_ref;
  UINT8       total_sm;
  UINT8       seq_num;

} wms_udh_concat_16_s_type,T_zUfiSms_UdhConcat16;


/* ------------------------------------- */
/* National Language Related Definitions */
/* ------------------------------------- */

typedef enum
{
  WMS_UDH_NAT_LANG_TURKISH          = 0x1,
  WMS_UDH_NAT_LANG_SPANISH          = 0x2,
  WMS_UDH_NAT_LANG_PORTUGUESE       = 0x3,
  /* 0x0    Reserved */
  /* 0x4 - 0xFF Reserved */
  WMS_UDH_NAT_LANG_MAX32 = 0x10000000   /* pas to 32 bit int */
} wms_udh_nat_lang_id_e_type;

typedef struct wms_udh_nat_lang_ss_s
{
  wms_udh_nat_lang_id_e_type nat_lang_id;
} wms_udh_nat_lang_ss_s_type;

typedef enum
{
  WMS_UDH_LEFT_ALIGNMENT = 0,
  WMS_UDH_CENTER_ALIGNMENT,
  WMS_UDH_RIGHT_ALIGNMENT,
  WMS_UDH_DEFAULT_ALIGNMENT,
  WMS_UDH_MAX_ALIGNMENT,
  WMS_UDH_ALIGNMENT_MAX32 = 0x10000000   /* pas to 32 bit int */
} wms_udh_alignment_e_type;

typedef enum
{
  WMS_UDH_FONT_NORMAL = 0,
  WMS_UDH_FONT_LARGE,
  WMS_UDH_FONT_SMALL,
  WMS_UDH_FONT_RESERVED,
  WMS_UDH_FONT_MAX,
  WMS_UDH_FONT_MAX32 = 0x10000000   /* pas to 32 bit int */
} wms_udh_font_size_e_type;

typedef enum
{
  WMS_UDH_TEXT_COLOR_BLACK          = 0x0,
  WMS_UDH_TEXT_COLOR_DARK_GREY      = 0x1,
  WMS_UDH_TEXT_COLOR_DARK_RED       = 0x2,
  WMS_UDH_TEXT_COLOR_DARK_YELLOW    = 0x3,
  WMS_UDH_TEXT_COLOR_DARK_GREEN     = 0x4,
  WMS_UDH_TEXT_COLOR_DARK_CYAN      = 0x5,
  WMS_UDH_TEXT_COLOR_DARK_BLUE      = 0x6,
  WMS_UDH_TEXT_COLOR_DARK_MAGENTA   = 0x7,
  WMS_UDH_TEXT_COLOR_GREY           = 0x8,
  WMS_UDH_TEXT_COLOR_WHITE          = 0x9,
  WMS_UDH_TEXT_COLOR_BRIGHT_RED     = 0xA,
  WMS_UDH_TEXT_COLOR_BRIGHT_YELLOW  = 0xB,
  WMS_UDH_TEXT_COLOR_BRIGHT_GREEN   = 0xC,
  WMS_UDH_TEXT_COLOR_BRIGHT_CYAN    = 0xD,
  WMS_UDH_TEXT_COLOR_BRIGHT_BLUE    = 0xE,
  WMS_UDH_TEXT_COLOR_BRIGHT_MAGENTA = 0xF,
  WMS_UDH_TEXT_COLOR_MAX32 = 0x10000000   /* pas to 32 bit int */
} wms_udh_text_color_e_type;

typedef struct wms_udh_text_formating_s
{
  UINT8                     start_position;
  UINT8                     text_formatting_length;
  wms_udh_alignment_e_type  alignment_type ;       /*bit 0 and  bit 1*/
  wms_udh_font_size_e_type  font_size ;            /*bit 3 and  bit 2*/
  UINT8                   style_bold;            /*bit 4 */
  UINT8                   style_italic;          /*bit 5  */
  UINT8                   style_underlined;      /*bit 6 */
  UINT8                   style_strikethrough;   /*bit 7 */

  UINT8                   is_color_present;
    /* if FALSE, ignore the following color information */
  wms_udh_text_color_e_type text_color_foreground;
  wms_udh_text_color_e_type text_color_background;

} wms_udh_text_formating_s_type;

enum { WMS_UDH_OTHER_SIZE        = 226 };
typedef struct wms_udh_other_s
{
   wms_udh_id_e_type  header_id;
   UINT8               header_length;
   UINT8              data[WMS_UDH_OTHER_SIZE];
} wms_udh_other_s_type;

#define WMS_UDH_EO_DATA_SEGMENT_MAX    131 /* 140 - 3 - 6 */
typedef struct wms_udh_eo_content_s
{
  UINT8         length;

  UINT8         data[WMS_UDH_EO_DATA_SEGMENT_MAX];
    /* WMS_UDH_EO_VCARD: See http://www.imc.org/pdi/vcard-21.doc for payload */
    /* WMS_UDH_EO_VCALENDAR: See http://www.imc.org/pdi/vcal-10.doc */
    /* Or: Unsupported/proprietary extended objects */

} wms_udh_eo_content_s_type;

/* Extended Object IDs/types
*/
typedef enum
{
  WMS_UDH_EO_VCARD                   = 0x09,
  WMS_UDH_EO_VCALENDAR               = 0x0A,
  WMS_UDH_EO_MAX32 = 0x10000000   /* pas to 32 bit int */
} wms_udh_eo_id_e_type;
/* Extended Object UDH
*/
typedef struct wms_udh_eo_s
{
  /* Extended objects are to be used together with 16-bit concatenation
  ** UDH. The max number of segments supported for E.O. is 8 at least.
  */
  wms_udh_eo_content_s_type    content;

  UINT8                                 first_segment;
    /* The following fields are only present in the first segment of a
    ** concatenated SMS message.
    */
  UINT8                                   reference;
    /* Identify those extended object segments which should be linked together
    */
  UINT16                                  length;
    /* Length of the whole extended object data
    */
  UINT8                                   control;
  wms_udh_eo_id_e_type                    type;
  UINT16                                  position;
    /* Absolute position of the E.O. in the whole text after concatenation,
    ** starting from 1.
    */
} wms_udh_eo_s_type;

/* Variable length picture
*/
typedef struct wms_udh_var_picture_s
{
  UINT8       position;
  UINT8       width;    /* Number of pixels - Should be a mutliple of 8 */
  UINT8       height;
  UINT8       data[WMS_UDH_VAR_PIC_SIZE];
} wms_udh_var_picture_s_type;

enum { WMS_UDH_MAX_SND_SIZE          = 128 };

typedef struct wms_udh_user_def_sound_s
{
  UINT8       data_length;
  UINT8       position;
  UINT8       user_def_sound[WMS_UDH_MAX_SND_SIZE];
} wms_udh_user_def_sound_s_type;

typedef struct wms_udh_nat_lang_ls_s
{
  wms_udh_nat_lang_id_e_type nat_lang_id;
} wms_udh_nat_lang_ls_s_type;

typedef struct wms_udh_special_sm_s
{
  wms_gw_msg_waiting_e_type                  msg_waiting;
  wms_gw_msg_waiting_kind_e_type             msg_waiting_kind;
  UINT8                                      message_count;
  /*it indicates the number of messages of the type specified in Octet 1 waiting.*/
} wms_udh_special_sm_s_type;

typedef struct wms_udh_wap_8_s
{
  UINT8  dest_port;
  UINT8  orig_port;
} wms_udh_wap_8_s_type;

typedef struct wms_udh_wap_16_s
{
  UINT16  dest_port;
  UINT16  orig_port;
} wms_udh_wap_16_s_type;

typedef struct wms_udh_pre_def_sound_s
{
  UINT8       position;
  UINT8       snd_number;
} wms_udh_pre_def_sound_s_type;

typedef struct wms_udh_pre_def_anim_s
{
  UINT8       position;
  UINT8       animation_number;
} wms_udh_pre_def_anim_s_type;

/* Large animation
*/
typedef struct wms_udh_large_anim_s
{
  UINT8        position;
  UINT8        data[WMS_UDH_ANIM_NUM_BITMAPS][WMS_UDH_LARGE_BITMAP_SIZE];
} wms_udh_large_anim_s_type;

/* Small animation
*/
typedef struct wms_udh_small_anim_s
{
  UINT8         position;
  UINT8         data[WMS_UDH_ANIM_NUM_BITMAPS][WMS_UDH_SMALL_BITMAP_SIZE];
} wms_udh_small_anim_s_type;

typedef struct wms_udh_large_picture_data_s
{
  UINT8                      position;
  UINT8                      data[WMS_UDH_LARGE_PIC_SIZE];
} wms_udh_large_picture_data_s_type;

/* Small picture
*/
typedef struct wms_udh_small_picture_data_s
{
  UINT8                     position;
  UINT8                     data[WMS_UDH_SMALL_PIC_SIZE];
} wms_udh_small_picture_data_s_type;

typedef struct wms_udh_user_prompt_s
{
  UINT8       number_of_objects;
    /* Number of objects of the same kind that follow this header which will
    ** be stitched together by the applications. For example, 5 small pictures
    ** are to be stitched together horizontally, or 6 iMelody tones are to be
    ** connected together with intermediate iMelody header and footer ignored.
    ** Allowed objects to be stitched:
    **   - Images (small, large, variable)
    **   - User defined sounds
    */
} wms_udh_user_prompt_s_type;

typedef struct wms_udh_rfc822_s
{
  UINT8        header_length;
} wms_udh_rfc822_s_type;

typedef struct wms_udh_s
{
  wms_udh_id_e_type               header_id;

  union wms_udh_u
  {
    wms_udh_concat_8_s_type             concat_8;       // 00
 	wms_udh_concat_16_s_type            concat_16;      // 08
	wms_udh_nat_lang_ss_s_type          nat_lang_ss;    // 24
    wms_udh_text_formating_s_type       text_formating; // 0a

    wms_udh_other_s_type                other;
	wms_udh_eo_s_type					eo; 
	wms_udh_var_picture_s_type			var_picture; 
    wms_udh_user_def_sound_s_type       user_def_sound; // 0c
    wms_udh_nat_lang_ls_s_type          nat_lang_ls;    // 25
	wms_udh_special_sm_s_type			special_sm; 	// 01	
    wms_udh_wap_8_s_type                wap_8;          //04
    wms_udh_wap_16_s_type               wap_16;         //05
    wms_udh_pre_def_sound_s_type        pre_def_sound;  // 0b
    wms_udh_pre_def_anim_s_type         pre_def_anim;   // 0d
    wms_udh_large_anim_s_type           large_anim;     // 0e
    wms_udh_small_anim_s_type           small_anim;     // 0f
    wms_udh_large_picture_data_s_type   large_picture;  // 10
    wms_udh_small_picture_data_s_type   small_picture;  // 11
	wms_udh_user_prompt_s_type          user_prompt;    // 13
    wms_udh_rfc822_s_type               rfc822;         // 20
  	#if 0
 /*~ CASE WMS_UDH_SMALL_PICTURE wms_udh_u.small_picture */
    wms_udh_var_picture_s_type          var_picture;    // 12
 /*~ CASE WMS_UDH_VAR_PICTURE wms_udh_u.var_picture */



    wms_udh_eo_s_type                   eo;             // 14
    wms_udh_other_s_type                other;
 /*~ DEFAULT wms_udh_u.other */
#endif
  }u;   /*~ FIELD wms_udh_s.u DISC _OBJ_.header_id */
} wms_udh_s_type,T_zUfiSms_Udh;
/* GW user data type
*/
typedef struct wms_gw_user_data_s
{
  UINT8                          num_headers;
  wms_udh_s_type                 headers[WMS_MAX_UD_HEADERS];

  UINT16                         sm_len;
  UINT8                          sm_data[WMS_MAX_LEN];
    /* If DCS indicates the default 7-bit alphabet, each UINT8 holds one character
    ** with bit 7 equal to 0 and sm_len indicates the number of characters;
    ** If DCS indicates otherwise, each character may occupy multiple bytes
    ** and sm_len indicates the total number of bytes.
    */
} wms_gw_user_data_s_type;

/* Submit TPDU
*/
typedef struct wms_gw_submit_s
{
  UINT8                           reject_duplicates;        /* TP-RD 0:ظ  1: ظ*/
  UINT8                           reply_path_present;       /* TP-RP 0:ЯӦ·*/
  UINT8                           user_data_header_present; /* TP-UDHI 1: header */
  UINT8                           status_report_enabled;    /* TP-SRR 1:״̬ */
  wms_message_number_type           message_reference;        /* TP-MR ŷͼ */
  wms_address_s_type                address;                  /* TP-DA sc· */
  wms_pid_e_type                    pid;                      /* TP-PID Эid */
  wms_gw_dcs_s_type                 dcs;                      /* TP-DCS űģʽ */
  wms_gw_validity_s_type            validity;                 /* TP-VPF & TP-VP Ч */
  wms_gw_user_data_s_type           user_data;                /* TP-UD */
} wms_gw_submit_s_type,T_zUfiSms_SubmitTpdu;

/* Deliver TPDU
*/
typedef struct wms_gw_deliver_s
{
  UINT8                          more;                     /* TP-MMS */
  UINT8                          reply_path_present;       /* TP-RP */
  UINT8                          user_data_header_present; /* TP-UDHI */
  UINT8                          status_report_enabled;    /* TP-SRI */
  wms_address_s_type               address;                  /* TP-OA */
  wms_pid_e_type                   pid;                      /* TP-PID */
  wms_gw_dcs_s_type                dcs;                      /* TP-DCS */
  wms_timestamp_s_type             timestamp;                /* TP-SCTS */
  wms_gw_user_data_s_type          user_data;                /* TP-UD */
} wms_gw_deliver_s_type,T_zUfiSms_DeliverPdu;


typedef struct wms_gw_status_report_s
{
  UINT8                       user_data_header_present; /* TP-UDHI */
  UINT8                       more;                     /* TP-MMS */
  UINT8                       status_report_qualifier;  /* TP-SRQ */
  wms_message_number_type       message_reference;        /* TP-MR */
  wms_address_s_type            address;                  /* TP-RA */
  wms_timestamp_s_type          timestamp;                /* TP-SCTS */
  wms_timestamp_s_type          discharge_time;           /* TP-DT */
  wms_tp_status_e_type          tp_status;                /* TP-ST */

  /* the mask indicates which of the optional fields are present
  */
  uint32                        mask;                     /* TP-PI */
  wms_pid_e_type                pid;                      /* TP-PID */
  wms_gw_dcs_s_type             dcs;                      /* TP-DCS */
  wms_gw_user_data_s_type       user_data;                /* TP-UD */
} wms_gw_status_report_s_type;

/* GW Point-to-Point TS data decoded from the raw TS data
*/
typedef struct wms_gw_pp_ts_data_s
{
  wms_gw_tpdu_type_e_type                tpdu_type;
    /* Note: this is not equivalent to TP-MTI */
  union wms_gw_pp_ts_data_u
  {
      wms_gw_deliver_s_type                deliver;
  #if 0
    /*~ CASE WMS_TPDU_DELIVER wms_gw_pp_ts_data_u.deliver */
    wms_gw_deliver_report_ack_s_type     deliver_report_ack;
    /*~ CASE WMS_TPDU_DELIVER_REPORT_ACK wms_gw_pp_ts_data_u.deliver_report_ack */
    wms_gw_deliver_report_error_s_type   deliver_report_error;
    /*~ CASE WMS_TPDU_DELIVER_REPORT_ERROR wms_gw_pp_ts_data_u.deliver_report_error */
#endif
	wms_gw_submit_s_type                 submit;
	wms_gw_status_report_s_type 		 status_report;

#if 0
	/*~ CASE WMS_TPDU_SUBMIT wms_gw_pp_ts_data_u.submit */
    wms_gw_submit_report_ack_s_type      submit_report_ack;
    /*~ CASE WMS_TPDU_SUBMIT_REPORT_ACK wms_gw_pp_ts_data_u.submit_report_ack */
    wms_gw_submit_report_error_s_type    submit_report_error;
    /*~ CASE WMS_TPDU_SUBMIT_REPORT_ERROR wms_gw_pp_ts_data_u.submit_report_error */

    /*~ CASE WMS_TPDU_STATUS_REPORT wms_gw_pp_ts_data_u.status_report*/
    wms_gw_command_s_type                command;
    /*~ CASE WMS_TPDU_COMMAND wms_gw_pp_ts_data_u.command */

    /*~ DEFAULT wms_gw_pp_ts_data_u.void */
#endif
  } u; /*~ FIELD wms_gw_pp_ts_data_s.u DISC _OBJ_.tpdu_type */

} wms_gw_pp_ts_data_s_type;

/* Client TS data decoded from the raw TS data
*/
typedef struct wms_client_ts_data_s
{
	wms_format_e_type             format;

	union wms_client_ts_data_u
	{
		//wms_client_bd_s_type        cdma;
		wms_gw_pp_ts_data_s_type    gw_pp;
		//wms_gw_cb_ts_data_s_type    gw_cb;
	} u; /*~ FIELD wms_client_ts_data_s.u DISC _OBJ_.format */

} wms_client_ts_data_s_type, T_zUfiSms_ClientTsData;


/* Status:
*/
typedef enum
{
  WMS_OK_S                  = 0,
  WMS_OUT_OF_RESOURCES_S,   /* e.g. out of memory buffer */
  WMS_TERMINAL_BLOCKED_S,
  WMS_TERMINAL_BUSY_S,
  WMS_INVALID_TRANSACTION_ID_S,
  WMS_INVALID_FORMAT_S,
  WMS_GENERAL_ERROR_S,
  WMS_UNSUPPORTED_S,
  WMS_NULL_PTR_S,

  /* CDMA only
  */
  WMS_INVALID_PARM_SIZE_S   = 100,
  WMS_INVALID_USER_DATA_SIZE_S,
  WMS_INVALID_PARM_VALUE_S,
  WMS_MISSING_PARM_S,
  WMS_NETWORK_NOT_READY_S,
  WMS_PHONE_NOT_READY_S,
  WMS_NOT_ALLOWED_IN_AMPS_S,
  WMS_NETWORK_FAILURE_S,
  WMS_ACCESS_TOO_LARGE_S,
  WMS_DTC_TOO_LARGE_S,
  WMS_ACCESS_BLOCK_S,
  WMS_ESN_MISMATCH_S, /* for JCDMA2 feature only */

  /* GSM/WCDMA only
  */
  WMS_INVALID_TPDU_TYPE_S  = 200,
  WMS_INVALID_VALIDITY_FORMAT_S,
  WMS_INVALID_CB_DATA_S,
  WMS_MT_MSG_FAILED_S, /* internal use */

  /* SIP errors
  */
  WMS_SIP_PERM_ERROR_S     = 300,
  WMS_SIP_TEMP_ERROR_S,

  /* WMSC, CS and RPC errors
  */
  WMS_WMSC_ERROR_S         = 400,
  WMS_CS_ERROR_S,
  WMS_RPC_ERROR_S,

  WMS_STATUS_MAX,
  WMS_STATUS_MAX32 = 0x10000000    /* pad to 32 bit int */
} wms_status_e_type;


/* TPDU parameter bit masks
*/
enum
{
  WMS_TPDU_MASK_PID         = 0x0001,
  WMS_TPDU_MASK_DCS         = 0x0002,
  WMS_TPDU_MASK_USER_DATA   = 0x0004
};

typedef enum 
{
	RECEIVED_UNREAD,
	RECEIVED_READ,
	STORED_UNSEND,
	STORED_SEND
}T_SmsStatus;

typedef enum {
  WMS_MESSAGE_TAG_TYPE_ENUM_MIN_ENUM_VAL_V01 = -2147483647, /**< To force a 32 bit signed enum.  Do not change or use*/
  WMS_TAG_TYPE_MT_READ_V01 = 0x00, 
  WMS_TAG_TYPE_MT_NOT_READ_V01 = 0x01, 
  WMS_TAG_TYPE_MO_SENT_V01 = 0x02, 
  WMS_TAG_TYPE_MO_NOT_SENT_V01 = 0x03, 
  WMS_MESSAGE_TAG_TYPE_ENUM_MAX_ENUM_VAL_V01 = 2147483647 /**< To force a 32 bit signed enum.  Do not change or use*/
}wms_message_tag_type_enum_v01;

#if 0 //ʹT_zSms_SmsInd
/* ϢݵĶ */
typedef struct 
{
    int     index;
    int     stat;
    //qinwei modify from 32 to 36,add one byte for endmark
    char    alpha[36];
    int     length;
    //޸SIM\USIMϢΪ100100SIM\USIM¼ʱֻܶ80
    //qinwei 2005-8-23 9:42 changed from 504 to 324
    char    pdu[354];
} T_zUfiSms_SmsItem;
#endif
//coremԴsms_com.h


#define AT_DEBUG 0
#define AT_ERR 1


#define at_print(LEVEL,...) do { printf(__VA_ARGS__); \						
                            } while(0)
                            //if(LEVEL) assert(__VA_ARGS__); \

#define ZSMS_RESULT_OK               0x01    /* ִгɹ */
#define ZSMS_RESULT_ERROR            0x02 

/*
#define ZSMS_SCA_SIZE               36
#define ZSMS_TPA_SIZE               36
#define ZSMS_TPSCTS_SIZE            30
#define ZSMS_MAX_TPUD_SIZE          760
#define ZSMS_TPDT_SIZE              30
*/
#define ZSMS_NUM_MAX_CPE            60
#define ZSMS_CTRL_Z_CHAR            26

#define SMS_ASCII_CONCAT_MAX_LEN     640 


typedef struct
{   
    UINT8 nv_count;
    UINT8 nv_index_count;
    UINT8 nv_index;
    int nv_id[ZTE_WMS_DELETE_COUNT_MAX];
    
    UINT8 sim_count;
    UINT8 sim_index_count;
    UINT8 sim_index;
    int sim_id[ZTE_WMS_DELETE_COUNT_MAX];
    UINT8 sim_indices[ZTE_WMS_DELETE_COUNT_MAX];
}T_zUfiSms_DelSms,T_zUfiSms_ModifySms;

typedef struct
{   
   UINT8 cur_index;
   UINT8 total;
   UINT8  index[ZTE_WMS_DELETE_COUNT_MAX];
}T_zUfiSms_DelIndexInfo, T_zUfiSms_ModifyIndexInfo;

/*modify msg tag req */
typedef struct
{
    unsigned long id_index;

    unsigned short total_indices;
    unsigned short  num_of_indices;     /* Total indices          */
    int indices[ZTE_WMS_MESSAGE_LIST_MAX];
} T_zUfiSms_ModifyTag;


// Ϣṹ/빲
// Уַ0β
typedef struct {
    char SCA[44];			// Ϣĺ(SMSCַ)
    char TPA[44];			// Ŀظ(TP-DATP-RA)
    char TP_PID;			// ûϢЭʶ(TP-PID)
    char TP_DCS;			// ûϢ뷽ʽ(TP-DCS)
    unsigned char TP_VP;             // ûϢڶĵıʱ䣨5Ϊλ
    char TP_SRR;            // ûϢ״̬棨0 Ҫ 1 Ҫ
    char TP_SCTS[30];		// ʱַ(TP_SCTS), ʱõ
    char TP_UD[SMS_ASCII_CONCAT_MAX_LEN+4];		// ԭʼûϢ(ǰTP-UD) MAX_TP_UD_LEN+1
    int  index;			    // Ϣţڶȡɾʱõ
    char TP_DT[30];		        // Ϣɹ͵кʱ(TP-DT)
    char TP_ST;			        //ǰһύĶϢ״̬(TP-ST)
    char TP_MR;
    unsigned char stat;     //Ϣ״̬ 0,1,2,3 öSMS_Status
    unsigned char   TP_UDLength; //TP_UDĳ
	//begin add for concat sms
	char            TP_UDHI;                      //Ϣͷָʾ1˵ǴϢͷ
    char            TP_IEI;                       //ϢԪָʾΪ0ʾӶϢ
    //char            TP_ReferNum;                  //ο룬ÿӶϢʹͬĲο
    //char            TP_AllPieceNum;               //ӶϢֵܶ
    //char            TP_CurrentPieceNum;           //ӶϢĵǰ
   // char            TP_IsALLConcatSms;            //ǷΪǰӶϢ
    unsigned short TP_ReferNum;                  //ο룬ÿӶϢʹͬĲο
    unsigned short TP_AllPieceNum;               //ӶϢֵܶ
    unsigned short TP_CurrentPieceNum;      //ӶϢĵǰ
    unsigned short TP_IsConcatSms;            //ǷΪϢ
    //end add for concat sms
} SMS_PARAM;


// for group send
typedef struct
{
    unsigned short total_receiver;
    unsigned short current_receiver;
    unsigned char receivers[ZTE_WMS_SEND_NUM_MAX][ZTE_WMS_ADDRESS_LEN_MAX+1];
} T_zUfiSms_GroupInfo;

typedef struct
{
    unsigned short total_msg;    //ֶܷ
    unsigned short current_sending; //ǰ͵Ķ
    unsigned long sms_len;
    unsigned char msg_contents[ZTE_WMS_CONCAT_SMS_COUNT_MAX][ZTE_WMS_SMS_MSG_CONTENT_LEN_MAX + 1];
    T_zUfiSms_Date date;
} T_zUfiSms_ConcatInfo;


/**************************************************************************
* 
**************************************************************************/ 
extern int zUfiSms_SetDeleteInfo(T_zUfiSms_DelReq *ptDelMsg);
extern T_zUfiSms_CmdStatus zUfiSms_DeleteSimSms(VOID);
extern void zUfiSms_CfgInit(void);
extern void zUfiSms_InitDb(void);
extern void zUfiSms_CfgSmsNvInit(void);
extern void zUfiSms_SetSmsLocation(SMS_LOCATION eLocation);
extern void zUfiSms_ChangeMainState(T_zUfiSms_MainState iNewState);
extern T_zUfiSms_CmdStatus zUfiSms_SaveSmsToDb
(
    T_zUfiSms_SaveReq *ptSaveSms,
    T_zUfiSms_ConcatInfo *ptConcatSms,
    T_zUfiSms_GroupInfo *ptGroupSms,
    int iSmsLength
);
byte * zUfiSms_UtilTimeStamp
(
    T_zUfiSms_TimeStamp zte_wms_time,  /* Pointer to Time Stamp        */
    byte * res_ptr,                /* Pointer to the result buffer */
    T_zUfiSms_Date *date
);

extern void zUfiSms_SetGlobalDcsLang(unsigned char cDcs);
extern int zUfiSms_FillGroupSms(T_zUfiSms_SendReq *ptSendMsg, T_zUfiSms_GroupInfo *ptGroupSms);
extern int zUfiSms_WriteSmsToDb(T_zUfiSms_DbStoreData *ptDbSaveData, zUfiSms_StoreType iMemStore,  long iSmsId);
extern VOID zUfiSms_InitCmdStatus(T_zUfiSms_StatusInfo *pStatusInfo,T_zUfiSms_CmdType iCmdId);
extern void zUfiSms_CmglRespProc(T_zSms_SmsInd *pSmsItem);
extern void zUfiSms_DelModemSms(int in_index);
extern void zUfiSms_ModifyModemSms(T_zUfiSms_ModifyFlag *ptModifyBuff);
extern T_zUfiSms_CmdStatus zUfiSms_SendSms(VOID);
extern int zUfiSms_SendConcatSms(int cid);
extern int zUfiSms_SetScaPara(char *sca);
extern int zUfiSms_FillConcatSms (T_zUfiSms_SendReq *pSendSrcMsg, T_zUfiSms_ConcatInfo *pDestConcatMsg);
extern int zUfiSms_CheckMemoryFull(T_zUfiSms_MemoryType mem_store);
extern int zUfiSms_IsUnreadSms(T_zUfiSms_MemoryType mem_store);
extern VOID zUfiSms_SendSmsStatusInfo(wms_message_status_info sms_op);
extern VOID BakNotificationSms(char * pushSms,int pushSmsLen);


extern SINT32 zSms_SendCmgsReq(VOID);
extern VOID zSms_RecvCmgsErr(VOID);
extern VOID zSms_RecvCmgsOk(VOID);
extern SINT32 zSms_SendCmgdReq(UINT8 index);
extern VOID zSms_RecvCmgdOk(VOID);
extern VOID zSms_RecvCmgdErr(VOID);
extern VOID zSms_RecvCmgdFinish(VOID);
extern int zSms_SendCmgrReq(UINT8 index);
extern int zSms_SendSmsInitReq(VOID);
extern int zSms_SendZmenaReq(SINT32 avail);
extern VOID atWeb_OutdateSmsCheck(UINT8 *pDatabuf);
extern int zSms_SendCnmaReq(int ack_mode);
extern int zSms_SetCscaReq(PSTR sca);
extern int zSms_SendCnmiReq(PSTR pAtCmdPara);


extern T_zUfiSms_CmdStatus zUfiSms_SendRawSms(T_zUfiSms_SendReq *ptSendMsg);
extern T_zUfiSms_CmdStatus zUfiSms_WriteRawSms(T_zUfiSms_SaveReq *pSaveBuff);
extern T_zUfiSms_CmdStatus zUfiSms_DeleteSms(T_zUfiSms_DelReq *ptDelBuff);
extern void zUfiMmi_SendSmsStatus(void);
extern T_zUfiSms_CmdStatus zUfiSms_ModifySmsTag(T_zUfiSms_ModifyFlag *ptModifyBuff);
extern T_zUfiSms_CmdStatus zUfiSms_SetSmsPara(T_zUfiSms_ParaInfo *ptParaBuff);
extern void zUfiSms_CmgsRespProc(VOID);
extern void zUfiSms_CmtRespProc(T_zSms_SmsInd *ptRespData);
extern void zUfiSms_CdsRespProc(T_zSms_SmsInd *ptRespData);
extern void zUfiSms_ZmgrRespProc(T_zSms_SmsInd *ptRespData);
extern VOID zSvr_Zpbic_Sms_Init(VOID);
extern int zte_fota_notifyPushMsg(int cmd);

/**************************************************************************
* ȫֱ
**************************************************************************/


#ifdef __cplusplus
} 
#endif

#endif  /* _SMS_FNC_H_ */

