#include "zctrm_locknet.h"
//#include "drvs_efuse.h"
#include "zctrm_ln_rsa.h"
#include "zctrm_ln_md5.h"
#include "RONvParam_AMT.h"
//#include "ps_normal.h"
//#include "ps_wifi.h"
#include <limits.h>

static BOOL g_IsDigestKeyGot = FALSE;
static BOOL g_IsSetListKeyGot = FALSE;

static BOOL g_IsSetListAuthSucc = FALSE;
static BOOL g_NeedSecondList = FALSE;
static BOOL g_IsKeyExist = FALSE;
static BOOL g_IsDigestGotSucc = FALSE;

static BOOL g_IsUnlockKeyGot = FALSE;
static UINT8 g_UnlockKeyPlaint[LOCKNET_KEY_LEN+1] = {0};

static UINT8 g_SetListPlaint[LOCKNET_KEY_LEN+1] = {0};

static T_ZDrvEfuse_Secure g_Efuse_Secure={0};

T_zCtrm_LockListPara simLockListPara = {0};
T_zCtrm_SIMPara simPara = {0};
SINT32 g_Sec_Status = ENCRYPT_INITING;
extern int sendflag;

SINT32 zCtrm_Atohex(CHAR c)
{
    SINT32 result = 0;
    
    if(c >= '0' && c <= '9')
    {
        result = c - '0';
    }
    else if(c>='a' && c<='f')
    {
        result = (c - 'a') + 10;
    }
    else if(c>='A' && c<='F')
    {
        result = (c - 'A') + 10;
    }
    else
    {
        at_print(AT_ERR,"zCtrm_Atohex error,can unknown char:%c\n",c);
        return result;
    }
    return result;
}

static SINT32 zCtrm_Strnicmp(const CHAR * cs,const CHAR * ct,UINT32 count)
{
    SINT32 res = 0;
    
    while (count) 
    {
        if ((res = toupper(*cs)- toupper(*ct++)) != 0 || !*cs++)
            break;
        count--;
    }
    
    return res;
}
VOID ConvertToBigEndian(unsigned int *data)
{
	*data = ((*data & 0xff000000) >> 24)
            | ((*data & 0x00ff0000) >>  8)
            | ((*data & 0x0000ff00) <<  8)
            | ((*data & 0x000000ff) << 24) ;
}

static UINT32 zCtrm_Bytes2String(const UINT8* pSrc, CHAR* pDst, UINT16 srcLength)
{
	const UINT8 tab[]="0123456789ABCDEF";
    int iSrc=0;

#if 1   // cov M srcLength is unsigned
    if(pSrc ==	NULL || pDst == NULL )
    {
    	return -1;
    }

#else
    if(pSrc ==  NULL || pDst == NULL || srcLength < 0)
    {
    	return -1;
    }
#endif   
    for(iSrc=0; iSrc<srcLength; iSrc++)
    {
        *pDst++ = tab[*pSrc >> 4];
        *pDst++ = tab[*pSrc & 0x0f];
        pSrc++;
    }
   
    *pDst = '\0';
   
    return srcLength * 2;
}

static UINT32 makeLocknetKeyRandom(VOID)
{
    UINT32 val = 0;
	UINT32 seed = (UINT32)time( NULL );
	int fd = open("/dev/urandom",O_RDONLY);

	if(fd >= 0)
	{
		int i = 0;
		UINT32 rand = 0;
		for(i = 0; i < 128; i++)
		{
			if(read(fd, &rand, sizeof(rand)) > 0)
			{
				if(rand > UINT_MAX-1)	// kw 3 cov M
				{
					rand = UINT_MAX;
				}		
				seed += rand;
				if(seed > UINT_MAX-1)	// kw 3 cov M
				{
					seed = UINT_MAX;
				}		
			}
		}
		close(fd);
	}
   
    srand(seed);
    val = rand() + (rand() ^ 2) + 1;
    val %= 100000000;
   	
    return val;
}

static VOID zCtrm_LocknetKeyGen(UINT8 *plainText, UINT16 len)
{
	UINT32 r1 = 0;
    UINT32 r2 = 0;
    UINT8 key[LOCKNET_KEY_LEN + 1] = {0};
       
    r1 = makeLocknetKeyRandom();
    r2 = makeLocknetKeyRandom();
    snprintf((char *)key, sizeof(key),"%08ld%08ld", r1, r2);        
    memcpy(plainText, key, len);
	at_print(AT_ERR,"zCtrm_LocknetKeyGen:plainText = %s\n",plainText); 
}

static UINT32 zCtrm_RsaPublicEncrypt(const UINT8 *plainText, UINT8 *cipherText,const char *rsa_n,const char *rsa_e)
{    
	rsa_context rsa;
	   
	rsa_init(&rsa, RSA_PKCS_V15, 0);
	   
	rsa.len = KEY_LEN;
	mpi_read_string(&rsa.N, 16, rsa_n);
	mpi_read_string(&rsa.E, 16, rsa_e);

	if(rsa_check_pubkey(&rsa) != 0)
	{
		at_print(AT_ERR,"Encode check failed\n");
	    return EXT_ERROR;
	}
	if(rsa_public(&rsa, plainText, cipherText) != 0)
	{
	    at_print(AT_ERR,"Encode check failed\n");
	    return EXT_ERROR;
	}
	rsa_free(&rsa);

	at_print(AT_ERR,"Encode passed\n");      
	return EXT_SUCCESS;
}

//efuseжȡĹԿдС˴洢ת(ΪС˴洢)
UINT32 zCtrm_RsaPublicEncryptProc(const UINT8 *plainText, UINT8 *cipherText)
{
	UINT32 retCode = EXT_ERROR;  
	unsigned int i;
	UINT32 pubKeyRsaEOrder[32]={0};
	UINT32 pubKeyRsaNOrder[32]={0};
	char pubKeyRsaEtext[KEY_LEN*2+1]={0};
	char pubKeyRsaNtext[KEY_LEN*2+1]={0};
	int efuse_fd = -1;
	int ret = -1;
	
	memset(&g_Efuse_Secure,0,sizeof(g_Efuse_Secure));
	
	efuse_fd = open("/dev/efuse", O_RDWR);
	if (efuse_fd < 0) {
		at_print(AT_ERR,"zCtrm_RsaPublicEncryptProc: efuse fd_func open fail.\n");
		return EXT_ERROR;//klocwork
	}

	ret = ioctl(efuse_fd , EFUSE_GET_DATA, &g_Efuse_Secure);
	
	at_print(AT_ERR,"[zCtrm_RsaPublicEncryptProc]: pubKeyRsaE[%x] pubKeyRsaN[%x]\n",ret,g_Efuse_Secure.pubKeyRsaE[31],g_Efuse_Secure.pubKeyRsaN[0]);
	close(efuse_fd);//klocwork
	/*if(g_Efuse_Secure.pubKeyRsaN ==NULL || g_Efuse_Secure.pubKeyRsaE ==NULL)
	{
		at_print(AT_ERR,"Rsa NULL\n");  		
		return EXT_ERROR;
	}*/
	
	memcpy(pubKeyRsaEOrder,g_Efuse_Secure.pubKeyRsaE,sizeof(g_Efuse_Secure.pubKeyRsaE));
	for(i=0;i<32;i++)
	{
	   ConvertToBigEndian(&pubKeyRsaEOrder[i]);
	}
	zCtrm_Bytes2String(pubKeyRsaEOrder, pubKeyRsaEtext, KEY_LEN);

	memcpy(pubKeyRsaNOrder,g_Efuse_Secure.pubKeyRsaN,sizeof(g_Efuse_Secure.pubKeyRsaN));
	for(i=0;i<32;i++)
	{
	   ConvertToBigEndian(&pubKeyRsaNOrder[i]);
	}
	zCtrm_Bytes2String(pubKeyRsaNOrder, pubKeyRsaNtext, KEY_LEN);
	
	at_print(AT_ERR,"zCtrm_RsaPublicEncryptProc:RsaN = %s\n",pubKeyRsaNtext);
	at_print(AT_ERR,"zCtrm_RsaPublicEncryptProc:RsaE = %s\n",pubKeyRsaEtext);
	
	return zCtrm_RsaPublicEncrypt(plainText,cipherText,pubKeyRsaNtext,pubKeyRsaEtext);
}

static BOOL zCtrm_IsParaNum(UINT8 *data, UINT16 dataLen)
{
	UINT16 idata = 0;

	if(*data == '\0')
	{
	   return TRUE;
	}

	for(idata = 0; idata < dataLen; idata++)
	{
	   if(*data < '0' || *data > '9')
	   {
	       at_print(AT_ERR,"zCtrm_IsParaNum error:%c!\n",*data);
	       return FALSE;
	   }
	   data++;
	}
	return TRUE;
}

static UINT32 zCtrm_CheckListPara(UINT8 *data, UINT16 dataLen)
{
	UINT8 *pBegin = data;
	UINT8 *pEnd = NULL;
	UINT16 subLen = 0;
	UINT16 iPara = 0;

	for(iPara = 0; iPara < LOCKNET_ITEM_NUM; iPara++)
	{        
	   if(iPara < LOCKNET_ITEM_NUM - 1)
	   {
	       pEnd = strchr(pBegin,',');
		   if (pEnd == NULL)//klocwork
			   return EXT_ERROR;
	       subLen = pEnd - pBegin;
	   }
	   else
	   {
	       subLen = dataLen - (pBegin - data);
	   }
	  
	   switch(iPara)
	   {
	       case PARA_MCC:
	       case PARA_MNC:
	       {
	           if(subLen > 3 || FALSE == zCtrm_IsParaNum(pBegin,subLen))
	           {
	               return EXT_ERROR;
	           }
	           break;
	       }
	       case PARA_IMSI6:
	       case PARA_IMSI7:
	       {
	           if(subLen > 1 || FALSE == zCtrm_IsParaNum(pBegin,subLen))
	           {
	               return EXT_ERROR;
	           }
	           break;
	       }
	       case PARA_GID1:
	       case PARA_GID2:
	       {
	           if(subLen > USED_GID_LEN) //one at, need opt
	           {
	               return EXT_ERROR;
	           }
	           break;
	       }            
	       default:
	       {
	           return EXT_ERROR;
	       }
	   }
	   
	   pBegin = pEnd + 1;                         
	}

	return EXT_SUCCESS;
}

static UINT32 zCtrm_CheckListNum(UINT8 *data, UINT16 dataLen, UINT16 *listnum)
{
	UINT8 *pBegin = NULL;
	UINT8 *pEnd = NULL;
	UINT16 iData = 0;
	UINT16 count = 0;
	UINT16 maxNum = LOCKNET_FIRST_NUM;

	pBegin=data;
	for(iData = 0; iData < dataLen; iData++)
	{
	   if(*pBegin == ';')
	   {
	       count++;
	   }
	   pBegin++;
	}
	   
	if(g_NeedSecondList == TRUE)
	{
	   maxNum = LOCKNET_MAX_NUM - LOCKNET_FIRST_NUM;
	}

	if(count < 1 || count > maxNum)
	{
	   return EXT_ERROR;
	}

	pEnd=strrchr(data,';');
	if (pEnd == NULL)//klocwork
		return EXT_ERROR;
	if(('\0' == *(char *)(pEnd+1))||(0 == strncmp(pEnd+1,"next",strlen("next")) && count == LOCKNET_FIRST_NUM) )
	{
	   *listnum = count;
	   at_print(AT_ERR,"zCtrm_CheckListNum pEnd:--%s--\n",pEnd);
	   return EXT_SUCCESS;
	}

	at_print(AT_ERR,"zCtrm_CheckListNum err:--%s--\n",pEnd);
	return EXT_ERROR;

}

static VOID zCtrm_GetListPara(UINT8 *data, UINT16 dataLen, T_zCtrm_LockListPara *para)
{
	UINT8 *pBegin = data;
	UINT8 *pEnd = NULL;
	UINT16 subLen = 0;
	UINT16 iPara = 0;

	for(iPara = 0; iPara < LOCKNET_ITEM_NUM; iPara++)
	{        
		if(iPara < LOCKNET_ITEM_NUM -1)
		{
		   pEnd = strchr(pBegin,',');
		   if (pEnd == NULL)//klocwork
				return;
		   subLen = pEnd - pBegin;
		}
		else
		{
		   subLen = dataLen - (pBegin - data);
		}

		switch(iPara)
		{
			case PARA_MCC:
			{
				if (subLen < sizeof(para->mcc)) {//klocwork
					memset(para->mcc,0,sizeof(para->mcc));
					snprintf(para->mcc,subLen+1,"%s",pBegin);
					//strncpy(para->mcc,pBegin,subLen);  
				}
				break;
			}
			case PARA_MNC:
			{
				if (subLen < sizeof(para->mnc)) {
					memset(para->mnc,0,sizeof(para->mnc));
					snprintf(para->mnc,subLen+1,"%s",pBegin);
					//strncpy(para->mnc,pBegin,subLen);  
				}
				break;
			}
			case PARA_IMSI6:
			{
				if (subLen < sizeof(para->imsi6)) {
					memset(para->imsi6,0,sizeof(para->imsi6));
					snprintf(para->imsi6,subLen+1,"%s",pBegin);
					//strncpy(para->imsi6,pBegin,subLen);  
				}
				break;
			}
			case PARA_IMSI7:
			{
				if (subLen < sizeof(para->imsi7)) {
					memset(para->imsi7,0,sizeof(para->imsi7));
					snprintf(para->imsi7,subLen+1,"%s",pBegin);
					//strncpy(para->imsi7,pBegin,subLen);
				}
				break;
			}
			case PARA_GID1:
			{
				if (subLen < sizeof(para->gid1)) {
					memset(para->gid1,0,sizeof(para->gid1));
					snprintf(para->gid1,subLen+1,"%s",pBegin);
					//strncpy(para->gid1,pBegin,subLen); 
				}
				break;
			}
			case PARA_GID2:
			{
				if (subLen < sizeof(para->gid2)) {
					memset(para->gid2,0,sizeof(para->gid2));
					snprintf(para->gid2,subLen+1,"%s",pBegin);
					//strncpy(para->gid2,pBegin,subLen);  
				}
				break;
			}            
			default:
			{
				break;
			}
		}

		pBegin = pEnd + 1;                         
	}

}

static UINT32 zCtrm_CleanAmtList(VOID)
{
	UINT32	retCode = EXT_ERROR;
	UINT16 iList = 0;
	T_zCtrm_LockListPara lockList = {0};
	  
	memset((UINT8 *)&lockList,0xFF,sizeof(lockList));
	for(iList = 0; iList < LOCKNET_MAX_NUM; iList++)
	{  
	   
	   
	   cpnv_ChangeNvRoAttr(1);
	   //retCode = zDrvNand_Program(AMT_LOCKNET_LIST + iList*sizeof(lockList), sizeof(lockList), (UINT8 *)&lockList);
	   retCode = cpnv_NvItemWriteNvro(AMT_LOCKNET_LIST + iList*sizeof(lockList), (UINT8 *)&lockList, sizeof(lockList));
	   cpnv_FsGcWait(FS_NVROFS);
	   cpnv_ChangeNvRoAttr(0);
	   if (EXT_SUCCESS != retCode )
	   {   
	       return EXT_ERROR;
	   }
	   
	}
	return EXT_SUCCESS;
}

static UINT32 zCtrm_WriteLocklist(UINT8 *data, UINT16 dataLen)
{
	UINT8 *pBegin = data;
	UINT8 *pEnd = NULL;
	UINT8 tStr[LOCKNET_MAX_AT_LEN] = {0};
	UINT16 listCount = 0;
	UINT16 iList = 0;
	UINT16 offset = 0;
	UINT32	retCode = EXT_ERROR;

	if(EXT_SUCCESS != zCtrm_CheckListNum(data, dataLen, &listCount))
	{        
	   return EXT_ERROR;
	}
	at_print(AT_ERR,"zCtrm_WriteLocklist listcount:%d!\n",listCount);

	if(g_NeedSecondList == TRUE)
	{
	   offset = LOCKNET_FIRST_NUM;
	}
	else
	{
	   if(zCtrm_CleanAmtList() != EXT_SUCCESS)
	   {
	       return EXT_ERROR;
	   }
	}

	for(iList = 0; iList < listCount; iList++)
	{  
	   T_zCtrm_LockListPara lockList = {0};
	   unsigned int slen = 0;//klocwork
	   
	   pEnd=strchr(pBegin,';');
	   if (pEnd == NULL)//klocwork
		   return EXT_ERROR;
	   slen = pEnd-pBegin;
	   if(slen < sizeof(tStr)) {
		   memset(tStr,0,sizeof(tStr));
		   snprintf(tStr,slen+1,"%s",pBegin);
		   //strncpy(tStr,pBegin,slen); 
	   } else {        
	       return EXT_ERROR;
	   }
	    
	   zCtrm_GetListPara(tStr,slen,&lockList);      
	   	   
	   cpnv_ChangeNvRoAttr(1);
	   //retCode = zDrvNand_Program(AMT_LOCKNET_LIST + (offset + iList)*sizeof(lockList), sizeof(lockList), (UINT8 *)&lockList);
	   retCode = cpnv_NvItemWriteNvro(AMT_LOCKNET_LIST + (offset + iList)*sizeof(lockList), (UINT8 *)&lockList, sizeof(lockList));
	   cpnv_FsGcWait(FS_NVROFS);
	   cpnv_ChangeNvRoAttr(0);
	   if (EXT_SUCCESS != retCode )
	   {   
	       return EXT_ERROR;
	   } 
	   
	   pBegin = pEnd + 1;                  
	}

	return EXT_SUCCESS;
}

static UINT32 zCtrm_GetUnlockMaxTime(VOID)
{   
	UINT32 retCode = EXT_ERROR;   
	UINT32 timet = 0;
	char time[AT_STR_LEN] = {0};
	//timet = atoi(cfg_get("zunlocktimes"));
	sc_cfg_get("zunlocktimes", time, sizeof(time));
	timet = atoi(time);
	at_print(AT_ERR,"zCtrm_GetUnlockMaxTime:%d---\n" ,timet);    

	return timet;
}

static UINT32 zCtrm_LocknetNandSet(UINT8 *plainText, UINT16 len)
{
	T_zCtrm_LockLevel lockState = LOCKED;
	UINT32 times = zCtrm_GetUnlockMaxTime();
	UINT32 retCode = EXT_ERROR;

	cpnv_ChangeNvRoAttr(1);

	//retCode = zDrvNand_Program(AMT_LOCKNET_TIMES, sizeof(times),(UINT8 *)&times);
	retCode = cpnv_NvItemWriteNvro(AMT_LOCKNET_TIMES, (UINT8 *)&times, sizeof(times));
	if (EXT_SUCCESS != retCode)
	{  
	   cpnv_ChangeNvRoAttr(0);   
	   return EXT_ERROR;
	}

	//retCode = zDrvNand_Program(AMT_LOCKNET_KEY, len, plainText);
	retCode = cpnv_NvItemWriteNvro(AMT_LOCKNET_KEY, plainText, len);
	if (EXT_SUCCESS != retCode)
	{  
	   cpnv_ChangeNvRoAttr(0);   
	   return EXT_ERROR;
	}

	//retCode = zDrvNand_Program(AMT_LOCKNET_BASE, sizeof(lockState),(UINT8 *)&lockState);
	retCode = cpnv_NvItemWriteNvro(AMT_LOCKNET_BASE, (UINT8 *)&lockState, sizeof(lockState));
	if (EXT_SUCCESS != retCode)
	{   
	   cpnv_ChangeNvRoAttr(0);   
	   return EXT_ERROR;
	}
	cpnv_FsGcWait(FS_NVROFS);
	cpnv_ChangeNvRoAttr(0);    
	return EXT_SUCCESS;
}

static UINT32 zCtrm_LocknetStaticCheck(VOID)
{
	T_zCtrm_LockLevel  lockState = LOCKFLAG_ERROR;
	UINT32	retCode = EXT_ERROR;

	//retCode = zDrvNand_Read(AMT_LOCKNET_BASE,sizeof(lockState),(UINT8 *)&lockState); //len=4
	retCode = cpnv_NvItemRead(AMT_LOCKNET_BASE, (UINT8 *)&lockState, sizeof(lockState));
	at_print(AT_ERR,"zCtrm_LocknetStaticCheck ret=%d lockstat=%d\n",retCode,lockState);
	if (EXT_SUCCESS == retCode)
	{
	   if(lockState == NEVER_LOCKED)
	   {
	       return EXT_SUCCESS;
	   }
	}

	return EXT_ERROR;
}

static UINT32 zCtrm_LocknetListCheck(VOID)
{
	T_zCtrm_LockListPara lockList = {0};
	UINT32	retCode = EXT_ERROR;

	//retCode = zDrvNand_Read(AMT_LOCKNET_LIST, sizeof(lockList), (UINT8 *)&lockList); 
	retCode = cpnv_NvItemRead(AMT_LOCKNET_LIST, (UINT8 *)&lockList, sizeof(lockList));
	if (EXT_SUCCESS != retCode )
	{       
	   return EXT_ERROR;        
	}
	   
	if((lockList.mcc[0] == 0xFF)||(lockList.imsi6[0] == 0xFF)||(lockList.gid1[0] == 0xFF))
	{
	   at_print(AT_ERR,"zCtrm_LocknetListCheck FF\n");
	   return EXT_ERROR;
	}

	return EXT_SUCCESS;
}

static UINT32 zCtrm_CheckLocklist(UINT8 *data, UINT16 dataLen)
{
	UINT8 *pBegin = data;
	UINT8 *pEnd = NULL;
	UINT16 iItem = 0;
	UINT8 *pPara = NULL;
	UINT16 listCount = 0;
	UINT16 paraCount = 0;

	if(EXT_SUCCESS != zCtrm_CheckListNum(data, dataLen, &listCount))
	{        
	   return EXT_ERROR;
	}
	at_print(AT_ERR,"zCtrm_CheckLocklist listCount = %d\n",listCount); 

	for(iItem = 0; iItem < listCount; iItem++)
	{        
		pEnd = strchr(pBegin,';');
		if (pEnd == NULL)//klocwork
			return EXT_ERROR;
	    paraCount = 0; 
	    for(pPara = pBegin; pPara < pEnd; pPara++)
	    {
			if(!((*pPara == ',')||(*pPara>='0'&&*pPara<='9')||(*pPara>='a'&&*pPara<='f')||(*pPara>='A'&&*pPara<='F')))
	        {
	  	    	at_print(AT_ERR,"zCtrm_CheckLocklist error:%c!\n",*pPara); 
	 			return EXT_ERROR;
	        }
	       
	        if(*pPara == ',')
	        {
	            paraCount++;
	        }
	   }
	   
	   if(paraCount == LOCKNET_ITEM_NUM - 1)
	   {   
	       if(EXT_SUCCESS != zCtrm_CheckListPara(pBegin, pEnd - pBegin))
	       {
	             return EXT_ERROR;
	       }
	       pBegin = pEnd + 1;           
	   }
	   else
	   {
	 		at_print(AT_ERR,"zCtrm_CheckLocklist count:%d!\n",paraCount); 
	        return EXT_ERROR;
	   }    
	   
	}
	at_print(AT_ERR,"zCtrm_CheckLocklist succ!\n");
	return EXT_SUCCESS;
}

static UINT32 zCtrm_LocknetDigestMD5Hash(char *psDest)
{
	md5_ctx stStc;
	UINT32 retCode = EXT_ERROR;
	char TmpImei[ZPS_ImeiLen]={0};//imeiֵ
	UINT16 iList = 0;
	char lockList[LIST_LEN] = {0};
	UINT8 plainText[KEY_LEN] = {0};
	UINT8 sTempBuf[16];
	unsigned int i;

	char PTmpImei[ZPS_ImeiLen*2+1]={0};
	char PlockList[LIST_LEN*2+1]={0};
	char PplainText[KEY_LEN*2+1]={0};

	md5_init(&stStc);
	 
	//retCode = zPS_NvAMTItemRead(ABIMEI_NVPARAM, (unsigned char *)TmpImei, ZPS_ImeiLen);
	retCode = cpnv_NvItemRead(OS_FLASH_AMT_COMM_RO_IMEI_ADDRESS, (unsigned char *)TmpImei, OS_FLASH_AMT_COMM_RO_IMEI_SIZE);

	if (CPNV_ERROR == retCode)
	{
		return EXT_ERROR;
	}
	zCtrm_Bytes2String(TmpImei, PTmpImei, ZPS_ImeiLen);
	at_print(AT_ERR,"zCtrm_LocknetDigestMD5Hash TmpImei=%s!\n",PTmpImei);
	md5_update(&stStc, (unsigned char *)TmpImei, ZPS_ImeiLen);


	//
	for(iList = 0; iList < LOCKNET_MAX_NUM; iList++)  
	{          
		//retCode = zDrvNand_Read(AMT_LOCKNET_LIST + iList*sizeof(lockList), sizeof(lockList), (UINT8 *)lockList);  
		retCode = cpnv_NvItemRead(AMT_LOCKNET_LIST + iList*sizeof(lockList), (UINT8 *)lockList, sizeof(lockList));
		if (EXT_SUCCESS != retCode )
		{   
	  		return EXT_ERROR;
		}
	  	zCtrm_Bytes2String(lockList, PlockList, LIST_LEN);
	  	at_print(AT_ERR,"zCtrm_LocknetDigestMD5Hash lockList=%s!\n",PlockList);
	  	md5_update(&stStc, (unsigned char *)lockList, LIST_LEN);
	}

	//
	//retCode = zDrvNand_Read(AMT_LOCKNET_KEY, sizeof(plainText), plainText);
	retCode = cpnv_NvItemRead(AMT_LOCKNET_KEY, plainText, sizeof(plainText));
	if (EXT_SUCCESS != retCode)
	{   
		return EXT_ERROR;
	}
	zCtrm_Bytes2String(plainText, PplainText, KEY_LEN);
	at_print(AT_ERR,"zCtrm_LocknetDigestMD5Hash plainText=%s!\n",PplainText);
	md5_update(&stStc, (unsigned char *)plainText, KEY_LEN);

	md5_final(sTempBuf, &stStc);
	for(i = 0; i < 16; i++)
	{
		snprintf(psDest + 2*i, 3, "%02x", sTempBuf[i]);
	}
	return EXT_SUCCESS;
}

static UINT32 zCtrm_String2Bytes(const CHAR* pSrc, UINT8* pDst, UINT16 srcLength)
{
	int i=0;

	//У
#if 1  // cov M srcLength is unsigned
	if(pSrc ==  NULL || pDst == NULL)
	{
	   return -1;
	}
#else
    if(pSrc ==	NULL || pDst == NULL || srcLength < 0)
    {
       return -1;
    }

#endif

	for(i = 0; i < srcLength; i += 2)
	{
	   // 4λ
	   if(*pSrc >= '0' && *pSrc <= '9')
	   {
	       *pDst = (*pSrc - '0') << 4;
	   }
	   else
	   {
	       *pDst = ((toupper(*pSrc) - 'A') + 10) << 4;
	   }

	   pSrc++;

	   // 4λ
	   if(*pSrc >= '0' && *pSrc <= '9')
	   {
	       *pDst |= *pSrc - '0';
	   }
	   else
	   {
	       *pDst |= (toupper(*pSrc) - 'A') + 10;
	   }

	   pSrc++;
	   pDst++;
	}

	// Ŀݳ
	return srcLength / 2;
}

int zCtrm_LocknetAuthList(char *at_paras)
{
	UINT8 *pBegin = NULL;
    UINT8 *pEnd = NULL;
    UINT16 keyLen = 0;
    UINT8 keyBuf[LOCKNET_KEY_LEN+1] = {0}; 
	UINT8 *pStrAt = NULL; 
	CHAR at_str[AT_STR_LEN] = {0};
	
	pStrAt = strstr(at_paras,"a,");
	if(pStrAt != NULL)
	{
		if (g_IsSetListKeyGot != TRUE)
		{
			at_print(AT_ERR,"zCtrm_LocknetAuthList:KeyGot false\n");
			snprintf(at_str,AT_STR_LEN,"\r\n+CME ERROR\r\n");
			goto end;
		}
		pEnd = at_paras+strlen(at_paras);

		pBegin = pStrAt + strlen("a,");
        keyLen = pEnd - pBegin;
        if (keyLen != LOCKNET_KEY_LEN)
		{
			snprintf(at_str,AT_STR_LEN,"\r\n+CME ERROR\r\n");
			goto end;
		}
		memcpy(keyBuf,pBegin,keyLen);
        if(memcmp(keyBuf,g_SetListPlaint,keyLen) != 0)	
		{
			at_print(AT_ERR,"zCtrm_LocknetAuthList:Key error\n");
			snprintf(at_str,AT_STR_LEN,"\r\n+CME ERROR\r\n");
			goto end;
		}
		snprintf(at_str,AT_STR_LEN,"\r\nOK\r\n");
		g_IsSetListKeyGot = FALSE;
        g_IsSetListAuthSucc = TRUE;
		goto end;
	}
	else 
	{
		snprintf(at_str,AT_STR_LEN,"\r\n+CME ERROR\r\n");
		goto end;
	}
end:
	send_rsp_str_to_farps(MODULE_ID_LOCKNET, at_str, strlen(at_str));
	return 0;	
}

int zCtrm_LocknetAuthGen()
{
	UINT32 retCode = EXT_ERROR;
	UINT8 plainText[LOCKNET_KEY_LEN+1] = {0};
    UINT8 plainText128[KEY_LEN] = {0};
    UINT8 cipherText[KEY_LEN] = {0};
   	CHAR cipherHex[KEY_LEN*2+1] = {0};
	CHAR at_str[AT_STR_LEN+KEY_LEN*2] = {0};  
	
	if (g_IsSetListKeyGot != FALSE)
	{
		snprintf(at_str,AT_STR_LEN,"\r\n+CME ERROR:Already authorized\r\n");
		goto end;
	}
	zCtrm_LocknetKeyGen(plainText, LOCKNET_KEY_LEN);
	memcpy(plainText128+KEY_LEN-LOCKNET_KEY_LEN, plainText, LOCKNET_KEY_LEN);
	retCode = zCtrm_RsaPublicEncryptProc(plainText128, cipherText);
    if (EXT_SUCCESS != retCode )
    {   
        snprintf(at_str,AT_STR_LEN,"\r\n+CME ERROR\r\n");
		goto end;
    }
	zCtrm_Bytes2String(cipherText, cipherHex, KEY_LEN);                

    memset(g_SetListPlaint,0,sizeof(g_SetListPlaint));
    memcpy(g_SetListPlaint,plainText,sizeof(g_SetListPlaint)-1);
	snprintf(at_str,AT_STR_LEN+KEY_LEN*2,"\r\n+LOCKLISTAUTH: %s\r\nOK\r\n",cipherHex);
	g_IsSetListKeyGot = TRUE;
	goto end;
end:
	send_rsp_str_to_farps(MODULE_ID_LOCKNET, at_str, strlen(at_str));
	return 0;
}

int zCtrm_LocknetAuthProc(MSG_BUF *msg)
{	
	char at_str[AT_STR_LEN] = {0};
	
	at_print(AT_ERR,"zCtrm_LocknetAuthProc\n");
	if('g' == (char*)msg->aucDataBuf[0])
	{
		zCtrm_LocknetAuthGen();
	}
	else if('a' == (char*)msg->aucDataBuf[0])
	{
		zCtrm_LocknetAuthList((char*)msg->aucDataBuf);
	}
	else 
	{
		at_print(AT_ERR,"zCtrm_LocknetAuthProc:param error!!!\n");
		goto error;
	}
	return 0;
error:
	snprintf(at_str,AT_STR_LEN,"\r\n+CME ERROR\r\n");
	send_rsp_str_to_farps(MODULE_ID_LOCKNET, at_str, strlen(at_str));
	return 0;

}

int zCtrm_LocknetListSet(MSG_BUF *msg)
{
	UINT32 retCode = EXT_ERROR;
    UINT16 dataLen = 0;
	CHAR at_str[AT_STR_LEN] = {0};
	char *at_paras = NULL; // cov M  PW.BRANCH_PAST_INITIALIZATION
	
	if (g_IsSetListAuthSucc != TRUE)
    {   
		snprintf(at_str,AT_STR_LEN,"\r\n+CME ERROR:unauthorized\r\n");
		goto end;
    }
	at_paras = (char*)msg->aucDataBuf;
	dataLen = strlen(at_paras);
	at_print(AT_ERR,"dataLen = %d\n",dataLen); 
	retCode = zCtrm_CheckLocklist((char*)msg->aucDataBuf, dataLen);
	if (EXT_SUCCESS != retCode )
	{   
		snprintf(at_str,AT_STR_LEN,"\r\n+CME ERROR:invalid parameter\r\n");
		goto end;
    }
	retCode = zCtrm_WriteLocklist(at_paras, dataLen);
	if (EXT_SUCCESS != retCode )
	{   
		snprintf(at_str,AT_STR_LEN,"\r\n+CME ERROR:flash failed\r\n");
		goto end;
    }
	if(NULL != strstr(at_paras,"next"))
    {
		g_NeedSecondList = TRUE;
    } 
    else
    {
    	g_NeedSecondList = FALSE;
    }
	snprintf(at_str,AT_STR_LEN,"\r\nOK\r\n");
	goto end;
end:
	send_rsp_str_to_farps(MODULE_ID_LOCKNET, at_str, strlen(at_str));
	return 0;
}

int zCtrm_LocknetKeyGenerate()
{
	UINT32 retCode = EXT_ERROR;    
    UINT8 plainText[LOCKNET_KEY_LEN+1] = {0};
    UINT8 plainText128[KEY_LEN] = {0};
    UINT8 cipherText[KEY_LEN] = {0};
	CHAR at_str[AT_STR_LEN] = {0};
	//need open
	retCode = zCtrm_LocknetStaticCheck();
    if (EXT_SUCCESS != retCode )
    {   
		snprintf(at_str,AT_STR_LEN,"\r\n+CME ERROR:locknet already exists\r\n");
		goto end;
    }
      
    retCode = zCtrm_LocknetListCheck();
    if (EXT_SUCCESS != retCode )
    {   
		snprintf(at_str,AT_STR_LEN,"\r\n+CME ERROR:missing locknet file\r\n");
		goto end;
    }
 	zCtrm_LocknetKeyGen(plainText, LOCKNET_KEY_LEN);
    at_print(AT_ERR,"zCtrm_ExtLocknetKeyGenerate plainText=%s!\n",plainText);
    memcpy(plainText128+KEY_LEN-LOCKNET_KEY_LEN, plainText, LOCKNET_KEY_LEN);
    retCode = zCtrm_RsaPublicEncryptProc(plainText128, cipherText);
    if (EXT_SUCCESS != retCode )
    {   
       	snprintf(at_str,AT_STR_LEN,"\r\n+CME ERROR:Encrypt error\r\n");
		goto end;
    }
    retCode = zCtrm_LocknetNandSet(cipherText, sizeof(cipherText));
    if (EXT_SUCCESS != retCode )
    {   
    	snprintf(at_str,AT_STR_LEN,"\r\n+CME ERROR:invalid command\r\n");
		goto end;
    }
    snprintf(at_str,AT_STR_LEN,"\r\nOK\r\n");
	g_IsKeyExist = TRUE;
    goto end;
end:
	send_rsp_str_to_farps(MODULE_ID_LOCKNET, at_str, strlen(at_str));
	return 0;
}

int zCtrm_LocknetDelRand()
{
	UINT32 retCode = EXT_ERROR;    
	UINT8 pPtr[KEY_LEN*2+64] = {0};    
	UINT8 plainText[LOCKNET_KEY_LEN+1] = {0};
	UINT8 plainText128[KEY_LEN] = {0};
	UINT8 cipherText[KEY_LEN] = {0};
	CHAR cipherHex[KEY_LEN*2+1] = {0};
	CHAR at_str[AT_STR_LEN+KEY_LEN*2] = {0};
	
	if (g_IsUnlockKeyGot != FALSE)
	{   
		snprintf(at_str,AT_STR_LEN,"\r\n+CME ERROR:Already authorized\r\n");
		goto end;
	}

	zCtrm_LocknetKeyGen(plainText, LOCKNET_KEY_LEN);
	memcpy(plainText128+KEY_LEN-LOCKNET_KEY_LEN, plainText, LOCKNET_KEY_LEN);
	retCode = zCtrm_RsaPublicEncryptProc(plainText128, cipherText);
	if (EXT_SUCCESS != retCode )
	{   
		 snprintf(at_str,AT_STR_LEN,"\r\n+CME ERROR\r\n");
		 goto end;
	}
	   
	zCtrm_Bytes2String(cipherText, cipherHex, KEY_LEN);               

	memset(g_UnlockKeyPlaint,0,sizeof(g_UnlockKeyPlaint));
	memcpy(g_UnlockKeyPlaint,plainText,sizeof(g_UnlockKeyPlaint)-1);

	snprintf(at_str,AT_STR_LEN+KEY_LEN*2,"\r\n+UNLOCKKEY:%s\r\nOK\r\n",cipherHex);
	g_IsUnlockKeyGot = TRUE;
	goto end;
end:
	send_rsp_str_to_farps(MODULE_ID_LOCKNET, at_str, strlen(at_str));
	return 0;

}

static UINT32 zCtrm_LocknetNandDel(VOID)
{
	T_zCtrm_LockLevel lockState = NEVER_LOCKED;
	UINT8 keyBuf[KEY_LEN] = {0};  
	UINT32 retCode = EXT_ERROR;

	cpnv_ChangeNvRoAttr(1);
	memset(keyBuf,0xFF,sizeof(keyBuf));
	//retCode = zDrvNand_Program(AMT_LOCKNET_KEY, sizeof(keyBuf), keyBuf);
	retCode = cpnv_NvItemWriteNvro(AMT_LOCKNET_KEY, keyBuf, sizeof(keyBuf));
	if (EXT_SUCCESS != retCode)
	{  
	   cpnv_ChangeNvRoAttr(0);   
	   return EXT_ERROR;
	}

	//retCode = zDrvNand_Program(AMT_LOCKNET_BASE, sizeof(lockState),(UINT8 *)&lockState);
	retCode = cpnv_NvItemWriteNvro(AMT_LOCKNET_BASE, (UINT8 *)&lockState, sizeof(lockState));
	if (EXT_SUCCESS != retCode)
	{   
	   cpnv_ChangeNvRoAttr(0);   
	   return EXT_ERROR;
	}
	cpnv_FsGcWait(FS_NVROFS);
	cpnv_ChangeNvRoAttr(0);    
	return EXT_SUCCESS;
}

int zCtrm_LocknetKeyDelete(char *at_paras)
{
	UINT32 retCode = EXT_ERROR;    
	UINT8 *pBegin = NULL;
	UINT8 *pEnd = NULL;
	UINT16 keyLen = 0;
	UINT8 keyBuf[LOCKNET_KEY_LEN+1] = {0};  
	UINT8 *pStrAt = NULL;
	CHAR at_str[AT_STR_LEN] = {0};
	
	if (g_IsUnlockKeyGot != TRUE)
	{   
		 snprintf(at_str,AT_STR_LEN,"\r\n+CME ERROR\r\n");
		 goto end;
	}
	pEnd = at_paras+strlen(at_paras);
	pBegin = at_paras + strlen("d,");
	keyLen = pEnd - pBegin;
	if (keyLen != LOCKNET_KEY_LEN)
	{   
		snprintf(at_str,AT_STR_LEN,"\r\n+CME ERROR\r\n");
		goto end;
	}
	memcpy(keyBuf,pBegin,keyLen);
	if(memcmp(keyBuf,g_UnlockKeyPlaint,keyLen) != 0)
	{   
		snprintf(at_str,AT_STR_LEN,"\r\n+CME ERROR\r\n");
		goto end;
	}   
	retCode = zCtrm_LocknetNandDel();
	if (EXT_SUCCESS != retCode )
	{   
		snprintf(at_str,AT_STR_LEN,"\r\n+CME ERROR\r\n");
		goto end;
	}
	   
	snprintf(at_str,AT_STR_LEN,"\r\nOK\r\n"); 
	g_IsUnlockKeyGot = FALSE;
	goto end;
end:
	send_rsp_str_to_farps(MODULE_ID_LOCKNET, at_str, strlen(at_str));
	return 0;
}

int zCtrm_LocknetKeyProc(MSG_BUF *msg)
{
	UINT32 retCode = EXT_ERROR;    
    //UINT8 plainText[LOCKNET_KEY_LEN+1] = {0};
    UINT8 plainText128[KEY_LEN] = {0};
    UINT8 cipherText[KEY_LEN] = {0};
	
	char *at_paras = (char*)msg->aucDataBuf;
	if('g' == at_paras[0])
	{
       	zCtrm_LocknetKeyGenerate();
    }
	if('c' == at_paras[0])
	{
		zCtrm_LocknetDelRand();
	}
	if('d' == at_paras[0])
	{
		zCtrm_LocknetKeyDelete(at_paras);
	}
	return 0;
}

int zCtrm_LocknetAmtStatus(MSG_BUF *msg)
{
	UINT32 retCode = EXT_ERROR;    
	UINT8 cipherText[KEY_LEN] = {0};
	CHAR cipherHex[KEY_LEN*2+1] = {0};
	UINT8 keyBuf[KEY_LEN] = {0};  
	CHAR at_str[AT_STR_LEN+KEY_LEN*2] = {0};
	
	//retCode = zDrvNand_Read(AMT_LOCKNET_KEY, sizeof(keyBuf), keyBuf);
	retCode = cpnv_NvItemRead(AMT_LOCKNET_KEY, keyBuf, sizeof(keyBuf));
	if (EXT_SUCCESS != retCode || keyBuf[0] == 0xFF)
	{   
		snprintf(at_str,AT_STR_LEN,"\r\n+CME ERROR:locknet not found\r\n");
		goto end;
	}
	if(g_IsKeyExist != TRUE)
	{   
	    snprintf(at_str,AT_STR_LEN,"\r\n+CME ERROR:illegal command\r\n");
		goto end;
	} 

	if (g_IsDigestGotSucc != TRUE)
	{   
		snprintf(at_str,AT_STR_LEN,"\r\n+CME ERROR:undigest\r\n");
		goto end;
	}
	memcpy(cipherText, keyBuf, sizeof(keyBuf));
	zCtrm_Bytes2String(cipherText, cipherHex, KEY_LEN);
	   
	snprintf(at_str,AT_STR_LEN+KEY_LEN*2,"\r\n+UNLOCKKEY:%s\r\nOK\r\n",cipherHex);
	g_IsKeyExist = FALSE;
	goto end;
end:
	send_rsp_str_to_farps(MODULE_ID_LOCKNET, at_str, strlen(at_str));
	return 0;
}

/*
*ȡժҪϢ
*豸IDEFMD5ժҪϢ
*/
int zCtrm_LocknetDigestGet(MSG_BUF *msg)
{
	char psDest[LOCKNET_KEY_LEN*2+1] = {0};
	UINT8 pPtr[MAX_AMT_AT_LEN] = {0};
	UINT32 retCode = EXT_ERROR;
	CHAR at_str[AT_STR_LEN+LOCKNET_KEY_LEN*2] = {0};
	
	if (g_IsDigestKeyGot != FALSE)
	{   
		snprintf(at_str,AT_STR_LEN,"\r\n+CME ERROR:Already Digestget\r\n");
		goto end;
	}

	if(g_IsKeyExist != TRUE)
	{   
		snprintf(at_str,AT_STR_LEN,"\r\n+CME ERROR:illegal command\r\n");
		goto end;
	}
	retCode=zCtrm_LocknetDigestMD5Hash(psDest);
	if(retCode==EXT_ERROR)
	{   
		 snprintf(at_str,AT_STR_LEN,"\r\n+CME ERROR\r\n");
		 goto end;
	}
	snprintf(at_str,AT_STR_LEN+LOCKNET_KEY_LEN*2,"\r\n+LOCKDIGEST: %s\r\nOK\r\n",psDest);
	g_IsDigestKeyGot = TRUE;
	goto end;
end:
	send_rsp_str_to_farps(MODULE_ID_LOCKNET, at_str, strlen(at_str));
	return 0;

}

int zCtrm_LocknetSignSet(MSG_BUF *msg)
{
	UINT32 retCode = EXT_ERROR;    
	UINT8 *pBegin = NULL;
	UINT8 *pEnd = NULL;
	UINT16 keyLen = 0;
	CHAR keyText[KEY_LEN*2+1]={0};
	UINT8 keyHex[KEY_LEN] = {0};  
	CHAR at_str[AT_STR_LEN] = {0};

	char *at_paras = NULL;// cov M  PW.BRANCH_PAST_INITIALIZATION
	
	if (g_IsDigestKeyGot != TRUE)
	{   
		snprintf(at_str,AT_STR_LEN,"\r\n+CME ERROR:NO Digestget\r\n");
		goto end;
	}
	at_paras = (char*)msg->aucDataBuf;
	pEnd = at_paras+strlen(at_paras);

	pBegin = at_paras;
	keyLen = pEnd - pBegin;
	if (keyLen != KEY_LEN*2)
	{   
		 snprintf(at_str,AT_STR_LEN,"\r\n+CME ERROR\r\n");
		 goto end;
	}
	memcpy(keyText,pBegin,keyLen);
	   //ַתɶȥ
	zCtrm_String2Bytes(keyText, keyHex, keyLen);
	cpnv_ChangeNvRoAttr(1);
	//retCode = zDrvNand_Program(AMT_LOCKNET_SIGN, KEY_LEN, keyHex);
	retCode = cpnv_NvItemWriteNvro(AMT_LOCKNET_SIGN, keyHex, KEY_LEN);
	if (EXT_SUCCESS != retCode)
	{   
		snprintf(at_str,AT_STR_LEN,"\r\n+CME ERROR\r\n");
		cpnv_ChangeNvRoAttr(0);
		goto end;
	}   
	cpnv_FsGcWait(FS_NVROFS);
	cpnv_ChangeNvRoAttr(0);
	snprintf(at_str,AT_STR_LEN,"\r\nOK\r\n");
	g_IsDigestKeyGot = FALSE;
	g_IsDigestGotSucc = TRUE;
	goto end;
end:
	send_rsp_str_to_farps(MODULE_ID_LOCKNET, at_str, strlen(at_str));
	return 0;

}

int zCtrm_LocknetLevel(MSG_BUF *msg)
{
	UINT32 retCode = EXT_ERROR;    
	CHAR at_str[AT_STR_LEN] = {0};    
	T_zCtrm_LockLevel  lockState = LOCKFLAG_ERROR;   
	//retCode = zDrvNand_Read(AMT_LOCKNET_BASE,sizeof(lockState),(UINT8 *)&lockState); //len=4
	retCode = cpnv_NvItemRead(AMT_LOCKNET_BASE, (UINT8 *)&lockState, sizeof(lockState));
	if (EXT_SUCCESS != retCode )
	{   
		at_print(AT_ERR,"zCtrm_ExtLocknetLevel read err\n");
	    snprintf(at_str,AT_STR_LEN,"\r\n+CME ERROR\r\n");
		goto end;
	}
	if(lockState == ALREADY_UNLOCKED)
	{
		snprintf(at_str,AT_STR_LEN,"\r\n+LOCKLEVEL:Already Unlocked\r\nOK\r\n");
	}
	else if(lockState == LOCKED)
	{
	 	snprintf(at_str,AT_STR_LEN,"\r\n+LOCKLEVEL:Locked\r\nOK\r\n");
	}
	else if(lockState == NEVER_LOCKED)
	{
	    snprintf(at_str,AT_STR_LEN,"\r\n+LOCKLEVEL:Never Locked\r\nOK\r\n");
	}
	else
	{
	    at_print(AT_ERR,"zCtrm_ExtLocknetLevel err flag:%x\n",lockState);
	    snprintf(at_str,AT_STR_LEN,"\r\n+CME ERROR\r\n");
		goto end;
	}
	goto end;
end:
	send_rsp_str_to_farps(MODULE_ID_LOCKNET, at_str, strlen(at_str));
	return 0;
}

int zCtrm_LocknetListGet()
{
	UINT32 retCode = EXT_ERROR;
	UINT16 iList = 0;
	UINT8 pPtr[MAX_AMT_AT_LEN] = {0};
	CHAR at_str[AT_STR_LEN+MAX_AMT_AT_LEN] = {0}; 
	
	T_zCtrm_LockListPara lockList = {0};
	for(iList = 0; iList < LOCKNET_MAX_NUM; iList++)  
	{
		memset(&lockList, 0, sizeof(lockList));//cov
		//retCode = zDrvNand_Read(AMT_LOCKNET_LIST + iList*sizeof(lockList), sizeof(lockList), (UINT8 *)&lockList);
		retCode = cpnv_NvItemRead(AMT_LOCKNET_LIST + iList*sizeof(lockList), (UINT8 *)&lockList, sizeof(lockList));
		if (EXT_SUCCESS != retCode )
		{   
			snprintf(at_str,AT_STR_LEN,"\r\n+CME ERROR\r\n");
			send_rsp_str_to_farps(MODULE_ID_LOCKNET, at_str, strlen(at_str));
	        return 0;
		}
		if((lockList.mcc[0] == 0xFF)||(lockList.imsi6[0] == 0xFF)||(lockList.gid1[0] == 0xFF))
		{
			at_print(AT_ERR,"zCtrm_ExtLocknetListGet break iList:[%d]\n",iList);
			break;
		}
		//cov
		lockList.mcc[LIST_MCCMNC_LEN-1] = '\0';
		lockList.mnc[LIST_MCCMNC_LEN-1] = '\0';
		lockList.imsi6[LIST_IMSI_LEN-1] = '\0';
		lockList.imsi7[LIST_IMSI_LEN-1] = '\0';
		lockList.gid1[LIST_GID_LEN-1] = '\0';
		lockList.gid2[LIST_GID_LEN-1] = '\0';
		if(iList < LOCKNET_FIRST_NUM)
		{	
			snprintf(pPtr+strlen(pPtr),sizeof(pPtr)-strlen(pPtr),"%s,%s,%s,%s,%s,%s;",
			    lockList.mcc,lockList.mnc,lockList.imsi6,lockList.imsi7,lockList.gid1,lockList.gid2);            
		}
		else
		{
			strcat((char *)pPtr,"next"); 
			break;
		}

	}
	snprintf(at_str,AT_STR_LEN+MAX_AMT_AT_LEN,"\r\n+MEPCG:%s\r\nOK\r\n",pPtr);
	send_rsp_str_to_farps(MODULE_ID_LOCKNET, at_str, strlen(at_str));
	return 0;
}

int zCtrm_LocknetListGetNext()
{
	UINT32	retCode = EXT_ERROR;
	UINT16 iList = 0;
	UINT8 pPtr[MAX_AMT_AT_LEN] = {0};
	CHAR at_str[AT_STR_LEN+MAX_AMT_AT_LEN] = {0}; 
	
	T_zCtrm_LockListPara lockList = {0};
	for(iList = 0; iList < LOCKNET_MAX_NUM - LOCKNET_FIRST_NUM; iList++)  
	{
		memset(&lockList, 0, sizeof(lockList));//cov
		//retCode = zDrvNand_Read(AMT_LOCKNET_LIST + (LOCKNET_FIRST_NUM+iList)*sizeof(lockList), sizeof(lockList), (UINT8 *)&lockList);  
		retCode = cpnv_NvItemRead(AMT_LOCKNET_LIST + (LOCKNET_FIRST_NUM+iList)*sizeof(lockList), (UINT8 *)&lockList, sizeof(lockList));
	    if (EXT_SUCCESS != retCode )
	    {   
	    	snprintf(at_str,AT_STR_LEN,"\r\n+CME ERROR\r\n");
			send_rsp_str_to_farps(MODULE_ID_LOCKNET, at_str, strlen(at_str));
	        return 0;
		}
	    if((lockList.mcc[0] == 0xFF)||(lockList.imsi6[0] == 0xFF)||(lockList.gid1[0] == 0xFF))
	    {
	     	at_print(AT_ERR,"zCtrm_ExtLocknetListGetNext break iList:[%d]\n",iList);
	        break;
	    }
	    //cov
	    lockList.mcc[LIST_MCCMNC_LEN-1] = '\0';
		lockList.mnc[LIST_MCCMNC_LEN-1] = '\0';
		lockList.imsi6[LIST_IMSI_LEN-1] = '\0';
		lockList.imsi7[LIST_IMSI_LEN-1] = '\0';
		lockList.gid1[LIST_GID_LEN-1] = '\0';
		lockList.gid2[LIST_GID_LEN-1] = '\0';
        snprintf(pPtr+strlen(pPtr),sizeof(pPtr)-strlen(pPtr),"%s,%s,%s,%s,%s,%s;",
            lockList.mcc,lockList.mnc,lockList.imsi6,lockList.imsi7,lockList.gid1,lockList.gid2);
	}
	snprintf(at_str,AT_STR_LEN+MAX_AMT_AT_LEN,"\r\n+MEPCG:%s\r\nOK\r\n",pPtr);
	send_rsp_str_to_farps(MODULE_ID_LOCKNET, at_str, strlen(at_str));
	return 0;
}

int zCtrm_LocknetListGetProc(MSG_BUF *msg)
{
	CHAR at_str[AT_STR_LEN] = {0};
	char *at_paras = (char*)msg->aucDataBuf;
	if(NULL != strstr(at_paras, "all"))
	{
		zCtrm_LocknetListGet();
	}
	else if(NULL != strstr(at_paras, "next"))
	{
		zCtrm_LocknetListGetNext();
	}
	else 
	{
		snprintf(at_str,AT_STR_LEN,"\r\n+CME ERROR\r\n");
		send_rsp_str_to_farps(MODULE_ID_LOCKNET, at_str, strlen(at_str));
	}
	return 0;
}

//ȡ롢ǩжǷ
static UINT32 zCtrm_SignExistAuthMutex(VOID)
{
    UINT32 retCode=EXT_ERROR;
    T_zCtrm_LockListPara lockList = {0};
    T_zCtrm_LockListPara lockListTmp = {0};
    UINT8 keyBuf[KEY_LEN] = {0};  
    UINT8 signBuf[KEY_LEN] = {0};  
    
    //
    //retCode = zDrvNand_Read(AMT_LOCKNET_LIST, sizeof(lockList), (UINT8 *)&lockList); 
    retCode = cpnv_NvItemRead(AMT_LOCKNET_LIST, (UINT8 *)&lockList, sizeof(lockList));   
    if (EXT_SUCCESS != retCode)
    {       
        return READ_ERROR;        
    }
    if((lockList.mcc[0] == 0xFF)||(lockList.imsi6[0] == 0xFF)||(lockList.gid1[0] == 0xFF))
    {
        return LOCKKEY_ISNULL;
    }
	if(memcmp(&lockList,&lockListTmp,sizeof(T_zCtrm_LockListPara)) == 0)
	{
        return LOCKKEY_ISNULL;//nvrowall.binȫ0
	}

    //
    //retCode = zDrvNand_Read(AMT_LOCKNET_KEY, sizeof(keyBuf), keyBuf);
    retCode = cpnv_NvItemRead(AMT_LOCKNET_KEY, keyBuf, sizeof(keyBuf));
    if (EXT_SUCCESS != retCode)
    {   
        return READ_ERROR;
    }   
    if(keyBuf[0] == 0xFF)
    {
        return LOCKKEY_ISNULL;
    }

    //ǩ
    //retCode = zDrvNand_Read(AMT_LOCKNET_SIGN, sizeof(signBuf), signBuf);
    retCode = cpnv_NvItemRead(AMT_LOCKNET_SIGN, signBuf, sizeof(signBuf));
    if (EXT_SUCCESS != retCode)
    {   
        return READ_ERROR;
    } 
    if(signBuf[0] == 0xFF)
    {
        return LOCKKEY_ISNULL;
    }

    return READ_SUCCESS;

}

static UINT32 zCtrm_SignAuth(VOID)
{
    UINT32	retCode = EXT_ERROR;
    UINT8 signBuf[KEY_LEN] = {0}; 
    UINT8 signHex128[KEY_LEN] = {0}; 
    char signtext[LOCKNET_KEY_LEN*2+1] = {0};
    char psDest[LOCKNET_KEY_LEN*2+1] = {0};
    
    //ǩ
    //retCode = zDrvNand_Read(AMT_LOCKNET_SIGN, sizeof(signBuf), signBuf);
	retCode = cpnv_NvItemRead(AMT_LOCKNET_SIGN, signBuf, sizeof(signBuf));
    if (EXT_SUCCESS != retCode)
    {   
        return RESULT_ERROR;
    } 
    
    //Կ
    retCode = zCtrm_RsaPublicEncryptProc(signBuf, signHex128);
    if (EXT_SUCCESS != retCode)
    {   
        return RESULT_ERROR;
    }
    
    zCtrm_Bytes2String(signHex128+KEY_LEN-LOCKNET_KEY_LEN, signtext, LOCKNET_KEY_LEN);
    
    //ժҪǩ Ƚ ժҪùԿ
    retCode=zCtrm_LocknetDigestMD5Hash(psDest);
    if (EXT_SUCCESS != retCode)
    {   
        return RESULT_ERROR;
    } 

    at_print(AT_ERR,"zCtrm_SignAuth signtext=%s,psDest=%s!",signtext,psDest);
    if(0 != strcasecmp(signtext,psDest))
    {
        return RESULT_LOCKED;
    }
    return RESULT_UNLOCKED;
}

static UINT32 zCtrm_KeyAuth(VOID)
{
    UINT32	retCode = EXT_ERROR;
    UINT8 keyBuf[KEY_LEN]  = {0};  
    UINT8 usrkeyBuf[LOCKNET_KEY_LEN] = {0}; 
    UINT8 usrkeyBuf128[KEY_LEN] = {0}; 
    UINT8 usrKeyText[KEY_LEN] = {0};
    
    //
    //retCode = zDrvNand_Read(AMT_LOCKNET_KEY, sizeof(keyBuf), keyBuf);
    retCode = cpnv_NvItemRead(AMT_LOCKNET_KEY, keyBuf, sizeof(keyBuf));
    if (EXT_SUCCESS != retCode || keyBuf[0] == 0xFF)
    {   
        return RESULT_ERROR;
    }   
    
    //û 
    //retCode = zDrvNand_Read(AMT_LOCKNET_USRKEY, sizeof(usrkeyBuf), usrkeyBuf);
    retCode = cpnv_NvItemRead(AMT_LOCKNET_USRKEY, usrkeyBuf, sizeof(usrkeyBuf));
    if (EXT_SUCCESS != retCode || usrkeyBuf[0] == 0xFF)
    {   
        return RESULT_LOCKED;
    } 

    memcpy(usrkeyBuf128+KEY_LEN-LOCKNET_KEY_LEN, usrkeyBuf, LOCKNET_KEY_LEN);
    retCode = zCtrm_RsaPublicEncryptProc(usrkeyBuf128, usrKeyText);
    if (EXT_SUCCESS != retCode )
    {   
        return RESULT_ERROR;
    }
    
    //û Ƚ ܺȽ
    if(memcmp(keyBuf,usrKeyText,KEY_LEN) != 0)
    {
        return RESULT_LOCKED;
    }
    return RESULT_UNLOCKED;
}

void zCtrm_DoSimAuth()
{
	char crsmrsp[256] = {0};
	void *p[] = {crsmrsp};
	UINT8 *pRes = NULL;
	CHAR  fileSize[5] = {0};
	char at_str[AT_STR_LEN] = {0};
	int ret = -1;
	
	snprintf(at_str, AT_STR_LEN, "AT+CRSM=192,%ld,0,0,15,,\"3F007F20\"\r\n", IDENTIFIER_GID1);
	ret = get_modem_info(at_str, "%s", p);
	if (ret) 
	{
		at_print(AT_ERR,"zCtrm_SignExistAuthMutex crsm error!\n");
		simPara.fileLen = 0;
	}
	else
	{
		pRes = strstr(crsmrsp, "144,0,");//ʾȷȡ
		if(NULL != pRes)
		{
			strncpy(fileSize, pRes+strlen("144,0,")+4, 4);
			simPara.fileLen = zCtrm_Atohex(fileSize[0])*4096 + zCtrm_Atohex(fileSize[1])*256 + zCtrm_Atohex(fileSize[2])*16 + zCtrm_Atohex(fileSize[3]);
			at_print(AT_ERR,"crsm_ok_act, fileLen1 = %ld \n", simPara.fileLen);
		}
		else
		{
			simPara.fileLen = 0;
		}
	}
	snprintf(at_str, AT_STR_LEN, "AT+CRSM=176,%ld,0,0,%ld\r\n", IDENTIFIER_GID1, simPara.fileLen);
	ret = get_modem_info(at_str, "%s", p);
	if (ret) 
		at_print(AT_ERR,"zCtrm_SignExistAuthMutex crsm error!\n");
	else
	{
		pRes = strstr(crsmrsp, "144,0,");//ʾȷȡ
		if(NULL != pRes)
		{
			strncpy(simLockListPara.gid1, pRes+strlen("144,0,"), LIST_GID_LEN-1);
			at_print(AT_ERR,"crsm_ok_act, gid1 = %s \n", simLockListPara.gid1);
		}
		
	}
	snprintf(at_str, AT_STR_LEN, "AT+CRSM=192,%ld,0,0,15,,\"3F007F20\"", IDENTIFIER_GID2);
	ret = get_modem_info(at_str, "%s", p); 
	if (ret) 
	{
		at_print(AT_ERR,"zCtrm_SignExistAuthMutex crsm error!\n");
		simPara.fileLen = 0;
	}
	else
	{
		pRes = strstr(crsmrsp, "144,0,");//ʾȷȡ
		if(NULL != pRes)
		{
			strncpy(fileSize, pRes+strlen("144,0,")+4, 4);
			simPara.fileLen = zCtrm_Atohex(fileSize[0])*4096 + zCtrm_Atohex(fileSize[1])*256 + zCtrm_Atohex(fileSize[2])*16 + zCtrm_Atohex(fileSize[3]);
			at_print(AT_ERR,"crsm_ok_act, fileLen2 = %ld \n", simPara.fileLen);
		}
		else
		{
			simPara.fileLen = 0;
		}
	}
	snprintf(at_str, AT_STR_LEN, "AT+CRSM=176,%ld,0,0,%ld\r\n", IDENTIFIER_GID2, simPara.fileLen);
	ret = get_modem_info(at_str, "%s", p); 
	if (ret) 
		at_print(AT_ERR,"zCtrm_SignExistAuthMutex crsm error!\n");
	else
	{
		pRes = strstr(crsmrsp, "144,0,");//ʾȷȡ
		if(NULL != pRes)
		{
			strncpy(simLockListPara.gid2, pRes+strlen("144,0,"), LIST_GID_LEN-1);
			at_print(AT_ERR,"crsm_ok_act, gid2 = %s \n", simLockListPara.gid2);
		}
	}
	ret = get_modem_info("AT+CRSM=176,28589,0,0,4\r\n", "%s", p); 
	if (ret) 
	{
		simPara.mncLen = 2;
		at_print(AT_ERR,"crsm_err_act, mncLen = %d \n", simPara.mncLen);
	}
	else
	{
		pRes = strstr(crsmrsp, "144,0,");//ʾȷȡ
		if((NULL != pRes)&&(0 == strcmp("03", pRes+strlen("144,0,")+6))) //use 02 test
		{
			simPara.mncLen = 3;
		}
		else
		{
			simPara.mncLen = 2;
		}
		at_print(AT_ERR,"crsm_ok_act, mncLen = %d \n", simPara.mncLen);
	}
	return;
}

void zCtrm_DoUsimAuth()
{
	char crsmrsp[256] = {0};
	void *p[] = {crsmrsp};
	UINT8 *pRes = NULL;
	CHAR  fileSize[5] = {0};
	int ret = -1;

	ret = get_modem_info("AT+CRSM=176,28478,0,0,0\r\n", "%s", p);
	if (ret) 
		at_print(AT_ERR,"cardmode_err_act zCtrm_USimAuth ERROR!\n");
	else
	{
		pRes = strstr(crsmrsp, "144,0,");
		if(NULL != pRes)
		{
			strncpy(simLockListPara.gid1, pRes+strlen("144,0,"), LIST_GID_LEN-1);
	 		at_print(AT_ERR,"crsm_ok_act, gid1 = %s \n", simLockListPara.gid1);
		}
	}
	ret = get_modem_info("AT+CRSM=176,28479,0,0,0\r\n", "%s", p);
	if (ret) 
		at_print(AT_ERR,"cardmode_err_act zCtrm_USimAuth ERROR!\n");
	else
	{
		pRes = strstr(crsmrsp, "144,0,");
		if(NULL != pRes)
		{
			strncpy(simLockListPara.gid2, pRes+strlen("144,0,"), LIST_GID_LEN-1);
	 		at_print(AT_ERR,"crsm_ok_act, gid2 = %s \n", simLockListPara.gid2);
		}
	}
	ret = get_modem_info("AT+CRSM=176,28589,0,0,4\r\n", "%s", p);
	if (ret) 
	{
		simPara.mncLen = 2;
		at_print(AT_ERR,"crsm_err_act, mncLen = %d \n", simPara.mncLen);
	}
	else
	{
		pRes = strstr(crsmrsp, "144,0,");
		if((NULL != pRes)&&(0 == strcmp("03", pRes+strlen("144,0,")+6))) //use 02 test
		{
			simPara.mncLen = 3;
		}
		else
		{
			simPara.mncLen = 2;
		}
	 	at_print(AT_ERR,"crsm_ok_act, mncLen = %d \n", simPara.mncLen);
	}
	return;	
}

VOID zCtrm_SIMPara2Auth(T_zCtrm_LockListPara *fromSim, T_zCtrm_SIMPara simPara)
{
	strncpy(fromSim->mcc,simPara.simImsi,3);
	if (simPara.mncLen < sizeof(fromSim->mnc)) {
		memset(fromSim->mnc,0,sizeof(fromSim->mnc));
		snprintf(fromSim->mnc,simPara.mncLen+1,"%s",simPara.simImsi+3);
		//strncpy(fromSim->mnc,simPara.simImsi+3,simPara.mncLen);
	}
	strncpy(fromSim->imsi6,simPara.simImsi+5,1);
	strncpy(fromSim->imsi7,simPara.simImsi+6,1);
}

UINT32 zCtrm_AuthSIMPara(T_zCtrm_LockListPara *simPara)
{
    UINT32	retCode = EXT_ERROR;
    UINT32 iNum = 0;

    if(0 == strcmp("001",simPara->mcc) && 0 == strcmp("01",simPara->mnc))
        //if(0 == strcmp("460",simPara.mcc) && 0 == strcmp("01",simPara.mnc))
    {
        at_print(AT_ERR,"sim ex\n");
        return EXT_SUCCESS;
    }
    
    for(iNum = 0; iNum < LOCKNET_MAX_NUM; iNum++)  
    {    
        T_zCtrm_LockListPara lockList = {0};
        //retCode = zDrvNand_Read(AMT_LOCKNET_LIST + iNum*sizeof(lockList), sizeof(lockList), (UINT8 *)&lockList);  
        retCode = cpnv_NvItemRead(AMT_LOCKNET_LIST + iNum*sizeof(lockList), (UINT8 *)&lockList, sizeof(lockList));
        if (EXT_SUCCESS != retCode )
        {              
			at_print(AT_ERR,"zCtrm_AuthSIMPara:zDrvNand_Read error\n");
			return EXT_ERROR;
        }
        
        if((lockList.mcc[0] == 0xFF)||(lockList.imsi6[0] == 0xFF)||(lockList.gid1[0] == 0xFF))
        {
			at_print(AT_ERR,"zCtrm_AuthSIMPara: lockList value error\n");
			return EXT_ERROR;
        }
		//cov
		lockList.mcc[LIST_MCCMNC_LEN-1] = '\0';
		lockList.mnc[LIST_MCCMNC_LEN-1] = '\0';
		lockList.imsi6[LIST_IMSI_LEN-1] = '\0';
		lockList.imsi7[LIST_IMSI_LEN-1] = '\0';
        if( (lockList.mcc[0] == '\0'||0 == strcmp(lockList.mcc,simPara->mcc))
          &&(lockList.mnc[0] == '\0'||0 == strcmp(lockList.mnc,simPara->mnc))
          &&(lockList.imsi6[0] == '\0'||0 == strcmp(lockList.imsi6,simPara->imsi6))
          &&(lockList.imsi7[0] == '\0'||0 == strcmp(lockList.imsi7,simPara->imsi7))
          &&(lockList.gid1[0] == '\0'||0 == zCtrm_Strnicmp(lockList.gid1,simPara->gid1,USED_GID_LEN))
          &&(lockList.gid2[0] == '\0'||0 == zCtrm_Strnicmp(lockList.gid2,simPara->gid2,USED_GID_LEN)) )
        {   
            at_print(AT_ERR,"sim checked\n");
            return EXT_SUCCESS;
        }       
    }
	
    at_print(AT_ERR,"zCtrm_AuthSIMPara: other error\n");    
    return EXT_ERROR;
}

static UINT32 zCtrm_SimAuth()
{
	int ret = -1;
	int cardmode = 0;
	void *p1[] = {&cardmode};
	char imsi[MAX_IMSI_LEN] = {0};
	void *p2[] = {imsi};
		
	ret = get_modem_info("AT^CARDMODE\r\n", "%d", p1);
	if (ret) {
		simPara.cardMode = CARDMODE_UNKNOW;
		at_print(AT_ERR,"cardmode_err_act zCtrm_SimAuth ERROR!\n");
		return RESULT_ERROR;
	}
	if(1 == cardmode)
	{
		simPara.cardMode = CARDMODE_SIM;
		zCtrm_DoSimAuth();
	}
	else if(2 == cardmode)
	{
		simPara.cardMode = CARDMODE_USIM;
		zCtrm_DoUsimAuth();
	}
	else 
		return RESULT_ERROR;
	ret = get_modem_info("AT+CIMI\r\n", "%s", p2); 
	if (ret)
	{
		at_print(AT_ERR,"cimi_err_act zCtrm_SimAuth ERROR!\n");
		return RESULT_ERROR;
	}
	else
	{
		strncpy(simPara.simImsi,imsi,sizeof(simPara.simImsi)-1);
		if(*(simPara.simImsi) == '\0')
     	{
        	at_print(AT_ERR,"cimi_ok_act zCtrm_SimAuth ERROR!\n");
			return RESULT_ERROR;
    	}
		zCtrm_SIMPara2Auth(&simLockListPara, simPara);
		ret = zCtrm_AuthSIMPara(&simLockListPara);
		if (EXT_SUCCESS != ret)
		{
			ret = get_modem_info("AT+CFUN=4;+ZSCHPLMN=0\r\n", NULL, NULL);
			if (ret)
			{
				at_print(AT_ERR,"zCtrm_SimAuth ZSCHPLMN0 error!\n");
			}
			return RESULT_LOCKED;
		}
		else 
		{
			ret = get_modem_info("AT+ZSCHPLMN=1\r\n", NULL, NULL);
			if (ret)
			{
				at_print(AT_ERR,"zCtrm_SimAuth ZSCHPLMN1 error!\n");
			}
			return RESULT_UNLOCKED;
		}	
	}

}

int zCtrm_makeLocknetAuth(MSG_BUF *msg)
{     
	UINT32 readCode = READ_ERROR;//ȡ롢ǩǷ
	UINT32  result = RESULT_ERROR;//ÿһжϽ
	char at_str[AT_STR_LEN] = {0};
	int ret = -1;
		
	at_print(AT_ERR,"zCtrm_ExtLocknetAuth,status = %d\n",g_Sec_Status);
    if(g_Sec_Status != ENCRYPT_LOCK && g_Sec_Status != ENCRYPT_UNLOCK_CORRECT)
    {
		at_print(AT_ERR,"zCtrm_LocknetAuth, g_Sec_Status:%d\n",g_Sec_Status);

	//롢ǩǷ
	    readCode = zCtrm_SignExistAuthMutex();
	    if(readCode == READ_ERROR)
	    {       
	        g_Sec_Status = ENCRYPT_ERROR;
	        at_print(AT_ERR,"zCtrm_SignExistAuthMutex ERROR!\n");
			snprintf(at_str,AT_STR_LEN,"\r\n+CME ERROR:149\r\n");
			goto end;
	    } 
	    else if(readCode == LOCKKEY_ISNULL)
	    {
	    	ret = get_modem_info("AT+ZSCHPLMN=1\r\n", NULL, NULL);
			if (ret) {
				at_print(AT_ERR,"zCtrm_SignExistAuthMutex zschplmn1 error!\n");
			}
			g_Sec_Status = ENCRYPT_UNLOCK_CORRECT;
			at_print(AT_ERR,"zCtrm_SignExistAuthMutex UNLOCK!\n");
			snprintf(at_str,AT_STR_LEN,"\r\nOK\r\n");
			goto end;
	    }
	    //ڣһж
	    else
	    {
	        //жժҪǩǷһ£ǩҪùԿ
	        result = zCtrm_SignAuth();
	        if(result == RESULT_ERROR)
	        {
	        	g_Sec_Status = ENCRYPT_ERROR;
		  		snprintf(at_str,AT_STR_LEN,"\r\n+CME ERROR:149\r\n");
				goto end;
	        }
	        else if(result == RESULT_LOCKED)
	        {
	        	snprintf(at_str,AT_STR_LEN,"AT+CFUN=4;+ZSCHPLMN=0\r\n");
				ret = get_modem_info(at_str, NULL, NULL);
				if (ret) {
					at_print(AT_ERR,"zCtrm_SignExistAuthMutex zschplmn0 error!\n");
				}
	            g_Sec_Status = ENCRYPT_LOCK;
	            at_print(AT_ERR,"zCtrm_SignAuth LOCK!\n");
	            snprintf(at_str,AT_STR_LEN,"\r\nOK\r\n");
				goto end;
	        }
	        //һж
	        else
	        {
	            //жϽûǷһ£ûҪùԿ
	            //û벻ڻû벻һʱsimж
	            result = zCtrm_KeyAuth();
	            if(result == RESULT_ERROR)
	            {
	                g_Sec_Status = ENCRYPT_ERROR;
	                at_print(AT_ERR,"zCtrm_KeyAuth ERROR!\n");
	               	snprintf(at_str,AT_STR_LEN,"\r\n+CME ERROR:149\r\n");
					goto end;
	            }
	            else if(result == RESULT_UNLOCKED)
	            {
	                ret = get_modem_info("AT+ZSCHPLMN=1\r\n", NULL, NULL);
					if (ret) {
						at_print(AT_ERR,"zCtrm_SignExistAuthMutex zschplmn1 error!\n");
					}
					g_Sec_Status = ENCRYPT_UNLOCK_CORRECT;
	                at_print(AT_ERR,"zCtrm_KeyAuth UNLOCK!\n");
	                snprintf(at_str,AT_STR_LEN,"\r\nOK\r\n");
					goto end;
	            }
	            //һж
	            else
	            {       
					result = zCtrm_SimAuth();
					if(RESULT_ERROR == result)
					{
						g_Sec_Status = ENCRYPT_ERROR;
						at_print(AT_ERR,"zCtrm_SimAuth ERROR!\n");
						snprintf(at_str,AT_STR_LEN,"\r\n+CME ERROR:149\r\n");
						goto end;
					}
					else if(RESULT_LOCKED == result)
					{
						g_Sec_Status = ENCRYPT_LOCK;
						snprintf(at_str,AT_STR_LEN,"\r\nOK\r\n");
						goto end;
					}
					else
					{
						g_Sec_Status = ENCRYPT_UNLOCK_CORRECT;
						snprintf(at_str,AT_STR_LEN,"\r\nOK\r\n");
						goto end;
					}
				}
		
	        }
	    }
		/* cov2
	   	ret = get_modem_info("AT+ZSCHPLMN=1\r\n", NULL, NULL);
		if (ret) {
			at_print(AT_ERR,"zCtrm_SignExistAuthMutex zschplmn1 error!\n");
		}
		g_Sec_Status = ENCRYPT_UNLOCK_CORRECT;
		snprintf(at_str,AT_STR_LEN,"\r\nOK\r\n");
		goto end;
		*/
    }
	snprintf(at_str,AT_STR_LEN,"\r\nOK\r\n");
	goto end;
end:
	if(1 == sendflag)
	{
		send_rsp_str_to_farps(MODULE_ID_LOCKNET, at_str, strlen(at_str));//zurdỵҪ򴮿ڷֵ
		sendflag = 0;
	}
	return 0;
}

static UINT32 zCtrm_UnlockTimesCheck(UINT32 *curTimes)
{
	UINT32 retCode = EXT_ERROR;
	UINT32 times = 0;
	UINT32 maxTimes = 0;
	T_zCtrm_LockLevel lockState = NEVER_LOCKED;

	//retCode = zDrvNand_Read(AMT_LOCKNET_BASE, sizeof(lockState),(UINT8 *)&lockState);
	retCode = cpnv_NvItemRead(AMT_LOCKNET_BASE,(UINT8 *)&lockState, sizeof(lockState));
	at_print(AT_ERR,"zCtrm_UnlockCodeCheck lockState=%d,retCode=%d!\n",lockState,retCode);
	if (EXT_SUCCESS != retCode || lockState != LOCKED)
	{  
	   return EXT_ERROR;
	}


	//retCode = zDrvNand_Read(AMT_LOCKNET_TIMES, sizeof(times),(UINT8 *)&times);
	retCode = cpnv_NvItemRead(AMT_LOCKNET_TIMES,(UINT8 *)&times, sizeof(times));
	at_print(AT_ERR,"zCtrm_UnlockCodeCheck times=%d,retCode=%d!\n",times,retCode);
	if (EXT_SUCCESS != retCode)
	{  
	   return EXT_ERROR;
	}

	maxTimes = zCtrm_GetUnlockMaxTime();
	if(times > 0 && times <= maxTimes)
	{
	   *curTimes = times;
	   return EXT_SUCCESS;
	}

	return EXT_ERROR;
}

//ûĽ룬ҪùԿܺROеĽȽϡ
//(ROн128λ)
static UINT32 zCtrm_UnlockCodeCheck(UINT8 *keyBuf,UINT16 keyLen)
{
	UINT32 retCode = EXT_ERROR;    
	UINT8 lockkey[KEY_LEN] = {0};
	UINT8 keyBufText[KEY_LEN] = {0};//ûַܺ
	UINT8 test1[KEY_LEN*2+1]={0};
	UINT8 test2[KEY_LEN*2+1]={0};
	UINT8 keyBuf128[KEY_LEN]={0};


	//retCode = zDrvNand_Read(AMT_LOCKNET_KEY, sizeof(lockkey), lockkey);
	retCode = cpnv_NvItemRead(AMT_LOCKNET_KEY,lockkey, sizeof(lockkey));
	zCtrm_Bytes2String(lockkey, test1, KEY_LEN);
	at_print(AT_ERR,"zCtrm_UnlockCodeCheck lockkey=%s,len=%d!\n",test1,strlen(test1));
	if (EXT_SUCCESS != retCode)
	{   
	   return EXT_ERROR;
	}


	memcpy(keyBuf128+KEY_LEN-LOCKNET_KEY_LEN, keyBuf, LOCKNET_KEY_LEN);
	retCode = zCtrm_RsaPublicEncryptProc(keyBuf128, keyBufText);
	zCtrm_Bytes2String(keyBufText, test2, KEY_LEN);
	at_print(AT_ERR,"zCtrm_UnlockCodeCheck keyBufText=%s,len=%d!\n",test2,strlen(test2));
	if (EXT_SUCCESS != retCode )
	{   
	   return EXT_ERROR;
	}

	if(memcmp(keyBufText,lockkey,keyLen) != 0)
	{   
	   return EXT_ERROR;
	}

	return EXT_SUCCESS;
}

static VOID zCtrm_UnlockTimesUpdate(UINT32 curTimes)
{   
	UINT32 retCode = EXT_ERROR;
	UINT32 maxTimes = 0;

	maxTimes = zCtrm_GetUnlockMaxTime();
	if(curTimes > 0 && curTimes <= maxTimes)
	{
	  	curTimes = curTimes - 1;
	}
	else
	{
	   	curTimes = 0;
	}

	cpnv_ChangeNvRoAttr(1);
	//retCode = zDrvNand_Program(AMT_LOCKNET_TIMES, sizeof(curTimes),(UINT8 *)&curTimes);
	retCode = cpnv_NvItemWriteNvro(AMT_LOCKNET_TIMES, (UINT8 *)&curTimes, sizeof(curTimes));
	if (EXT_SUCCESS != retCode)
	{  
		//retCode = zDrvNand_Program(AMT_LOCKNET_TIMES, sizeof(curTimes),(UINT8 *)&curTimes);
		retCode = cpnv_NvItemWriteNvro(AMT_LOCKNET_TIMES, (UINT8 *)&curTimes, sizeof(curTimes));
	    at_print(AT_ERR,"zCtrm_UnlockTimesUpdate: %ld\n",retCode);
	}
	cpnv_FsGcWait(FS_NVROFS);
	cpnv_ChangeNvRoAttr(0);    
	at_print(AT_ERR,"zCtrm_UnlockTimesUpdate cur: %ld\n",curTimes); 
}

static UINT32 zCtrm_UnlockNandSet(UINT8 *keyBuf,UINT16 len)
{
	T_zCtrm_LockLevel lockState = ALREADY_UNLOCKED;
	T_zCtrm_LockLevel lockState_out = ALREADY_UNLOCKED;
	UINT32 times = zCtrm_GetUnlockMaxTime();
	UINT32 retCode =EXT_ERROR;

	cpnv_ChangeNvRoAttr(1);
	//retCode = zDrvNand_Program(AMT_LOCKNET_TIMES, sizeof(times),(UINT8 *)&times);
	retCode = cpnv_NvItemWriteNvro(AMT_LOCKNET_TIMES, (UINT8 *)&times, sizeof(times));
	at_print(AT_ERR,"zCtrm_UnlockNandSet len=%d,times=%d!\n",sizeof(times),times);
	if (EXT_SUCCESS != retCode)
	{  
		cpnv_ChangeNvRoAttr(0);   
	    return EXT_ERROR;
	}

	//retCode = zDrvNand_Program(AMT_LOCKNET_USRKEY, len,keyBuf);
	retCode = cpnv_NvItemWriteNvro(AMT_LOCKNET_USRKEY, keyBuf, len);
	at_print(AT_ERR,"zCtrm_UnlockNandSet len=%d,keyBuf=%s!\n",len,keyBuf);
	if (EXT_SUCCESS != retCode)
	{  
	  	cpnv_ChangeNvRoAttr(0);   
	   	return EXT_ERROR;
	}

	//retCode = zDrvNand_Program(AMT_LOCKNET_BASE, sizeof(lockState),(UINT8 *)&lockState);
	retCode = cpnv_NvItemWriteNvro(AMT_LOCKNET_BASE, (UINT8 *)&lockState, sizeof(lockState));
	at_print(AT_ERR,"zCtrm_UnlockNandSet len=%d,lockstate=%d!\n",sizeof(lockState),lockState);
	if (EXT_SUCCESS != retCode)
	{   
		cpnv_ChangeNvRoAttr(0);   
	   	return EXT_ERROR;
	}

	//zDrvNand_Read(AMT_LOCKNET_BASE, sizeof(lockState_out),(UINT8 *)&lockState_out);
	retCode = cpnv_NvItemRead(AMT_LOCKNET_BASE,(UINT8 *)&lockState_out, sizeof(lockState_out));
	at_print(AT_ERR,"zCtrm_UnlockNandSet len=%d,lockState_out=%d!\n",sizeof(lockState_out),lockState_out);
	cpnv_FsGcWait(FS_NVROFS);
	cpnv_ChangeNvRoAttr(0);    

	return EXT_SUCCESS;
}

int zCtrm_LocknetUnlock(MSG_BUF *msg)
{    
	UINT32 retCode = EXT_ERROR;
	UINT32 retryCount = 0;  
    UINT16 keyLen = 0;
    MSG_BUF *p_msg = (MSG_BUF *)msg;
    UINT8 keyBuf[LOCKNET_KEY_LEN+1] = {0};  
	char at_str[AT_STR_LEN] = {0};
	int ret = -1;

	at_print(AT_ERR,"zCtrm_LocknetUnlock\n");
	retCode = zCtrm_UnlockTimesCheck(&retryCount);
    if (EXT_SUCCESS != retCode )
	{   
	  	snprintf(at_str,AT_STR_LEN,"\r\n+CME ERROR:3\r\n");
		goto end;
    }
    at_print(AT_ERR,"zCtrm_LocknetUnlock cur: %ld\n",retryCount);  
	keyLen = p_msg->usDataLen;
	if (keyLen != LOCKNET_KEY_LEN)
	{
		snprintf(at_str,AT_STR_LEN,"\r\n+CME ERROR:6004\r\n");
		goto end;
	}
    memcpy(keyBuf,p_msg->aucDataBuf,keyLen);
    at_print(AT_ERR,"zCtrm_ExtLocknetUnlock keyBuf=%s!\n",keyBuf);
        
    retCode = zCtrm_UnlockCodeCheck(keyBuf,keyLen);
    if (EXT_SUCCESS != retCode )
    {   
    	zCtrm_UnlockTimesUpdate(retryCount);
		snprintf(at_str,AT_STR_LEN,"\r\n+CME ERROR:6004\r\n");
		goto end;
    }

    //ĴûĽ(16λַ)
    retCode = zCtrm_UnlockNandSet(keyBuf,keyLen);
	if (EXT_SUCCESS != retCode )
    {   
        zCtrm_UnlockTimesUpdate(retryCount);
        snprintf(at_str,AT_STR_LEN,"\r\n+CME ERROR:6004\r\n");
		goto end;
    }
	ret = get_modem_info("AT+ZSCHPLMN=1\r\n", NULL, NULL);
	if (ret) {
		at_print(AT_ERR,"zCtrm_LocknetUnlock zschplmn1 error!\n");
	}
	g_Sec_Status = ENCRYPT_UNLOCK_CORRECT;
    at_print(AT_ERR,"zCtrm_UnlockModemSet\n");
    snprintf(at_str,AT_STR_LEN,"\r\nOK\r\n");
	goto end;
 end:
	send_rsp_str_to_farps(MODULE_ID_LOCKNET, at_str, strlen(at_str));
	return 0;       
}

static UINT32 zCtrm_UnlockTimesGet(UINT32 *curTimes)
{
    UINT32 retCode = EXT_ERROR;
    UINT32 times = 0;
    UINT32 maxTimes = 0;
    T_zCtrm_LockLevel lockState = NEVER_LOCKED;
    
    //retCode = zDrvNand_Read(AMT_LOCKNET_BASE, sizeof(lockState),(UINT8 *)&lockState);
    retCode = cpnv_NvItemRead(AMT_LOCKNET_BASE,(UINT8 *)&lockState, sizeof(lockState));
    at_print(AT_ERR,"zCtrm_UnlockTimesGet lockState=%d,retCode=%d!\n",lockState,retCode);
    if (EXT_SUCCESS != retCode || lockState != LOCKED)
    {  
        return EXT_ERROR;
    }
    
    
    //retCode = zDrvNand_Read(AMT_LOCKNET_TIMES, sizeof(times),(UINT8 *)&times);
    retCode = cpnv_NvItemRead(AMT_LOCKNET_TIMES,(UINT8 *)&times, sizeof(times));
    at_print(AT_ERR,"zCtrm_UnlockTimesGet times=%d,retCode=%d!\n",times,retCode);
    if (EXT_SUCCESS != retCode)
    {  
        return EXT_ERROR;
    }

    maxTimes = zCtrm_GetUnlockMaxTime();
    if(times <= maxTimes)//klocwork
    {
        *curTimes = times;
        return EXT_SUCCESS;
    }
    
    return EXT_ERROR;
}

int zCtrm_LocknetUnlockTimes(MSG_BUF *msg)
{
	UINT32 retCode = EXT_ERROR;
	UINT32 retryCount = 0; 
	UINT8 pStr[4] = {0};
	char at_str[AT_STR_LEN] = {0};
		
	retCode = zCtrm_UnlockTimesGet(&retryCount);
	if (EXT_SUCCESS != retCode )
	{   
	   	snprintf(at_str,AT_STR_LEN,"\r\n+CME ERROR:3\r\n");
		goto end;
	}  
	snprintf(at_str,AT_STR_LEN,"\r\n+ZNCK:%d\r\nOK\r\n",retryCount);
	goto end;
end:
	send_rsp_str_to_farps(MODULE_ID_LOCKNET, at_str, strlen(at_str));
	return 0;

}

int zCtrm_LocknetStatus(MSG_BUF *msg)
{
	T_zCtrm_SecItems secItems = NO_ACTION;
	char at_str[AT_STR_LEN] = {0};

	if(g_Sec_Status == ENCRYPT_LOCK)
	{
	    secItems = NET_LOCK;
	}
	snprintf(at_str,AT_STR_LEN,"\r\n+ZSEC:%d,%d\r\nOK\r\n",g_Sec_Status,secItems);
	send_rsp_str_to_farps(MODULE_ID_LOCKNET, at_str, strlen(at_str));
	return 0;
}

