/*****************************************************************************
*  汾 (C)ͨѶɷ޹˾
*  ģ    MMI
*  ļ    mmi_msg.c
*  ļʶ  
*  ļ  
*  ʵֹ  MMIϢ
*        
*  汾      V1.0
*    2014-6-20
*  ˵  
*
******************************************************************************/

/*****************************************************************************
                         ͷļ
******************************************************************************/
#include <errno.h>
#include <sys/msg.h>
#include "softap_api.h"

/**********************************************************************************
:MMI̵Ϣ
***********************************************************************************/
long mmi_create_msg_queue()
{
	long msgid = 0;
	if ((msgid = msgget(MODULE_ID_MMI, IPC_CREAT | 0600)) == -1) {
		slog(MMI_PRINT, SLOG_ERR, "MMI [error]:Create MODULE_ID_MMI queue faild! msgid=%d\n", msgid);
		return -1;
	}
	slog(MMI_PRINT, SLOG_DEBUG, "MMI Creating mmi message queue success! MODULE_ID_MMI=%d\n", msgid);
	return msgid;
}

int mmi_RecvMsgFromQueue(int msgQueueId, MSG_BUF *pstMsg, long MsgType)
{
	int iRet = -1;
	long msgSize =  sizeof(MSG_BUF) - sizeof(long);

	if (NULL == pstMsg) {
		return -1;
	}

	iRet = msgrcv(msgQueueId, pstMsg, msgSize, MsgType, MSG_NOERROR);
	slog(MMI_PRINT, SLOG_DEBUG, "MMI mmi_RecvMsgFromQueue : iRet : %ld, pstMsg->src_id:%ld,  pstMsg->usMsgCmd:%ld \n", iRet, pstMsg->src_id, pstMsg->usMsgCmd);

	if (iRet <= 0) {
		slog(MMI_PRINT, SLOG_ERR, "MMI mmi_RecvMsgFromQueue Failed : iRet : %ld, pstMsg->src_id:%ld,  pstMsg->usMsgCmd:%ld \n", iRet, pstMsg->src_id, pstMsg->usMsgCmd);
		return -1;
	} else {
		return 0;
	}
}

