/**
 * @file absvr_msg.h
 * @brief Extern MSG APIs of absvr_msg
 *
 * Copyright (C) 2023 Sanechips Technology Co., Ltd.
 * @author
 * @ingroup
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 *
 */


#ifndef _ABSVR_MSG_H
#define _ABSVR_MSG_H


/*******************************************************************************
 *                           Include header files                              *
 ******************************************************************************/
#include "message.h"


/*******************************************************************************
 *                             Macro definitions                               *
 ******************************************************************************/


/*******************************************************************************
 *                             Type definitions                                *
 ******************************************************************************/
enum absvr_msg_cmd
{
    ABSVR_GET_UPGRADE_TYPE_REQ = MSG_CMD_ABSVR_BASE,
    ABSVR_GET_UPGRADE_TYPE_RSP,

    ABSVR_VRITFY_REQ,
    ABSVR_VRITFY_RSP,

    ABSVR_UPDATE_REQ,
    ABSVR_UPDATING_RSP,
    ABSVR_UPDATE_RSP,

    ABSVR_SYNC_REQ,
    ABSVR_SYNC_RSP,

    ABSVR_GET_UPGRADE_STATUS_REQ,
    ABSVR_GET_UPGRADE_STATUS_RSP,

    ABSVR_GET_CURRENT_SYSTEM_REQ,
    ABSVR_GET_CURRENT_SYSTEM_RSP,

    ABSVR_GET_BOOT_TO_SYSTEM_REQ,
    ABSVR_GET_BOOT_TO_SYSTEM_RSP,

    ABSVR_SET_BOOT_TO_SYSTEM_REQ,
    ABSVR_SET_BOOT_TO_SYSTEM_RSP,

    ABSVR_GET_SYSTEM_STATUS_REQ,
    ABSVR_GET_SYSTEM_STATUS_RSP,

    ABSVR_SET_SYSTEM_STATUS_REQ,
    ABSVR_SET_SYSTEM_STATUS_RSP,

    ABSVR_GET_FOTA_STATUS_FOR_NV_REQ,
    ABSVR_GET_FOTA_STATUS_FOR_NV_RSP,

    ABSVR_SET_FOTA_STATUS_FOR_NV_REQ,
    ABSVR_SET_FOTA_STATUS_FOR_NV_RSP,

    ABSVR_GET_SYNC_STATUS_REQ,
    ABSVR_GET_SYNC_STATUS_RSP,

    ABSVR_SET_SYNC_STATUS_REQ,
    ABSVR_SET_SYNC_STATUS_RSP,

    ABSVR_CONFIG_PACKAGE_PATH_REQ,
    ABSVR_CONFIG_PACKAGE_PATH_RSP
};


#endif

