/**
 * @file at_other_msg.h
 * @brief ṩAT_CTLзOPENCPUϢӦĽṹ嶨
 *
 * Copyright (C) 2017 Sanechips Technology Co., Ltd.
 * @author
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 *
 */
	
#ifndef __AT_OTHER_API_H__
#define __AT_OTHER_API_H__
	
	
/*******************************************************************************
*							 Include header files							   *
******************************************************************************/
#include "max_macro.h"
/*******************************************************************************
*							   Macro definitions							   *
******************************************************************************/
#define ZDIAL_NUM_MAX                48

/*******************************************************************************
*                             Type definitions                                *
******************************************************************************/
typedef struct {
	unsigned char	pduLen;
	char	pdu[1024];
	unsigned char	seq;
} T_zAt_CsimRes;
	


/**
 * @brief ϢϱӦϢMSG_CMD_ZUSLOT_IND
 * @param slot ȡֵΧ 0,1,2
 * @param slot_state, ״̬ 0 ο 1 忨
 */
typedef struct {
	long  slot;
	long  slot_state;
} T_zAt_ZuslotRes;


/**
 * @brief PIN֤Ϣṹ壬ӦϢMSG_CMD_VERIFY_PIN_REQ/MSG_CMD_VERIFY_PUK_REQ
 * @param pinpin2ǰΪPINPIN2+CPIN=<pin>У
 * @param newpin, ǰΪPUKPUK2+CPIN=<pin>,<newpin>н
 * һpinΪSIM PUKSIM PUK2룬ڶnewpinΪµPINPIN2
 */
typedef struct {
	char	pin[10];
	char	newpin[10];
} T_zAt_CpinPukSet;


/**
 * @brief PINϢṹ壬ӦϢMSG_CMD_PIN_MANAGE_REQ
 * @param action 0 ر 1  2 ޸
 * @param oldPin, ر/ʱPIN룬޸ʱľPIN
 * @param newPin ޸ʱPIN
 */
typedef struct {
	unsigned int action;		   /*ͣenable, disable, modify*/
	char  oldPin[10];
	char  newPin[10];
} T_zAt_PinManage;


/**
 * @brief ʼӦϢMSG_CMD_ZPBIC_IND
 * @param result0 ʧ 1 ɹ
 * @param opertype, ҵ 0  1 绰 2 ȫ
 */
typedef struct {
	long result;
	long opertype;
} T_zAt_ZpbicRes;


/*****************ϢӦṹ begin*****************************/

/**
 * @brief ͶϢṹ壬ӦϢMSG_CMD_SENDSMS_REQ
 * @param lengthݳ
 * @param pdu, pdu
 */
typedef struct {
	int 	length;
	char	pdu[ZSMS_PDU_SIZE];
} T_zSms_SendSmsReq;

/**
 * @brief ɾϢṹ壬ӦϢMSG_CMD_DELSMS_REQ
 * @param indexɾ
 */
typedef struct {
	int 	index;
} T_zSms_DelSmsReq;


/**
 * @brief ϲռɿû򲻿ãӦϢMSG_CMD_STORAGE_CAP_REQ
 * @param type	0   1 
 */
typedef struct {
	int 	type;
} T_zSms_StroageReq;


/**
 * @brief Ŵδ״̬ѶӦϢMSG_CMD_MODIFY_TAG_REQ
 * @param index
 */
typedef struct {
	int 	index;
} T_zSms_ModifyTagReq;


/**
 * @brief ṹ壬ӦϢMSG_CMD_READSMS_REQ
 * @param index
 */
typedef struct {
	int 	index;
} T_zSms_ReadSmsReq;


/**
 * @brief öģӦϢMSG_CMD_SCA_SET_REQ
 * @param scaĺ
 */
typedef struct {
	char sca[22];
} T_zSms_SetScaReq;


/**
 * @brief ¶֪ͨãӦϢMSG_CMD_NOTIFY_SET_REQ
 * @param mtָʾ¶ŵʱָʾʽ
 */
typedef struct {
	int mt;
} T_zSms_NotifySetReq;


/**
 * @brief ¶ȷϣӦϢMSG_CMD_SMSACK_REQ
 * @param ackmodeӦʽ
 * @param lengthPDUĳ
 * @param pduSMSCַTPDUݰ
 */
typedef struct {
	int   ackmode;
	int   length;
	char  pdu[50];
} T_zSms_SmsAckReq;


/**
 * @brief ŲӦϢMSG_CMD_SENDSMS_RSP
 *		/MSG_CMD_DELSMS_RSP /MSG_CMD_STORAGE_CAP_RSP
 *		/MSG_CMD_MODIFY_TAG_RSP/MSG_CMD_NOTIFY_SET_RSP/MSG_CMD_SCA_SET_RSP
 *		/MSG_CMD_SMSACK_RSP/MSG_CMD_SMSINIT_RSP
 * @param result1 ɹ   ʧ
 */
typedef struct {
	int   result;
} T_zSms_optRsp;


/*ӦϢ MSG_CMD_NEWSMS_STATUS_IND MSG_CMD_ZMGR_IND MSG_CMD_READSMS_RSP*/
/**
 * @brief ¶ϱӦϢMSG_CMD_NEWSMS_STATUS_IND/MSG_CMD_ZMGR_IND
 * @param indexڴ洢е
 * @param stat洢жϢϢ״̬
 * @param alpha+CSCS
 * @param lengthpdu
 * @param pdupdu
 */
typedef struct {
	int 	index;
	int 	stat;
	char	alpha[36];
	int 	length;
	char	pdu[ZSMS_PDU_SIZE];
} T_zSms_SmsInd;


/**
 * @brief ¶indexϱӦϢMSG_CMD_NEWSMS_INDEX_IND/MSG_CMD_NEWSMS_STATUS_INDEX_IND
 * @param storetypeϢյĴ洢
 * @param index洢λ
 */
typedef struct {
	char	storetype[10];
	int 	index;
} T_zSms_SmsIndexInd;


/**
 * @brief ϱӦϢMSG_CMD_CSCA_IND
 * @param scaĵַ
 * @param tosca<sca>
 */
typedef struct {
	char sca[22];
	char tosca[22];
} T_zSms_CscaInd;


/**
 * @brief Ŵ洢ϢӦϢMSG_CMD_CPMS_IND
 * @param used
 * @param totalܹ
 */
typedef struct {
	int used;
	int total;
} T_zSms_CpmsInd;
/*****************ϢӦṹ end*****************************/


/************ƬϢӦĽṹbegin***********/
/*contactϢӦϢMSG_CMD_READ_PB_RSP*/
typedef struct {
	char    number1[42];
	char    number2[42];
	char    number3[42];
	char    number4[42];
	char    text[182];
	char    email[182];
	unsigned char   coding;
	unsigned char   num1Type;
	unsigned char   num2Type;
	unsigned char   num3Type;
	unsigned char   num4Type;
	unsigned int  index;
} T_zPb_ScpbrSetRes;

/*ӦϢMSG_CMD_READ_PB_REQ*/
typedef struct {
	int minIndex;//ɾpbʼλ
	int maxIndex;//ɾpbλ
} T_zPb_ScpbrReadRes;

typedef struct {
	int      pbIndex;
	int      coding;
	char        name[185];
	char        mobilNumber[42];
	char        officeNumber[42];
	char        homeNumber[42];
	char        faxNumber[42];
	char        email[182];
} T_zPb_ScpbwParam;

/*ӦϢ */
typedef struct {
	int   result;
} T_zPb_optRsp;

/*ѯpbϢܴ洢ô洢Ϣмϱ*/
typedef struct {
	char   locType[10];
	unsigned int  usedEntries;
	unsigned int  totalEntries;
} T_zPb_AtCpbsReadRes;
/*ѯpbϢȵϢмϱ*/
typedef struct {
	int  minIndex;
	int  maxIndex;
	int  maxNumberLen;
	int  maxTextLen;
	int  maxEmailLen;
} T_zPb_AtScpbrTestRes;
/************ƬϢӦĽṹend***********/

/************ccappϢӦĽṹbegin***********/
/*ӦϢMSG_CMD_ATD_DIAL_REQ*/
typedef struct {
	char    number[ZDIAL_NUM_MAX];
} T_zCcapp_CallMoReq;

/*ӦϢMSG_CMD_VTS_REQ*/
typedef struct {
	char    dtmfchar;
} T_zCcapp_VtsReq;

/*ӦϢMSG_CMD_ZIMSPLUS_REQ*/
typedef struct {
	unsigned int     setfg;
	unsigned int     act;
} T_zCcapp_ImsplusReq;

/*ӦϢMSG_CMD_CLCK_REQ*/
typedef struct {
	unsigned int     type;
	unsigned int     act;
	char     pw[5];
} T_zCcapp_ClckReq;

/*ӦϢMSG_CMD_CCFC_REQ*/
typedef struct {
	unsigned int     type;
	unsigned int     act;
	char     dn[ZDIAL_NUM_MAX];
} T_zCcapp_CcfcReq;

/*ӦϢMSG_CMD_CCFC_REQ*/
typedef struct {
	unsigned int     type;
} T_zCcapp_ChldReq;

/*ӦϢ */
typedef struct {
	int   result;
} T_zCcapp_optRsp;

/*ӦϢMSG_CMD_DSCI_IND*/
typedef struct {
	unsigned int     cid;
	unsigned int     dir;
	unsigned int     state;
	unsigned int     inMpty;
	char    num[ZDIAL_NUM_MAX];
} T_zCcApp_DsciInd;

/*ӦϢMSG_CMD_ZIMSPLUS_IND*/
typedef struct {
	unsigned int     act;
	unsigned int     rate;
} T_zCcApp_ImsplusInd;

/*ӦϢMSG_CMD_ZCPI*/
typedef struct {
	unsigned int     cid;
	unsigned int     state;
	unsigned int     progdsp;
} T_zCcApp_ZcpiInd;





/*ӦϢMSG_CMD_ZVOICECHNL*/
typedef struct {
	unsigned int     op; //0-close,1-open
	unsigned int     act; //   3-gsm,  5-w, 15-tds, 17-lte
	unsigned int     codetype; //0-nb, 1-wb
    	unsigned int     amrpath;  //0-teak, 1-softlib
} T_zCcApp_VoiceChnl;






/************ccappϢӦĽṹend***********/
#endif
