/**
 * @file sms_msg.h
 * @brief ϢӦöṩϢṹ壬Ҫʹ߰webservertro69Ӧ
 *
 * Copyright (C) 2017 Sanechips Technology Co., Ltd.
 * @author
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 *
 */
#ifndef __SMS_MSG_H__
#define __SMS_MSG_H__

#include "message.h"

enum sms_msg_cmd {
	MSG_CMD_COPY_SMS = MSG_CMD_SMS_BASE,//0x4100     /*ҳ淢͸ƶ*/
	MSG_CMD_SEND_SMS,//ӦṹT_zGoaheadMsgBuf
	MSG_CMD_DEL_SMS_BY_INDEX,//ӦṹT_zUfiSms_DelReq
	MSG_CMD_DEL_SMS_BY_TYPE,
	MSG_CMD_SMS_MODIFY_TAG,//ӦṹT_zGoaheadMsgBuf
	MSG_CMD_DRAFTS_SAVE,//ӦṹT_zGoaheadMsgBuf
	MSG_CMD_SMS_LOCATION_SET,//ӦṹT_zGoaheadMsgBuf
	MSG_CMD_SMS_OUTDATE_CHECK,//޲
	/***----MSG_CMD_SMS_END 0x4180 ϼ128-------*/
};

/************ϢϢӦĽṹbegin***********/
#define ZTE_MODEM_RELAY_MSGBUF_MAX_LEN 				600
#ifdef CONFIG_MIN_8M_VERSION
#define ZTE_WMS_DELETE_COUNT_MAX         20
#else
#define ZTE_WMS_DELETE_COUNT_MAX         100
#endif

typedef enum {
	ZTE_MC_STATE_TYPE,			//machine state maintain type
	ZTE_MDM_REALY_TYPE,		//mdm mode relay type
	ZTE_WAN_RELAY_TYPE,		//wan mode  relay type
	ZTE_LAN_RELAY_TYPE,			//lan mode relay type
	ZTE_SMS_RELAY_TYPE,			//shortmsg mode  relay type
	ZTE_PBM_RELAY_TYPE,			//phonebook mode relay type
	ZTE_ATSERVER_RELAY_TYPE,	//at server mode relay type
	ZTE_SLEEP_WAKEUP_RELAY_TYPE,		// relay sleep and wakeup  type
	ZTE_FOTA_RELAY_TYPE,          //fota modle relay type
	ZTE_USSD_RELAY_TYPE,		// relay USSDtype
	ZTE_AP_STATION_RELAY_TYPE,		// relay USSDtype
	ZTE_BUZZER_RELAY_TYPE,		//
	ZTE_MODE_RELAY_TYPE,		//
	ZTE_KEY_RELAY_TYPE		//
} zte_mc_msg_mode_e_type;

typedef struct {
	zte_mc_msg_mode_e_type type;
	unsigned long 		   id;
	int				       result;
} zte_mc_msg_hdr_s_type;

//MSG_CMD_SEND_SMS/MSG_CMD_SMS_MODIFY_TAG/MSG_CMD_DRAFTS_SAVEϢʹøò
typedef struct {
	zte_mc_msg_hdr_s_type  msg_hdr;				//the message header
	unsigned long 			msg_len;				//the message len
	unsigned char			   msg_data[ZTE_MODEM_RELAY_MSGBUF_MAX_LEN];   //the message data
} T_zGoaheadMsgBuf;


//MSG_CMD_DEL_SMS_BY_INDEXϢʹøò
typedef struct {
	unsigned char all_or_count;                        /*all_or_count=0--->delete all,others--->delete partial sms*/
	int id[ZTE_WMS_DELETE_COUNT_MAX];
	unsigned char sql[2];
} T_zUfiSms_DelReq;

/************ϢϢӦĽṹend***********/


//Դsms_com.hwebserverʹ

/**************************************************************************
* 
**************************************************************************/
#define ZTE_WMS_MESSAGE_LIST_MAX         255
#define ZTE_WMS_DB_EXECSQL_LEN           1024
#define ZTE_WMS_SEND_NUM_MAX             5
#define ZTE_WMS_ADDRESS_LEN_MAX          32
#define ZTE_WMS_SMS_COUNT_MAX            10
#define ZTE_WMS_DB_MSG_COUNT_MAX         (ZTE_WMS_DELETE_COUNT_MAX)
#define ZTE_WMS_CONCAT_SMS_COUNT_MAX     10
#define ZTE_WMS_SMS_MSG_CONTENT_LEN_MAX  160
#define ZTE_WMS_ADDRESS_DIGIT_MAX_V01  	 21


/**************************************************************************
* ݽṹ
**************************************************************************/
/* smsĲ */
typedef enum {
	WMS_SMS_CMD_NONE = 0,

	WMS_SMS_CMD_INIT,
	WMS_SMS_CMD_GET_MEM_CAPABILITY,

	WMS_SMS_CMD_CFG_SET_PARAMETERS,
	WMS_SMS_CMD_MSG_SEND,
	WMS_SMS_CMD_MSG_WRITE,
	WMS_SMS_CMD_MSG_DELETE,
	WMS_SMS_CMD_MSG_MODIFY_TAG,
	WMS_SMS_CMD_MSG_REPLY,

	WMS_SMS_CMD_SMS_INIT_LOAD,
	WMS_SMS_CMD_SMS_LOAD_COMPLETE,

	WMS_SMS_CMD_RECEIVE_MSG,
	WMS_SMS_CMD_SLEEP_WAKEUP,

	WMS_SMS_CMD_RESTORE,

	WMS_SMS_CMD_WMS_MAX
} T_zUfiSms_CmdType;

typedef enum {
	WMS_CMD_NONE = 0x00,
	WMS_CMD_PROCESSING,
	WMS_CMD_FAILED,
	WMS_CMD_SUCCESS,
	WMS_CMD_CONFLICT,        /*WHEN db data conflict with sim card or nv */
	WMS_CMD_STATUS_MAX = 0x1000
} T_zUfiSms_CmdStatus;


typedef enum {
	ZTE_SMS_CMS_NONE               = 0,
	ZTE_SMS_CMS_ME_FAILURE         = 300,
	ZTE_SMS_CMS_SERVICE_RESERVED   = 301,
	ZTE_SMS_CMS_OP_NOT_ALLOWED     = 302,
	ZTE_SMS_CMS_OP_NOT_SUPPORTED   = 303,
	ZTE_SMS_CMS_INVALID_PDU_PARAM  = 304,
	ZTE_SMS_CMS_INVALID_TXT_PARAM  = 305,
	ZTE_SMS_CMS_SIM_NOT_INSERTED   = 310,
	ZTE_SMS_CMS_SIM_PIN_REQ        = 311,
	ZTE_SMS_CMS_PHSIM_PIN_REQ      = 312,
	ZTE_SMS_CMS_SIM_FAILURE        = 313,
	ZTE_SMS_CMS_SIM_BUSY           = 314,
	ZTE_SMS_CMS_SIM_WRONG          = 315,
	ZTE_SMS_CMS_SIM_PUK_REQ        = 316,
	ZTE_SMS_CMS_SIM_PIN2_REQ       = 317,
	ZTE_SMS_CMS_SIM_PUK2_REQ       = 318,
	ZTE_SMS_CMS_MEM_FAILURE        = 320,
	ZTE_SMS_CMS_INVALID_INDEX      = 321,
	ZTE_SMS_CMS_MEM_FULL           = 322,
	ZTE_SMS_CMS_SCA_ADDR_UNKNOWN   = 330,
	ZTE_SMS_CMS_NO_SERVICE         = 331,
	ZTE_SMS_CMS_NETWORK_TIMEOUT    = 332,
	ZTE_SMS_CMS_CNMA_NOT_EXP       = 340,
	ZTE_SMS_CMS_UNKNOWN_ERR        = 500,
	ZTE_SMS_CMS_MAX                = 512
} T_zUfiSms_ErrorType;


//ǰ̵״̬Ϣ
typedef struct {
	T_zUfiSms_CmdType cmd; //ǰҵ̱ǣաɾ
	T_zUfiSms_CmdStatus cmd_status;
	T_zUfiSms_ErrorType err_code;
	int send_failed_count;
	int delete_failed_count;
} T_zUfiSms_StatusInfo;

/*޸Ĳ*/
typedef struct {
	unsigned char tags;
	unsigned int total_id;
	unsigned int type;
	unsigned int id[ZTE_WMS_DB_MSG_COUNT_MAX];
} T_zUfiSms_ModifyFlag;

typedef struct {
	unsigned char sca[ZTE_WMS_ADDRESS_DIGIT_MAX_V01 + 1];    /*read from the sim card,null terminated */
	unsigned int mem_store;            /*洢λã SimNv*/
	unsigned int tp_validity_period;                    /* [0,255], initial vaule=255 */
	unsigned int status_report_on;                        /*1-->open, 0-->close, initial vaue=0 */
	unsigned int sendfail_retry_on;                        /*1-->open, 0-->close, initial vaue=0 */
	unsigned int outdate_delete_on;                        /*1-->open, 0-->close, initial vaue=0 */
	unsigned char default_store[10];                        /*nv, sim, initial vaue=nv */
} zte_wms_parameter_info_s_type, T_zUfiSms_ParaInfo;


typedef struct {
	unsigned char year[5];
	unsigned char month[3];
	unsigned char day[3];
	unsigned char hour[3];
	unsigned char min[3];
	unsigned char sec[3];
	unsigned char timezone[4];//ʱҪʱЩ
} T_zUfiSms_Date;

/*  */
typedef struct {
	unsigned char receiver_count;
	unsigned char mem_store; //Ŵ洢λã򿨣NV
	unsigned char dest_num[ZTE_WMS_SEND_NUM_MAX][ZTE_WMS_ADDRESS_LEN_MAX + 1]; //ռ
	unsigned short msg_len;

	unsigned char dcs;  /* ʽ 1-->ASCII, 2-->UNICODE, 3-->GSM7 SPANISH, 4-->GSM7 DEFAULT, 5-->GSM7 PORTUGUESE*/
	unsigned char tags; /* շ״̬ */
	unsigned char isDelete;  //1ɾö

	long id; // ŵ,web½-1ݸеĶŷʱЯݿΪid
	T_zUfiSms_Date date;
	unsigned char draft_group_id[32]; //ݸʱʹ
} T_zUfiSms_SendReq, T_zUfiSms_SaveReq;


#endif
