#include <string.h>
#include <sys/ioctl.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <unistd.h>
#include <errno.h>
#include <sys/stat.h>
#include <pppoe.h>
#include <linux/ppp_defs.h>
#include <linux/if_pppox.h>
#include <linux/if_ppp.h>
#include <pppd.h>
#include <fsm.h>
#include <lcp.h>
#include <ipcp.h>
#include <ccp.h>
#include <pathnames.h>

extern int kill_link;
struct session *ses = NULL;
char	*pppoe_srv_name=NULL;
char	*pppoe_ac_name=NULL;
char    *hostuniq = NULL;
int     retries = 0;

#define PPPOE_MTU	1492
#define _PATH_ETHOPT         _ROOT_PATH "/etc/ppp/options."

int setdevname_pppoe(const char *cp);

extern int disc_sock;

static int std_rcv_pado(struct session* ses,
			struct pppoe_packet *p_in,
			struct pppoe_packet **p_out){

    
    if(ses->state != PADO_CODE ){
	return 0;
    }
    
    if( verify_packet(ses, p_in) < 0)
	return 0;

    char ac[1024], srv[1024];
    struct pppoe_tag *ac_name, *srv_name;
	
    sc_cfg_set("pppoe_reply","1");
    
    memcpy(&ses->remote, &p_in->addr, sizeof(struct sockaddr_ll));
    memcpy(&ses->curr_pkt.addr, &ses->remote , sizeof(struct sockaddr_ll));
    
    ses->curr_pkt.hdr->code = PADR_CODE;
    copy_tag(&ses->curr_pkt,get_tag(p_in->hdr,PTT_HOST_UNIQ));	
    
    if (ses->filt->ntag) {
    	ses->curr_pkt.tags[TAG_AC_NAME]=NULL;
    }
    
    srv_name = get_tag(p_in->hdr,PTT_SRV_NAME);
    ac_name = get_tag(p_in->hdr,PTT_AC_NAME);

    memset(srv, 0, sizeof(srv)); 	 
    memset(ac, 0, sizeof(ac)); 	 
    
    strncpy(srv, srv_name->tag_data, ntohs(srv_name->tag_len));
    strncpy(ac, ac_name->tag_data, ntohs(ac_name->tag_len));

    script_setenv("SRV_NAME", srv, 1);
    script_setenv("AC_NAME", ac, 1);
    
    if(ses->filt->stag) {
    	ses->curr_pkt.tags[TAG_SRV_NAME]=NULL;
    }
    copy_tag(&ses->curr_pkt,get_tag(p_in->hdr,PTT_AC_COOKIE));
    copy_tag(&ses->curr_pkt,get_tag(p_in->hdr,PTT_SRV_NAME));
    copy_tag(&ses->curr_pkt,get_tag(p_in->hdr,PTT_RELAY_SID));
    
    ses->retransmits = 0;
    ses->state = PADS_CODE;
    send_disc(ses, &ses->curr_pkt);
    (*p_out) = &ses->curr_pkt;
    
    if (!ses->np)
    {
		return 0;
	}
	else
	{
	    return 1;
	}
}

static int std_init_disc(struct session* ses,
			 struct pppoe_packet *p_in,
			 struct pppoe_packet **p_out){
    
    if( ses->state != PADO_CODE ){
	return -1;
    }
    
    memset(&ses->curr_pkt,0, sizeof(struct pppoe_packet));

    ses->curr_pkt.hdr = (struct pppoe_hdr*) ses->curr_pkt.buf;
    ses->curr_pkt.hdr->ver  = 1;
    ses->curr_pkt.hdr->type = 1;
    ses->curr_pkt.hdr->code = PADI_CODE;
    
    
    memcpy( &ses->curr_pkt.addr, &ses->remote , sizeof(struct sockaddr_ll));
    ses->retransmits = 0 ;
    if(ses->filt->stag)
	ses->curr_pkt.tags[TAG_SRV_NAME]=ses->filt->stag;
    if(ses->filt->ntag)
	ses->curr_pkt.tags[TAG_AC_NAME]=ses->filt->ntag;
    if(ses->filt->htag)
	ses->curr_pkt.tags[TAG_HOST_UNIQ]=ses->filt->htag;
    ses->retransmits = 0 ;
    send_disc(ses, &ses->curr_pkt);
    (*p_out)= &ses->curr_pkt;

    return 0;
}


static int std_rcv_pads(struct session* ses,
			struct pppoe_packet *p_in,
			struct pppoe_packet **p_out){
    if(ses->state != PADS_CODE ){
	return 0;
    }
    
    if( verify_packet(ses, p_in) < 0)
	return 0;
    
    ses->sp.sa_addr.pppoe.sid = p_in->hdr->sid;
    ses->sp.sa_protocol = PX_PROTO_OE;
    ses->sp.sa_family = AF_PPPOX;
    memcpy(ses->sp.sa_addr.pppoe.remote, p_in->addr.sll_addr, ETH_ALEN);
    memcpy(ses->sp.sa_addr.pppoe.dev,ses->name, IFNAMSIZ);
    
    return 1;
}

static int std_rcv_padt(struct session* ses,
			struct pppoe_packet *p_in,
			struct pppoe_packet **p_out){
    ses->state = PADO_CODE;
    return 0;
}

int retry_num = 10;

static int connect_pppoe_ses(void)
{
    int err=-1;

    client_init_ses(ses,devnam);

    strlcpy(ppp_devnam, devnam, sizeof(ppp_devnam));

    err= session_connect ( ses );
    if(err < 0){
    }
    err = connect(ses->fd, (struct sockaddr*)&ses->sp,
		  sizeof(struct sockaddr_pppox));

    if( err < 0 ){
	return err;
    }
    /* Once the logging is fixed, print a message here indicating
       connection parameters */

    return ses->fd;
}

static void disconnect_pppoe_ses(void)
{
    int ret;
    printf("Doing disconnect");
    session_disconnect(ses);
    ses->sp.sa_addr.pppoe.sid = 0;
    ret = connect(ses->fd, (struct sockaddr*)&ses->sp,
	    sizeof(struct sockaddr_pppox));
}

static void init_device_pppoe(void)
{
    struct filter *filt;
    ses=(void *)malloc(sizeof(struct session));
    if(!ses){
	printf("No memory for new PPPoE session");
    }
    memset(ses,0,sizeof(struct session));

    if ((ses->filt=malloc(sizeof(struct filter))) == NULL) {
	return;
    }

    filt=ses->filt;  /* makes the code more readable */
    memset(filt,0,sizeof(struct filter));

    if (pppoe_ac_name !=NULL) {
	if (strlen (pppoe_ac_name) > 255) {
	    return;
	}
	ses->filt->ntag = make_filter_tag(PTT_AC_NAME,
					  strlen(pppoe_ac_name),
					  pppoe_ac_name);

	if ( ses->filt->ntag== NULL) {
	    return;
	}

    }


    if (pppoe_srv_name !=NULL) {
	if (strlen (pppoe_srv_name) > 255) {
	    return;
	}
	ses->filt->stag = make_filter_tag(PTT_SRV_NAME,
					  strlen(pppoe_srv_name),
					  pppoe_srv_name);
	if ( ses->filt->stag == NULL) {
	    return;
	}
    }

    if (hostuniq) {
	ses->filt->htag = make_filter_tag(PTT_HOST_UNIQ,
					  strlen(hostuniq),
					  hostuniq);
	if ( ses->filt->htag == NULL) {
	    return;
	}
    }

    if (retries) {
	ses->retries=retries;
    }
    memcpy( ses->name, devnam, IFNAMSIZ);
    ses->opt_debug=1;
    ses->fd = -1;
}

static void send_config_pppoe(int mtu,
			      u_int32_t asyncmap,
			      int pcomp,
			      int accomp)
{
    int sock;
    struct ifreq ifr;

    if (mtu > PPPOE_MTU)
	printf("Couldn't increase MTU to %d", mtu);
    sock = socket(AF_INET, SOCK_DGRAM, 0);
    if (sock < 0)
	printf("Couldn't create IP socket: %m");
    strlcpy(ifr.ifr_name, ifname, sizeof(ifr.ifr_name));
    ifr.ifr_mtu = mtu;
    if (ioctl(sock, SIOCSIFMTU, (caddr_t) &ifr) < 0)
	printf("ioctl(SIOCSIFMTU): %m");
    (void) close (sock);
}

int client_init_ses (struct session *ses, char* devnam)
{
  int retval;
  char dev[IFNAMSIZ+1];
  int addr[ETH_ALEN];
  int sid;
  
  if( disc_sock < 0 ){
  
  disc_sock = socket(PF_PACKET, SOCK_DGRAM, 0);
  if( disc_sock < 0 ){
  }
  
  }
  
  retval =sscanf(devnam, FMTSTRING(IFNAMSIZ),addr, addr+1, addr+2,
		 addr+3, addr+4, addr+5,&sid,dev);
  if( retval != 8 ){
  retval = get_sockaddr_ll(devnam,&ses->local);
  if (retval < 0)
  {}
  
  
  ses->state = PADO_CODE;
  memcpy(&ses->remote, &ses->local, sizeof(struct sockaddr_ll) );
  
  memset( ses->remote.sll_addr, 0xff, ETH_ALEN);
  }
  else
  {
  retval = get_sockaddr_ll(dev,&ses->local);
  if (retval < 0)
  {}
  ses->state = PADS_CODE;
  ses->sp.sa_family = AF_PPPOX;
  ses->sp.sa_protocol = PX_PROTO_OE;
  ses->sp.sa_addr.pppoe.sid = sid;
  
  memcpy(&ses->remote, &ses->local, sizeof(struct sockaddr_ll) );
  int i=0;
  for(; i < ETH_ALEN ; ++i ){
	  ses->sp.sa_addr.pppoe.remote[i] = addr[i];
	  ses->remote.sll_addr[i]=addr[i];
  }
  memcpy(ses->sp.sa_addr.pppoe.dev, dev, IFNAMSIZ);
  
  
  
  }
  if( retval < 0 )
  {}
  retval = bind( disc_sock ,
		 (struct sockaddr*)&ses->local,
		 sizeof(struct sockaddr_ll));
  if( retval < 0 ){
  }
  if (ses->fd < 0) {
	  ses->fd = socket(AF_PPPOX,SOCK_STREAM,PX_PROTO_OE);
	  if(ses->fd < 0)
	  {
	  }
  }
  ses->init_disc = std_init_disc;
  ses->rcv_pado  = std_rcv_pado;
  ses->rcv_pads  = std_rcv_pads;
  ses->rcv_padt  = std_rcv_padt;
  ses->retries = retry_num;
  return ses->fd;
}


static void recv_config_pppoe(int mru,
			      u_int32_t asyncmap,
			      int pcomp,
			      int accomp)
{
    if (mru > PPPOE_MTU)
	printf("Couldn't increase MRU to %d", mru);
}

struct channel pppoe_channel;
/* Check is cp is a valid ethernet device
 * return either 1 if "cp" is a reasonable thing to name a device
 * or die.
 * Note that we don't actually open the device at this point
 * We do need to fill in:
 *   devnam: a string representation of the device
 */

int (*old_setdevname_hook)(const char* cp) = NULL;
int setdevname_pppoe(const char *cp)
{
    int ret;
    char dev[IFNAMSIZ+1];
    int addr[ETH_ALEN];
    int sid;
    option_t *opt;

    ret =sscanf(cp, FMTSTRING(IFNAMSIZ),addr, addr+1, addr+2,
		addr+3, addr+4, addr+5,&sid,dev);
    if( ret != 8 ){

	ret = get_sockaddr_ll(cp,NULL);
        if (ret < 0)
	    printf("Cannot create PF_PACKET socket for PPPoE discovery\n");
	if (ret == 1)
	    strncpy(devnam, cp, sizeof(devnam));
    }else{
	/* long form parsed */
	ret = get_sockaddr_ll(dev,NULL);
        if (ret < 0)
	    printf("Cannot create PF_PACKET socket for PPPoE discovery\n");

	strncpy(devnam, cp, sizeof(devnam));
	ret = 1;
    }

    if( ret == 1 && the_channel != &pppoe_channel ){

	the_channel = &pppoe_channel;

	lcp_allowoptions[0].neg_accompression = 0;
	lcp_wantoptions[0].neg_accompression = 0;

	lcp_allowoptions[0].neg_asyncmap = 0;
	lcp_wantoptions[0].neg_asyncmap = 0;

	lcp_allowoptions[0].neg_pcompression = 0;
	lcp_wantoptions[0].neg_pcompression = 0;

	ipcp_allowoptions[0].neg_vj=0;
	ipcp_wantoptions[0].neg_vj=0;

	ipcp_allowoptions[0].default_route=1;
	
	/* remove for add -R parameter set default route. by tallest.*/
	//ipcp_wantoptions[0].default_route=0;
	
	for (opt = ipcp_protent.options; opt->name != NULL; ++opt) {
		if (!strncmp(opt->name, "usepeerdns", 10)) {
			*(bool *)(opt->addr) = 1;
			break;
		}
	}
	init_device_pppoe();
    }
    return ret;
}

struct channel pppoe_channel = {
    options: NULL,
    process_extra_options: NULL,
    check_options: NULL,
    connect: &connect_pppoe_ses,
    disconnect: &disconnect_pppoe_ses,
    establish_ppp: &generic_establish_ppp,
    disestablish_ppp: &generic_disestablish_ppp,
    send_config: &send_config_pppoe,
    recv_config: &recv_config_pppoe,
    close: NULL,
    cleanup: NULL
};

