/**
 * @file at_socmsg.c
 * @brief at_ctl˼ϢͨŵĽӿʵ
 *
 * Copyright (C) 2017 Sanechips Technology Co., Ltd.
 * @author 
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation. 
 *
 */
#ifdef MULTI_CPU
/*******************************************************************************
 *                           Include header files                              *
 ******************************************************************************/
#include "at_com.h"
#include "at_context.h"
#include "at_utils.h"
#include "softap_api.h"
#include "syncnv.h"
#include "at_register.h"
#include "ps_normal.h"
#include "ps_pdp.h"
#include "mnet_whitelist.h"
/*******************************************************************************
 *                             Macro definitions                               *
 ******************************************************************************/
#define MAX_SOC_MSG_HEAD_LEN  32   //+MSGͷ󳤶 \r\n+MSG:targetid,msgid,msglen\r\n
/*******************************************************************************
 *                             Type definitions                                *
 ******************************************************************************/
/*******************************************************************************
 *                        Local function declarations                          *
 ******************************************************************************/
/*******************************************************************************
 *                         Local variable definitions                          *
 ******************************************************************************/
/*******************************************************************************
 *                        Global variable definitions                          *
 ******************************************************************************/
/*******************************************************************************
 *                      Local function implementations                         *
 ******************************************************************************/
/*******************************************************************************
 *                      Global function implementations                        *
 ******************************************************************************/
extern char PsmIndAtCmdPrefix[AT_CMD_MAX];
extern void ext_reset_proc();
extern void ztcard_msg_proc(char *at_paras);
extern void zusbflag_stat_proc(char *at_paras);
/*˼ϢʵֽӿڣsocϢװ+MSG˼ͨ*/
int at_socmsg_write(int at_fd,int src_id,int targetId, unsigned short msg_id, unsigned short len, unsigned char *msg)
{
    char *pAtcmdStr = NULL;
	char *dstMsg = NULL;
	int atcmdlen = 0;
	int ret = 0;
	atcmdlen = len*2 + MAX_SOC_MSG_HEAD_LEN;

	if(atcmdlen >= AT_CMD_MAX*2)
		softap_assert("");
	pAtcmdStr = malloc(atcmdlen+1);
	if(pAtcmdStr == NULL)softap_assert("");
	memset(pAtcmdStr, 0x00, atcmdlen+1);

	if(len > 0)//socϢݲΪʱ+MSGĸϢ
	{
		dstMsg = malloc(len*2+1);
		if(dstMsg == NULL)softap_assert("");
		memset(dstMsg, 0x00, len*2+1);

		bytes2string(msg, dstMsg, len);
		snprintf(pAtcmdStr, atcmdlen+1, "\r\n+MSG:%d,%d,%d,%d,\"%s\"\r\n",src_id,targetId, msg_id, len, dstMsg);
		free(dstMsg);
	}
	else//socϢݲΪʱ+MSGϢ
	{
		snprintf(pAtcmdStr, atcmdlen+1, "\r\n+MSG:%d,%d,%d,%d\r\n",src_id,targetId, msg_id, len);
	}
	ret = at_context_write_data(at_fd, pAtcmdStr, strlen(pAtcmdStr));
   	at_print(AT_NORMAL,"[SOC]soc_app_msg_proc: at_write at_str = %s  fd=%d ret =%d\n",pAtcmdStr, at_fd, ret);    
	if(MSG_CMD_SYNC_ATCMD_STREAM == msg_id)//оƬ֤
	{
		at_print(AT_ERR,"$$$$$send len=%d,ret=%d,str=%s\n",strlen(pAtcmdStr), ret, pAtcmdStr);
	}
	free(pAtcmdStr);
	return ret;	
}
/**
 * @brief ˼ӦϢͽӿ
 * @param 
 * @return 
 * @note   
 * @warning 
 */
int at_socmsg_write_msg(int at_fd,int src_id,int targetId, unsigned short msg_id, unsigned short len, unsigned char* msg)
{
    int msglen = len;

    switch(msg_id)
    {
    /*ܻcpದҪ֪ͨapBL͵socϢcidҪat_ctl
	cidȡipַĬغDNSַȻ·װsocϢap*/
    case MSG_CMD_DATASWITCH_ON_REQ:
        {
            int cur_cid = atoi(msg);
            struct pdp_active_info *info = get_pdpinfo_bycid(cur_cid);//cidȡipַĬغDNSַ
            if(info == NULL)
            {
                at_print(AT_ERR,"ERR: zphone_dataswitchon_act: pdpinfo is null, cid %d is deacted by core network\n");
                return NULL;
            }
            msg = malloc(512);
            if(NULL == msg)
                softap_assert("");
            memset(msg, 0x00, 512);
            msglen = build_ipdns_param(msg, info);//ݻȡipַĬغDNSַ·װsocϢ
        }
        break;
    default:
        break;
    }
    return at_socmsg_write(at_fd,src_id,targetId, msg_id, msglen, msg);//˼ͨд˼Ϣ
}

/*յĺ˼Ϣ תΪϢ͸Ӧģ*/
int at_socmsg_trans_and_write(void * at_paras, int paras_len)
{
    int src_id = 0;
	int targetid = 0;
    int msgid = 0;
    int len = 0;
    char socMsg[AT_CMD_MAX*2] = {0};
    unsigned char dstMsg[AT_CMD_MAX] = {0};
    void *p[5] = {&src_id,&targetid, &msgid, &len, socMsg};
    int parse_return_num = 0;
	MSG_BUF *buf=NULL;
	
    parse_return_num = parse_param2("%d,%d,%d,%d,%s",at_paras,p);
    if(parse_return_num == 5)
    {
        string2bytes(socMsg, dstMsg, strlen(socMsg));
    }

	/*Ϣat_ctlֱӵӦĴҪӦô*/
    switch (msgid)
    {
	    case MSG_CMD_SYNC_NV_REQ://˷͵NVͬϢ
	        sync_nv_proc(dstMsg);
	        return 1;
		case MSG_CMD_SYNC_ATCMD_STREAM:	//оƬ֤
			proc_sync_atcmd_stream(dstMsg);
			return 1;
	    case MSG_CMD_DATASWITCH_ON_REQ://ܻCPݿ()֪ͨAPϢ
	        znetifup_proc(dstMsg);
	        return 1;
	    case MSG_CMD_DATASWITCH_OFF_REQ://ܻCPݿ(ȥ)֪ͨAPϢ
	        znetifdown_proc(dstMsg);
	        return 1;
	    case MSG_CMD_AT_FILTER_REQ://AP֪ͨCPҪϱATϢ
	    {
		    if(strlen(dstMsg) == 0)
				sc_cfg_set("customIndCmdList","");
			else			
				sc_cfg_set("customIndCmdList",dstMsg);	
	        sc_cfg_save(); 
	        return 1;
	    }
	    case MSG_CMD_ISMSSTART_REQ://ܻCP֪ͨAPܶŽ̵Ϣ
	        at_ctl_startisms();
	        return 1;
	    case MSG_CMD_RESET_NOTIFY://ָϢ
	        ext_reset_proc();
	        return 1;
#ifdef _USE_BL
	    case MSG_CMD_UDISKSTAT_SET_RSP://TлϢ
	        //ztcard_msg_proc(dstMsg);
	        return 1;
	    case MSG_CMD_USBFLAG_STAT_REQ://USBϢ
	        //zusbflag_stat_proc(dstMsg);
	        return 1;
#endif
		case MSG_CMD_ADD_MNET_WHITELIST:
			mnet_whitelist_insert(dstMsg);
			return 1;
		case MSG_CMD_DEL_MNET_WHITELIST:
			mnet_whitelist_delete(dstMsg);
			return 1;
		case MSG_CMD_CLEAR_MNET_WHITELIST:
			strcpy(PsmIndAtCmdPrefix, "");			
			sc_cfg_set("customIndCmdList", PsmIndAtCmdPrefix);
			sc_cfg_save();
			return 1;
		case MSG_CMD_GET_MNET_WHITELIST:
			mnet_whitelist_fetch();
			return 1;

    }
  
    at_print(AT_NORMAL,"[SOC]at_socmsg_trans_and_write: send msg=%x, module=%x \n",msgid, targetid);
	/*at_ctlܴsocϢֱӷӦӦô*/
    ipc_send_message(src_id, targetid, msgid, len, (unsigned char *)dstMsg,0);
    return 1;

}
#endif

