#include "zte_drv_serial_ctrl.h"
//add for cmux
#include <sys/socket.h>
#include <linux/if.h>
#include <linux/gsmmux.h>
#include <linux/netlink.h>
#include <poll.h>
#include <linux/serial.h>
#include <termios.h>
//#include "../../../linux-3.4.x/include/generated/autoconf.h"
#include "nv_api.h"
#include "softap_api.h"

#define PCS_REPLY_OK       "\r\nOK\r\n"
//ĿǰCMUXͨΪ3ҪչıMAX_DLCI_NUM 
#define MAX_DLCI_NUM      3	

typedef enum{
    AUTO_MODE,
    SET_MODE
}USB_PORT_MODE;

static int writefile(char*path, char*buf, unsigned len)
{
    FILE *fp;
    int rtv = 0;
    if((fp=fopen(path,"w"))==NULL)
    {
        return -1;
    }
    rtv = fwrite(buf,len,1, fp);
    fclose(fp);
    return rtv;
}

typedef struct TAG_PCS_USB_INFO
{
    char cPrompt;      // prompt after reciving data
    int32_t iBaudrate; // baudrate
    char cDatabit;     // data bits, 5, 6, 7, 8
    char cDebug;       // debug mode, 0: none, 1: debug
    char cEcho;        // echo mode, 0: none, 1: echo
    char cFctl;        // flow control, 0: none, 1: hardware, 2: software
    char cTty;         // tty: 0, 1, 2, 3, 4, 5, 6, 7
    char cParity;      // parity 0: none, 1: odd, 2: even
    char cStopbit;     // stop bits, 1, 2
    int32_t iReserved; // reserved, must be zero
}T_PCS_USB_INFO, *PT_PCS_USB_INFO;

struct at_cmux_req
{
    char name[32];
	#if 1
    int cmux_mode;		///߼ģʽ
    int subset;			//֡ʽ
    int port_speed;		//cmux
    int frame_len;		//֡(N1)
    int ack_time;		//ȷʱ(T1)
    int recon_count;	//(N2)
    int resp_time;		//Ӧʱ(T2)
    int awak_time;		//ʱ(T3)
    int win_size;		//ڴС
    #endif
};


char g_selfAdaptionPort[32] = {0};
char notify_forbid_dev[32] = {0};//some port doesn't need notify application 

char g_mux_main_port[32] = {0};
char g_cmux_port[MAX_DLCI_NUM][32] = {0};		//һͨ
unsigned int uart_baud_for_cmux;
T_PCS_USB_INFO s_tUsbInfo = {'0',115200,'8','0','0','0','0','0','1',0 };

#define UART_AUTOBAUD_LEVEL 	5
#define UART_AUTOBAUD_CHECKBYTE 4
#define FALSE 0
#define TRUE 1

//˱ֻ߲Ϊ115200ʱƥ115200Ĳ
unsigned char UART_baud_check[UART_AUTOBAUD_LEVEL][UART_AUTOBAUD_CHECKBYTE]={
		{0x61,0x74,0x41,0x54},{0x06,0x9e,0x06,0x98},{0x1c,0x80,0x1c,0x00},
		{0xe0,0x00,0xe0,0x00},{0x00,0x00,0x00,0x00},
};
unsigned int UART_baud[UART_AUTOBAUD_LEVEL] ={
		115200,57600,38400,19200,9600
};

int BaudSelfAdaptionList(char *strTempStr)
{
    int i,j;
    for(i=0;i<UART_AUTOBAUD_LEVEL;i++)
    {
        for(j=0;j<UART_AUTOBAUD_CHECKBYTE;j++)
        {	
            if((j == 0)&&(strTempStr[0] == UART_baud_check[i][j]))
            {
                j++;
                if(strTempStr[1] == UART_baud_check[i][j])
                {
                    return UART_baud[i];
                }
            }
            if((j == 2 )&&(strTempStr[0] == UART_baud_check[i][j]))
            {
                j++;
                if(strTempStr[1] == UART_baud_check[i][j])
                {
                    return UART_baud[i];       
                }
            }
        }
    }
	return 0;
}


// תת
int32_t com_Convbaud(int32_t iBaudrate)
{
    switch(iBaudrate)
    {
        case 0:
            return B0;
        case 50:
            return B50;
        case 75:
            return B75;
        case 110:
            return B110;
        case 134:
            return B134;
        case 150:
            return B150;
        case 200:
            return B200;
        case 300:
            return B300;
        case 600:
            return B600;
        case 1200:
            return B1200;
        case 1800:
            return B1800;
        case 2400:
            return B2400;
        case 4800:
            return B4800;
        case 9600:
            return B9600;
        case 19200:
            return B19200;
        case 38400:
            return B38400;
        case 57600:
            return B57600;
        case 115200:
            return B115200;
        case 230400:
            return B230400;
        case 460800:
            return B460800;
        case 500000:
            return B500000;
        case 576000:
            return B576000;
        case 921600:
            return B921600;
        case 1000000:
            return B1000000;
        case 1152000:
            return B1152000;
        case 1500000:
            return B1500000;
        case 2000000:
            return B2000000;
        case 2500000:
            return B2500000;
        case 3000000:
            return B3000000;
        case 3500000:
            return B3500000;
        case 4000000:
            return B4000000;
        default:
            return B115200;
    }
}

// ʷתת
static int32_t iFnBaudconv(int32_t Baudrate)
{
    switch(Baudrate)
    {
        case B2400:
            return 2400;
        case B4800:
            return 4800;
        case B9600:
            return 9600;
        case B19200:
            return 19200;
        case B38400:
            return 38400;
        case B57600:
            return 57600;
        case B115200:
            return 115200;
        default:
            return 115200;
    }
}

/*
 *return value, 0: success
 *                  -EINVAL: baud is specil, should call  com_Set_SpeciBaud
 * 
 */
static int  com_SetBaud(int32_t iFdCom,int nSpeed)
{
    struct termios tOldTermios = {0};
	int32_t iBaudrate = 0;
    bzero(&tOldTermios, sizeof(tOldTermios));
	
    tcgetattr(iFdCom, &tOldTermios); // get the serial port attributions
    
	iBaudrate = com_Convbaud(nSpeed);
	if(iBaudrate == B115200 && nSpeed != 115200){
		//got specil baud, not standerd
		slog(DRVCOMMNG_PRINT,SLOG_ERR,"the baud set is not standerd, please call other function to set \n");
		return -EINVAL;
	}
	tcflush(iFdCom, TCIOFLUSH);
	cfsetispeed(&tOldTermios, iBaudrate); //봮˲
	cfsetospeed(&tOldTermios, iBaudrate); //봮˲
	if(tcsetattr(iFdCom, TCSANOW, &tOldTermios) != 0)  //, TCSANOW: ɸıЧ
	{	
        slog(DRVCOMMNG_PRINT,SLOG_ERR,"Set vFnSetBaud error. iFd == %d\n", iFdCom);
		return -EPERM;
	}
	tcflush(iFdCom, TCIOFLUSH);	

	return 0;

}



static int com_Set_SpeciBaud(int32_t iFdCom,int nSpeed)
{
    struct termios tOldTermios = {0};
	struct serial_struct ss, ss_set;
	int32_t iBaudrate = 0;
    bzero(&tOldTermios, sizeof(tOldTermios));
	
    tcgetattr(iFdCom, &tOldTermios); // get the serial port attributions
    
	cfsetispeed(&tOldTermios, B38400); //봮˲
	cfsetospeed(&tOldTermios, B38400); //봮˲
	tcflush(iFdCom, TCIOFLUSH);
	
	if(tcsetattr(iFdCom, TCSANOW, &tOldTermios) != 0)  //, TCSANOW: ɸıЧ
	{	
        slog(DRVCOMMNG_PRINT,SLOG_ERR,"Set vFnSetBaud error. iFd == %d\n", iFdCom);
		return -EPERM;
	}
	if((ioctl(iFdCom, TIOCGSERIAL, &ss)) < 0)
	{
		slog(DRVCOMMNG_PRINT,SLOG_ERR,"BAUD: error to get the serial_struct info:%s\n", strerror(errno));
		return -EPERM;
	}
	
	
	ss.flags = ASYNC_SPD_CUST;
	ss.custom_divisor = ss.baud_base / nSpeed;
	if((ioctl(iFdCom, TIOCSSERIAL, &ss)) < 0)
	{
		slog(DRVCOMMNG_PRINT,SLOG_ERR,"BAUD: error to set serial_struct:%s\n", strerror(errno));
		return -ENOENT;
	}
		
	if(ioctl(iFdCom, TIOCGSERIAL, &ss_set) < 0) // cov M CHECKED_RETURN
	{
	    slog(DRVCOMMNG_PRINT,SLOG_ERR,"ioctl fail\n");
	}
	slog(DRVCOMMNG_PRINT,SLOG_DEBUG,"BAUD: success set baud to %d,custom_divisor=%d,baud_base=%d\n",
		  nSpeed, ss_set.custom_divisor, ss_set.baud_base);
	
	tcflush(iFdCom, TCIOFLUSH);	
	return 0;

}



static void com_SetnBit(int32_t iFdCom, int nBits)
{
    struct termios tOldTermios = {0};

    bzero(&tOldTermios, sizeof(tOldTermios));
	
    tcgetattr(iFdCom, &tOldTermios); // get the serial port attributions

	switch( nBits )
    {
    case 7:
        tOldTermios.c_cflag |= CS7;
        break;
    case 8:
	default:	
        tOldTermios.c_cflag |= CS8;
        break;
    }
	
	if(tcsetattr(iFdCom, TCSANOW, &tOldTermios) != 0)  //, TCSANOW: ɸıЧ
	{	
        slog(DRVCOMMNG_PRINT,SLOG_ERR,"Set vFnSetnBit error. iFd == %d\n", iFdCom);
		return;
	}
	tcflush(iFdCom, TCIOFLUSH);

}

static void com_SetParity(int32_t iFdCom,char nEvent)
{
    struct termios tOldTermios = {0};

    bzero(&tOldTermios, sizeof(tOldTermios));
	
    tcgetattr(iFdCom, &tOldTermios); // get the serial port attributions
    switch( nEvent )
    {
    case 'O':                     //У
        tOldTermios.c_cflag |= PARENB;
        tOldTermios.c_cflag |= PARODD;
        tOldTermios.c_iflag |= (INPCK | ISTRIP);
        break;
    case 'E':                     //żУ
        tOldTermios.c_iflag |= (INPCK | ISTRIP);
        tOldTermios.c_cflag |= PARENB;
        tOldTermios.c_cflag &= ~PARODD;
        break;
    case 'N':                    //У
    default:
		tOldTermios.c_cflag &= ~PARENB;
        break;
    }
	if(tcsetattr(iFdCom, TCSANOW, &tOldTermios) != 0)  //, TCSANOW: ɸıЧ
	{	
       slog(DRVCOMMNG_PRINT,SLOG_ERR,"Set vFnSetParity error. iFd == %d\n", iFdCom);
		return;
	}
	tcflush(iFdCom, TCIOFLUSH);

}

static void com_SetnStop(int32_t iFdCom, int nStop)
{
    struct termios tOldTermios = {0};

    bzero(&tOldTermios, sizeof(tOldTermios));
	
    tcgetattr(iFdCom, &tOldTermios); // get the serial port attributions


    switch( nStop )
    {
    case 1:                    
        tOldTermios.c_cflag &=  ~CSTOPB;
        break;
    case 2:  
		tOldTermios.c_cflag |=  CSTOPB;
		break;
    default:
		 tOldTermios.c_cflag &=  ~CSTOPB;
		break;
    }
	if(tcsetattr(iFdCom, TCSANOW, &tOldTermios) != 0)  //, TCSANOW: ɸıЧ
	{	
        slog(DRVCOMMNG_PRINT,SLOG_ERR,"Set vFnSetnStop error. iFd == %d\n", iFdCom);
		return;
	}
	tcflush(iFdCom, TCIOFLUSH);

}
//ǷԹܡ1:
static void com_SetEcho(int32_t iFdCom, int isEcho)
{
    struct termios tOldTermios = {0};

    bzero(&tOldTermios, sizeof(tOldTermios));
	
    tcgetattr(iFdCom, &tOldTermios); // get the serial port attributions


    if(isEcho == 1) {
		tOldTermios.c_lflag = (ICANON | ECHO | ECHOE | ISIG); 
    } else {   
		tOldTermios.c_lflag &= ~(ICANON | ECHO | ECHOE | ISIG);
    }
	
	if(tcsetattr(iFdCom, TCSANOW, &tOldTermios) != 0)  //, TCSANOW: ɸıЧ
	{	
       	slog(DRVCOMMNG_PRINT,SLOG_ERR,"Set vFnSetEcho error. iFd == %d\n", iFdCom);
		return;
	}
	tcflush(iFdCom, TCIOFLUSH);

}
//Ӳ
static void com_SetCtrl(int32_t iFdCom, int nCtrl)
{
    struct termios tOldTermios = {0};

    bzero(&tOldTermios, sizeof(tOldTermios));
	
    tcgetattr(iFdCom, &tOldTermios); // get the serial port attributions

	switch(nCtrl)
	{
	case 0:
		{
			tOldTermios.c_cflag &= ~CRTSCTS;        //no flow control
			tOldTermios.c_iflag |= IGNBRK | IGNPAR;
		}break;
	case 1:
		{
			tOldTermios.c_cflag |= CRTSCTS;         //hardware flow control
		}break;
	case 2:
		{
			tOldTermios.c_iflag |= IXON | IXOFF | IXANY;    //software flow control
		}break;
	default:
		break;
	}
	
	if(tcsetattr(iFdCom, TCSANOW, &tOldTermios) != 0)  //, TCSANOW: ɸıЧ
	{	
       	 slog(DRVCOMMNG_PRINT,SLOG_ERR,"Set vFnSetCtrl error. iFd == %d\n", iFdCom);
		return;
	}
	tcflush(iFdCom, TCIOFLUSH);

	  slog(DRVCOMMNG_PRINT,SLOG_DEBUG,"Set vFnSetCtrl end\n");

}
void com_set_portInfo(int32_t iFdCom,int nSpeed, int nBits, char nEvent, int nStop, int i)
{
	com_SetBaud(iFdCom, nSpeed);
	com_SetnBit(iFdCom, nBits);
	com_SetParity(iFdCom, nEvent);
	com_SetnStop(iFdCom,nStop); 
	com_SetCtrl(iFdCom,i); 
}


// ö˿ϢiFdCom: ļ, ptPortInfo: õĶ˿Ϣ
void vFnSetUsbInfo(int32_t iFdCom, const PT_PCS_USB_INFO ptPortInfo, USB_PORT_MODE usbPortMode)
{
    struct termios tOldTermios = {0}, tNewTermios = {0};
    int32_t iBaudrate = 0;
    char cDatabit = 0, cStopbit = 0, cParity = 0, cFctl = 0;

    bzero(&tOldTermios, sizeof(tOldTermios));
    bzero(&tNewTermios, sizeof(tNewTermios));
    cfmakeraw(&tNewTermios);
    tcgetattr(iFdCom, &tOldTermios); // get the serial port attributions
    /*------------ö˿----------------*/
	if(usbPortMode == AUTO_MODE)
	{
	    //iBaudrate = cfgetispeed(&tOldTermios);
	    iBaudrate = com_Convbaud(ptPortInfo->iBaudrate);
        tcflush(iFdCom, TCIOFLUSH);
	}
	else
	{
        iBaudrate = com_Convbaud(ptPortInfo->iBaudrate);
        tcflush(iFdCom, TCIOFLUSH);
        cfsetispeed(&tOldTermios, iBaudrate); //봮˲
        cfsetospeed(&tOldTermios, iBaudrate); //봮˲
        if(tcsetattr(iFdCom, TCSANOW, &tOldTermios) != 0)  //, TCSANOW: ɸıЧ
        {
            return;
        }
        tcflush(iFdCom, TCIOFLUSH);
        return;
	}
    cfsetispeed(&tNewTermios, iBaudrate); //봮˲
    cfsetospeed(&tNewTermios, iBaudrate); //봮˲
    tNewTermios.c_cflag |= CLOCAL;       //ģʽ, ֤򲻻Ϊ˿ڵռ
    tNewTermios.c_cflag |= CREAD;        //ģʽ, ʹܶ˿ڶȡ
    // ģʽ, flow control
    cFctl = ptPortInfo->cFctl;
    switch(cFctl)
    {
        case '0':
            {
                tNewTermios.c_cflag &= ~CRTSCTS;        //no flow control
                tNewTermios.c_iflag |= IGNBRK | IGNPAR;
            }break;
        case '1':
            {
                tNewTermios.c_cflag |= CRTSCTS;         //hardware flow control
            }break;
        case '2':
            {
                tNewTermios.c_iflag |= IXON | IXOFF | IXANY;    //software flow control
            }break;
        default:
            {
                break;
            }
    }
    // ģʽ, data bits
    tNewTermios.c_cflag &= ~CSIZE; //ģʽ, ַСλ
    cDatabit = ptPortInfo->cDatabit;
    switch(cDatabit)
    {
        case '5':
            tNewTermios.c_cflag |= CS5;
            // lint -fallthrough
        case '6':
            tNewTermios.c_cflag |= CS6;
            // lint -fallthrough
        case '7':
            tNewTermios.c_cflag |= CS7;
            // lint -fallthrough
        default:
            tNewTermios.c_cflag |= CS8;
    }
    // ģʽ parity check
    cParity = ptPortInfo->cParity;
    switch(cParity)
    {
        case '0':
            {
                tNewTermios.c_cflag &= ~PARENB; //no parity check
            }break;
        case '1':
            {
                tNewTermios.c_cflag |= PARENB;  //odd check
                tNewTermios.c_cflag &= ~PARODD;
            }break;
        case '2':
            {
                tNewTermios.c_cflag |= PARENB;  //even check
                tNewTermios.c_cflag |= PARODD;
            }break;
        default:
            {
                break;
            }
    }
    // ģʽ, stop bits
    cStopbit = ptPortInfo->cStopbit;
    if('2' == cStopbit)
    {
        tNewTermios.c_cflag |= CSTOPB;
    }
    else
    {
        tNewTermios.c_cflag &= ~CSTOPB;
    }
    // other attributions default
    tNewTermios.c_oflag &= ~OPOST;            //ģʽ, ԭʼ
    tNewTermios.c_cc[VMIN] = 1;               //ַ, ҪȡַС
    tNewTermios.c_cc[VTIME] = 1;              //ַ, ȡһַĵȴʱ䣬unit: (1/10)second
    tcflush(iFdCom, TCIFLUSH);                //ݿԽ,
    tcsetattr(iFdCom, TCSANOW, &tNewTermios); //, TCSANOW: ɸıЧ
    tcgetattr(iFdCom, &tOldTermios);
}

static void vFnPortRecvTimeout(int fdcom, CHAR *data, int datalen, int msec)
{
	int32_t         fs_sel;
	fd_set          fs_read;
	struct timeval  tv_timeout;
	FD_ZERO(&fs_read);
	FD_SET(fdcom, &fs_read);

    /*RAT ֵӦüСӦٶ*/
	tv_timeout.tv_sec = 0;/*TIMEOUT_SEC(datalen, baudrate);*/

	tv_timeout.tv_usec = msec*1000;/*TIMEOUT_USEC;*/

	fs_sel = select(fdcom + 1, &fs_read, NULL, NULL, &tv_timeout);
	if (fs_sel)
	{
		read(fdcom, data, datalen);
	}
	return;
}

int32_t g_cmux_flag = 0;//жϵǰǷcmux״̬
int32_t g_commonPortinCmux = -1; //лcmux״̬ʱͨģʽļ
int32_t g_iUartPort = -1;	//ǰUart豸

static pthread_t s_uiMonitorHungupThread = -1; //hungup߳
static pthread_t  self_adapt_thread;
static pthread_t  usb_hotplug_thread;

#define N_GSM0710	21	//cmux
//#define cmuxChID 	1	//ǰʹõcmuxͨ
static int cmuxChID[MAX_DLCI_NUM] = {1,2,3};//ǰʹõcmuxͨ

static int zUP_SetPort(int32_t iFd ,int ctsrts_en)
{		
    if(iFd < 0)
    {
        slog(DRVCOMMNG_PRINT,SLOG_ERR,"Set usb port error. iFd == %d\n", iFd);
        return FALSE;
    }	
	slog(DRVCOMMNG_PRINT,SLOG_DEBUG,"Set usb port ok. iFd == %d\n", iFd);
    //ioctl(iFd, (('R'<<8)|1|(0x4004<<16)), 0x400);
    //ioctl(iFd, (('R'<<8)|4|(0x4004<<16)), 0);
    //vFnSetUsbInfo(iFd, &s_tUsbInfo, AUTO_MODE);
	com_SetBaud(iFd, 115200);
	com_SetnBit(iFd, 8);
	com_SetParity(iFd, 'N');
	com_SetnStop(iFd,1);    
	com_SetCtrl(iFd,ctsrts_en); //add flow control
    return TRUE;
}

int zUP_Uart_num()
{
	int zUP_uart_num = -1;
    if(!strcmp(g_mux_main_port, "/dev/ttyS0"))
    {
        zUP_uart_num = 0;
    }
    else if(!strcmp(g_mux_main_port, "/dev/ttyS1"))
    {
       zUP_uart_num = 1;
    }
    else if(!strcmp(g_mux_main_port, "/dev/ttyS2"))
    {
        zUP_uart_num = 2;
    }
    else if(!strcmp(g_mux_main_port, "/dev/ttyS3"))
    {
        zUP_uart_num = 3;
    }
    slog(DRVCOMMNG_PRINT,SLOG_DEBUG,"drvcommng zUP_Uart_num:%d\n",zUP_uart_num);

    return zUP_uart_num;
}

int zUP_Uart_Flowcontrol(int i)
{
    char uart_ctsrts[32] = {0};
    int uart_ctsrts16 = 0; 
    int uart_bit = 0;
    int flow_control = 0;
    char uart_ctsrts_path[64] = {0};
    char uart_software[32] = {0};
    int uart_software16 = 0;
	
    if(i >= 0){
		sc_cfg_get("uart_ctstrs_enable",uart_ctsrts,sizeof(uart_ctsrts));
		uart_ctsrts16 = atoi(uart_ctsrts);
		sc_cfg_get("uart_softcontrol_enable",uart_software,sizeof(uart_software));
		uart_software16 = atoi(uart_software);
		uart_bit = 0x1<<i;

		if((uart_ctsrts16 & uart_bit) == 1){
			flow_control = 1;
			snprintf(uart_ctsrts_path, sizeof(uart_ctsrts_path) , "%s%d%s", Uart_Path, i, CtsRts_EN);
			writefile(uart_ctsrts_path,"1",1);
		}else if((uart_software16 & uart_bit) == 1){
			flow_control = 2;
		}
    }
    slog(DRVCOMMNG_PRINT,SLOG_DEBUG,"drvcommng uart portnum:%d,zUP_Uart_Flowcontrol uart flow control:%d\n",i,flow_control);
    return flow_control;
}

void zUP_Uart_wakeup(int i)
{
    char uart_wakeup[32] = {0};
    int uart_wakeup16 = 0; 
    int wakeup_bit = 0;
    int wakeup_enable = 0;
    char uart_wakeup_path[64] = {0};
	
    if(i >= 0){
		sc_cfg_get("uart_wakeup_enable",uart_wakeup,sizeof(uart_wakeup));
		uart_wakeup16 = atoi(uart_wakeup);
		wakeup_bit = 0x1<<i;

		if((uart_wakeup16 & wakeup_bit) == 1){
			wakeup_enable = 1;
			snprintf(uart_wakeup_path, sizeof(uart_wakeup_path) , "%s%d%s", Uart_Path, i, Wakeup_EN);
			writefile(uart_wakeup_path,"1",1);
		}
    }
     slog(DRVCOMMNG_PRINT,SLOG_DEBUG,"drvcommng uart portnum:%d,zUP_Uart_wakeup:%d\n",i,wakeup_enable);
    return;
}

static BOOL zUP_UartOpenConfig()
{
    int zUP_uart = -1;
    int zUP_Flowcontrol = -1;
    //sc_cfg_get("port_mode",g_mux_main_port,sizeof(g_mux_main_port));
    g_iUartPort = open(g_mux_main_port, O_RDWR);
    
    if(g_iUartPort < 0)
    {
        slog(DRVCOMMNG_PRINT,SLOG_ERR,"Open port %s error.\n", g_mux_main_port);
        return FALSE;
    }
    slog(DRVCOMMNG_PRINT,SLOG_DEBUG,"Open port success: %s, g_iUartPort: %d\n", g_mux_main_port, g_iUartPort);

    zUP_uart = zUP_Uart_num();
    zUP_Flowcontrol = zUP_Uart_Flowcontrol(zUP_uart);
    zUP_Uart_wakeup(zUP_uart);
    zUP_SetPort(g_iUartPort,zUP_Flowcontrol);
    return TRUE;
}

static void zUP_MuxChannelConfig(int32_t iFd)
{
	static struct termios  Muxtio;

	tcgetattr(iFd, &Muxtio); // save current port settings
	Muxtio.c_cflag = CS8 | CLOCAL | CREAD;


	Muxtio.c_iflag = IGNPAR;
	Muxtio.c_oflag = 0;
	Muxtio.c_lflag = 0;       //!ICANON;

	Muxtio.c_cc[VMIN] = 1;
	Muxtio.c_cc[VTIME] = 0;
	//cfsetospeed(&Muxtio, B38400);
    //cfsetispeed(&Muxtio, B38400);
    tcsetattr(iFd, TCSANOW, &Muxtio);
}

int zUP_CreateCMUXATThread()
{
    char shellCmd[1024] = {0};
    char mainDevNum[1024] = {0};
    char cmuxDevice[1024] = {0};
    FILE *fp = NULL;
    int32_t result = -1;
    int32_t g_modeToCMUXAT = -1; //CMUX1ļ
    int dlci_num;
	char *temp_str = NULL;
    system("rm -f /tmp/uartproxy_file");
    system("cat /proc/devices | grep gsmtty > /tmp/uartproxy_file");
    fp = fopen("/tmp/uartproxy_file", "r");
    if(NULL == fp)
    {
        slog(DRVCOMMNG_PRINT,SLOG_ERR,"can not open file /tmp/uartproxy_file\n");
        return 0;
    }
    memset(shellCmd, 0, sizeof(shellCmd));
    fgets(shellCmd, sizeof(shellCmd), fp);
   	slog(DRVCOMMNG_PRINT,SLOG_DEBUG,"shellCmd= %s!!!\n", shellCmd);
	temp_str = strchr(shellCmd,' ');
	if(temp_str == NULL){
		fclose(fp);
		slog(DRVCOMMNG_PRINT,SLOG_ERR,"CreateCMUXATThread find maindevnum fail!\n");
		return 0;
	}
		
    memcpy(mainDevNum, shellCmd, (int32_t)(strchr(shellCmd,' ') - shellCmd));
	slog(DRVCOMMNG_PRINT,SLOG_DEBUG,"mainDevNum= %s!!!\n", mainDevNum);
    fclose(fp);
	temp_str = NULL;
    memset(shellCmd, 0, sizeof(shellCmd));
    snprintf(shellCmd, sizeof(shellCmd),"mknod /dev/gsmtty0 c %s 0", mainDevNum);//cmuxͨ0봴
	temp_str = strstr(shellCmd, "mknod /dev/gsmtty0");
	if(temp_str == NULL){
		slog(DRVCOMMNG_PRINT,SLOG_ERR,"CreateCMUXATThread check cmd fail!\n");
		return 0;		
	}
	result = system(shellCmd);
    slog(DRVCOMMNG_PRINT,SLOG_DEBUG,"result1= %d!!!\n", result);
    g_commonPortinCmux = g_iUartPort;
    for(dlci_num = 0;dlci_num < MAX_DLCI_NUM;dlci_num++){
	    memset(shellCmd, 0, sizeof(shellCmd));
	    snprintf(shellCmd, sizeof(shellCmd),"mknod /dev/gsmtty%d c %s %d", cmuxChID[dlci_num], mainDevNum, cmuxChID[dlci_num]);
	    result = system(shellCmd);
	  	slog(DRVCOMMNG_PRINT,SLOG_DEBUG,"result2= %d!!!\n", result);
	    sprintf(cmuxDevice, "/dev/gsmtty%d", cmuxChID[dlci_num]);//ȡcmux豸
	    g_modeToCMUXAT = open(cmuxDevice, O_RDWR);
	    if(g_modeToCMUXAT < 0)
	    {
	        slog(DRVCOMMNG_PRINT,SLOG_ERR,"Open port %d error.\n", errno);
	        return 0;
	    }
	    //g_commonPortinCmux = g_iUartPort;
	    g_iUartPort = g_modeToCMUXAT;
		g_modeToCMUXAT = -1;
	    memcpy(g_cmux_port[dlci_num], cmuxDevice, sizeof(g_cmux_port[dlci_num]));
	    //ipc_send_message(MODULE_ID_DRVCOMMNG, MODULE_ID_AT_CTL,MSG_CMD_AT_PORT_OPEN, sizeof(g_cmux_port[dlci_num]), g_cmux_port[dlci_num], 0);
	    slog(DRVCOMMNG_PRINT,SLOG_DEBUG,"use gsmtty%d start!!!!\n", cmuxChID[dlci_num]);
		
	    zUP_MuxChannelConfig(g_iUartPort);
    }
	ipc_send_message(MODULE_ID_DRVCOMMNG, MODULE_ID_AT_CTL,MSG_CMD_AT_PORT_CLOSE, sizeof(g_mux_main_port), g_mux_main_port, 0);
    return 1;
}

static int32_t zUP_GetUartEvents(int32_t fd)
{
	struct pollfd fds;
	int32_t time_delay = 300;
	fds.fd = fd;
	fds.events = POLLHUP;
	if(poll(&fds, 1, time_delay) <= 0)
	{
		return 0;
	}
	if(fds.revents)
	{
		return 1;
	}
	return 0;
}

static void zUP_Mux2USB(int32_t fd)
{
	int32_t uart_ldisc = 0;
	int32_t ret = 0;
	
	ret = ioctl(fd, TIOCSETD, &uart_ldisc);//л·
	if(ret == 0)
	{
		slog(DRVCOMMNG_PRINT,SLOG_ERR,"cmux to tty success\n");
	}
    return;
}

static void *zUP_MonitorHungupHander()
{
    int32_t result = 0;
    int dlci_num;
    while(1)
    {
        result = zUP_GetUartEvents(g_commonPortinCmux);
        if(result > 0)
        {       
			slog(DRVCOMMNG_PRINT,SLOG_DEBUG,"GetUartEvents ret is %d\n",result);

			if(zUP_UartOpenConfig() == FALSE)
			{            
				slog(DRVCOMMNG_PRINT,SLOG_ERR,"zUP_UartOpenConfig  FALSE\n");
				return NULL;
			}
			zUP_Mux2USB(g_iUartPort);

			g_cmux_flag = 0;
			//Ϣat_Ctlmux2USBĲ»ȡfd
			com_SetBaud(g_iUartPort,uart_baud_for_cmux);		//˳cmuxģʽò
			ipc_send_message(MODULE_ID_DRVCOMMNG, MODULE_ID_AT_CTL,MSG_CMD_AT_PORT_OPEN, sizeof(g_mux_main_port), g_mux_main_port, 0);
			pthread_cancel(s_uiMonitorHungupThread);
        }
    }
    return NULL;
}


int zUP_CreateMonitorHungupThread()
{
    int32_t iResult = -1;
    pthread_attr_t attr;

    pthread_attr_init(&attr);
    pthread_attr_setdetachstate(&attr, PTHREAD_CREATE_DETACHED);
    iResult = pthread_create(&s_uiMonitorHungupThread, &attr, zUP_MonitorHungupHander, NULL);
    pthread_attr_destroy(&attr);
    if(0 != iResult)
    {
		slog(DRVCOMMNG_PRINT,SLOG_ERR,"Call MonitorHungup pthread_create() error.\n");
        return FALSE;
    }
    return TRUE;
}

void OpenMultiCmuxChannel()
{
//	UART_PROXY_LOG("Enter %s, and will go open multi mux_fd\n", __FUNCTION__);
    
	if(!zUP_CreateCMUXATThread())
    {    
		slog(DRVCOMMNG_PRINT,SLOG_ERR,"Call zUP_CreateCMUXATThread() error.\n");
        return;
    }
    g_cmux_flag = 1;
    if(!zUP_CreateMonitorHungupThread())
    {
       slog(DRVCOMMNG_PRINT,SLOG_ERR,"Call zUP_CreateMonitorHungupThread() error.\n");
        return;
    }
	
}


static void bFnCmuxProc(struct at_cmux_req *cmux_req)		//xiu
//static void bFnCmuxProc()		//xiu
{
	int ldisc = N_GSM0710;
	int ret = 0;
	struct gsm_config cmux_config;
	struct at_cmux_req *cmux_opt = cmux_req;
	struct termios tOldTermios = {0};
	int32_t iBaudrate = 0; 

	if(cmux_opt->port_speed != 0)
	{
		uart_baud_for_cmux = UART_baud[5 - cmux_opt->port_speed];
		com_SetBaud(g_iUartPort,uart_baud_for_cmux);		//cmuxôڲ
	}
	 
	tcgetattr(g_iUartPort, &tOldTermios); // get the serial port attributions
	uart_baud_for_cmux = iFnBaudconv(cfgetispeed(&tOldTermios));	 

	ret = ioctl(g_iUartPort, TIOCSETD, &ldisc);				//л·	
	slog(DRVCOMMNG_PRINT,SLOG_DEBUG,"tty goto mux ret is %d\n",ret);
		
	ret = ioctl(g_iUartPort, GSMIOC_GETCONF, &cmux_config);
	slog(DRVCOMMNG_PRINT,SLOG_DEBUG,"get mux ret is %d\n",ret);
#if 0
	cmux_config.initiator = 0;
	cmux_config.encapsulation = 0;
	cmux_config.mru = 512;
	cmux_config.mtu = 512;
#endif
#if 1
	cmux_config.initiator = 0;							//ͻ/
	cmux_config.encapsulation = cmux_opt->cmux_mode;		//ģʽ
	
	if(cmux_opt->subset == 0)							//֡
		cmux_config.i= 1;
	else if(cmux_opt->subset == 1)
		cmux_config.i= 2;
	
	if(cmux_opt->frame_len)							//֡
	{
		cmux_config.mru = cmux_opt->frame_len;
		cmux_config.mtu = cmux_opt->frame_len;
	}
	else
	{
		cmux_config.mru = 512;
		cmux_config.mtu = 512;
	}
	if(cmux_opt->ack_time != 0)
		cmux_config.t1 = cmux_opt->ack_time;
	if(cmux_opt->resp_time != 0)
		cmux_config.t2 = cmux_opt->resp_time;
	if(cmux_opt->recon_count != 0)
		cmux_config.n2 = cmux_opt->recon_count;	
	if(cmux_opt->awak_time != 0)
		cmux_config.t3 = cmux_opt->awak_time;
	if(cmux_opt->win_size != 0)
		cmux_config.k= cmux_opt->win_size;
#endif
	ret = ioctl(g_iUartPort, GSMIOC_SETCONF, &cmux_config);
    slog(DRVCOMMNG_PRINT,SLOG_DEBUG,"set mux ret is %d\n",ret);
	OpenMultiCmuxChannel();
}

static int cmux_proc(struct at_cmux_req *cmux_req)
{
    int ret = !g_cmux_flag;
	
	ipc_send_message(MODULE_ID_DRVCOMMNG, MODULE_ID_AT_CTL,MSG_CMD_CMUX_SET_RSP, sizeof(ret), &ret, 0);
    if(g_cmux_flag == 0)
    {
        g_iUartPort = open(cmux_req->name, O_RDWR);
		if(g_iUartPort <= 0)
		{
			return -1;
		}
		memcpy(g_mux_main_port,cmux_req->name,strlen(cmux_req->name));
		bFnCmuxProc(cmux_req);		//xiu
		//bFnCmuxProc();		//xiu
	}
	return 0;
}

static void sig_usr(int signo)
{

    if (signo == SIGUSR1)
    {
        slog(DRVCOMMNG_PRINT,SLOG_DEBUG,"drvcom_msg receive SIGUSR1!\n");
    }
    else
    {
        slog(DRVCOMMNG_PRINT,SLOG_DEBUG,"drvcom_msg receive signo %d", signo);
    }
}

void drvcom_msg_proc(MSG_BUF* stMsg)
{
    slog(DRVCOMMNG_PRINT,SLOG_DEBUG,"recv usMsgCmd = %x\n",stMsg->usMsgCmd);
    switch (stMsg->usMsgCmd)
    {
		case MSG_CMD_CMUX_SET_REQ:
			cmux_proc((struct at_cmux_req *)(stMsg->aucDataBuf));
			break;
		default:
			break;
	}

	return;
}

static int create_msg_queue(void)
{
    return msgget(MODULE_ID_DRVCOMMNG, IPC_CREAT | 0600);
}

int get_selfadaptionport_num()
{
	int selfadaptionport_uart_num = -1;
    if(!strcmp(g_selfAdaptionPort, "/dev/ttyS0"))
    {
        selfadaptionport_uart_num = 0;
    }
    else if(!strcmp(g_selfAdaptionPort, "/dev/ttyS1"))
    {
       selfadaptionport_uart_num = 1;
    }
    else if(!strcmp(g_selfAdaptionPort, "/dev/ttyS2"))
    {
        selfadaptionport_uart_num = 2;
    }
    else if(!strcmp(g_selfAdaptionPort, "/dev/ttyS3"))
    {
        selfadaptionport_uart_num = 3;
    }
    slog(DRVCOMMNG_PRINT,SLOG_DEBUG,"drvcommng get_selfadaptionport_num:%d port:%s\n",selfadaptionport_uart_num,g_selfAdaptionPort);

    return selfadaptionport_uart_num;
	
}

int selfadaptionport_flowcontrol(int i)
{
    char uart_ctsrts[32] = {0};
    int uart_ctsrts16 = 0; 
    int uart_bit = 0;
    int flow_control = 0;
    char uart_ctsrts_path[64] = {0};
    char uart_software[32] = {0};
    int uart_software16 = 0;
	
    if(i >= 0){
		sc_cfg_get("uart_ctstrs_enable",uart_ctsrts,sizeof(uart_ctsrts));
		uart_ctsrts16 = atoi(uart_ctsrts);
		sc_cfg_get("uart_softcontrol_enable",uart_software,sizeof(uart_software));
		uart_software16 = atoi(uart_software);
		uart_bit = 0x1<<i;

		if((uart_ctsrts16 & uart_bit) == 1){
			flow_control = 1;
			snprintf(uart_ctsrts_path, sizeof(uart_ctsrts_path) , "%s%d%s", Uart_Path, i, CtsRts_EN);
			writefile(uart_ctsrts_path,"1",1);
		}else if((uart_software16 & uart_bit) == 1){
			flow_control = 2;
		}
    }
     slog(DRVCOMMNG_PRINT,SLOG_DEBUG,"drvcommng uart portnum:%d,selfadaptionport_flowcontrol uart flow control:%d\n",i,flow_control);
    return flow_control;
}

void selfadaptionport_wakeup(int i)
{
    char uart_wakeup[32] = {0};
    int uart_wakeup16 = 0; 
    int wakeup_bit = 0;
    int wakeup_enable = 0;
    char uart_wakeup_path[64] = {0};
	
    if(i >= 0){
		sc_cfg_get("uart_wakeup_enable",uart_wakeup,sizeof(uart_wakeup));
		uart_wakeup16 = atoi(uart_wakeup);
		wakeup_bit = 0x1<<i;

		if((uart_wakeup16 & wakeup_bit) == 1){
			wakeup_enable = 1;
			snprintf(uart_wakeup_path, sizeof(uart_wakeup_path) , "%s%d%s", Uart_Path, i, Wakeup_EN);
			writefile(uart_wakeup_path,"1",1);
		}
    }
     slog(DRVCOMMNG_PRINT,SLOG_DEBUG,"drvcommng uart portnum:%d,selfadaptionport_wakeup:%d\n",i,wakeup_enable);
}

void com_read_proc()
{
    int fd = open(g_selfAdaptionPort, O_RDWR);
	int iAtCmdLen = 0;
	int tempLen = 0;
	char strReadAtCmd[1024+1] = {0};
	char strTempStr[16] = {0};
	#if 0
	int uart_num = -1;
	int uart_flowcontrol = -1;
	
    ioctl(fd, (('R'<<8)|1|(0x4004<<16)), 0x400);
    ioctl(fd, (('R'<<8)|4|(0x4004<<16)), 0);
	uart_num = get_selfadaptionport_num();
	uart_flowcontrol = selfadaptionport_flowcontrol(uart_num);
	selfadaptionport_wakeup(uart_num);
	com_set_portInfo(fd, 115200, 8, 'N', 1,uart_flowcontrol);
	#endif
	if(fd < 0)
		return;
	
    while(1)
	{
		iAtCmdLen = read(fd, strReadAtCmd, 1024);
        memcpy(strTempStr+tempLen, strReadAtCmd, 2);
        tempLen += iAtCmdLen;

        if(tempLen >= 2)
        {
            int inum =0 ;
            for(;inum<strlen(strTempStr);inum++)
            {
                slog(DRVCOMMNG_PRINT,SLOG_DEBUG,"data: %02x\n",strTempStr[inum]);
            }
            int32_t iBaund = BaudSelfAdaptionList(strTempStr);
			uart_baud_for_cmux = iBaund;		//Ӧʱ ֮ʹ
			if(iBaund != 0) {
                s_tUsbInfo.iBaudrate = iBaund;
				{
					char brt[10] = {0};
					snprintf(brt,sizeof(brt),"%d",iBaund);
				    sc_cfg_set("Baudrate", brt);
                }                
				com_SetBaud(fd, iBaund);
                usleep(70000);
                vFnPortRecvTimeout(fd, strReadAtCmd, 1024, 10);
		        // ͺŻҪ͵ATβȥ'\0'ַ
				write(fd, PCS_REPLY_OK, strlen(PCS_REPLY_OK));
				break;
            }
            memset(strTempStr, 0, 16);
            tempLen = 0;
        }
        continue;
    }
	close(fd);
	ipc_send_message(MODULE_ID_DRVCOMMNG, MODULE_ID_AT_CTL,MSG_CMD_AT_PORT_OPEN, sizeof(g_selfAdaptionPort), g_selfAdaptionPort, 0);
	//pthread_cancel(pthread_self());
	return;
	
}

void set_selfadaptionport()
{
    int fd = open(g_selfAdaptionPort, O_RDWR);
	if(fd < 0){
		slog(DRVCOMMNG_PRINT,SLOG_ERR,"open %s fail\n", g_selfAdaptionPort);
		return;
	}
	int uart_num = -1;
	int uart_flowcontrol = -1;
	
    //ioctl(fd, (('R'<<8)|1|(0x4004<<16)), 0x400);
   // ioctl(fd, (('R'<<8)|4|(0x4004<<16)), 0);
	uart_num = get_selfadaptionport_num();
	uart_flowcontrol = selfadaptionport_flowcontrol(uart_num);
	selfadaptionport_wakeup(uart_num);
	com_set_portInfo(fd, 115200, 8, 'N', 1,uart_flowcontrol);
	
    close(fd);
}
int create_self_adaption_thread(void)
{
	int32_t iResult = -1;
	pthread_attr_t attr;
    pthread_attr_init(&attr);
    pthread_attr_setdetachstate(&attr, PTHREAD_CREATE_DETACHED);
	Uart_config_and_notify();
	set_selfadaptionport();
    iResult = pthread_create(&self_adapt_thread, &attr, com_read_proc, NULL);
	if(iResult)
	{
	   	slog(DRVCOMMNG_PRINT,SLOG_ERR,"self_adapt_thread_create fail %d\n", iResult);
  		pthread_attr_destroy(&attr);
		return -1;
	}
    pthread_attr_destroy(&attr);
	return 0;
}

void notify_atctl_update_port(char* dev_ptr)
{
	if(strstr(dev_ptr, "online@"))
	{
		if(strstr(dev_ptr, "ttyGS0")){
			ipc_send_message2(MODULE_ID_DRVCOMMNG, MODULE_ID_AT_CTL,MSG_CMD_AT_PORT_OPEN, sizeof("/dev/ttyGS0"), "/dev/ttyGS0", 0);
		}
		if(strstr(dev_ptr, "ttyGS1")){
			ipc_send_message2(MODULE_ID_DRVCOMMNG, MODULE_ID_AT_CTL,MSG_CMD_AT_PORT_OPEN, sizeof("/dev/ttyGS0"), "/dev/ttyGS1", 0);
		}
	}else if(strstr(dev_ptr, "offline@")){
		if(strstr(dev_ptr, "ttyGS0")){
			ipc_send_message2(MODULE_ID_DRVCOMMNG, MODULE_ID_AT_CTL,MSG_CMD_AT_PORT_CLOSE, sizeof("/dev/ttyGS0"), "/dev/ttyGS0", 0);
		}
		if(strstr(dev_ptr, "ttyGS1")){
			ipc_send_message2(MODULE_ID_DRVCOMMNG, MODULE_ID_AT_CTL,MSG_CMD_AT_PORT_CLOSE, sizeof("/dev/ttyGS1"), "/dev/ttyGS1", 0);
		}
	}
}
#if 1
/*USB_EVENTе'\0' 滻'\n'ֹȡ'\0'*/
void char_event_analyse(char*buf, int count)
{
    int index = 0;
    
    if(!buf)        
        return; 
    
    for(index = 0; index < count; ++index)
    {
        if(buf[index] == '\0')
        {
            buf[index] = '\n';
        }
    }
}
#endif


#if 0

 int notify_cmux_dlci_state(char* buf,int len)
 {
 	int rtv = 0;
	if(!buf)        
       	    return; 
 	 char_event_analyse(buf,len);
	
	if(strstr(buf, "online@/cmux/cmuxconfig"))
	{
		if(strstr(buf, "CMUXEVENT=gsmtty1"))
		{
    			ipc_send_message(MODULE_ID_DRVCOMMNG, MODULE_ID_AT_CTL,MSG_CMD_AT_PORT_OPEN, sizeof(g_cmux_port[0]), g_cmux_port[0], 0);
		}
		else if(strstr(buf, "CMUXEVENT=gsmtty2"))
		{
    			ipc_send_message(MODULE_ID_DRVCOMMNG, MODULE_ID_AT_CTL,MSG_CMD_AT_PORT_OPEN, sizeof(g_cmux_port[1]), g_cmux_port[1], 0);
		}
		else if(strstr(buf, "CMUXEVENT=gsmtty3"))
		{
    			ipc_send_message(MODULE_ID_DRVCOMMNG, MODULE_ID_AT_CTL,MSG_CMD_AT_PORT_OPEN, sizeof(g_cmux_port[2]), g_cmux_port[2], 0);
		}
		rtv  = 1;
	}
	else if(strstr(buf, "offline@/cmux/cmuxconfig"))
	{
	    	if(strstr(buf, "CMUXEVENT=gsmtty1"))
		{
    			ipc_send_message(MODULE_ID_DRVCOMMNG, MODULE_ID_AT_CTL,MSG_CMD_AT_PORT_CLOSE, sizeof(g_cmux_port[0]), g_cmux_port[0], 0);
		}
		else if(strstr(buf, "CMUXEVENT=gsmtty2"))
		{
    			ipc_send_message(MODULE_ID_DRVCOMMNG, MODULE_ID_AT_CTL,MSG_CMD_AT_PORT_CLOSE, sizeof(g_cmux_port[1]), g_cmux_port[1], 0);
		}
		else if(strstr(buf, "CMUXEVENT=gsmtty3"))
		{
    			ipc_send_message(MODULE_ID_DRVCOMMNG, MODULE_ID_AT_CTL,MSG_CMD_AT_PORT_CLOSE, sizeof(g_cmux_port[2]), g_cmux_port[2], 0);
		}
		rtv = 1;
	}
	return rtv;
 }

void usb_hotplug_proc()
{
    int sockfd = 0;
    fd_set readfds;
    int maxfd = 0;
    char buf[8192] = {0};//Сȷ
    int len = 0;
    const int buffersize = 8 * 1024; 
    char tempModeType[12] = {0};
    int ret = 0;
	char *act_ptr = NULL;
    struct sockaddr_nl snl; 
    
    bzero(&snl, sizeof(struct sockaddr_nl)); 
    snl.nl_family = AF_NETLINK; 
    snl.nl_pid = getpid();
    snl.nl_groups = 1; 

    if (signal(SIGPIPE, SIG_IGN) == SIG_ERR)
        perror ("signal");

    sockfd = socket(PF_NETLINK, SOCK_DGRAM, NETLINK_KOBJECT_UEVENT); 
    if (sockfd < 0)  
    { 
        slog(DRVCOMMNG_PRINT,SLOG_ERR,"usb_create hotplug socket failed!\n");
        return; 
    }
    //setsockopt(sockfd, SOL_SOCKET, SO_RCVBUF, &buffersize, sizeof(buffersize)); 

    ret = bind(sockfd, (struct sockaddr *)&snl, sizeof(struct sockaddr_nl)); 
    if (ret < 0)  
    { 
        slog(DRVCOMMNG_PRINT,SLOG_ERR,"usb_hotplug socket bind fail!\n"); 
        close(sockfd); 
        return; 
    } 
    maxfd = sockfd;
    while (1) 
    {
        FD_ZERO(&readfds);
        FD_SET(sockfd, &readfds);
        
        ret = select(maxfd + 1, &readfds, NULL, NULL, NULL);
        if (ret == -1 && errno == EINTR)
            continue;

        if(FD_ISSET(sockfd, &readfds))
        {
            memset(buf, 0, sizeof(buf));
            len = recv(sockfd, &buf, sizeof(buf), 0);
            if(len <= 0)
            {
                slog(DRVCOMMNG_PRINT,SLOG_ERR,"usb_hotplug recv msg fail!\n");
                continue;
            }
	if(notify_cmux_dlci_state(buf,len) != 0)		//жcmuxͨ״̬
		continue;
		    act_ptr = strchr(buf, '@');
		    if(NULL == act_ptr)
		    {
		        slog(DRVCOMMNG_PRINT,SLOG_ERR,"usb_hotplug msg parse failed!\n");
                continue;
		    }
		#if 1
		notify_atctl_update_port(buf);
		#else
		   offline_ptr = strchr(buf, 'offline');
		   if(offline_ptr != NULL)
		 ret = nv_get_item(NV_RO, STR_USB_MODE_TYPE, tempModeType, sizeof(tempModeType));
		  if((!strcmp(tempModeType, "debug")) || (!strcmp(tempModeType, "debug"))){
			notify_atctl_update_port(buf, "ttyGS0");
			notify_atctl_update_port(buf, "ttyGS1");
		  }else if(!strcmp(tempModeType, "factory")){
		  	notify_atctl_update_port(buf, "ttyGS0");
		  }
		  #endif
        }
    }	
}

int create_usb_hotplug_thread(void)
{
	int32_t iResult = -1;
	pthread_attr_t attr;
    pthread_attr_init(&attr);
    pthread_attr_setdetachstate(&attr, PTHREAD_CREATE_DETACHED);
    iResult = pthread_create(&usb_hotplug_thread, &attr, usb_hotplug_proc, NULL);
	if(iResult)
	{
	   	slog(DRVCOMMNG_PRINT,SLOG_ERR,"usb_hotplug_thread_create fail %d\n", iResult);
		return -1;
	}
    pthread_attr_destroy(&attr);
	return 0;
}

#endif

void notify_atctl_open_atport(const char *tty ,int ctsrts_en)
{
	int ret = 0;
	int fd = open(tty, O_RDWR);
	if(fd < 0){
		slog(DRVCOMMNG_PRINT,SLOG_ERR,"open %s fail\n", tty);
		return;		
	}
   // ioctl(fd, (('R'<<8)|1|(0x4004<<16)), 0x400);
   // ioctl(fd, (('R'<<8)|4|(0x4004<<16)), 0);
    zUP_SetPort(fd,ctsrts_en);	
	ret = close(fd);	
	
	if(strlen(notify_forbid_dev) > 0){
		if(strcmp(tty, notify_forbid_dev))
			ret = ipc_send_message2(MODULE_ID_DRVCOMMNG, MODULE_ID_AT_CTL,MSG_CMD_AT_PORT_OPEN, strlen(tty)+1, tty, 0);
		else
			slog(DRVCOMMNG_PRINT,SLOG_ERR,"notify_atctl %s don't notify \n", tty);
	} else {
		ret = ipc_send_message2(MODULE_ID_DRVCOMMNG, MODULE_ID_AT_CTL,MSG_CMD_AT_PORT_OPEN, strlen(tty)+1, tty, 0);
	}
	
    slog(DRVCOMMNG_PRINT,SLOG_DEBUG,"notify_atctl send %s %d\n",tty, ret);
}

void Uart_config_and_notify(void)
{
	 char uart_ctsrts[32] = {0};
   	 char uart_control[32] = {0};
    	int uart_ctsrts16 = 0; 
  	  int uart_control16 = 0; 
    	char uart_path[64] = {0};
   	 char uart_control_nam[32] = {0};
	char uart_wakeup[32] = {0};
	int uart_wakeup16 = 0;
	char uart_software[32] = {0};
	int uart_software16 = 0;
	char uart_app_ctrl[16] = {0};
	int uart_app_ctrl16 = 0;
   	 int i = 0;
	
	sc_cfg_get("uart_control",uart_control,sizeof(uart_control));
	sc_cfg_get("uart_ctstrs_enable",uart_ctsrts,sizeof(uart_ctsrts));
	sc_cfg_get("uart_wakeup_enable",uart_wakeup,sizeof(uart_wakeup));
	sc_cfg_get("uart_softcontrol_enable",uart_software,sizeof(uart_software));
	sc_cfg_get("uart_app_ctrl",uart_app_ctrl,sizeof(uart_app_ctrl));
			
	uart_control16 = atoi(uart_control);
	uart_ctsrts16 = atoi(uart_ctsrts);
	uart_wakeup16 = atoi(uart_wakeup);
	uart_software16 = atoi(uart_software);
	uart_app_ctrl16 = atoi(uart_app_ctrl);
	
	for(i=0;i<4;i++)
	{
		if((uart_control16&0x1) == 1){
			 snprintf(uart_control_nam, sizeof(uart_control_nam) , "%s%d", "/dev/ttyS",i);

			 if(strcmp(uart_control_nam, g_selfAdaptionPort)){//for baud self adapter,don't config again
				if((uart_ctsrts16&0x1) == 1){
					snprintf(uart_path, sizeof(uart_path) , "%s%d%s", Uart_Path, i, CtsRts_EN);
					writefile(uart_path,"1",1);
					notify_atctl_open_atport(uart_control_nam,1);
					slog(DRVCOMMNG_PRINT,SLOG_DEBUG,"drvcommng uart:%d,enable ctsrts\n",i);
				}else if((uart_software16&0x1) == 1){
					notify_atctl_open_atport(uart_control_nam,2);
					slog(DRVCOMMNG_PRINT,SLOG_DEBUG,"drvcommng uart:%d, enable software control\n",i);
				}else{
					notify_atctl_open_atport(uart_control_nam,0);
					slog(DRVCOMMNG_PRINT,SLOG_DEBUG,"drvcommng uart:%d,no flow control\n",i);
				}
				if((uart_wakeup16&0x1) == 1){
					snprintf(uart_path, sizeof(uart_path) , "%s%d%s", Uart_Path, i, Wakeup_EN);
					writefile(uart_path,"1",1);
					//notify_atctl_open_atport(uart_control_nam,1);
					slog(DRVCOMMNG_PRINT,SLOG_DEBUG,"drvcommng uart:%d,wakeup enable\n",i);
				}
				if((uart_app_ctrl16&0x1) == 1){
					snprintf(uart_path, sizeof(uart_path) , "%s%d%s", Uart_Path, i, APP_CTRL_LOWPOWER);
					writefile(uart_path,"1",1);
					//notify_atctl_open_atport(uart_control_nam,1);
					slog(DRVCOMMNG_PRINT,SLOG_DEBUG,"drvcommng uart:%d,uart_app_ctrl enable\n",i);
				}
			}
		}
		uart_control16=uart_control16>>1;
		uart_ctsrts16=uart_ctsrts16>>1;
		uart_wakeup16=uart_wakeup16>>1;
		uart_software16=uart_software16>>1;
		uart_app_ctrl16=uart_app_ctrl16>>1;
	}

}
#ifdef USE_CAP_SUPPORT
#define CORE_ID_OCCUPY_UART_PATH "/sys/devices/platform/zx29_uart.1/coreid_occupy_uart"
void get_which_core_occupy_uart(void)
{
		char uart_occupy_core_id[4] = {0};
		sc_cfg_get("uart_console_coreid",uart_occupy_core_id,sizeof(uart_occupy_core_id));
		if(strcmp("1" , uart_occupy_core_id) == 0){
			writefile(CORE_ID_OCCUPY_UART_PATH, "1", 1);
			printf("uart_console_coreid is %s.",uart_occupy_core_id);
		}
		else if(strcmp("2" , uart_occupy_core_id) == 0){
			writefile(CORE_ID_OCCUPY_UART_PATH, "2", 1);
			printf("uart_console_coreid is %s.",uart_occupy_core_id);
		}			
}
#endif
void zte_drv_serial_ctrl_main()
{
	int iMsgHandle = 0;
    int iRet = 0;
    MSG_BUF stMsg;
    LONG msgSize =  sizeof(MSG_BUF)-sizeof(LONG);
    int interruptSIG = 0;
#ifdef USE_CAP_SUPPORT
	get_which_core_occupy_uart();
#endif
	prctl(PR_SET_NAME, "serial_ctrl", 0, 0, 0);
    sc_cfg_get("notify_forbiden_ports",notify_forbid_dev,sizeof(notify_forbid_dev));
    sc_cfg_get("self_adaption_port",g_selfAdaptionPort,sizeof(g_selfAdaptionPort));
    if(strlen(g_selfAdaptionPort) > 0)
    {
		create_self_adaption_thread();
	}
	else
	{
		Uart_config_and_notify();
	}
	//create_usb_hotplug_thread();	
	iMsgHandle = create_msg_queue();
    if (signal(SIGUSR1, sig_usr) == SIG_ERR)
        slog(DRVCOMMNG_PRINT,SLOG_DEBUG,"drvcom not catch SIGUSR1\n");
	
	if(-1 == iMsgHandle)
    {
        slog(DRVCOMMNG_PRINT,SLOG_ERR,"drvcom create msg queue fail!\n");
        return;
    }
    
    for(;;)
    {
        if (0 == interruptSIG)
        {
            slog(DRVCOMMNG_PRINT,SLOG_DEBUG,"drvcom begin to rcv msg from queue %d. \n", iMsgHandle);
        }
        memset(&stMsg, '\0', sizeof(stMsg));
        iRet = 0;
        iRet = msgrcv(iMsgHandle, &stMsg, msgSize, 0, 0);
        slog(DRVCOMMNG_PRINT,SLOG_DEBUG,"drvcom received msg  ============\n");
        if (-1 == iRet)
        {
            if (EINTR == errno)
            {
                interruptSIG = 1;
                continue;
            }
            else
            {
				slog(DRVCOMMNG_PRINT,SLOG_ERR,"drvcom recv msg fail \n");
                return ;
            }
        }
        else
        {
            interruptSIG = 1;
        }
        drvcom_msg_proc(&stMsg);
    }
}

