/**************************************************************************
*
*                  Copyright (c) 2013 ZTE Corporation.
*
***************************************************************************
* ģ   : zte_usbCfgMng
*    : usbCfgMng_udisk.c
* ļ :
* ʵֹ : 7520V2ܻU/Tлܣ7520V2ܻʹ
*      : 
*      : V1.0
*  : 2016-10-21
* ˵ :
**************************************************************************/
#include <pthread.h>
#include <sys/socket.h>  
#include <errno.h>  
#include <linux/netlink.h>
#include "zte_drv_usb_ctrl.h"
#include "drv_msg.h"


int g_usbcfg_udisk_state = -1;

extern unsigned char enum_functions[USB_STR_FUNCTIONS_MAX_LEN];
extern pthread_mutex_t g_usbcfg_usbenum_mutex;

#if 0
#define SDCARD_ADD_MESSAGE          "add@/devices/platform/zx29_sd.1"
#define SDCARD_REMOVE_MESSAGE         "remove@/devices/platform/zx29_sd.1"    
#define SDCARD_OFFLINE_MESSAGE         "offline@/devices/platform/zx29_sd.1"   

#define SDCARD_ADD_STR_SUBSYSTEM    "SUBSYSTEM=block"
#define SDCARD_ADD_STR_DEVNAME      "DEVNAME=mmcblk0"
#define SDCARD_ADD_STR_DEVTYPE      "DEVTYPE=disk"
#define SDCARD_REMOVE_STR_SUBSYSTEM   "SUBSYSTEM=mmc"
#define SDCARD_REMOVE_STR_MMCTYPE     "MMC_TYPE=SD"
#define SDCARD_OFFLINE_STR_SUBSYSTEM   "SUBSYSTEM=mmc"
#define SDCARD_OFFLINE_STR_MMCTYPE     "MMC_TYPE=SD"
#endif

void usb_RegisterUdiskHook(T_USBCFG_UDISKFunc func)
{
    g_usbcfg_udiskProcFnc = func;
    slog(USBCFGMNG_PRINT,SLOG_DEBUG, "[usbCfgMng]  usb_RegisterUdiskHook\n");
}

void usb_UnRegisterUdiskHook(void)
{
    g_usbcfg_udiskProcFnc = NULL;
    slog(USBCFGMNG_PRINT,SLOG_DEBUG, "[usbCfgMng]  usb_UnRegisterUdiskHook\n");
}

static char * usb_pstrFnStrupr(char * pstr)
{
    char * p = pstr;
    while(*p != '\0')
    {
        if(*p >= 'a' && *p <= 'z')
        {
            *p -= 0x20;
        }
        p++;
    }
    return pstr;
}

void usb_setLunPathByStorageType()
{
    return;
}

int usb_udiskProcFunc(void)
{
    if(strstr((char *)enum_functions, USB_STR_MASSSTORAGE) == NULL)
    {
        if(strlen((const char*)enum_functions) != 0)
        { 
            strcat((char *)enum_functions, ",");
        } 
        strncat((char *)enum_functions, USB_STR_MASSSTORAGE, strlen(USB_STR_MASSSTORAGE));
    }
    
    slog(USBCFGMNG_PRINT,SLOG_DEBUG, "[usbCfgMng]usb_udisProcFunc enum_functions = %s \n",enum_functions);

    usb_setLunPathByStorageType();
    
    usb_UnRegisterUdiskHook();
    return 0;
}

int usb_ParseATCmdSetUdisState(char * pstrAtCmd)
{
    char *pStrAt    = NULL;
    char *pStrValue = NULL;
    int udisState = -1;

    usb_pstrFnStrupr(pstrAtCmd);
	if(*pstrAtCmd == '1')
        {
            //system("echo 1 > /sys/kernel/debug/mmc1/card_simulate_hotplug");
            udisState = 1;
        }
        else if(*pstrAtCmd == '0')
        {
            //system("echo 0 > /sys/kernel/debug/mmc1/card_simulate_hotplug");
            udisState = 0;
        }
	#if 0
    pStrAt = strstr((const char*)pstrAtCmd, "AT+ZUDISKSTAT=");
    
    if(pStrAt != NULL && (pStrAt + strlen("AT+ZUDISKSTAT=") + 1) != NULL)
    {
        pStrValue = pStrAt + strlen("AT+ZUDISKSTAT=");

        if(((*(pStrValue) == '1') && *(pStrValue + 1) == '\r'))
        {
            //system("echo 1 > /sys/kernel/debug/mmc1/card_simulate_hotplug");
            udisState = 1;
        }
        else if(((*(pStrValue ) == '0') && *(pStrValue + 1) == '\r'))
        {
            //system("echo 0 > /sys/kernel/debug/mmc1/card_simulate_hotplug");
            udisState = 0;
        }
    }
    #endif
    return udisState;
}

void usb_sendUdiskStateRlt(int state)
{
    unsigned char dataRst[40] = {0};
    int rtv = -1;
    
    if(state == 1)
    {
        strcat((char *)dataRst,"\r\nOK\r\n");
        slog(USBCFGMNG_PRINT,SLOG_DEBUG, "[usbCfgMng]usb_sendUdiskStateRlt OK state = %d \n",state);
    }
    else
    {
        strcat((char *)dataRst,"\r\nERROR\r\n");
        slog(USBCFGMNG_PRINT,SLOG_DEBUG, "[usbCfgMng]usb_sendUdiskStateRlt ERROR state = %d \n",state);
    }
    
    rtv = usbcfg_send_message(MSG_CMD_UDISKSTAT_SET_RSP, strlen((const char*)dataRst), (CHAR *)dataRst);
    if(rtv < 0)
    {
        slog(USBCFGMNG_PRINT,SLOG_ERR, "[usbCfgMng]usb_sendUdiskStateRlt error rtv =%d\n",rtv);
    }
}

/**********************************************************************************
: ʵöU/жỤܻʹ
***********************************************************************************/
int usbcfg_Handle_Msg_SetUdiskState(void *data)
{
    int usbPlugtype =  1;
    int mmcExist = -1;
    char need_cp_udisk[8] = {0};
    
    sc_cfg_get(NV_NEED_CP_UDISK, need_cp_udisk,sizeof(need_cp_udisk));
    if(strcmp(need_cp_udisk, "yes"))
    {
        slog(USBCFGMNG_PRINT,SLOG_ERR, "[usbCfgMng]usbcfg_Handle_Msg_SetUdiskState not support!\n");
        return 0;
    }

    slog(USBCFGMNG_PRINT,SLOG_DEBUG, "[usbCfgMng]usbcfg_Handle_Msg_SetUdiskState enter \n");
    set_wake_lock(USBCFG_MAIN_LOCK_ID);

    g_usbcfg_udisk_state = usb_ParseATCmdSetUdisState(data);
    
    if(g_usbcfg_udisk_state < 0){/*,ERROR*/
        slog(USBCFGMNG_PRINT,SLOG_ERR, "[usbCfgMng]usbcfg_Handle_Msg_SetUdiskState: g_usbcfg_udisk_state=%d\n", g_usbcfg_udisk_state);
        usb_sendUdiskStateRlt(0);
        set_wake_unlock(USBCFG_MAIN_LOCK_ID);
        return -1;
    }

    if(g_usbcfg_udisk_state == 0)/*UģʽлTģʽ*/
    {
		usbPlugtype = usb_GetUsbPlugState();
		mmcExist = usb_isMmcExist();
        slog(USBCFGMNG_PRINT,SLOG_DEBUG, "[usbCfgMng]usbcfg_Handle_Msg_SetUdiskStateusb switch to tcard Plugtype=%d,mmc:%d\n", usbPlugtype,mmcExist); 

        if(mmcExist > 0){
        	if(usbPlugtype == 1)
       		{
            	usbcfg_getMutex(&g_usbcfg_usbenum_mutex);
            	set_wake_lock(USBCFG_MAIN_LOCK_ID);
            	//Ӻÿ
            	usb_UnRegisterUdiskHook();
            	usb_disable();
            	usb_CfgInfoInit();
            	usb_PlugInProc(usbPlugtype);
            	set_wake_unlock(USBCFG_MAIN_LOCK_ID);
            	usbcfg_putMutex(&g_usbcfg_usbenum_mutex);
        	}       
			usb_sendUdiskStateRlt(1);
	        slog(USBCFGMNG_PRINT,SLOG_DEBUG, "[usbCfgMng]usbcfg_Handle_Msg_SetUdiskState enter tcard state\n");
      }else{
	      	usb_sendUdiskStateRlt(1);
	      	slog(USBCFGMNG_PRINT,SLOG_DEBUG, "[usbCfgMng]usbcfg_Handle_Msg_SetUdiskState mmc is not present\n");
      }
    }else{
        usbPlugtype = usb_GetUsbPlugState();
        slog(USBCFGMNG_PRINT,SLOG_DEBUG, "[usbCfgMng]usbcfg_Handle_Msg_SetUdiskState enter udisk state usbPlugtype = %d\n", usbPlugtype);
        
        if(usbPlugtype <= 0)
        {
            slog(USBCFGMNG_PRINT,SLOG_ERR, "[usbCfgMng]usbcfg_Handle_Msg_SetUdiskState enter udisk state error usb is out\n");
	     usb_sendUdiskStateRlt(0);
        }
        else
        {
            slog(USBCFGMNG_PRINT,SLOG_DEBUG, "[usbCfgMng]sdcard_event_proc  sd add >>>>>>>>enum udisk\n"); 
            usbcfg_getMutex(&g_usbcfg_usbenum_mutex);
            set_wake_lock(USBCFG_MAIN_LOCK_ID);
            //ӹӺ
            usb_RegisterUdiskHook((T_USBCFG_UDISKFunc)usb_udiskProcFunc);
            usb_disable();
            usb_CfgInfoInit();
            usb_PlugInProc(usbPlugtype);
            usb_sendUdiskStateRlt(1);
            set_wake_unlock(USBCFG_MAIN_LOCK_ID);
            usbcfg_putMutex(&g_usbcfg_usbenum_mutex);
        }
    }

    set_wake_unlock(USBCFG_MAIN_LOCK_ID);
    return 0;
}

extern void usb_sendUsbOperateRlt(int state);
/*sdȰβ¼*/
int sd_event_proc(unsigned short sd_msg)
{
    int usbPlugtype =  1;
    int mmcExist = -1;
    

    switch(sd_msg)
    {
    case MSG_CMD_DRV_SD_ADD:
        /*sd*/
        usbPlugtype = usb_GetUsbPlugState();
        mmcExist = usb_isMmcExist();
        
        slog(USBCFGMNG_PRINT,SLOG_DEBUG, "[usbCfgMng]sdcard_event_proc sd add usbPlugtype=%d, mmcExist=%d\n", usbPlugtype, mmcExist); 

        if(usbPlugtype == 1 && mmcExist > 0)
        {
            slog(USBCFGMNG_PRINT,SLOG_DEBUG, "[usbCfgMng]sdcard_event_proc  sd add >>>>>>>>enum udisk\n"); 
            usbcfg_getMutex(&g_usbcfg_usbenum_mutex);
            set_wake_lock(USBCFG_MAIN_LOCK_ID);
            //ӹӺ
            usb_RegisterUdiskHook((T_USBCFG_UDISKFunc)usb_udiskProcFunc);
            usb_disable();
            usb_CfgInfoInit();
            usb_PlugInProc(usbPlugtype);
            usb_sendUdiskStateRlt(1);
            set_wake_unlock(USBCFG_MAIN_LOCK_ID);
            usbcfg_putMutex(&g_usbcfg_usbenum_mutex);
        }else{
        	system("echo 0 > /sys/kernel/debug/mmc1/card_simulate_hotplug");
        }
        break;
    case MSG_CMD_DRV_SD_REMOVE:
        /*sdγ*/
        #if 0
        usbPlugtype = usb_GetUsbPlugState();
        mmcExist = usb_isMmcExist();
        slog(USBCFGMNG_PRINT,SLOG_DEBUG, "[usbCfgMng]sdcard_event_proc sd remove >>>>>>>usbPlugtype=%d, mmcExist=%d\n", usbPlugtype,mmcExist); 

        if(g_usbcfg_udisk_state == 1)//Uʧܣerror
        {
            usb_sendUdiskStateRlt(0);
            slog(USBCFGMNG_PRINT,SLOG_ERR, "[usbCfgMng]sdcard_event_proc sd remove >>>>>>>>>>udisk enum error\n"); 
        }
        else if(mmcExist <= 0)
        {
            if(usbPlugtype == 1)
            {
                usbcfg_getMutex(&g_usbcfg_usbenum_mutex);
                set_wake_lock(USBCFG_MAIN_LOCK_ID);
                //Ӻÿ
                usb_UnRegisterUdiskHook();
                usb_disable();
                usb_CfgInfoInit();
                usb_PlugInProc(usbPlugtype);
                set_wake_unlock(USBCFG_MAIN_LOCK_ID);
                usbcfg_putMutex(&g_usbcfg_usbenum_mutex);
            }
            
            usb_sendUdiskStateRlt(1);
            slog(USBCFGMNG_PRINT,SLOG_DEBUG, "[usbCfgMng]sdcard_event_proc sd remove >>>>>>>>return ok\n"); 
        }
        #endif
        if(g_usbcfg_udisk_state == 0)
        	usb_sendUdiskStateRlt(1);
	else
		usb_sendUdiskStateRlt(0);
        slog(USBCFGMNG_PRINT,SLOG_DEBUG, "[usbCfgMng]sdcard_event_proc sd remove ,udisk_satte:%d\n",g_usbcfg_udisk_state);
        break;
     case MSG_CMD_DRV_SD_OFFLINE:
        /*sdγ*/
        usbPlugtype = usb_GetUsbPlugState();
        mmcExist = usb_isMmcExist();
        slog(USBCFGMNG_PRINT,SLOG_DEBUG, "[usbCfgMng]sdcard_event_proc sd offline >>>>>>>usbPlugtype=%d, mmcExist=%d\n", usbPlugtype,mmcExist); 

        if(mmcExist > 0)
        {
            if(usbPlugtype == 1)
            {
                usbcfg_getMutex(&g_usbcfg_usbenum_mutex);
                set_wake_lock(USBCFG_MAIN_LOCK_ID);
                //Ӻÿ
                usb_UnRegisterUdiskHook();
                usb_disable();
		  system("echo 0 > /sys/kernel/debug/mmc1/card_simulate_hotplug");
		  slog(USBCFGMNG_PRINT,SLOG_DEBUG, "[usbCfgMng]sdcard_event_proc sd offline >>>>>>>>echo 0 > /sys/kernel/debug/mmc1/card_simulate_hotplug\n"); 
                usb_CfgInfoInit();
                usb_PlugInProc(usbPlugtype);
		  usb_sendUsbOperateRlt(3);
                set_wake_unlock(USBCFG_MAIN_LOCK_ID);
                usbcfg_putMutex(&g_usbcfg_usbenum_mutex);
            }

            slog(USBCFGMNG_PRINT,SLOG_DEBUG, "[usbCfgMng]sdcard_event_proc sd offline >>>>>>>>return ok\n"); 
        }
        break;
    default:
        break;
    }
    
    return 0;
}

/*sdȰβ¼,2G Flash汾ʵ*/
int vsd_event_proc(unsigned short vsd_msg)
{
    switch(vsd_msg)
    {
    case MSG_CMD_DRV_VSD_ADD:
    case MSG_CMD_DRV_VSD_REMOVE:
	case MSG_CMD_DRV_VSD_OFFLINE:
    default:
        break;
    }

    return 0;
}

#if 0

/*sdcardȰβʼ*/
void sdcard_hotplug_init()
{
    hotplug_parse_register(DEV_TYPE_SDCARD, sdcard_msg_parse);
    hotplug_proc_register(DEV_TYPE_SDCARD, sdcard_event_proc);
}

/*sdcardȰβʼ*/
void virtual_sdcard_hotplug_init()
{
    hotplug_parse_register(DEV_TYPE_VIRTUAL_SDCARD, virtual_sdcard_msg_parse);
    hotplug_proc_register(DEV_TYPE_VIRTUAL_SDCARD, virtual_sdcard_event_proc);
}
#endif

