/**
 * @file at_netdog.h
 * @brief at_ctlļأ漰ͨϽܺͷĴ洢ϢĴ
 *        ԼӡlogϢĽӿ
 *
 * Copyright (C) 2017 Sanechips Technology Co., Ltd.
 * @author 
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation. 
 *
 */

#ifndef __AT_NETDOG_H__
#define __AT_NETDOG_H__

/*******************************************************************************
 *                           Include header files                              *
 ******************************************************************************/
#include "softap_api.h"
/*******************************************************************************
 *                             Macro definitions                               *
 ******************************************************************************/
#define AT_NETDOG_ARRAY_MAX  30  //at netdogʱ洢AT
#define AT_MONITOR_ARRAY_MAX 30
#define AT_NETDOG_AT_CMD_MAX  25  //at netdogʱ洢ATǰnֽ
#define AT_ABORT_ARRAY_MAX 10
#define AT_NOIDLE_ARRAY_MAX 100

static unsigned long long soctime_us = 0;

#define AT_ERR    SLOG_ERR    //logС
#define AT_NORMAL SLOG_NORMAL    //ɲԽ׶log
#define AT_DEBUG  SLOG_DEBUG    //зΪlogܴ
//#define AT_EXT    8

#define SOCTIME_LOG_OFF	0
#define SOCTIME_LOG_ON		1

#if (APP_OS_TYPE == APP_OS_LINUX)
#define at_print(LEVEL,...) slog(AT_PRINT,LEVEL ,__VA_ARGS__)
/*
#define at_print(LEVEL,...) do { \					        
	                            if ( LEVEL == AT_ERR) {\
								slog(AT_PRINT,SLOG_ERR,__VA_ARGS__); \
								}\
								else if(LEVEL == AT_NORMAL) { \
								slog(AT_PRINT,SLOG_NORMAL,__VA_ARGS__); \
								}\
								else if(LEVEL == AT_DEBUG){ \
								slog(AT_PRINT,SLOG_DEBUG,__VA_ARGS__); \
								} \	
								else{\
								}\
                            } while(0)*/
#elif (APP_OS_TYPE == APP_OS_TOS)
#define at_print(LEVEL,...) do { \
							soctime_us = read_persistent_us(); \
							if(LEVEL == AT_ERR) { \
								if(SOCTIME_LOG_ON == soctime_switch) { \
									zOss_Printf(SUBMDL_TEST, PRINT_LEVEL_ABNORMAL, "[%llu.%llus]\n", soctime_us/1000000, soctime_us%1000000); } \	
								zOss_Printf(SUBMDL_TEST, PRINT_LEVEL_ABNORMAL, __VA_ARGS__); } \
							else if(LEVEL == AT_DEBUG) { \
								if(SOCTIME_LOG_ON == soctime_switch) { \
									zOss_Printf(SUBMDL_TEST, PRINT_LEVEL_DEBUG, "[%llu.%llus]\n", soctime_us/1000000, soctime_us%1000000); } \	
								zOss_Printf(SUBMDL_TEST, PRINT_LEVEL_DEBUG, __VA_ARGS__); } \
							else if(LEVEL == AT_NORMAL) { \
								if(SOCTIME_LOG_ON == soctime_switch) { \
									zOss_Printf(SUBMDL_TEST, PRINT_LEVEL_NORMAL, "[%llu.%llus]\n", soctime_us/1000000, soctime_us%1000000); } \	
								zOss_Printf(SUBMDL_TEST, PRINT_LEVEL_NORMAL, __VA_ARGS__); } \
							else { \
								if(SOCTIME_LOG_ON == soctime_switch) { \
									zOss_Printf(SUBMDL_TEST, PRINT_LEVEL_SEVERE, "[%llu.%llus]\n", soctime_us/1000000, soctime_us%1000000); } \	
								zOss_Printf(SUBMDL_TEST, PRINT_LEVEL_SEVERE, __VA_ARGS__); }\
                            } while(0)
#define softap_assert(...) do { zOss_Printf(SUBMDL_TEST, PRINT_LEVEL_ABNORMAL, __VA_ARGS__); \
                            zOss_ASSERT(!(__VA_ARGS__)); \
                            } while(0)
#endif 
/*******************************************************************************
 *                             Type definitions                                *
 ******************************************************************************/
struct at_read_info
{
    char read_buf[AT_NETDOG_AT_CMD_MAX+1];
    int  read_len;
    unsigned long cur_read_tick;
};

struct at_write_info
{
    char write_buf[AT_NETDOG_AT_CMD_MAX+1];
    int  write_len;
    unsigned long cur_write_tick;
};

struct at_monitor_info
{
    struct at_read_info read_info[AT_MONITOR_ARRAY_MAX];
    struct at_write_info write_info[AT_MONITOR_ARRAY_MAX];
    int monitor_read_count_num;//¼صĶ
    int monitor_write_count_num;//¼صд
};

struct at_netdog_info
{
    unsigned long cur_tick;//ӿǰtickֵ
    char partial_cmd[AT_NETDOG_AT_CMD_MAX+1];//洢յǰAT_NETDOG_AT_CMD_MAXֽ
};

typedef enum at_time_type
{
    AT_SEND_TYPE=0,
    AT_RECV_TYPE
}AT_TIME_TYPE;


struct	at_context;

struct at_debug_stat {
	int rcv_undesirable_rsp;	//ڵȴrspʱͷĺյrsp룬ý룬send_req_and_waitʹó
	int wait_farps_rsp_timeout; //ⲿMCU,ʱûյӦ
	int channel_info_null;      //Ȳfdchannel_infoʧ
	int farps_cmd_err;      	//FARPSյĲȷAT
	int farps_cmd_again;   	 	//FARPSһûյӦʱַһ
	int wait_farps_end_timeout; //ⲿȴ/rʱ
	int multicore_write_err;    //˼䷢ʧ
	int ip_package_err;         //ݰ
	int dbg_uart_zero_chr_num;       //յа\0
	int dbg_uart_no_print_num;      //յаɴӡַ
};
extern struct at_debug_stat at_netdog;

#define NETDOG_AT_STATICS(a) do { \
								((&at_netdog)->a); \
								} while(0)

/*******************************************************************************
 *                        Global variable definitions                          *
 ******************************************************************************/
 extern int soctime_switch;

/*******************************************************************************
 *                       Global function declarations                          *
 ******************************************************************************/
/**
 * @brief ָpositionĽڵĵǰʱ
 * @param 
 * @return 
 * @note   ͻȡͨʱ޷ȡͨϢ
 * @warning 
 */
void save_noidle_fd(int position);
/**
 * @brief ͬһģ鷢һ(ȡ)Ϣ
 * @param 
 * @return 
 * @note   
 * @warning 
 */
void save_abort_client_context(struct at_context *context);
/**
 * @brief ӡרãֹӡԽ磬ֻǰ19ֽ
 * @param 
 * @return 
 * @note   
 * @warning 
 */
char *get_small_str(const char *buff);
/**
 * @brief ָATǰ׺ATϢм
 * @param 
 * @return 
 * @note  ԸȤATмأȤinterested_at_cmdУ
          ʷ¼ΪAT_NETDOG_ARRAY_MAX,at_netdog_flagλΪ1ʱʾ򿪴˹
 * @warning 
 */
int at_netdog_monitor(int fd, char *data, char *at_prefix);
/**
 * @brief д뵽ͨͨATм
 * @param 
 * @return 
 * @note  ʷ¼дͶΪAT_MONITOR_ARRAY_MAXat_netdog_flagελΪ1ʱʾ򿪴˹
 * @warning 
 */
int save_monitor_at_buf(int fd, char *buf,int len, AT_TIME_TYPE time_type);
/**
 * @brief ͨϢϢĴӡ
 * @param 
 * @return 
 * @note   
 * @warning 
 */
void at_channel_context_print(void);
/**
 * @brief ʼatͨ״̬Ϣӡ
 * @param 
 * @return 
 * @note   
 * @warning 
 */
void at_debug_init(void);

//ͨ豸fdĶӦϢ
void channel_info_print();

enum atctltest_branch_t
{
	AT_TEST_BUSY=0 ,//ͨæģ⣬ӦATERR_CHANNEL_BUSY
	AT_TEST_MEM_LESS,//ϵͳڴ治㣬ӦATERR_MEM_LESS
	AT_TEST_NOT_ALLOWED,//PDPأӦATERR_NOT_ALLOWED
	
};

//ȡatctlеĹؼ֧ĵȫλͼǷãatctlڲ,ýӿΪset_test_bitmap
int check_test_bitmap(int test_flag);

#endif
